/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.controller.Block$;
import kafka.controller.Continue$;
import kafka.controller.ContinueMerged$;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u0004.\u0001\u0001\u0006IA\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0011\u0019Y\u0004\u0001)A\u0005a!9A\b\u0001b\u0001\n\u0003y\u0003BB\u001f\u0001A\u0003%\u0001\u0007C\u0004?\u0001\t\u0007I\u0011A\u0018\t\r}\u0002\u0001\u0015!\u00031\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015\u0001\u0006\u0001\"\u0001B\u0011\u0015\u0011\u0006\u0001\"\u0001B\u0011\u0015!\u0006\u0001\"\u0001B\u0011\u00151\u0006\u0001\"\u0001B\u0011\u0015A\u0006\u0001\"\u0001B\u0011\u0015Q\u0006\u0001\"\u0001B\u0011\u0015a\u0006\u0001\"\u0001B\u0011\u0015q\u0006\u0001\"\u0001B\u0011\u0015\u0001\u0007\u0001\"\u0001B\u0011\u0015\u0011\u0007\u0001\"\u0001B\u0011\u0015\u0011\u0007\u0001\"\u0001e\u0011\u0015Q\u0007\u0001\"\u0001l\u0005UaU-\u00193fe\u0006sG-S:s\u0005\u0006$8\r\u001b+fgRT!!\u0007\u000e\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\t\u0001$A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\u0012A\u000b\t\u0003O-J!\u0001\f\r\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013!\u0002(pI\u0016\u0004T#\u0001\u0019\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u001ck)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ$G\u0001\u0003O_\u0012,\u0017A\u0002(pI\u0016\u0004\u0004%A\u0003O_\u0012,\u0017'\u0001\u0004O_\u0012,\u0017\u0007I\u0001\u0006\u001d>$WMM\u0001\u0007\u001d>$WM\r\u0011\u0002'Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\\:\u0015\u0003\t\u0003\"aH\"\n\u0005\u0011\u0003#\u0001B+oSRD#A\u0003$\u0011\u0005\u001dsU\"\u0001%\u000b\u0005%S\u0015aA1qS*\u00111\nT\u0001\bUV\u0004\u0018\u000e^3s\u0015\tiu'A\u0003kk:LG/\u0003\u0002P\u0011\n!A+Z:u\u00039!Xm\u001d;BI\u0012$v\u000e]5d\u0013\u0012D#a\u0003$\u0002+Q,7\u000f^!eIB\u000b'\u000f^5uS>t7\u000b^1uK\"\u0012ABR\u0001\u001di\u0016\u001cH/\u00138wC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fQ\tia)\u0001\u0011uKN$\bK]8dKN\u001cx+\u001b;i\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\"bi\u000eD\u0007F\u0001\bG\u0003q\"Xm\u001d;Qe>\u001cWm]:XSRDG*Z1eKJ\fe\u000eZ%te\n\u000bGo\u00195XQ\u0016t')\u0019;dQ\u000e{g\u000e^1j]N\fE\u000e\u001c*fa2L7-Y:)\u0005=1\u0015a\b;fgR\u0004&o\\2fgN<\u0016\u000e\u001e5Ti>\u0004(+\u001a9mS\u000e\f')\u0019;dQ\"\u0012\u0001CR\u0001<i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8oV5uQN#x\u000e\u001d*fa2L7-\u0019\"bi\u000eDw\u000b[3o\u0005\u0006$8\r[\"p]R\f\u0017N\\:BY2\u0014V\r\u001d7jG\u0006\u001c\bFA\tG\u0003\t\"Xm\u001d;Qe>\u001cWm]:XSRDW\u000b\u001d3bi\u0016lU\r^1eCR\f')\u0019;dQ\"\u0012!CR\u0001#i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8oV5uQ&s7m\u001c8tSN$XM\u001c;U_BL7-\u00133)\u0005M1\u0015!\u0005;fgR\u0014U/\u001b7e%\u0016\fX/Z:ug\"\u0012AC\u0012\u000b\u0003\u0005\u0016DQAZ\u000bA\u0002\u001d\fqA^3sg&|g\u000e\u0005\u0002 Q&\u0011\u0011\u000e\t\u0002\u0006'\"|'\u000f^\u0001\u0013[\u0006\\W\rU1si&$\u0018n\u001c8Ti\u0006$X\rF\u0005m\u0003\u000b\ty!!\u0007\u0002\u001eA\u0011Qn \b\u0003]rt!a\u001c>\u000f\u0005ALhBA9y\u001d\t\u0011xO\u0004\u0002tm6\tAO\u0003\u0002v9\u00051AH]8pizJ\u0011\u0001O\u0005\u0003m]J!aG\u001b\n\u0005M\"\u0014BA>3\u0003\u001diWm]:bO\u0016L!! @\u0002/1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;ECR\f'BA>3\u0013\u0011\t\t!a\u0001\u000351+\u0017\rZ3s\u0003:$\u0017j\u001d:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\u0005ut\bbBA\u0004-\u0001\u0007\u0011\u0011B\u0001\u0003iB\u00042!MA\u0006\u0013\r\tiA\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\tB\u0006a\u0001\u0003'\ta\u0001\\3bI\u0016\u0014\bcA\u0010\u0002\u0016%\u0019\u0011q\u0003\u0011\u0003\u0007%sG\u000fC\u0004\u0002\u001cY\u0001\r!a\u0005\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0003?1\u0002\u0019AA\u0011\u0003\u0015I7OT3x!\ry\u00121E\u0005\u0004\u0003K\u0001#a\u0002\"p_2,\u0017M\u001c")
public class LeaderAndIsrBatchTest {
    private final StateChangeLogger stateChangeLogger = new StateChangeLogger(0, true, (Option)None$.MODULE$);
    private final Node Node0 = new Node(0, "", 9090);
    private final Node Node1 = new Node(1, "", 9091);
    private final Node Node2 = new Node(2, "", 9092);

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Node Node0() {
        return this.Node0;
    }

    public Node Node1() {
        return this.Node1;
    }

    public Node Node2() {
        return this.Node2;
    }

    @Test
    public void testBasicOperations() {
        LeaderAndIsrBatch batch = new LeaderAndIsrBatch(0);
        Assertions.assertEquals((short)ApiKeys.LEADER_AND_ISR.latestVersion(), (short)batch.version());
        Assertions.assertEquals((int)0, (int)batch.controllerId());
        Assertions.assertEquals((int)0, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)0L, (long)batch.brokerEpoch());
        Assertions.assertTrue((boolean)batch.partitions().isEmpty());
        Assertions.assertTrue((boolean)batch.liveLeaders().isEmpty());
        Assertions.assertFalse((boolean)batch.containsAllReplicas());
        Assertions.assertTrue((boolean)batch.isEmpty());
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState tpState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeader(0).setLeaderEpoch(1).setIsNew(false);
        batch.setVersion(ApiKeys.LEADER_AND_ISR.oldestVersion()).setControllerId(1).setControllerEpoch(2).setBrokerEpoch(3L).addPartitionState(tp, tpState).addTopicId(tp.topic(), topicId).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0()}))).addLiveLeader(this.Node1()).setContainsAllReplicas();
        Assertions.assertEquals((short)ApiKeys.STOP_REPLICA.oldestVersion(), (short)batch.version());
        Assertions.assertEquals((int)1, (int)batch.controllerId());
        Assertions.assertEquals((int)2, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)3L, (long)batch.brokerEpoch());
        Assertions.assertFalse((boolean)batch.partitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)tpState)})), (Object)batch.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicId)})), (Object)batch.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0(), this.Node1()})), (Object)batch.liveLeaders());
        Assertions.assertTrue((boolean)batch.containsAllReplicas());
        Assertions.assertFalse((boolean)batch.isEmpty());
    }

    @Test
    public void testAddTopicId() {
        LeaderAndIsrBatch batch = new LeaderAndIsrBatch(0);
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        String topic = "topic";
        batch.addTopicId(topic, topicId0);
        batch.addTopicId(topic, topicId0);
        Assertions.assertThrows(IllegalStateException.class, () -> batch.addTopicId(topic, topicId1));
    }

    @Test
    public void testAddPartitionState() {
        LeaderAndIsrBatch batch = new LeaderAndIsrBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0, false));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0, true));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 1, true));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)1, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertTrue((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 2, false));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)2, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertTrue((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
    }

    @Test
    public void testInvalidatePartitionState() {
        LeaderAndIsrBatch batch = new LeaderAndIsrBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 5, false));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.maybeInvalidatePartitionState(tp, 4);
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.maybeInvalidatePartitionState(tp, 5);
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.maybeInvalidatePartitionState(tp, 6);
        Assertions.assertNull((Object)batch.partitions().get((Object)tp).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 5, false));
        Assertions.assertEquals((int)0, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)batch.partitions().apply((Object)tp)).isNew());
        batch.maybeInvalidatePartitionState(tp, LeaderAndIsr$.MODULE$.EpochDuringDelete());
        Assertions.assertNull((Object)batch.partitions().get((Object)tp).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testProcessWithLeaderAndIsrBatch() {
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        LeaderAndIsrBatch batch1 = new LeaderAndIsrBatch(0).setVersion((short)(ApiKeys.LEADER_AND_ISR.latestVersion() - 1)).setControllerId(0).setControllerEpoch(0).setBrokerEpoch(0L).addPartitionState(tp0, this.makePartitionState(tp0, 0, 1, false)).addTopicId(tp0.topic(), topicId0).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0()})));
        LeaderAndIsrBatch batch2 = new LeaderAndIsrBatch(0).setVersion(ApiKeys.LEADER_AND_ISR.latestVersion()).setControllerId(1).setControllerEpoch(1).setBrokerEpoch(1L).addPartitionState(tp0, this.makePartitionState(tp0, 1, 2, true)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 1, false)).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node1()})));
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertEquals((short)ApiKeys.LEADER_AND_ISR.latestVersion(), (short)batch1.version());
        Assertions.assertEquals((int)1, (int)batch1.controllerId());
        Assertions.assertEquals((int)1, (int)batch1.controllerEpoch());
        Assertions.assertEquals((long)1L, (long)batch1.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(tp0, 1, 2, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(tp1, 1, 1, false))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)batch1.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0(), this.Node1()})), (Object)batch1.liveLeaders());
    }

    @Test
    public void testProcessWithLeaderAndIsrBatchWhenBatchContainsAllReplicas() {
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)new LeaderAndIsrBatch(0).setContainsAllReplicas().process((ControlMetadataBatch)new LeaderAndIsrBatch(0)));
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)new LeaderAndIsrBatch(0).setContainsAllReplicas().process((ControlMetadataBatch)new LeaderAndIsrBatch(0).setContainsAllReplicas()));
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        TopicPartition tp2 = new TopicPartition("topic-2", 2);
        LeaderAndIsrBatch batch1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, this.makePartitionState(tp0, 0, 1, false)).addTopicId(tp0.topic(), topicId0).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0()})));
        LeaderAndIsrBatch batch2 = new LeaderAndIsrBatch(0).setContainsAllReplicas().addPartitionState(tp1, this.makePartitionState(tp1, 1, 1, false)).addPartitionState(tp2, this.makePartitionState(tp2, 2, 1, false)).addTopicId(tp1.topic(), topicId1).addTopicId(tp2.topic(), topicId2).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node1(), this.Node2()})));
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertTrue((boolean)batch1.containsAllReplicas());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(tp1, 1, 1, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)this.makePartitionState(tp2, 2, 1, false))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)})), (Object)batch1.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node1(), this.Node2()})), (Object)batch1.liveLeaders());
    }

    @Test
    public void testProcessWithStopReplicaBatch() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 2);
        LeaderAndIsrBatch leaderAndIsrBatch = new LeaderAndIsrBatch(0).addPartitionState(tp0, this.makePartitionState(tp0, 0, 2, true)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 3, false)).addPartitionState(tp2, this.makePartitionState(tp2, 2, 4, false));
        StopReplicaBatch stopReplicaBatch = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(3)).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(LeaderAndIsr$.MODULE$.EpochDuringDelete()));
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)leaderAndIsrBatch.process((ControlMetadataBatch)stopReplicaBatch));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)this.makePartitionState(tp2, 2, 4, false))})), (Object)leaderAndIsrBatch.partitions());
    }

    @Test
    public void testProcessWithStopReplicaBatchWhenBatchContainsAllReplicas() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new LeaderAndIsrBatch(0).setContainsAllReplicas().process((ControlMetadataBatch)new StopReplicaBatch(0)));
    }

    @Test
    public void testProcessWithUpdateMetadataBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new LeaderAndIsrBatch(0).process((ControlMetadataBatch)new UpdateMetadataBatch(0)));
    }

    @Test
    public void testProcessWithInconsistentTopicId() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid())));
    }

    @Test
    public void testBuildRequests() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LEADER_AND_ISR.oldestVersion()), (int)ApiKeys.LEADER_AND_ISR.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> this.testBuildRequests((short)version));
    }

    public void testBuildRequests(short version) {
        int controllerId = 0;
        int controllerEpoch = 1;
        int brokerEpoch = 2;
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState state0 = this.makePartitionState(tp0, 0, 2, true);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState state1 = this.makePartitionState(tp1, 1, 3, false);
        Seq requests = new LeaderAndIsrBatch(0).setVersion(version).setControllerId(controllerId).setControllerEpoch(controllerEpoch).setBrokerEpoch((long)brokerEpoch).addPartitionState(tp0, state0).addPartitionState(tp1, state1).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).addLiveLeaders((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.Node0(), this.Node1(), this.Node2()}))).requests(this.stateChangeLogger());
        Assertions.assertEquals((int)1, (int)requests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)((AbstractRequest.Builder)requests.head()).build();
        Assertions.assertEquals((short)version, (short)leaderAndIsrRequest.version());
        Assertions.assertEquals((int)controllerId, (int)leaderAndIsrRequest.controllerId());
        Assertions.assertEquals((int)controllerEpoch, (int)leaderAndIsrRequest.controllerEpoch());
        Assertions.assertEquals((long)brokerEpoch, (long)leaderAndIsrRequest.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{state0, state1})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(leaderAndIsrRequest.partitionStates()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.Node0().id(), this.Node1().id()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(leaderAndIsrRequest.liveLeaders()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()))).toSet());
        if (version >= 2) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(leaderAndIsrRequest.topicIds()).asScala());
            return;
        }
    }

    public LeaderAndIsrRequestData.LeaderAndIsrPartitionState makePartitionState(TopicPartition tp, int leader, int leaderEpoch, boolean isNew) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsNew(isNew);
    }
}

