/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!C\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011\u0002'\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0006\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\"I1\r\u0001a\u0001\u0002\u0003\u0006KA\u0017\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00026\t\u00131\u0004\u0001\u0019!A!B\u00131\u0007\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003o\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005v\u0001\u0001\u0007\t\u0011)Q\u0005_\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005%\u0001\u0001)A\u0005}\"A\u00111\u0002\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0005\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA \u0001\u0001\u0006I!a\f\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003s\u0002A\u0011AA\"\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u0007Bq!a\"\u0001\t\u0003\t\u0019\u0005C\u0004\u0002\f\u0002!\t!a\u0011\t\u000f\u0005=\u0005\u0001\"\u0001\u0002D!9\u00111\u0013\u0001\u0005\u0002\u0005\r\u0003bBAL\u0001\u0011\u0005\u00111\t\u0005\b\u00037\u0003A\u0011AA\"\u0011\u001d\ty\n\u0001C\u0001\u0003\u0007Bq!a)\u0001\t\u0003\t\u0019\u0005C\u0004\u0002(\u0002!\t!a\u0011\t\u000f\u0005-\u0006\u0001\"\u0001\u0002D!9\u0011q\u0016\u0001\u0005\u0002\u0005\r\u0003bBAZ\u0001\u0011\u0005\u00111\t\u0005\b\u0003o\u0003A\u0011AA\"\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!<\u0001\t\u0003\t\u0019\u0005C\u0004\u0002r\u0002!\t!a\u0011\t\u000f\u0005U\b\u0001\"\u0001\u0002D!9\u0011\u0011 \u0001\u0005\u0002\u0005\r\u0003bBA\u007f\u0001\u0011\u0005\u00111\t\u0005\b\u0005\u0003\u0001A\u0011AA\"\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u0007BqA!\u0003\u0001\t\u0003\t\u0019\u0005C\u0004\u0003\u000e\u0001!IAa\u0004\t\u000f\t%\u0002\u0001\"\u0001\u0002D!9!Q\u0006\u0001\u0005\u0002\u0005\r\u0003b\u0002B\u0019\u0001\u0011\u0005\u00111\t\u0005\b\u0005k\u0001A\u0011AA\"\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003\u0007BqA!\u0010\u0001\t\u0013\u0011yDA\rQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3UKN$(B\u0001\u001f>\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002}\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001B!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0013\t\u0003\u0015\u0002i\u0011aO\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A'\u0011\u0005)s\u0015BA(<\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\t\u0011V\u000b\u0005\u0002C'&\u0011Ak\u0011\u0002\u0005+:LG\u000fC\u0004W\u0007\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013\u0001D7pG.T6n\u00117jK:$X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0014A\u0001>l\u0013\tyFLA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0011[>\u001c7NW6DY&,g\u000e^0%KF$\"A\u00152\t\u000fY3\u0011\u0011!a\u00015\u0006iQn\\2l5.\u001cE.[3oi\u0002\n\u0001%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQV\ta\r\u0005\u0002KO&\u0011\u0001n\u000f\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0011jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195`I\u0015\fHC\u0001*l\u0011\u001d1\u0016\"!AA\u0002\u0019\f\u0011%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002\nQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-F\u0001p!\tQ\u0005/\u0003\u0002rw\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0017!\u00079beRLG/[8o'R\fG/Z'bG\"Lg.Z0%KF$\"A\u0015;\t\u000fYc\u0011\u0011!a\u0001_\u00061\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007%\u0001\u0005ce>\\WM]%e+\u0005A\bC\u0001\"z\u0013\tQ8IA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r\r|gNZ5h+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0014AB:feZ,'/\u0003\u0003\u0002\b\u0005\u0005!aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u00111\u0003\t\u0005\u0003+\t)#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0019\u0019w.\\7p]*\u0019a(!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0012aA8sO&!\u0011qEA\f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003_\u0001b!!\r\u0002<\u0005MQBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013%lW.\u001e;bE2,'bAA\u001d\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0004'\u0016\f\u0018a\u00039beRLG/[8og\u0002\nQa]3u+B$\u0012A\u0015\u0015\u00041\u0005\u001d\u0003\u0003BA%\u0003/j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0004CBL'\u0002BA)\u0003'\nqA[;qSR,'O\u0003\u0003\u0002V\u0005\u0005\u0012!\u00026v]&$\u0018\u0002BA-\u0003\u0017\u0012!BQ3g_J,W)Y2i\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016$B!a\u0018\u0002fA\u0019!*!\u0019\n\u0007\u0005\r4H\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\u0005=\u0011\u00041\u0001\u0002\u0014\u00059\u0002/\u0019:uSRLwN\u001c'fC\u0012,'o\u001d5ja&sgm\u001c\u000b\u0005\u0003W\n9\bE\u0003C\u0003[\n\t(C\u0002\u0002p\r\u0013aa\u00149uS>t\u0007c\u0001&\u0002t%\u0019\u0011QO\u001e\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\tyA\u0007a\u0001\u0003'\t\u0001\u0007^3ti:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)>tUm\u001e)beRLG/[8o)J\fgn]5uS>t\u0007fA\u000e\u0002~A!\u0011\u0011JA@\u0013\u0011\t\t)a\u0013\u0003\tQ+7\u000f^\u0001;i\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3\u0001HA?\u0003m\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004;\u0005u\u0014a\u000b;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007y\ti(A*uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o5>|7*Z3qKJ\u001cE.[3oi\u0016C8-\u001a9uS>tgI]8n\u0007J,\u0017\r^3Ti\u0006$Xm\u001d\u0015\u0004?\u0005u\u0014\u0001\u0012;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8FeJ|'oQ8eK\u001a\u0013x.\\\"sK\u0006$Xm\u0015;bi\u0016\u001c\bf\u0001\u0011\u0002~\u0005aC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005u\u0014a\u000e;fgRLeN^1mS\u0012tUm\u001e)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002#\u0003{\nQ\u0005^3ti>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,GK]1og&$\u0018n\u001c8)\u0007\r\ni(\u0001\u001euKN$xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a+sC:\u001c\u0018\u000e^5p]\u001a{'oQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001aA%! \u0002MQ,7\u000f^(oY&tW\rU1si&$\u0018n\u001c8U_>3g\r\\5oKR\u0013\u0018M\\:ji&|g\u000eK\u0002&\u0003{\n!\b^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0019\ni(\u0001\u001auKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8OK^\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r9\u0013QP\u00010i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004Q\u0005u\u0014A\u000f;fgR$UmY8eKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3[\u001d>$WmV5uQ>,H/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014h\t\\1hQ\rI\u0013QP\u00017i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_Vs7\r\\3b]>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u000b\u0004%\u0006}\u0006bBAaU\u0001\u0007\u00111Y\u0001\u001aSNdU-\u00193feJ+7m\u001c<fef\u001cV\u000f\u001d9peR,G\rE\u0002C\u0003\u000bL1!a2D\u0005\u001d\u0011un\u001c7fC:D3AKAf!\u0011\ti-a5\u000e\u0005\u0005='\u0002BAi\u0003\u001f\na\u0001]1sC6\u001c\u0018\u0002BAk\u0003\u001f\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001dQ\u0013\u0011\\As\u0003O\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0005\u0003?\fy-\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t\u0019/!8\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011\u0011^Av3\u0005\t\u0011$\u0001\u0001\u0002{Q,7\u000f^+oG2,\u0017M\\(gM2Lg.\u001a)beRLG/[8o)>,fn\u00197fC:|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007-\ni(\u0001\u001cuKN$XK\\2mK\u0006twJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002-\u0003{\n\u0011\n^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:<\u0016\u000e\u001e5V]\u000edW-\u00198FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\ri\u0013QP\u0001%i\u0016\u001cHO\u0011:pW\u0016\u0014(i\\;oG\u0016\fe\r^3s+:\u001cG.Z1o\u000b2,7\r^5p]\"\u001aa&! \u0002-R,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u\u000bb\u001cW\r\u001d;j_:4%o\\7Ti\u0006$X\rT8pWV\u0004\bfA\u0018\u0002~\u00059E/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\u0016\u0013(o\u001c:D_\u0012,gI]8n'R\fG/\u001a'p_.,\b\u000fK\u00021\u0003{\nA\u0007^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r\t\u0014QP\u00014i\u0016\u001cH/\u00138wC2LGm\u00144gY&tW\rU1si&$\u0018n\u001c8U_:+w\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3AMA?\u0003\u0015\u0002(/\u001a9be\u0016lunY6U_\u0016cWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002S\u0005#Aq!a\u000b4\u0001\u0004\u0011\u0019\u0002\u0005\u0004\u0003\u0016\t\u0015\u00121\u0003\b\u0005\u0005/\u0011\tC\u0004\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\r\u0011ibP\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K1Aa\tD\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0003()\u0019!1E\"\u0002EQ,7\u000f^+qI\u0006$\u0018N\\4PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]N\u001cu.\u001e8uQ\r!\u0014QP\u00013i\u0016\u001cHOT8PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]N\u001c\u0005.\u00198hK\u001a{'\u000fV8qS\u000e\u001c()Z5oO\u0012+G.\u001a;fI\"\u001aQ'! \u0002kQ,7\u000f^+qI\u0006$\u0018N\\4PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]N\u001cu.\u001e8u\tV\u0014\u0018N\\4U_BL7\rR3mKRLwN\u001c\u0015\u0004m\u0005u\u0014!\u0010;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8XSRDG)Z7pi\u0016$'I]8lKJ\u001c\bfA\u001c\u0002~\u00059D/Z:u\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016$&/\u00198tSRLwN\\,ji\"$U-\\8uK\u0012\u0014%o\\6feND3\u0001OA?\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0005\u0005\u0003\u00129\u0005E\u0002K\u0005\u0007J1A!\u0012<\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\b\u0005\u0013J\u0004\u0019\u0001B&\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#\u0002B\u000b\u0005KA\b")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext;
    private KafkaZkClient mockZkClient;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch;
    private PartitionStateMachine partitionStateMachine;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final scala.collection.immutable.Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new Metrics(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    private Option<LeaderIsrAndControllerEpoch> partitionLeadershipInfo(TopicPartition partition) {
        return this.controllerContext().partitionLeadershipInfo(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenThrow(new Throwable[]{new ZooKeeperClientException("test")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        objectArray[1] = TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getTopicConfigOverrides(Predef$.MODULE$.Set().empty())).thenReturn((Object)new Tuple2(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)new Properties())})), Map$.MODULE$.empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicConfigOverrides((scala.collection.immutable.Set)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testDecodeTopicPartitionStateZNodeWithoutUncleanLeaderFlag() {
        byte[] zNodeData = Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.InitialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava())}))).asJava());
        Stat zNodeDataStat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(zNodeData, zNodeDataStat, this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), LeaderRecoveryState.RECOVERED, LeaderAndIsr$.MODULE$.InitialLeaderEpoch(), this.controllerEpoch());
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.InitialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_is_unclean_leader"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))).asJava()), zNodeDataStat, this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.InitialLeaderEpoch(), this.controllerEpoch());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOfflinePartitionToUncleanOnlinePartitionTransition(boolean isLeaderRecoverySupported) {
        MetadataVersion metadataVersion = isLeaderRecoverySupported ? MetadataVersion.IBP_2_4_IV1 : MetadataVersion.IBP_2_4_IV0;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        if (metadataVersion == null) {
            throw null;
        }
        properties.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), metadataVersion.version());
        ZkPartitionStateMachine partitionStateMachine = new ZkPartitionStateMachine(KafkaConfig$.MODULE$.fromProps(properties), new Metrics(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch());
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = isLeaderRecoverySupported ? leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))) : leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        partitionStateMachine.handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToUncleanOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, LeaderAndIsr$.MODULE$.InitialLeaderEpoch(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.InitialPartitionEpoch(), (Option)None$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, LeaderAndIsr$.MODULE$.InitialLeaderEpoch(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.InitialPartitionEpoch(), (Option)None$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionWithUncleanElectionEnabled() {
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testBrokerBounceAfterUncleanElection() {
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr qual$1 = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        int x$2 = qual$1.copy$default$1();
        int x$3 = qual$1.copy$default$2();
        List x$4 = qual$1.copy$default$4();
        int x$5 = qual$1.copy$default$5();
        Option x$6 = qual$1.copy$default$6();
        LeaderAndIsr leaderAndIsr = qual$1.copy(x$2, x$3, LeaderRecoveryState.RECOVERING, x$4, x$5, x$6);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.empty());
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch(), (VerificationMode)Mockito.times((int)2))).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch(), (VerificationMode)Mockito.times((int)2))).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenThrow(new Throwable[]{new ZooKeeperClientException("")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$5 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$5)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((scala.collection.immutable.Seq<TopicPartition>)partitions);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$6 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$6)));
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$7 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$7)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient, (Option)None$.MODULE$, (Option)None$.MODULE$);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionWithDemotedBrokers() {
        int otherBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        objectArray[1] = TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().setDegradedBrokerComponent(this.brokerId(), ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("demoted broker for test", BrokerComponent.UNSPECIFIED.id()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(otherBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
        Assertions.assertNotEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)this.brokerId());
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionWithDemotedBrokers() {
        int otherBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        objectArray[1] = TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().setDegradedBrokerComponent(this.brokerId(), ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("demoted broker for test", BrokerComponent.UNSPECIFIED.id()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)package$.MODULE$.Seq().empty()));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(otherBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().empty()));
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)newLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)newLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        Assertions.assertEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)otherBrokerId);
        this.controllerContext().setDegradedBrokerComponent(this.brokerId(), ComponentHealthStatus.HEALTHY, new DegradedBrokerComponent("demoted broker for test", BrokerComponent.UNSPECIFIED.id()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
        Assertions.assertEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)this.brokerId());
    }

    private ReplicaAssignment replicaAssignment(scala.collection.immutable.Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)package$.MODULE$.Seq().empty());
    }

    private static final void decodeTopicPartitionStateZNodeAndValidate$1(byte[] responseData, Stat responseStat, int leader, List isr, LeaderRecoveryState expectedLeaderRecoveryState, int leaderEpoch, int controllerEpoch) {
        Option option = TopicPartitionStateZNode$.MODULE$.decode(responseData, responseStat);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            Assertions.assertEquals((int)leader, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leader(), (String)"Leader mismatch");
            Assertions.assertEquals((Object)isr, (Object)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), (String)"Isr mismatch");
            Assertions.assertEquals((Object)expectedLeaderRecoveryState, (Object)leaderIsrAndControllerEpoch.leaderAndIsr().leaderRecoveryState(), (String)"Leader recovery state mismatch");
            Assertions.assertEquals((int)leaderEpoch, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch(), (String)"Leader Epoch mismatch");
            Assertions.assertEquals((int)controllerEpoch, (int)leaderIsrAndControllerEpoch.controllerEpoch(), (String)"Controller Epoch mismatch");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(true, (Function0 & Serializable)() -> "Could not decode TopicPartitionStateZNode data");
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, scala.collection.immutable.Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        scala.collection.immutable.Seq getDataResponses = (scala.collection.immutable.Seq)partitions$1.map((Function1 & Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw((Seq)partitions$1)).thenReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Mockito.when((Object)this.mockZkClient().getTopicConfigOverrides(Predef$.MODULE$.Set().empty())).thenReturn((Object)new Tuple2(Map$.MODULE$.empty(), Map$.MODULE$.empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(scala.collection.immutable.Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((IterableOnceOps)partitions$1.map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)package$.MODULE$.Right().apply((Object)v));
            }
            throw new MatchError(null);
        }), (Seq)package$.MODULE$.Seq().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$5) {
        return new TopicPartition(topic$1, x$5);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$6) {
        return new TopicPartition(topic$2, x$6);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$7) {
        return new TopicPartition("test", x$7);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)package$.MODULE$.Seq().empty()));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

