/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.Block$;
import kafka.controller.Continue$;
import kafka.controller.ContinueMerged$;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00042\u0001\u0001\u0006IA\f\u0005\be\u0001\u0011\r\u0011\"\u00014\u0011\u0019Q\u0004\u0001)A\u0005i!91\b\u0001b\u0001\n\u0003\u0019\u0004B\u0002\u001f\u0001A\u0003%A\u0007C\u0004>\u0001\t\u0007I\u0011\u0001 \t\r\u001d\u0003\u0001\u0015!\u0003@\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015Q\u0006\u0001\"\u0001J\u0011\u0015a\u0006\u0001\"\u0001J\u0011\u0015q\u0006\u0001\"\u0001J\u0011\u0015\u0001\u0007\u0001\"\u0001J\u0011\u0015\u0011\u0007\u0001\"\u0001J\u0011\u0015!\u0007\u0001\"\u0001J\u0011\u0015q\u0006\u0001\"\u0001g\u0011\u0015q\u0007\u0001\"\u0001J\u0011\u0015\u0001\b\u0001\"\u0001J\u0011\u0015\u0011\b\u0001\"\u0001J\u0011\u0015!\b\u0001\"\u0001J\u0011\u00151\b\u0001\"\u0001J\u0011\u0015A\b\u0001\"\u0001J\u0011\u0015Q\b\u0001\"\u0001J\u0011\u0015Q\b\u0001\"\u0001}\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\u0011q#\u00169eCR,W*\u001a;bI\u0006$\u0018MQ1uG\"$Vm\u001d;\u000b\u0005uq\u0012AC2p]R\u0014x\u000e\u001c7fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u0005\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u00039\u0002\"aK\u0018\n\u0005Ab\"!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0003\u001d\u0011%o\\6feB*\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003oy\tqa\u00197vgR,'/\u0003\u0002:m\t1!I]8lKJ\f\u0001B\u0011:pW\u0016\u0014\b\u0007I\u0001\b\u0005J|7.\u001a:2\u0003!\u0011%o\\6feF\u0002\u0013a\u0002\"s_.,'o]\u000b\u0002\u007fA\u0019\u0001)\u0012\u001b\u000e\u0003\u0005S!AQ\"\u0002\u0013%lW.\u001e;bE2,'B\u0001#%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u0006\u00131aU3u\u0003!\u0011%o\\6feN\u0004\u0013a\u0005;fgR\u0014\u0015m]5d\u001fB,'/\u0019;j_:\u001cH#\u0001&\u0011\u0005\rZ\u0015B\u0001'%\u0005\u0011)f.\u001b;)\u0005)q\u0005CA(Y\u001b\u0005\u0001&BA)S\u0003\r\t\u0007/\u001b\u0006\u0003'R\u000bqA[;qSR,'O\u0003\u0002V-\u0006)!.\u001e8ji*\tq+A\u0002pe\u001eL!!\u0017)\u0003\tQ+7\u000f^\u0001\u000fi\u0016\u001cH/\u00113e)>\u0004\u0018nY%eQ\tYa*A\u000buKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N#\u0018\r^3)\u00051q\u0015A\t;fgR\u0004&o\\2fgN<\u0016\u000e\u001e5Va\u0012\fG/Z'fi\u0006$\u0017\r^1CCR\u001c\u0007\u000e\u000b\u0002\u000e\u001d\u0006\u0011D/Z:u!J|7-Z:t\u0011\u00064\u0018N\\4OK^\u0014%o\\6feN<\u0016\u000e\u001e5Va\u0012\fG/Z'fi\u0006$\u0017\r^1CCR\u001c\u0007\u000e\u000b\u0002\u000f\u001d\u00061D/Z:u!J|7-Z:t/&$\b.\u00169eCR,W*\u001a;bI\u0006$\u0018MQ1uG\"\u001cuN\u001c;bS:Lgn\u001a(fo\n\u0013xn[3sg\"\u0012qBT\u0001Gi\u0016\u001cH\u000f\u0015:pG\u0016\u001c8\u000fS1wS:<g*Z<Ce>\\WM]:XSRDW\u000b\u001d3bi\u0016lU\r^1eCR\f')\u0019;dQ\u000e{g\u000e^1j]&twMT3x\u0005J|7.\u001a:tQ\t\u0001b\nF\u0002KO2DQ\u0001[\tA\u0002%\fa\u0002[1t\u001d\u0016<(I]8lKJ\u001c\u0018\u0007\u0005\u0002$U&\u00111\u000e\n\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0017\u00031\u0001j\u00039A\u0017m\u001d(fo\n\u0013xn[3sgJ\n1\u0007^3tiB\u0013xnY3tg6K'O]8s'R\fG/Z+qI\u0006$XmV5uQV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195)\u0005Iq\u0015\u0001\t;fgR\u0004&o\\2fgN<\u0016\u000e\u001e5MK\u0006$WM]!oI&\u001b(OQ1uG\"D#a\u0005(\u0002[Q,7\u000f\u001e)s_\u000e,7o\u001d%bg:+wO\u0011:pW\u0016\u00148oV5uQ2+\u0017\rZ3s\u0003:$\u0017j\u001d:CCR\u001c\u0007\u000e\u000b\u0002\u0015\u001d\u0006yB/Z:u!J|7-Z:t/&$\bn\u0015;paJ+\u0007\u000f\\5dC\n\u000bGo\u00195)\u0005Uq\u0015\u0001\f;fgR\u0004&o\\2fgND\u0015m\u001d(fo\n\u0013xn[3sg^KG\u000f[*u_B\u0014V\r\u001d7jG\u0006\u0014\u0015\r^2iQ\t1b*\u0001\u0012uKN$\bK]8dKN\u001cx+\u001b;i\u0013:\u001cwN\\:jgR,g\u000e\u001e+pa&\u001c\u0017\n\u001a\u0015\u0003/9\u000b\u0011\u0003^3ti\n+\u0018\u000e\u001c3SKF,Xm\u001d;tQ\tAb\n\u0006\u0002K{\")a0\u0007a\u0001\u007f\u00069a/\u001a:tS>t\u0007cA\u0012\u0002\u0002%\u0019\u00111\u0001\u0013\u0003\u000bMCwN\u001d;\u0002%5\f7.\u001a)beRLG/[8o'R\fG/\u001a\u000b\t\u0003\u0013\ty$a\u0013\u0002VA!\u00111BA\u001d\u001d\u0011\ti!a\r\u000f\t\u0005=\u0011Q\u0006\b\u0005\u0003#\t9C\u0004\u0003\u0002\u0014\u0005\rb\u0002BA\u000b\u0003?qA!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0001\u0013A\u0002\u001fs_>$h(C\u0001X\u0013\r\t\tCV\u0001\u0007CB\f7\r[3\n\u0007}\t)CC\u0002\u0002\"YKA!!\u000b\u0002,\u000511m\\7n_:T1aHA\u0013\u0013\u0011\ty#!\r\u0002\u000f5,7o]1hK*!\u0011\u0011FA\u0016\u0013\u0011\t)$a\u000e\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0003_\t\t$\u0003\u0003\u0002<\u0005u\"\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003k\t9\u0004C\u0004\u0002Bi\u0001\r!a\u0011\u0002\u0005Q\u0004\b\u0003BA#\u0003\u000fj!!!\r\n\t\u0005%\u0013\u0011\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tiE\u0007a\u0001\u0003\u001f\na\u0001\\3bI\u0016\u0014\bcA\u0012\u0002R%\u0019\u00111\u000b\u0013\u0003\u0007%sG\u000fC\u0004\u0002Xi\u0001\r!a\u0014\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b")
public class UpdateMetadataBatchTest {
    private final StateChangeLogger stateChangeLogger = new StateChangeLogger(0, true, (Option)None$.MODULE$);
    private final Broker Broker0 = Broker$.MODULE$.apply(0, (Seq)new .colon.colon((Object)new EndPoint("localhost", 9090, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)new .colon.colon((Object)new EndPoint("localhost", 9190, new ListenerName("SASL_SSL"), SecurityProtocol.SASL_SSL), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr0"), (Object)"value0")})));
    private final Broker Broker1 = Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)new EndPoint("localhost", 9091, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)new .colon.colon((Object)new EndPoint("localhost", 9191, new ListenerName("SASL_SSL"), SecurityProtocol.SASL_SSL), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr1"), (Object)"value1")})));
    private final Set<Broker> Brokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}));

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Broker Broker0() {
        return this.Broker0;
    }

    public Broker Broker1() {
        return this.Broker1;
    }

    public Set<Broker> Brokers() {
        return this.Brokers;
    }

    @Test
    public void testBasicOperations() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.latestVersion(), (short)batch.version());
        Assertions.assertEquals((int)0, (int)batch.controllerId());
        Assertions.assertEquals((int)0, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)0L, (long)batch.brokerEpoch());
        Assertions.assertFalse((boolean)batch.hasNewBrokers());
        Assertions.assertTrue((boolean)batch.partitions().isEmpty());
        Assertions.assertTrue((boolean)batch.liveBrokers().isEmpty());
        Assertions.assertTrue((boolean)batch.isEmpty());
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        UpdateMetadataRequestData.UpdateMetadataPartitionState tpState = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeader(0).setLeaderEpoch(0);
        batch.setVersion(ApiKeys.UPDATE_METADATA.oldestVersion()).setControllerId(1).setControllerEpoch(2).setBrokerEpoch(3L).setHasNewBrokers().addPartitionState(tp, tpState).addTopicId(tp.topic(), topicId).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})));
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.oldestVersion(), (short)batch.version());
        Assertions.assertEquals((int)1, (int)batch.controllerId());
        Assertions.assertEquals((int)2, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)3L, (long)batch.brokerEpoch());
        Assertions.assertTrue((boolean)batch.hasNewBrokers());
        Assertions.assertFalse((boolean)batch.partitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)tpState)})), (Object)batch.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicId)})), (Object)batch.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})), (Object)batch.liveBrokers());
        Assertions.assertFalse((boolean)batch.isEmpty());
    }

    @Test
    public void testAddTopicId() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        String topic = "topic";
        batch.addTopicId(topic, topicId0);
        batch.addTopicId(topic, topicId0);
        Assertions.assertThrows(IllegalStateException.class, () -> batch.addTopicId(topic, topicId1));
    }

    @Test
    public void testAddPartitionState() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 1));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)1, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
    }

    @Test
    public void testProcessWithUpdateMetadataBatch() {
        this.testProcessWithUpdateMetadataBatch(false, false);
    }

    @Test
    public void testProcessHavingNewBrokersWithUpdateMetadataBatch() {
        this.testProcessWithUpdateMetadataBatch(true, false);
    }

    @Test
    public void testProcessWithUpdateMetadataBatchContainingNewBrokers() {
        this.testProcessWithUpdateMetadataBatch(false, true);
    }

    @Test
    public void testProcessHavingNewBrokersWithUpdateMetadataBatchContainingNewBrokers() {
        this.testProcessWithUpdateMetadataBatch(true, true);
    }

    public void testProcessWithUpdateMetadataBatch(boolean hasNewBrokers1, boolean hasNewBrokers2) {
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        UpdateMetadataBatch batch1 = new UpdateMetadataBatch(0).setVersion((short)(ApiKeys.UPDATE_METADATA.latestVersion() - 1)).setControllerId(0).setControllerEpoch(0).setBrokerEpoch(0L).addPartitionState(tp0, this.makePartitionState(tp0, 0, 1)).addTopicId(tp0.topic(), topicId0).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})));
        if (hasNewBrokers1) {
            batch1.setHasNewBrokers();
        }
        UpdateMetadataBatch batch2 = new UpdateMetadataBatch(0).setVersion(ApiKeys.UPDATE_METADATA.latestVersion()).setControllerId(1).setControllerEpoch(1).setBrokerEpoch(1L).addPartitionState(tp0, this.makePartitionState(tp0, 1, 2)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 1)).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker1()})));
        if (hasNewBrokers2) {
            batch2.setHasNewBrokers();
        }
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.latestVersion(), (short)batch1.version());
        Assertions.assertEquals((int)1, (int)batch1.controllerId());
        Assertions.assertEquals((int)1, (int)batch1.controllerEpoch());
        Assertions.assertEquals((long)1L, (long)batch1.brokerEpoch());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((hasNewBrokers1 || hasNewBrokers2 ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)batch1.hasNewBrokers()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(tp0, 1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(tp1, 1, 1))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)batch1.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker1()})), (Object)batch1.liveBrokers());
    }

    @Test
    public void testProcessMirrorStateUpdateWithUpdateMetadataBatch() {
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        TopicPartition tp2 = new TopicPartition("topic-2", 2);
        ClusterLinkTopicState.Mirror mirrorState0 = new ClusterLinkTopicState.Mirror("testLink", Uuid.randomUuid(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.Mirror mirrorState1 = new ClusterLinkTopicState.Mirror("testLink", Uuid.randomUuid(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.PendingStoppedMirror pendingMirrorState1 = new ClusterLinkTopicState.PendingStoppedMirror("testLink", mirrorState1.linkId(), mirrorState1.sourceTopicId(), false, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.PendingStoppedMirror pendingMirrorState2 = new ClusterLinkTopicState.PendingStoppedMirror("testLink", Uuid.randomUuid(), Uuid.randomUuid(), true, Time.SYSTEM.milliseconds());
        UpdateMetadataBatch batch1 = new UpdateMetadataBatch(0).setVersion((short)(ApiKeys.UPDATE_METADATA.latestVersion() - 1)).setControllerId(0).setControllerEpoch(0).setBrokerEpoch(0L).addPartitionState(tp0, this.makePartitionState(tp0, 0, 1)).addTopicId(tp0.topic(), topicId0).setMirrorTopicMetadata(tp0.topic(), (Option)new Some((Object)mirrorState0)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 1)).addTopicId(tp1.topic(), topicId1).setMirrorTopicMetadata(tp1.topic(), (Option)new Some((Object)mirrorState1));
        UpdateMetadataBatch batch2 = new UpdateMetadataBatch(0).setVersion(ApiKeys.UPDATE_METADATA.latestVersion()).setControllerId(1).setControllerEpoch(1).setBrokerEpoch(1L).addPartitionState(tp0, this.makePartitionState(tp0, 1, 2)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 1)).addPartitionState(tp2, this.makePartitionState(tp2, 2, 3)).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).addTopicId(tp2.topic(), topicId2).setMirrorTopicMetadata(tp1.topic(), (Option)new Some((Object)pendingMirrorState1)).setMirrorTopicMetadata(tp2.topic(), (Option)new Some((Object)pendingMirrorState2));
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.latestVersion(), (short)batch1.version());
        Assertions.assertEquals((int)1, (int)batch1.controllerId());
        Assertions.assertEquals((int)1, (int)batch1.controllerEpoch());
        Assertions.assertEquals((long)1L, (long)batch1.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(tp0, 1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(tp1, 1, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)this.makePartitionState(tp2, 2, 3))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)})), (Object)batch1.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)UpdateMetadataBatchTest.stateString$1(mirrorState0.toMirrorTopicState())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)UpdateMetadataBatchTest.stateString$1(pendingMirrorState1.toMirrorTopicState())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)UpdateMetadataBatchTest.stateString$1(pendingMirrorState2.toMirrorTopicState()))})), (Object)batch1.mirrorTopicsMetadata().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                UpdateMetadataRequest.MirrorTopicState state = (UpdateMetadataRequest.MirrorTopicState)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)UpdateMetadataBatchTest.stateString$1(state));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testProcessWithLeaderAndIsrBatch() {
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)new UpdateMetadataBatch(0).process((ControlMetadataBatch)new LeaderAndIsrBatch(0)));
    }

    @Test
    public void testProcessHasNewBrokersWithLeaderAndIsrBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).setHasNewBrokers().process((ControlMetadataBatch)new LeaderAndIsrBatch(0)));
    }

    @Test
    public void testProcessWithStopReplicaBatch() {
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)new UpdateMetadataBatch(0).process((ControlMetadataBatch)new StopReplicaBatch(0)));
    }

    @Test
    public void testProcessHasNewBrokersWithStopReplicaBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).setHasNewBrokers().process((ControlMetadataBatch)new StopReplicaBatch(0)));
    }

    @Test
    public void testProcessWithInconsistentTopicId() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid())));
    }

    @Test
    public void testBuildRequests() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.UPDATE_METADATA.oldestVersion()), (int)ApiKeys.UPDATE_METADATA.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> this.testBuildRequests((short)version));
    }

    public void testBuildRequests(short version) {
        int controllerId = 0;
        int controllerEpoch = 1;
        int brokerEpoch = 2;
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        UpdateMetadataRequestData.UpdateMetadataPartitionState state0 = this.makePartitionState(tp0, 0, 2);
        UpdateMetadataRequestData.UpdateMetadataPartitionState state1 = this.makePartitionState(tp1, 1, 3);
        Seq requests = new UpdateMetadataBatch(0).setVersion(version).setControllerId(controllerId).setControllerEpoch(controllerEpoch).setBrokerEpoch((long)brokerEpoch).addPartitionState(tp0, state0).addPartitionState(tp1, state1).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).setLiveBrokers(this.Brokers()).requests(this.stateChangeLogger());
        Assertions.assertEquals((int)1, (int)requests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)((AbstractRequest.Builder)requests.head()).build();
        Assertions.assertEquals((short)version, (short)updateMetadataRequest.version());
        Assertions.assertEquals((int)controllerId, (int)updateMetadataRequest.controllerId());
        Assertions.assertEquals((int)controllerEpoch, (int)updateMetadataRequest.controllerEpoch());
        Assertions.assertEquals((long)brokerEpoch, (long)updateMetadataRequest.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{state0, state1})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(updateMetadataRequest.partitionStates()).asScala().toSet());
        Assertions.assertEquals((Object)this.Brokers().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id())), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest.liveBrokers()).asScala().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()))).toSet());
        Assertions.assertEquals((Object)this.Brokers().map((Function1 & Serializable)x$15 -> x$15.tags()), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest.liveBrokers()).asScala().map((Function1 & Serializable)broker -> CollectionConverters$.MODULE$.MapHasAsScala(UpdateMetadataRequest.tagMapFromBrokerTagCollection((java.util.List)broker.tags())).asScala())).toSet());
        if (version >= 5) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest.topicStates()).asScala().map((Function1 & Serializable)partitionState -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionState.topicName()), (Object)partitionState.topicId()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        Set ports = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest.liveBrokers()).asScala().flatMap((Function1 & Serializable)x$16 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$16.endpoints()).asScala().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.port())))).toSet();
        if (version == 0) {
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
            Assertions.assertEquals((Object)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}))).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)UpdateMetadataBatchTest.$anonfun$testBuildRequests$12(listenerName, x$18))), (Object)ports);
            return;
        }
        Assertions.assertEquals((Object)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}))).flatMap((Function1 & Serializable)x$19 -> (Seq)x$19.endPoints().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.port()))), (Object)ports);
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState makePartitionState(TopicPartition tp, int leader, int leaderEpoch) {
        return new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setLeader(leader).setLeaderEpoch(leaderEpoch);
    }

    private static final String stateString$1(UpdateMetadataRequest.MirrorTopicState state) {
        return new StringBuilder(32).append("(state=").append(state.state()).append(", linkId=").append(state.clusterLinkId()).append(" sourceTopicId=").append(state.sourceTopicId()).append(")").toString();
    }

    public static final /* synthetic */ int $anonfun$testBuildRequests$12(ListenerName listenerName$1, Broker x$18) {
        return x$18.node(listenerName$1).port();
    }
}

