/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller.rest;

import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.CheckReadyControllerStatus;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;
import java.util.function.Function;
import kafka.controller.rest.ControllerServerRestHandler;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.client.CannotCreateClientWithCurrentMetadataException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServerRestHandlerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerServerRestHandlerTest.class);
    private static final List<QuorumInfo.ReplicaState> GOOD_VOTERS = Arrays.asList(new QuorumInfo.ReplicaState(1000, 123L, OptionalLong.of(123L), OptionalLong.of(1000000L)), new QuorumInfo.ReplicaState(1001, 124L, OptionalLong.of(124L), OptionalLong.of(1001000L)), new QuorumInfo.ReplicaState(1002, 124L, OptionalLong.of(124L), OptionalLong.of(1001000L)));
    private static final List<QuorumInfo.ReplicaState> VOTERS_WITH_TWO_UNREACHABLE = Arrays.asList(new QuorumInfo.ReplicaState(0, 123L, OptionalLong.of(123L), OptionalLong.of(1000000L)), new QuorumInfo.ReplicaState(1, -1L, OptionalLong.empty(), OptionalLong.empty()), new QuorumInfo.ReplicaState(2, -1L, OptionalLong.empty(), OptionalLong.empty()), new QuorumInfo.ReplicaState(3, 123L, OptionalLong.of(123L), OptionalLong.of(1000001L)), new QuorumInfo.ReplicaState(4, 123L, OptionalLong.of(123L), OptionalLong.of(1000002L)));
    private static final List<QuorumInfo.ReplicaState> BAD_VOTERS = Arrays.asList(new QuorumInfo.ReplicaState(1000, 123L, OptionalLong.of(123L), OptionalLong.empty()), new QuorumInfo.ReplicaState(1001, 122L, OptionalLong.of(122L), OptionalLong.empty()), new QuorumInfo.ReplicaState(1002, 122L, OptionalLong.of(122L), OptionalLong.of(500000L)));

    @Test
    public void testGetVoterById() {
        Assertions.assertEquals((Object)GOOD_VOTERS.get(1), (Object)ControllerServerRestHandler.getVoterById(GOOD_VOTERS, (int)1001));
    }

    @Test
    public void testGetVoterByIdWithInvalidId() {
        Assertions.assertNull((Object)ControllerServerRestHandler.getVoterById(GOOD_VOTERS, (int)9999));
    }

    @Test
    public void testTranslateReadinessInfoWithMissingNode() {
        this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Can't find node 123 in QuorumInfo."), ControllerServerRestHandler.translateReadinessInfo(GOOD_VOTERS, (int)123, (long)1002000L));
    }

    @Test
    public void testTranslateReadinessInfoWithUnreachableNode() {
        this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Node 1 is unreachable."), ControllerServerRestHandler.translateReadinessInfo(VOTERS_WITH_TWO_UNREACHABLE, (int)1, (long)1002000L));
    }

    @Test
    public void testTranslateReadinessInfoWithNotCaughtUpNode() {
        this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Node 1001 is not caught up."), ControllerServerRestHandler.translateReadinessInfo(BAD_VOTERS, (int)1001, (long)1002000L));
    }

    @Test
    public void testTranslateReadinessInfoWithLaggingNode() {
        this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Node 1002 is lagging by 502000 ms."), ControllerServerRestHandler.translateReadinessInfo(BAD_VOTERS, (int)1002, (long)1002000L));
    }

    @Test
    public void testTranslateReadinessInfoWithGoodNode() {
        this.assertReadyStatusEquals(new CheckReadyControllerStatus(true, ""), ControllerServerRestHandler.translateReadinessInfo(BAD_VOTERS, (int)1002, (long)500000L));
    }

    @Test
    public void testTranslateGoodRollableInfo() {
        this.assertRollStatusEquals(new BeginShutdownControllerStatus(true, ""), ControllerServerRestHandler.translateRollableInfo(GOOD_VOTERS, (long)1002000L));
    }

    @Test
    public void testTranslateUnreachableRollableInfo() {
        this.assertRollStatusEquals(new BeginShutdownControllerStatus(false, "Some controller quorum nodes had problems: 1 was unreachable, 2 was unreachable"), ControllerServerRestHandler.translateRollableInfo(VOTERS_WITH_TWO_UNREACHABLE, (long)1002000L));
    }

    @Test
    public void testTranslateBadRollableInfo() {
        this.assertRollStatusEquals(new BeginShutdownControllerStatus(false, "Some controller quorum nodes had problems: 1000 was not caught up, 1001 was not caught up, 1002 was lagging by 502000 ms"), ControllerServerRestHandler.translateRollableInfo(BAD_VOTERS, (long)1002000L));
    }

    private void assertReadyStatusEquals(CheckReadyControllerStatus expected, CheckReadyControllerStatus actual) {
        Assertions.assertEquals((Object)expected.reason(), (Object)actual.reason());
        Assertions.assertEquals((Object)expected.ready(), (Object)actual.ready());
    }

    private void assertRollStatusEquals(BeginShutdownControllerStatus expected, BeginShutdownControllerStatus actual) {
        Assertions.assertEquals((Object)expected.reason(), (Object)actual.reason());
        Assertions.assertEquals((Object)expected.rollable(), (Object)actual.rollable());
    }

    @Test
    public void testGenerateRollableStatusSuccess() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().build();){
            ctx.adminClient.setQuorumInfo(new QuorumInfo(100, 1234L, 123L, GOOD_VOTERS, Arrays.asList(new QuorumInfo.ReplicaState[0])));
            this.assertRollStatusEquals(new BeginShutdownControllerStatus(true, ""), ctx.handler.generateRollableStatus());
        }
    }

    @Test
    public void testGenerateRollableStatusWithoutMetadata() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)new CannotCreateClientWithCurrentMetadataException("")).build();){
            this.assertRollStatusEquals(new BeginShutdownControllerStatus(false, "Error checking rollable status: failed to create AdminClient from current metadata."), ctx.handler.generateRollableStatus());
        }
    }

    @Test
    public void testGenerateRollableStatusWithoutMetadataInMigrationMode() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)new CannotCreateClientWithCurrentMetadataException("")).setZkMigrationEnabled(true).build();){
            this.assertRollStatusEquals(new BeginShutdownControllerStatus(true, ""), ctx.handler.generateRollableStatus());
        }
    }

    @Test
    public void testGenerateRollableStatusWithConfigExceptionFromAdminClientSupplier() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)((Object)new ConfigException(""))).setZkMigrationEnabled(true).build();){
            this.assertRollStatusEquals(new BeginShutdownControllerStatus(false, "Error checking rollable status: failed to create AdminClient."), ctx.handler.generateRollableStatus());
        }
    }

    @Test
    public void testGenerateReadinessStatusSuccess() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setNodeId(0).build();){
            ctx.adminClient.setQuorumInfo(new QuorumInfo(0, 1234L, 123L, VOTERS_WITH_TWO_UNREACHABLE, Arrays.asList(new QuorumInfo.ReplicaState[0])));
            this.assertReadyStatusEquals(new CheckReadyControllerStatus(true, ""), ctx.handler.generateReadinessStatus());
        }
    }

    @Test
    public void testGenerateReadinessStatusWithoutMetadata() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)new CannotCreateClientWithCurrentMetadataException("")).build();){
            this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Error checking readiness status: failed to create AdminClient from current metadata."), ctx.handler.generateReadinessStatus());
        }
    }

    @Test
    public void testGenerateReadinessStatusWithoutMetadataInMigrationMode() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)new CannotCreateClientWithCurrentMetadataException("")).setZkMigrationEnabled(true).build();){
            this.assertReadyStatusEquals(new CheckReadyControllerStatus(true, ""), ctx.handler.generateReadinessStatus());
        }
    }

    @Test
    public void testGenerateReadinessStatusWithConfigExceptionFromAdminClientSupplier() {
        try (ControllerServerRestHandlerTestContext ctx = new ControllerServerRestHandlerTestContext.Builder().setAdminClientSupplier((RuntimeException)((Object)new ConfigException(""))).setZkMigrationEnabled(true).build();){
            this.assertReadyStatusEquals(new CheckReadyControllerStatus(false, "Error checking readiness status: failed to create AdminClient."), ctx.handler.generateReadinessStatus());
        }
    }

    static class ControllerServerRestHandlerTestContext
    implements AutoCloseable {
        private final MockAdminClient adminClient;
        private final MockTime time;
        private final ControllerServerRestHandler handler;

        ControllerServerRestHandlerTestContext(MockAdminClient adminClient, MockTime time, ControllerServerRestHandler handler) {
            this.adminClient = adminClient;
            this.time = time;
            this.handler = handler;
        }

        @Override
        public void close() {
            try {
                this.adminClient.close();
            }
            catch (Exception e) {
                LOG.error("Error closing adminClient", (Throwable)e);
            }
            try {
                this.handler.close();
            }
            catch (Exception e) {
                LOG.error("Error closing handler", (Throwable)e);
            }
        }

        static class Builder {
            private int nodeId = 1001;
            private boolean zkMigrationEnabled = false;
            private Function<String, Admin> adminClientSupplier = null;

            Builder() {
            }

            Builder setNodeId(int nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            Builder setZkMigrationEnabled(boolean zkMigrationEnabled) {
                this.zkMigrationEnabled = zkMigrationEnabled;
                return this;
            }

            Builder setAdminClientSupplier(Function<String, Admin> adminClientSupplier) {
                this.adminClientSupplier = adminClientSupplier;
                return this;
            }

            Builder setAdminClientSupplier(final RuntimeException exception) {
                this.adminClientSupplier = new Function<String, Admin>(){

                    @Override
                    public Admin apply(String s) {
                        throw exception;
                    }
                };
                return this;
            }

            ControllerServerRestHandlerTestContext build() {
                MockAdminClient adminClient = new MockAdminClient();
                MockTime time = new MockTime(0L, 1002000L, 12345678L);
                if (this.adminClientSupplier == null) {
                    this.adminClientSupplier = __ -> adminClient;
                }
                ControllerServerRestHandler handler = new ControllerServerRestHandler(new LogContext(), (Time)time, this.nodeId, this.adminClientSupplier, this.zkMigrationEnabled);
                return new ControllerServerRestHandlerTestContext(adminClient, time, handler);
            }
        }
    }
}

