/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.coordinator.NonBlockingSynchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\u0005\u0001C\u0001-\tYbj\u001c8CY>\u001c7.\u001b8h'ft7\r\u001b:p]&TXM\u001d+fgRT!AB\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0011\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011!B\u0001\u0011i\u0016\u001cHoU=oG\"\u0014xN\\5{KJ$\u0012a\u0006\t\u0003\u0019aI!!G\u0007\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005m\u0001\"\u0001H\u0013\u000e\u0003uQ!AH\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0002!C\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0012$\u0003\u0015QWO\\5u\u0015\u0005!\u0013aA8sO&\u0011a%\b\u0002\u0005)\u0016\u001cH/A\u0006uKN$h)\u001e;ve\u0016\u001c\bFA\u0002\u001c\u0001")
public class NonBlockingSynchronizerTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testSynchronizer() {
        NonBlockingSynchronizer synchronizer = new NonBlockingSynchronizer();
        CountDownLatch latch = new CountDownLatch(1);
        VolatileBooleanRef longRunningOpStarted = VolatileBooleanRef.create((boolean)false);
        CompletableFuture.runAsync(() -> synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            longRunningOpStarted$1.elem = true;
            latch.await();
        }));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!longRunningOpStarted.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Long running operation failed to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        BooleanRef done75 = BooleanRef.create((boolean)false);
        synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)75), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done75$1.elem = true;
        });
        Assertions.assertTrue((boolean)done75.elem, (String)"Operation on a different partition should complete");
        VolatileBooleanRef done42 = VolatileBooleanRef.create((boolean)false);
        synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done42$1.elem = true;
        });
        Assertions.assertFalse((boolean)done42.elem, (String)"Operation on the same partition should get queued");
        latch.countDown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!done42.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Operation on the same partition is still blocked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutures() {
        NonBlockingSynchronizer synchronizer = new NonBlockingSynchronizer();
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef future = ObjectRef.create((Object)synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done$1.elem = true;
        }));
        Assertions.assertTrue((boolean)done.elem, (String)"Operation should complete");
        Assertions.assertTrue((boolean)((Future)future.elem).isCompleted(), (String)"Future should be completed");
        Await$.MODULE$.result((Awaitable)((Future)future.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        future.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0 & Serializable)() -> {
            throw new NullPointerException();
        });
        Assertions.assertTrue((boolean)((Future)future.elem).isCompleted(), (String)"Future should be completed");
        Assertions.assertThrows(NullPointerException.class, () -> Await$.MODULE$.result((Awaitable)((Future)future$1.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        VolatileBooleanRef longRunningOpStarted = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef longRunningOpFuture = VolatileObjectRef.create(null);
        VolatileBooleanRef longRunningOpDone = VolatileBooleanRef.create((boolean)false);
        CompletableFuture.runAsync(() -> {
            longRunningOpFuture$1.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                longRunningOpStarted$2.elem = true;
                latch.await();
                longRunningOpDone$1.elem = true;
            });
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!longRunningOpStarted.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Long running operation failed to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertFalse((boolean)longRunningOpDone.elem, (String)"Long running op shouldn't be done");
        future.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0 & Serializable)() -> {
            throw new NullPointerException();
        });
        Assertions.assertFalse((boolean)((Future)future.elem).isCompleted(), (String)"Future shouldn't be completed");
        latch.countDown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Future)longRunningOpFuture.elem != null)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Long running operation failed to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Await$.MODULE$.result((Awaitable)((Future)longRunningOpFuture.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)longRunningOpDone.elem, (String)"Long running operation should complete");
        Assertions.assertThrows(NullPointerException.class, () -> Await$.MODULE$.result((Awaitable)((Future)future$1.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
    }

    public static final /* synthetic */ boolean $anonfun$testSynchronizer$3(VolatileBooleanRef longRunningOpStarted$1) {
        return longRunningOpStarted$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testSynchronizer$4() {
        return "Long running operation failed to start";
    }

    public static final /* synthetic */ boolean $anonfun$testSynchronizer$7(VolatileBooleanRef done42$1) {
        return done42$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testSynchronizer$8() {
        return "Operation on the same partition is still blocked";
    }

    public static final /* synthetic */ boolean $anonfun$testFutures$6(VolatileBooleanRef longRunningOpStarted$2) {
        return longRunningOpStarted$2.elem;
    }

    public static final /* synthetic */ String $anonfun$testFutures$7() {
        return "Long running operation failed to start";
    }

    public static final /* synthetic */ boolean $anonfun$testFutures$9(VolatileObjectRef longRunningOpFuture$1) {
        return (Future)longRunningOpFuture$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$testFutures$10() {
        return "Long running operation failed to complete";
    }
}

