/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.ArrayList;
import java.util.Map;
import kafka.coordinator.RequestQueueMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RequestQueueMapTest {
    private RequestQueueMap<String, Integer> requestQueueMap;
    private String k1 = "k1";
    private String k2 = "k2";

    @BeforeEach
    public void beforeEach() {
        this.requestQueueMap = new RequestQueueMap();
    }

    @Test
    public void testMultipleInserts() {
        int numEntries = 4;
        int viter = 0;
        this.addEntries(this.k1, numEntries, viter);
        this.removeAndVerifyEntries(this.k1, numEntries, viter);
        this.requestQueueMap.returnKey((Object)this.k1);
        this.addEntries(this.k1, numEntries, viter += numEntries);
        this.removeAndVerifyEntries(this.k1, numEntries, viter);
        this.requestQueueMap.returnKey((Object)this.k1);
    }

    @Test
    public void testInsertWhileInFlight() {
        int numEntries = 4;
        int viter = 0;
        this.addEntries(this.k1, numEntries, viter);
        this.removeAndVerifyEntries(this.k1, numEntries, viter);
        this.addEntries(this.k1, numEntries, viter += numEntries);
        this.addEntries(this.k2, numEntries, viter += numEntries);
        this.removeAndVerifyEntries(this.k2, numEntries, viter);
        this.requestQueueMap.returnKey((Object)this.k1);
        this.removeAndVerifyEntries(this.k1, numEntries, viter -= numEntries);
        this.requestQueueMap.returnKey((Object)this.k2);
    }

    @Test
    public void testReturnEmptyQueue() {
        int numEntries = 4;
        int viter = 0;
        this.addEntries(this.k1, numEntries, viter);
        this.removeAndVerifyEntries(this.k1, numEntries, viter);
        this.addEntries(this.k2, numEntries, viter += numEntries);
        this.requestQueueMap.returnKey((Object)this.k1);
        this.removeAndVerifyEntries(this.k2, numEntries, viter);
        this.requestQueueMap.returnKey((Object)this.k2);
    }

    @Test
    public void testReturnNullOnShutdown() {
        int numEntries = 4;
        int viter = 0;
        this.addEntries(this.k1, numEntries, viter);
        this.requestQueueMap.shutDown();
        Assertions.assertEquals(null, (Object)this.requestQueueMap.getRandomNonEmptyQueue());
    }

    private void addEntries(String k, int numEntries, int st) {
        for (int i = 0; i < numEntries; ++i) {
            this.requestQueueMap.addRequest((Object)k, (Object)(st + i));
        }
    }

    private void removeAndVerifyEntries(String k, int numEntries, int st) {
        Map.Entry kvEntry = this.requestQueueMap.getRandomNonEmptyQueue();
        Assertions.assertEquals((Object)k, kvEntry.getKey());
        for (int i = 0; i < numEntries; ++i) {
            Assertions.assertEquals((int)(st + i), (Integer)((Integer)((ArrayList)kvEntry.getValue()).get(i)));
        }
    }
}

