/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.PartitionListener;
import kafka.coordinator.group.CoordinatorPartitionWriter;
import kafka.coordinator.group.ListenerAdapter;
import kafka.coordinator.group.StringKeyValueSerializer;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005M4Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)\u0001\u0007\u0001C\u0001?!)!\u0007\u0001C\u0001?!)A\u0007\u0001C\u0001k!)\u0011\f\u0001C\u00015\")1\u000e\u0001C\u0001?!)Q\u000e\u0001C\u0001?!)q\u000e\u0001C\u0001?!)\u0011\u000f\u0001C\u0001?\tq2i\\8sI&t\u0017\r^8s!\u0006\u0014H/\u001b;j_:<&/\u001b;feR+7\u000f\u001e\u0006\u0003\u001b9\tQa\u001a:pkBT!a\u0004\t\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011\u0001D\u0001\u001fi\u0016\u001cHOU3hSN$XM\u001d#fe\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ$\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0011\u0002\"!\n\u0018\u000e\u0003\u0019R!a\n\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002*U\u00059!.\u001e9ji\u0016\u0014(BA\u0016-\u0003\u0015QWO\\5u\u0015\u0005i\u0013aA8sO&\u0011qF\n\u0002\u0005)\u0016\u001cH/\u0001\tuKN$xK]5uKJ+7m\u001c:eg\"\u00121\u0001J\u0001\u001ei\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006dwK]5uKJ+7m\u001c:eg\"\u0012A\u0001J\u0001\u001ei\u0016\u001cHo\u0016:ji\u0016,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M]6feR\u0011\u0001E\u000e\u0005\u0006o\u0015\u0001\r\u0001O\u0001\u0012G>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007CA\u001dB\u001b\u0005Q$BA\u001e=\u0003\u0019\u0011XmY8sI*\u0011QHP\u0001\u0007G>lWn\u001c8\u000b\u0005Ey$B\u0001!-\u0003\u0019\t\u0007/Y2iK&\u0011!I\u000f\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007FA\u0003E!\t)\u0005*D\u0001G\u0015\t9\u0005&\u0001\u0004qCJ\fWn]\u0005\u0003\u0013\u001a\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u0019)1*\u0015*T)B\u0011AjT\u0007\u0002\u001b*\u0011aJR\u0001\taJ|g/\u001b3fe&\u0011\u0001+\u0014\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7%\u0001\u001d\u0002\u000b9\fW.Z:-\u0005U;\u0016%\u0001,\u0002\r\r{U*T%UC\u0005A\u0016!B!C\u001fJ#\u0016!\n;fgRl\u0015-\u001f2f'R\f'\u000f\u001e+sC:\u001c\u0018m\u0019;j_:4VM]5gS\u000e\fG/[8o)\t\u00013\fC\u0003]\r\u0001\u0007Q,A\u0003feJ|'\u000f\u0005\u0002_C6\tqL\u0003\u0002ay\u0005A\u0001O]8u_\u000e|G.\u0003\u0002c?\n1QI\u001d:peND#A\u0002#)\r\u0019Y\u0015+Z*gG\u0005iFFA4jC\u0005A\u0017\u0001\u0002(P\u001d\u0016\u000b\u0013A[\u0001\u0014\u001d>#v,\u0012(P+\u001eCuLU#Q\u0019&\u001b\u0015iU\u0001\u001ci\u0016\u001cHo\u0016:ji\u0016\u0014VmY8sIN<\u0016\u000e\u001e5GC&dWO]3)\u0005\u001d!\u0013a\u0006;fgR<&/\u001b;f%\u0016\u001cwN\u001d3U_>d\u0015M]4fQ\tAA%\u0001\ruKN$xK]5uK\u0016k\u0007\u000f^=SK\u000e|'\u000f\u001a'jgRD#!\u0003\u0013\u00021Q,7\u000f\u001e(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u000bI\u0001")
public class CoordinatorPartitionWriterTest {
    @Test
    public void testRegisterDeregisterListener() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        PartitionWriter.Listener listener = new PartitionWriter.Listener(null){

            public void onHighWatermarkUpdated(TopicPartition tp, long offset) {
            }
        };
        partitionRecordWriter.registerListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(tp, (PartitionListener)new ListenerAdapter(listener));
        partitionRecordWriter.deregisterListener(tp, listener);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).removeListener(tp, (PartitionListener)new ListenerAdapter(listener));
        Assertions.assertEquals((Object)new ListenerAdapter(listener), (Object)new ListenerAdapter(listener));
        Assertions.assertEquals((int)new ListenerAdapter(listener).hashCode(), (int)new ListenerAdapter(listener).hashCode());
    }

    @Test
    public void testWriteRecords() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)VerificationGuard.SENTINEL)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecords$1(callbackCapture, tp, x$1);
            return BoxedUnit.UNIT;
        });
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((long)11L, (long)partitionRecordWriter.append(tp, -1L, (short)-1, VerificationGuard.SENTINEL, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records).asJava()));
        MemoryRecords batch = (MemoryRecords)((MapOps)recordsCapture.getValue()).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(15).append("No records for ").append(tp).toString());
        });
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().toList().size());
        List receivedRecords = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(batch.records()).asScala().map((Function1 & Serializable)record -> new Tuple2((Object)Charset.defaultCharset().decode(record.key()).toString(), (Object)Charset.defaultCharset().decode(record.value()).toString()))).toList();
        Assertions.assertEquals((Object)records, (Object)receivedRecords);
    }

    @Test
    public void testTransactionalWriteRecords() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        VerificationGuard verificationGuard = new VerificationGuard();
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)verificationGuard)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            CoordinatorPartitionWriterTest.$anonfun$testTransactionalWriteRecords$1(callbackCapture, tp, x$2);
            return BoxedUnit.UNIT;
        });
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((long)11L, (long)partitionRecordWriter.append(tp, 100L, (short)50, verificationGuard, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records).asJava()));
        MemoryRecords batch = (MemoryRecords)((MapOps)recordsCapture.getValue()).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(15).append("No records for ").append(tp).toString());
        });
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().toList().size());
        MutableRecordBatch firstBatch = (MutableRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().head();
        Assertions.assertEquals((long)100L, (long)firstBatch.producerId());
        Assertions.assertEquals((short)((short)50), (short)firstBatch.producerEpoch());
        Assertions.assertTrue((boolean)firstBatch.isTransactional());
        List receivedRecords = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(batch.records()).asScala().map((Function1 & Serializable)record -> new Tuple2((Object)Charset.defaultCharset().decode(record.key()).toString(), (Object)Charset.defaultCharset().decode(record.value()).toString()))).toList();
        Assertions.assertEquals((Object)records, (Object)receivedRecords);
    }

    @ParameterizedTest
    @EnumSource(value=ControlRecordType.class, names={"COMMIT", "ABORT"})
    public void testWriteEndTransactionMarker(ControlRecordType controlRecordType) {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)VerificationGuard.SENTINEL)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteEndTransactionMarker$1(callbackCapture, tp, x$3);
            return BoxedUnit.UNIT;
        });
        ControlRecordType controlRecordType2 = controlRecordType;
        ControlRecordType controlRecordType3 = ControlRecordType.COMMIT;
        Assertions.assertEquals((long)11L, (long)partitionRecordWriter.appendEndTransactionMarker(tp, 100L, (short)50, 10, !(controlRecordType2 != null ? !controlRecordType2.equals(controlRecordType3) : controlRecordType3 != null) ? TransactionResult.COMMIT : TransactionResult.ABORT));
        MemoryRecords batch = (MemoryRecords)((MapOps)recordsCapture.getValue()).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(15).append("No records for ").append(tp).toString());
        });
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().toList().size());
        MutableRecordBatch firstBatch = (MutableRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(batch.batches()).asScala().head();
        Assertions.assertEquals((long)100L, (long)firstBatch.producerId());
        Assertions.assertEquals((short)((short)50), (short)firstBatch.producerEpoch());
        Assertions.assertTrue((boolean)firstBatch.isTransactional());
        Assertions.assertTrue((boolean)firstBatch.isControlBatch());
        List receivedRecords = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(batch.records()).asScala().map((Function1 & Serializable)record -> ControlRecordType.parse((ByteBuffer)record.key()))).toList();
        Assertions.assertEquals((Object)new .colon.colon((Object)controlRecordType, (List)Nil$.MODULE$), (Object)receivedRecords);
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "NOT_ENOUGH_REPLICAS"})
    public void testMaybeStartTransactionVerification(Errors error) {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        VerificationGuard verificationGuard = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new VerificationGuard() : VerificationGuard.SENTINEL;
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.maybeStartTransactionVerificationForPartition((TopicPartition)ArgumentMatchers.eq((Object)tp), (String)ArgumentMatchers.eq((Object)"transactional-id"), ArgumentMatchers.eq((long)10L), ArgumentMatchers.eq((short)((short)5)), ArgumentMatchers.eq((int)-1), (Function1)callbackCapture.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            CoordinatorPartitionWriterTest.$anonfun$testMaybeStartTransactionVerification$1(callbackCapture, error, verificationGuard, x$4);
            return BoxedUnit.UNIT;
        });
        CompletableFuture future = partitionRecordWriter.maybeStartTransactionVerification(tp, "transactional-id", 10L, (short)5);
        Errors errors3 = error;
        Errors errors4 = Errors.NONE;
        if (!(errors3 != null ? !errors3.equals(errors4) : errors4 != null)) {
            Assertions.assertEquals((Object)verificationGuard, future.get());
            return;
        }
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
    }

    @Test
    public void testWriteRecordsWithFailure() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MockTime time = new MockTime();
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, (Time)time);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        replicaManager.appendRecords(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((short)((short)1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)VerificationGuard.SENTINEL)}))));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            CoordinatorPartitionWriterTest.$anonfun$testWriteRecordsWithFailure$1(callbackCapture, tp, x$5);
            return BoxedUnit.UNIT;
        });
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testWriteRecordsWithFailure$2(partitionRecordWriter, tp, (List)records));
    }

    @Test
    public void testWriteRecordTooLarge() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        int maxBatchSize = 16384;
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)BoxesRunTime.boxToInteger((int)maxBatchSize))}))).asJava(), (Properties)new Properties())));
        byte[] randomBytes = TestUtils.randomBytes((int)(maxBatchSize + 1));
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)new String(randomBytes)), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)new String(randomBytes)), (List)Nil$.MODULE$));
        Assertions.assertThrows(RecordTooLargeException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testWriteRecordTooLarge$1(partitionRecordWriter, tp, (List)records));
    }

    @Test
    public void testWriteEmptyRecordList() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)new Some((Object)LogConfig.fromProps(Collections.emptyMap(), (Properties)new Properties())));
        Assertions.assertThrows(IllegalStateException.class, () -> partitionRecordWriter.append(tp, -1L, (short)-1, VerificationGuard.SENTINEL, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
    }

    @Test
    public void testNonexistentPartition() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        CoordinatorPartitionWriter partitionRecordWriter = new CoordinatorPartitionWriter(replicaManager, (PartitionWriter.Serializer)new StringKeyValueSerializer(), CompressionType.NONE, Time.SYSTEM);
        Mockito.when((Object)replicaManager.getLogConfig(tp)).thenReturn((Object)None$.MODULE$);
        .colon.colon records = new .colon.colon((Object)new Tuple2((Object)"k0", (Object)"v0"), (List)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)"v1"), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)"v2"), (List)Nil$.MODULE$)));
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> CoordinatorPartitionWriterTest.$anonfun$testNonexistentPartition$1(partitionRecordWriter, tp, (List)records));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecords$1(ArgumentCaptor callbackCapture$1, TopicPartition tp$1, InvocationOnMock x$1) {
        ((Function1)callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 5L, 10L, -1L, -1L, Collections.emptyList(), ""))})));
    }

    public static final /* synthetic */ void $anonfun$testTransactionalWriteRecords$1(ArgumentCaptor callbackCapture$2, TopicPartition tp$2, InvocationOnMock x$2) {
        ((Function1)callbackCapture$2.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 5L, 10L, -1L, -1L, Collections.emptyList(), ""))})));
    }

    public static final /* synthetic */ void $anonfun$testWriteEndTransactionMarker$1(ArgumentCaptor callbackCapture$3, TopicPartition tp$3, InvocationOnMock x$3) {
        ((Function1)callbackCapture$3.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$3), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 5L, 10L, -1L, -1L, Collections.emptyList(), ""))})));
    }

    public static final /* synthetic */ void $anonfun$testMaybeStartTransactionVerification$1(ArgumentCaptor callbackCapture$4, Errors error$1, VerificationGuard verificationGuard$1, InvocationOnMock x$4) {
        ((Function1)callbackCapture$4.getValue()).apply((Object)new Tuple2((Object)error$1, (Object)verificationGuard$1));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordsWithFailure$1(ArgumentCaptor callbackCapture$5, TopicPartition tp$4, InvocationOnMock x$5) {
        ((Function1)callbackCapture$5.getValue()).apply(Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$4), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_LEADER_OR_FOLLOWER))})));
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordsWithFailure$2(CoordinatorPartitionWriter partitionRecordWriter$1, TopicPartition tp$4, List records$1) {
        partitionRecordWriter$1.append(tp$4, -1L, (short)-1, VerificationGuard.SENTINEL, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$1).asJava());
    }

    public static final /* synthetic */ void $anonfun$testWriteRecordTooLarge$1(CoordinatorPartitionWriter partitionRecordWriter$2, TopicPartition tp$5, List records$2) {
        partitionRecordWriter$2.append(tp$5, -1L, (short)-1, VerificationGuard.SENTINEL, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$2).asJava());
    }

    public static final /* synthetic */ void $anonfun$testNonexistentPartition$1(CoordinatorPartitionWriter partitionRecordWriter$4, TopicPartition tp$7, List records$3) {
        partitionRecordWriter$4.append(tp$7, -1L, (short)-1, VerificationGuard.SENTINEL, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records$3).asJava());
    }
}

