/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorTest;
import kafka.server.ActionQueue;
import kafka.server.DelayedActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001\u0002\n\u0014\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013\u00053\u0005\u0003\u0004+\u0001\u0001\u0006I\u0001\n\u0005\nW\u0001\u0001\r\u00111A\u0005\n1B\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\t\u0013i\u0002\u0001\u0019!A!B\u0013i\u0003\"B\u001e\u0001\t\u0003b\u0004\"\u0002&\u0001\t\u0003a\u0004\"B(\u0001\t\u0003a\u0004\"B)\u0001\t\u0003a\u0004\"B*\u0001\t\u0003a\u0004\"B+\u0001\t\u0003a\u0004\"B,\u0001\t\u0013A\u0006BB@\u0001\t\u0013\t\t\u0001C\u0005\u0002N\u0001\t\n\u0011\"\u0003\u0002P!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0002$\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014\u0015\r^2iS:<wJ\u001a4tKR\u001cH+Z:u\u0015\t!R#A\u0003he>,\bO\u0003\u0002\u0017/\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u000f\u000e\u0003MI!AH\n\u0003)\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002\u001d\u0001\u0005)RM\\1cY\u0016|eMZ:fiN\u0014\u0015\r^2iS:<W#\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u000f\t{w\u000e\\3b]\u00061RM\\1cY\u0016|eMZ:fiN\u0014\u0015\r^2iS:<\u0007%A\u0006bGRLwN\\)vKV,W#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A:\u0012AB:feZ,'/\u0003\u00023_\tY\u0011i\u0019;j_:\fV/Z;f\u0003=\t7\r^5p]F+X-^3`I\u0015\fHCA\u001b9!\t)c'\u0003\u00028M\t!QK\\5u\u0011\u001dIT!!AA\u00025\n1\u0001\u001f\u00132\u00031\t7\r^5p]F+X-^3!\u0003\u0015\u0019X\r^+q)\u0005)\u0004FA\u0004?!\ty\u0004*D\u0001A\u0015\t\t%)A\u0002ba&T!a\u0011#\u0002\u000f),\b/\u001b;fe*\u0011QIR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u0003%A\u0003\"fM>\u0014X-R1dQ\u0006qB/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:J]NKgn\u001a7f\u0005\u0006$8\r\u001b\u0015\u0003\u00111\u0003\"aP'\n\u00059\u0003%\u0001\u0002+fgR\f1\u0005^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;t\u000fJ,\u0017\r^3s)\"\fg.T:h'&TX\r\u000b\u0002\n\u0019\u0006\tD/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:Nk2$\u0018\u000e\u001d7f\u000fJ|W\u000f]:B]\u0012lU\u000f\u001c;ja2,')\u0019;dQ\u0016\u001c\bF\u0001\u0006M\u0003\t\"Xm\u001d;D_6l\u0017\u000e^(gMN,Go]#yG\u0016\u0004H/[8o%\u0016\u001cwN^3ss\"\u00121\u0002T\u0001*i\u0016\u001cHoQ8n[&$xJ\u001a4tKR\u001c\b+\u0019:uS\u0006dW\t_2faRLwN\u001c*fG>4XM]=)\u00051a\u0015a\u0007<bY&$\u0017\r^3PM\u001a\u001cX\r^\"p[6LGOR;ukJ,7\u000f\u0006\u000363.<\b\"\u0002.\u000e\u0001\u0004Y\u0016aE2p[6LGo\u00144gg\u0016$h)\u001e;ve\u0016\u001c\bc\u0001/`C6\tQL\u0003\u0002_M\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001l&aA*fcB\u0019!-Z4\u000e\u0003\rT!\u0001\u001a\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002gG\n1a)\u001e;ve\u0016\u0004\"\u0001[5\u000e\u0003\u0001I!A[\u000f\u00035\r{W.\\5u\u001f\u001a47/\u001a;DC2d'-Y2l!\u0006\u0014\u0018-\\:\t\u000b1l\u0001\u0019A7\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u00042\u0001X0o!\tyW/D\u0001q\u0015\t\t(/\u0001\u0004d_6lwN\u001c\u0006\u00031MT!\u0001\u001e$\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t1\bO\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\")\u00010\u0004a\u0001s\u0006)QM\u001d:peB\u0011!0`\u0007\u0002w*\u0011A\u0010]\u0001\taJ|Go\\2pY&\u0011ap\u001f\u0002\u0007\u000bJ\u0014xN]:\u0002%\r|W.\\5u\u001f\u001a47/\u001a;t\u0005\u0006$8\r\u001b\u000b\r\u0003\u0007\tI!a\t\u0002&\u0005e\u00121\t\t\u0005K\u0005\u0015\u0011-C\u0002\u0002\b\u0019\u0012Q!\u0011:sCfDq!a\u0003\u000f\u0001\u0004\ti!A\u0004he>,\b/\u00133\u0011\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tI\u0002E\u0002\u0002\u0014\u0019j!!!\u0006\u000b\u0007\u0005]\u0011$\u0001\u0004=e>|GOP\u0005\u0004\u000371\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"AB*ue&twMC\u0002\u0002\u001c\u0019BQ\u0001\u001c\bA\u00025Dq!a\n\u000f\u0001\u0004\tI#A\tok6\u001cu.\\7jiJ+\u0017/^3tiN\u0004B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003mC:<'BAA\u001a\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012Q\u0006\u0002\b\u0013:$XmZ3s\u0011\u001d\tYD\u0004a\u0001\u0003{\t1b\u001c4gg\u0016$8\u000b^1siB\u0019Q%a\u0010\n\u0007\u0005\u0005cE\u0001\u0003M_:<\u0007\"CA#\u001dA\u0005\t\u0019AA$\u00039i\u0017\r_'fgN\fw-Z*ju\u0016\u00042!JA%\u0013\r\tYE\n\u0002\u0004\u0013:$\u0018\u0001H2p[6LGo\u00144gg\u0016$8OQ1uG\"$C-\u001a4bk2$H%N\u000b\u0003\u0003#RC!a\u0012\u0002T-\u0012\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003%)hn\u00195fG.,GMC\u0002\u0002`\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019'!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nd_6l\u0017\u000e^(gMN,Go]!ts:\u001cG#D1\u0002j\u0005-\u0014qNA:\u0003\u000f\u000b\t\nC\u0004\u0002\fA\u0001\r!!\u0004\t\u000f\u00055\u0004\u00031\u0001\u0002\u000e\u0005AQ.Z7cKJLE\rC\u0004\u0002rA\u0001\r!a\u0012\u0002\u0019\u001d,g.\u001a:bi&|g.\u00133\t\u000f\u0005U\u0004\u00031\u0001\u0002x\u00059qN\u001a4tKR\u001c\bcBA\b\u0003sr\u0017QP\u0005\u0005\u0003w\n\tCA\u0002NCB\u0004B!a \u0002\u00046\u0011\u0011\u0011\u0011\u0006\u0003c^IA!!\"\u0002\u0002\n\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\u0005%\u0005\u00031\u0001\u0002\f\u0006yqM]8va&s7\u000f^1oG\u0016LE\rE\u0003&\u0003\u001b\u000bi!C\u0002\u0002\u0010\u001a\u0012aa\u00149uS>t\u0007bBA#!\u0001\u0007\u0011qI\u0001\u0015CB\u0004XM\u001c3SK\u000e|'\u000fZ:Tk\u000e\u001cWm]:\u0015\u000bU\n9*!5\t\u000f\u0005e\u0015\u00031\u0001\u0002\u001c\u0006\u00012-\u00199ukJ,GmQ1mY\n\f7m\u001b\t\u0007K\u0005u\u0015\u0011U\u001b\n\u0007\u0005}eEA\u0005Gk:\u001cG/[8ocA9A,a)\u0002&\u0006-\u0016bAA>;B\u0019q.a*\n\u0007\u0005%\u0006O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u00055\u00161\u001a\b\u0005\u0003_\u000b)M\u0004\u0003\u00022\u0006\u0005g\u0002BAZ\u0003\u007fsA!!.\u0002>:!\u0011qWA^\u001d\u0011\t\u0019\"!/\n\u0003\u001dK!\u0001\u001e$\n\u0005a\u0019\u0018BA9s\u0013\r\t\u0019\r]\u0001\te\u0016\fX/Z:ug&!\u0011qYAe\u0003=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,'bAAba&!\u0011QZAh\u0005E\u0001\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003\u000f\fI\rC\u0004\u0002TF\u0001\r!!6\u0002\u001f\r\f\u0007\u000f^;sK\u0012\u0014VmY8sIN\u0004r\u0001XAR\u0003K\u000b9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\ti\u000e]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005\u0005\u00181\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:")
public class GroupCoordinatorBatchingOffsetsTest
extends GroupCoordinatorTest {
    private final boolean enableOffsetsBatching;
    private ActionQueue actionQueue;

    @Override
    public boolean enableOffsetsBatching() {
        return this.enableOffsetsBatching;
    }

    private ActionQueue actionQueue() {
        return this.actionQueue;
    }

    private void actionQueue_$eq(ActionQueue x$1) {
        this.actionQueue = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.actionQueue_$eq((ActionQueue)new DelayedActionQueue());
    }

    @Test
    public void testCommitOffsetsInSingleBatch() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 15;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ArrayBuffer topicIdPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tIter -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), partitions).foreach((Function1 & Serializable)pIter -> GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsInSingleBatch$2(topicIdPartitions, tIter, BoxesRunTime.unboxToInt((Object)pIter))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        this.groupCoordinator().shutdownOffsetCommitThreads();
        Object[] commitOffsetFutures = this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, 0x10000C);
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)commitRequests, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(commitOffsetFutures)));
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)Predef$.MODULE$.wrapRefArray(commitOffsetFutures), (Seq<TopicIdPartition>)topicIdPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).tryCompleteActions();
        IntRef expectedOffset = IntRef.create((int)baseOffset);
        topicPartitions.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsInSingleBatch$3(this, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCommitOffsetsGreaterThanMsgSize() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 15;
        int baseOffset = 31;
        ArrayBuffer topicIdPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int maxMessageSize = 1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tIter -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), partitions).foreach((Function1 & Serializable)pIter -> GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsGreaterThanMsgSize$2(topicIdPartitions, tIter, BoxesRunTime.unboxToInt((Object)pIter))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        this.groupCoordinator().shutdownOffsetCommitThreads();
        Object[] commitOffsetFutures = this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, maxMessageSize);
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)commitRequests, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(commitOffsetFutures)));
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)Predef$.MODULE$.wrapRefArray(commitOffsetFutures), (Seq<TopicIdPartition>)topicIdPartitions, Errors.INVALID_COMMIT_OFFSET_SIZE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)0))).tryCompleteActions();
    }

    @Test
    public void testCommitOffsetsMultipleGroupsAndMultipleBatches() {
        int topics = 3;
        .colon.colon groupIds = new .colon.colon((Object)this.groupId(), (List)new .colon.colon((Object)this.otherGroupId(), (List)Nil$.MODULE$));
        int partitions = 20;
        int commitRequests = 30;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ArrayBuffer topicIdPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int maxMessageSize = 10000;
        ArrayBuffer commitOffsetFutures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int otherGroupPartitionId = this.groupCoordinator().partitionFor(this.otherGroupId());
        this.groupCoordinator().groupManager().addOwnedPartition(otherGroupPartitionId);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__consumer_offsets", otherGroupPartitionId))).thenReturn((Object)new Some((Object)this.logConfig()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tIter -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), partitions).foreach((Function1 & Serializable)pIter -> GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$2(topicIdPartitions, tIter, BoxesRunTime.unboxToInt((Object)pIter))));
        groupIds.foreach((Function1 & Serializable)groupId -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$3(this, groupId);
            return BoxedUnit.UNIT;
        });
        this.groupCoordinator().shutdownOffsetCommitThreads();
        groupIds.foreach((Function1 & Serializable)groupId -> (ArrayBuffer)commitOffsetFutures.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch((String)groupId, (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, maxMessageSize))));
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)(commitRequests * groupIds.size()), (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)commitOffsetFutures, (Seq<TopicIdPartition>)topicIdPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeast((int)(groupIds.size() * 2)))).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)groupIds.size()))).getMagicFromConfig(this.logConfig());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)groupIds.size()))).tryCompleteActions();
        groupIds.foreach((Function1 & Serializable)groupId -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$5(this, baseOffset, topicPartitions, groupId);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCommitOffsetsExceptionRecovery() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 1;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ArrayBuffer topicIdPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tIter -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), partitions).foreach((Function1 & Serializable)pIter -> GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsExceptionRecovery$2(topicIdPartitions, tIter, BoxesRunTime.unboxToInt((Object)pIter))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__consumer_offsets", this.groupPartitionId()))).thenThrow(new Throwable[]{new RuntimeException("Test exception")}).thenReturn((Object)new Some((Object)this.logConfig()));
        ArraySeq.ofRef commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, 0x10000C));
        Assertions.assertEquals((int)commitRequests, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)commitOffsetFutures, (Seq<TopicIdPartition>)topicIdPartitions, Errors.UNKNOWN_SERVER_ERROR);
        commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, 0x10000C));
        Assertions.assertEquals((int)commitRequests, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)commitOffsetFutures, (Seq<TopicIdPartition>)topicIdPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).tryCompleteActions();
        IntRef expectedOffset = IntRef.create((int)baseOffset);
        topicPartitions.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsExceptionRecovery$3(this, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCommitOffsetsPartialExceptionRecovery() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 30;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ArrayBuffer topicIdPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int maxMessageSize = 10000;
        ArgumentCaptor capturedRecords = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tIter -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), partitions).foreach((Function1 & Serializable)pIter -> GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsPartialExceptionRecovery$2(topicIdPartitions, tIter, BoxesRunTime.unboxToInt((Object)pIter))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        this.groupCoordinator().shutdownOffsetCommitThreads();
        ArraySeq.ofRef commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, maxMessageSize));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__consumer_offsets", this.groupPartitionId()))).thenReturn((Object)new Some((Object)this.logConfig()));
        Mockito.when((Object)BoxesRunTime.boxToByte((byte)this.replicaManager().getMagicFromConfig(this.logConfig()))).thenReturn((Object)BoxesRunTime.boxToByte((byte)1));
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)capturedRecords.capture(), (Function1)capturedCallback.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsPartialExceptionRecovery$3(this, capturedCallback, capturedRecords, x$5);
            return BoxedUnit.UNIT;
        }).thenThrow(new Throwable[]{new RuntimeException("runtime exception")}).thenAnswer(x$6 -> {
            this.appendRecordsSuccess((Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)((Function1)capturedCallback.getValue()), (Map<TopicPartition, MemoryRecords>)((Map)capturedRecords.getValue()));
            return BoxedUnit.UNIT;
        });
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)commitRequests, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)new .colon.colon((Object)((Future)commitOffsetFutures.head()), (List)Nil$.MODULE$), (Seq<TopicIdPartition>)topicIdPartitions, Errors.NONE);
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)new .colon.colon((Object)((Future)commitOffsetFutures.last()), (List)Nil$.MODULE$), (Seq<TopicIdPartition>)topicIdPartitions, Errors.UNKNOWN_SERVER_ERROR);
        commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicIdPartition>)topicIdPartitions, Predef$.MODULE$.int2Integer(1), baseOffset, 0x10000C));
        Assertions.assertEquals((int)1, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>>)commitOffsetFutures, (Seq<TopicIdPartition>)topicIdPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeast((int)3))).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getMagicFromConfig(this.logConfig());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).tryCompleteActions();
        IntRef expectedOffset = IntRef.create((int)baseOffset);
        topicPartitions.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsPartialExceptionRecovery$5(this, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void validateOffsetCommitFutures(Seq<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>> commitOffsetFutures, Seq<TopicIdPartition> topicPartitions, Errors error) {
        commitOffsetFutures.foreach((Function1 & Serializable)futureResult -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$validateOffsetCommitFutures$1(topicPartitions, error, futureResult);
            return BoxedUnit.UNIT;
        });
    }

    private Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>[] commitOffsetsBatch(String groupId, Seq<TopicIdPartition> topicPartitions, Integer numCommitRequests, long offsetStart, int maxMessageSize) {
        ArrayBuffer commitOffsetFuturesList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        LongRef offsetIter = LongRef.create((long)offsetStart);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), Predef$.MODULE$.Integer2int(numCommitRequests)).foreach((Function1 & Serializable)x$8 -> GroupCoordinatorBatchingOffsetsTest.$anonfun$commitOffsetsBatch$1(this, topicPartitions, offsetIter, commitOffsetFuturesList, groupId, maxMessageSize, BoxesRunTime.unboxToInt((Object)x$8)));
        return (Future[])commitOffsetFuturesList.toArray(ClassTag$.MODULE$.apply(Future.class));
    }

    private int commitOffsetsBatch$default$5() {
        return 0x10000C;
    }

    /*
     * WARNING - void declaration
     */
    private Future<scala.collection.immutable.Map<TopicIdPartition, Errors>> commitOffsetsAsync(String groupId, String memberId, int generationId, scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata> offsets, Option<String> groupInstanceId, int maxMessageSize) {
        void var8_8;
        void var9_9;
        Tuple2<Future<scala.collection.immutable.Map<TopicIdPartition, Errors>>, Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>> tuple2 = this.setupCommitOffsetsCallback();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Future responseFuture = (Future)tuple2._1();
        Function1 responseCallback = (Function1)tuple2._2();
        ArgumentCaptor capturedRecords = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)capturedRecords.capture(), (Function1)capturedCallback.capture(), (Function0)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$10 -> {
            this.appendRecordsSuccess((Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)((Function1)capturedCallback.getValue()), (Map<TopicPartition, MemoryRecords>)((Map)capturedRecords.getValue()));
            return BoxedUnit.UNIT;
        });
        this.replicaManager().tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$11 -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$commitOffsetsAsync$2(this, x$11);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)BoxesRunTime.boxToByte((byte)this.replicaManager().getMagicFromConfig(this.logConfig()))).thenReturn((Object)BoxesRunTime.boxToByte((byte)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.logConfig().maxMessageSize())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxMessageSize));
        GroupCoordinator qual$1 = this.groupCoordinator();
        RequestLocal x$7 = qual$1.handleCommitOffsets$default$7();
        qual$1.handleCommitOffsets(groupId, memberId, groupInstanceId, generationId, offsets, (Function1)var9_9, x$7);
        return var8_8;
    }

    public void appendRecordsSuccess(Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit> capturedCallback, Map<TopicPartition, MemoryRecords> capturedRecords) {
        this.actionQueue().add((Function0)(JFunction0.mcV.sp & Serializable)() -> capturedCallback.apply(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", ((TopicPartition)((Tuple2)capturedRecords.toList().head())._1()).partition())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))}))));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testCommitOffsetsInSingleBatch$2(ArrayBuffer topicIdPartitions$1, int tIter$1, int pIter) {
        return (ArrayBuffer)topicIdPartitions$1.append((Object)new TopicIdPartition(Uuid.randomUuid(), pIter, new StringBuilder(5).append("topic").append(tIter$1).toString()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsInSingleBatch$3(GroupCoordinatorBatchingOffsetsTest $this, IntRef expectedOffset$1, TopicPartition tp) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets($this.groupId(), $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        Assertions.assertEquals((Object)Errors.NONE, (Object)var4_4);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)var5_5.get((Object)tp).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$1.elem, (long)offset.offset);
        ++expectedOffset$1.elem;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testCommitOffsetsGreaterThanMsgSize$2(ArrayBuffer topicIdPartitions$2, int tIter$2, int pIter) {
        return (ArrayBuffer)topicIdPartitions$2.append((Object)new TopicIdPartition(Uuid.randomUuid(), pIter, new StringBuilder(5).append("topic").append(tIter$2).toString()));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$2(ArrayBuffer topicIdPartitions$3, int tIter$3, int pIter) {
        return (ArrayBuffer)topicIdPartitions$3.append((Object)new TopicIdPartition(Uuid.randomUuid(), pIter, new StringBuilder(5).append("topic").append(tIter$3).toString()));
    }

    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$3(GroupCoordinatorBatchingOffsetsTest $this, String groupId) {
        GroupCoordinator qual$1 = $this.groupCoordinator();
        boolean x$2 = $this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(groupId, x$2, x$3));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$6(GroupCoordinatorBatchingOffsetsTest $this, String groupId$1, IntRef expectedOffset$2, TopicPartition tp) {
        void var6_6;
        void var5_5;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets(groupId$1, $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        Assertions.assertEquals((Object)Errors.NONE, (Object)var5_5);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)var6_6.get((Object)tp).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$2.elem, (long)offset.offset);
        ++expectedOffset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$5(GroupCoordinatorBatchingOffsetsTest $this, int baseOffset$1, ArrayBuffer topicPartitions$1, String groupId) {
        IntRef expectedOffset = IntRef.create((int)baseOffset$1);
        topicPartitions$1.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$6($this, groupId, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testCommitOffsetsExceptionRecovery$2(ArrayBuffer topicIdPartitions$4, int tIter$4, int pIter) {
        return (ArrayBuffer)topicIdPartitions$4.append((Object)new TopicIdPartition(Uuid.randomUuid(), pIter, new StringBuilder(5).append("topic").append(tIter$4).toString()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsExceptionRecovery$3(GroupCoordinatorBatchingOffsetsTest $this, IntRef expectedOffset$3, TopicPartition tp) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets($this.groupId(), $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        Assertions.assertEquals((Object)Errors.NONE, (Object)var4_4);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)var5_5.get((Object)tp).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$3.elem, (long)offset.offset);
        ++expectedOffset$3.elem;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$testCommitOffsetsPartialExceptionRecovery$2(ArrayBuffer topicIdPartitions$5, int tIter$5, int pIter) {
        return (ArrayBuffer)topicIdPartitions$5.append((Object)new TopicIdPartition(Uuid.randomUuid(), pIter, new StringBuilder(5).append("topic").append(tIter$5).toString()));
    }

    public static final /* synthetic */ void $anonfun$testCommitOffsetsPartialExceptionRecovery$3(GroupCoordinatorBatchingOffsetsTest $this, ArgumentCaptor capturedCallback$1, ArgumentCaptor capturedRecords$1, InvocationOnMock x$5) {
        $this.appendRecordsSuccess((Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)((Function1)capturedCallback$1.getValue()), (Map<TopicPartition, MemoryRecords>)((Map)capturedRecords$1.getValue()));
        $this.actionQueue().tryCompleteActions();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsPartialExceptionRecovery$5(GroupCoordinatorBatchingOffsetsTest $this, IntRef expectedOffset$4, TopicPartition tp) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets($this.groupId(), $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        Assertions.assertEquals((Object)Errors.NONE, (Object)var4_4);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)var5_5.get((Object)tp).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$4.elem, (long)offset.offset);
        ++expectedOffset$4.elem;
    }

    public static final /* synthetic */ void $anonfun$validateOffsetCommitFutures$2(Errors error$1, scala.collection.immutable.Map commitOffsetResult$1, TopicIdPartition tp) {
        Assertions.assertEquals((Object)error$1, (Object)commitOffsetResult$1.apply((Object)tp));
    }

    public static final /* synthetic */ void $anonfun$validateOffsetCommitFutures$1(Seq topicPartitions$2, Errors error$1, Future futureResult) {
        scala.collection.immutable.Map commitOffsetResult = (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)futureResult, (Duration)Duration$.MODULE$.apply(15000L, TimeUnit.MILLISECONDS));
        topicPartitions$2.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$validateOffsetCommitFutures$2(error$1, commitOffsetResult, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)topicPartitions$2.size(), (int)commitOffsetResult.size());
    }

    public static final /* synthetic */ void $anonfun$commitOffsetsBatch$2(GroupCoordinatorBatchingOffsetsTest $this, LongRef offsetIter$1, scala.collection.mutable.Map offsets$1, TopicIdPartition tp) {
        OffsetAndMetadata offset = $this.offsetAndMetadata(offsetIter$1.elem);
        offsets$1.update((Object)tp, (Object)offset);
        ++offsetIter$1.elem;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$commitOffsetsBatch$1(GroupCoordinatorBatchingOffsetsTest $this, Seq topicPartitions$3, LongRef offsetIter$1, ArrayBuffer commitOffsetFuturesList$1, String groupId$2, int maxMessageSize$2, int x$8) {
        scala.collection.mutable.Map offsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        topicPartitions$3.foreach((Function1 & Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$commitOffsetsBatch$2($this, offsetIter$1, offsets, tp);
            return BoxedUnit.UNIT;
        });
        return (ArrayBuffer)commitOffsetFuturesList$1.append($this.commitOffsetsAsync(groupId$2, "", -1, (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)offsets.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<String>)None$.MODULE$, maxMessageSize$2));
    }

    public static final /* synthetic */ void $anonfun$commitOffsetsAsync$2(GroupCoordinatorBatchingOffsetsTest $this, InvocationOnMock x$11) {
        $this.actionQueue().tryCompleteActions();
    }

    public GroupCoordinatorBatchingOffsetsTest() {
        this.enableOffsetsBatching = true;
    }
}

