/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.TestClientQuotaCallback;
import kafka.coordinator.quota.TestClientQuotaCallback$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00048\u0001\u0001\u0006I!\r\u0005\bq\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003\u0001\u0004BB\u001e\u0001A\u0003%\u0011\u0007C\u0004=\u0001\t\u0007I\u0011\u0001\u0019\t\ru\u0002\u0001\u0015!\u00032\u0011\u001dq\u0004A1A\u0005\u0002ABaa\u0010\u0001!\u0002\u0013\t\u0004\"\u0003!\u0001\u0001\u0004\u0005\r\u0011\"\u0001B\u0011%y\u0005\u00011AA\u0002\u0013\u0005\u0001\u000bC\u0005W\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\"Iq\u000b\u0001a\u0001\u0002\u0004%\t\u0001\u0017\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001D\u0011B\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B-\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0003!\u0007\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0001m\u0011%q\u0007\u00011A\u0001B\u0003&Q\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA3\u0001\u0011%\u0011q\r\u0005\n\u0003_\u0003\u0011\u0013!C\u0005\u0003cCa!a2\u0001\t#\u0002$!\u0005#z]\u0006l\u0017nY)v_R\f7\u000fV3ti*\u0011adH\u0001\u0006cV|G/\u0019\u0006\u0003A\u0005\n1bY8pe\u0012Lg.\u0019;pe*\t!%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\"\u0003\r\t\u0007/[\u0005\u0003U\u001d\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003u\t!B\\;n'\u0016\u0014h/\u001a:t+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$aA%oi\u0006Ya.^7TKJ4XM]:!\u0003aqW/\\)v_R\f7\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u0001\u001a]Vl\u0017+^8uCN$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0004ce>\\WM\u001d\u0019\u0002\u0011\t\u0014xn[3sa\u0001\nqA\u0019:pW\u0016\u0014\u0018'\u0001\u0005ce>\\WM]\u0019!\u0003M\u0011'o\\6fe2KW.\u001b;Qe>$WoY3s\u0003Q\u0011'o\\6fe2KW.\u001b;Qe>$WoY3sA\u0005!A/[7f+\u0005\u0011\u0005CA\"N\u001b\u0005!%BA#G\u0003\u0015)H/\u001b7t\u0015\t9\u0005*\u0001\u0004d_6lwN\u001c\u0006\u0003E%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011a\n\u0012\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\t\tF\u000b\u0005\u00023%&\u00111k\r\u0002\u0005+:LG\u000fC\u0004V\u001b\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013'A\u0003uS6,\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A,I\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005y[&aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\t\t\u0016\rC\u0004V!\u0005\u0005\t\u0019A-\u0002\u000f\r|gNZ5hA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\"\u000bqa\u00197jK:$8/\u0003\u0002kO\nia*\u001a;x_J\\7\t\\5f]R\f\u0011C\\3uo>\u00148n\u00117jK:$x\fJ3r)\t\tV\u000eC\u0004V'\u0005\u0005\t\u0019A3\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA\u0005)1/\u001a;VaR\u0011\u0011+\u001d\u0005\u0006eV\u0001\ra]\u0001\ti\u0016\u001cH/\u00138g_B\u0011AO_\u0007\u0002k*\u0011\u0001F\u001e\u0006\u0003ob\fqA[;qSR,'O\u0003\u0002z\u0017\u0006)!.\u001e8ji&\u001110\u001e\u0002\t)\u0016\u001cH/\u00138g_\"\u0012Q# \t\u0003izL!a`;\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000buKN$(+\u001a9peR\u001cuN\\:v[B$\u0018n\u001c8\u0015\u0007E\u000b)\u0001C\u0004\u0002\bY\u0001\r!!\u0003\u0002\rE,xN];n!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001f\u0019TBAA\t\u0015\r\t\u0019bI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]1'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/\u0019\u0004f\u0002\f\u0002\"\u00055\u0012q\u0006\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005<\u0002\rA\f'/Y7t\u0013\u0011\tY#!\n\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u0019\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":a#!\u000e\u0002B\u0005\r\u0003\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u0012QE\u0001\taJ|g/\u001b3fe&!\u0011qHA\u001d\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011QIA%C\t\t9%\u0001\u0002{W\u0006\u0012\u00111J\u0001\u0006WJ\fg\r^\u0001\u0018i\u0016\u001cH/U;pi\u0006\u001cHk\u001c9jG\u001a\u000b\u0017\u000e\\8wKJ$2!UA)\u0011\u001d\t9a\u0006a\u0001\u0003\u0013AsaFA\u0011\u0003[\ty\u0003K\u0004\u0018\u0003k\t\t%a\u0016-\t\u0005\u0015\u0013\u0011J\u0001\u0014i\u0016\u001cH/U;pi\u0006,\u0005\u0010]5sCRLwN\u001c\u000b\u0004#\u0006u\u0003bBA\u00041\u0001\u0007\u0011\u0011\u0002\u0015\b1\u0005\u0005\u0012QFA\u0018Q\u001dA\u0012QGA!\u0003GbC!!\u0012\u0002J\u0005\tr-\u001a;SKF,Xm\u001d;Ck&dG-\u001a:\u0015\u0019\u0005%\u0014QPAA\u0003\u0017\u000bY*!*\u0011\t\u0005-\u0014q\u000f\b\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f$\u0002\u0011I,\u0017/^3tiNLA!!\u001e\u0002p\u0005i\"+\u001a9peR\fVo\u001c;b\u0007>t7/^7qi&|gNU3rk\u0016\u001cH/\u0003\u0003\u0002z\u0005m$a\u0002\"vS2$WM\u001d\u0006\u0005\u0003k\ny\u0007\u0003\u0004\u0002\u0000e\u0001\r!M\u0001\tEJ|7.\u001a:JI\"9\u00111Q\rA\u0002\u0005\u0015\u0015aC9v_R\fWI\u001c;jif\u00042ALAD\u0013\r\tI)\b\u0002\f#V|G/Y#oi&$\u0018\u0010C\u0004\u0002\u000ef\u0001\r!a$\u0002\u001f\rd\u0017.\u001a8u#V|G/\u0019+za\u0016\u0004B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004=\u0005U%B\u0001/I\u0013\u0011\tI*a%\u0003\u001f\rc\u0017.\u001a8u#V|G/\u0019+za\u0016Dq!!(\u001a\u0001\u0004\ty*A\u0003vg\u0006<W\rE\u00023\u0003CK1!a)4\u0005\u0019!u.\u001e2mK\"I\u0011qU\r\u0011\u0002\u0003\u0007\u0011\u0011V\u0001\ni\"\u0014x\u000e\u001e;mK\u0012\u00042AMAV\u0013\r\tik\r\u0002\b\u0005>|G.Z1o\u0003m9W\r\u001e*fcV,7\u000f\u001e\"vS2$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u0017\u0016\u0005\u0003S\u000b)l\u000b\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016!C;oG\",7m[3e\u0015\r\t\tmM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003w\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-\u0011'o\\6fe\u000e{WO\u001c;")
public class DynamicQuotasTest
extends IntegrationTestHarness {
    private final int numServers;
    private final int numQuotasTopicPartitions;
    private final int broker0;
    private final int broker1;
    private final int brokerLimitProducer;
    private Time time;
    private KafkaConfig config;
    private NetworkClient networkClient;

    public int numServers() {
        return this.numServers;
    }

    public int numQuotasTopicPartitions() {
        return this.numQuotasTopicPartitions;
    }

    public int broker0() {
        return this.broker0;
    }

    public int broker1() {
        return this.broker1;
    }

    public int brokerLimitProducer() {
        return this.brokerLimitProducer;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(NetworkClient x$1) {
        this.networkClient = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_listenerName;
        void clientChannelBuilder_config;
        void clientChannelBuilder_contextType;
        this.serverConfig().put(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasTopicPartitionsProp(), Integer.toString(this.numQuotasTopicPartitions()));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasTopicReplicationFactorProp(), Integer.toString(2));
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestClientQuotaCallback.class.getName());
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp(), Integer.toString(0));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasExpirationIntervalMsProp(), Integer.toString(2000));
        this.serverConfig().put("confluent.quota.tenant.broker.max.producer.rate", Integer.toString(this.brokerLimitProducer()));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasLazyEvaluationThresholdProp(), Integer.toString(0));
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), "_confluent-quotas", this.numQuotasTopicPartitions());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            DynamicQuotasTest.$anonfun$setUp$1(broker);
            return BoxedUnit.UNIT;
        });
        this.config_$eq(((KafkaBroker)this.brokers().head()).config());
        this.time_$eq(((KafkaBroker)this.brokers().head()).time());
        Metrics metrics = ((KafkaBroker)this.brokers().head()).metrics();
        LogContext logContext = new LogContext("DynamicQuotasTest ");
        boolean bl = this.config().saslInterBrokerHandshakeRequestEnable();
        Time time = this.time();
        String string = this.config().saslMechanismInterBrokerProtocol();
        ListenerName listenerName = this.config().interBrokerListenerName();
        KafkaConfig kafkaConfig = this.config();
        JaasContext.Type type = JaasContext.Type.SERVER;
        SecurityProtocol clientChannelBuilder_securityProtocol = this.config().interBrokerSecurityProtocol();
        Object var6_10 = null;
        type = null;
        kafkaConfig = null;
        listenerName = null;
        string = null;
        time = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)clientChannelBuilder_securityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)clientChannelBuilder_listenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)logContext, null, null);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), metrics, this.time(), "dynamic-quota-test-client-metrics", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), false, channelBuilder, logContext);
        this.networkClient_$eq(new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), "dynamic-quota-test-client", 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(this.config().socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMaxMs()), this.time(), false, new ApiVersions(), logContext));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReportConsumption(String quorum) {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        Node coordinatorNode = node;
        this.brokers().foreach((Function1 & Serializable)broker -> {
            int brokerId = broker.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, false);
            ClientRequest request = this.networkClient().newClientRequest(coordinatorNode.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$1(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)coordinatorNode, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(coordinatorNode).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(coordinatorNode.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            DynamicQuotasTest.$anonfun$testReportConsumption$3(quotas, broker);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testQuotasTopicFailover(String quorum) {
        void var26_25;
        void var27_26;
        Node node;
        void var18_18;
        void var19_19;
        Node node2;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        double usageBroker0 = 1000.0;
        double usageBroker1 = 2000.0;
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        int initialLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), "_confluent-quotas", partition, 15000L).leader();
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node2 = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node2 = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        Node coordinatorNode = node2;
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker0 = this.getRequestBuilder(this.broker0(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker0, false);
        ClientRequest requestBroker0 = this.networkClient().newClientRequest(coordinatorNode.idString(), (AbstractRequest.Builder)requestBuilderBroker0, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)coordinatorNode, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(coordinatorNode).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)requestBroker0, (Time)this.time());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicQuotasTest.$anonfun$testQuotasTopicFailover$2(this, initialLeader, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$testQuotasTopicFailover$3(initialLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long lastUpdatedTimestamp = ((QuotaEntry)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(initialLeader)).quotaCoordinatorOpt().get()).quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp();
        ((KafkaBroker)this.brokers().apply(initialLeader)).shutdown();
        ((KafkaBroker)this.brokers().apply(initialLeader)).awaitShutdown();
        int newLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), "_confluent-quotas", partition, 15000L).leader();
        QuotaCoordinator newCoordinator = (QuotaCoordinator)((KafkaBroker)this.brokers().apply(newLeader)).quotaCoordinatorOpt().get();
        Tuple2 tuple2 = newCoordinator.describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription loadedQuota = (QuotaDescription)tuple2._2();
        double quotaValue = BoxesRunTime.unboxToDouble((Object)((MapOps)var19_19.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)var18_18, (String)new StringBuilder(37).append("Got error ").append(var18_18).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)this.brokerLimitProducer(), (double)quotaValue, (String)new StringBuilder(44).append("Loaded quotas ").append(quotaValue).append(" did not match expected quota ").append(this.brokerLimitProducer()).toString());
        Assertions.assertEquals((long)lastUpdatedTimestamp, (long)((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp(), (String)new StringBuilder(63).append("Loaded last update timestamp ").append(((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp()).append(" ").append("did not match expected timestamp ").append(lastUpdatedTimestamp).toString());
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker1 = this.getRequestBuilder(this.broker1(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker1, false);
        Option option2 = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option2 instanceof Some) {
            node = (Node)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option2);
        }
        coordinatorNode = node;
        ClientRequest request = this.networkClient().newClientRequest(coordinatorNode.idString(), (AbstractRequest.Builder)requestBuilderBroker1, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)coordinatorNode, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(coordinatorNode).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        Tuple2 tuple22 = newCoordinator.describeQuota(quotaEntity);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Errors newError = (Errors)tuple22._1();
        QuotaDescription newLoadedQuota = (QuotaDescription)tuple22._2();
        double quotaValueBroker0 = BoxesRunTime.unboxToDouble((Object)((MapOps)var27_26.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        double quotaValueBroker1 = BoxesRunTime.unboxToDouble((Object)((MapOps)var27_26.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker1()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)var26_25, (String)new StringBuilder(37).append("Got error ").append(var26_25).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)40000.0, (double)quotaValueBroker0, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker0).append(" did not match expected quota 40000.0").toString());
        Assertions.assertEquals((double)80000.0, (double)quotaValueBroker1, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker1).append(" did not match expected quota 80000.0").toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testQuotaExpiration(String quorum) {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        Node coordinatorNode = node;
        this.brokers().foreach((Function1 & Serializable)broker -> {
            int brokerId = broker.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, false);
            ClientRequest request = this.networkClient().newClientRequest(coordinatorNode.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$3(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)coordinatorNode, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(coordinatorNode).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(coordinatorNode.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            DynamicQuotasTest.$anonfun$testQuotaExpiration$3(quotas, broker);
            return BoxedUnit.UNIT;
        });
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        alterableConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp()).setValue("5000").setConfigOperation(AlterConfigOp.OpType.SET.id()));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(alterableConfigs));
        IncrementalAlterConfigsRequest.Builder alterConfigRequestBuilder = new IncrementalAlterConfigsRequest.Builder(data);
        ClientRequest alterConfigsRequest = this.networkClient().newClientRequest(coordinatorNode.idString(), (AbstractRequest.Builder)alterConfigRequestBuilder, this.time().milliseconds(), true);
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)alterConfigsRequest, (Time)this.time());
        Thread.sleep(10000L);
        Tuple2 quotasAfterExpiration = ((QuotaCoordinator)((KafkaBroker)this.brokers().apply(coordinatorNode.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity);
        if (quotasAfterExpiration != null) {
            Errors error = (Errors)quotasAfterExpiration._1();
            QuotaDescription quotaDescription = (QuotaDescription)quotasAfterExpiration._2();
            if (error != null && quotaDescription != null) {
                Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)quotaDescription, (String)new StringBuilder(67).append("Got description ").append(quotaDescription).append(" when describing entity ").append(quotaEntity).append(", but expected an empty map").toString());
                Assertions.assertEquals((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)error, (String)new StringBuilder(24).append("Got error ").append(error).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
                return;
            }
        }
        throw new MatchError((Object)quotasAfterExpiration);
    }

    private ReportQuotaConsumptionRequest.Builder getRequestBuilder(int brokerId, QuotaEntity quotaEntity, ClientQuotaType clientQuotaType, double usage, boolean throttled) {
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        quotaEntity.entityTypes().foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicQuotasTest.$anonfun$getRequestBuilder$1(entryData, x0$1)));
        entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(clientQuotaType.toString()).setUsage(usage).setThrottled(throttled));
        ReportQuotaConsumptionRequestData requestData = new ReportQuotaConsumptionRequestData().setBrokerId(brokerId).setEntries(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entryData, (List)Nil$.MODULE$)).asJava());
        return new ReportQuotaConsumptionRequest.Builder(requestData);
    }

    private boolean getRequestBuilder$default$5() {
        return false;
    }

    @Override
    public int brokerCount() {
        return this.numServers();
    }

    public static final /* synthetic */ boolean $anonfun$setUp$2(AtomicBoolean eta$0$1$1) {
        return eta$0$1$1.get();
    }

    public static final /* synthetic */ String $anonfun$setUp$3(KafkaBroker broker$1) {
        return new StringBuilder(48).append("Quota coordinator on broker ").append(broker$1).append(" never became active").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setUp$1(KafkaBroker broker) {
        AtomicBoolean atomicBoolean = ((QuotaCoordinator)broker.quotaCoordinatorOpt().get()).isActive();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!atomicBoolean.get()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$setUp$3(broker));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private static final void requestCallback$1(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testReportConsumption$3(Map quotas$1, KafkaBroker broker) {
        int brokerId = broker.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapOps)quotas$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    private static final void requestCallback$2(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ boolean $anonfun$testQuotasTopicFailover$2(DynamicQuotasTest $this, int initialLeader$1, int partition$1) {
        boolean x$2;
        TopicPartition x$1;
        LogManager qual$1 = ((KafkaBroker)$this.brokers().apply(initialLeader$1)).logManager();
        return ((AbstractLog)qual$1.getLog(x$1 = new TopicPartition("_confluent-quotas", partition$1), x$2 = qual$1.getLog$default$2()).get()).highWatermark() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testQuotasTopicFailover$3(int initialLeader$1) {
        return new StringBuilder(65).append("Quota records were not successfully written to the log on broker ").append(initialLeader$1).toString();
    }

    private static final void requestCallback$3(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testQuotaExpiration$3(Map quotas$2, KafkaBroker broker) {
        int brokerId = broker.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapOps)quotas$2.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getRequestBuilder$1(ReportQuotaConsumptionRequestData.EntryData entryData$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String entityType = (String)x0$1._1();
            String entityName = (String)x0$1._2();
            return entryData$1.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        }
        throw new MatchError(null);
    }

    public DynamicQuotasTest() {
        this.numServers = 3;
        this.numQuotasTopicPartitions = 3;
        this.broker0 = 0;
        this.broker1 = 1;
        this.brokerLimitProducer = 80000;
    }
}

