/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\n1\u0002\u0001\r\u00111A\u0005\u0002eC\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011A4\t\u00135\u0004\u0001\u0019!A!B\u0013Q\u0006\"\u00038\u0001\u0001\u0004\u0005\r\u0011\"\u0001p\u0011%\u0019\b\u00011AA\u0002\u0013\u0005A\u000fC\u0005w\u0001\u0001\u0007\t\u0011)Q\u0005a\"9q\u000f\u0001a\u0001\n\u0003A\b\"CA\u0002\u0001\u0001\u0007I\u0011AA\u0003\u0011\u001d\tI\u0001\u0001Q!\neD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0015\u0011-\ti\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0004\t\u0017\u0005=\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\u0007\u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0004C\u0006\u0002D\u0001\u0001\r\u0011!Q!\n\u0005M\u0002bCA#\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000fB1\"a\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002R!Y\u0011Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA%\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%\t!!\u0017\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013\u0005\u00111\r\u0005\f\u0003O\u0002\u0001\u0019!A!B\u0013\tY\u0006C\u0005\u0002j\u0001\u0011\r\u0011\"\u0001\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0001\u0002l!A\u0011q\u000f\u0001!\u0002\u0013\ti\u0007C\u0005\u0002z\u0001\u0011\r\u0011\"\u0001\u0002|!A\u00111\u0011\u0001!\u0002\u0013\ti\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0001\u0002|!A\u0011q\u0011\u0001!\u0002\u0013\ti\bC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0001\u0002\f\"A\u00111\u0013\u0001!\u0002\u0013\ti\tC\u0005\u0002\u0016\u0002\u0011\r\u0011\"\u0001\u0002\f\"A\u0011q\u0013\u0001!\u0002\u0013\ti\tC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0001\u0002\u001c\"A\u00111\u0017\u0001!\u0002\u0013\ti\nC\u0005\u00026\u0002\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011q\u0017\u0001!\u0002\u0013\ti\nC\u0005\u0002:\u0002\u0011\r\u0011\"\u0001\u0002\u001c\"A\u00111\u0018\u0001!\u0002\u0013\ti\nC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005]\u0007\u0001\"\u0001\u0002@\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005}\u0006bBAs\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003S\u0004A\u0011AA`\u0011\u001d\ti\u000f\u0001C\u0001\u0003\u007fCq!!=\u0001\t\u0003\ty\fC\u0004\u0002v\u0002!\t!a0\t\u000f\u0005e\b\u0001\"\u0001\u0002@\"9\u0011Q \u0001\u0005\u0002\u0005}\u0006b\u0002B\u0001\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005\u000b\u0001A\u0011AA`\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003\u007fCqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!1\f\u0001\u0005\n\tu#\u0001F)v_R\f7i\\8sI&t\u0017\r^8s)\u0016\u001cHO\u0003\u0002?\u007f\u0005)\u0011/^8uC*\u0011\u0001)Q\u0001\fG>|'\u000fZ5oCR|'OC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A#\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0005\u0002O\u00015\tQ(\u0001\u0004d_:4\u0017nZ\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A+Q\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Y\u001b&aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0003uS6,W#\u0001.\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016\u0001B;uS2T!\u0001V0\u000b\u0005\t\u0003'BA1c\u0003\u0019\t\u0007/Y2iK*\t1-A\u0002pe\u001eL!!\u001a/\u0003\u00115{7m\u001b+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0003Q.\u0004\"AR5\n\u0005)<%\u0001B+oSRDq\u0001\\\u0003\u0002\u0002\u0003\u0007!,A\u0002yIE\nQ\u0001^5nK\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003A\u0004\"aW9\n\u0005Id&!D'pG.\u001c6\r[3ek2,'/A\u0007tG\",G-\u001e7fe~#S-\u001d\u000b\u0003QVDq\u0001\u001c\u0005\u0002\u0002\u0003\u0007\u0001/\u0001\u0006tG\",G-\u001e7fe\u0002\na\u0003^3oC:$X*\u001a;sS\u000e\u001c\b+\u001e2mSNDWM]\u000b\u0002sB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\b[\u0016$(/[2t\u0015\tqx,\u0001\u0006d_:$(o\u001c7mKJL1!!\u0001|\u0005Y!VM\\1oi6+GO]5dgB+(\r\\5tQ\u0016\u0014\u0018A\u0007;f]\u0006tG/T3ue&\u001c7\u000fU;cY&\u001c\b.\u001a:`I\u0015\fHc\u00015\u0002\b!9AnCA\u0001\u0002\u0004I\u0018a\u0006;f]\u0006tG/T3ue&\u001c7\u000fU;cY&\u001c\b.\u001a:!\u0003UIg\u000e^3s]\u0006d\u0017\tZ7j]N+\b\u000f\u001d7jKJ,\"!a\u0004\u0011\r\u0005E\u0011QDA\u0011\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007u\u000bIB\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"a\u0005\u0003\u0011M+\b\u000f\u001d7jKJ\u00042AUA\u0012\u0013\r\t)c\u0015\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u00023%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5fe~#S-\u001d\u000b\u0004Q\u0006-\u0002\u0002\u00037\u000f\u0003\u0003\u0005\r!a\u0004\u0002-%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5fe\u0002\n\u0011d\u00197vgR,'\u000fT3wK2\fVo\u001c;b\u0007\u0006dGNY1dWV\u0011\u00111\u0007\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0011aHX\u0005\u0005\u0003w\t9DA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017!H2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.|F%Z9\u0015\u0007!\f\t\u0005\u0003\u0005m#\u0005\u0005\t\u0019AA\u001a\u0003i\u0019G.^:uKJdUM^3m#V|G/Y\"bY2\u0014\u0017mY6!\u0003E\tXo\u001c;b'R\fG/Z'b]\u0006<WM]\u000b\u0003\u0003\u0013\u00022ATA&\u0013\r\ti%\u0010\u0002\u0012#V|G/Y*uCR,W*\u00198bO\u0016\u0014\u0018!F9v_R\f7\u000b^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0004Q\u0006M\u0003\u0002\u00037\u0015\u0003\u0003\u0005\r!!\u0013\u0002%E,x\u000e^1Ti\u0006$X-T1oC\u001e,'\u000fI\u0001\u0011cV|G/Y\"p_J$\u0017N\\1u_J,\"!a\u0017\u0011\u00079\u000bi&C\u0002\u0002`u\u0012\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0002)E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\rA\u0017Q\r\u0005\tY^\t\t\u00111\u0001\u0002\\\u0005\t\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0007\u0015\u00036+\u0006\u0002\u0002nA\u0019a)a\u001c\n\u0007\u0005EtI\u0001\u0004E_V\u0014G.Z\u0001\u0005\u000bB\u001b\u0006%\u0001\fdYV\u001cH/\u001a:UQJ|Wo\u001a5qkR\fVo\u001c;b\u0003]\u0019G.^:uKJ$\u0006N]8vO\"\u0004X\u000f^)v_R\f\u0007%A\nce>\\WM\u001d'j[&$\bK]8ek\u000e,'/\u0006\u0002\u0002~A\u0019a)a \n\u0007\u0005\u0005uIA\u0002J]R\fAC\u0019:pW\u0016\u0014H*[7jiB\u0013x\u000eZ;dKJ\u0004\u0013a\u00052s_.,'\u000fT5nSR\u001cuN\\:v[\u0016\u0014\u0018\u0001\u00062s_.,'\u000fT5nSR\u001cuN\\:v[\u0016\u0014\b%A\u0004f]RLG/_\u0019\u0016\u0005\u00055\u0005c\u0001(\u0002\u0010&\u0019\u0011\u0011S\u001f\u0003\u0017E+x\u000e^1F]RLG/_\u0001\tK:$\u0018\u000e^=2A\u00059QM\u001c;jif\u0014\u0014\u0001C3oi&$\u0018P\r\u0011\u00023\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'\u000fM\u000b\u0003\u0003;\u0003b!a(\u0002*\u00065VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013%lW.\u001e;bE2,'bAAT\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0004'\u0016\f\bc\u0001(\u00020&\u0019\u0011\u0011W\u001f\u00035E+x\u000e^1F]RLG/_!oI\u000e{gn];naRLwN\\:\u00025\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'\u000f\r\u0011\u00023\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'/M\u0001\u001bK:$\u0018\u000e^=D_:\u001cX/\u001c9uS>t7O\u0011:pW\u0016\u0014\u0018\u0007I\u0001\u001aK:$\u0018\u000e^=D_:\u001cX/\u001c9uS>t7O\u0011:pW\u0016\u0014('\u0001\u000ef]RLG/_\"p]N,X\u000e\u001d;j_:\u001c(I]8lKJ\u0014\u0004%A\u0003tKR,\u0006\u000fF\u0001iQ\rY\u00131\u0019\t\u0005\u0003\u000b\f\u0019.\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001b\fy-A\u0004kkBLG/\u001a:\u000b\u0007\u0005E'-A\u0003kk:LG/\u0003\u0003\u0002V\u0006\u001d'A\u0003\"fM>\u0014X-R1dQ\u0006!C/Z:u\u0007>l\u0007/\u001e;f#V|G/Y:J]\u0006\u001cG/\u001b<f\u0007>|'\u000fZ5oCR|'\u000fK\u0002-\u00037\u0004B!!2\u0002^&!\u0011q\\Ad\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^\"p[B,H/Z)v_R\f7/\u00138wC2LG-U;pi\u0006,e\u000e^5uS\u0016\u001c\bfA\u0017\u0002\\\u0006)C/Z:u\t\u0016\u001c8M]5cKF+x\u000e^1t\u0013:\f7\r^5wK\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004]\u0005m\u0017\u0001\n;fgR$Um]2sS\n,\u0017+^8uCN,e\u000e^5us\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007=\nY.A\u0016uKN$8i\\7qkR,\u0017I\u001c3EKN\u001c'/\u001b2f#V|G/Y:XSRD7)\u00199qK\u0012\fVo\u001c;bQ\r\u0001\u00141\\\u0001/i\u0016\u001cHoQ8naV$X-\u00118e\t\u0016\u001c8M]5cKF+x\u000e^1t+:,g/\u001a8ESN$(/\u001b2vi&|g\u000eK\u00022\u00037\f\u0011\u0006^3ti\u000e{W\u000e];uK\u0006sG\rR3tGJL'-Z)v_R\f7o\u00165f]RC'o\u001c;uY\u0016$\u0007f\u0001\u001a\u0002\\\u0006QB/Z:u\u000bb\u0004\u0018N]3Rk>$\u0018mQ8ogVl\u0007\u000f^5p]\"\u001a1'a7\u0002-Q,7\u000f^!mYj+'o\\\"p]N,X\u000e\u001d;j_:D3\u0001NAn\u00035\"Xm\u001d;Es:\fW.[2Rk>$\u0018MT8u)JLwmZ3sK\u0012<\u0016\u000e\u001e5M_^$\u0006N]8vO\"\u0004X\u000f\u001e\u0015\u0004k\u0005m\u0017!\n;fgRlU\r\u001e:jGN,6/Y4f+B$\u0017\r^3e\u0013:\u001c\u0015m\u00195f\r>\u0014XiQ&VQ\r1\u00141\\\u00013m\u0016\u0014\u0018NZ=EKN\u001c'/\u001b2f#V|G/Y:Jg:{GOU3ukJt\u0017N\\4ICJ$7m\u001c3fI6+GO]5dg\"\u001aq'a7\u0002+\r|W\u000e];uKF+x\u000e^1t\u0007\u0006dGNY1dWR\u0019\u0001N!\u0005\t\u000f\tM\u0001\b1\u0001\u0003\u0016\u00051!/Z:vYR\u00042A\u0014B\f\u0013\r\u0011I\"\u0010\u0002\u0012%\u0016\u0004xN\u001d;Rk>$\u0018MU3tk2$\u0018!\u0007<fe&4\u00170T3ue&\u001c7/V:bO\u0016LenQ1dQ\u0016$\u0012\u0002\u001bB\u0010\u0005G\u00119C!\u0011\t\u000f\t\u0005\u0012\b1\u0001\u0002~\u00051!M]8lKJDqA!\n:\u0001\u0004\ti)A\u0006rk>$\u0018-\u00128uSRL\bb\u0002B\u0015s\u0001\u0007!1F\u0001\u0010[\u0016$(/[2Rk>$\u0018\rV=qKB!!Q\u0006B\u001e\u001d\u0011\u0011yCa\u000e\u0011\u0007\tEr)\u0004\u0002\u00034)\u0019!QG\"\u0002\rq\u0012xn\u001c;?\u0013\r\u0011IdR\u0001\u0007!J,G-\u001a4\n\t\tu\"q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\ter\tC\u0004\u0003De\u0002\r!!\u001c\u0002'\u0015D\b/Z2uK\u0012lU\r\u001e:jGV\u001b\u0018mZ3\u0002\u0017Y,'/\u001b4z#V|G/\u0019\u000b\nQ\n%#1\nB'\u0005/BqA!\t;\u0001\u0004\ti\bC\u0004\u0003&i\u0002\r!!$\t\u000f\t=#\b1\u0001\u0003R\u0005I\u0011/^8uCRK\b/\u001a\t\u0005\u0003k\u0011\u0019&\u0003\u0003\u0003V\u0005]\"aD\"mS\u0016tG/U;pi\u0006$\u0016\u0010]3\t\u000f\te#\b1\u0001\u0002n\u0005iQ\r\u001f9fGR,G-U;pi\u0006\f\u0011dZ3u#V|G/Y\"p_J$\u0017N\\1u_J\u001cuN\u001c4jOR!!q\fB3!\rq%\u0011M\u0005\u0004\u0005Gj$AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\t\u000b=[\u0004\u0019A)")
public class QuotaCoordinatorTest {
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private MockTime time;
    private MockScheduler scheduler;
    private TenantMetricsPublisher tenantMetricsPublisher = (TenantMetricsPublisher)Mockito.mock(TenantMetricsPublisher.class);
    private Supplier<InternalAdmin> internalAdminSupplier;
    private ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private QuotaStateManager quotaStateManager;
    private QuotaCoordinator quotaCoordinator;
    private final double EPS;
    private final double clusterThroughputQuota;
    private final int brokerLimitProducer;
    private final int brokerLimitConsumer;
    private final QuotaEntity entity1 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
    private final QuotaEntity entity2 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant2")})));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 400.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 300.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 5000.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);

    public KafkaConfig config() {
        return this.config;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(MockScheduler x$1) {
        this.scheduler = x$1;
    }

    public TenantMetricsPublisher tenantMetricsPublisher() {
        return this.tenantMetricsPublisher;
    }

    public void tenantMetricsPublisher_$eq(TenantMetricsPublisher x$1) {
        this.tenantMetricsPublisher = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public void internalAdminSupplier_$eq(Supplier<InternalAdmin> x$1) {
        this.internalAdminSupplier = x$1;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public void clusterLevelQuotaCallback_$eq(ClusterLevelQuotaCallback x$1) {
        this.clusterLevelQuotaCallback = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public double EPS() {
        return this.EPS;
    }

    public double clusterThroughputQuota() {
        return this.clusterThroughputQuota;
    }

    public int brokerLimitProducer() {
        return this.brokerLimitProducer;
    }

    public int brokerLimitConsumer() {
        return this.brokerLimitConsumer;
    }

    public QuotaEntity entity1() {
        return this.entity1;
    }

    public QuotaEntity entity2() {
        return this.entity2;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0() {
        return this.entityConsumptionsBroker0;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1() {
        return this.entityConsumptionsBroker1;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2() {
        return this.entityConsumptionsBroker2;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq(new MockTime());
        this.scheduler_$eq(new MockScheduler((Time)this.time()));
        InternalAdmin internalAdmin = (InternalAdmin)EasyMock.createNiceMock(InternalAdmin.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)EasyMock.eq((Object)"_confluent-quotas"), EasyMock.anyInt(), EasyMock.anyShort(), (Properties)EasyMock.anyObject(Properties.class)))).andReturn((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.config().confluentConfig().quotasTopicPartitions()))).anyTimes();
        this.internalAdminSupplier_$eq(() -> internalAdmin);
        this.clusterLevelQuotaCallback_$eq((ClusterLevelQuotaCallback)EasyMock.createNiceMock(ClusterLevelQuotaCallback.class));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().clusterQuotaLimit((ClientQuotaType)EasyMock.anyObject(ClientQuotaType.class), (java.util.Map)EasyMock.anyObject(java.util.Map.class))).andReturn((Object)Predef$.MODULE$.double2Double(this.clusterThroughputQuota())).anyTimes();
        QuotaCoordinatorConfig quotaCoordinatorConfig = this.getQuotaCoordinatorConfig(this.config());
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getMagic((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)2)))).anyTimes();
        this.quotaStateManager_$eq(new QuotaStateManager(quotaCoordinatorConfig, (Scheduler)this.scheduler(), (Option)new Some((Object)this.tenantMetricsPublisher()), replicaManager, this.clusterLevelQuotaCallback(), new Metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> 50, (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity2()));
        EasyMock.replay((Object[])new Object[]{internalAdmin, this.clusterLevelQuotaCallback(), replicaManager});
        this.quotaCoordinator_$eq(new QuotaCoordinator(this.config().brokerId(), quotaCoordinatorConfig, this.quotaStateManager(), (Scheduler)this.scheduler(), this.internalAdminSupplier(), this.clusterLevelQuotaCallback(), (Time)this.time()));
    }

    @Test
    public void testComputeQuotasInactiveCoordinator() {
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testComputeQuotasInvalidQuotaEntities() {
        this.quotaStateManager().removeOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addLoadingPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$2(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasInactiveCoordinator() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.COORDINATOR_NOT_AVAILABLE, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasEntityDoesNotExist() {
        void var3_3;
        void var2_2;
        this.quotaCoordinator().isActive().set(true);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.QUOTA_ENTITY_NOT_FOUND, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    @Test
    public void testComputeAndDescribeQuotasWithCappedQuota() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
    }

    @Test
    public void testComputeAndDescribeQuotasUnevenDistribution() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumptionBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumptionBroker0, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumptionBroker1, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 150.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionBroker2, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2800.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4200.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
    }

    @Test
    public void testComputeAndDescribeQuotasWhenThrottled() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionThrottled = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionThrottled, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        double broker2Quota = (double)12000 * (1.1 / 3.1);
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, broker2Quota);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaConsumption() {
        void var4_4;
        void var3_3;
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep((long)(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3)));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep((long)(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3)));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var3_3, (Object)Errors.NONE, (String)new StringBuilder(10).append("Got error ").append(var3_3).toString());
        Assertions.assertFalse((boolean)var4_4.brokerQuotas().contains((Object)BoxesRunTime.boxToInteger((int)2)));
    }

    @Test
    public void testAllZeroConsumption() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon zeroConsumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 0.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        this.quotaCoordinator().computeQuotas(0, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
    }

    @Test
    public void testDynamicQuotaNotTriggeredWithLowThroughput() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 10.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 20.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 30.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
    }

    @Test
    public void testMetricsUsageUpdatedInCacheForECKU() {
        this.quotaCoordinator().isActive().set(true);
        String connectionAttemptMetric = "connection-attempt";
        .colon.colon consumptionBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 200.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(connectionAttemptMetric, 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumptionBroker0, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyMetricsUsageInCache(0, this.entity2(), connectionAttemptMetric, 100.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void verifyDescribeQuotasIsNotReturningHardcodedMetrics() {
        void var4_4;
        void var5_5;
        this.quotaCoordinator().isActive().set(true);
        String connectionAttemptMetric = "connection-attempt";
        .colon.colon consumptionBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 200.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(connectionAttemptMetric, 100.0, false), (List)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 300.0, false), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumptionBroker0, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity2());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        boolean computedQuotaProduce = ((MapOps)var5_5.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).contains((Object)ClientQuotaType.PRODUCE.toString());
        boolean computedQuotaMetric = ((MapOps)var5_5.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).contains((Object)connectionAttemptMetric);
        Assertions.assertEquals((Object)Errors.NONE, (Object)var4_4, (String)new StringBuilder(40).append("Got error ").append(var4_4).append(" when describing quota entity2").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)computedQuotaProduce), (String)"Produce Quota isn't returned by describeQuotas");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)computedQuotaMetric), (String)"Connection attempt metric information is given by describeQuotas, it actually shouldn't return that");
    }

    private void computeQuotasCallback(ReportQuotaResult result) {
        result.entityErrors().foreach((Function1 & Serializable)x0$1 -> {
            QuotaCoordinatorTest.$anonfun$computeQuotasCallback$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyMetricsUsageInCache(int broker, QuotaEntity quotaEntity, String metricQuotaType, double expectedMetricUsage) {
        double d;
        Option option = this.quotaStateManager().getQuota(quotaEntity);
        if (option instanceof Some) {
            scala.collection.mutable.Map perBrokerQuotas;
            QuotaEntry quotaEntry = (QuotaEntry)((Some)option).value();
            d = quotaEntry.computedQuotas().contains((Object)BoxesRunTime.boxToInteger((int)broker)) ? ((perBrokerQuotas = (scala.collection.mutable.Map)quotaEntry.computedQuotas().get((Object)BoxesRunTime.boxToInteger((int)broker))).contains((Object)metricQuotaType) ? ((QuotaValue)perBrokerQuotas.get((Object)metricQuotaType).get()).usage() : 0.0) : 0.0;
        } else if (None$.MODULE$.equals(option)) {
            d = 0.0;
        } else {
            throw new MatchError((Object)option);
        }
        double metricUsageInCache = d;
        Assertions.assertEquals((double)expectedMetricUsage, (double)metricUsageInCache, (double)this.EPS(), (String)new StringBuilder(56).append("Got ").append(metricQuotaType).append(" metric updated in cache is ").append(metricUsageInCache).append(" but expected value was ").append(expectedMetricUsage).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyQuota(int broker, QuotaEntity quotaEntity, ClientQuotaType quotaType, double expectedQuota) {
        void var7_6;
        void var8_7;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        double computedQuota = BoxesRunTime.unboxToDouble((Object)((MapOps)var8_7.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)broker), (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Object)quotaType.toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)var7_6, (String)new StringBuilder(40).append("Got error ").append(var7_6).append(" when describing quota entity ").append(quotaEntity).toString());
        Assertions.assertEquals((double)expectedQuota, (double)computedQuota, (double)this.EPS(), (String)new StringBuilder(53).append("Got quota ").append(computedQuota).append(" on broker ").append(broker).append(" for quota entity ").append(quotaEntity).append(" but expected ").append(expectedQuota).toString());
    }

    private QuotaCoordinatorConfig getQuotaCoordinatorConfig(KafkaConfig config) {
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        short x$2 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        int x$4 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        CompressionType x$5 = config.confluentConfig().quotasTopicCompressionType();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        int x$10 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasConsumptionExpirationTimeMs());
        long x$11 = this.brokerLimitProducer();
        long x$12 = this.brokerLimitConsumer();
        QuotaCoordinatorConfig$ apply$default$13_this = QuotaCoordinatorConfig$.MODULE$;
        Object var19_14 = null;
        long x$14 = apply$default$13_this.DefaultQuotasRecomputeIntervalMs();
        QuotaCoordinatorConfig$ apply$default$15_this = QuotaCoordinatorConfig$.MODULE$;
        Object var20_16 = null;
        boolean x$15 = apply$default$15_this.DefaultElasticCkuEnabled();
        return new QuotaCoordinatorConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$14, 0.01, x$15);
    }

    public static final /* synthetic */ void $anonfun$testComputeQuotasInactiveCoordinator$1(ReportQuotaResult result$1, QuotaEntityAndConsumptions entityAndConsumption) {
        Option option = result$1.entityErrors().get((Object)entityAndConsumption.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)error, (String)new StringBuilder(42).append("Got error ").append(error).append(" for quota entity ").append(entityAndConsumption.entity()).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(36).append("Did not get status for quota entity ").append(entityAndConsumption.entity()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void callback$1(ReportQuotaResult result) {
        this.entityConsumptionsBroker0().foreach((Function1 & Serializable)entityAndConsumption -> {
            QuotaCoordinatorTest.$anonfun$testComputeQuotasInactiveCoordinator$1(result, entityAndConsumption);
            return BoxedUnit.UNIT;
        });
    }

    private final void callback$2(ReportQuotaResult result) {
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)result.entityErrors().apply((Object)this.entity1()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity1())).append(" but expected ").append(Errors.COORDINATOR_LOAD_IN_PROGRESS).toString());
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)result.entityErrors().apply((Object)this.entity2()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity2())).append(" but expected ").append(Errors.NOT_COORDINATOR).toString());
    }

    public static final /* synthetic */ void $anonfun$computeQuotasCallback$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            QuotaEntity quotaEntity = (QuotaEntity)x0$1._1();
            Errors error = (Errors)x0$1._2();
            Assertions.assertEquals((Object)Errors.NONE, (Object)error, (String)new StringBuilder(49).append("Got error ").append(error).append(" when reporting usage for quota entity ").append(quotaEntity).toString());
            return;
        }
        throw new MatchError(null);
    }

    public QuotaCoordinatorTest() {
        this.EPS = 1.0E-4;
        this.clusterThroughputQuota = 12000.0;
        this.brokerLimitProducer = 5000;
        this.brokerLimitConsumer = 5000;
    }
}

