/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.quota.QuotaStateManagerTest$;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ActionQueue;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.quota.ElasticCkuDefinitionKey;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEd\u0001B'O\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004f\u0001\u0001\u0006IA\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0001b\u0011\u00199\u0007\u0001)A\u0005E\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB?\u0001A\u0003%!\u000eC\u0004\u007f\u0001\t\u0007I\u0011A@\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0003A\u0011\"a\u0005\u0001\u0005\u0004%\t!!\u0006\t\u0011\u0005e\u0001\u0001)A\u0005\u0003/A\u0001\"a\u0007\u0001\u0005\u0004%\ta \u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0002!Aq\n\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011%\tI\u0003\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0011\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u0019\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%\t!!\u0013\t\u0017\u0005m\u0003\u00011AA\u0002\u0013\u0005\u0011Q\f\u0005\f\u0003S\u0002\u0001\u0019!A!B\u0013\tY\u0005C\u0006\u0002l\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0004bCA=\u0001\u0001\u0007\t\u0019!C\u0001\u0003wB1\"a \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002p!Y\u0011\u0011\u0011\u0001A\u0002\u0003\u0007I\u0011AAB\u0011-\t)\n\u0001a\u0001\u0002\u0004%\t!a&\t\u0017\u0005m\u0005\u00011A\u0001B\u0003&\u0011Q\u0011\u0005\f\u0003;\u0003\u0001\u0019!a\u0001\n\u0003\ty\nC\u0006\u0002,\u0002\u0001\r\u00111A\u0005\u0002\u00055\u0006bCAY\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CC1\"a-\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00026\"Y\u0011Q\u0018\u0001A\u0002\u0003\u0007I\u0011AA`\u0011-\t\u0019\r\u0001a\u0001\u0002\u0003\u0006K!a.\t\u0017\u0005\u0015\u0007\u00011AA\u0002\u0013\u0005\u0011q\u0019\u0005\f\u0003+\u0004\u0001\u0019!a\u0001\n\u0003\t9\u000eC\u0006\u0002\\\u0002\u0001\r\u0011!Q!\n\u0005%\u0007bCAF\u0001\u0001\u0007\t\u0019!C\u0001\u0003;D1\"!;\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002l\"Y\u0011q\u001e\u0001A\u0002\u0003\u0005\u000b\u0015BAp\u0011-\t\t\u0010\u0001a\u0001\u0002\u0004%\t!a=\t\u0017\tE\u0001\u00011AA\u0002\u0013\u0005!1\u0003\u0005\f\u0005/\u0001\u0001\u0019!A!B\u0013\t)\u0010C\u0006\u0003\u001a\u0001\u0001\r\u00111A\u0005\u0002\tm\u0001b\u0003B\u0012\u0001\u0001\u0007\t\u0019!C\u0001\u0005KA1B!\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001e!I!1\u0006\u0001A\u0002\u0013\u0005!Q\u0006\u0005\n\u0005\u0013\u0002\u0001\u0019!C\u0001\u0005\u0017B\u0001Ba\u0014\u0001A\u0003&!q\u0006\u0005\f\u0005#\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0019\u0006C\u0006\u0003^\u0001\u0001\r\u00111A\u0005\u0002\t}\u0003b\u0003B2\u0001\u0001\u0007\t\u0011)Q\u0005\u0005+B1B!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003h!Y!1\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001B;\u0011-\u0011I\b\u0001a\u0001\u0002\u0003\u0006KA!\u001b\t\u0013\tm\u0004A1A\u0005\n\tu\u0004\u0002\u0003BC\u0001\u0001\u0006IAa \t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!\u0011\u0015\u0001\u0005\u0002\t%\u0005b\u0002BV\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005k\u0003A\u0011\u0001BE\u0011\u001d\u0011I\f\u0001C\u0001\u0005\u0013CqA!0\u0001\t\u0013\u0011I\tC\u0004\u0003@\u0002!\tA!#\t\u000f\t\r\u0007\u0001\"\u0001\u0003\n\"9!q\u0019\u0001\u0005\u0002\t%\u0005b\u0002Bf\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0011\u001d\u00119\u0010\u0001C\u0001\u0005\u0013CqAa?\u0001\t\u0003\u0011I\tC\u0004\u0003\u0000\u0002!\tA!#\t\u000f\r\r\u0001\u0001\"\u0001\u0003\n\"91q\u0001\u0001\u0005\n\r%\u0001bBB\u0004\u0001\u0011%1\u0011\u0006\u0005\b\u0007s\u0001A\u0011BB\u001e\u0011\u001d\u0019I\u0005\u0001C\u0005\u0007\u0017\u0012Q#U;pi\u0006\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002P!\u0006)\u0011/^8uC*\u0011\u0011KU\u0001\fG>|'\u000fZ5oCR|'OC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\f\u0005\u0002`\u00015\ta*A\nok6\fVo\u001c;bgB\u000b'\u000f^5uS>t7/F\u0001c!\t96-\u0003\u0002e1\n\u0019\u0011J\u001c;\u0002)9,X.U;pi\u0006\u001c\b+\u0019:uSRLwN\\:!\u0003!\u0011'o\\6fe&#\u0017!\u00032s_.,'/\u00133!\u0003Q\tXo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8ogV\t!\u000eE\u0002laJl\u0011\u0001\u001c\u0006\u0003[:\f\u0011\"[7nkR\f'\r\\3\u000b\u0005=D\u0016AC2pY2,7\r^5p]&\u0011\u0011\u000f\u001c\u0002\u0004'\u0016\f\bCA:|\u001b\u0005!(BA;w\u0003\u0019\u0019w.\\7p]*\u00111k\u001e\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}i\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!F9v_R\fGk\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\u000bK:$\u0018\u000e^=UsB,WCAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tA\u0001\\1oO*\u0011\u00111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005\u0015!AB*ue&tw-A\u0006f]RLG/\u001f+za\u0016\u0004\u0013aC3oi&$\u0018PT1nKN,\"!a\u0006\u0011\t-\u0004\u0018\u0011A\u0001\rK:$\u0018\u000e^=OC6,7\u000fI\u0001\ncV|G/\u0019+za\u0016\f!\"];pi\u0006$\u0016\u0010]3!+\t\t\t\u0003E\u0002X\u0003GI1!!\nY\u0005\u0019!u.\u001e2mK\u00061\u0011/^8uC\u0002\nQ!^:bO\u0016\fa!^:bO\u0016\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t\t\u0004\u0005\u0003\u00024\u0005\u0005SBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u00071|wM\u0003\u0003\u0002<\u0005u\u0012!C5oi\u0016\u0014h.\u00197t\u0015\r\tyD^\u0001\bgR|'/Y4f\u0013\u0011\t\u0019%!\u000e\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u0005!A/[7f+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003+2\u0018AB:feZ,'/\u0003\u0003\u0002Z\u0005=#\u0001C'pG.$\u0016.\\3\u0002\u0011QLW.Z0%KF$B!a\u0018\u0002fA\u0019q+!\u0019\n\u0007\u0005\r\u0004L\u0001\u0003V]&$\b\"CA4+\u0005\u0005\t\u0019AA&\u0003\rAH%M\u0001\u0006i&lW\rI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\ty\u0007\u0005\u0003\u0002r\u0005UTBAA:\u0015\r\t)FU\u0005\u0005\u0003o\n\u0019H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003?\ni\bC\u0005\u0002ha\t\t\u00111\u0001\u0002p\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\fuK:\fg\u000e^'fiJL7m\u001d)vE2L7\u000f[3s+\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u000f5,GO]5dg*\u0019\u0011q\u0012<\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002\u0014\u0006%%A\u0006+f]\u0006tG/T3ue&\u001c7\u000fU;cY&\u001c\b.\u001a:\u00025Q,g.\u00198u\u001b\u0016$(/[2t!V\u0014G.[:iKJ|F%Z9\u0015\t\u0005}\u0013\u0011\u0014\u0005\n\u0003OZ\u0012\u0011!a\u0001\u0003\u000b\u000bq\u0003^3oC:$X*\u001a;sS\u000e\u001c\b+\u001e2mSNDWM\u001d\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002\"B!\u00111UAT\u001b\t\t)KC\u0002\u00028IKA!!+\u0002&\nQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u0011qLAX\u0011%\t9GHA\u0001\u0002\u0004\t\t+A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!E9v_R\f7\u000b^1uK6\u000bg.Y4feV\u0011\u0011q\u0017\t\u0004?\u0006e\u0016bAA^\u001d\n\t\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:\u0002+E,x\u000e^1Ti\u0006$X-T1oC\u001e,'o\u0018\u0013fcR!\u0011qLAa\u0011%\t9'IA\u0001\u0002\u0004\t9,\u0001\nrk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013!\u00039beRLG/[8o+\t\tI\r\u0005\u0003\u0002L\u0006EWBAAg\u0015\r\tyMU\u0001\bG2,8\u000f^3s\u0013\u0011\t\u0019.!4\u0003\u0013A\u000b'\u000f^5uS>t\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002`\u0005e\u0007\"CA4I\u0005\u0005\t\u0019AAe\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u000b\u0003\u0003?\u0004B!!9\u0002f6\u0011\u00111\u001d\u0006\u0004\u0003\u0017#\u0018\u0002BAt\u0003G\u0014q!T3ue&\u001c7/A\u0006nKR\u0014\u0018nY:`I\u0015\fH\u0003BA0\u0003[D\u0011\"a\u001a(\u0003\u0003\u0005\r!a8\u0002\u00115,GO]5dg\u0002\nQ\"];pi\u0006,e\u000e^5uS\u0016\u001cXCAA{!\u0019\t9Pa\u0002\u0003\f9!\u0011\u0011 B\u0002\u001d\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000)\u00061AH]8pizJ\u0011!W\u0005\u0004\u0005\u000bA\u0016a\u00029bG.\fw-Z\u0005\u0004c\n%!b\u0001B\u00031B\u0019qL!\u0004\n\u0007\t=aJA\u0006Rk>$\u0018-\u00128uSRL\u0018!E9v_R\fWI\u001c;ji&,7o\u0018\u0013fcR!\u0011q\fB\u000b\u0011%\t9GKA\u0001\u0002\u0004\t)0\u0001\brk>$\u0018-\u00128uSRLWm\u001d\u0011\u0002\u0015E,x\u000e^1WC2,X-\u0006\u0002\u0003\u001eA\u0019qLa\b\n\u0007\t\u0005bJ\u0001\u0006Rk>$\u0018MV1mk\u0016\fa\"];pi\u00064\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002`\t\u001d\u0002\"CA4[\u0005\u0005\t\u0019\u0001B\u000f\u0003-\tXo\u001c;b-\u0006dW/\u001a\u0011\u0002\u001bE,x\u000e^1WC2,X-T1q+\t\u0011y\u0003\u0005\u0005\u00032\t]\"1\bB\u000f\u001b\t\u0011\u0019DC\u0002\u000369\fq!\\;uC\ndW-\u0003\u0003\u0003:\tM\"aA'baB!!Q\bB#\u001d\u0011\u0011yD!\u0011\u0011\u0007\u0005m\b,C\u0002\u0003Da\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0005\u000fR1Aa\u0011Y\u0003E\tXo\u001c;b-\u0006dW/Z'ba~#S-\u001d\u000b\u0005\u0003?\u0012i\u0005C\u0005\u0002hA\n\t\u00111\u0001\u00030\u0005q\u0011/^8uCZ\u000bG.^3NCB\u0004\u0013\u0001D9v_R\fWI\u001c;sS\u0016\u001cXC\u0001B+!\u0019\t9Pa\u0002\u0003XA\u0019qL!\u0017\n\u0007\tmcJ\u0001\u0006Rk>$\u0018-\u00128uef\f\u0001#];pi\u0006,e\u000e\u001e:jKN|F%Z9\u0015\t\u0005}#\u0011\r\u0005\n\u0003O\u001a\u0014\u0011!a\u0001\u0005+\nQ\"];pi\u0006,e\u000e\u001e:jKN\u0004\u0013!G2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.,\"A!\u001b\u0011\t\t-$qN\u0007\u0003\u0005[R1aTA*\u0013\u0011\u0011\tH!\u001c\u00033\rcWo\u001d;fe2+g/\u001a7Rk>$\u0018mQ1mY\n\f7m[\u0001\u001eG2,8\u000f^3s\u0019\u00164X\r\\)v_R\f7)\u00197mE\u0006\u001c7n\u0018\u0013fcR!\u0011q\fB<\u0011%\t9GNA\u0001\u0002\u0004\u0011I'\u0001\u000edYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007%A\u0006rk>$\u0018mQ8oM&<WC\u0001B@!\ry&\u0011Q\u0005\u0004\u0005\u0007s%AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0002\u0019E,x\u000e^1D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005}\u0003f\u0001\u001e\u0003\u000eB!!q\u0012BO\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015aA1qS*!!q\u0013BM\u0003\u001dQW\u000f]5uKJT1Aa'z\u0003\u0015QWO\\5u\u0013\u0011\u0011yJ!%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rY$Q\u0015\t\u0005\u0005\u001f\u00139+\u0003\u0003\u0003*\nE%!C!gi\u0016\u0014X)Y2i\u0003Q!Xm\u001d;M_\u0006$\u0017+^8uCJ+7m\u001c:eg\"\u001aAHa,\u0011\t\t=%\u0011W\u0005\u0005\u0005g\u0013\tJ\u0001\u0003UKN$\u0018a\u0004;fgR\u001cFo\u001c:f#V|G/Y:)\u0007u\u0012y+A\nuKN$XiS\"V\u0007\u0006d7-\u001e7bi&|g\u000eK\u0002?\u0005_\u000b1C]3qY&\u001c\u0017-T1oC\u001e,'oU3ukB\fa\u0003^3ti:+H\u000e\\#D\u0017V#UMZ5oSRLwN\u001c\u0015\u0004\u0001\n=\u0016a\u0006;fgRtu.T5o\u000b\u000e[U\u000bR3gS:LG/[8oQ\r\t%qV\u0001\u0018i\u0016\u001cHOT8NCb,5iS+EK\u001aLg.\u001b;j_:D3A\u0011BX\u0003e!Xm\u001d;QCJ$\u0018.\u00197F\u0007.+F)\u001a4j]&$\u0018n\u001c8)\u0007\r\u0013y+A\u0005hKRlU\r\u001e:jGR1!1\u001bBx\u0005g\u0004Ra\u0016Bk\u00053L1Aa6Y\u0005\u0019y\u0005\u000f^5p]B!!1\u001cBv\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018\u0001B2pe\u0016TA!a#\u0003d*!!Q\u001dBt\u0003\u0019I\u0018-\\7fe*\u0011!\u0011^\u0001\u0004G>l\u0017\u0002\u0002Bw\u0005;\u0014a!T3ue&\u001c\u0007b\u0002By\t\u0002\u0007!1H\u0001\u0007[\u0016$(/[2\t\u000f\tUH\t1\u0001\u0003\f\u0005Y\u0011/^8uC\u0016sG/\u001b;z\u0003A!Xm\u001d;FqBL'/Z)v_R\f7\u000fK\u0002F\u0005_\u000b\u0001\u0005^3ti\u0016C\b/\u001b:f#V|G/Y:XSRDwK]5uK\u001a\u000b\u0017\u000e\\;sK\"\u001aaIa,\u0002+Q,7\u000f^)v_R\fWI\u001c;ssB\u000b'o]5oO\"\u001aqIa,\u00023Q,7\u000f^)v_R\fGk\\7cgR|g.\u001a)beNLgn\u001a\u0015\u0004\u0011\n=\u0016AF3ya\u0016\u001cG/U;pi\u0006\u0014VmY8sINdu.\u00193\u0015\u0011\u0005}31BB\b\u00073Aaa!\u0004J\u0001\u0004\u0011\u0018aG4s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0004\u0012%\u0003\raa\u0005\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004/\u000eU\u0011bAB\f1\n!Aj\u001c8h\u0011\u001d\u0019Y\"\u0013a\u0001\u0007;\tqA]3d_J$7\u000f\u0005\u0003\u0004 \r\u0015RBAB\u0011\u0015\r\u0019\u0019\u0003^\u0001\u0007e\u0016\u001cwN\u001d3\n\t\r\u001d2\u0011\u0005\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0015\u0011\rM11FB\u001b\u0007oAqa!\fK\u0001\u0004\u0019y#A\u0004m_\u001elunY6\u0011\t\u0005\r6\u0011G\u0005\u0005\u0007g\t)KA\u0006BEN$(/Y2u\u0019><\u0007bBB\t\u0015\u0002\u000711\u0003\u0005\b\u00077Q\u0005\u0019AB\u000f\u0003E\u0019'/Z1uKF+x\u000e^1SK\u000e|'\u000f\u001a\u000b\u0007\u0007{\u0019\u0019e!\u0012\u0011\t\r}1qH\u0005\u0005\u0007\u0003\u001a\tC\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0004\u0003v.\u0003\rAa\u0003\t\u000f\r\u001d3\n1\u0001\u0003X\u0005Q\u0011/^8uC\u0016sGO]=\u0002)\u0015D\b/Z2u\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3t)\u0011\u0019iea\u0018\u0011\r\r=3QKB-\u001b\t\u0019\tFC\u0002\u0004Te\f\u0001\"Z1ts6|7m[\u0005\u0005\u0007/\u001a\tFA\u0004DCB$XO]3\u0011\u000f\rm3Q\f:\u0004\u001e5\ta.C\u0002\u0003:9Dqa!\u0019M\u0001\u0004\u0019\u0019'\u0001\u0004feJ|'o\u001d\t\u0007\u0003o\u00149a!\u001a\u0011\t\r\u001d4QN\u0007\u0003\u0007SR1aa\u001bu\u0003!\u0001(o\u001c;pG>d\u0017\u0002BB8\u0007S\u0012a!\u0012:s_J\u001c\b")
public class QuotaStateManagerTest {
    private final int numQuotasPartitions;
    private final int brokerId;
    private final Seq<TopicPartition> quotaTopicPartitions = new .colon.colon((Object)new TopicPartition("_confluent-quotas", 0), (List)new .colon.colon((Object)new TopicPartition("_confluent-quotas", 1), (List)Nil$.MODULE$));
    private final String entityType;
    private final Seq<String> entityNames = new .colon.colon((Object)"entityName0", (List)new .colon.colon((Object)"entityName1", (List)Nil$.MODULE$));
    private final String quotaType;
    private final double quota;
    private final double usage;
    private final LogConfig logConfig = new LogConfig(Collections.emptyMap());
    private MockTime time;
    private ReplicaManager replicaManager;
    private TenantMetricsPublisher tenantMetricsPublisher;
    private LogManager logManager;
    private QuotaStateManager quotaStateManager;
    private Partition partition;
    private Metrics metrics;
    private Seq<QuotaEntity> quotaEntities;
    private QuotaValue quotaValue;
    private scala.collection.mutable.Map<String, QuotaValue> quotaValueMap = new HashMap();
    private Seq<QuotaEntry> quotaEntries;
    private ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final QuotaCoordinatorConfig quotaConfig;

    public int numQuotasPartitions() {
        return this.numQuotasPartitions;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Seq<TopicPartition> quotaTopicPartitions() {
        return this.quotaTopicPartitions;
    }

    public String entityType() {
        return this.entityType;
    }

    public Seq<String> entityNames() {
        return this.entityNames;
    }

    public String quotaType() {
        return this.quotaType;
    }

    public double quota() {
        return this.quota;
    }

    public double usage() {
        return this.usage;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TenantMetricsPublisher tenantMetricsPublisher() {
        return this.tenantMetricsPublisher;
    }

    public void tenantMetricsPublisher_$eq(TenantMetricsPublisher x$1) {
        this.tenantMetricsPublisher = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public Seq<QuotaEntity> quotaEntities() {
        return this.quotaEntities;
    }

    public void quotaEntities_$eq(Seq<QuotaEntity> x$1) {
        this.quotaEntities = x$1;
    }

    public QuotaValue quotaValue() {
        return this.quotaValue;
    }

    public void quotaValue_$eq(QuotaValue x$1) {
        this.quotaValue = x$1;
    }

    public scala.collection.mutable.Map<String, QuotaValue> quotaValueMap() {
        return this.quotaValueMap;
    }

    public void quotaValueMap_$eq(scala.collection.mutable.Map<String, QuotaValue> x$1) {
        this.quotaValueMap = x$1;
    }

    public Seq<QuotaEntry> quotaEntries() {
        return this.quotaEntries;
    }

    public void quotaEntries_$eq(Seq<QuotaEntry> x$1) {
        this.quotaEntries = x$1;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public void clusterLevelQuotaCallback_$eq(ClusterLevelQuotaCallback x$1) {
        this.clusterLevelQuotaCallback = x$1;
    }

    private QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    @BeforeEach
    public void setUp() {
        this.metrics_$eq(new Metrics());
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.tenantMetricsPublisher_$eq((TenantMetricsPublisher)EasyMock.createNiceMock(TenantMetricsPublisher.class));
        this.logManager_$eq((LogManager)EasyMock.createNiceMock(LogManager.class));
        this.clusterLevelQuotaCallback_$eq((ClusterLevelQuotaCallback)EasyMock.createNiceMock(ClusterLevelQuotaCallback.class));
        this.quotaStateManager_$eq(new QuotaStateManager(this.quotaConfig(), (Scheduler)this.time().scheduler, (Option)new Some((Object)this.tenantMetricsPublisher()), this.replicaManager(), this.clusterLevelQuotaCallback(), this.metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numQuotasPartitions(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
        this.quotaEntities_$eq((Seq<QuotaEntity>)((Seq)this.entityNames().map((Function1 & Serializable)name -> new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), name)}))))));
        this.quotaValue_$eq(QuotaValue$.MODULE$.loadValue(this.usage(), false, this.quota(), this.time().milliseconds()));
        this.quotaValueMap().update((Object)this.quotaType(), (Object)this.quotaValue());
        this.quotaEntries_$eq((Seq<QuotaEntry>)((Seq)this.quotaEntities().map((Function1 & Serializable)entity -> new QuotaEntry(entity, this.time().milliseconds()))));
        this.quotaEntries().foreach((Function1 & Serializable)quotaEntry -> {
            quotaEntry.putQuotaValue(this.brokerId(), this.quotaType(), this.quotaValue());
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.logConfig())).anyTimes();
    }

    @AfterEach
    public void tearDown() {
        this.quotaStateManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadQuotaRecords() {
        void withRecords_records;
        long startOffset = 10L;
        SimpleRecord quotaRecord = this.createQuotaRecord((QuotaEntity)this.quotaEntities().head(), (QuotaEntry)this.quotaEntries().head());
        TopicPartition quotaTopicPartition = (TopicPartition)this.quotaTopicPartitions().apply(this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().head()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{quotaRecord};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var11_6 = null;
        Object var9_5 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.expectQuotaRecordsLoad(quotaTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaStateManager().loadQuotaState(quotaTopicPartition.partition(), 0);
        this.time().sleep(5L);
        QuotaEntry loadedQuota = this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head());
        Assertions.assertEquals((Object)this.quotaEntities().head(), (Object)loadedQuota.quotaEntity());
        int loadedBroker = ((Tuple2)loadedQuota.computedQuotas().head())._1$mcI$sp();
        Assertions.assertEquals((int)this.brokerId(), (int)loadedBroker);
        scala.collection.mutable.Map loadedQuotaValues = (scala.collection.mutable.Map)((Tuple2)loadedQuota.computedQuotas().head())._2();
        Assertions.assertEquals(this.quotaValueMap(), (Object)loadedQuotaValues);
        EasyMock.verify((Object[])new Object[]{this.replicaManager(), this.logManager()});
    }

    @Test
    public void testStoreQuotas() {
        .colon.colon expectedErrors = new .colon.colon((Object)Errors.NONE, (List)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$));
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessages((Seq<Errors>)expectedErrors);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeErrors = ObjectRef.create((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$12))), (Object)None$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        QuotaStateManager qual$1 = this.quotaStateManager();
        scala.collection.immutable.Map x$1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.quotaTopicPartitions().apply(BoxesRunTime.unboxToInt((Object)i))), (Object)new .colon.colon((Object)((QuotaEntry)this.quotaEntries().apply(BoxesRunTime.unboxToInt((Object)i))), (List)Nil$.MODULE$))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Function1 & Serializable x$2 = (Function1 & Serializable)errors -> {
            QuotaStateManagerTest.callback$1(errors, maybeErrors);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$3 = qual$1.storeQuotas$default$3();
        qual$1.storeQuotas((Map)x$1, (Function1)x$2, x$3);
        ((Map)maybeErrors.elem).foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testStoreQuotas$5$adapted((Seq)expectedErrors, arg_0));
        Assertions.assertTrue((boolean)capturedRecords.hasCaptured());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            List records = CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)capturedRecords.getValue()).apply(this.quotaTopicPartitions().apply(partition))).records()).asScala().toList();
            Assertions.assertEquals((int)1, (int)records.size());
            Record record = (Record)records.head();
            QuotaEntity capturedQuotaKey = QuotaStateManager$.MODULE$.readMessageKey(record.key());
            Assertions.assertEquals((Object)this.quotaEntities().apply(partition), (Object)capturedQuotaKey);
            Option capturedQuotaValue = QuotaStateManager$.MODULE$.readMessageValue((QuotaEntity)this.quotaEntities().apply(partition), record.value());
            int capturedBrokerId = ((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._1$mcI$sp();
            Assertions.assertEquals((int)this.brokerId(), (int)capturedBrokerId);
            scala.collection.mutable.Map capturedQuotaValues = (scala.collection.mutable.Map)((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._2();
            Assertions.assertEquals(this.quotaValueMap(), (Object)capturedQuotaValues);
        });
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testEKCUCalculation() {
        this.metrics_$eq(new Metrics());
        this.replicaManagerSetup();
        EasyMock.expect((Object)this.tenantMetricsPublisher().getPartitionCountForTenant(EasyMock.anyString())).andAnswer(() -> new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy());
        this.entityNames().foreach((Function1 & Serializable)tenant -> BoxesRunTime.boxToBoolean((boolean)QuotaStateManagerTest.$anonfun$testEKCUCalculation$2(this, tenant)));
        Map elasticCkuDefinitionMap = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.PRODUCE), (Object)Predef$.MODULE$.int2Integer(0x3200000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.FETCH), (Object)Predef$.MODULE$.int2Integer(0x9600000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_ATTEMPT), (Object)Predef$.MODULE$.int2Integer(250)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_COUNT), (Object)Predef$.MODULE$.int2Integer(4500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.REQUEST_COUNT), (Object)Predef$.MODULE$.int2Integer(7500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(120)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.MAX_ELASTIC_CKU), (Object)Predef$.MODULE$.int2Integer(5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.MIN_ELASTIC_CKU), (Object)Predef$.MODULE$.int2Integer(2))}));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().elasticCkuDefinition((java.util.Map)EasyMock.anyObject())).andReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava(elasticCkuDefinitionMap).asJava()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLevelQuotaCallback()});
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1.0E9, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 5.0E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        double ecku = this.quotaStateManager().calculateElasticCKU((QuotaEntity)this.quotaEntities().head());
        Assertions.assertEquals((double)5.0, (double)ecku);
        double expectedECkuMetric = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", (QuotaEntity)this.quotaEntities().head()).get()).value());
        Assertions.assertEquals((double)5.0, (double)expectedECkuMetric);
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).updateConsumption(1, new QuotaConsumption("listener-tenant-connection-accept-rate", 250.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).updateConsumption(0, new QuotaConsumption("listener-tenant-connection-accept-rate", 250.0, false), this.time().milliseconds());
        double ecku1 = this.quotaStateManager().calculateElasticCKU((QuotaEntity)this.quotaEntities().apply(1));
        Assertions.assertEquals((double)2.0, (double)ecku1);
        double expectedECkuMetric1 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", (QuotaEntity)this.quotaEntities().apply(1)).get()).value());
        Assertions.assertEquals((double)2.0, (double)expectedECkuMetric1);
        QuotaEntity quotaEntity2 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName2")})));
        this.quotaStateManager().registerGauge("entityName2");
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity2).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity2).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity2).updateConsumption(1, new QuotaConsumption("listener-tenant-connection-accept-rate", 750.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity2).updateConsumption(0, new QuotaConsumption("listener-tenant-connection-accept-rate", 250.0, false), this.time().milliseconds());
        double ecku2 = this.quotaStateManager().calculateElasticCKU(quotaEntity2);
        Assertions.assertEquals((double)4.0, (double)ecku2);
        double expectedECkuMetric2 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity2).get()).value());
        Assertions.assertEquals((double)4.0, (double)expectedECkuMetric2);
        QuotaEntity quotaEntity3 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName3")})));
        this.quotaStateManager().registerGauge("entityName3");
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity3).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity3).updateConsumptionAndRecomputeQuotas(1, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6.0E7, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity3).updateConsumptionAndRecomputeQuotas(2, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6.0E7, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity3).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity3).updateConsumption(1, new QuotaConsumption("listener-tenant-connection-accept-rate", 500.0, false), this.time().milliseconds());
        double ecku3 = this.quotaStateManager().calculateElasticCKU(quotaEntity3);
        Assertions.assertEquals((double)3.0, (double)ecku3);
        double expectedECkuMetric3 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity3).get()).value());
        Assertions.assertEquals((double)3.0, (double)expectedECkuMetric3);
        QuotaEntity quotaEntity4 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName4")})));
        this.quotaStateManager().registerGauge("entityName4");
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity4).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity4).updateConsumptionAndRecomputeQuotas(1, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 1.6E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity4).updateConsumptionAndRecomputeQuotas(2, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 1.6E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity4).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 1.6E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity4).updateConsumption(1, new QuotaConsumption("listener-tenant-connection-accept-rate", 500.0, false), this.time().milliseconds());
        double ecku4 = this.quotaStateManager().calculateElasticCKU(quotaEntity4);
        Assertions.assertEquals((double)4.0, (double)ecku4);
        double expectedECkuMetric4 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity4).get()).value());
        Assertions.assertEquals((double)4.0, (double)expectedECkuMetric4);
        QuotaEntity quotaEntity5 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName5")})));
        this.quotaStateManager().registerGauge("entityName5");
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity5).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity5).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity5).updateConsumption(1, new QuotaConsumption("listener-tenant-connection-accept-rate", 750.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity5).updateConsumption(0, new QuotaConsumption("authenticated-unthrottled-connection-count", 9000.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity5).updateConsumption(1, new QuotaConsumption("authenticated-unthrottled-connection-count", 9000.0, false), this.time().milliseconds());
        double ecku5 = this.quotaStateManager().calculateElasticCKU(quotaEntity5);
        Assertions.assertEquals((double)4.0, (double)ecku5);
        double expectedECkuMetric5 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity5).get()).value());
        Assertions.assertEquals((double)4.0, (double)expectedECkuMetric5);
        QuotaEntity quotaEntity6 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName16")})));
        this.quotaStateManager().registerGauge("entityName16");
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6000000.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(1, new QuotaConsumption("authenticated-unthrottled-connection-count", 9000.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(1, new QuotaConsumption("aggregate-request-rate", 7500.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(0, new QuotaConsumption("aggregate-request-rate", 18000.0, false), this.time().milliseconds());
        double ecku6 = this.quotaStateManager().calculateElasticCKU(quotaEntity6);
        Assertions.assertEquals((double)4.0, (double)ecku6);
        double expectedECkuMetric6 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity6).get()).value());
        Assertions.assertEquals((double)4.0, (double)expectedECkuMetric6);
        QuotaEntity quotaEntity7 = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName7")})));
        this.quotaStateManager().registerGauge("entityName7");
        long expiredTs = System.currentTimeMillis() - 150000L;
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 6.0E10, false), 2.147483647E9, 2.147483647E9, expiredTs, Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 6.0E12, false), 2.147483647E9, 2.147483647E9, expiredTs, Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(1, new QuotaConsumption("authenticated-unthrottled-connection-count", 9.0E7, false), expiredTs);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(1, new QuotaConsumption("aggregate-request-rate", 7.5E8, false), expiredTs);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity6).updateConsumption(0, new QuotaConsumption("aggregate-request-rate", 1.8E8, false), expiredTs);
        double ecku7 = this.quotaStateManager().calculateElasticCKU(quotaEntity7);
        Assertions.assertEquals((double)2.0, (double)ecku7);
        double expectedECkuMetric7 = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity6).get()).value());
        Assertions.assertEquals((double)2.0, (double)expectedECkuMetric7);
    }

    private void replicaManagerSetup() {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject(), (ActionQueue)EasyMock.anyObject(), (Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, callbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture callbackCapture$1;

            public void answer() {
                ((Function1)this.callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callbackCapture$1 = callbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testNullECKUDefinition() {
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName8")})));
        this.quotaStateManager().registerGauge("entityName8");
        this.replicaManagerSetup();
        EasyMock.expect((Object)this.tenantMetricsPublisher().getPartitionCountForTenant(EasyMock.anyString())).andAnswer(() -> new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy());
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().elasticCkuDefinition((java.util.Map)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLevelQuotaCallback()});
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1.0E9, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 5.0E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        double ecku = this.quotaStateManager().calculateElasticCKU(quotaEntity);
        Assertions.assertEquals((double)5.0, (double)ecku);
        double expectedECkuMetric = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity).get()).value());
        Assertions.assertEquals((double)5.0, (double)expectedECkuMetric);
    }

    @Test
    public void testNoMinECKUDefinition() {
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName9")})));
        this.quotaStateManager().registerGauge("entityName9");
        this.replicaManagerSetup();
        EasyMock.expect((Object)this.tenantMetricsPublisher().getPartitionCountForTenant(EasyMock.anyString())).andAnswer(() -> new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy());
        Map elasticCkuDefinitionMap = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.PRODUCE), (Object)Predef$.MODULE$.int2Integer(0x3200000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.FETCH), (Object)Predef$.MODULE$.int2Integer(0x9600000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_ATTEMPT), (Object)Predef$.MODULE$.int2Integer(250)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_COUNT), (Object)Predef$.MODULE$.int2Integer(4500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.REQUEST_COUNT), (Object)Predef$.MODULE$.int2Integer(7500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(120)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.MAX_ELASTIC_CKU), (Object)Predef$.MODULE$.int2Integer(5))}));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().elasticCkuDefinition((java.util.Map)EasyMock.anyObject())).andReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava(elasticCkuDefinitionMap).asJava()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLevelQuotaCallback()});
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 0.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.FETCH.toString(), 0.0, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        double ecku = this.quotaStateManager().calculateElasticCKU(quotaEntity);
        Assertions.assertEquals((double)1.0, (double)ecku);
        double expectedECkuMetric = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity).get()).value());
        Assertions.assertEquals((double)1.0, (double)expectedECkuMetric);
    }

    @Test
    public void testNoMaxECKUDefinition() {
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName10")})));
        this.quotaStateManager().registerGauge("entityName10");
        this.replicaManagerSetup();
        this.entityNames().foreach((Function1 & Serializable)tenant -> BoxesRunTime.boxToBoolean((boolean)QuotaStateManagerTest.$anonfun$testNoMaxECKUDefinition$1(this, tenant)));
        EasyMock.expect((Object)this.tenantMetricsPublisher().getPartitionCountForTenant(EasyMock.anyString())).andAnswer(() -> new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy());
        Map elasticCkuDefinitionMap = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.PRODUCE), (Object)Predef$.MODULE$.int2Integer(0x3200000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.FETCH), (Object)Predef$.MODULE$.int2Integer(0x9600000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_ATTEMPT), (Object)Predef$.MODULE$.int2Integer(250)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_COUNT), (Object)Predef$.MODULE$.int2Integer(4500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.REQUEST_COUNT), (Object)Predef$.MODULE$.int2Integer(7500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(120)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.MIN_ELASTIC_CKU), (Object)Predef$.MODULE$.int2Integer(1))}));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().elasticCkuDefinition((java.util.Map)EasyMock.anyObject())).andReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava(elasticCkuDefinitionMap).asJava()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLevelQuotaCallback()});
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 5.24288E8, false), 2.147483647E9, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        double ecku = this.quotaStateManager().calculateElasticCKU(quotaEntity);
        Assertions.assertEquals((double)5.0, (double)ecku);
        double expectedECkuMetric = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity).get()).value());
        Assertions.assertEquals((double)5.0, (double)expectedECkuMetric);
    }

    @Test
    public void testPartialECKUDefinition() {
        this.quotaStateManager().registerGauge("entityName61");
        this.replicaManagerSetup();
        EasyMock.expect((Object)this.tenantMetricsPublisher().getPartitionCountForTenant(EasyMock.anyString())).andAnswer(() -> new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy());
        Map elasticCkuDefinitionMap = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.PRODUCE), (Object)Predef$.MODULE$.int2Integer(0x3200000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.FETCH), (Object)Predef$.MODULE$.int2Integer(0x9600000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_ATTEMPT), (Object)Predef$.MODULE$.int2Integer(250)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.CONNECTION_COUNT), (Object)Predef$.MODULE$.int2Integer(4500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(120)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.NON_COMPACTED_PARTITION_COUNT), (Object)Predef$.MODULE$.int2Integer(1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ElasticCkuDefinitionKey.MIN_ELASTIC_CKU), (Object)Predef$.MODULE$.int2Integer(1))}));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().elasticCkuDefinition((java.util.Map)EasyMock.anyObject())).andReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava(elasticCkuDefinitionMap).asJava()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterLevelQuotaCallback()});
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"entityName61")})));
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumption(1, new QuotaConsumption("aggregate-request-rate", 7500.0, false), this.time().milliseconds());
        this.quotaStateManager().getAndMaybePutQuota(quotaEntity).updateConsumption(0, new QuotaConsumption("aggregate-request-rate", 18000.0, false), this.time().milliseconds());
        double ecku = this.quotaStateManager().calculateElasticCKU(quotaEntity);
        Assertions.assertEquals((double)1.0, (double)ecku);
        double expectedECkuMetric = BoxesRunTime.unboxToDouble((Object)((Gauge)this.getMetric("ElasticCku", quotaEntity).get()).value());
        Assertions.assertEquals((double)1.0, (double)expectedECkuMetric);
    }

    public Option<Metric> getMetric(String metric, QuotaEntity quotaEntity) {
        java.util.Map javaMetrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        scala.collection.mutable.Map metricsMap = CollectionConverters$.MODULE$.MapHasAsScala(javaMetrics).asScala();
        Predef$.MODULE$.println((Object)new StringBuilder(54).append("Printing contents of metricsMap for metric: ").append(metric).append(", entity: ").append(quotaEntity).toString());
        metricsMap.foreach((Function1 & Serializable)entry -> {
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Key::").append(entry._1()).append("    :::: Value: ").append(entry._2()).toString());
            return BoxedUnit.UNIT;
        });
        return metricsMap.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaStateManagerTest.$anonfun$getMetric$2(metric, quotaEntity, x0$1))).map((Function1 & Serializable)x$13 -> (Metric)x$13._2());
    }

    @Test
    public void testExpireQuotas() {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject(), (ActionQueue)EasyMock.anyObject(), (Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, callbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture callbackCapture$2;

            public void answer() {
                ((Function1)this.callbackCapture$2.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callbackCapture$2 = callbackCapture$2;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotas$1(this.quotaStateManager(), arg_0));
        this.time().sleep((long)(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3)));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), 100000.0, 2.147483647E9, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.time().sleep((long)(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3)));
        Assertions.assertEquals((int)1, (int)((MapOps)recordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)recordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)recordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    @Test
    public void testExpireQuotasWithWriteFailure() {
        Capture firstRecordsCapture = EasyMock.newCapture();
        Capture firstCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)firstRecordsCapture), (Function1)EasyMock.capture((Capture)firstCallbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject(), (ActionQueue)EasyMock.anyObject(), (Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, firstCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture firstCallbackCapture$1;

            public void answer() {
                ((Function1)this.firstCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstCallbackCapture$1 = firstCallbackCapture$1;
            }
        }).once();
        Capture secondRecordsCapture = EasyMock.newCapture();
        Capture secondCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)secondRecordsCapture), (Function1)EasyMock.capture((Capture)secondCallbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject(), (ActionQueue)EasyMock.anyObject(), (Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, secondCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture secondCallbackCapture$1;

            public void answer() {
                ((Function1)this.secondCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondCallbackCapture$1 = secondCallbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotasWithWriteFailure$1(this.quotaStateManager(), arg_0));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).lastUpdatedTimestamp_$eq(this.time().milliseconds() - (long)(this.quotaConfig().quotasExpirationTimeMs() * 2));
        this.time().sleep((long)this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)firstRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)firstRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)firstRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
        this.time().sleep((long)this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)secondRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)secondRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)secondRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaEntryParsing() {
        void var8_8;
        void var7_7;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, this.time().milliseconds());
        quotaEntry.putQuotaValue(0, this.quotaType(), this.quotaValue());
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] valueBytes = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, valueBytes), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var7_7);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",lastUpdatedTimestamp:").append(this.time().milliseconds()).toString()), (Object)var8_8);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaTombstoneParsing() {
        void var6_6;
        void var5_5;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, null), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var5_5);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var6_6);
    }

    private void expectQuotaRecordsLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records) {
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectQuotaRecordsLoad(logMock, startOffset, records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.expect((Object)this.replicaManager().logManager()).andStubReturn((Object)this.logManager());
        this.logManager().abortAndPauseCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.logManager().resumeCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.logManager()});
    }

    private long expectQuotaRecordsLoad(AbstractLog logMock, long startOffset, MemoryRecords records) {
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchIsolation.LOG_END), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private SimpleRecord createQuotaRecord(QuotaEntity quotaEntity, QuotaEntry quotaEntry) {
        byte[] quotaRecordKey = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] quotaRecordValue = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        return new SimpleRecord(quotaRecordKey, quotaRecordValue);
    }

    private Capture<Map<TopicPartition, MemoryRecords>> expectAppendMessages(Seq<Errors> errors) {
        Capture capturedCallback = EasyMock.newCapture();
        Capture capturedRecords = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)capturedRecords), (Function1)EasyMock.capture((Capture)capturedCallback), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject(), (ActionQueue)EasyMock.anyObject(), (Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedCallback, errors){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture capturedCallback$1;
            private final Seq errors$1;

            public void answer() {
                ((Function1)this.capturedCallback$1.getValue()).apply((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.numQuotasPartitions()).map((Function1 & Serializable)i -> $anon$6.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$6 $this, int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc($this.$outer.quotaTopicPartitions().apply(i)), (Object)new ProduceResponse.PartitionResponse((Errors)$this.errors$1.apply(i), 0L, -1L, 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedCallback$1 = capturedCallback$1;
                this.errors$1 = errors$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.quota.QuotaStateManagerTest$$anon$6 java.lang.Object )}, serializedLambda);
            }
        });
        return capturedRecords;
    }

    private static final void callback$1(Map errors, ObjectRef maybeErrors$1) {
        maybeErrors$1.elem = (Map)errors.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Errors error = (Errors)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Some((Object)error));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$testStoreQuotas$5(Seq expectedErrors$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int i = x0$1._1$mcI$sp();
            Option errorOpt = (Option)x0$1._2();
            if (errorOpt instanceof Some) {
                Errors error = (Errors)((Some)errorOpt).value();
                Assertions.assertEquals((Object)expectedErrors$1.apply(i), (Object)error);
                return;
            }
            if (None$.MODULE$.equals(errorOpt)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(51).append("Partition ").append(i).append(" was not processed by the append callback").toString());
                return;
            }
            throw new MatchError((Object)errorOpt);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testEKCUCalculation$2(QuotaStateManagerTest $this, String tenant) {
        return $this.quotaStateManager().registerGauge(tenant);
    }

    public static final /* synthetic */ boolean $anonfun$testNoMaxECKUDefinition$1(QuotaStateManagerTest $this, String tenant) {
        return $this.quotaStateManager().registerGauge(tenant);
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$2(String metric$1, QuotaEntity quotaEntity$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.getName();
            if (!(string != null ? !string.equals(metric$1) : metric$1 != null)) {
                String string2 = metricName.getType();
                String string3 = "QuotaStateManager";
                if (string2 != null && string2.equals(string3) && metricName.getMBeanName().contains(new StringBuilder(1).append(((Tuple2)quotaEntity$1.entityTypes().head())._1()).append("=").append(((Tuple2)quotaEntity$1.entityTypes().head())._2()).toString())) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotas$1(QuotaStateManager eta$0$1$1, QuotaEntity quotaEntity) {
        return eta$0$1$1.getAndMaybePutQuota(quotaEntity);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotasWithWriteFailure$1(QuotaStateManager eta$0$1$2, QuotaEntity quotaEntity) {
        return eta$0$1$2.getAndMaybePutQuota(quotaEntity);
    }

    public QuotaStateManagerTest() {
        this.numQuotasPartitions = 2;
        this.brokerId = 0;
        this.entityType = "tenant";
        this.quotaType = "quotaType";
        this.quota = 60000.0;
        this.usage = 3000.0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        int x$2 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        short x$4 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        CompressionType x$5 = config.confluentConfig().quotasTopicCompressionType();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        QuotaCoordinatorConfig$ apply$default$10_this = QuotaCoordinatorConfig$.MODULE$;
        Object var20_11 = null;
        int x$11 = apply$default$10_this.DefaultQuotasConsumptionExpirationTimeMs();
        QuotaCoordinatorConfig$ apply$default$11_this = QuotaCoordinatorConfig$.MODULE$;
        Object var21_13 = null;
        long x$12 = apply$default$11_this.DefaultBrokerLimitProducer();
        QuotaCoordinatorConfig$ apply$default$12_this = QuotaCoordinatorConfig$.MODULE$;
        Object var22_15 = null;
        long x$13 = apply$default$12_this.DefaultBrokerLimitProducer();
        QuotaCoordinatorConfig$ apply$default$13_this = QuotaCoordinatorConfig$.MODULE$;
        Object var23_17 = null;
        long x$14 = apply$default$13_this.DefaultQuotasRecomputeIntervalMs();
        QuotaCoordinatorConfig$ apply$default$14_this = QuotaCoordinatorConfig$.MODULE$;
        Object var24_19 = null;
        double x$15 = apply$default$14_this.DefaultQuotasLazyEvaluationThreshold();
        this.quotaConfig = new QuotaCoordinatorConfig(x$2, x$4, x$3, x$1, x$5, x$6, x$7, x$8, x$9, x$11, x$12, x$13, x$14, x$15, true);
    }

    public static final /* synthetic */ Object $anonfun$testStoreQuotas$5$adapted(Seq expectedErrors$1, Tuple2 x0$1) {
        QuotaStateManagerTest.$anonfun$testStoreQuotas$5(expectedErrors$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

