/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\tMc\u0001\u0002\u00192\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0001\r\u0011\"\u0001N\u0011\u001dI\u0006\u00011A\u0005\u0002iCa\u0001\u0019\u0001!B\u0013qe\u0001B1\u0001\u0001\tD\u0001BZ\u0004\u0003\u0006\u0004%\ta\u001a\u0005\tW\u001e\u0011\t\u0011)A\u0005Q\"AAn\u0002BA\u0002\u0013\u0005Q\u000e\u0003\u0005r\u000f\t\u0005\r\u0011\"\u0001s\u0011!!xA!A!B\u0013q\u0007\u0002C;\b\u0005\u000b\u0007I\u0011A4\t\u0011Y<!\u0011!Q\u0001\n!D\u0001b^\u0004\u0003\u0002\u0004%\t\u0001\u001f\u0005\u000b\u0003\u00079!\u00111A\u0005\u0002\u0005\u0015\u0001\"CA\u0005\u000f\t\u0005\t\u0015)\u0003z\u0011)\tYa\u0002BC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003+9!\u0011!Q\u0001\n\u0005=\u0001BCA\f\u000f\t\u0015\r\u0011\"\u0001\u0002\u001a!Q\u0011qE\u0004\u0003\u0002\u0003\u0006I!a\u0007\t\u0013\u0005%rA!a\u0001\n\u00039\u0007BCA\u0016\u000f\t\u0005\r\u0011\"\u0001\u0002.!I\u0011\u0011G\u0004\u0003\u0002\u0003\u0006K\u0001\u001b\u0005\u0007\u007f\u001d!\t!a\r\t\u0013\u0005\u001dsA1A\u0005\n\u0005%\u0003\u0002CA0\u000f\u0001\u0006I!a\u0013\t\u0013\u0005\u0005tA1A\u0005\u0002\u0005\r\u0004\u0002CA9\u000f\u0001\u0006I!!\u001a\t\u0011\u0005Mt\u0001\"\u00112\u0003kB\u0001\"a\u001e\b\t\u0003\n\u0014\u0011\u0010\u0005\t\u0003\u0017;A\u0011I\u0019\u0002v\u001dI\u0011Q\u0012\u0001\u0002\u0002#\u0005\u0011q\u0012\u0004\tC\u0002\t\t\u0011#\u0001\u0002\u0012\"1qH\tC\u0001\u0003'C\u0011\"!&##\u0003%\t!a&\t\u0013\u00055&%%A\u0005\u0002\u0005=\u0006\"CAZEE\u0005I\u0011AA[\u0011%\tILII\u0001\n\u0003\tY\fC\u0004\u0002@\u0002!\t!!\u001e\t\u000f\u0005]\u0007\u0001\"\u0001\u0002v!9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005W\u0001A\u0011AA;\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003kBqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003<\u0001!IA!\u0010\u0003+A\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000fV3ti*\u0011!gM\u0001\fiJ\fgn]1di&|gN\u0003\u00025k\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00051\u0014!B6bM.\f7\u0001A\n\u0003\u0001e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001B!\t\u0011\u0005!D\u00012\u0003!Q8n\u00117jK:$X#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0014A\u0001>l\u0013\tQuIA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\n!C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7feV\ta\n\u0005\u0002P/6\t\u0001K\u0003\u0002R%\u000611/\u001a:wKJT!AN*\u000b\u0005Q+\u0016AB1qC\u000eDWMC\u0001W\u0003\ry'oZ\u0005\u00031B\u0013aDT8eKR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002-\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]0%KF$\"a\u00170\u0011\u0005ib\u0016BA/<\u0005\u0011)f.\u001b;\t\u000f}+\u0011\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010J\u0019\u0002'\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM\u001d\u0011\u0003+5{7m\u001b)s_\u0012,8-\u001a:JI6\u000bg.Y4feN\u0011qa\u0019\t\u0003\u0005\u0012L!!Z\u0019\u0003)I\u00036\t\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s\u0003!\u0011'o\\6fe&#W#\u00015\u0011\u0005iJ\u0017B\u00016<\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\nq!\u001b3Ti\u0006\u0014H/F\u0001o!\tQt.\u0003\u0002qw\t!Aj\u001c8h\u0003-IGm\u0015;beR|F%Z9\u0015\u0005m\u001b\bbB0\f\u0003\u0003\u0005\rA\\\u0001\tS\u0012\u001cF/\u0019:uA\u0005)\u0011\u000e\u001a'f]\u00061\u0011\u000e\u001a'f]\u0002\nQ!\u001a:s_J,\u0012!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003}J\u000baaY8n[>t\u0017bAA\u0001w\n1QI\u001d:peN\f\u0011\"\u001a:s_J|F%Z9\u0015\u0007m\u000b9\u0001C\u0004`!\u0005\u0005\t\u0019A=\u0002\r\u0015\u0014(o\u001c:!\u0003AI7/\u0012:s_:,w.^:CY>\u001c7.\u0006\u0002\u0002\u0010A\u0019!(!\u0005\n\u0007\u0005M1HA\u0004C_>dW-\u00198\u0002#%\u001cXI\u001d:p]\u0016|Wo\u001d\"m_\u000e\\\u0007%\u0001\u0003uS6,WCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011{\u0006)Q\u000f^5mg&!\u0011QEA\u0010\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!I,W.Y5oS:<'+\u001a;sS\u0016\u001c\u0018\u0001\u0006:f[\u0006Lg.\u001b8h%\u0016$(/[3t?\u0012*\u0017\u000fF\u0002\\\u0003_AqaX\f\u0002\u0002\u0003\u0007\u0001.A\tsK6\f\u0017N\\5oOJ+GO]5fg\u0002\"\u0002#!\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0011\u0007\u0005]r!D\u0001\u0001\u0011\u00151\u0017\u00041\u0001i\u0011\u0015a\u0017\u00041\u0001o\u0011\u0015)\u0018\u00041\u0001i\u0011\u001d9\u0018\u0004%AA\u0002eD\u0011\"a\u0003\u001a!\u0003\u0005\r!a\u0004\t\u0013\u0005]\u0011\u0004%AA\u0002\u0005m\u0001\u0002CA\u00153A\u0005\t\u0019\u00015\u00023\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002\\5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0016\u0002X\u0005!Q\u000f^5m\u0015\t\tI&\u0001\u0003kCZ\f\u0017\u0002BA/\u0003\u001f\u0012q\"\u0012=fGV$xN]*feZL7-Z\u0001\u001bEJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G\u000eI\u0001\u0010G\u0006\u0004H/\u001e:fI\u001a\u000b\u0017\u000e\\;sKV\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)!\u00111NA(\u0003\u0019\tGo\\7jG&!\u0011qNA5\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u00012-\u00199ukJ,GMR1jYV\u0014X\rI\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000fF\u0001\\\u0003\u0005B\u0017M\u001c3mK\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:SKN\u0004xN\\:f)\rY\u00161\u0010\u0005\b\u0003{z\u0002\u0019AA@\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015U0\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tI)a!\u00037\u0005cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:SKN\u0004xN\\:f\u0003Ui\u0017-\u001f2f%\u0016\fX/Z:u\u001d\u0016DHO\u00117pG.\fQ#T8dWB\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000fE\u0002\u00028\t\u001a\"AI\u001d\u0015\u0005\u0005=\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001a*\u001a\u00110a',\u0005\u0005u\u0005\u0003BAP\u0003Sk!!!)\u000b\t\u0005\r\u0016QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a*<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\u000b\tKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAAYU\u0011\ty!a'\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t9L\u000b\u0003\u0002\u001c\u0005m\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0002>*\u001a\u0001.a'\u0002'Q,7\u000f^$fiB\u0013x\u000eZ;dKJLEMW6)\u0007!\n\u0019\r\u0005\u0003\u0002F\u0006MWBAAd\u0015\u0011\tI-a3\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002N\u0006=\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003#,\u0016!\u00026v]&$\u0018\u0002BAk\u0003\u000f\u0014A\u0001V3ti\u0006YB/Z:u\u000bb\u001cW-\u001a3Qe>$WoY3s\u0013\u0012d\u0015.\\5u5.D3!KAb\u0003\u0005\"Xm\u001d;D_:\u001cWO\u001d:f]R<UM\\3sCR,\u0007+\u001b3SKF,Xm\u001d;t)\rY\u0016q\u001c\u0005\u0007\u0003CT\u0003\u0019\u00015\u0002\u0015%$'\t\\8dW2+g\u000eK\u0002+\u0003K\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fY-\u0001\u0004qCJ\fWn]\u0005\u0005\u0003_\fIOA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDsAKAz\u0003\u007f\u0014\t\u0001\u0005\u0003\u0002v\u0006mXBAA|\u0015\u0011\tI0!;\u0002\u0011A\u0014xN^5eKJLA!!@\u0002x\nYa+\u00197vKN{WO]2f\u0003\u0011Ig\u000e^:-\u0011\t\r!Q\u0001B\u0004\u0005\u0013i\u0012!A\u000f\u0002\u0005u\t!\"H\u0001e\u0003]!Xm\u001d;V]J,7m\u001c<fe\u0006\u0014G.Z#se>\u00148\u000fF\u0002\\\u0005\u001fAQa^\u0016A\u0002eD3aKAsQ-Y#Q\u0003B\u000e\u0005;\u0011yB!\t\u0011\t\u0005U(qC\u0005\u0005\u00053\t9P\u0001\u0006F]Vl7k\\;sG\u0016\fQA^1mk\u0016\u001c\u0013!_\u0001\u0006]\u0006lWm\u001d\u0017\u0005\u0005G\u00119#\t\u0002\u0003&\u0005!RKT&O\u001f^sulU#S-\u0016\u0013v,\u0012*S\u001fJ\u000b#A!\u000b\u0002\u001f%se+\u0011'J\t~\u0013V)U+F'R\u000b\u0011\u0003^3ti&sg/\u00197jIJ\u000bgnZ3tQ\ra\u00131Y\u0001\u0011i\u0016\u001cHOU3uef\u0014\u0015mY6pM\u001aD3!LAb\u000351XM]5gs\u001a\u000b\u0017\u000e\\;sKR\u00191La\u000e\t\u000f\teb\u00061\u0001\u00026\u00059Q.\u00198bO\u0016\u0014\u0018a\u0007<fe&4\u0017PT3x\u00052|7m[!oIB\u0013x\u000eZ;dKJLE\rF\u0004\\\u0005\u007f\u0011\tEa\u0014\t\u000f\ter\u00061\u0001\u00026!9!1I\u0018A\u0002\t\u0015\u0013!D3ya\u0016\u001cG/\u001a3CY>\u001c7\u000e\u0005\u0003\u0003H\t-SB\u0001B%\u0015\tq\b+\u0003\u0003\u0003N\t%#\u0001\u0005)s_\u0012,8-\u001a:JIN\u0014En\\2l\u0011\u0019\u0011\tf\fa\u0001]\u0006YQ\r\u001f9fGR,G\rU5e\u0001")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(NodeToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get());
        long pid2 = BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get());
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get())));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get())));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get()));
        Assertions.assertEquals((long)(pid2 + 2000L), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get()));
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10, 100})
    public void testConcurrentGeneratePidRequests(int idBlockLen) {
        int numThreads = 5;
        CountDownLatch latch = new CountDownLatch(idBlockLen * 3);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, Errors.NONE, false, Time.SYSTEM, 1);
        Map pidMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ExecutorService requestHandlerThreadPool = Executors.newFixedThreadPool(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach((Function1 & Serializable)x$5 -> requestHandlerThreadPool.submit(() -> {
            while (latch$1.getCount() > 0L) {
                Try result = manager$1.generateProducerId();
                if (result instanceof Success) {
                    long pid = BoxesRunTime.unboxToLong((Object)((Success)result).value());
                    synchronized (pidMap$1) {
                        if (latch$1.getCount() != 0L) {
                            int counter = BoxesRunTime.unboxToInt((Object)pidMap$1.getOrElse((Object)BoxesRunTime.boxToLong((long)pid), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                            pidMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)pid)), (Object)BoxesRunTime.boxToInteger((int)(counter + 1))));
                            latch$1.countDown();
                        }
                    }
                } else if (result instanceof Failure) {
                    Throwable exception = ((Failure)result).exception();
                    Assertions.assertEquals(CoordinatorLoadInProgressException.class, exception.getClass());
                } else {
                    throw new MatchError((Object)result);
                }
                Thread.sleep(100L);
            }
        }, BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertTrue((boolean)latch.await(12000L, TimeUnit.MILLISECONDS));
        requestHandlerThreadPool.shutdown();
        Assertions.assertEquals((int)(idBlockLen * 3), (int)pidMap.size());
        pidMap.foreach((Function1 & Serializable)x0$1 -> {
            ProducerIdManagerTest.$anonfun$testConcurrentGeneratePidRequests$4(idBlockLen, numThreads, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        MockTime time = new MockTime();
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$5 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        boolean x$6 = false;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$7 = 1;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, x$5, x$6, (Time)time, x$7);
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
        manager.error_$eq(error);
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyFailure(manager);
        manager.error_$eq(Errors.NONE);
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 1L, 1), 1L);
    }

    @Test
    public void testInvalidRanges() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$5 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$6 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$7 = 1;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, -1L, 10, x$5, true, x$6, x$7);
        this.verifyFailure(manager);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$12 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$13 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$14 = 1;
        manager = new MockProducerIdManager(this, 0, 0L, -1, x$12, true, x$13, x$14);
        this.verifyFailure(manager);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$19 = Errors.NONE;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Time x$20 = Time.SYSTEM;
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        int x$21 = 1;
        manager = new MockProducerIdManager(this, 0, 0x7FFFFFFFFFFFFFFEL, 10, x$19, true, x$20, x$21);
        this.verifyFailure(manager);
    }

    @Test
    public void testRetryBackoff() {
        MockTime time = new MockTime();
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        boolean x$7 = false;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, Errors.UNKNOWN_SERVER_ERROR, x$7, (Time)time, 2);
        this.verifyFailure(manager);
        manager.error_$eq(Errors.NONE);
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFailure(MockProducerIdManager manager) {
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyFailure$1(manager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected failure");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        manager.capturedFailure().set(false);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNewBlockAndProducerId(MockProducerIdManager manager, ProducerIdsBlock expectedBlock, long expectedPid) {
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, manager.generateProducerId().failed().get().getClass());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyNewBlockAndProducerId$1(manager, expectedBlock)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to generate block");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedPid, (long)BoxesRunTime.unboxToLong((Object)manager.generateProducerId().get()));
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testConcurrentGeneratePidRequests$4(int idBlockLen$1, int numThreads$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long pid = x0$1._1$mcJ$sp();
            int count = x0$1._2$mcI$sp();
            Assertions.assertEquals((int)1, (int)count);
            Assertions.assertTrue((pid < (long)(3 * idBlockLen$1 + numThreads$1) ? 1 : 0) != 0, (String)new StringBuilder(81).append("Unexpected pid ").append(pid).append("; ").append("non-contiguous blocks generated or did not fully exhaust blocks.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFailure$1(MockProducerIdManager manager$2) {
        synchronized (manager$2) {
            boolean bl = manager$2.capturedFailure().get();
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyFailure$2() {
        return "Expected failure";
    }

    public static final /* synthetic */ boolean $anonfun$verifyNewBlockAndProducerId$1(MockProducerIdManager manager$3, ProducerIdsBlock expectedBlock$1) {
        ProducerIdsBlock nextBlock = (ProducerIdsBlock)manager$3.nextProducerIdBlock().get();
        return nextBlock != null && nextBlock.equals((Object)expectedBlock$1);
    }

    public static final /* synthetic */ String $anonfun$verifyNewBlockAndProducerId$2() {
        return "failed to generate block";
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private Errors error;
        private final boolean isErroneousBlock;
        private final Time time;
        private int remainingRetries;
        private final ExecutorService brokerToControllerChannel;
        private final AtomicBoolean capturedFailure;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public Errors error() {
            return this.error;
        }

        public void error_$eq(Errors x$1) {
            this.error = x$1;
        }

        public boolean isErroneousBlock() {
            return this.isErroneousBlock;
        }

        public Time time() {
            return this.time;
        }

        public int remainingRetries() {
            return this.remainingRetries;
        }

        public void remainingRetries_$eq(int x$1) {
            this.remainingRetries = x$1;
        }

        private ExecutorService brokerToControllerChannel() {
            return this.brokerToControllerChannel;
        }

        public AtomicBoolean capturedFailure() {
            return this.capturedFailure;
        }

        public void sendRequest() {
            this.brokerToControllerChannel().submit(() -> {
                Errors errors = this.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                    if (!this.isErroneousBlock()) {
                        this.idStart_$eq(this.idStart() + (long)this.idLen());
                        return;
                    }
                    return;
                }
                this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(this.error().code())));
            }, BoxesRunTime.boxToInteger((int)0));
        }

        public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
            super.handleAllocateProducerIdsResponse(response);
            this.capturedFailure().set(this.nextProducerIdBlock().get() == null);
        }

        public void maybeRequestNextBlock() {
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && !this.isErroneousBlock()) {
                super.maybeRequestNextBlock();
                return;
            }
            if (this.remainingRetries() > 0) {
                super.maybeRequestNextBlock();
                this.remainingRetries_$eq(this.remainingRetries() - 1);
                return;
            }
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, Errors error, boolean isErroneousBlock, Time time, int remainingRetries) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.error = error;
            this.isErroneousBlock = isErroneousBlock;
            this.time = time;
            this.remainingRetries = remainingRetries;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, time, (Function0)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final long apply() {
                    return 1L;
                }

                public final long apply$mcJ$sp() {
                    return 1L;
                }
            }, $outer.brokerToController());
            this.brokerToControllerChannel = Executors.newSingleThreadExecutor();
            this.capturedFailure = new AtomicBoolean(false);
        }
    }
}

