/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\teb\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003U\u0011\u0019Q\u0006\u0001)A\u0005+\"91\f\u0001b\u0001\n\u0013a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\n5Da!\u001d\u0001!\u0002\u0013q\u0007b\u0002:\u0001\u0005\u0004%I!\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u00028\t\u000fQ\u0004!\u0019!C\u0005)\"1Q\u000f\u0001Q\u0001\nUCqA\u001e\u0001C\u0002\u0013%A\u000b\u0003\u0004x\u0001\u0001\u0006I!\u0016\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u001d\ty\u0001\u0001Q\u0001\niD\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005u\u0001\u0001)A\u0005\u0003+A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003_A\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u001b\t\u0011\u0005U\u0004\u0001)A\u0005\u0003WB\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wB\u0011\"a!\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003wBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\u0012\u0002!\t!!#\t\u000f\u0005%\u0006\u0001\"\u0001\u0002\n\"9\u0011Q\u0016\u0001\u0005\u0002\u0005%\u0005bBAY\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003k\u0003A\u0011AAE\u0011\u001d\tI\f\u0001C\u0001\u0003\u0013Cq!!0\u0001\t\u0003\tI\tC\u0004\u0002B\u0002!\t!!#\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002\n\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005%\u0005bBAg\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003#\u0004A\u0011AAE\u0011\u001d\t)\u000e\u0001C\u0001\u0003\u0013Cq!!7\u0001\t\u0003\tI\tC\u0004\u0002^\u0002!\t!!#\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002\n\"9\u0011Q\u001d\u0001\u0005\u0002\u0005%\u0005bBAu\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003[\u0004A\u0011AAE\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\f\u0001!IA!\u0004\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0002.)J\fgn]1di&|g.T1sW\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:UKN$(B\u0001\"D\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u0011+\u0015aC2p_J$\u0017N\\1u_JT\u0011AR\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0003\"A\u0015\u0001\u000e\u0003\u0005\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002+B\u0011!JV\u0005\u0003/.\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8oA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002QB\u0011!*[\u0005\u0003U.\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\ta\u000e\u0005\u0002K_&\u0011\u0001o\u0013\u0002\u0006'\"|'\u000f^\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0003Ea\u0017m\u001d;Qe>$WoY3s\u000bB|7\r[\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0007%\u0001\u0007uq:$\u0016.\\3pkRl5/A\u0007uq:$\u0016.\\3pkRl5\u000fI\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\f\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0003%!\bP\u001c*fgVdG/F\u0001{!\rY\u00181B\u0007\u0002y*\u0011QP`\u0001\te\u0016\fX/Z:ug*\u0019q0!\u0001\u0002\r\r|W.\\8o\u0015\r1\u00151\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\t1a\u001c:h\u0013\r\ti\u0001 \u0002\u0012)J\fgn]1di&|gNU3tk2$\u0018A\u0003;y]J+7/\u001e7uA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u000b!\u0011\t9\"!\u0007\u000e\u0003yL1!a\u0007\u007f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\fibtW*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002$A\u0019!+!\n\n\u0007\u0005\u001d\u0012IA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-\u0001\u0007uq:lU\r^1eCR\f\u0007%\u0001\u000fqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM]:\u0016\u0005\u0005=\u0002CBA\u0019\u0003o\tY$\u0004\u0002\u00024)\u0019\u0011QG1\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0003MSN$\bc\u0001*\u0002>%\u0019\u0011qH!\u0003AA+g\u000eZ5oO\u000e{W\u000e\u001d7fi\u0016$\u0006P\\!oI6\u000b'o[3s\u000b:$(/_\u0001\u001ea\u0016tG-\u001b8h\u0007>l\u0007\u000f\\3uKRCh.\u00118e\u001b\u0006\u00148.\u001a:tA\u0005!R.\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\"!a\u0012\u0011\u0007I\u000bI%C\u0002\u0002L\u0005\u0013q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Ui\u0017M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0002\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0003\u0003'\u00022AUA+\u0013\r\t9&\u0011\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u000f!\fg\u000e\u001a7feV\u0011\u0011q\f\t\u0004%\u0006\u0005\u0014bAA2\u0003\nICK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\f\u0001\u0002[1oI2,'\u000fI\u0001\b[\u0016$(/[2t+\t\tY\u0007\u0005\u0003\u0002n\u0005ETBAA8\u0015\r\t9G`\u0005\u0005\u0003g\nyGA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0001d\u001d;bi\u0016,%O]8s%\u0006$X-T3ue&\u001cg*Y7f+\t\tY\b\u0005\u0003\u0002\u0018\u0005u\u0014bAA@}\nQQ*\u001a;sS\u000et\u0015-\\3\u00023M$\u0018\r^3FeJ|'OU1uK6+GO]5d\u001d\u0006lW\rI\u0001\u001agR\fG/Z#se>\u00148i\\;oi6+GO]5d\u001d\u0006lW-\u0001\u000eti\u0006$X-\u0012:s_J\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0007%A\u0005n_\u000e\\7)Y2iKR\u0011\u00111\u0012\t\u0004\u0015\u00065\u0015bAAH\u0017\n!QK\\5u\u0003=\u001a\bn\\;mIJ+WI\\9vKV,\u0007+\u0019:uSRLwN\\:XQ\u0016t'I]8lKJ$\u0015n]2p]:,7\r^3eQ\r9\u0013Q\u0013\t\u0005\u0003/\u000b)+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\r\t\u0007/\u001b\u0006\u0005\u0003?\u000b\t+A\u0004kkBLG/\u001a:\u000b\t\u0005\r\u0016qA\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\u000bIJ\u0001\u0003UKN$\u0018!P:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Le-\u0012:s_J\u001cu\u000eZ3O_R\fe/Y5mC\ndWMR8s!&$\u0007f\u0001\u0015\u0002\u0016\u0006Q3\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK:tu.\u0012:s_J\u001c\bfA\u0015\u0002\u0016\u0006\u00014\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK:tu\u000e^\"p_J$\u0017N\\1u_JD3AKAK\u0003Q\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u00165f]\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012Lgn\u001a\u0015\u0004W\u0005U\u0015!O:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gnQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195DQ\u0006tw-\u001a3)\u00071\n)*\u0001\u001ctQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\\%om\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eK\u0002.\u0003+\u000b\u0001h\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016t7i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b$f]\u000e,G\rK\u0002/\u0003+\u000b\u0001g\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\\+oW:|wO\\#se>\u0014\bfA\u0018\u0002\u0016\u000694\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",gnQ8seV\u0004H/T3tg\u0006<W-\u0012:s_JD3\u0001MAK\u0003a\u001a\bn\\;mIRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8XQ\u0016tW*Z:tC\u001e,Gk\\8MCJ<W-\u0012:s_JD3!MAK\u0003m\u001a\bn\\;mIRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8XQ\u0016t'+Z2pe\u0012d\u0015n\u001d;U_>d\u0015M]4f\u000bJ\u0014xN\u001d\u0015\u0004e\u0005U\u0015\u0001P:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8J]Z\fG.\u001b3SKF,\u0018N]3e\u0003\u000e\\7/\u0012:s_JD3aMAK\u0003Q\u001a\bn\\;mIJ+GO]=QCJ$\u0018\u000e^5p]^CWM\\+oW:|wO\u001c+pa&\u001cwJ\u001d)beRLG/[8o\u000bJ\u0014xN\u001d\u0015\u0004i\u0005U\u0015\u0001M:i_VdGMU3uef\u0004\u0016M\u001d;ji&|gn\u00165f]:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:FeJ|'\u000fK\u00026\u0003+\u000baf\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o\u001d>$XI\\8vO\"\u0014V\r\u001d7jG\u0006\u001cXI\u001d:pe\"\u001aa'!&\u0002sMDw.\u001e7e%\u0016$(/\u001f)beRLG/[8o/\",gNT8u\u000b:|Wo\u001a5SKBd\u0017nY1t\u0003\u001a$XM]!qa\u0016tG-\u0012:s_JD3aNAK\u0003%\u001a\bn\\;mIJ+GO]=QCJ$\u0018\u000e^5p]^CWM\\&bM.\f7\u000b^8sC\u001e,WI\u001d:pe\"\u001a\u0001(!&\u0002\u000bNDw.\u001e7e%\u0016lwN^3U_BL7\rU1si&$\u0018n\u001c8Ge>lw+Y5uS:<7+\u001a;P]Vs7/\u001e9q_J$X\r\u001a$pe6+7o]1hK\u001a{'/\\1uQ\rI\u0014QS\u0001\u001em\u0016\u0014\u0018NZ=SKR\u0014\u0018.Z:QCJ$\u0018\u000e^5p]>sWI\u001d:peR!\u00111RA{\u0011\u001d\t9P\u000fa\u0001\u0003s\fQ!\u001a:s_J\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007ft\u0018\u0001\u00039s_R|7m\u001c7\n\t\t\r\u0011Q \u0002\u0007\u000bJ\u0014xN]:\u0002OY,'/\u001b4z)\"\u0014xn^%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003\u0017\u0013I\u0001C\u0004\u0002xn\u0002\r!!?\u0002KY,'/\u001b4z\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>twJ\\#se>\u0014H\u0003BAF\u0005\u001fAq!a>=\u0001\u0004\tI0A\u0012wKJLg-\u001f*f[>4X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005-%Q\u0003\u0005\b\u0003ol\u0004\u0019AA}\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJLE-\u0012:s_Jl\u0015\r\u001d\u000b\u0005\u00057\u0011Y\u0003\u0005\u0005\u00022\tu!\u0011\u0005B\u0013\u0013\u0011\u0011y\"a\r\u0003\u000f!\u000b7\u000f['baB\u0019aLa\t\n\u0005)|\u0006\u0003CA\u0019\u0005O\t)\"!?\n\t\t%\u00121\u0007\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u0017}\u0001\u0007\u0011\u0011`\u0001\u0007KJ\u0014xN]:\u0002+M,G/\u001e9Ti\u0006$X-\u0012:s_J\u001cVM\\:peR\u0011!1\u0007\t\u0005\u0003[\u0012)$\u0003\u0003\u00038\u0005=$AB*f]N|'\u000f")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkers = Arrays.asList(new PendingCompleteTxnAndMarkerEntry(new PendingCompleteTxn(this.transactionalId(), this.coordinatorEpoch(), this.txnMetadata(), this.txnMetadata().prepareComplete(42L)), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.topicPartition()))));
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)Mockito.mock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.pendingCompleteTxnAndMarkers());
    private final Metrics metrics = new Metrics();
    private final MetricName stateErrorRateMetricName = this.metrics().metricName("transaction-state-error-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which state errors occur within the transaction coordinator");
    private final MetricName stateErrorCountMetricName = this.metrics().metricName("transaction-state-error-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of state errors that have occurred within the transaction coordinator");

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkers() {
        return this.pendingCompleteTxnAndMarkers;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public MetricName stateErrorRateMetricName() {
        return this.stateErrorRateMetricName;
    }

    public MetricName stateErrorCountMetricName() {
        return this.stateErrorCountMetricName;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata()))));
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.producerId(), this.producerEpoch(), this.txnResult(), this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        Mockito.when((Object)this.txnStateManager().stateErrorSensor()).thenReturn((Object)this.setupStateErrorSensor());
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorCountMetricName()).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorRateMetricName()).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata()))));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderOrFollowerError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRetryPartitionWhenKafkaStorageError() {
        this.verifyRetriesPartitionOnError(Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.producerId(), this.producerEpoch(), this.txnResult(), this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    private void verifyThrowIllegalStateExceptionOnError(Errors error) {
        Mockito.when((Object)this.txnStateManager().stateErrorSensor()).thenReturn((Object)this.setupStateErrorSensor());
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorCountMetricName()).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorRateMetricName()).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().maybeWriteTxnCompletion(this.transactionalId());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            completed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assertions.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        PendingCompleteTxn pendingCompleteTxn = this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn();
        this.markerChannelManager().removeMarkersForTxn(pendingCompleteTxn);
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            removed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)removed.elem);
    }

    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        HashMap<Long, Map<TopicPartition, Errors>> pidMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return pidMap;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor setupStateErrorSensor() {
        void add_stat;
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Sensor sensor = this.metrics().sensor("TransactionStateErrors");
        Meter meter = new Meter(this.stateErrorRateMetricName(), this.stateErrorCountMetricName());
        if (sensor == null) {
            throw null;
        }
        sensor.add((CompoundStat)add_stat, null);
        return sensor;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

