/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.job.AuditJobResult;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.durability.utils.DurabilityTierTopicReader;
import kafka.durability.utils.OffsetInfo;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.UploadCompleteEvent;
import kafka.durability.utils.UploadInitiateEvent;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SortedMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5f\u0001B2e\u0001-DQA\u001d\u0001\u0005\u0002MD\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011A<\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013A\bbCA\t\u0001\u0001\u0007\t\u0019!C\u0001\u0003'A1\"!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002$!Y\u0011q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%\t!a\u000b\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013\u0005\u0011\u0011\n\u0005\f\u0003\u001b\u0002\u0001\u0019!A!B\u0013\ti\u0003C\u0006\u0002P\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0003bCA0\u0001\u0001\u0007\t\u0019!C\u0001\u0003CB1\"!\u001a\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002T!I\u0011q\r\u0001A\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0001\u0003#C\u0001\"!&\u0001A\u0003&\u00111\u000e\u0005\n\u0003/\u0003\u0001\u0019!C\u0001\u00033C\u0011\"!+\u0001\u0001\u0004%\t!a+\t\u0011\u0005=\u0006\u0001)Q\u0005\u00037C\u0011\"!-\u0001\u0001\u0004%\t!a-\t\u0013\u0005\u0015\u0007\u00011A\u0005\u0002\u0005\u001d\u0007\u0002CAf\u0001\u0001\u0006K!!.\t\u0013\u00055\u0007A1A\u0005\u0002\u0005=\u0007\u0002CAl\u0001\u0001\u0006I!!5\t\u0017\u0005e\u0007\u00011AA\u0002\u0013\u0005\u00111\u001c\u0005\f\u0003O\u0004\u0001\u0019!a\u0001\n\u0003\tI\u000fC\u0006\u0002n\u0002\u0001\r\u0011!Q!\n\u0005u\u0007bCAx\u0001\u0001\u0007\t\u0019!C\u0001\u0003cD1\"!?\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002|\"Y\u0011q \u0001A\u0002\u0003\u0005\u000b\u0015BAz\u0011-\u0011\t\u0001\u0001a\u0001\u0002\u0004%\tAa\u0001\t\u0017\t-\u0001\u00011AA\u0002\u0013\u0005!Q\u0002\u0005\f\u0005#\u0001\u0001\u0019!A!B\u0013\u0011)\u0001C\u0006\u0003\u0014\u0001\u0001\r\u00111A\u0005\u0002\tU\u0001b\u0003B\u0010\u0001\u0001\u0007\t\u0019!C\u0001\u0005CA1B!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0018!I!q\u0005\u0001C\u0002\u0013\u0005!\u0011\u0006\u0005\t\u0005#\u0002\u0001\u0015!\u0003\u0003,!I!1\u000b\u0001C\u0002\u0013\u0005!Q\u000b\u0005\t\u0005O\u0002\u0001\u0015!\u0003\u0003X!Y!\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001B6\u0011-\u0011i\u0007\u0001a\u0001\u0002\u0004%\tAa\u001c\t\u0017\tM\u0004\u00011A\u0001B\u0003&\u00111\u0011\u0005\n\u0005k\u0002\u0001\u0019!C\u0001\u0005oB\u0011B!\u001f\u0001\u0001\u0004%\tAa\u001f\t\u0011\t}\u0004\u0001)Q\u0005\u0003GC\u0011B!!\u0001\u0001\u0004%\tAa!\t\u0013\t=\u0005\u00011A\u0005\u0002\tE\u0005\u0002\u0003BK\u0001\u0001\u0006KA!\"\t\u0013\t]\u0005\u00011A\u0005\u0002\te\u0005\"\u0003BQ\u0001\u0001\u0007I\u0011\u0001BR\u0011!\u00119\u000b\u0001Q!\n\tm\u0005\"\u0003BU\u0001\u0001\u0007I\u0011\u0001BV\u0011%\u00119\f\u0001a\u0001\n\u0003\u0011I\f\u0003\u0005\u0003>\u0002\u0001\u000b\u0015\u0002BW\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003DqA!7\u0001\t\u0003\u0011\t\rC\u0004\u0003d\u0002!\tA!1\t\u000f\t5\b\u0001\"\u0001\u0003B\"9!\u0011\u001f\u0001\u0005\u0002\t\u0005\u0007b\u0002B{\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0005s\u0004A\u0011\u0002B~\u0011\u001d\u0019i\u0002\u0001C\u0001\u0005\u0003Dqa!\t\u0001\t\u0003\u0011\t\rC\u0004\u0004&\u0001!\tA!1\t\u000f\r%\u0002\u0001\"\u0001\u0003B\"91Q\u0006\u0001\u0005\u0002\t\u0005\u0007bBB\u0019\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0007k\u0001A\u0011\u0001Ba\u0011\u001d\u0019I\u0004\u0001C\u0001\u0005\u0003Dqa!\u0010\u0001\t\u0003\u0011\t\rC\u0004\u0004B\u0001!\tA!1\t\u000f\r\u0015\u0003\u0001\"\u0001\u0003B\"91\u0011\n\u0001\u0005\u0002\t\u0005\u0007bBB'\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0007#\u0002A\u0011\u0001Ba\u0011\u001d\u0019)\u0006\u0001C\u0001\u0005\u0003Dqa!\u0017\u0001\t\u0003\u0011\t\rC\u0004\u0004^\u0001!\tA!1\t\u000f\r\u0005\u0004\u0001\"\u0001\u0003B\"91Q\r\u0001\u0005\u0002\t\u0005\u0007bBB5\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0007[\u0002A\u0011\u0001Ba\u0011\u001d\u0019\t\b\u0001C\u0001\u0005\u0003Dqa!\u001e\u0001\t\u0003\u0011\t\rC\u0004\u0004z\u0001!\tA!1\t\u000f\ru\u0004\u0001\"\u0001\u0003B\"91\u0011\u0011\u0001\u0005\u0002\t\u0005\u0007bBBC\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0007\u0013\u0003A\u0011\u0001Ba\u0011\u001d\u0019i\t\u0001C\u0001\u0005\u0003Dqa!%\u0001\t\u0003\u0011\t\rC\u0004\u0004\u0016\u0002!\tA!1\t\u000f\re\u0005\u0001\"\u0001\u0003B\"91Q\u0014\u0001\u0005\u0002\t\u0005\u0007bBBQ\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0007K\u0003A\u0011\u0001Ba\u0011\u001d\u0019I\u000b\u0001C\u0001\u0005\u0003\u0014!C\u0011:pW\u0016\u0014\u0018)\u001e3ji*{'\rV3ti*\u0011QMZ\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003O\"\f!\u0002Z;sC\nLG.\u001b;z\u0015\u0005I\u0017!B6bM.\f7\u0001A\n\u0003\u00011\u0004\"!\u001c9\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001u!\t)\b!D\u0001e\u0003\u0019awn\u001a#jeV\t\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006\u0011\u0011n\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR!\u0011QAA\u0006!\ri\u0017qA\u0005\u0004\u0003\u0013q'\u0001B+oSRD\u0001\"!\u0004\u0004\u0003\u0003\u0005\r\u0001_\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eQ\u0006\u0019An\\4\n\t\u0005}\u0011\u0011\u0004\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u000b\t)\u0003C\u0005\u0002\u000e\u0019\t\t\u00111\u0001\u0002\u0016\u0005YAn\\4NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003\u0007j!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005kRLGN\u0003\u0003\u00028\u0005e\u0012AB:feZ,'OC\u0002j\u0003wQA!!\u0010\u0002@\u00051\u0011\r]1dQ\u0016T!!!\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002F\u0005E\"\u0001C'pG.$\u0016.\\3\u0002\u0011QLW.Z0%KF$B!!\u0002\u0002L!I\u0011QB\u0005\u0002\u0002\u0003\u0007\u0011QF\u0001\u0006i&lW\rI\u0001\tCV$\u0017\u000e\u001e&pEV\u0011\u00111\u000b\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f3\u0002\u0007)|'-\u0003\u0003\u0002^\u0005]#A\u0004\"s_.,'/Q;eSRTuNY\u0001\rCV$\u0017\u000e\u001e&pE~#S-\u001d\u000b\u0005\u0003\u000b\t\u0019\u0007C\u0005\u0002\u000e1\t\t\u00111\u0001\u0002T\u0005I\u0011-\u001e3ji*{'\rI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\u0011\u00111\u000e\t\u0007\u0003[\ni(a!\u000f\t\u0005=\u0014\u0011\u0010\b\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f6\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0017bAA>]\u00069\u0001/Y2lC\u001e,\u0017\u0002BA@\u0003\u0003\u00131aU3r\u0015\r\tYH\u001c\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*!\u0011\u0011RA\u001d\u0003\u0019\u0019w.\\7p]&!\u0011QRAD\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]0%KF$B!!\u0002\u0002\u0014\"I\u0011QB\b\u0002\u0002\u0003\u0007\u00111N\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\na\u0002]1si&$\u0018n\u001c8UkBdW-\u0006\u0002\u0002\u001cB1\u0011QNA?\u0003;\u0003r!\\AP\u0003\u0007\u000b\u0019+C\u0002\u0002\":\u0014a\u0001V;qY\u0016\u0014\u0004cA7\u0002&&\u0019\u0011q\u00158\u0003\t1{gnZ\u0001\u0013a\u0006\u0014H/\u001b;j_:$V\u000f\u001d7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u00055\u0006\"CA\u0007%\u0005\u0005\t\u0019AAN\u0003=\u0001\u0018M\u001d;ji&|g\u000eV;qY\u0016\u0004\u0013\u0001C8cUN#xN]3\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\u0006gR|'/\u001a\u0006\u0004\u0003\u007fC\u0017\u0001\u0002;jKJLA!a1\u0002:\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\u0007pE*\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005%\u0007\"CA\u0007+\u0005\u0005\t\u0019AA[\u0003%y'M[*u_J,\u0007%A\u0003k_\nLE-\u0006\u0002\u0002RB\u0019Q.a5\n\u0007\u0005UgNA\u0002J]R\faA[8c\u0013\u0012\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003;\u0004B!a8\u0002d6\u0011\u0011\u0011\u001d\u0006\u0005\u00033\f9)\u0003\u0003\u0002f\u0006\u0005(aB'fiJL7m]\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\b\"CA\u00075\u0005\u0005\t\u0019AAo\u0003!iW\r\u001e:jGN\u0004\u0013AD:j[BdWMU3q_J$XM]\u000b\u0003\u0003g\u00042!^A{\u0013\r\t9\u0010\u001a\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u0002%MLW\u000e\u001d7f%\u0016\u0004xN\u001d;fe~#S-\u001d\u000b\u0005\u0003\u000b\ti\u0010C\u0005\u0002\u000eu\t\t\u00111\u0001\u0002t\u0006y1/[7qY\u0016\u0014V\r]8si\u0016\u0014\b%\u0001\ntS6\u0004H.Z!vI&$8+^7nCJLXC\u0001B\u0003!\r)(qA\u0005\u0004\u0005\u0013!'aD!vI&$(j\u001c2Tk6l\u0017M]=\u0002-MLW\u000e\u001d7f\u0003V$\u0017\u000e^*v[6\f'/_0%KF$B!!\u0002\u0003\u0010!I\u0011Q\u0002\u0011\u0002\u0002\u0003\u0007!QA\u0001\u0014g&l\u0007\u000f\\3Bk\u0012LGoU;n[\u0006\u0014\u0018\u0010I\u0001\u0014IV\u0014\u0018MY5mSRLX*\u001a;sS\u000eluM]\u000b\u0003\u0005/\u0001BA!\u0007\u0003\u001c5\ta-C\u0002\u0003\u001e\u0019\u0014\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u0003]!WO]1cS2LG/_'fiJL7-T4s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\t\r\u0002\"CA\u0007G\u0005\u0005\t\u0019\u0001B\f\u0003Q!WO]1cS2LG/_'fiJL7-T4sA\u0005i\u0011-\u001e3jiN\fE\u000e\\8xK\u0012,\"Aa\u000b\u0011\r\t5\"q\u0007B\u001e\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0011)D\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u001d\u0005_\u00111aU3u!\u0011\u0011iD!\u0013\u000f\t\t}\"QI\u0007\u0003\u0005\u0003R1Aa\u0011e\u0003\u001di\u0017M\\1hKJLAAa\u0012\u0003B\u0005!B)\u001e:bE&d\u0017\u000e^=Bk\u0012LGo\u00115fG.LAAa\u0013\u0003N\t)a+\u00197vK&\u0019!q\n8\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u000fCV$\u0017\u000e^:BY2|w/\u001a3!\u00035\tG\u000e\\8xK\u0012,e/\u001a8ugV\u0011!q\u000b\t\u0007\u0005[\u00119D!\u0017\u0011\t\tm#\u0011\n\b\u0005\u0005;\u0012\u0019'\u0004\u0002\u0003`)\u0019!\u0011\r4\u0002\r\u00154XM\u001c;t\u0013\u0011\u0011)Ga\u0018\u0002'\u0011+(/\u00192jY&$\u00180\u0012<f]R$\u0016\u0010]3\u0002\u001d\u0005dGn\\<fI\u00163XM\u001c;tA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAAB\u0003I!x\u000e]5d!\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\u0005\u0015!\u0011\u000f\u0005\n\u0003\u001bQ\u0013\u0011!a\u0001\u0003\u0007\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\tI\n\u001cuN\u001c4jOV\u0011\u00111U\u0001\rI\n\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u000b\u0011i\bC\u0005\u0002\u000e5\n\t\u00111\u0001\u0002$\u0006IAMY\"p]\u001aLw\rI\u0001\u0003I\n,\"A!\"\u0011\t\t\u001d%1R\u0007\u0003\u0005\u0013S1A!!g\u0013\u0011\u0011iI!#\u0003\u0019\u0011+(/\u00192jY&$\u0018\u0010\u0012\"\u0002\r\u0011\u0014w\fJ3r)\u0011\t)Aa%\t\u0013\u00055\u0001'!AA\u0002\t\u0015\u0015a\u00013cA\u0005Y\u0011-\u001e3ji\u000e{gNZ5h+\t\u0011Y\nE\u0002v\u0005;K1Aa(e\u0005U!UO]1cS2LG/_!vI&$8i\u001c8gS\u001e\fq\"Y;eSR\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u000b\u0011)\u000bC\u0005\u0002\u000eM\n\t\u00111\u0001\u0003\u001c\u0006a\u0011-\u001e3ji\u000e{gNZ5hA\u0005i!/\u001a9mS\u000e\fW*\u00198bO\u0016,\"A!,\u0011\t\t=&1W\u0007\u0003\u0005cS1!a\u000ei\u0013\u0011\u0011)L!-\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\t\"/\u001a9mS\u000e\fW*\u00198bO\u0016|F%Z9\u0015\t\u0005\u0015!1\u0018\u0005\n\u0003\u001b1\u0014\u0011!a\u0001\u0005[\u000baB]3qY&\u001c\u0017-T1oC\u001e,\u0007%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\u0006!\u001a\u0001H!2\u0011\t\t\u001d'Q[\u0007\u0003\u0005\u0013TAAa3\u0003N\u0006\u0019\u0011\r]5\u000b\t\t='\u0011[\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011\u0019.a\u0010\u0002\u000b),h.\u001b;\n\t\t]'\u0011\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007e\u0012i\u000e\u0005\u0003\u0003H\n}\u0017\u0002\u0002Bq\u0005\u0013\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002)Q,7\u000f^*j[BdWm\u00144gg\u0016$8kY1oQ\rQ$q\u001d\t\u0005\u0005\u000f\u0014I/\u0003\u0003\u0003l\n%'\u0001\u0002+fgR\fa\u0006^3tiNKW\u000e\u001d7f\u001f\u001a47/\u001a;TG\u0006tw+\u001b;i\u001fZ,'\u000f\\1q/&$\b\u000eV5feB{'\u000f^5p]\"\u001a1Ha:\u00025Q,7\u000f^*j[BdW\rV5fe\u0016$wJ\u001a4tKR\u001c6-\u00198)\u0007q\u00129/\u0001\u0017uKN$x)\u00199CKR<X-\u001a8US\u0016\u0014X\rZ#oI>3gm]3u\u0003:$Gj\\4F]\u0012|eMZ:fi\"\u001aQHa:\u0002)%t\u0017\u000e^5bY&TX\rT8h\u001b\u0006t\u0017mZ3s)\u0011\u0011ip!\u0007\u0011\r\t}8\u0011BB\u0007\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011\u0001C:uk\n\u0014\u0017N\\4\u000b\t\r\u001d\u0011qH\u0001\b[>\u001c7.\u001b;p\u0013\u0011\u0019Ya!\u0001\u0003\u001f=swm\\5oON#XO\u00192j]\u001e\u0004R!\\B\b\u0007'I1a!\u0005o\u0005\u0019y\u0005\u000f^5p]B!\u0011qCB\u000b\u0013\u0011\u00199\"!\u0007\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u00077q\u0004\u0019AB\n\u0003\u0011iGj\\4\u00025Q,7\u000f^(cU\u0016\u001cGo\u0015;pe\u0016\u001cVmZ7f]Rdun]:)\u0007}\u00129/A\u000euKN$H+[3s\u0007>l\u0007/Y2uK\u0012|%M[3di2{7o\u001d\u0015\u0004\u0001\n\u001d\u0018a\b;fgR$\u0016.\u001a:D_6\u0004\u0018m\u0019;fIR{\u0007/[2WC2LG-\u0019;fg\"\u001a\u0011Ia:\u0002?Q,7\u000f^'jgNLgnZ*fO6,g\u000e^%o\u001f\nTWm\u0019;Ti>\u0014X\rK\u0002C\u0005O\fQ\u0004^3ti2\u000bwmZ5oORKWM\u001d)beRLG/[8o'R\fG/\u001a\u0015\u0004\u0007\n\u001d\u0018a\u0004;fgR,e\u000e\u001a+p\u000b:$'+\u001e8)\u0007\u0011\u00139/A\u0012uKN$xJ\u001a4tKR<\u0015\r\u001d\"fi^,WM\u001c+jKJ\fe\u000e\u001a'pG\u0006dGj\\4)\u0007\u0015\u00139/\u0001\ruKN$H+[3s\u001f\u001a47/\u001a;HCB\u0014V\r\u001e:jKND3A\u0012Bt\u0003Y!Xm\u001d;O_:\fE.[4oK\u0012\u001cVmZ7f]R\u001c\bfA$\u0003h\u0006YB/Z:u\u0007>l\u0007/Y2uK\u0012$v\u000e]5d\u0013N\feo\\5eK\u0012D3\u0001\u0013Bt\u0003\u0005\"Xm\u001d;D_6\u0004\u0018m\u0019;fIR{\u0007/[2DQ\u0006tw-\u001a3U_\u0012+G.\u001a;fQ\rI%q]\u0001\"i\u0016\u001cH\u000fT1uG\"\u001cu.\u001e8uI><h\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004\u0015\n\u001d\u0018!\n;fgR\fU\u000fZ5u\u0015>\u00147\u000b\\3faN4uN\u001d+jKJ4VM]5gS\u000e\fG/[8oQ\rY%q]\u0001)i\u0016\u001cH\u000fV5fe2{wmU3h[\u0016tGoQ8om\u0016\u00148/[8o\r>\u0014h+\u00197jI\u0006$xN\u001d\u0015\u0004\u0019\n\u001d\u0018a\u0006;fgR\u001c\u0005.Z2lgVlG)[:bE2,G+Z:uQ\ri%q]\u0001\u0011i\u0016\u001cHoU5{K6K7/\\1uG\"D3A\u0014Bt\u0003]!Xm\u001d;J]Z\fG.\u001b3TSj,W*[:nCR\u001c\u0007\u000eK\u0002P\u0005O\fa\u0004^3tiNKW\u000e\u001d7f\u0007>l\u0007/Y2uS>tg+\u00197jI\u0006$\u0018n\u001c8)\u0007A\u00139/\u0001\u0015uKN$8+[7qY\u0016\u001cu.\u001c9bGRLwN\u001c,bY&$\u0017\r^5p]~\u001b6-\u001a8be&|\u0017\u0007K\u0002R\u0005O\f\u0001\u0006^3tiNKW\u000e\u001d7f\u0007>l\u0007/Y2uS>tg+\u00197jI\u0006$\u0018n\u001c8`'\u000e,g.\u0019:j_JB3A\u0015Bt\u0003!\"Xm\u001d;TS6\u0004H.Z\"p[B\f7\r^5p]Z\u000bG.\u001b3bi&|gnX*dK:\f'/[84Q\r\u0019&q]\u0001\u001fi\u0016\u001cH/T5tg&twmU3h[\u0016tG/\u00138D_6\u0004\u0018m\u0019;j_:D3\u0001\u0016Bt\u0003q!Xm\u001d;D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\\*lSBD3!\u0016Bt\u0003I!Xm\u001d;D_:<'/^3oi\u001aKG.Z:)\u0007Y\u00139/\u0001\nuKN$xJ\u001a4tKRl\u0015\r\u001d$jY\u0016\u001c\bfA,\u0003h\u00069B/Z:u\u0019\u0006\u0014x-Z(gMN,G/T1q\r&dWm\u001d\u0015\u00041\n\u001d\u0018!\u0005;fgRl\u0015n]'bi\u000eDg)\u001b7fg\"\u001a\u0011La:\u0002/Q,7\u000f^'jg6\u000bGo\u00195TSj,\u0017J\u001c$jY\u0016\u001c\bf\u0001.\u0003h\u0006\u0011B/Z:u)>l'm\u001d;p]\u00164\u0015\u000e\\3tQ\rY&q]\u0001+i\u0016\u001cH\u000fV8nEN$xN\\3F]R\u0014\u0018\u0010\u0015:fg\u0016tGo\u00148ms&sG)Z:uS:\fG/[8oQ\ra&q]\u0001(i\u0016\u001cH\u000fV5fe\u0016$g+\u00197jI\u0006$\u0018n\u001c8t'.L\u0007\u000f]3e\u001f:4u\u000e\u001c7po\u0016\u00148\u000fK\u0002^\u0005O\fq\u0005^3ti2{7-\u00197M_\u001e\u001cF/\u0019:u\u000f\u0006\u0004H)\u001a;fGR,Gm\u00148G_2dwn^3sg\"\u001aaLa:\u0002AQ,7\u000f^(cU\u0016\u001cGo\u0015;pe\u0016\u001cu.\u001c9bGR,GmU3h[\u0016tGo\u001d\u0015\u0004?\n\u001d\u0018\u0001\u0007;fgR$\u0016.\u001a:M_\u000e\fGnU3h[\u0016tGo]$ba\"\u001a\u0001Ma:\u0002%Q,7\u000f\u001e$f]\u000e,G-T3tg\u0006<Wm\u001d\u0015\u0004C\n\u001d\u0018\u0001\u0007;fgR$%i\u0015;bY\u0016,e\u000e\u001e:z\t\u0016dW\r^5p]\"\u001a!Ma:")
public class BrokerAuditJobTest {
    private File logDir;
    private LogManager logManager;
    private MockTime time;
    private BrokerAuditJob auditJob;
    private scala.collection.immutable.Seq<TopicPartition> topicPartitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private TierObjectStore objStore = null;
    private final int jobId;
    private Metrics metrics;
    private AuditReporter simpleReporter;
    private AuditJobSummary simpleAuditSummary;
    private DurabilityMetricsManager durabilityMetricMgr;
    private final Set<Enumeration.Value> auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    private final Set<Enumeration.Value> allowedEvents = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityEventType$.MODULE$.DeleteRecordsType(), DurabilityEventType$.MODULE$.IsrExpandType(), DurabilityEventType$.MODULE$.EpochChangeType(), DurabilityEventType$.MODULE$.RetentionChangeType(), DurabilityEventType$.MODULE$.StartOffsetChangeType(), DurabilityEventType$.MODULE$.OffsetChangeType(), DurabilityEventType$.MODULE$.DeletePartitionType(), DurabilityEventType$.MODULE$.HealthCheckType()}));
    private TopicPartition topicPartition;
    private long dbConfig = 0L;
    private DurabilityDB db = null;
    private DurabilityAuditConfig auditConfig = null;
    private ReplicaManager replicaManage = null;

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public BrokerAuditJob auditJob() {
        return this.auditJob;
    }

    public void auditJob_$eq(BrokerAuditJob x$1) {
        this.auditJob = x$1;
    }

    public scala.collection.immutable.Seq<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.immutable.Seq<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple() {
        return this.partitionTuple;
    }

    public void partitionTuple_$eq(scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> x$1) {
        this.partitionTuple = x$1;
    }

    public TierObjectStore objStore() {
        return this.objStore;
    }

    public void objStore_$eq(TierObjectStore x$1) {
        this.objStore = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter simpleReporter() {
        return this.simpleReporter;
    }

    public void simpleReporter_$eq(AuditReporter x$1) {
        this.simpleReporter = x$1;
    }

    public AuditJobSummary simpleAuditSummary() {
        return this.simpleAuditSummary;
    }

    public void simpleAuditSummary_$eq(AuditJobSummary x$1) {
        this.simpleAuditSummary = x$1;
    }

    public DurabilityMetricsManager durabilityMetricMgr() {
        return this.durabilityMetricMgr;
    }

    public void durabilityMetricMgr_$eq(DurabilityMetricsManager x$1) {
        this.durabilityMetricMgr = x$1;
    }

    public Set<Enumeration.Value> auditsAllowed() {
        return this.auditsAllowed;
    }

    public Set<Enumeration.Value> allowedEvents() {
        return this.allowedEvents;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public long dbConfig() {
        return this.dbConfig;
    }

    public void dbConfig_$eq(long x$1) {
        this.dbConfig = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    public DurabilityAuditConfig auditConfig() {
        return this.auditConfig;
    }

    public void auditConfig_$eq(DurabilityAuditConfig x$1) {
        this.auditConfig = x$1;
    }

    public ReplicaManager replicaManage() {
        return this.replicaManage;
    }

    public void replicaManage_$eq(ReplicaManager x$1) {
        this.replicaManage = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.time_$eq(new MockTime());
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), (Time)this.time()));
        Metrics x$2 = this.metrics();
        MockTime x$3 = this.time();
        long x$5 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        this.durabilityMetricMgr_$eq(new DurabilityMetricsManager("0", x$2, (Time)x$3, x$5, false));
        DurabilityMetricsManager apply_metricManager = this.durabilityMetricMgr();
        Object var6_4 = null;
        this.simpleReporter_$eq(new AuditReporter(apply_metricManager));
        this.simpleAuditSummary_$eq(new AuditJobSummary());
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        this.topicPartition_$eq(new TopicPartition("some-topic", 1));
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$));
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        PartitionState partitionState = PartitionState$.MODULE$.apply(this.topicPartition().partition(), 0L);
        partitionState.isLeader_$eq(true);
        this.db().addPartition(this.topicPartition(), partitionState);
        this.auditConfig_$eq(DurabilityTestUtils$.MODULE$.getDurabilityAuditConfig((Time)this.time(), true, this.auditsAllowed(), this.allowedEvents(), this.logDir(), Predef$.MODULE$.Long2long(ConfluentConfigs.DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT), DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID()));
    }

    @AfterEach
    public void tearDown() {
        if (this.objStore() != null) {
            this.objStore().close();
        }
        this.logManager_$eq(null);
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testSimpleOffsetScan() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), segments, (scala.collection.immutable.Seq<TierLogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleOffsetScanWithOverlapWithTierPortion() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TierPartitionState tierPartitionMock = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        File x$1 = this.logDir();
        long x$4 = 0L;
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(x$1, 10L, x$4, 10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionMock.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        TopicPartition x$5 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$7 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$8 = new Some((Object)tierPartitionMock);
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        boolean x$12 = false;
        boolean x$13 = false;
        None$ x$14 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$5, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$7, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$9, (Option<Object>)x$10, (Option<Object>)x$11, x$12, x$13, (Option<TierPartitionState>)x$8, (Option<Uuid>)x$14);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)22L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleTieredOffsetScan() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleTieredOffsetScan$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testGapBetweenTieredEndOffsetAndLogEndOffset() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testGapBetweenTieredEndOffsetAndLogEndOffset$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$4, (Option<Object>)x$5, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)999L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)999L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.InconsistentLocalAndTierEndOffset())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    private OngoingStubbing<Option<AbstractLog>> initializeLogManager(AbstractLog mLog) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        return Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
    }

    @Test
    public void testObjectStoreSegmentLoss() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testObjectStoreSegmentLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedObjectLoss() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierCompactedObjectLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedTopicValidates() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierCompactedTopicValidates$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testMissingSegmentInObjectStore() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata((TierLogSegment)tierSegments.head()), this.objStore());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1010L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1010L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLaggingTierPartitionState() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)3000L)), (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3001L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testEndToEndRun() {
        long expectedTotalMsgCount = 2004L;
        long expectedGapCount = 0L;
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)new .colon.colon((Object)new TopicPartition("some-topic", 2), (List)Nil$.MODULE$)));
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        scala.collection.immutable.Map logMap = ((IterableOnceOps)this.topicPartitions().map((Function1 & Serializable)topicPartition -> {
            File logDir = TestUtils.tempDirectory(null, null);
            scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)topicPartition, this.objStore(), 0L, 0L);
            tierSegments.foreach((Function1 & Serializable)tierSegment -> {
                BrokerAuditJobTest.$anonfun$testEndToEndRun$2(this, tierSegment);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(logDir, 0L, 2000L, 1);
            Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)2003L));
            None$ x$5 = None$.MODULE$;
            None$ x$6 = None$.MODULE$;
            boolean x$7 = false;
            boolean x$8 = false;
            None$ x$9 = None$.MODULE$;
            None$ x$10 = None$.MODULE$;
            return new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$6, (Option<Object>)x$4, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)logMap));
        CountDownLatch countdown = new CountDownLatch(1);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), countdown, this.simpleReporter(), this.simpleAuditSummary(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().run();
        this.partitionTuple().foreach((Function1 & Serializable)x0$1 -> {
            BrokerAuditJobTest.$anonfun$testEndToEndRun$3(this, expectedGapCount, expectedTotalMsgCount, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Assertions.assertEquals((long)0L, (long)countdown.getCount());
    }

    @Test
    public void testOffsetGapBetweenTierAndLocalLog() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testOffsetGapBetweenTierAndLocalLog$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(localLogStartOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)2045L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)42L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)42L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierOffsetGapRetries() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        scala.collection.immutable.Seq<TierLogSegment> secondaryTierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 2000L);
        ((IterableOnceOps)tierSegments.$plus$plus(secondaryTierSegments)).foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierOffsetGapRetries$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)new Some(tierSegments.$plus$plus(secondaryTierSegments)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)4003L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testNonAlignedSegments() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)mLog.config()).thenReturn((Object)new LogConfig(new HashMap()));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 11L, 20L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 18L, 31L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testNonAlignedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(20L, 30L, this.logDir(), 10, Time.SYSTEM, -1L), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(31L, 40L, this.logDir(), 10, Time.SYSTEM, -1L), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(41L, 50L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$)));
        TopicPartition x$3 = (TopicPartition)this.topicPartitions().head();
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)50L));
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = false;
        boolean x$10 = false;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$3, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$7, (Option<Object>)x$8, (Option<Object>)x$6, x$9, x$10, (Option<TierPartitionState>)x$11, (Option<Uuid>)x$12);
        LogManager qual$2 = this.logManager();
        TopicPartition x$13 = (TopicPartition)this.topicPartitions().head();
        boolean x$14 = qual$2.getLog$default$2();
        Mockito.when((Object)qual$2.getLog(x$13, x$14)).thenReturn((Object)new Some((Object)mlog));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)66L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicIsAvoided() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$3 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$3, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$6, (Option<Object>)x$7, true, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)0L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertFalse((boolean)auditResult.errorOpt().isEmpty());
        Predef$.MODULE$.assert(auditResult.errorOpt().get() instanceof UnsupportedOperationException);
        Assertions.assertTrue((boolean)((Throwable)auditResult.errorOpt().get()).getMessage().contains("is not audited"));
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicChangedToDelete() {
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)ConfigFlag$.MODULE$.OnceCompacted().id())), (List)Nil$.MODULE$));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 1000L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testCompactedTopicChangedToDelete$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 1000L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, true, true, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.config().compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)mLog.tieredLogSegments()).thenReturn((Object)tierSegments.iterator());
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult2 = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult2.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult2.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInLocalSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)auditResult2.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLatchCountdownThrowsException() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)Nil$.MODULE$);
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(0), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Assertions.assertThrows(InterruptedException.class, () -> this.auditJob().doAuditSafely(mlog, this.dbConfig()), () -> "Expected InterruptedException to be thrown");
    }

    @Test
    public void testAuditJobSleepsForTierVerification() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(BrokerAuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE() + 1, (Function0 & Serializable)() -> LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive));
        long beforeAccessTimestamp = this.time().milliseconds();
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)(BrokerAuditJob$.MODULE$.SLEEP_TIME_MS() * 2L), (long)(this.time().milliseconds() - beforeAccessTimestamp));
    }

    @Test
    public void testTierLogSegmentConversionForValidator() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("my-topic", UUID.randomUUID(), 0);
        int keyBaseOffset = 44;
        int virtualBaseOffset = 43;
        int endOffset = 55;
        int maxTimestamp = 100;
        int size = 33;
        int firstBatchTimestamp = 30;
        SegmentState segmentState = new SegmentState(0, UUID.randomUUID(), (long)virtualBaseOffset, (long)keyBaseOffset, (long)endOffset, (long)maxTimestamp, (long)firstBatchTimestamp, size, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, false, false, TierUploadType.Archive, OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99L, Optional.empty());
        TierLogSegment tierLogSegmentOverlapping = new TierLogSegment(topicIdPartition, segmentState);
        TierObjectMetadata overlappingMetadata = BrokerAuditJob$.MODULE$.getTierObjectMetadata(tierLogSegmentOverlapping);
        Assertions.assertEquals((long)keyBaseOffset, (long)overlappingMetadata.baseOffset(), (String)"tier log segment with virtually bounded base offset should return true key base offset in metadata");
        Assertions.assertEquals((long)55L, (long)overlappingMetadata.endOffset());
        Assertions.assertEquals((long)100L, (long)overlappingMetadata.maxTimestamp());
        Assertions.assertEquals((int)33, (int)size);
    }

    @Test
    public void testChecksumDisableTest() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testChecksumDisableTest$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().validateChecksum())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.ChecksumValidation())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSizeMismatch() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        TierObjectStore objectStoreSpy = (TierObjectStore)Mockito.spy((Object)this.objStore());
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), objectStoreSpy, 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSizeMismatch$1(objectStoreSpy, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        ObjectMetadata firstSegMetadata = ((TierLogSegment)tierSegments.head()).metadata();
        Mockito.when((Object)objectStoreSpy.objectExists((ObjectStoreMetadata)new ObjectMetadata(firstSegMetadata.topicIdPartition(), firstSegMetadata.objectId(), firstSegMetadata.tierEpoch(), firstSegMetadata.baseOffset(), firstSegMetadata.hasAbortedTxns(), firstSegMetadata.hasProducerState(), firstSegMetadata.hasEpochState(), firstSegMetadata.opaqueData(), (SegmentAndMetadataLayout)firstSegMetadata.segmentAndMetadataLayout().orElse(null)), ObjectType.SEGMENT)).thenReturn((Object)new TierObjectAttribute(true, 1L));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)objectStoreSpy), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)999L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.InvalidTieredSegmentSize())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testInvalidSizeMismatch() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        TierObjectStore objectStoreSpy = (TierObjectStore)Mockito.spy((Object)this.objStore());
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), objectStoreSpy, 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testInvalidSizeMismatch$1(objectStoreSpy, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        ObjectMetadata firstSegMetadata = ((TierLogSegment)tierSegments.head()).metadata();
        Mockito.when((Object)objectStoreSpy.objectExists((ObjectStoreMetadata)new ObjectMetadata(firstSegMetadata.topicIdPartition(), firstSegMetadata.objectId(), firstSegMetadata.tierEpoch(), firstSegMetadata.baseOffset(), firstSegMetadata.hasAbortedTxns(), firstSegMetadata.hasProducerState(), firstSegMetadata.hasEpochState(), firstSegMetadata.opaqueData(), null), ObjectType.SEGMENT)).thenReturn((Object)new TierObjectAttribute(true, -1L));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)objectStoreSpy), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.InvalidTieredSegmentSize())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleCompactionValidation() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1, objectID2})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 0L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, Instant.ofEpochMilli(this.time().milliseconds()));
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario1() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario1$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 50L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 0L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, Instant.ofEpochMilli(this.time().milliseconds()));
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario2() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario2$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent1 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), Predef$.MODULE$.Set().empty(), 0L, 0L, 999L, false);
        CommitAndSwapEvent commitSwapEvent2 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID2})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1L, 0L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)commitSwapEvent2, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, Instant.ofEpochMilli(this.time().milliseconds()));
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario3() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario3$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent1 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), Predef$.MODULE$.Set().empty(), 0L, 0L, 999L, false);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Assertions.assertTrue((boolean)this.auditJob().trimCommitAndSwapEvent((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$)).isEmpty());
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, Instant.ofEpochMilli(this.time().milliseconds()));
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testMissingSegmentInCompaction() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testMissingSegmentInCompaction$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 0L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, Instant.ofEpochMilli(this.time().milliseconds()));
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testCompactionValidationSkip() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit(), DurabilityAuditCheck$.MODULE$.DeepCompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testCompactionValidationSkip$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED, Optional.empty());
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent1 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), Predef$.MODULE$.Set().empty(), 0L, 0L, 999L, false);
        CommitAndSwapEvent commitSwapEvent2 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID2})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1L, 0L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)commitSwapEvent2, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Instant startTime = this.simpleReporter().startAuditCompactionJob();
        this.time().sleep(DurabilityAuditConstants$.MODULE$.TIER_COMPACTION_AUDIT_DURATION().toMillis() + 1000L);
        this.auditJob().verifyCompactedPartition(topicIdPartition, events, startTime);
        Assertions.assertEquals((long)1L, (long)this.simpleReporter().fetchCompactedPartitionDataValidationSkipped());
    }

    @Test
    public void testCongruentFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)0, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testOffsetMapFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(50, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        scala.collection.SortedMap offsetMap2 = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(new File("."), "File1");
        Assertions.assertTrue((boolean)offsetMap1.equals((Object)offsetMap2));
        new File("./File2").delete();
    }

    @Test
    public void testLargeOffsetMapFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(200000, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        scala.collection.SortedMap offsetMap2 = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(new File("."), "File1");
        Assertions.assertTrue((boolean)offsetMap1.equals((Object)offsetMap2));
        new File("./File2").delete();
    }

    @Test
    public void testMisMatchFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int memMismatches = 0;
        Iterator iter1 = offsetMap1.iterator();
        Iterator iter2 = offsetMap2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Tuple2 firstObj = (Tuple2)iter1.next();
            Tuple2 secondObj = (Tuple2)iter2.next();
            if (BoxesRunTime.equals((Object)firstObj._1(), (Object)secondObj._1()) && ((OffsetInfo)firstObj._2()).offset() == ((OffsetInfo)secondObj._2()).offset()) continue;
            ++memMismatches;
        }
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)memMismatches, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testMisMatchSizeInFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File1").toFile(), false);
        SortedMap updatedMap = (SortedMap)offsetMap.dropRight(1);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)updatedMap, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)1, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTombstoneFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(20, true);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(10, true);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)0, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTombstoneEntryPresentOnlyInDestination() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(0, true);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(20, true);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)2, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTieredValidationsSkippedOnFollowers() {
        ((PartitionState)this.db().fetchPartitionState(this.topicPartition()).get()).isLeader_$eq(false);
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTieredValidationsSkippedOnFollowers$1(this, segment);
            return BoxedUnit.UNIT;
        });
        long localLogStartOffset = ((TierLogSegment)tierSegments.last()).endOffset() + 1L;
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithoutGap(this.logDir(), localLogStartOffset);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)((TierLogSegment)tierSegments.head()).baseOffset()));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(localLogStartOffset + 3L)));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.last()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)(((LogSegment)localSegments.last()).readNextOffset() - ((TierLogSegment)tierSegments.last()).baseOffset()), (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLocalLogStartGapDetectedOnFollowers() {
        ((PartitionState)this.db().fetchPartitionState(this.topicPartition()).get()).isLeader_$eq(false);
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testLocalLogStartGapDetectedOnFollowers$1(this, segment);
            return BoxedUnit.UNIT;
        });
        int localLogStartOffsetGapCount = 4;
        long localLogStartOffset = ((TierLogSegment)tierSegments.last()).endOffset() + 1L + (long)localLogStartOffsetGapCount;
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithoutGap(this.logDir(), localLogStartOffset);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)((TierLogSegment)tierSegments.head()).baseOffset()));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(localLogStartOffset + 3L)));
        Predef$.MODULE$.assert(mLog.logStartOffset() == 10L);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)(((LogSegment)localSegments.last()).readNextOffset() - ((TierLogSegment)tierSegments.last()).baseOffset() - (long)localLogStartOffsetGapCount), (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)localLogStartOffsetGapCount, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)localLogStartOffsetGapCount, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testObjectStoreCompactedSegments() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        TierObjectStore x$4 = this.objStore();
        TierObjectMetadata.State x$6 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$7 = 1L;
        long x$8 = 1L;
        TierObjectMetadata.State x$9 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$13 = this.objStore();
        TierObjectMetadata.State x$15 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$16 = 1L;
        long x$17 = 1L;
        TierObjectMetadata.State x$18 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$22 = this.objStore();
        TierObjectMetadata.State x$24 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$25 = 1L;
        long x$26 = 1L;
        TierObjectMetadata.State x$27 = TierObjectMetadata.State.INVALID;
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, x$4, x$6, x$7, x$8, x$9, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 12L, 20L, x$13, x$15, x$16, x$17, x$18, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 22L, 31L, x$22, x$24, x$25, x$26, x$27, TierUploadType.Archive), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testObjectStoreCompactedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(24L, 32L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$);
        TopicPartition x$28 = (TopicPartition)this.topicPartitions().head();
        Some x$31 = new Some((Object)BoxesRunTime.boxToLong((long)32L));
        None$ x$32 = None$.MODULE$;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = false;
        boolean x$35 = false;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$28, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$32, (Option<Object>)x$33, (Option<Object>)x$31, x$34, x$35, (Option<TierPartitionState>)x$36, (Option<Uuid>)x$37);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)39L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierLocalSegmentsGap() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        TierObjectStore x$4 = this.objStore();
        TierObjectMetadata.State x$6 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$7 = 1L;
        long x$8 = 1L;
        TierObjectMetadata.State x$9 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$13 = this.objStore();
        TierObjectMetadata.State x$15 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$16 = 1L;
        long x$17 = 1L;
        TierObjectMetadata.State x$18 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$22 = this.objStore();
        TierObjectMetadata.State x$24 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$25 = 1L;
        long x$26 = 1L;
        TierObjectMetadata.State x$27 = TierObjectMetadata.State.INVALID;
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, x$4, x$6, x$7, x$8, x$9, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 12L, 20L, x$13, x$15, x$16, x$17, x$18, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 22L, 31L, x$22, x$24, x$25, x$26, x$27, TierUploadType.Compaction), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierLocalSegmentsGap$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(35L, 40L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$);
        TopicPartition x$28 = (TopicPartition)this.topicPartitions().head();
        Some x$31 = new Some((Object)BoxesRunTime.boxToLong((long)40L));
        None$ x$32 = None$.MODULE$;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = false;
        boolean x$35 = false;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$28, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$32, (Option<Object>)x$33, (Option<Object>)x$31, x$34, x$35, (Option<TierPartitionState>)x$36, (Option<Uuid>)x$37);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)36L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapInTieredSegments())).count());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.OffsetGapBetweenTieredAndLocalSegments())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedMessages() {
        void apply_topicPartitionsMap;
        void apply_onCompleteSignaller;
        TopicIdPartition topicIdPartition = new TopicIdPartition("test-topic", UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitEvent1 = new TierSegmentUploadInitiate(topicIdPartition, 1, objectId1, 0L, 100L, 10L, 2L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ConsumerRecord record1_1 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadInitEvent1.serializeKey(), (Object)uploadInitEvent1.serializeValue());
        TierSegmentUploadComplete uploadCompleteEvent1 = new TierSegmentUploadComplete(uploadInitEvent1);
        ConsumerRecord record1_2 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadCompleteEvent1.serializeKey(), (Object)uploadCompleteEvent1.serializeValue());
        TierSegmentUploadInitiate uploadInitEvent2 = new TierSegmentUploadInitiate(topicIdPartition, 1, objectId2, 100L, 200L, 10L, 2L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ConsumerRecord record2_1 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadInitEvent2.serializeKey(), (Object)uploadInitEvent2.serializeValue());
        TierTopicInitLeader tierInitEvent = new TierTopicInitLeader(topicIdPartition, 2, UUID.randomUUID(), 0);
        ConsumerRecord record3 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)tierInitEvent.serializeKey(), (Object)tierInitEvent.serializeValue());
        TierSegmentUploadComplete uploadCompleteEvent2 = new TierSegmentUploadComplete(uploadInitEvent2);
        ConsumerRecord record2_2 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadCompleteEvent2.serializeKey(), (Object)uploadCompleteEvent2.serializeValue());
        Map tierEpochMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()))}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        DurabilityAuditConfig apply_config = this.auditConfig();
        Object var19_17 = null;
        countDownLatch = null;
        map = null;
        DurabilityTierTopicReader reader = new DurabilityTierTopicReader(apply_config, (CountDownLatch)apply_onCompleteSignaller, (scala.collection.immutable.Map)apply_topicPartitionsMap);
        HashMap<TopicPartition, java.util.List<ConsumerRecord>> records = new HashMap<TopicPartition, java.util.List<ConsumerRecord>>();
        ConsumerRecords consumerRecords = new ConsumerRecords(records);
        records.put(this.topicPartition(), Arrays.asList(record1_1, record1_2, record2_1, record3, record2_2));
        Map events = reader.filterCompactionMessage(consumerRecords, tierEpochMap);
        Assertions.assertEquals((int)1, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).uploadMessages().size());
        Assertions.assertEquals((int)2, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).uploadInitMessages().size());
        Assertions.assertEquals((int)0, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).commitAndSwapMessages().size());
    }

    @Test
    public void testDBStaleEntryDeletion() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("unknown-topic", 1), (List)new .colon.colon((Object)new TopicPartition("unknown-topic-no-log", 1), (List)new .colon.colon((Object)new TopicPartition("stray-topic", 2), (List)Nil$.MODULE$))));
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)((scala.collection.immutable.Seq)this.topicPartitions().map((Function1 & Serializable)topicPartition -> new Tuple2(topicPartition, (Object)BoxesRunTime.boxToLong((long)1L)))));
        scala.collection.immutable.Map logMap = ((IterableOnceOps)((IterableOps)this.topicPartitions().filter((Function1 & Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)BrokerAuditJobTest.$anonfun$testDBStaleEntryDeletion$2(topicPartition)))).map((Function1 & Serializable)topicPartition -> new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)logMap));
        ReplicaManager mockReplicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)mockReplicaManager.logManager()).thenReturn((Object)this.logManager());
        Mockito.when((Object)mockReplicaManager.getPartitionOrError((TopicPartition)this.topicPartitions().apply(0))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION));
        Mockito.when((Object)mockReplicaManager.getPartitionOrError((TopicPartition)this.topicPartitions().apply(1))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION));
        Mockito.when((Object)mockReplicaManager.getPartitionOrError((TopicPartition)this.topicPartitions().apply(2))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_LEADER_OR_FOLLOWER));
        this.db().addPartition((TopicPartition)this.topicPartitions().apply(1), PartitionState$.MODULE$.apply(((TopicPartition)this.topicPartitions().apply(1)).partition(), 0L));
        this.db().addPartition((TopicPartition)this.topicPartitions().apply(2), PartitionState$.MODULE$.apply(((TopicPartition)this.topicPartitions().apply(2)).partition(), 0L));
        Assertions.assertTrue((boolean)this.db().fetchPartitionState((TopicPartition)this.topicPartitions().apply(0)).isEmpty());
        Assertions.assertTrue((boolean)this.db().fetchPartitionState((TopicPartition)this.topicPartitions().apply(1)).nonEmpty());
        Assertions.assertTrue((boolean)this.db().fetchPartitionState((TopicPartition)this.topicPartitions().apply(2)).nonEmpty());
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), Option$.MODULE$.apply((Object)mockReplicaManager), false, (Option)None$.MODULE$));
        this.auditJob().run();
        Assertions.assertTrue((boolean)this.db().fetchPartitionState((TopicPartition)this.topicPartitions().apply(1)).isEmpty());
        Assertions.assertTrue((boolean)this.db().fetchPartitionState((TopicPartition)this.topicPartitions().apply(2)).isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testSimpleTieredOffsetScan$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testGapBetweenTieredEndOffsetAndLogEndOffset$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreSegmentLoss$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedObjectLoss$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedTopicValidates$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$2(BrokerAuditJobTest $this, TierLogSegment tierSegment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(tierSegment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$3(BrokerAuditJobTest $this, long expectedGapCount$1, long expectedTotalMsgCount$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            OffsetCount offsetCount = $this.simpleReporter().getDurabilityCounters(topicPartition);
            Assertions.assertEquals((long)expectedGapCount$1, (long)offsetCount.loss(), (String)new StringBuilder(19).append("Incorrect gap for: ").append(topicPartition).toString());
            Assertions.assertEquals((long)expectedTotalMsgCount$1, (long)offsetCount.total(), (String)new StringBuilder(21).append("Incorrect total for: ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testOffsetGapBetweenTierAndLocalLog$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierOffsetGapRetries$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testNonAlignedSegments$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testCompactedTopicChangedToDelete$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testChecksumDisableTest$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSizeMismatch$1(TierObjectStore objectStoreSpy$1, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), objectStoreSpy$1);
    }

    public static final /* synthetic */ void $anonfun$testInvalidSizeMismatch$1(TierObjectStore objectStoreSpy$2, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), objectStoreSpy$2);
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario1$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario2$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario3$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testMissingSegmentInCompaction$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testCompactionValidationSkip$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTieredValidationsSkippedOnFollowers$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testLocalLogStartGapDetectedOnFollowers$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreCompactedSegments$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierLocalSegmentsGap$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ boolean $anonfun$testDBStaleEntryDeletion$2(TopicPartition topicPartition) {
        return !topicPartition.topic().equals("unknown-topic-no-log");
    }

    public BrokerAuditJobTest() {
        this.jobId = 0;
    }
}

