/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.TestBrokerAuditManager;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.ClusterLinkTruncationRequest;
import kafka.durability.audit.request.DeleteMessagesRequest;
import kafka.durability.audit.request.DeletePartitionRequest;
import kafka.durability.audit.request.EpochChangeRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest$;
import kafka.durability.audit.request.ISRExpandRequest;
import kafka.durability.audit.request.MirrorStateChangeRequest;
import kafka.durability.audit.request.RegisterPartitionRequest;
import kafka.durability.audit.request.RetentionConfigChangeRequest;
import kafka.durability.audit.request.StartOffsetChangeRequest;
import kafka.durability.db.PartitionState;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001\u0002\u001e<\u0001\tCQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004[\u0001\u0001\u0006Ia\u0014\u0005\b7\u0002\u0011\r\u0011\"\u0001O\u0011\u0019a\u0006\u0001)A\u0005\u001f\"9Q\f\u0001b\u0001\n\u0003q\u0006B\u00023\u0001A\u0003%q\fC\u0005f\u0001\u0001\u0007\t\u0019!C\u0001M\"IQ\u000e\u0001a\u0001\u0002\u0004%\tA\u001c\u0005\ni\u0002\u0001\r\u0011!Q!\n\u001dD\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0001<\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bBCA\u0001\u0001\u0001\u0007\t\u0011)Q\u0005o\"I\u00111\u0001\u0001A\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00033\u0001\u0001\u0019!C\u0001\u00037A\u0001\"a\b\u0001A\u0003&\u0011q\u0001\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0002bCA\u001e\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KA1\"!\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002@!Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011AA&\u0011-\ty\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u0011\t\u0013\u0005E\u0003A1A\u0005\u0002\u0005M\u0003\u0002CA=\u0001\u0001\u0006I!!\u0016\t\u0017\u0005m\u0004\u00011AA\u0002\u0013\u0005\u0011Q\u0010\u0005\f\u0003\u0013\u0003\u0001\u0019!a\u0001\n\u0003\tY\tC\u0006\u0002\u0010\u0002\u0001\r\u0011!Q!\n\u0005}\u0004bCAI\u0001\u0001\u0007\t\u0019!C\u0001\u0003'C1\"a'\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001e\"Y\u0011\u0011\u0015\u0001A\u0002\u0003\u0005\u000b\u0015BAK\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!0\u0001\t\u0003\t)\u000bC\u0004\u0002H\u0002!\t!!*\t\u000f\u0005E\u0007\u0001\"\u0001\u0002&\"9\u0011Q\u001b\u0001\u0005\u0002\u0005\u0015\u0006bBAm\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003;\u0004A\u0011AAS\u0011\u001d\t\t\u000f\u0001C\u0001\u0003KCq!!:\u0001\t\u0003\t)\u000bC\u0004\u0002j\u0002!\t!!*\t\u000f\u00055\b\u0001\"\u0001\u0002&\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005\u0015\u0006bBA{\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003s\u0004A\u0011AAS\u0011\u001d\ti\u0010\u0001C\u0001\u0003KCqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\u001a\u0001!\t!!*\t\u000f\tu\u0001\u0001\"\u0001\u0002&\"9!\u0011\u0005\u0001\u0005\u0002\u0005\u0015\u0006b\u0002B\u0013\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0005S\u0001A\u0011AAS\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003KCqA!\r\u0001\t\u0003\t)\u000bC\u0004\u00036\u0001!\t!!*\t\u000f\te\u0002\u0001\"\u0003\u0002&\"9!1\b\u0001\u0005\u0002\u0005\u0015\u0006b\u0002B \u0001\u0011\u0005\u0011Q\u0015\u0002\u0017\u0005J|7.\u001a:Bk\u0012LG/T1oC\u001e,'\u000fV3ti*\u0011A(P\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003}}\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0001\u0015!B6bM.\f7\u0001A\n\u0003\u0001\r\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001L!\ta\u0005!D\u0001<\u0003\r!\b/M\u000b\u0002\u001fB\u0011\u0001\u000bW\u0007\u0002#*\u0011!kU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0001#&BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001eL!!W)\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qc\u0001\n1\u0001\u001e93\u0003\u0011!\bO\r\u0011\u0002\tQ\u0004\u0018\nZ\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!mP\u0001\u0005i&,'/\u0003\u0002ZC\u0006)A\u000f]%eA\u0005!A/[7f+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016R\u0003\u0015)H/\u001b7t\u0013\ta\u0017N\u0001\u0003US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0005=\u0014\bC\u0001#q\u0013\t\tXI\u0001\u0003V]&$\bbB:\n\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014!\u0002;j[\u0016\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!pP\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005qL(A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002p\u007f\"91\u000fDA\u0001\u0002\u00049\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u001fQLWM](cUN#xN]3PaR,\"!a\u0002\u0011\u000b\u0011\u000bI!!\u0004\n\u0007\u0005-QI\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C1\u0002\u000bM$xN]3\n\t\u0005]\u0011\u0011\u0003\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u0019B/[3s\u001f\nT7\u000b^8sK>\u0003Ho\u0018\u0013fcR\u0019q.!\b\t\u0011M|\u0011\u0011!a\u0001\u0003\u000f\t\u0001\u0003^5fe>\u0013'n\u0015;pe\u0016|\u0005\u000f\u001e\u0011\u0002\rQl\u0007\u000fR5s+\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0005%|'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012\u0011\u0006\u0002\u0005\r&dW-\u0001\u0006u[B$\u0015N]0%KF$2a\\A\u001d\u0011!\u0019(#!AA\u0002\u0005\u0015\u0012a\u0002;na\u0012K'\u000fI\u0001\u0011i\u0016\u001cH/Q;eSRl\u0015M\\1hKJ,\"!!\u0011\u0011\t\u0005\r\u0013QI\u0007\u0002{%\u0019\u0011qI\u001f\u0003-Q+7\u000f\u001e\"s_.,'/Q;eSRl\u0015M\\1hKJ\fA\u0003^3ti\u0006+H-\u001b;NC:\fw-\u001a:`I\u0015\fHcA8\u0002N!A1/FA\u0001\u0002\u0004\t\t%A\tuKN$\u0018)\u001e3ji6\u000bg.Y4fe\u0002\nA\u0002\\8dC2|eMZ:fiN,\"!!\u0016\u0011\r\u0005]\u0013qMA7\u001d\u0011\tI&a\u0019\u000f\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018B\u0003\u0019a$o\\8u}%\ta)C\u0002\u0002f\u0015\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$aA*fc*\u0019\u0011QM#\u0011\u000f\u0011\u000by'a\u001d\u0002t%\u0019\u0011\u0011O#\u0003\rQ+\b\u000f\\33!\r!\u0015QO\u0005\u0004\u0003o*%\u0001\u0002'p]\u001e\fQ\u0002\\8dC2|eMZ:fiN\u0004\u0013a\u00017pOV\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000b))\u0004\u0002\u0002\u0004*\u0019\u00111P \n\t\u0005\u001d\u00151\u0011\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\u0007=\fi\t\u0003\u0005t5\u0005\u0005\t\u0019AA@\u0003\u0011awn\u001a\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002\u0016B!\u0011\u0011QAL\u0013\u0011\tI*a!\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0007=\fy\n\u0003\u0005t;\u0005\u0005\t\u0019AAK\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003=D3aHAU!\u0011\tY+!/\u000e\u0005\u00055&\u0002BAX\u0003c\u000b1!\u00199j\u0015\u0011\t\u0019,!.\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u0017,\u0002\u000b),h.\u001b;\n\t\u0005m\u0016Q\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0001\n\t\r\u0005\u0003\u0002,\u0006\r\u0017\u0002BAc\u0003[\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002E\t\u000b7/[2Bk\u0012LG/T1oC\u001e,'/\u00138ti\u0006tG/[1uS>tG+Z:uQ\r\t\u00131\u001a\t\u0005\u0003W\u000bi-\u0003\u0003\u0002P\u00065&\u0001\u0002+fgR\f1DQ1tS\u000e\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u000bZ,g\u000e^:UKN$\bf\u0001\u0012\u0002L\u0006QB+Z:u\u001fJ$WM\u001d#fY&4XM]=PM6+7o]1hK\"\u001a1%a3\u0002E\t\u000b7/[2F]\u0012\u0014TI\u001c3Bk\u0012LG/T1oC\u001e,'/\u0012<f]R\u001cH+Z:uQ\r!\u00131Z\u0001\u0013\u0013N\u0013V\t\u001f9b]\u0012,e/\u001a8u)\u0016\u001cH\u000fK\u0002&\u0003\u0017\fad\u00117vgR,'\u000fT5oWR\u0013XO\\2bi&|g.\u0012<f]R$Vm\u001d;)\u0007\u0019\nY-\u0001\u0016uKN$(+\u0019;f\u0019&l\u0017\u000e^\"mkN$XM\u001d'j].$&/\u001e8dCRLwN\u001c*fcV,7\u000f^:)\u0007\u001d\nY-\u0001\u0013NSJ\u0014xN]*uCR,7\t[1oO\u0016\u0014V-];fgR\u0014VM[3di\u0016$G+Z:uQ\rA\u00131Z\u0001\u001b\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u0004S\u0005-\u0017\u0001\u0006%fC2$\bn\u00115fG.,e/\u001a8u)\u0016\u001cH\u000fK\u0002+\u0003\u0017\f\u0011c\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8uQ\rY\u00131Z\u0001+i\u0016\u001cH/Q;eSR\u0014V-];fgR|eNU3bI>sG._'jeJ|'\u000fU1si&$\u0018n\u001c8tQ\ra\u00131Z\u0001+i\u0016\u001cH/Q;eSR\u0014V-];fgR|en\u0016:ji\u0006\u0014G.Z'jeJ|'\u000fU1si&$\u0018n\u001c8tQ\ri\u00131Z\u0001\u001fCV$\u0017\u000e\u001e*fcV,7\u000f^(o\u001b&\u0014(o\u001c:QCJ$\u0018\u000e^5p]N$2a\u001cB\u0003\u0011\u001d\u00119A\fa\u0001\u0005\u0013\t1\"\\5se>\u00148\u000b^1uKB!!1\u0002B\n\u001d\u0011\u0011iAa\u0004\u0011\u0007\u0005mS)C\u0002\u0003\u0012\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u000b\u0005/\u0011aa\u0015;sS:<'b\u0001B\t\u000b\u00069B/Z:u\u00032dwn^3e\u000bZ,g\u000e^:GS2$XM\u001d\u0015\u0004_\u0005-\u0017\u0001\n;fgR\fU\u000fZ5u\u0015>\u0014W)\\5ug6+GO]5dg^KG\u000f\u001b(p\u000bZ,g\u000e^:)\u0007A\nY-\u0001\u0015uKN$8k\u00195fIVdW-Q;eSRTuN\u0019*fgB,7\r^:J]&$\u0018.\u00197EK2\f\u0017\u0010K\u00022\u0003\u0017\fQ\u0005^3tiN\u001b\u0007.\u001a3vY\u0016\fU\u000fZ5u\u0015>\u0014'+Z:qK\u000e$8\u000fR1z\u001f\u001aLV-\u0019:)\u0007I\nY-A\u0015uKN$8k\u00195fIVdW-Q;eSRTuN\u0019*fgB,7\r^:MCN$H)Y=PMf+\u0017M\u001d\u0015\u0004g\u0005-\u0017a\u0012;fgR\u001c6\r[3ek2,\u0017)\u001e3ji*{'MU3ta\u0016\u001cGo\u001d'bgR$\u0015-_(g3\u0016\f'oV5uQ*{'\rR;sCRLwN\\$sK\u0006$XM\u001d+iC:\fE)Y=)\u0007Q\nY-\u0001\bBk\u0012LG/U;fk\u0016$Vm\u001d;)\u0007U\nY-\u0001\u0017uKN$HIQ*uCR,\u0007K]3tKJ4X\rZ!gi\u0016\u0014\u0018)\u001e3ji6\u000bg.Y4feJ+7\u000f^1si\"\u001aa'a3\u0002S\u0011,(/\u00192jY&$\u0018pQ8ogVlWM\u001d)pY24%o\\7EkJ\f'-\u001b7jif$v\u000e]5d\u0003\u0019\"Xm\u001d;SCR,G*[7jiN#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<WMU3rk\u0016\u001cHo\u001d\u0015\u0004q\u0005-\u0017\u0001\r;fgRluN\\8u_:L7-\u00197ms&s7M]3bg&tw\rR3mKR,W*Z:tC\u001e,'+Z9vKN$8\u000fK\u0002:\u0003\u0017\u0004")
public class BrokerAuditManagerTest {
    private final org.apache.kafka.common.TopicIdPartition tp1 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 1));
    private final org.apache.kafka.common.TopicIdPartition tp2 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t2", 2));
    private final TopicIdPartition tpId = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
    private Time time;
    private ReplicaManager replicaManager;
    private Option<TierObjectStore> tierObjStoreOpt = None$.MODULE$;
    private File tmpDir;
    private TestBrokerAuditManager testAuditManager;
    private final Seq<Tuple2<Object, Object>> localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    private AbstractLog log;
    private LogManager logManager;

    public org.apache.kafka.common.TopicIdPartition tp1() {
        return this.tp1;
    }

    public org.apache.kafka.common.TopicIdPartition tp2() {
        return this.tp2;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Option<TierObjectStore> tierObjStoreOpt() {
        return this.tierObjStoreOpt;
    }

    public void tierObjStoreOpt_$eq(Option<TierObjectStore> x$1) {
        this.tierObjStoreOpt = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public TestBrokerAuditManager testAuditManager() {
        return this.testAuditManager;
    }

    public void testAuditManager_$eq(TestBrokerAuditManager x$1) {
        this.testAuditManager = x$1;
    }

    public Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.tierObjStoreOpt_$eq((Option<TierObjectStore>)new Some((Object)TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig())));
        this.testAuditManager_$eq(new TestBrokerAuditManager(false));
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)((Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.testAuditManager().cleanUp();
        this.tierObjStoreOpt().foreach((Function1 & Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void BasicAuditManagerInstantiationTest() {
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, false, (Option)None$.MODULE$));
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)1);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().pendingRegistration().size(), (String)"AuditManager didn't clear pending registrations during startup");
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (String)"AuditManager didn't process registration submitted prior to startup");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, false, (Option)None$.MODULE$));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)2, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
    }

    @Test
    public void BasicAuditManagerEventsTest() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true, (Option)None$.MODULE$));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeletePartitionRequest(this.tp1(), 0));
        BrokerAuditManager qual$3 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$7 = qual$3.doWorkActual$default$1();
        boolean x$8 = qual$3.doWorkActual$default$2();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$7, x$8, x$9);
        Assertions.assertNotEquals((Object)this.testAuditManager().instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition reported before fetch");
    }

    @Test
    public void TestOrderDeliveryOfMessage() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicEnd2EndAuditManagerEventsTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), -1, 111L, 10L, RetentionType$.MODULE$.Other(), -1L, -1L));
        Assertions.assertEquals((int)2, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size());
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        long l = 5L;
        long l2 = 111L;
        boolean bl = true;
        long l3 = 111L;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var11_17 = null;
        set = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ISRExpandEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp1(), 0, 3));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"DurabilityTopicConsumer did not read ISRExpand event before timeout");
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = -1L;
        long l2 = -1L;
        boolean bl = false;
        int n2 = 3;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var11_16 = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ClusterLinkTruncationEventTest() {
        void apply_truncationType;
        void apply_nodeId;
        void apply_truncateOffsetTo;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        ReplicaManager x$3 = this.replicaManager();
        Set x$4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.MirrorTopicAudit()}));
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$3, (Option<TierObjectStore>)x$5, x$6, (Set<Enumeration.Value>)x$4, x$7, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)new Some((Object)"Mirror")));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ClusterLinkTruncationRequest(this.tp1(), 0, 100L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), 3L, ClusterLinkTruncationEvent.TruncationType$.MODULE$.TruncateHWM()));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$14 = qual$2.doWorkActual$default$1();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$14, x$15, x$16);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"DurabilityTopicConsumer did not read ClusterLinkTruncation event before timeout");
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        byte by = (byte)ClusterLinkTruncationEvent.TruncationType$.MODULE$.TruncateHWM().id();
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 3L;
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        long l2 = -1L;
        long l3 = -1L;
        boolean bl = false;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var21_28 = null;
        set = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new ClusterLinkTruncationEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (long)apply_truncateOffsetTo, (int)apply_nodeId, (byte)apply_truncationType));
    }

    @Test
    public void testRateLimitClusterLinkTruncationRequests() {
        int currentHighWatermark = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 2, (long)currentHighWatermark, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 2, true, (Option)None$.MODULE$));
        int clusterLinkTruncationRequestCountTp1 = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 3;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), clusterLinkTruncationRequestCountTp1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offsetTruncateTo -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ClusterLinkTruncationRequest(this.tp1(), 2, (long)currentHighWatermark, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (long)(currentHighWatermark - offsetTruncateTo), ClusterLinkTruncationEvent.TruncationType$.MODULE$.TruncateHWM())));
        Assertions.assertEquals((int)(DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp2(), 3, 101L, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 3, true, (Option)None$.MODULE$));
        int clusterLinkTruncationRequestCountTp2 = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 3;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), clusterLinkTruncationRequestCountTp2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offsetTruncateTo -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ClusterLinkTruncationRequest(this.tp2(), 3, (long)DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(), 0L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (long)(DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() - offsetTruncateTo), ClusterLinkTruncationEvent.TruncationType$.MODULE$.TruncateHWM())));
        Assertions.assertEquals((int)DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$2 = qual$1.doWorkActual$default$1();
        boolean x$3 = qual$1.doWorkActual$default$2();
        qual$1.doWorkActual(x$2, x$3, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)4, (int)this.testAuditManager().queue().size(), (String)new StringBuilder(70).append("testAuditManager queue size expect to be: ").append(4).append(", but actual is: ").append(this.testAuditManager().queue().size()).toString());
        TestBrokerAuditManager qual$2 = this.testAuditManager();
        boolean x$4 = qual$2.stopAuditManager$default$1();
        qual$2.stopAuditManager(x$4);
        Assertions.assertNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not shut down fully after call to stopAuditManager");
    }

    @Test
    public void MirrorStateChangeRequestRejectedTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)new Some((Object)"Mirror")));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Object object = ((PartitionState)this.testAuditManager().instance().db().fetchPartitionState(this.tp1().topicPartition()).get()).mirrorState().get();
        String string = "Mirror";
        Assertions.assertTrue((object != null && object.equals(string) ? 1 : 0) != 0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new MirrorStateChangeRequest(this.tp1(), 0, 3L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Option)new Some((Object)"PausedMirror")));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)0, (int)this.testAuditManager().queue().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void MirrorStateChangeEventTest() {
        void apply_nodeId;
        void apply_mirrorState;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        ReplicaManager x$3 = this.replicaManager();
        Set x$4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.MirrorTopicAudit()}));
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$3, (Option<TierObjectStore>)x$5, x$6, (Set<Enumeration.Value>)x$4, x$7, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)new Some((Object)"Mirror")));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Object object = ((PartitionState)this.testAuditManager().instance().db().fetchPartitionState(this.tp1().topicPartition()).get()).mirrorState().get();
        String string = "Mirror";
        Assertions.assertTrue((object != null && object.equals(string) ? 1 : 0) != 0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new MirrorStateChangeRequest(this.tp1(), 0, 3L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Option)new Some((Object)"PausedMirror")));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$14 = qual$2.doWorkActual$default$1();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$14, x$15, x$16);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"DurabilityTopicConsumer did not read MirrorStateChange event before timeout");
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Some some = new Some((Object)"PausedMirror");
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        long l = 0L;
        long l2 = 3L;
        boolean bl = false;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var22_28 = null;
        set = null;
        some = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new MirrorStateChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (Option)apply_mirrorState, (int)apply_nodeId));
    }

    @Test
    public void HealthCheckEventTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), (ReplicaManager)Mockito.mock(ReplicaManager.class), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        org.apache.kafka.common.TopicIdPartition tp = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("durability-health-check", 0));
        this.time().sleep(5L);
        long produceTime = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 0, produceTime));
        this.time().sleep(20L);
        long produceTimeDelayed = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 1, produceTimeDelayed));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 2, produceTimeDelayed));
        Assertions.assertEquals((int)3, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size());
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (!this.testAuditManager().queue().isEmpty()) {
            ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
            Assertions.assertNotNull(events);
            events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        }
        Assertions.assertEquals((int)3, (int)eventList.length());
    }

    @Test
    public void OffsetChangeEvent() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 10L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 1, 10L, 7L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$5 = qual$2.doWorkActual$default$1();
        boolean x$6 = qual$2.doWorkActual$default$2();
        qual$2.doWorkActual(x$5, x$6, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 8L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        BrokerAuditManager qual$3 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$8 = qual$3.doWorkActual$default$1();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$8, true, x$9);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"event received at consumer should not have changed from 1");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 8L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        BrokerAuditManager qual$4 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$4.doWorkActual$default$1();
        boolean x$12 = qual$4.doWorkActual$default$3();
        qual$4.doWorkActual(x$11, true, x$12);
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)0, (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)2, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 0, 8L, 4L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 11L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        BrokerAuditManager qual$5 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$13 = qual$5.doWorkActual$default$1();
        boolean x$14 = qual$5.doWorkActual$default$2();
        boolean x$15 = qual$5.doWorkActual$default$3();
        qual$5.doWorkActual(x$13, x$14, x$15);
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 1");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)this.testAuditManager().queue().size(), (int)2, (String)"event not received at consumer");
        BrokerAuditManager qual$6 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$17 = qual$6.doWorkActual$default$1();
        boolean x$18 = qual$6.doWorkActual$default$3();
        qual$6.doWorkActual(x$17, true, x$18);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, false, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp2(), 1, 10L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        BrokerAuditManager qual$7 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$20 = qual$7.doWorkActual$default$1();
        boolean x$21 = qual$7.doWorkActual$default$3();
        qual$7.doWorkActual(x$20, true, x$21);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
    }

    @Test
    public void testAuditRequestOnReadOnlyMirrorPartitions() {
        this.auditRequestOnMirrorPartitions("Mirror");
    }

    @Test
    public void testAuditRequestOnWritableMirrorPartitions() {
        this.auditRequestOnMirrorPartitions("StoppedMirror");
    }

    /*
     * WARNING - void declaration
     */
    private void auditRequestOnMirrorPartitions(String mirrorState) {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        void apply_nodeId2;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.replicaManager(), mirrorState));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), -1, 8L, 4L, RetentionType$.MODULE$.TimeBasedRetention(), -1L, -1L));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RetentionConfigChangeRequest(this.tp1(), -1, 100L, -1L, false));
        Assertions.assertEquals((int)2, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 1");
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$5 = qual$2.doWorkActual$default$1();
        boolean x$6 = qual$2.doWorkActual$default$2();
        qual$2.doWorkActual(x$5, x$6, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)2, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (!this.testAuditManager().queue().isEmpty()) {
            ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
            if (events == null) continue;
            events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        }
        Assertions.assertEquals((int)2, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        long l = -1L;
        int n2 = 4;
        long l2 = 4L;
        long l3 = 8L;
        boolean bl = true;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var11_18 = null;
        set = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId2));
        int n3 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l4 = -1L;
        long l5 = -1L;
        boolean bl2 = true;
        long l6 = -1L;
        long l7 = 100L;
        org.apache.kafka.common.TopicIdPartition apply_id2 = this.tp1();
        Object var22_25 = null;
        Assertions.assertEquals((Object)eventList.last(), (Object)new RetentionChangeEvent(apply_id2, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false));
    }

    @Test
    public void testAllowedEventsFilter() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        ReplicaManager x$3 = this.replicaManager();
        Set x$4 = Predef$.MODULE$.Set().empty();
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$3, (Option<TierObjectStore>)x$5, x$6, x$7, (Set<Enumeration.Value>)x$4, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Assertions.assertEquals((Object)this.tp1().topicPartition(), (Object)((Tuple2)this.testAuditManager().instance().db().getTopicPartitionsForAudit().head())._1());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 110L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$14 = qual$2.doWorkActual$default$1();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$14, x$15, x$16);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().queue().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuditJobEmitsMetricsWithNoEvents() {
        TopicIdPartition tpId1 = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        .colon.colon tieredOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(11L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(25L, 38L), (List)Nil$.MODULE$));
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(39L, 152L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(160L, 168L), (List)Nil$.MODULE$));
        AbstractLog tp1Log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId1, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)tieredOffsets, this.tierObjStoreOpt());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)tp1Log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Option<TierObjectStore> x$4 = this.tierObjStoreOpt();
        Set x$5 = Predef$.MODULE$.Set().empty();
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, replicaManager, x$4, x$6, x$7, (Set<Enumeration.Value>)x$5, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        Assertions.assertNotNull((Object)this.testAuditManager().instance());
        Metrics metrics = this.testAuditManager().instance().config().metrics();
        Assertions.assertEquals((int)29, (int)metrics.metrics().size());
        Assertions.assertEquals((long)0L, (long)this.testAuditManager().instance().metricsManager().totalLostMessages());
        MetricName name = DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)metrics.metric(name).metricValue());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(true, x$15, x$16);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"AuditJob didn't complete within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)30, (int)metrics.metrics().size());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)11L), (Object)metrics.metric(DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics)).metricValue());
    }

    @Test
    public void testScheduleAuditJobRespectsInitialDelay() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsDayOfYear() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-01-30T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(30);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYear() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(366);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYearWithJobDurationGreaterThanADay() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2021-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(365);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(2L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void AuditQueueTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        int maxEvents = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() + 1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), maxEvents).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)epoch -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), epoch, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)new StringBuilder(58).append("auditRequestsQueue size expected to be: 0, but actual is: ").append(((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size()).toString());
        BrokerAuditManager qual$3 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$7 = qual$3.doWorkActual$default$1();
        boolean x$8 = qual$3.doWorkActual$default$2();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$7, x$8, x$9);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)new StringBuilder(58).append("auditRequestsQueue size expected to be: 0, but actual is: ").append(((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size()).toString());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)maxEvents, (int)this.testAuditManager().queue().size(), (String)new StringBuilder(59).append("testAuditManager queue size expect to be: ").append(maxEvents).append(", but actual is: ").append(this.testAuditManager().queue().size()).toString());
    }

    @Test
    public void testDBStatePreservedAfterAuditManagerRestart() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().fetchTopicStates().size());
        File dbPath = this.testAuditManager().instance().config().dbPath();
        TestBrokerAuditManager qual$2 = this.testAuditManager();
        boolean x$4 = qual$2.stopAuditManager$default$1();
        qual$2.stopAuditManager(x$4);
        Assertions.assertNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not shut down fully after call to stopAuditManager");
        TestBrokerAuditManager x$5 = this.testAuditManager();
        Time x$6 = this.time();
        ReplicaManager x$7 = this.replicaManager();
        Set x$8 = Predef$.MODULE$.Set().empty();
        Some x$9 = new Some((Object)dbPath);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = true;
        Set<Enumeration.Value> x$12 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$13 = None$.MODULE$;
        int x$14 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$5, x$6, x$7, (Option<TierObjectStore>)x$10, x$11, x$12, (Set<Enumeration.Value>)x$8, (Option<TopicPartition>)x$13, x$14, (Option<File>)x$9);
        Assertions.assertNotNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not start up properly after call to initializeTestAuditManager");
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().fetchTopicStates().size(), (String)"Database state was not properly preserved after shutdown / reinitialization of AuditManager");
    }

    private void durabilityConsumerPollFromDurabilityTopic() {
        ConsumerRecords records;
        Duration pollDuration = Duration.ofMillis(this.testAuditManager().instance().topicManager().config().pollDurationMs());
        do {
            if ((records = this.testAuditManager().instance().topicManager().consumerProvider().consumer().poll(pollDuration)) == null) continue;
            this.testAuditManager().instance().topicManager().consumerProvider().processRecords(records);
        } while (records != null);
    }

    @Test
    public void testRateLimitStartOffsetChangeRequests() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 2, 101L, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 2, true, (Option)None$.MODULE$));
        int startOffsetChangeRequestCountTp1 = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 3;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), startOffsetChangeRequestCountTp1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)startOffsetTp1 -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 2, 101L, (long)(startOffsetTp1 + 2), RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L)));
        Assertions.assertEquals((int)(DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp2(), 3, 101L, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 3, true, (Option)None$.MODULE$));
        int startOffsetChangeRequestCountTp2 = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 3;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), startOffsetChangeRequestCountTp2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)startOffsetTp2 -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp2(), 3, 101L, (long)(startOffsetTp2 + 2), RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L)));
        Assertions.assertEquals((int)DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$2 = qual$1.doWorkActual$default$1();
        boolean x$3 = qual$1.doWorkActual$default$2();
        qual$1.doWorkActual(x$2, x$3, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)4, (int)this.testAuditManager().queue().size(), (String)new StringBuilder(70).append("testAuditManager queue size expect to be: ").append(4).append(", but actual is: ").append(this.testAuditManager().queue().size()).toString());
        TestBrokerAuditManager qual$2 = this.testAuditManager();
        boolean x$4 = qual$2.stopAuditManager$default$1();
        qual$2.stopAuditManager(x$4);
        Assertions.assertNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not shut down fully after call to stopAuditManager");
    }

    @Test
    public void testMonotonicallyIncreasingDeleteMessageRequests() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 2, 101L, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 2, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeleteMessagesRequest(this.tp1(), 2, 3L, 101L, 1L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        int deleteMessagesRequestCountTp1 = (DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 4) / 2;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(deleteMessagesRequestCountTp1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)deleteMessagesTp1 -> {
            this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeleteMessagesRequest(this.tp1(), 2, (long)(deleteMessagesTp1 + 2), 101L, 1L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 2, 101L, (long)(deleteMessagesTp1 + 2), RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L));
        });
        Assertions.assertEquals((int)(DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, true, (Option)None$.MODULE$));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp2(), 3, 101L, 101L, 2L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 3, true, (Option)None$.MODULE$));
        int deleteMessagesRequestCountTp2 = (DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() / 2 - 4) / 2;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), deleteMessagesRequestCountTp2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)deleteMessagesTp2 -> {
            this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeleteMessagesRequest(this.tp2(), 3, (long)(deleteMessagesTp2 * 3), 101L, 1L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
            this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeleteMessagesRequest(this.tp2(), 3, (long)(deleteMessagesTp2 * 3 - 2), 101L, 1L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        });
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeleteMessagesRequest(this.tp2(), 3, (long)(deleteMessagesRequestCountTp2 * 3), 101L, 1L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(), (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$2 = qual$1.doWorkActual$default$1();
        boolean x$3 = qual$1.doWorkActual$default$2();
        qual$1.doWorkActual(x$2, x$3, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.durabilityConsumerPollFromDurabilityTopic();
        Assertions.assertEquals((int)28, (int)this.testAuditManager().queue().size(), (String)new StringBuilder(71).append("testAuditManager queue size expect to be: ").append(28).append(", but actual is: ").append(this.testAuditManager().queue().size()).toString());
        TestBrokerAuditManager qual$2 = this.testAuditManager();
        boolean x$4 = qual$2.stopAuditManager$default$1();
        qual$2.stopAuditManager(x$4);
        Assertions.assertNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not shut down fully after call to stopAuditManager");
    }

    public static final /* synthetic */ boolean $anonfun$testAuditJobEmitsMetricsWithNoEvents$1(BrokerAuditManagerTest $this) {
        return 0L == $this.testAuditManager().instance().auditJobCountdownLatch().getCount();
    }

    public static final /* synthetic */ String $anonfun$testAuditJobEmitsMetricsWithNoEvents$2() {
        return "AuditJob didn't complete within timeout";
    }
}

