/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.materialization.DurabilityLapseType$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Enumeration;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021B\u0011b\f\u0001A\u0002\u0003\u0007I\u0011\u0002\u0019\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0013q\u0004\"\u0003#\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011%)\u0005\u00011AA\u0002\u0013%a\tC\u0005K\u0001\u0001\u0007\t\u0019!C\u0005\u0017\"IQ\n\u0001a\u0001\u0002\u0003\u0006Ka\u0012\u0005\n\u001d\u0002\u0001\r\u00111A\u0005\n=C\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011B+\t\u0013]\u0003\u0001\u0019!A!B\u0013\u0001\u0006\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0003Z\u0011%\u0001\u0007\u00011AA\u0002\u0013%\u0011\rC\u0005d\u0001\u0001\u0007\t\u0011)Q\u00055\"9A\r\u0001b\u0001\n\u0003)\u0007B\u00026\u0001A\u0003%a\rC\u0003l\u0001\u0011\u0005A\u000eC\u0003y\u0001\u0011\u0005A\u000eC\u0003~\u0001\u0011\u0005A\u000eC\u0003\u0000\u0001\u0011\u0005A\u000e\u0003\u0004\u0002\u0004\u0001!\t\u0001\u001c\u0005\u0007\u0003\u000f\u0001A\u0011\u00017\t\r\u0005-\u0001\u0001\"\u0001m\u0011\u0019\ty\u0001\u0001C\u0001Y\"1\u00111\u0003\u0001\u0005\u00021Da!a\u0006\u0001\t\u0003a\u0007BBA\u000e\u0001\u0011\u0005A\u000e\u0003\u0004\u0002 \u0001!\t\u0001\u001c\u0002\u0015'\u0016<W.\u001a8u\u001f\u001a47/\u001a;NCB$Vm\u001d;\u000b\u0005yy\u0012!B1vI&$(B\u0001\u0011\"\u0003)!WO]1cS2LG/\u001f\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011!H\u0001\b[\u0016$(/[2t+\u0005\t\u0004C\u0001\u001a<\u001b\u0005\u0019$BA\u00185\u0015\t)d'\u0001\u0004d_6lwN\u001c\u0006\u0003E]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011Ah\r\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\u0005}\u0012\u0005C\u0001\u0014A\u0013\t\tuE\u0001\u0003V]&$\bbB\"\u0004\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0014\u0001C7fiJL7m\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\u0012a\u0012\t\u0003]!K!!S\u000f\u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u00031\u0011X\r]8si\u0016\u0014x\fJ3r)\tyD\nC\u0004D\r\u0005\u0005\t\u0019A$\u0002\u0013I,\u0007o\u001c:uKJ\u0004\u0013\u0001C7NC:\fw-\u001a:\u0016\u0003A\u0003\"!\u0015*\u000e\u0003}I!aU\u0010\u00031\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'/\u0001\u0007n\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002@-\"91)CA\u0001\u0002\u0004\u0001\u0016!C7NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u001b\u0002\u000bU$\u0018\u000e\\:\n\u0005}c&\u0001\u0002+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0003\u007f\tDqa\u0011\u0007\u0002\u0002\u0003\u0007!,A\u0003uS6,\u0007%\u0001\u0003ua&#W#\u00014\u0011\u0005\u001dDW\"\u0001\u001b\n\u0005%$$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0006iBLE\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u007f!\u0012\u0001C\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\f1!\u00199j\u0015\t\u0019H/A\u0004kkBLG/\u001a:\u000b\u0005UL\u0014!\u00026v]&$\u0018BA<q\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001di\u0016\u001cHoU3h[\u0016tG/T1q\t&\u001cH/\u001b8diR{\u0007/[2tQ\t\t\"\u0010\u0005\u0002pw&\u0011A\u0010\u001d\u0002\u0005)\u0016\u001cH/\u0001\u0011uKN$8+Z4nK:$X*\u00199XSRDgj\\%oi\u0016\u00148/Z2uS>t\u0007F\u0001\n{\u0003%\"Xm\u001d;TK\u001elWM\u001c;NCB<\u0016\u000e\u001e5MK\u001a$\u0018J\u001c;feN,7\r^5p]N\u000bW.\u001a*v]\"\u00121C_\u0001/i\u0016\u001cHoU3h[\u0016tG/T1q/&$\b\u000eT3gi&sG/\u001a:tK\u000e$\u0018n\u001c8ES\u001a4WM]3oiJ+h\u000e\u000b\u0002\u0015u\u0006\u0019C/Z:u'\u0016<W.\u001a8u\u001b\u0006\u0004x+\u001b;i%&<\u0007\u000e^%oi\u0016\u00148/Z2uS>t\u0007FA\u000b{\u0003y!Xm\u001d;TK\u001elWM\u001c;NCB<\u0016\u000e\u001e5J]R,'o]3di&|g\u000e\u000b\u0002\u0017u\u0006YC/Z:u'\u0016<W.\u001a8u\u001b\u0006\u0004x+\u001b;i'V\u00147/\u001a;J]R,'o]3di&|gnU1nKJ+h\u000e\u000b\u0002\u0018u\u0006\u0001D/Z:u'\u0016<W.\u001a8u\u001b\u0006\u0004x+\u001b;i'V\u00147/\u001a;J]R,'o]3di&|g\u000eR5gM\u0016\u0014XM\u001c;Sk:D#\u0001\u0007>\u0002iQ,7\u000f\u001e*fa>\u0014H\u000fR;sC\nLG.\u001b;z\u0019\u0006\u00048/Z,ji\"|W\u000f^%oi\u0016\u00148/Z2uS:<7+Z4nK:$8\u000f\u000b\u0002\u001au\u0006\tD/Z:u%\u0016\u0004xN\u001d;EkJ\f'-\u001b7jifd\u0015\r]:f/&$\b.\u00138uKJ\u001cXm\u0019;j]\u001e\u001cVmZ7f]R\u001c\bF\u0001\u000e{\u0003]\"Xm\u001d;SKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3XSRD\u0017J\u001c;feN,7\r^5oON+(m]3u'\u0016<W.\u001a8ug\"\u00121D\u001f")
public class SegmentOffsetMapTest {
    private Metrics metrics;
    private AuditReporter reporter;
    private DurabilityMetricsManager mManager;
    private Time time;
    private final TopicPartition tpId = new TopicPartition("t", 1);

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private AuditReporter reporter() {
        return this.reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public TopicPartition tpId() {
        return this.tpId;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), this.time()));
        Metrics x$2 = this.metrics();
        Time x$3 = this.time();
        long x$5 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        this.mManager_$eq(new DurabilityMetricsManager("0", x$2, x$3, x$5, false));
        DurabilityMetricsManager apply_metricManager = this.mManager();
        Object var5_4 = null;
        this.reporter_$eq(new AuditReporter(apply_metricManager));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapDistinctTopics() {
        void var9_9;
        void var8_8;
        void var6_6;
        void var5_5;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        TopicPartition tpId2 = new TopicPartition("t2", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_5);
        Assertions.assertTrue((boolean)var6_6);
        Tuple2 tuple22 = segmentMap.insert(tpId2, new SegmentRange(15L, 25L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var8_8);
        Assertions.assertTrue((boolean)var9_9);
        Object[] objectArray = new Tuple2[2];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(10L, 20L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Object[] objectArray3 = new SegmentRange[1];
        objectArray3[0] = new SegmentRange(15L, 25L, 0, true);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId2), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithNoIntersection() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(30L, 40L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[2];
        objectArray2[0] = new SegmentRange(10L, 20L, 0, true);
        objectArray2[1] = new SegmentRange(30L, 40L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithLeftIntersectionSameRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 25L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(10L, 25L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithLeftIntersectionDifferentRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 25L, 1, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(10L, 25L, 1, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithRightIntersection() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(5L, 15L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(5L, 20L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithIntersection() {
        void var17_17;
        void var16_16;
        void var14_14;
        void var13_13;
        void var11_11;
        void var10_10;
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(25L, 30L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Tuple2 tuple23 = segmentMap.insert(tpId1, new SegmentRange(18L, 24L, 0, true));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        boolean alert3 = tuple23._1$mcZ$sp();
        boolean lapse3 = tuple23._2$mcZ$sp();
        Assertions.assertTrue((boolean)var10_10);
        Assertions.assertTrue((boolean)var11_11);
        Tuple2 tuple24 = segmentMap.insert(tpId1, new SegmentRange(5L, 8L, 0, true));
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        boolean alert4 = tuple24._1$mcZ$sp();
        boolean lapse4 = tuple24._2$mcZ$sp();
        Assertions.assertTrue((boolean)var13_13);
        Assertions.assertTrue((boolean)var14_14);
        Tuple2 tuple25 = segmentMap.insert(tpId1, new SegmentRange(2L, 50L, 0, true));
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        boolean alert5 = tuple25._1$mcZ$sp();
        boolean lapse5 = tuple25._2$mcZ$sp();
        Assertions.assertTrue((boolean)var16_16);
        Assertions.assertTrue((boolean)var17_17);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(2L, 50L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithSubsetIntersectionSameRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 18L, 0, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertFalse((boolean)var7_7);
        Assertions.assertFalse((boolean)var8_8);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(10L, 20L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithSubsetIntersectionDifferentRun() {
        void var15_15;
        void var14_14;
        void var11_11;
        void var10_10;
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 18L, 1, true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertFalse((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Tuple2 tuple23 = segmentMap.insert(tpId1, new SegmentRange(15L, 18L, 0, true));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        boolean alert3 = tuple23._1$mcZ$sp();
        boolean lapse3 = tuple23._2$mcZ$sp();
        Assertions.assertFalse((boolean)var10_10);
        Assertions.assertTrue((boolean)var11_11);
        Object[] objectArray = new Tuple2[1];
        Object[] objectArray2 = new SegmentRange[1];
        objectArray2[0] = new SegmentRange(10L, 20L, 0, true);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
        Tuple2 tuple24 = segmentMap.insert(tpId1, new SegmentRange(15L, 21L, 1, true));
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        boolean alert4 = tuple24._1$mcZ$sp();
        boolean lapse4 = tuple24._2$mcZ$sp();
        Assertions.assertTrue((boolean)var14_14);
        Assertions.assertTrue((boolean)var15_15);
        Object[] objectArray3 = new Tuple2[1];
        Object[] objectArray4 = new SegmentRange[1];
        objectArray4[0] = new SegmentRange(10L, 21L, 1, true);
        objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4)));
        expectedMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    @Test
    public void testReportDurabilityLapseWithoutIntersectingSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$1 = this.reporter();
        TopicPartition x$1 = this.tpId();
        Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.StartOffset();
        Some x$7 = new Some((Object)"");
        boolean x$8 = qual$1.reportDurabilityLapse$default$7();
        qual$1.reportDurabilityLapse(x$1, 10L, 5L, x$4, "", false, x$8, (Option)x$7);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$2 = this.reporter();
        TopicPartition x$9 = this.tpId();
        Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.StartOffset();
        boolean x$15 = qual$2.reportDurabilityLapse$default$7();
        Option x$16 = qual$2.reportDurabilityLapse$default$8();
        qual$2.reportDurabilityLapse(x$9, 20L, 10L, x$12, "", false, x$15, x$16);
        Assertions.assertEquals((long)15L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testReportDurabilityLapseWithIntersectingSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$1 = this.reporter();
        TopicPartition x$1 = this.tpId();
        Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.StartOffset();
        boolean x$7 = qual$1.reportDurabilityLapse$default$7();
        Option x$8 = qual$1.reportDurabilityLapse$default$8();
        qual$1.reportDurabilityLapse(x$1, 10L, 5L, x$4, "", false, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$2 = this.reporter();
        TopicPartition x$9 = this.tpId();
        Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.StartOffset();
        boolean x$15 = qual$2.reportDurabilityLapse$default$7();
        Option x$16 = qual$2.reportDurabilityLapse$default$8();
        qual$2.reportDurabilityLapse(x$9, 12L, 10L, x$12, "", false, x$15, x$16);
        Assertions.assertEquals((long)15L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testReportDurabilityLapseWithIntersectingSubsetSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$1 = this.reporter();
        TopicPartition x$1 = this.tpId();
        Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.StartOffset();
        boolean x$7 = qual$1.reportDurabilityLapse$default$7();
        Option x$8 = qual$1.reportDurabilityLapse$default$8();
        qual$1.reportDurabilityLapse(x$1, 10L, 5L, x$4, "", false, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        AuditReporter qual$2 = this.reporter();
        TopicPartition x$9 = this.tpId();
        Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.StartOffset();
        boolean x$15 = qual$2.reportDurabilityLapse$default$7();
        Option x$16 = qual$2.reportDurabilityLapse$default$8();
        qual$2.reportDurabilityLapse(x$9, 12L, 2L, x$12, "", false, x$15, x$16);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
    }
}

