/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.Serializable;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftQuorumState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.materialization.ControllerDurabilityEventsMaterialize;
import kafka.durability.materialization.DurabilityLapseType$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001\u0002+V\u0001qCQa\u0019\u0001\u0005\u0002\u0011D\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00025\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011%9\b\u00011AA\u0002\u0013%\u0001\u0010C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\n\u0005=\u0001BCA\n\u0001\u0001\u0007\t\u0011)Q\u0005s\"Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\f\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0004\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0002bCA\u001e\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_A\u0011\"!\u0010\u0001\u0001\u0004%I!a\u0010\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0004\u0002CA4\u0001\u0001\u0006K!!\u0011\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA;\u0001\u0001\u0006I!!\u001c\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAI\u0001\u0001\u0006I!a\u001f\t\u0013\u0005M\u0005A1A\u0005\n\u0005U\u0005\u0002CAL\u0001\u0001\u0006I!a#\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0005\u0002CAR\u0001\u0001\u0006I!!(\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005m\u0005\u0002CAT\u0001\u0001\u0006I!!(\t\u0013\u0005%\u0006A1A\u0005\n\u0005U\u0005\u0002CAV\u0001\u0001\u0006I!a#\t\u0013\u00055\u0006A1A\u0005\n\u0005m\u0005\u0002CAX\u0001\u0001\u0006I!!(\t\u0013\u0005E\u0006A1A\u0005\n\u0005m\u0005\u0002CAZ\u0001\u0001\u0006I!!(\t\u0013\u0005U\u0006A1A\u0005\n\u0005]\u0006\u0002CAf\u0001\u0001\u0006I!!/\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011q\u001d\u0001\u0005\u0002\u0005=\u0007bBAy\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003w\u0004A\u0011AAh\u0011\u001d\ty\u0010\u0001C\u0001\u0003\u001fDqAa\u0001\u0001\t\u0003\ty\rC\u0004\u0003\b\u0001!\t!a4\t\u000f\t-\u0001\u0001\"\u0001\u0002P\"9!q\u0002\u0001\u0005\u0002\u0005=\u0007b\u0002B\n\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005/\u0001A\u0011AAh\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003\u001fDqAa\b\u0001\t\u0003\ty\rC\u0004\u0003$\u0001!IA!\n\t\u000f\t%\u0003\u0001\"\u0001\u0002P\"9!Q\n\u0001\u0005\u0002\u0005=\u0007b\u0002B)\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005+\u0002A\u0011AAh\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003\u001fDqA!\u0018\u0001\t\u0003\ty\rC\u0004\u0003b\u0001!IAa\u0019\t\u000f\t5\u0004\u0001\"\u0001\u0002P\"9!\u0011\u000f\u0001\u0005\u0002\u0005=\u0007b\u0002B;\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005s\u0002A\u0011AAh\u0011\u001d\u0011i\b\u0001C\u0001\u0003\u001fDqA!!\u0001\t\u0003\ty\rC\u0004\u0003\u0006\u0002!IAa\"\t\u000f\tE\u0005\u0001\"\u0001\u0002P\"9!Q\u0013\u0001\u0005\u0002\u0005=\u0007b\u0002BM\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005;\u0003A\u0011AAh\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0003\u001fDqA!*\u0001\t\u0003\ty\rC\u0004\u0003*\u0002!\t!a4\t\u000f\t5\u0006\u0001\"\u0001\u0002P\"9!\u0011\u0017\u0001\u0005\n\tM\u0006b\u0002B_\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005\u0003\u0004A\u0011AAh\u0011\u001d\u0011)\r\u0001C\u0001\u0003\u001fDqA!3\u0001\t\u0003\ty\rC\u0004\u0003N\u0002!\t!a4\t\u000f\tE\u0007\u0001\"\u0001\u0002P\"9!Q\u001b\u0001\u0005\u0002\u0005=\u0007b\u0002Bm\u0001\u0011%!1\u001c\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011%\u00119\u0010AI\u0001\n\u0013\u0011I\u0010C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0003\u0004\u0012!91Q\u0003\u0001\u0005\n\r]!!K\"p]R\u0014x\u000e\u001c7fe\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f)\u0016\u001cHO\u0003\u0002W/\u0006yQ.\u0019;fe&\fG.\u001b>bi&|gN\u0003\u0002Y3\u0006QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003i\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;B\u0011a,Y\u0007\u0002?*\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A3\u0011\u0005\u0019\u0004Q\"A+\u0002\u0011I,\u0007o\u001c:uKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y^\u000bQ!Y;eSRL!A\\6\u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u00031\u0011X\r]8si\u0016\u0014x\fJ3r)\t\tH\u000f\u0005\u0002_e&\u00111o\u0018\u0002\u0005+:LG\u000fC\u0004v\u0007\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'A\u0005sKB|'\u000f^3sA\u0005!A/[7f+\u0005I\bc\u0001>\u0002\n5\t1P\u0003\u0002}{\u0006)Q\u000f^5mg*\u0011ap`\u0001\u0007G>lWn\u001c8\u000b\u0007i\u000b\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB1qC\u000eDWM\u0003\u0002\u0002\b\u0005\u0019qN]4\n\u0007\u0005-1P\u0001\u0003US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0007E\f\t\u0002C\u0004v\r\u0005\u0005\t\u0019A=\u0002\u000bQLW.\u001a\u0011\u0002\u0005\u0011\u0014WCAA\r!\u0011\tY\"a\b\u000e\u0005\u0005u!bAA\u000b/&!\u0011\u0011EA\u000f\u00051!UO]1cS2LG/\u001f#C\u0003\u0019!'m\u0018\u0013fcR\u0019\u0011/a\n\t\u0011UL\u0011\u0011!a\u0001\u00033\t1\u0001\u001a2!\u0003-i\u0017\r^3sS\u0006d\u0017N_3\u0016\u0005\u0005=\u0002c\u00014\u00022%\u0019\u00111G+\u0003K\r{g\u000e\u001e:pY2,'\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,\u0017aD7bi\u0016\u0014\u0018.\u00197ju\u0016|F%Z9\u0015\u0007E\fI\u0004\u0003\u0005v\u0019\u0005\u0005\t\u0019AA\u0018\u00031i\u0017\r^3sS\u0006d\u0017N_3!\u0003%a\u0017\r]:f)f\u0004X-\u0006\u0002\u0002BA!\u00111IA.\u001d\u0011\t)%a\u0016\u000f\t\u0005\u001d\u0013Q\u000b\b\u0005\u0003\u0013\n\u0019F\u0004\u0003\u0002L\u0005ESBAA'\u0015\r\tyeW\u0001\u0007yI|w\u000e\u001e \n\u0003iK!\u0001W-\n\u0005Y;\u0016bAA-+\u0006\u0019B)\u001e:bE&d\u0017\u000e^=MCB\u001cX\rV=qK&!\u0011QLA0\u0005M!UO]1cS2LG/\u001f'baN,G+\u001f9f\u0015\r\tI&V\u0001\u000eY\u0006\u00048/\u001a+za\u0016|F%Z9\u0015\u0007E\f)\u0007\u0003\u0005v\u001f\u0005\u0005\t\u0019AA!\u0003)a\u0017\r]:f)f\u0004X\rI\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:,\"!!\u001c\u0011\t\u0005=\u0014\u0011O\u0007\u0002{&\u0019\u00111O?\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u00051ao\u001c;feN,\"!a\u001f\u0011\r\u0005u\u0014qQAF\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C5n[V$\u0018M\u00197f\u0015\r\t)iX\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAE\u0003\u007f\u00121aU3u!\rq\u0016QR\u0005\u0004\u0003\u001f{&aA%oi\u00069ao\u001c;feN\u0004\u0013a\u00037pG\u0006dgj\u001c3f\u0013\u0012,\"!a#\u0002\u00191|7-\u00197O_\u0012,\u0017\n\u001a\u0011\u0002%%t\u0017\u000e^5bY\u0012\u0013G*Z1eKJDu/\\\u000b\u0003\u0003;\u00032AXAP\u0013\r\t\tk\u0018\u0002\u0005\u0019>tw-A\nj]&$\u0018.\u00197EE2+\u0017\rZ3s\u0011^l\u0007%A\tj]&$\u0018.\u00197EE2{7-\u00197Io6\f!#\u001b8ji&\fG\u000e\u00122M_\u000e\fG\u000eS<nA\u0005q\u0011N\\5uS\u0006dGIY#q_\u000eD\u0017aD5oSRL\u0017\r\u001c#c\u000bB|7\r\u001b\u0011\u0002/%t\u0017\u000e^5bY\u0012\u0013Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018\u0001G5oSRL\u0017\r\u001c#c\u0019><7\u000b^1si>3gm]3uA\u0005i\u0012N\\5uS\u0006dGI\u0019'bgR\\en\\<o\r\u0016$8\r[(gMN,G/\u0001\u0010j]&$\u0018.\u00197EE2\u000b7\u000f^&o_^tg)\u001a;dQ>3gm]3uA\u0005I\u0012N\\5uS\u0006dGI\u0019'bi\u0016\u001cHo\u00158baNDw\u000e^%e+\t\tI\fE\u0003_\u0003w\u000by,C\u0002\u0002>~\u0013AaU8nKB!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F~\fAA]1gi&!\u0011\u0011ZAb\u00059yeMZ:fi\u0006sG-\u00129pG\"\f!$\u001b8ji&\fG\u000e\u00122MCR,7\u000f^*oCB\u001c\bn\u001c;JI\u0002\nQa]3u+B$\u0012!\u001d\u0015\u0004G\u0005M\u0007\u0003BAk\u0003Gl!!a6\u000b\t\u0005e\u00171\\\u0001\u0004CBL'\u0002BAo\u0003?\fqA[;qSR,'O\u0003\u0003\u0002b\u0006\u0015\u0011!\u00026v]&$\u0018\u0002BAs\u0003/\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0013\u0002lB!\u0011Q[Aw\u0013\u0011\ty/a6\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u000f;fgR,e/\u001a8u\u001b\u0006$XM]5bY&T\u0018\r^5p]J+'.Z2uK\u0012Le\rU1si&$\u0018n\u001c8O_R\u0014VmZ5ti\u0016\u0014X\r\u001a\u0015\u0004K\u0005U\b\u0003BAk\u0003oLA!!?\u0002X\n!A+Z:u\u0003Q\"Xm\u001d;Fm\u0016tG/T1uKJL\u0017\r\\5{CRLwN\u001c*fU\u0016\u001cG/\u001a3JM\u00163XM\u001c;UsB,\u0017j]%om\u0006d\u0017\u000e\u001a\u0015\u0004M\u0005U\u0018A\u000b;fgRl\u0015\r^3sS\u0006d\u0017N_3WC2LGm\u0013*bMRdU-\u00193fe\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0015\u0004O\u0005U\u0018a\u000e;fgRLeN^1mS\u0012\\%+\u00194u\u0019\u0016\fG-\u001a:DQ\u0006tw-Z#wK:$x+\u001b;i\u0019\u0016\fG-\u001a:M_\u001e|U\u000f^(g\t\u0006$X\rK\u0002)\u0003k\f1\u0007^3ti&sg/\u00197jI.\u0013\u0016M\u001a;MK\u0006$WM]\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5O_R,en\\;hQZ{G/Z:)\u0007%\n)0A\u001buKN$\u0018J\u001c<bY&$7JU1gi2+\u0017\rZ3s\u0007\"\fgnZ3Fm\u0016tGoV5uQ:{gnQ;se\u0016tGOV8uKJ\u001c\bf\u0001\u0016\u0002v\u0006!D/Z:u\u0013:4\u0018\r\\5e\u0017J\u000bg\r\u001e'fC\u0012,'o\u00115b]\u001e,WI^3oi^KG\u000f\u001b#va2L7-\u0019;f\u0019\u0016\fG-\u001a:)\u0007-\n)0\u0001\u001cuKN$\u0018J\u001c<bY&$7JU1gi2+\u0017\rZ3s\u0007\"\fgnZ3Fm\u0016tGoV5uQ&sg/\u00197jI\u0016\u0003xn\u00195DQ\u0006Lg\u000eK\u0002-\u0003k\f\u0011\n^3ti&sg/\u00197jI.\u0013\u0016M\u001a;MK\u0006$WM]\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5WC2LG-\u00129pG\"\u001c\u0005.Y5o/&$\b.T5o\u001f\u001a47/\u001a;NSNl\u0017\r^2iQ\ri\u0013Q_\u0001<i\u0016\u001cH/\u00138wC2LGm\u0013*bMRdU-\u00193fe\u000eC\u0017M\\4f\u000bZ,g\u000e^,ji\"dunZ*uCJ$xJ\u001a4tKR$Um\u0019:fCN,\u0007f\u0001\u0018\u0002v\u0006)D/Z:u\u0013:4\u0018\r\\5e\u0017J\u000bg\r\u001e'fC\u0012,'o\u00115b]\u001e,WI^3oi^KG\u000f\u001b'pG\u0006d\u0007jV'EK\u000e\u0014X-Y:fQ\ry\u0013Q_\u0001'O\u0016$X\t\u001f9fGR,Gm\u0013*bMR\u001cF/\u0019;f\u0003\u001a$XM\u001d'fC\u0012,'o\u00115b]\u001e,G\u0003\u0002B\u0014\u0005g\u0001BA!\u000b\u000305\u0011!1\u0006\u0006\u0005\u0005[\ti\"A\u0003le\u00064G/\u0003\u0003\u00032\t-\"\u0001E&SC\u001a$\u0018+^8sk6\u001cF/\u0019;f\u0011\u001d\u0011)\u0004\ra\u0001\u0005o\tQ!\u001a<f]R\u0004BA!\u000f\u0003F5\u0011!1\b\u0006\u0005\u0005[\u0011iD\u0003\u0003\u0003@\t\u0005\u0013AC2p]R\u0014x\u000e\u001c7fe*\u0019!1I,\u0002\r\u00154XM\u001c;t\u0013\u0011\u00119Ea\u000f\u0003--\u0013\u0016M\u001a;MK\u0006$WM]\"iC:<W-\u0012<f]R\fq\u0005^3ti6\u000bG/\u001a:jC2L'0\u001a,bY&$7JU1gi\";Vj\u00115b]\u001e,WI^3oi\"\u001a\u0011'!>\u0002cQ,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$\bjV'DQ\u0006tw-Z#wK:$x+\u001b;i\tV\u0004H.[2bi\u0016dU-\u00193fe\"\u001a!'!>\u0002qQ,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$\bjV'DQ\u0006tw-Z#wK:$x+\u001b;i\u0019><7\u000b^1si>3gm]3u\t\u0016\u001c'/Z1tK\"\u001a1'!>\u0002[Q,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$\bjV'DQ\u0006tw-Z#wK:$x+\u001b;i\u0011^kE)Z2sK\u0006\u001cX\rK\u00025\u0003k\f1\u0007^3ti&sg/\u00197jI.\u0013\u0016M\u001a;I/6\u001b\u0005.\u00198hK\u00163XM\u001c;XSRD\u0007jV'NSN\u001c\u0017\r\\2vY\u0006$\u0018n\u001c8)\u0007U\n)0A\u001cuKN$\u0018J\u001c<bY&$7JU1gi\";Vj\u00115b]\u001e,WI^3oi^KG\u000f[(vi>3G)\u0019;f#V|'/^7W_R,'o\u001d\u0015\u0004m\u0005U\u0018aI4fi\u0016C\b/Z2uK\u0012\\%+\u00194u'R\fG/Z!gi\u0016\u0014\bjV'DQ\u0006tw-\u001a\u000b\u0005\u0005O\u0011)\u0007C\u0004\u00036]\u0002\rAa\u001a\u0011\t\te\"\u0011N\u0005\u0005\u0005W\u0012YDA\nL%\u00064G\u000fS,N\u0007\"\fgnZ3Fm\u0016tG/\u0001\u001auKN$X*\u0019;fe&\fG.\u001b>f-\u0006d\u0017\u000eZ&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8uQ\rA\u0014Q_\u00018i\u0016\u001cH/\u00138wC2LGm\u0013*bMRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;P]:{g\u000eT8dC2tu\u000eZ3)\u0007e\n)0A\"uKN$\u0018J\u001c<bY&$7JU1gi2{wm\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e^,ji\"dunZ*uCJ$xJ\u001a4tKR$Um\u0019:fCN,\u0007f\u0001\u001e\u0002v\u0006aD/Z:u\u0013:4\u0018\r\\5e\u0017J\u000bg\r\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5EkBd\u0017nY1uK2+\u0017\rZ3sQ\rY\u0014Q_\u0001Ci\u0016\u001cH/\u00138wC2LGm\u0013*bMRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;XSRD\u0007jV'EK\u000e\u0014X-Y:f\rJ|W\u000eT3bI\u0016\u0014\bf\u0001\u001f\u0002v\u0006)E/Z:u\u0013:4\u0018\r\\5e\u0017J\u000bg\r\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5I/6#Um\u0019:fCN,gI]8n\u001d>tG*Z1eKJD3!PA{\u00039:W\r^#ya\u0016\u001cG/\u001a3L%\u00064Go\u0015;bi\u0016\fe\r^3s\u0019><7\u000b^1si>3gm]3u\u0007\"\fgnZ3\u0015\t\t\u001d\"\u0011\u0012\u0005\b\u0005kq\u0004\u0019\u0001BF!\u0011\u0011ID!$\n\t\t=%1\b\u0002\u001f\u0017J\u000bg\r\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R\f1\u0007^3ti6\u000bG/\u001a:jC2L'0\u001a,bY&$7JU1gi2{wm\u00158baNDw\u000e^$f]\u0016\u0014\u0018\r^5p]\u00163XM\u001c;)\u0007}\n)0\u0001\u001duKN$\u0018J\u001c<bY&$7JU1gi2{wm\u00158baNDw\u000e^$f]\u0016\u0014\u0018\r^5p]\u00163XM\u001c;P]:{g\u000eT8dC2tu\u000eZ3)\u0007\u0001\u000b)0\u0001#uKN$\u0018J\u001c<bY&$7JU1gi2{wm\u00158baNDw\u000e^$f]\u0016\u0014\u0018\r^5p]\u00163XM\u001c;XSRDGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$H)Z2sK\u0006\u001cX\rK\u0002B\u0003k\fQ\b^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGoV5uQ\u0012+\b\u000f\\5dCR,G*Z1eKJD3AQA{\u00031\"Xm\u001d;L%\u00064G\u000fT8h':\f\u0007o\u001d5pi\u001e+g.\u001a:bi&|g.\u0012<f]R<\u0016\u000e\u001e5O_\";V\nK\u0002D\u0003k\f1\t^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGoV5uQ\";V\nR3de\u0016\f7/\u001a$s_6dU-\u00193fe\"\u001aA)!>\u0002\rR,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$Hj\\4T]\u0006\u00048\u000f[8u\u000f\u0016tWM]1uS>tWI^3oi^KG\u000f\u001b%X\u001b\u0012+7M]3bg\u00164%o\\7O_:dU-\u00193fe\"\u001aQ)!>\u0002\u0001R,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$Hj\\4T]\u0006\u00048\u000f[8u\u000f\u0016tWM]1uS>tWI^3oi^KG\u000f[%om\u0006d\u0017\u000e\u001a'pONs\u0017\r]:i_RD3ARA{\u0003=:W\r^#ya\u0016\u001cG/\u001a3L%\u00064Go\u0015;bi\u0016\fe\r^3s\u0019><7K\\1qg\"|GoR3oKJ\fG/[8o)\u0011\u00119C!.\t\u000f\tUr\t1\u0001\u00038B!!\u0011\bB]\u0013\u0011\u0011YLa\u000f\u0003?-\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tG/A\u0015uKN$X*\u0019;fe&\fG.\u001b>f-\u0006d\u0017\u000eZ&SC\u001a$hj\u001c3f'R\f'\u000f^+q\u000bZ,g\u000e\u001e\u0015\u0004\u0011\u0006U\u0018A\f;fgRLeN^1mS\u0012\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R|eNT8o\u0019>\u001c\u0017\r\u001c(pI\u0016D3!SA{\u0003a\"Xm\u001d;WC2LGm\u0013*bMRtu\u000eZ3Ti\u0006\u0014H/\u00169Fm\u0016tGoV5uQ2{wm\u0015;beR|eMZ:fi\u0012+7M]3bg\u0016D3ASA{\u0003M\"Xm\u001d;J]Z\fG.\u001b3L%\u00064GOT8eKN#\u0018M\u001d;Va\u00163XM\u001c;XSRDG)\u001e9mS\u000e\fG/\u001a'fC\u0012,'\u000fK\u0002L\u0003k\f\u0011\b^3ti&sg/\u00197jI.\u0013\u0016M\u001a;O_\u0012,7\u000b^1siV\u0003XI^3oi^KG\u000f\u001b%X\u001b\u0012+7M]3bg\u00164%o\\7MK\u0006$WM\u001d\u0015\u0004\u0019\u0006U\u0018\u0001\u0010;fgRLeN^1mS\u0012\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R<\u0016\u000e\u001e5I/6#Um\u0019:fCN,gI]8n\u001d>tG*Z1eKJD3!TA{\u0003Y\"Xm\u001d;J]Z\fG.\u001b3L%\u00064GOT8eKN#\u0018M\u001d;Va\u00163XM\u001c;XSRD\u0017J\u001c<bY&$Gj\\4T]\u0006\u00048\u000f[8uQ\rq\u0015Q_\u0001&O\u0016$X\t\u001f9fGR,Gm\u0013*bMR\u001cF/\u0019;f\u0003\u001a$XM\u001d(pI\u0016\u001cF/\u0019:u+B$BAa\n\u0003^\"9!QG(A\u0002\t}\u0007\u0003\u0002B\u001d\u0005CLAAa9\u0003<\t)2JU1gi:{G-Z*uCJ$X\u000b]#wK:$\u0018aC5oSR$%m\u0015;bi\u0016$R!\u001dBu\u0005[D\u0011Ba;Q!\u0003\u0005\r!a#\u0002\u001f%t\u0017\u000e^5bY2+\u0017\rZ3s\u0013\u0012D\u0011Ba<Q!\u0003\u0005\rA!=\u0002#%t\u0017\u000e^5bYNs\u0017\r]:i_RLE\rE\u0003_\u0005g\fy,C\u0002\u0003v~\u0013aa\u00149uS>t\u0017!F5oSR$%m\u0015;bi\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005wTC!a#\u0003~.\u0012!q \t\u0005\u0007\u0003\u0019Y!\u0004\u0002\u0004\u0004)!1QAB\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0004\n}\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019iaa\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bj]&$HIY*uCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rM!\u0006\u0002By\u0005{\fadY8oM&\u0014X\u000eR;sC\nLG.\u001b;z\u0019\u0006\u00048/\u001a*fa>\u0014H/\u001a3\u0015\u0007E\u001cI\u0002C\u0004\u0004\u001cM\u0003\r!!\u0011\u0002#\u0015D\b/Z2uK\u0012d\u0015\r]:f)f\u0004X\r")
public class ControllerDurabilityEventsMaterializeTest {
    private AuditReporter reporter;
    private Time time;
    private DurabilityDB db;
    private ControllerDurabilityEventsMaterialize materialize;
    private Enumeration.Value lapseType = DurabilityLapseType$.MODULE$.NonCustomerFacing();
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION);
    private final Set<Object> voters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
    private final int localNodeId;
    private final long initialDbLeaderHwm;
    private final long initialDbLocalHwm;
    private final int initialDbEpoch;
    private final long initialDbLogStartOffset;
    private final long initialDbLastKnownFetchOffset = this.initialDbLeaderHwm();
    private final Some<OffsetAndEpoch> initialDbLatestSnapshotId = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));

    private AuditReporter reporter() {
        return this.reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.reporter = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private DurabilityDB db() {
        return this.db;
    }

    private void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    private ControllerDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    private void materialize_$eq(ControllerDurabilityEventsMaterialize x$1) {
        this.materialize = x$1;
    }

    private Enumeration.Value lapseType() {
        return this.lapseType;
    }

    private void lapseType_$eq(Enumeration.Value x$1) {
        this.lapseType = x$1;
    }

    private TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    private Set<Object> voters() {
        return this.voters;
    }

    private int localNodeId() {
        return this.localNodeId;
    }

    private long initialDbLeaderHwm() {
        return this.initialDbLeaderHwm;
    }

    private long initialDbLocalHwm() {
        return this.initialDbLocalHwm;
    }

    private int initialDbEpoch() {
        return this.initialDbEpoch;
    }

    private long initialDbLogStartOffset() {
        return this.initialDbLogStartOffset;
    }

    private long initialDbLastKnownFetchOffset() {
        return this.initialDbLastKnownFetchOffset;
    }

    private Some<OffsetAndEpoch> initialDbLatestSnapshotId() {
        return this.initialDbLatestSnapshotId;
    }

    @BeforeEach
    public void setUp() {
        this.lapseType_$eq(DurabilityLapseType$.MODULE$.NonCustomerFacing());
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.reporter_$eq((AuditReporter)Mockito.mock(AuditReporter.class));
        this.reporter().reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            this.lapseType_$eq((Enumeration.Value)invocation.getArgument(3));
            return BoxedUnit.UNIT;
        });
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.db().setKRaftLocalNodeId(this.localNodeId());
        this.materialize_$eq(new ControllerDurabilityEventsMaterialize(this.db(), this.reporter(), this.time()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.db());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventMaterializationRejectedIfPartitionNotRegistered() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        boolean bl = true;
        long l = 0L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)20L));
        int n = 2;
        long l2 = 21L;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var3_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertFalse((boolean)this.materialize().materialize(consumerRecord));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventMaterializationRejectedIfEventTypeIsInvalid() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 20L;
        int n2 = 2;
        boolean bl = false;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var3_6 = null;
        IsrExpandEvent invalidEvent = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)invalidEvent, this.topicIdPartition());
        Assertions.assertFalse((boolean)this.materialize().materialize(consumerRecord));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLeaderChangeEvent() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        void apply_yesVoters2;
        void apply_currentVoters2;
        void apply_epochChainOpt2;
        void apply_newLeaderId2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_newEpoch2;
        void apply_logEnd2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent validLeaderChangeEventLocal = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd2, 2, (int)apply_newEpoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (int)apply_newLeaderId2, (Option)apply_epochChainOpt2, (Set)apply_currentVoters2, (Set)apply_yesVoters2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(validLeaderChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLeaderChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        Set<Object> set3 = this.voters();
        Set<Object> set4 = this.voters();
        Some some3 = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)31L))})));
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLogStartOffset() + 2L;
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n4 = this.initialDbEpoch() + 2;
        long l4 = this.initialDbLeaderHwm() + 1L;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var16_21 = null;
        some4 = null;
        some3 = null;
        set4 = null;
        set3 = null;
        KRaftLeaderChangeEvent validLeaderChangeEventNonLocal = new KRaftLeaderChangeEvent(apply_id2, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(validLeaderChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLeaderChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLeaderLogOutOfDate() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm() - 1L;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLeaderLogOutOfDate());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithNotEnoughVotes() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidVotesForLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithNonCurrentVoters() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1000, 1002}));
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidVotesForLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithDuplicateLeader() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch() + 1, this.localNodeId() + 1);
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithInvalidEpochChain() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        ((KRaftPartitionState)this.db().kraftQuorumState().kRaftPartitionStates().apply((Object)this.topicIdPartition())).epochChain().put((Object)BoxesRunTime.boxToInteger((int)1000), (Object)BoxesRunTime.boxToLong((long)5000L));
        ((KRaftPartitionState)this.db().kraftQuorumState().kRaftPartitionStates().apply((Object)this.topicIdPartition())).epochChain().put((Object)BoxesRunTime.boxToInteger((int)2000), (Object)BoxesRunTime.boxToLong((long)6000L));
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidEpochChain());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithValidEpochChainWithMinOffsetMismatch() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        void apply_yesVoters2;
        void apply_currentVoters2;
        void apply_epochChainOpt2;
        void apply_newLeaderId2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_newEpoch2;
        void apply_logEnd2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        ((KRaftPartitionState)this.db().kraftQuorumState().kRaftPartitionStates().apply((Object)this.topicIdPartition())).epochChain().put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L));
        ((KRaftPartitionState)this.db().kraftQuorumState().kRaftPartitionStates().apply((Object)this.topicIdPartition())).epochChain().put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)10L));
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)15L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 2;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd2, 2, (int)apply_newEpoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (int)apply_newLeaderId2, (Option)apply_epochChainOpt2, (Set)apply_currentVoters2, (Set)apply_yesVoters2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        Set<Object> set3 = this.voters();
        Set<Object> set4 = this.voters();
        Some some3 = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToLong((long)18L))})));
        int n3 = this.localNodeId();
        long l3 = this.initialDbLogStartOffset() + 1L;
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n4 = this.initialDbEpoch() + 3;
        long l4 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_21 = null;
        some4 = null;
        some3 = null;
        set4 = null;
        set3 = null;
        leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id2, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLogStartOffsetDecrease() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLocalHWMDecrease() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLeaderChange(KRaftLeaderChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasLogEndOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.newLeaderId() == quorumState.localNodeId();
        quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), (Object)BoxesRunTime.boxToInteger((int)event.newLeaderId()));
        quorumState.epochLeaderIds_$eq((HashMap)quorumState.epochLeaderIds().filter((Function1 & Serializable)epochAndLeader -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$1(event, epochAndLeader))));
        boolean isCurrentLeader = event.epoch() >= BoxesRunTime.unboxToInt((Object)quorumState.epochLeaderIds().keys().max((Ordering)Ordering.Int$.MODULE$));
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        Map newEpochChain = (Map)((scala.collection.mutable.MapOps)event.epochChainOpt().getOrElse((Function0 & Serializable)() -> new HashMap())).clone();
        if (event.epochChainOpt().isDefined() && BoxesRunTime.unboxToLong((Object)event.highWatermarkOpt().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) < BoxesRunTime.unboxToLong((Object)((MapOps)event.epochChainOpt().get()).apply((Object)BoxesRunTime.boxToInteger((int)event.epoch())))) {
            newEpochChain.remove((Object)BoxesRunTime.boxToInteger((int)event.epoch()));
        }
        HashMap mergedEpochChain = (HashMap)partitionState.epochChain().filter((Function1 & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$4(event, epochAndStartOffset)));
        if (isCurrentLeader) {
            ((IterableOnceOps)newEpochChain.filter((Function1 & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$5(event, epochAndStartOffset)))).foreach((Function1 & Serializable)epochAndStartOffset -> mergedEpochChain.put((Object)BoxesRunTime.boxToInteger((int)epochAndStartOffset._1$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)epochAndStartOffset._2$mcJ$sp())));
        }
        boolean bl = hasLogEndOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode || event.yesVoters().contains((Object)BoxesRunTime.boxToInteger((int)this.localNodeId())) && event.epoch() > quorumState.epoch()) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasLogEndOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = isCurrentLeader ? mergedEpochChain : partitionState.epochChain();
        Option option2 = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var10_17 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftHWMChangeEvent() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_currentVoters2;
        void apply_quorumFetchOffsets2;
        void apply_nodeId2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent validHWMChangeEventLocal = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (int)apply_nodeId2, (Map)apply_quorumFetchOffsets2, (Set)apply_currentVoters2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(validHWMChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validHWMChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        Set<Object> set2 = this.voters();
        Map map2 = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLogStartOffset() + 2L;
        long l4 = this.initialDbLeaderHwm() + 2L;
        int n4 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_17 = null;
        map2 = null;
        set2 = null;
        KRaftHWMChangeEvent validHWMChangeEventNonLocal = new KRaftHWMChangeEvent(apply_id2, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(validHWMChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validHWMChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithDuplicateLeader() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithLogStartOffsetDecrease() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() - 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithHWMDecrease() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() - 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithHWMMiscalculation() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMMiscalculation());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithOutOfDateQuorumVoters() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)100)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMMiscalculation());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterHWMChange(KRaftHWMChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), (Object)BoxesRunTime.boxToInteger((int)event.nodeId()));
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && (BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)quorumState.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode || event.quorumFetchOffsets().contains((Object)BoxesRunTime.boxToInteger((int)this.localNodeId())) && BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().apply((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()))) > -1L && event.epoch() > quorumState.epoch()) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = partitionState.localLatestSnapshotId();
        long l = BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) != -1L ? BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Some some = eventFromLocalNode ? new Some((Object)BoxesRunTime.boxToLong((long)event.highWatermark())) : partitionState.localHighWatermark();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)event.highWatermark()));
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var7_13 = null;
        some2 = null;
        some = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLogStartOffsetChangeEvent() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_latestSnapshotId2;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch() + 1));
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        none$ = null;
        some = null;
        KRaftLogStartOffsetChangeEvent validLogStartOffsetChangeEventLocal = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2, (Option)apply_latestSnapshotId2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(validLogStartOffsetChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogStartOffsetChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$2 = None$.MODULE$;
        None$ none$3 = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 2L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 2L)));
        int n4 = this.initialDbEpoch() + 2;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some3 = null;
        none$3 = null;
        none$2 = null;
        KRaftLogStartOffsetChangeEvent validLogStartOffsetChangeEventNonLocal = new KRaftLogStartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(validLogStartOffsetChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogStartOffsetChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventOnNonLocalNode() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        int n = this.localNodeId() + 1;
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        none$2 = null;
        none$ = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithLogStartOffsetDecrease() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some<OffsetAndEpoch> some = this.initialDbLatestSnapshotId();
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        none$ = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithDuplicateLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithHWMDecreaseFromLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithHWMDecreaseFromNonLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)(this.localNodeId() + 1)));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLogStartOffsetChange(KRaftLogStartOffsetChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = eventFromLocalNode ? event.latestSnapshotId() : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option2 = eventFromLocalNode ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLogSnapshotGenerationEvent() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.localNodeId() + 2, this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)(this.localNodeId() + 2)));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent validLogSnapshotGenerationEventLocal = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(validLogSnapshotGenerationEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogSnapshotGenerationEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$ = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some3 = null;
        offsetAndEpoch2 = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent validLogSnapshotGenerationEventNonLocal = new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(validLogSnapshotGenerationEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogSnapshotGenerationEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventOnNonLocalNode() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId() + 1;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithLogStartOffsetDecrease() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        None$ x$1 = None$.MODULE$;
        int x$2 = this.initDbState$default$1();
        this.initDbState(x$2, (Option<OffsetAndEpoch>)x$1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() - 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var6_10 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithDuplicateLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKRaftLogSnapshotGenerationEventWithNoHWM() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        None$ none$2 = None$.MODULE$;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        none$2 = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithHWMDecreaseFromLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithHWMDecreaseFromNonLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithInvalidLogSnapshot() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        void apply_leaderIdOpt3;
        void apply_nodeId3;
        void apply_newSnapshotId3;
        void apply_logEndOffset3;
        void apply_logStartOffset3;
        void apply_highWatermarkOpt3;
        void apply_epoch3;
        void apply_leaderIdOpt4;
        void apply_nodeId4;
        void apply_newSnapshotId4;
        void apply_logEndOffset4;
        void apply_logStartOffset4;
        void apply_highWatermarkOpt4;
        void apply_epoch4;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch4, (Option)apply_highWatermarkOpt4, (long)apply_logStartOffset4, (long)apply_logEndOffset4, (OffsetAndEpoch)apply_newSnapshotId4, (int)apply_nodeId4, (Option)apply_leaderIdOpt4);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotGap());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLocalHwm() + 2L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_19 = null;
        some2 = null;
        offsetAndEpoch2 = null;
        none$2 = null;
        logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch3, (Option)apply_highWatermarkOpt3, (long)apply_logStartOffset3, (long)apply_logEndOffset3, (OffsetAndEpoch)apply_newSnapshotId3, (int)apply_nodeId3, (Option)apply_leaderIdOpt3);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotExceedsHWM());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$3 = None$.MODULE$;
        int n5 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch3 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l5 = this.initialDbLastKnownFetchOffset() + 1L;
        long l6 = this.initialDbLogStartOffset();
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n6 = this.initialDbEpoch();
        TopicIdPartition apply_id3 = this.topicIdPartition();
        Object var24_27 = null;
        some3 = null;
        offsetAndEpoch3 = null;
        none$3 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id3, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2), this.topicIdPartition()));
        None$ none$4 = None$.MODULE$;
        int n7 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch4 = new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch());
        long l7 = this.initialDbLastKnownFetchOffset() + 1L;
        long l8 = this.initialDbLogStartOffset();
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n8 = this.initialDbEpoch();
        TopicIdPartition apply_id4 = this.topicIdPartition();
        Object var34_35 = null;
        some4 = null;
        offsetAndEpoch4 = null;
        none$4 = null;
        logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id4, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLogSnapshotGeneration(KRaftLogSnapshotGenerationEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Some some = eventFromLocalNode ? new Some((Object)event.newSnapshotId()) : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option2 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option2 = null;
        option = null;
        hashMap2 = null;
        hashMap = null;
        some = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftNodeStartUpEvent() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_latestSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent validNodeStartUpEventLocal = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (Option)apply_latestSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(validNodeStartUpEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validNodeStartUpEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        Some some3 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some4 = null;
        some3 = null;
        none$2 = null;
        KRaftNodeStartUpEvent validNodeStartUpEventNonLocal = new KRaftNodeStartUpEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(validNodeStartUpEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validNodeStartUpEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventOnNonLocalNode() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId() + 1;
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidKRaftNodeStartUpEventWithLogStartOffsetDecrease() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, (Option<OffsetAndEpoch>)None$.MODULE$);
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() - 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset();
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithDuplicateLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        Some some2 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithHWMDecreaseFromLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        Some some2 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithHWMDecreaseFromNonLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithInvalidLogSnapshot() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        void apply_leaderIdOpt3;
        void apply_nodeId3;
        void apply_latestSnapshotId2;
        void apply_logEndOffset3;
        void apply_logStartOffset3;
        void apply_highWatermarkOpt3;
        void apply_epoch3;
        void apply_leaderIdOpt4;
        void apply_nodeId4;
        void apply_newSnapshotId2;
        void apply_logEndOffset4;
        void apply_logStartOffset4;
        void apply_highWatermarkOpt4;
        void apply_epoch4;
        void apply_leaderIdOpt5;
        void apply_nodeId5;
        void apply_latestSnapshotId3;
        void apply_logEndOffset5;
        void apply_logStartOffset5;
        void apply_highWatermarkOpt5;
        void apply_epoch5;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch5, (Option)apply_highWatermarkOpt5, (long)apply_logStartOffset5, (long)apply_logEndOffset5, (Option)apply_latestSnapshotId3, (int)apply_nodeId5, (Option)apply_leaderIdOpt5);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotGap());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset();
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_19 = null;
        some3 = null;
        offsetAndEpoch = null;
        none$2 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch4, (Option)apply_highWatermarkOpt4, (long)apply_logStartOffset4, (long)apply_logEndOffset4, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId4, (Option)apply_leaderIdOpt4), this.topicIdPartition()));
        None$ none$3 = None$.MODULE$;
        int n5 = this.localNodeId();
        Some some4 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));
        long l5 = this.initialDbLastKnownFetchOffset() + 1L;
        long l6 = this.initialDbLogStartOffset();
        Some some5 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n6 = this.initialDbEpoch();
        TopicIdPartition apply_id3 = this.topicIdPartition();
        Object var24_27 = null;
        some5 = null;
        some4 = null;
        none$3 = null;
        nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id3, 2, (int)apply_epoch3, (Option)apply_highWatermarkOpt3, (long)apply_logStartOffset3, (long)apply_logEndOffset3, (Option)apply_latestSnapshotId2, (int)apply_nodeId3, (Option)apply_leaderIdOpt3);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$4 = None$.MODULE$;
        int n7 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l7 = this.initialDbLastKnownFetchOffset() + 1L;
        long l8 = this.initialDbLogStartOffset();
        Some some6 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n8 = this.initialDbEpoch();
        TopicIdPartition apply_id4 = this.topicIdPartition();
        Object var34_35 = null;
        some6 = null;
        offsetAndEpoch2 = null;
        none$4 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id4, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId2, (Option)apply_leaderIdOpt2), this.topicIdPartition()));
        None$ none$5 = None$.MODULE$;
        int n9 = this.localNodeId();
        None$ none$6 = None$.MODULE$;
        long l9 = this.initialDbLastKnownFetchOffset() + 1L;
        long l10 = this.initialDbLogStartOffset();
        Some some7 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n10 = this.initialDbEpoch();
        TopicIdPartition apply_id5 = this.topicIdPartition();
        Object var44_43 = null;
        some7 = null;
        none$6 = null;
        none$5 = null;
        nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id5, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterNodeStartUp(KRaftNodeStartUpEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = eventFromLocalNode ? event.latestSnapshotId() : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option2 = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    private void initDbState(int initialLeaderId, Option<OffsetAndEpoch> initialSnapshotId) {
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean bl = false;
        long l = this.initialDbLastKnownFetchOffset();
        long l2 = this.initialDbLogStartOffset();
        HashMap hashMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap hashMap2 = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)this.initialDbLocalHwm()));
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm()));
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var4_10 = null;
        some2 = null;
        some = null;
        hashMap2 = null;
        hashMap = null;
        KRaftPartitionState kRaftPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, initialSnapshotId);
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), initialLeaderId);
        this.db().addKRaftPartitionState(kRaftPartitionState);
        this.db().setKRaftLocalEpoch(this.initialDbEpoch());
    }

    private int initDbState$default$1() {
        return this.localNodeId();
    }

    private Option<OffsetAndEpoch> initDbState$default$2() {
        return this.initialDbLatestSnapshotId();
    }

    private void confirmDurabilityLapseReported(Enumeration.Value expectedLapseType) {
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.atLeastOnce())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.atMostOnce())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedLapseType, (Object)this.lapseType());
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$1(KRaftLeaderChangeEvent event$1, Tuple2 epochAndLeader) {
        return epochAndLeader._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$4(KRaftLeaderChangeEvent event$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$5(KRaftLeaderChangeEvent event$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public ControllerDurabilityEventsMaterializeTest() {
        this.localNodeId = 0;
        this.initialDbLeaderHwm = 20L;
        this.initialDbLocalHwm = 3L;
        this.initialDbEpoch = 1;
        this.initialDbLogStartOffset = 1L;
    }
}

