/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.durability.ondemand.OnDemandAuditJobOrchestrator;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Node;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OnDemandAuditJobOrchestratorTest {
    private CloseableHttpClient httpClient;
    private MockAdminClient mockAdminClient;
    private OnDemandAuditJobOrchestrator onDemandAuditJobOrchestrator;
    private CloseableHttpResponse closeableHttpResponse;
    private HttpEntity entity;
    private StatusLine statusLine;
    private String topicPartitionConfigFile;

    @BeforeEach
    public void setup() throws Exception {
        this.initializeMockAdminClient();
        this.httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        this.closeableHttpResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        this.statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        String filename = "/src/test/java/kafka/durability/ondemand/topic-partition-config-file.txt";
        this.topicPartitionConfigFile = System.getenv("BAZEL_TEST") != null ? "core/src/test/java/kafka/durability/ondemand/topic-partition-config-file.txt" : Paths.get("", new String[0]).toRealPath(new LinkOption[0]) + "/src/test/java/kafka/durability/ondemand/topic-partition-config-file.txt";
        this.onDemandAuditJobOrchestrator = new OnDemandAuditJobOrchestrator(Boolean.valueOf(false), Boolean.valueOf(false), (AdminClient)this.mockAdminClient, this.httpClient);
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)this.entity);
        Mockito.when((Object)this.closeableHttpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenReturn((Object)this.closeableHttpResponse);
    }

    @Test
    public void test_startOnDemandAuditJob_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("newJob", "true");
        content.addProperty("status", "1");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.startOnDemandAuditJobBasedOnConfig(this.topicPartitionConfigFile);
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    @Test
    public void test_startOnDemandAuditJobForCluster_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("newJob", "true");
        content.addProperty("status", "1");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.startOnDemandAuditJobForCluster();
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    @Test
    public void test_startOnDemandAuditJobForTopic_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("newJob", "true");
        content.addProperty("status", "1");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.startOnDemandAuditJobForTopic("topicA");
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    @Test
    public void test_startOnDemandAuditJobForBroker_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("newJob", "true");
        content.addProperty("status", "1");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.startOnDemandAuditJobForBroker(0);
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    @Test
    public void test_startOnDemandJobForTopicPartition_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("newJob", "true");
        content.addProperty("status", "1");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.startOnDemandJobForTopicPartition("topicA", Collections.singleton(0));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    @Test
    public void test_getAuditJobStatus_success() throws InterruptedException, ExecutionException, IOException {
        JsonObject data = new JsonObject();
        JsonObject attributes = new JsonObject();
        JsonObject content = new JsonObject();
        content.addProperty("jobId", "100");
        content.addProperty("status", "Completed");
        content.addProperty("topicPartitionScanned", "100");
        content.addProperty("topicPartitionScannedSuccess", "100");
        content.addProperty("topicPartitionSkipped", "0");
        content.addProperty("totalTierCompactedPartitionsRequested", "100");
        content.addProperty("topicPartitionsRequested", "100");
        content.addProperty("totalGapCountAcrossPartitions", "10000");
        content.addProperty("totalOffsetCountAcrossPartitions", "0");
        attributes.add("attributes", (JsonElement)content);
        data.add("data", (JsonElement)attributes);
        StringEntity httpEntity = new StringEntity(data.toString());
        Mockito.when((Object)this.closeableHttpResponse.getEntity()).thenReturn((Object)httpEntity);
        this.onDemandAuditJobOrchestrator.getAuditJobStatus(Optional.empty(), false, 100);
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)ArgumentMatchers.any());
    }

    private void initializeMockAdminClient() {
        List<Node> brokers = Arrays.asList(new Node(0, "localhost", 9092), new Node(1, "localhost", 9093));
        this.mockAdminClient = new MockAdminClient(brokers, brokers.get(0));
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("topicA", 3, 2));
        newTopics.add(new NewTopic("topicB", 3, 2));
        this.mockAdminClient.createTopics(newTopics);
    }
}

