/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kafka.durability.ondemand.GetAuditJobStatusRequest;
import kafka.durability.ondemand.StartAuditJobRequest;
import kafka.tier.common.RestServerRequest;
import kafka.tier.common.RestServerUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnDemandAuditJobUtilTest {
    private StartAuditJobRequest startAuditJobRequest;
    private GetAuditJobStatusRequest getAuditJobStatusRequest;

    @Test
    public void test_buildKafkaHttpRequest_startAuditJob() throws IOException, URISyntaxException {
        this.populateStartAuditJobRequest();
        HttpPost postReq = RestServerUtil.buildKafkaHttpPostRequest((RestServerRequest)this.startAuditJobRequest, (URI)this.startAuditJobRequest.uri());
        Assertions.assertEquals((Object)"http://kafka-0.kafka:9080/v1/audit/start-audit-job", (Object)postReq.getURI().toString());
        String content = EntityUtils.toString((HttpEntity)postReq.getEntity());
        Assertions.assertEquals((Object)"{\"job_id\": \"1\",\"topic_partitions_map\": {\"topicA\":[0,1,2,3]},\"compaction_check_needed\": \"false\",\"force_start\": \"false\"}", (Object)content);
    }

    @Test
    public void test_buildKafkaHttpRequest_getAuditJobStatus() throws URISyntaxException, JsonProcessingException {
        this.populateGetAuditJobStatusRequest();
        HttpPost postReq = RestServerUtil.buildKafkaHttpPostRequest((RestServerRequest)this.getAuditJobStatusRequest, (URI)this.getAuditJobStatusRequest.uri());
        Assertions.assertEquals((Object)"http://kafka-0.kafka:9080/v1/audit/get-audit-job-status", (Object)postReq.getURI().toString());
    }

    private void populateStartAuditJobRequest() {
        HashMap topicPartitionsMap = new HashMap();
        topicPartitionsMap.put("topicA", new HashSet());
        ((Set)topicPartitionsMap.get("topicA")).add(0);
        ((Set)topicPartitionsMap.get("topicA")).add(1);
        ((Set)topicPartitionsMap.get("topicA")).add(2);
        ((Set)topicPartitionsMap.get("topicA")).add(3);
        this.startAuditJobRequest = new StartAuditJobRequest("http://kafka-0.kafka:9080", topicPartitionsMap, 1, false, false);
    }

    private void populateGetAuditJobStatusRequest() {
        this.getAuditJobStatusRequest = new GetAuditJobStatusRequest("http://kafka-0.kafka:9080", false, "kafka-0");
    }
}

