/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.Utils$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.topic.DurabilityTopicMessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\u0012$\u0001)BQ!\r\u0001\u0005\u0002IB\u0011\"\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001\u001c\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u00038\u0011%\u0011\u0005\u00011AA\u0002\u0013\u00051\tC\u0005P\u0001\u0001\u0007\t\u0019!C\u0001!\"I!\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0012\u0005\n'\u0002\u0001\r\u00111A\u0005\u0002QC\u0011\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011A-\t\u0013m\u0003\u0001\u0019!A!B\u0013)\u0006\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0001U\u0011%i\u0006\u00011AA\u0002\u0013\u0005a\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005+\"I\u0011\r\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021D\u0011B\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B2\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0001v\u0011%9\b\u00011A\u0001B\u0003&\u0011\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002\f\u0001!\t!\u001f\u0005\u0007\u0003+\u0001A\u0011A=\t\r\u0005e\u0001\u0001\"\u0001z\u0011\u0019\ti\u0002\u0001C\u0001s\"1\u0011\u0011\u0005\u0001\u0005\u0002eDa!!\n\u0001\t\u0003I\bBBA\u0015\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002.\u0001!\t!\u001f\u0005\u0007\u0003c\u0001A\u0011A=\t\r\u0005U\u0002\u0001\"\u0001z\u0011\u0019\tI\u0004\u0001C\u0001s\"1\u0011Q\b\u0001\u0005\u0002eDa!!\u0011\u0001\t\u0003I(a\t#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;feR+7\u000f\u001e\u0006\u0003I\u0015\nQ\u0001^8qS\u000eT!AJ\u0014\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\t1%A\u0005g_Jl\u0017\r\u001e;feV\tq\u0007\u0005\u00025q%\u0011\u0011h\t\u0002 \tV\u0014\u0018MY5mSRLHk\u001c9jG6+7o]1hK\u001a{'/\\1ui\u0016\u0014\u0018!\u00044pe6\fG\u000f^3s?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011A&P\u0005\u0003}5\u0012A!\u00168ji\"9\u0001iAA\u0001\u0002\u00049\u0014a\u0001=%c\u0005Qam\u001c:nCR$XM\u001d\u0011\u0002\tQ\u0004\u0018\u000eZ\u000b\u0002\tB\u0011Q)T\u0007\u0002\r*\u0011q\tS\u0001\u0007G>lWn\u001c8\u000b\u0005!J%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!A\u0014$\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0003;qS\u0012|F%Z9\u0015\u0005q\n\u0006b\u0002!\u0007\u0003\u0003\u0005\r\u0001R\u0001\u0006iBLG\rI\u0001\u0006KB|7\r[\u000b\u0002+B\u0011AFV\u0005\u0003/6\u00121!\u00138u\u0003%)\u0007o\\2i?\u0012*\u0017\u000f\u0006\u0002=5\"9\u0001)CA\u0001\u0002\u0004)\u0016AB3q_\u000eD\u0007%A\u0004wKJ\u001c\u0018n\u001c8\u0002\u0017Y,'o]5p]~#S-\u001d\u000b\u0003y}Cq\u0001\u0011\u0007\u0002\u0002\u0003\u0007Q+\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0003\u0011\u0011\u0017m\\:\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0005%|'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0005cC>\u001cx\fJ3r)\taT\u000eC\u0004A\u001f\u0005\u0005\t\u0019A2\u0002\u000b\t\fwn\u001d\u0011\u0002\u0005A\u001cX#A9\u0011\u0005\u0011\u0014\u0018BA:f\u0005-\u0001&/\u001b8u'R\u0014X-Y7\u0002\rA\u001cx\fJ3r)\tad\u000fC\u0004A%\u0005\u0005\t\u0019A9\u0002\u0007A\u001c\b%A\u0003tKR,\u0006\u000fF\u0001=Q\t!2\u0010E\u0002}\u0003\u000fi\u0011! \u0006\u0003}~\f1!\u00199j\u0015\u0011\t\t!a\u0001\u0002\u000f),\b/\u001b;fe*\u0019\u0011QA&\u0002\u000b),h.\u001b;\n\u0007\u0005%QP\u0001\u0006CK\u001a|'/Z#bG\"\f1DZ8s[\u0006$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;UKN$\bfA\u000b\u0002\u0010A\u0019A0!\u0005\n\u0007\u0005MQP\u0001\u0003UKN$\u0018\u0001\b4pe6\fG\u000fR3mKR,'+Z2pe\u0012\u001cXI^3oiR+7\u000f\u001e\u0015\u0004-\u0005=\u0011A\u00074pe6\fG/\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;UKN$\bfA\f\u0002\u0010\u0005Abm\u001c:nCRL5O]#ya\u0006tG-\u0012<f]R$Vm\u001d;)\u0007a\ty!\u0001\u0010g_Jl\u0017\r\u001e*fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000fV3ti\"\u001a\u0011$a\u0004\u0002A\u0019|'/\\1u'R\f'\u000f^(gMN,Go\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u00045\u0005=\u0011\u0001\t4pe6\fGo\u0013*bMRdU-\u00193fe\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e+fgRD3aGA\b\u0003u1wN]7bi.\u0013\u0016M\u001a;I/6\u001b\u0005.\u00198hK\u00163XM\u001c;UKN$\bf\u0001\u000f\u0002\u0010\u0005ybm\u001c:nCR\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R$Vm\u001d;)\u0007u\ty!\u0001\u0015g_Jl\u0017\r^&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u)\u0016\u001cH\u000fK\u0002\u001f\u0003\u001f\t\u0011FZ8s[\u0006$8JU1gi2{wm\u00158baNDw\u000e^$f]\u0016\u0014\u0018\r^5p]\u00163XM\u001c;UKN$\bfA\u0010\u0002\u0010\u0005!cm\u001c:nCR\u001cE.^:uKJd\u0015N\\6UeVt7-\u0019;j_:,e/\u001a8u)\u0016\u001cH\u000fK\u0002!\u0003\u001f\t\u0001EZ8s[\u0006$X*\u001b:s_J\u001cF/\u0019;f\u0007\"\fgnZ3Fm\u0016tG\u000fV3ti\"\u001a\u0011%a\u0004")
public class DurabilityTopicMessageFormatterTest {
    private DurabilityTopicMessageFormatter formatter;
    private TopicIdPartition tpid;
    private int epoch;
    private int version;
    private ByteArrayOutputStream baos;
    private PrintStream ps;

    public DurabilityTopicMessageFormatter formatter() {
        return this.formatter;
    }

    public void formatter_$eq(DurabilityTopicMessageFormatter x$1) {
        this.formatter = x$1;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public void tpid_$eq(TopicIdPartition x$1) {
        this.tpid = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public int version() {
        return this.version;
    }

    public void version_$eq(int x$1) {
        this.version = x$1;
    }

    public ByteArrayOutputStream baos() {
        return this.baos;
    }

    public void baos_$eq(ByteArrayOutputStream x$1) {
        this.baos = x$1;
    }

    public PrintStream ps() {
        return this.ps;
    }

    public void ps_$eq(PrintStream x$1) {
        this.ps = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.formatter_$eq(new DurabilityTopicMessageFormatter());
        this.tpid_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 0)));
        this.epoch_$eq(0);
        this.version_$eq(1);
        this.baos_$eq(new ByteArrayOutputStream());
        this.ps_$eq(new PrintStream(this.baos()));
    }

    @Test
    public void formatOffsetChangeEventTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID());
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(23).append(metadata).append(" -> OffsetChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatDeleteRecordsEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 100L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        set = null;
        DeleteRecordsEvent obj = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(24).append(metadata).append(" -> DeleteRecordsEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatEpochChangeEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        set = null;
        EpochChangeEvent obj = new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(22).append(metadata).append(" -> EpochChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatIsrExpandEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        int n3 = 5;
        TopicIdPartition apply_id = this.tpid();
        Object var4_6 = null;
        IsrExpandEvent obj = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(20).append(metadata).append(" -> IsrExpandEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatRetentionChangeEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 1000L;
        long l4 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        RetentionChangeEvent obj = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(26).append(metadata).append(" -> RetentionChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatStartOffsetChangeEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        byte by = (byte)RetentionType$.MODULE$.SizeBasedRetention().id();
        long l2 = 21L;
        long l3 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var4_8 = null;
        set = null;
        StartOffsetChangeEvent obj = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(28).append(metadata).append(" -> StartOffsetChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLeaderChangeEventTest() {
        void apply_epochChainOpt;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_version;
        long logStartOffset = 0L;
        long logEndOffset = 21L;
        int newLeaderId = 0;
        HashMap epochChain = new HashMap();
        epochChain.put((Object)BoxesRunTime.boxToInteger((int)this.epoch()), (Object)BoxesRunTime.boxToLong((long)logStartOffset));
        epochChain.put((Object)BoxesRunTime.boxToInteger((int)(this.epoch() + 1)), (Object)BoxesRunTime.boxToLong((long)(logEndOffset + 1L)));
        Set currentVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Set yesVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Some some = new Some((Object)epochChain);
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
        int n = this.epoch() + 1;
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var12_11 = null;
        some2 = null;
        some = null;
        KRaftLeaderChangeEvent obj = new KRaftLeaderChangeEvent(apply_id, logEndOffset, (int)apply_version, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, logStartOffset, newLeaderId, (Option)apply_epochChainOpt, currentVoters, yesVoters);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(28).append(metadata).append(" -> KRaftLeaderChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftHWMChangeEventTest() {
        void apply_epoch;
        void apply_version;
        long logStartOffset = 0L;
        long highWatermark = 21L;
        int nodeId = 0;
        HashMap quorumFetchOffsets = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)nodeId), (Object)BoxesRunTime.boxToLong((long)22L));
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)21L));
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)20L));
        Set currentVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var11_8 = null;
        KRaftHWMChangeEvent obj = new KRaftHWMChangeEvent(apply_id, (int)apply_version, (int)apply_epoch, highWatermark, logStartOffset, nodeId, (Map)quorumFetchOffsets, currentVoters);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(25).append(metadata).append(" -> KRaftHWMChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftNodeStartUpEventTest() {
        void apply_leaderIdOpt;
        void apply_latestSnapshotId;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 5L;
        long logEndOffset = 10L;
        OffsetAndEpoch latestSnapshotId = new OffsetAndEpoch(5L, this.epoch());
        int nodeId = 1;
        None$ none$ = None$.MODULE$;
        Some some = new Some((Object)latestSnapshotId);
        None$ none$2 = None$.MODULE$;
        int n = this.epoch() + 1;
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var10_10 = null;
        none$2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent obj = new KRaftNodeStartUpEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, (Option)apply_latestSnapshotId, nodeId, (Option)apply_leaderIdOpt);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(27).append(metadata).append(" -> KRaftNodeStartUpEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLogStartOffsetChangeEventTest() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 0L;
        long logEndOffset = 21L;
        long highWatermark = 21L;
        int nodeId = 1;
        int leaderId = 0;
        Some some = new Some((Object)new OffsetAndEpoch(highWatermark, this.epoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)highWatermark));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var12_11 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent obj = new KRaftLogStartOffsetChangeEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(36).append(metadata).append(" -> KRaftLogStartOffsetChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLogSnapshotGenerationEventTest() {
        void apply_leaderIdOpt;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 2L;
        long logEndOffset = 21L;
        long highWatermark = 20L;
        OffsetAndEpoch newSnapshotId = new OffsetAndEpoch(2L, 1);
        int nodeId = 0;
        int leaderId = 1;
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)highWatermark));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var13_11 = null;
        some2 = null;
        some = null;
        KRaftLogSnapshotGenerationEvent obj = new KRaftLogSnapshotGenerationEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, newSnapshotId, nodeId, (Option)apply_leaderIdOpt);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(37).append(metadata).append(" -> KRaftLogSnapshotGenerationEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatClusterLinkTruncationEventTest() {
        void apply_truncationType;
        void apply_nodeId;
        void apply_truncateOffsetTo;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        byte by = (byte)ClusterLinkTruncationEvent.TruncationType$.MODULE$.TruncateHWM().id();
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 50L;
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l2 = 0L;
        long l3 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var4_8 = null;
        set = null;
        ClusterLinkTruncationEvent obj = new ClusterLinkTruncationEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (long)apply_truncateOffsetTo, (int)apply_nodeId, (byte)apply_truncationType);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(32).append(metadata).append(" -> ClusterLinkTruncationEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatMirrorStateChangeEventTest() {
        void apply_nodeId;
        void apply_mirrorState;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Some some = new Some((Object)"Mirror");
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        set = null;
        some = null;
        MirrorStateChangeEvent obj = new MirrorStateChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (Option)apply_mirrorState, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(28).append(metadata).append(" -> MirrorStateChangeEvent ").append(obj.toString()).append("\n").toString(), (Object)this.baos().toString());
    }
}

