/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.log.LogManager;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011ea!\u0002-Z\u0003\u0003q\u0006\"B3\u0001\t\u00031\u0007bB5\u0001\u0005\u0004%\tA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0003\u0019\b\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u007f\u0011)\tI\u0001\u0001a\u0001\u0002\u0003\u0006K\u0001\u001e\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"!\t\u0001A\u0003%\u0011q\u0002\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003_A1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002<!Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011AA&\u0011-\ty\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u0010\t\u0013\u0005E\u0003\u00011A\u0005\n\u0005M\u0003\"CA+\u0001\u0001\u0007I\u0011BA,\u0011!\tY\u0006\u0001Q!\n\u0005\r\u0003BBA/\u0001\u0019\u00051\u000fC\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"1\u00111\u0011\u0001\u0005\u0002MDq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006\"CAk\u0001E\u0005I\u0011AAl\u0011\u001d\ti\u000f\u0001C\t\u0003_Dq!!0\u0001\t#\u0011\t\u0001C\u0004\u0003\u0004\u0001!\tB!\u0002\t\u000f\te\u0001\u0001\"\u0005\u0003\u001c!9!1\u0006\u0001\u0005\u0012\tm\u0001b\u0002B\u0017\u0001\u0011E!q\u0006\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003\u0003CqA!\u0015\u0001\t\u0003\n\t\tC\u0004\u0003\\\u0001!\tA!\u0018\t\u0013\t\u001d\u0004!%A\u0005\u0002\t%\u0004\"\u0003B7\u0001E\u0005I\u0011\u0001B5\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cB\u0011B!\u001f\u0001#\u0003%\t!a6\t\u0013\tm\u0004!%A\u0005\u0002\tu\u0004b\u0002BA\u0001\u0011\u0005!1\u0011\u0005\n\u0005K\u0003\u0011\u0013!C\u0001\u0005OC\u0011Ba+\u0001#\u0003%\tAa*\t\u0013\t5\u0006!%A\u0005\u0002\tu\u0004\"\u0003BX\u0001E\u0005I\u0011AAl\u0011%\u0011\t\fAI\u0001\n\u0003\u0011i\bC\u0004\u00034\u0002!\tA!.\t\u0013\t\u0015\u0007!%A\u0005\u0002\u0005]\u0007b\u0002BA\u0001\u0011\u0005!q\u0019\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0011%\u00119\u000eAI\u0001\n\u0003\t9\u000eC\u0004\u0003Z\u0002!\tAa7\t\u000f\te\u0007\u0001\"\u0001\u0004\u0010!9!\u0011\u001c\u0001\u0005\u0002\r]\u0001bBB\u000e\u0001\u0011\u00051Q\u0004\u0005\n\u0007[\u0001\u0011\u0013!C\u0001\u0007_Aqaa\r\u0001\t\u0003\u0019)\u0004C\u0004\u0004:\u0001!\taa\u000f\t\u000f\r-\u0003\u0001\"\u0001\u0004N!911\u000f\u0001\u0005\u0002\rU\u0004bBB>\u0001\u0011\u00051Q\u0010\u0005\b\u0007\u007f\u0002A\u0011ABA\u0011\u001d\u0019)\t\u0001C\u0001\u0007\u000fCqa!$\u0001\t\u0003\u0019y\tC\u0005\u0004\u0016\u0002\t\n\u0011\"\u0001\u0003j!91q\u0013\u0001\u0005\u0002\re\u0005\"CBP\u0001E\u0005I\u0011\u0001B5\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007GCqaa*\u0001\t\u0003\u0019I\u000bC\u0004\u00042\u0002!\t!!!\t\u000f\rM\u0006\u0001\"\u0001\u00046\"I1\u0011\u0018\u0001\u0012\u0002\u0013\u0005!\u0011\u000e\u0005\b\u0007w\u0003A\u0011AAA\u0011\u001d\u0019i\f\u0001C\u0001\u0003\u0003Cqaa0\u0001\t\u0003\u0019\t\rC\u0004\u0004D\u0002!\ta!2\t\u000f\r5\u0007\u0001\"\u0001\u0004P\"91\u0011\u001c\u0001\u0005\u0002\rm\u0007bBBm\u0001\u0011\u00051Q\u001e\u0005\b\u0007_\u0004A\u0011ABy\u0011\u001d\u0019)\u0010\u0001C\u0001\u0007oDqaa?\u0001\t\u0003\u0019i\u0010C\u0004\u0005\u0002\u0001!I\u0001b\u0001\t\u000f\u0011\u001d\u0001\u0001\"\u0001\u0005\n!9AQ\u0002\u0001\u0005\u0002\u0011=\u0001b\u0002C\t\u0001\u0011\u0005A1\u0003\u0005\b\t/\u0001A\u0011AAA\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c(B\u0001.\\\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?B\u0011\u0001mY\u0007\u0002C*\u0011!mW\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\f'!E)v_J,X\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u001a\t\u0003Q\u0002i\u0011!W\u0001\u000eM&\u00148\u000f\u001e\"s_.,'/\u00133\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003a6\u00141!\u00138u\u000391\u0017N]:u\u0005J|7.\u001a:JI\u0002\nq\"\u001b8ti\u0006t7-Z\"p]\u001aLwm]\u000b\u0002iB\u0019Q\u000f\u001f>\u000e\u0003YT!a^7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002zm\n\u00191+Z9\u0011\u0005\u0001\\\u0018B\u0001?b\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002'%t7\u000f^1oG\u0016\u001cuN\u001c4jON|F%Z9\u0015\u0007}\f)\u0001E\u0002m\u0003\u0003I1!a\u0001n\u0005\u0011)f.\u001b;\t\u0011\u0005\u001dQ!!AA\u0002Q\f1\u0001\u001f\u00132\u0003AIgn\u001d;b]\u000e,7i\u001c8gS\u001e\u001c\b%\u0001\u0005`EJ|7.\u001a:t+\t\ty\u0001\u0005\u0004\u0002\u0012\u0005]\u00111D\u0007\u0003\u0003'Q1!!\u0006w\u0003\u001diW\u000f^1cY\u0016LA!!\u0007\u0002\u0014\tY\u0011I\u001d:bs\n+hMZ3s!\r\u0001\u0017QD\u0005\u0004\u0003?\t'aC&bM.\f'I]8lKJ\f\u0011b\u00182s_.,'o\u001d\u0011\u0002\u000f\t\u0014xn[3sgV\u0011\u0011q\u0005\t\u0007\u0003#\tI#a\u0007\n\t\u0005-\u00121\u0003\u0002\u0007\u0005V4g-\u001a:\u0002\u000fM,'O^3sgV\u0011\u0011\u0011\u0007\t\u0007\u0003#\tI#a\r\u0011\u0007\u0001\f)$C\u0002\u00028\u0005\u00141bS1gW\u0006\u001cVM\u001d<fe\u0006)\u0011\r\\5wKV\u0011\u0011Q\b\t\u0006Y\u0006}\u00121I\u0005\u0004\u0003\u0003j'!B!se\u0006L\bc\u00017\u0002F%\u0019\u0011qI7\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011\r\\5wK~#S-\u001d\u000b\u0004\u007f\u00065\u0003\"CA\u0004\u0019\u0005\u0005\t\u0019AA\u001f\u0003\u0019\tG.\u001b<fA\u0005y1m\u001c8ue>dG.\u001a:BY&4X-\u0006\u0002\u0002D\u0005\u00192m\u001c8ue>dG.\u001a:BY&4Xm\u0018\u0013fcR\u0019q0!\u0017\t\u0013\u0005\u001dq\"!AA\u0002\u0005\r\u0013\u0001E2p]R\u0014x\u000e\u001c7fe\u0006c\u0017N^3!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001c\u0018aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f\u001e\u000b\u0004\u007f\u0006\r\u0004bBA3%\u0001\u0007\u0011qM\u0001\ti\u0016\u001cH/\u00138g_B!\u0011\u0011NA>\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014aA1qS*!\u0011\u0011OA:\u0003\u001dQW\u000f]5uKJTA!!\u001e\u0002x\u0005)!.\u001e8ji*\u0011\u0011\u0011P\u0001\u0004_J<\u0017\u0002BA?\u0003W\u0012\u0001\u0002V3ti&sgm\\\u0001#G>tg-[4ve\u0016\u001cVmY;sSRL\u0018I\u001a;feN+'O^3sgN#\u0018M\u001d;\u0015\u0003}\fqaY8oM&<7/A\u0006tKJ4XM\u001d$pe&#G\u0003BAE\u0003\u001f\u0003R\u0001\\AF\u0003gI1!!$n\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011S\u000bA\u0002-\f!!\u001b3\u0002\u0017\t\u0014xn[3s\r>\u0014\u0018\n\u001a\u000b\u0005\u0003/\u000bI\nE\u0003m\u0003\u0017\u000bY\u0002\u0003\u0004\u0002\u0012Z\u0001\ra[\u0001\nE>,h\u000e\u001a)peR$2a[AP\u0011\u0019\u0011w\u00031\u0001\u00024\u0005\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u000b\u0005\u0003K\u000bY\f\u0005\u0003\u0002(\u0006Uf\u0002BAU\u0003c\u00032!a+n\u001b\t\tiKC\u0002\u00020v\u000ba\u0001\u0010:p_Rt\u0014bAAZ[\u00061\u0001K]3eK\u001aLA!a.\u0002:\n11\u000b\u001e:j]\u001eT1!a-n\u0011%\ti\f\u0007I\u0001\u0002\u0004\ty,\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002B\u0006EWBAAb\u0015\u0011\t)-a2\u0002\u000f9,Go^8sW*!\u0011\u0011ZAf\u0003\u0019\u0019w.\\7p]*\u0019A,!4\u000b\t\u0005=\u0017qO\u0001\u0007CB\f7\r[3\n\t\u0005M\u00171\u0019\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u001bE>|Go\u001d;sCB\u001cVM\u001d<feN$C-\u001a4bk2$H%M\u000b\u0003\u00033TC!a0\u0002\\.\u0012\u0011Q\u001c\t\u0005\u0003?\fI/\u0004\u0002\u0002b*!\u00111]As\u0003%)hn\u00195fG.,GMC\u0002\u0002h6\f!\"\u00198o_R\fG/[8o\u0013\u0011\tY/!9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\u0011\u0011\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005m\u0018qY\u0001\tg\u0016\u001cWO]5us&!\u0011q`A{\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0006\u0002\u0002@\u0006qAO];tiN#xN]3GS2,WC\u0001B\u0004!\u0015a\u00171\u0012B\u0005!\u0011\u0011YA!\u0006\u000e\u0005\t5!\u0002\u0002B\b\u0005#\t!![8\u000b\u0005\tM\u0011\u0001\u00026bm\u0006LAAa\u0006\u0003\u000e\t!a)\u001b7f\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\u0011!Q\u0004\t\u0006Y\u0006-%q\u0004\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!Q\u0005B\t\u0003\u0011)H/\u001b7\n\t\t%\"1\u0005\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7/\u0001\u0006ce>\\WM\u001d+j[\u0016$BA!\r\u0003>A!!1\u0007B\u001d\u001b\t\u0011)D\u0003\u0003\u00038\u0005\u001d\u0017!B;uS2\u001c\u0018\u0002\u0002B\u001e\u0005k\u0011A\u0001V5nK\"1!qH\u0010A\u0002-\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004\u007f\n\u0015\u0003bBA3A\u0001\u0007\u0011q\r\u0015\u0004A\t%\u0003\u0003BA5\u0005\u0017JAA!\u0014\u0002l\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002-\r|gnY;se\u0016tGo\u0015;beR\u0014%o\\6feN\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004E\tU\u0003\u0003BA5\u0005/JAA!\u0017\u0002l\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0010e\u0016\u001c'/Z1uK\n\u0013xn[3sgR)qPa\u0018\u0003d!I!\u0011M\u0012\u0011\u0002\u0003\u0007\u00111I\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rC\u0005\u0003f\r\u0002\n\u00111\u0001\u0002D\u000591\u000f^1siV\u0004\u0018!\u0007:fGJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIE*\"Aa\u001b+\t\u0005\r\u00131\\\u0001\u001ae\u0016\u001c'/Z1uK\n\u0013xn[3sg\u0012\"WMZ1vYR$#'\u0001\nde\u0016\fG/Z(gMN,Go\u001d+pa&\u001cG#B@\u0003t\tU\u0004\"CA_MA\u0005\t\u0019AA`\u0011%\u00119H\nI\u0001\u0002\u0004\u0011y\"A\tbI6Lgn\u00117jK:$8i\u001c8gS\u001e\fAd\u0019:fCR,wJ\u001a4tKR\u001cHk\u001c9jG\u0012\"WMZ1vYR$\u0013'\u0001\u000fde\u0016\fG/Z(gMN,Go\u001d+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}$\u0006\u0002B\u0010\u00037\f1b\u0019:fCR,Gk\u001c9jGRq!Q\u0011BI\u0005+\u0013IJ!(\u0003\"\n\r\u0006C\u0002BD\u0005\u001b[7.\u0004\u0002\u0003\n*\u0019!1\u0012<\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002BH\u0005\u0013\u00131!T1q\u0011\u001d\u0011\u0019*\u000ba\u0001\u0003K\u000bQ\u0001^8qS\u000eD\u0001Ba&*!\u0003\u0005\ra[\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0011\tm\u0015\u0006%AA\u0002-\f\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011%\u0011y*\u000bI\u0001\u0002\u0004\u0011y\"A\u0006u_BL7mQ8oM&<\u0007\"CA_SA\u0005\t\u0019AA`\u0011%\u00119(\u000bI\u0001\u0002\u0004\u0011y\"A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%&fA6\u0002\\\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u001a\u0014!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00136\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIY\n\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiRA!Q\u0011B\\\u0005s\u0013\u0019\rC\u0004\u0003\u0014>\u0002\r!!*\t\u000f\tmv\u00061\u0001\u0003>\u0006Q\u0002/\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiB1QOa0l\u0005\u0003L1Aa$w!\r)\bp\u001b\u0005\n\u0003{{\u0003\u0013!a\u0001\u0003\u007f\u000b1e\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$3\u0007\u0006\u0005\u0003\u0006\n%'1\u001aBg\u0011\u001d\u0011\u0019*\ra\u0001\u0003KCqAa/2\u0001\u0004\u0011i\fC\u0004\u0003 F\u0002\rAa\b\u0002\u0017\u0011,G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0006\u007f\nM'Q\u001b\u0005\b\u0005'\u0013\u0004\u0019AAS\u0011%\tiL\rI\u0001\u0002\u0004\ty,A\u000beK2,G/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u00029]\f\u0017\u000e^+oi&dGj\\4De\u0016\fG/\u001a3P]\n\u0013xn[3sgV!!Q\\B\u0002)\u0015y(q\u001cBv\u0011\u001d\u0011\t\u000f\u000ea\u0001\u0005G\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003f\n\u001dXBAAd\u0013\u0011\u0011I/a2\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111\u0005\u001bA\u0002\t5\bC\u0002Bx\u0005s\u0014yP\u0004\u0003\u0003r\nUh\u0002BAV\u0005gL\u0011A\\\u0005\u0004\u0005ol\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005w\u0014iP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u001190\u001c\t\u0005\u0007\u0003\u0019\u0019\u0001\u0004\u0001\u0005\u000f\r\u0015AG1\u0001\u0004\b\t\t!)\u0005\u0003\u0004\n\u0005m\u0001c\u00017\u0004\f%\u00191QB7\u0003\u000f9{G\u000f[5oOR)qp!\u0005\u0004\u0014!9!1S\u001bA\u0002\u0005\u0015\u0006BBB\u000bk\u0001\u00071.A\u0006qCJ$\u0018\u000e^5p]&#GcA@\u0004\u001a!9!\u0011\u001d\u001cA\u0002\t\r\u0018!H<bSR,f\u000e^5m\rR\u00048o\u00158baNDw\u000e^+qY>\fG-\u001a3\u0015\u000b}\u001cyba\t\t\u000f\r\u0005r\u00071\u0001\u0002&\u00069Ao\u001c9jG&#\u0007\"CB\u0013oA\u0005\t\u0019AB\u0014\u0003)9\u0018-\u001b;US6,Wj\u001d\t\u0004Y\u000e%\u0012bAB\u0016[\n!Aj\u001c8h\u0003\u001d:\u0018-\u001b;V]RLGN\u0012;qgNs\u0017\r]:i_R,\u0006\u000f\\8bI\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rE\"\u0006BB\u0014\u00037\f\u0001%\\1zE\u0016<\u0016-\u001b;V]RLGNU3qY&\u001c\u0017m]%o!V\u001c\b.T8eKR\u0019qpa\u000e\t\u000f\t\u0005\u0018\b1\u0001\u0003d\u0006I!M]8lKJLEm\u001d\u000b\u0003\u0007{\u0001B!\u001e=\u0004@A!1\u0011IB$\u001b\t\u0019\u0019E\u0003\u0003\u0004F\tE\u0011\u0001\u00027b]\u001eLAa!\u0013\u0004D\t9\u0011J\u001c;fO\u0016\u0014\u0018\u0001E1eI\u0006sGMV3sS\u001aL\u0018i\u00197t)\u0015y8qJB3\u0011\u001d\u0019\tf\u000fa\u0001\u0007'\nA!Y2mgB1\u0011qUB+\u00073JAaa\u0016\u0002:\n\u00191+\u001a;\u0011\t\rm3\u0011M\u0007\u0003\u0007;RAaa\u0018\u0002H\u0006\u0019\u0011m\u00197\n\t\r\r4Q\f\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0004\u0004hm\u0002\ra!\u001b\u0002\u0011I,7o\\;sG\u0016\u0004Baa\u001b\u0004p5\u00111Q\u000e\u0006\u0005\u0007O\n9-\u0003\u0003\u0004r\r5$a\u0004*fg>,(oY3QCR$XM\u001d8\u0002'I,Wn\u001c<f\u0003:$g+\u001a:jMf\f5\r\\:\u0015\u000b}\u001c9h!\u001f\t\u000f\rEC\b1\u0001\u0004T!91q\r\u001fA\u0002\r%\u0014\u0001E6jY2\u0014\u0016M\u001c3p[\n\u0013xn[3s)\u0005Y\u0017AD6jY2\u0014%o\\6fe\nK\u0018\n\u001a\u000b\u0004\u007f\u000e\r\u0005BBAI}\u0001\u00071.\u0001\u0006lS2d'I]8lKJ$2a`BE\u0011\u0019\u0019Yi\u0010a\u0001W\u0006)\u0011N\u001c3fq\u0006\t\"/Z:uCJ$H)Z1e\u0005J|7.\u001a:\u0015\u000b}\u001c\tja%\t\r\r-\u0005\t1\u0001l\u0011%\u0011\t\u0007\u0011I\u0001\u0002\u0004\t\u0019%A\u000esKN$\u0018M\u001d;EK\u0006$'I]8lKJ$C-\u001a4bk2$HEM\u0001\u0016e\u0016\u001cH/\u0019:u\t\u0016\fGM\u0011:pW\u0016\u0014()_%e)\u0015y81TBO\u0011\u0019\u0011yD\u0011a\u0001W\"I!\u0011\r\"\u0011\u0002\u0003\u0007\u00111I\u0001 e\u0016\u001cH/\u0019:u\t\u0016\fGM\u0011:pW\u0016\u0014()_%eI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0004:f[>4XM\u0011:pW\u0016\u0014HcA@\u0004&\"91\u0011\b#A\u0002\ru\u0012!C1eI\n\u0013xn[3s)\u0015y81VBW\u0011\u0019\u0019Y)\u0012a\u0001W\"11qV#A\u0002i\faaY8oM&<\u0017AD6jY2\fE\u000e\u001c\"s_.,'o]\u0001\u0013e\u0016\u001cH/\u0019:u\t\u0016\fGM\u0011:pW\u0016\u00148\u000fF\u0002\u0000\u0007oC\u0011B!\u0019H!\u0003\u0005\r!a\u0011\u00029I,7\u000f^1si\u0012+\u0017\r\u001a\"s_.,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u000592\u000f[;uI><hnS1gW\u0006\u001cuN\u001c;s_2dWM]\u0001\u0012e\u0016\u001cH/\u0019:u\u0007>tGO]8mY\u0016\u0014\u0018!D4fi\u000e{g\u000e\u001e:pY2,'\u000f\u0006\u0002\u00024\u0005\u0011r-\u001a;L%\u00064GoQ8oiJ|G\u000e\\3s)\t\u00199\rE\u0002a\u0007\u0013L1aa3b\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/\u0001\u0018xC&$hi\u001c:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fG\u000eV8BaB,\u0017M](o\u00032d'I]8lKJ\u001cH#B@\u0004R\u000eU\u0007bBBj\u001b\u0002\u0007\u0011QU\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bY\"91q['A\u0002\u0005\u0015\u0016!D7fG\"\fg.[:n\u001d\u0006lW-A\u0006hKR$v\u000e]5d\u0013\u0012\u001cH\u0003BBo\u0007O\u0004\u0002\"a*\u0004`\u0006\u00156\u0011]\u0005\u0005\u0005\u001f\u000bI\f\u0005\u0003\u0003f\u000e\r\u0018\u0002BBs\u0003\u000f\u0014A!V;jI\"91\u0011\u001e(A\u0002\r-\u0018!\u00028b[\u0016\u001c\b\u0003B;y\u0003K#\"a!8\u0002\u001b\u001d,G\u000fV8qS\u000et\u0015-\\3t)\t\u0019\u0019\u0010\u0005\u0005\u0002(\u000e}7\u0011]AS\u0003I\u0019XM\u001d<fe^KG\u000f\u001b\"s_.,'/\u00133\u0015\t\u0005m1\u0011 \u0005\u0007\u0005\u007f\t\u0006\u0019A6\u0002\u001b\r\u0014X-\u0019;f\u0005J|7.\u001a:t)\ry8q \u0005\b\u0005K\u0012\u0006\u0019AA\"\u0003Y\u0019'/Z1uK\n\u0013xn[3s\rJ|WnQ8oM&<G\u0003BA\u000e\t\u000bAaaa,T\u0001\u0004Q\u0018\u0001\u00042s_.,'oV5uQ&#G\u0003BA\u000e\t\u0017AaAa\u0010U\u0001\u0004Y\u0017aD4fiJ\u000bg\u000eZ8n\u0005J|7.\u001a:\u0015\u0005\u0005m\u0011\u0001D1mSZ,'I]8lKJ\u001cXC\u0001C\u000b!\u0011)\b0a\u0007\u0002;\u0015t7/\u001e:f\u0007>t7/[:uK:$8JU1gi6+G/\u00193bi\u0006\u0004")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private final int firstBrokerId;
    private Seq<KafkaConfig> instanceConfigs;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive;
    private boolean controllerAlive = false;

    public int firstBrokerId() {
        return this.firstBrokerId;
    }

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    private boolean controllerAlive() {
        return this.controllerAlive;
    }

    private void controllerAlive_$eq(boolean x$1) {
        this.controllerAlive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public Option<KafkaBroker> brokerForId(int id) {
        return this.brokers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart(testInfo);
        this.createBrokers(true);
        this.controllerAlive_$eq(true);
        this.configureSecurityAfterServersStart();
    }

    public void concurrentStartBrokers() {
        int numBrokers = this.configs().size();
        ArrayBuffer brokerFutures = ArrayBuffer$.MODULE$.empty();
        ExecutorService executorService = Executors.newFixedThreadPool(numBrokers);
        this.alive_$eq(new boolean[numBrokers]);
        Arrays.fill(this.alive(), false);
        try {
            this.configs().foreach((Function1 & Serializable)config -> (ArrayBuffer)brokerFutures.$plus$eq(executorService.submit(() -> {
                KafkaBroker broker = this.createBrokerFromConfig((KafkaConfig)config);
                broker.startup();
                return broker;
            })));
            AtomicReference firstException = new AtomicReference();
            brokerFutures.foreach((Function1 & Serializable)future -> {
                KafkaServerTestHarness.$anonfun$concurrentStartBrokers$3(this, firstException, future);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), true);
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);){
                TestUtils$.MODULE$.createOffsetsTopicWithAdmin(resource_resource, this.brokers(), this.controllerServers());
            }
            return;
        }
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);){
                map = KafkaServerTestHarness.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties());){
                map = KafkaServerTestHarness.$anonfun$createTopicWithAssignment$1(this, topic, partitionReplicaAssignment, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, this.servers());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties topicConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties());){
                map = KafkaServerTestHarness.$anonfun$createTopic$2(this, topic, partitionReplicaAssignment, topicConfig, resource_resource);
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            try (Admin resource_resource = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties());){
                TestUtils$.MODULE$.deleteTopicWithAdmin(resource_resource, topic, this.aliveBrokers(), this.controllerServers());
            }
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public <B extends KafkaBroker> void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition, Iterable<B> brokers) {
        brokers.foreach((Function1 & Serializable)broker -> {
            KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$1(topicPartition, broker);
            return BoxedUnit.UNIT;
        });
    }

    public void waitUntilLogCreatedOnBrokers(String topic, int partitionId) {
        this.waitUntilLogCreatedOnBrokers(new TopicPartition(topic, partitionId));
    }

    public void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition) {
        Option option;
        long awaitValue_waitTimeMs = 60000L;
        long awaitValue_waitUntilTrue_pause = 100L;
        long awaitValue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$4(this, topicPartition)).isDefined()) {
            if (System.currentTimeMillis() > awaitValue_waitUntilTrue_startTime + awaitValue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$5(topicPartition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(awaitValue_waitTimeMs), awaitValue_waitUntilTrue_pause));
        }
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)option.get();
        Buffer replicas = CollectionConverters$.MODULE$.ListHasAsScala(partitionInfo.isr()).asScala();
        this.waitUntilLogCreatedOnBrokers(topicPartition, (Iterable)replicas.map((Function1 & Serializable)x$3 -> (KafkaBroker)this.brokerForId(Predef$.MODULE$.Integer2int(x$3)).get()));
    }

    public void waitUntilFtpsSnapshotUploaded(String topicId, long waitTimeMs) {
        MockInMemoryTierObjectStore objectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitUntilFtpsSnapshotUploaded$1(objectStore, topicId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)"FTPS snapshot not taken prior to timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), waitUntilTrue_pause));
        }
    }

    public long waitUntilFtpsSnapshotUploaded$default$2() {
        return 300000L;
    }

    public void maybeWaitUntilReplicasInPushMode(TopicPartition topicPartition) {
        if (this.isPushReplicationTest()) {
            TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), topicPartition);
            return;
        }
    }

    public Seq<Integer> brokerIds() {
        return (Seq)this._brokers().map((Function1 & Serializable)b -> new Integer(b.config().brokerId()));
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.removeAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    public int killRandomBroker() {
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return index;
    }

    public void killBrokerById(int id) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$killBrokerById$1(id, b)));
        this.killBroker(brokerIndex);
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown();
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
            return;
        }
    }

    public void restartDeadBroker(int index, boolean reconfigure) {
        if (!this.alive()[index]) {
            if (reconfigure || this.isKRaftTest()) {
                this._brokers().update(index, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(index)));
            }
            ((KafkaBroker)this._brokers().apply(index)).startup();
            this.alive()[index] = true;
            return;
        }
    }

    public boolean restartDeadBroker$default$2() {
        return false;
    }

    public void restartDeadBrokerById(int brokerId, boolean reconfigure) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$restartDeadBrokerById$1(brokerId, b)));
        this.restartDeadBroker(brokerIndex, reconfigure);
    }

    public boolean restartDeadBrokerById$default$2() {
        return false;
    }

    public void removeBroker(Seq<Integer> brokerIds) {
        brokerIds.foreach((Function1 & Serializable)id -> {
            KafkaServerTestHarness.$anonfun$removeBroker$1(this, id);
            return BoxedUnit.UNIT;
        });
    }

    public void addBroker(int index, KafkaConfig config) {
        Assertions.assertTrue((index <= this._brokers().size() ? 1 : 0) != 0, (String)new StringBuilder(33).append("Can only add a broker at index 0-").append(this._brokers().size()).toString());
        KafkaBroker broker = this.createBroker(config, this.brokerTime(config.brokerId()), this.createBroker$default$3(), this.createBroker$default$4());
        if (index >= this._brokers().size()) {
            this._brokers().$plus$eq((Object)broker);
            boolean[] newAlive = new boolean[this._brokers().length()];
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.booleanArrayOps(this.alive())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                newAlive$1[i] = this.alive()[i];
            });
            this.alive_$eq(newAlive);
        } else {
            this._brokers().update(index, (Object)broker);
        }
        this.alive()[index] = true;
    }

    public void killAllBrokers() {
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> this.restartDeadBroker(x$5, reconfigure));
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void shutdownKafkaController() {
        if (this.isKRaftTest()) {
            throw new UnsupportedOperationException("KRaft tests do not have a KafkaController instance.");
        }
        if (this.controllerAlive()) {
            this.getController().shutdown();
            this.controllerAlive_$eq(false);
            return;
        }
    }

    public void restartController() {
        if (this.isKRaftTest()) {
            this.restartControllerServer();
        } else {
            this.shutdownKafkaController();
            Assertions.assertFalse((boolean)this.controllerAlive());
            this.getController().startup();
        }
        this.controllerAlive_$eq(true);
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public ControllerServer getKRaftController() {
        this.checkIsKRaftTest();
        if (!this.controllerServer().controller().isActive()) {
            throw new KafkaException("Could not find the active controller!");
        }
        return this.controllerServer();
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(names).asJava()).get();
            names.foreach((Function1 & Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            names.foreach((Function1 & Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.get(name).get());
                }
                return BoxedUnit.UNIT;
            });
        }
        return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).entrySet().forEach(e -> result.put(e.getValue(), e.getKey()));
            return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public KafkaBroker serverWithBrokerId(int brokerId) {
        return (KafkaBroker)this.brokers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverWithBrokerId$1(brokerId, x$6))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    public void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
        }
        return TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, 0, false, this.isZkMigrationTest() || config.migrationEnabled() && config.interBrokerProtocolVersion().isApiForwardingEnabled());
    }

    public KafkaBroker brokerWithId(int brokerId) {
        return (KafkaBroker)this._brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerWithId$1(brokerId, x$7))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    public KafkaBroker getRandomBroker() {
        KafkaBroker broker = (KafkaBroker)this._brokers().apply(TestUtils$.MODULE$.random().nextInt(this._brokers().size() - 1));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Returning Broker with ID ").append(broker.config().brokerId()).append(" as the next random broker").toString());
        return broker;
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)this._brokers().zipWithIndex()).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, e)))).map((Function1 & Serializable)x$8 -> (KafkaBroker)x$8._1())).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        if (this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$brokerForId$1(int id$2, KafkaBroker s) {
        return s.config().brokerId() == id$2;
    }

    public static final /* synthetic */ void $anonfun$concurrentStartBrokers$3(KafkaServerTestHarness $this, AtomicReference firstException$1, Future future) {
        try {
            KafkaBroker broker = (KafkaBroker)future.get(60000L, TimeUnit.MILLISECONDS);
            $this._brokers().$plus$eq((Object)broker);
            $this.alive()[$this._brokers().length() - 1] = true;
        }
        catch (Exception e) {
            firstException$1.compareAndSet(null, e);
        }
        if (firstException$1.get() != null) {
            throw (Throwable)firstException$1.get();
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(KafkaServerTestHarness $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$3 = $this.brokers();
        Seq<ControllerServer> x$4 = $this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$3, x$4, numPartitions$1, replicationFactor$1, (Map<Object, Seq<Object>>)x$8, topicConfig$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopicWithAssignment$1(KafkaServerTestHarness $this, String topic$2, Map partitionReplicaAssignment$1, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        Seq<ControllerServer> x$5 = $this.controllerServers();
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$2, x$4, x$5, x$6, x$7, (Map<Object, Seq<Object>>)partitionReplicaAssignment$1, x$8);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$2(KafkaServerTestHarness $this, String topic$3, Map partitionReplicaAssignment$2, Properties topicConfig$2, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        Seq<ControllerServer> x$5 = $this.controllerServers();
        int x$7 = 1;
        int x$8 = 1;
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$3, x$4, x$5, x$7, x$8, (Map<Object, Seq<Object>>)partitionReplicaAssignment$2, topicConfig$2);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLogCreatedOnBrokers$2(KafkaBroker broker$1, TopicPartition topicPartition$1) {
        LogManager qual$1 = broker$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLogCreatedOnBrokers$3(TopicPartition topicPartition$1) {
        return new StringBuilder(16).append("Log for ").append(topicPartition$1).append(" created").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilLogCreatedOnBrokers$1(TopicPartition topicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$2(broker, topicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$3(topicPartition$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ Option $anonfun$waitUntilLogCreatedOnBrokers$4(KafkaServerTestHarness $this, TopicPartition topicPartition$2) {
        return ((KafkaBroker)$this.brokers().head()).metadataCache().getPartitionInfo(topicPartition$2.topic(), topicPartition$2.partition());
    }

    public static final /* synthetic */ String $anonfun$waitUntilLogCreatedOnBrokers$5(TopicPartition topicPartition$2) {
        return new StringBuilder(38).append("Partition information for ").append(topicPartition$2).append(" not present").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilFtpsSnapshotUploaded$1(MockInMemoryTierObjectStore objectStore$1, String topicId$1) {
        return !objectStore$1.getStoredKeys().stream().filter(str -> str.startsWith(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix) && str.contains(topicId$1)).collect(Collectors.toList()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitUntilFtpsSnapshotUploaded$3() {
        return "FTPS snapshot not taken prior to timeout";
    }

    public static final /* synthetic */ boolean $anonfun$killBrokerById$1(int id$3, KafkaBroker b) {
        return b.config().brokerId() == id$3;
    }

    public static final /* synthetic */ boolean $anonfun$restartDeadBrokerById$1(int brokerId$1, KafkaBroker b) {
        return b.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeBroker$2(Integer id$4, KafkaBroker x$4) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$4.config().brokerId()), (Object)id$4);
    }

    public static final /* synthetic */ void $anonfun$removeBroker$1(KafkaServerTestHarness $this, Integer id) {
        $this._brokers().$minus$eq($this._brokers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$removeBroker$2(id, x$4))).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(id).append(" not found").toString());
        }));
        $this.alive()[Predef$.MODULE$.Integer2int((Integer)id)] = false;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverWithBrokerId$1(int brokerId$2, KafkaBroker x$6) {
        return x$6.config().brokerId() == brokerId$2;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithId$1(int brokerId$3, KafkaBroker x$7) {
        return x$7.config().brokerId() == brokerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, Tuple2 e) {
        return $this.alive()[e._2$mcI$sp()];
    }

    public KafkaServerTestHarness() {
        this.firstBrokerId = 0;
    }

    public static final /* synthetic */ Object $anonfun$deleteTopic$1$adapted(KafkaServerTestHarness $this, String topic$4, Admin admin) {
        TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic$4, $this.aliveBrokers(), $this.controllerServers());
        return BoxedUnit.UNIT;
    }
}

