/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.AbstractLog;
import kafka.server.KafkaBroker;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkListOffsetsTaskType$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.LinkCoordinatorNotEnabledTaskErrorCode$;
import kafka.server.link.LinkPausedTaskState$;
import kafka.server.link.LinkUnavailableTaskState$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PeriodicPartitionSchedulerTaskType$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.UnknownTaskState$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:11")})
@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}Aq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004*\u0001\u0001\u0006Ia\t\u0005\bU\u0001\u0011\r\u0011\"\u0001#\u0011\u0019Y\u0003\u0001)A\u0005G!9A\u0006\u0001b\u0001\n\u0003i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00038\u0001\u0011\u0005\u0001\bC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\u00121e\u00117vgR,'\u000fT5oW\u0006\u001b\u0018P\\2UCN\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0016-\u0005!A.\u001b8l\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003QI!!\b\u000b\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u001c\u0001\u0005qqN\u001a4tKR$vnQ8n[&$X#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\t1{gnZ\u0001\u0010_\u001a47/\u001a;U_\u000e{W.\\5uA\u0005Q1/\u001f8d!\u0016\u0014\u0018n\u001c3\u0002\u0017MLhn\u0019)fe&|G\rI\u0001\u000eG>t7/^7fe\u001e\u0013x.\u001e9\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\t1\fgn\u001a\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004G\u0001\u0004TiJLgnZ\u0001\u000fG>t7/^7fe\u001e\u0013x.\u001e9!\u0003)#Xm\u001d;PM\u001a\u001cX\r^'jOJ\fG/[8o)\u0006\u001c8n\u0015;bi\u0016<u.Z:J]R|WI\u001d:pe^CWM\u001c+iKJ,7/\u00118Fq&\u001cH/\u001b8h\u0007>t7/^7fe\u001e\u0013x.\u001e9\u0015\u0007eb\u0004\n\u0005\u0002%u%\u00111(\n\u0002\u0005+:LG\u000fC\u0003>\u0011\u0001\u0007a(\u0001\u0004rk>\u0014X/\u001c\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005+S\"\u0001\"\u000b\u0005\rC\u0012A\u0002\u001fs_>$h(\u0003\u0002FK\u00051\u0001K]3eK\u001aL!!N$\u000b\u0005\u0015+\u0003\"B%\t\u0001\u0004Q\u0015aC2p_J$\u0017N\\1u_J\u0004\"\u0001J&\n\u00051+#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u00119S6\f\u0005\u0002P16\t\u0001K\u0003\u0002R%\u00061\u0001/\u0019:b[NT!a\u0015+\u0002\u000f),\b/\u001b;fe*\u0011QKV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002/\u0006\u0019qN]4\n\u0005e\u0003&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005a\u0016\u0001K>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{:\u001awn\u001c:eS:\fGo\u001c:>wFj\b\u0006\u0002\u0005_I\u0016\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019)\u0002\u0011A\u0014xN^5eKJL!a\u00191\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003\u0019\f\u0013aZ\u0001\u0010C2d7i\\7cS:\fG/[8og\u00061D/Z:u\u001f\u001a47/\u001a;NS\u001e\u0014\u0018\r^5p]R\u000b7o[*uCR,W*\u00198bO\u0016lWM\u001c;WCJLw.^:TG\u0016t\u0017M]5pgR\u0019\u0011H[6\t\u000buJ\u0001\u0019\u0001 \t\u000b%K\u0001\u0019\u0001&)\t%q%l\u0017\u0015\u0005\u0013y#g\u000eL\u0001g\u0003%\"Xm\u001d;PM\u001a\u001cX\r^'jOJ\fG/[8o/&$\b.\u00113eK\u0012\u001cuN\\:v[\u0016\u0014xI]8vaR\u0019\u0011(\u001d:\t\u000buR\u0001\u0019\u0001 \t\u000b%S\u0001\u0019\u0001&)\t)q%l\u0017\u0015\u0005\u0015y#W\u000fL\u0001g\u0003\u0005\"Xm\u001d;PM\u001a\u001cX\r^'jOJ\fG/[8o/&$\b.\u00113eK\u0012$v\u000e]5d)\rI\u00040\u001f\u0005\u0006{-\u0001\rA\u0010\u0005\u0006\u0013.\u0001\rA\u0013\u0015\u0005\u00179S6\f\u000b\u0003\f=\u0012dH&\u00014\u0002=Q,7\u000f^*z]\u000e$v\u000e]5dg\u000e{gNZ5hgR\u000b7o[*uCR,G\u0003B\u001d\u0000\u0003\u0003AQ!\u0010\u0007A\u0002yBQ!\u0013\u0007A\u0002)CC\u0001\u0004([7\"*AB\u00183\u0002\b1\na-\u0001\u0016uKN$H+Y:l'R\fG/\u001a$peZ\u000b'/[8vg\u000ecWo\u001d;fe2Kgn[5oOR\u000b7o[:\u0015\u000be\ni!a\u0004\t\u000buj\u0001\u0019\u0001 \t\u000b%k\u0001\u0019\u0001&)\t5q%l\u0017\u0015\u0006\u001by#\u0017Q\u0003\u0017\u0002M\u0006\u0019B/Z:u)>\u0004\u0018nY\"p]\u001aLwmU=oGR)\u0011(a\u0007\u0002\u001e!)QH\u0004a\u0001}!)\u0011J\u0004a\u0001\u0015\"\"aB\u0014.\\Q\u0015qa\fZA\u0012Y\u00051\u0017!\u0005;fgR\fE\r\u001a)beRLG/[8ogR)\u0011(!\u000b\u0002,!)Qh\u0004a\u0001}!)\u0011j\u0004a\u0001\u0015\"\"qB\u0014.\\Q\u0015ya\fZA\u0019Y\u00051\u0017A\u000b;fgR\fE\r\u001a)beRLG/[8og^KG\u000f[*pkJ\u001cW\rT3bI\u0016\u0014X\t]8dQ\n+X\u000e\u001d\u000b\u0006s\u0005]\u0012\u0011\b\u0005\u0006{A\u0001\rA\u0010\u0005\u0006\u0013B\u0001\rA\u0013\u0015\u0005!9S6\fK\u0003\u0011=\u0012\fy\u0004L\u0001g\u0003\t\"Xm\u001d;J]R,'O^1m\u0007\"\fgnZ3G_J\u0004VM]5pI&\u001cG+Y:lgR)\u0011(!\u0012\u0002H!)Q(\u0005a\u0001}!)\u0011*\u0005a\u0001\u0015\"\"\u0011C\u0014.\\Q\u0015\tb\fZA'Y\u00051\u0017A\u000f;fgR$\u0016m]6EKN\u001c'/\u001b9uS>t7OR8s)^|G*\u001b8lg>sG)\u001b4gKJ,g\u000e\u001e'j].\u001cun\u001c:eS:\fGo\u001c:t)\u0015I\u00141KA+\u0011\u0015i$\u00031\u0001?\u0011\u0015I%\u00031\u0001KQ\u0011\u0011bJW.)\u000bIqF-a\u0017-\u0003\u0019Dc\u0001AA0I\u0006-\u0004\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015$+A\u0002ba&LA!!\u001b\u0002d\t\u0019A+Y4\"\u0005\u00055\u0014aC5oi\u0016<'/\u0019;j_:Dc\u0001AA0I\u0006E\u0014EAA:\u0003Q\u0011\u0017M_3muMD\u0017M\u001d3`G>,h\u000e\u001e\u001e2c\u0001")
public class ClusterLinkAsyncTaskIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long offsetToCommit;
    private final long syncPeriod;
    private final String consumerGroup;

    public long offsetToCommit() {
        return this.offsetToCommit;
    }

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationTaskStateGoesIntoErrorWhenTheresAnExistingConsumerGroup(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, (short)2, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", this.consumerGroup());
        consumerProps.setProperty("enable.auto.commit", "false");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ByteArrayDeserializer x$13 = qual$3.createConsumer$default$1();
        ByteArrayDeserializer x$14 = qual$3.createConsumer$default$2();
        List<String> x$15 = qual$3.createConsumer$default$4();
        Consumer consumer = qual$3.createConsumer(x$13, x$14, consumerProps, x$15);
        consumer.subscribe(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJavaCollection());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkAsyncTaskIntegrationTest.$anonfun$testOffsetMigrationTaskStateGoesIntoErrorWhenTheresAnExistingConsumerGroup$2(consumer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to consume records on the destination");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        consumer.commitSync();
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)ConsumerGroupInUseTaskErrorCode$.MODULE$, (Object)new Some((Object)"Unable to commit offsets for consumer group testGroup on the destination cluster because there are active members on the destination already.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.CONSUMER_GROUP_IN_USE_ERROR, "Unable to commit offsets for consumer group testGroup on the destination cluster because there are active members on the destination already."))));
        consumer.close();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        String x$17 = this.linkName();
        boolean x$18 = qual$4.unlinkTopic$default$3();
        boolean x$19 = qual$4.unlinkTopic$default$4();
        boolean x$20 = qual$4.unlinkTopic$default$5();
        int x$21 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$16, x$17, x$18, x$19, x$20, x$21);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.linkName();
        boolean x$23 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$24 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$22, x$23, x$24);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationTaskStateManagementVariousScenarios(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        long finalOffset = 20L;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "6000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.verifyTaskStateAndMetrics((TaskState)NotConfiguredTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        Map updatedProps = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        Set<String> x$10 = qual$2.alterClusterLink$default$4();
        boolean x$11 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$7, (Map<String, String>)updatedProps, x$9, x$10, x$11);
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)MisconfigurationTaskErrorCode$.MODULE$, (Object)new Some((Object)"consumer.offset.sync.enable is true but no consumer group filters are specified. No consumer offsets will be migrated.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.MISCONFIGURATION_ERROR, "consumer.offset.sync.enable is true but no consumer group filters are specified. No consumer offsets will be migrated."))));
        Map updatedPropsWithFilters = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter(this.consumerGroup())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$12, (Map<String, String>)updatedPropsWithFilters, x$14, x$15, x$16);
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = this.topic();
        String x$19 = this.linkName();
        Map<String, String> x$20 = qual$4.linkTopic$default$4();
        String x$21 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(x$17, (short)2, x$19, x$20, x$21);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyConsumerOffsetMigrationMetrics();
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.PAUSED, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)LinkPausedTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_PAUSED, Collections.emptyList()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        String validCreds = linkProps.getProperty("sasl.jaas.config");
        String invalidCreds = this.generateInvalidCredentials(this.sourceCluster());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.linkName();
        Map x$23 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)invalidCreds)}));
        Seq<KafkaBroker> x$24 = qual$5.alterClusterLink$default$3();
        Set<String> x$25 = qual$5.alterClusterLink$default$4();
        boolean x$26 = qual$5.alterClusterLink$default$5();
        qual$5.alterClusterLink(x$22, (Map<String, String>)x$23, x$24, x$25, x$26);
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)AuthenticationTaskErrorCode$.MODULE$, (Object)new Some((Object)"Unable to list consumer groups due to authentication issues.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHENTICATION_ERROR, "Unable to list consumer groups due to authentication issues."))));
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$27 = this.linkName();
        Map x$28 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)validCreds)}));
        Seq<KafkaBroker> x$29 = qual$6.alterClusterLink$default$3();
        Set<String> x$30 = qual$6.alterClusterLink$default$4();
        boolean x$31 = qual$6.alterClusterLink$default$5();
        qual$6.alterClusterLink(x$27, (Map<String, String>)x$28, x$29, x$30, x$31);
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        Map updatedPropsWithAvailabilityCheckerConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp()), (Object)"1")}));
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$32 = this.linkName();
        Seq<KafkaBroker> x$34 = qual$7.alterClusterLink$default$3();
        Set<String> x$35 = qual$7.alterClusterLink$default$4();
        boolean x$36 = qual$7.alterClusterLink$default$5();
        qual$7.alterClusterLink(x$32, (Map<String, String>)updatedPropsWithAvailabilityCheckerConfigs, x$34, x$35, x$36);
        this.sourceCluster().killAllBrokers();
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.UNAVAILABLE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)LinkUnavailableTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_UNAVAILABLE, Collections.emptyList()));
        this.restartSource(this.restartSource$default$1());
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"consumer-offset-sync"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()));
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$37 = this.topic();
        String x$38 = this.linkName();
        boolean x$39 = qual$8.unlinkTopic$default$3();
        boolean x$40 = qual$8.unlinkTopic$default$4();
        boolean x$41 = qual$8.unlinkTopic$default$5();
        int x$42 = qual$8.unlinkTopic$default$6();
        qual$8.unlinkTopic(x$37, x$38, x$39, x$40, x$41, x$42);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$43 = this.linkName();
        boolean x$44 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$45 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$43, x$44, x$45);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationWithAddedConsumerGroup(String quorum, boolean coordinator) {
        long finalOffset = 20L;
        String additionalConsumerGroup = "testGroup2";
        String multiConsumerGroupFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"groupFilters\": [\n          |  {\n          |     \"name\": \"").append(this.consumerGroup()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(additionalConsumerGroup).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, (short)2, x$9, x$11, x$10);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup(), this.verifyOffsetMigration$default$5());
        Map updatedProps = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)multiConsumerGroupFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$12, (Map<String, String>)updatedProps, x$14, x$15, x$16);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, additionalConsumerGroup);
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, additionalConsumerGroup, this.verifyOffsetMigration$default$5());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$18 = this.linkName();
        boolean x$19 = qual$4.unlinkTopic$default$3();
        boolean x$20 = qual$4.unlinkTopic$default$4();
        boolean x$21 = qual$4.unlinkTopic$default$5();
        int x$22 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$17, x$18, x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$25 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$23, x$24, x$25);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationWithAddedTopic(String quorum, boolean coordinator) {
        long finalOffset = 20L;
        String additionalTopic = "linkedTopic2";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(additionalTopic, x$8, x$9, x$10, x$11, x$12);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        String x$15 = this.linkName();
        String x$16 = this.clusterLinkPrefix();
        Map<String, String> x$17 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$13, (short)2, x$15, x$17, x$16);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup(), this.verifyOffsetMigration$default$5());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$20 = this.linkName();
        String x$21 = this.clusterLinkPrefix();
        Map<String, String> x$22 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(additionalTopic, (short)2, x$20, x$22, x$21);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), additionalTopic, 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString(), 0, finalOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$24 = this.linkName();
        boolean x$26 = qual$5.unlinkTopic$default$4();
        boolean x$27 = qual$5.unlinkTopic$default$5();
        int x$28 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$23, x$24, false, x$26, x$27, x$28);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter(this.consumerGroup()).replaceAll("include", "exclude"))}))));
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", this.consumerGroup());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        ByteArrayDeserializer x$30 = qual$6.createConsumer$default$1();
        ByteArrayDeserializer x$31 = qual$6.createConsumer$default$2();
        List<String> x$32 = qual$6.createConsumer$default$4();
        Consumer destConsumer = qual$6.createConsumer(x$30, x$31, consumerProps, x$32);
        destConsumer.subscribe(Collections.singleton(additionalTopic));
        do {
            destConsumer.poll(Duration.ofMillis(10L));
        } while (destConsumer.assignment().isEmpty());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> destConsumer.poll(Duration.ofMillis(10L)));
        try {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$33 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString();
            String x$34 = this.linkName();
            boolean x$35 = qual$7.unlinkTopic$default$3();
            boolean x$36 = qual$7.unlinkTopic$default$4();
            boolean x$37 = qual$7.unlinkTopic$default$5();
            int x$38 = qual$7.unlinkTopic$default$6();
            qual$7.unlinkTopic(x$33, x$34, x$35, x$36, x$37, x$38);
        }
        finally {
            executor.shutdownNow();
        }
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$39 = this.linkName();
        boolean x$40 = qual$8.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$41 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$39, x$40, x$41);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSyncTopicsConfigsTaskState(String quorum, boolean coordinator) {
        void var21_26;
        Tuple2 tuple2;
        this.numPartitions_$eq(1);
        Properties topicConfig = new Properties();
        topicConfig.setProperty("segment.bytes", "1000");
        topicConfig.setProperty("retention.bytes", "1000");
        topicConfig.setProperty("retention.ms", "10000000");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, topicConfig, x$5, x$6);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        String topicConfigInclude = new StringBuilder(14).append(MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",")).append(",segment.bytes").toString();
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigInclude);
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        while (this.sourceCluster().leaderLog(tp).logStartOffset() <= 100L) {
            this.produceToSourceAndWaitForMirror(10);
        }
        this.produceToSourceAndWaitForMirror(10);
        AbstractLog destLog = this.destCluster().leaderLog(tp);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"999")}))));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = destLog.config().segmentSize;
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkAsyncTaskIntegrationTest.$anonfun$testSyncTopicsConfigsTaskState$2(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var42_23 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int destSegmentSize = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)999, (int)var21_26);
        if (coordinator) {
            this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"topic-configs-sync"));
            this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("TopicConfigsSync", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()));
        } else {
            this.verifyTaskStateAndMetrics((TaskState)UnknownTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$, (Object)new Some((Object)"The cluster linking link coordinator is not enabled.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
            this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("TopicConfigsSync", ClusterLinkTaskDescription.ClusterLinkTaskState.UNKNOWN, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.LINK_COORDINATOR_NOT_ENABLED_ERROR, "The cluster linking link coordinator is not enabled."))));
        }
        String validCreds = linkProps.getProperty("sasl.jaas.config");
        String invalidCreds = this.generateInvalidCredentials(this.sourceCluster());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)invalidCreds)}));
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14, x$15, x$16);
        if (coordinator) {
            this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)AuthenticationTaskErrorCode$.MODULE$, (Object)new Some((Object)new StringBuilder(67).append("Unable to describe topic configs due to authentication issues for ").append(this.topic()).append(".").toString())), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"topic-configs-sync"));
            this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("TopicConfigsSync", ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHENTICATION_ERROR, new StringBuilder(67).append("Unable to describe topic configs due to authentication issues for ").append(this.topic()).append(".").toString()))));
        } else {
            this.verifyTaskStateAndMetrics((TaskState)UnknownTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$, (Object)new Some((Object)"The cluster linking link coordinator is not enabled.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        }
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)validCreds)}));
        Seq<KafkaBroker> x$19 = qual$4.alterClusterLink$default$3();
        Set<String> x$20 = qual$4.alterClusterLink$default$4();
        boolean x$21 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$17, (Map<String, String>)x$18, x$19, x$20, x$21);
        if (coordinator) {
            this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"topic-configs-sync"));
            return;
        }
        this.verifyTaskStateAndMetrics((TaskState)UnknownTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$, (Object)new Some((Object)"The cluster linking link coordinator is not enabled.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkSyncTopicConfigsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTaskStateForVariousClusterLinkingTasks(String quorum, boolean coordinator) {
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkCheckAvailabilityTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"check-availability"), (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)Seq$.MODULE$.empty()));
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkListOffsetsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"list-offsets"), (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)Seq$.MODULE$.empty()));
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)PeriodicPartitionSchedulerTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"periodic-partition-scheduler"), (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)Seq$.MODULE$.empty()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTopicConfigSync(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.destCluster().linkTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.topic(), this.replicationFactor(), this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<OffsetSpec>)new Some((Object)OffsetSpec.forTimestamp((long)(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L)))));
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkAsyncTaskIntegrationTest.$anonfun$testTopicConfigSync$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic configs did not get propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyTopicConfigChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAddPartitions(String quorum, boolean coordinator) {
        void var19_24;
        Tuple2 tuple2;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.numPartitions_$eq(4);
        this.sourceCluster().createPartitions(this.topic(), this.numPartitions());
        this.produceToSourceCluster(8);
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitions$1(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitions$2(this, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var26_21 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)this.numPartitions(), (int)var19_24);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAddPartitionMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAddPartitionsWithSourceLeaderEpochBump(String quorum, boolean coordinator) {
        void var18_23;
        Tuple2 tuple2;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.numPartitions_$eq(4);
        this.sourceCluster().createPartitions(this.topic(), this.numPartitions());
        this.produceToSourceCluster(8);
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitionsWithSourceLeaderEpochBump$1(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitionsWithSourceLeaderEpochBump$2(this, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var33_20 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)this.numPartitions(), (int)var18_23);
        IndexedSeq partitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitionsWithSourceLeaderEpochBump$3(this, BoxesRunTime.unboxToInt((Object)i)));
        int atLeastExpectedLeaderEpoch = 3;
        ClusterLinkAsyncTaskIntegrationTest.bumpLeaderEpochs$1(this.sourceCluster(), atLeastExpectedLeaderEpoch, partitions);
        ClusterLinkAsyncTaskIntegrationTest.verifyLeaderEpochIsBumped$1(this.sourceCluster(), partitions, atLeastExpectedLeaderEpoch);
        ClusterLinkAsyncTaskIntegrationTest.verifyLeaderEpochIsBumped$1(this.destCluster(), partitions, atLeastExpectedLeaderEpoch);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$5();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, false, x$16, x$17);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testIntervalChangeForPeriodicTasks(String quorum, boolean coordinator) {
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        linkProps.setProperty("metadata.max.age.ms", String.valueOf(300000));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, 2, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, (short)2, x$9, x$11, x$10);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkAsyncTaskIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic configs did not get propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyTopicConfigChangeMetrics();
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup(), this.verifyOffsetMigration$default$5());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$4();
        boolean x$16 = qual$3.unlinkTopic$default$5();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$14, x$15, x$16, x$17);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}))));
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}))));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$19 = this.linkName();
        boolean x$20 = qual$4.unlinkTopic$default$3();
        boolean x$21 = qual$4.unlinkTopic$default$4();
        boolean x$22 = qual$4.unlinkTopic$default$5();
        int x$23 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$18, x$19, x$20, x$21, x$22, x$23);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$24 = this.linkName();
        boolean x$25 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$26 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$24, x$25, x$26);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        String topicConfigInclude = new StringBuilder(14).append(MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",")).append(",segment.bytes").toString();
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigInclude);
        linkProps.put("metadata.max.age.ms", Long.toString(this.syncPeriod()));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        String linkNameTwo = "testLinkTwo-0";
        this.createClusterLink(linkNameTwo, linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        if (coordinator) {
            KafkaBroker linkCoordinator = this.destCluster().linkCoordinator(this.linkName());
            KafkaBroker linkCoordinatorTwo = this.destCluster().linkCoordinator(linkNameTwo);
            if (linkCoordinator.config().brokerId() == linkCoordinatorTwo.config().brokerId()) {
                this.changeCoordinator(this.destCluster(), true, linkNameTwo);
                linkCoordinatorTwo = this.destCluster().linkCoordinator(linkNameTwo);
            }
            Assertions.assertTrue((linkCoordinator.config().brokerId() != linkCoordinatorTwo.config().brokerId() ? 1 : 0) != 0);
        }
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkAsyncTaskIntegrationTest.$anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$3(this, linkNameTwo, coordinator);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var20_14 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var8_9 = null;
        Object var13_13 = null;
        long l3 = 15000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkAsyncTaskIntegrationTest.$anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$4(this, coordinator, linkNameTwo);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var21_20 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testOffsetMigrationTaskStateGoesIntoErrorWhenTheresAnExistingConsumerGroup$2(Consumer consumer$1) {
        return !consumer$1.poll(Duration.ZERO).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMigrationTaskStateGoesIntoErrorWhenTheresAnExistingConsumerGroup$3() {
        return "Failed to consume records on the destination";
    }

    public static final /* synthetic */ boolean $anonfun$testSyncTopicsConfigsTaskState$2(int x$1) {
        return (long)x$1 == 999L;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSync$1(ClusterLinkAsyncTaskIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSync$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ int $anonfun$testAddPartitions$1(ClusterLinkAsyncTaskIntegrationTest $this) {
        return $this.destCluster().describeTopic(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitions$2(ClusterLinkAsyncTaskIntegrationTest $this, int x$2) {
        return x$2 == $this.numPartitions();
    }

    public static final /* synthetic */ int $anonfun$testAddPartitionsWithSourceLeaderEpochBump$1(ClusterLinkAsyncTaskIntegrationTest $this) {
        return $this.destCluster().describeTopic(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionsWithSourceLeaderEpochBump$2(ClusterLinkAsyncTaskIntegrationTest $this, int x$3) {
        return x$3 == $this.numPartitions();
    }

    public static final /* synthetic */ TopicPartition $anonfun$testAddPartitionsWithSourceLeaderEpochBump$3(ClusterLinkAsyncTaskIntegrationTest $this, int i) {
        return new TopicPartition($this.topic(), i);
    }

    private static final void bumpLeaderEpochs$1(ClusterLinkTestHarness cluster, int atLeastExpectedLeaderEpoch$1, IndexedSeq partitions$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), atLeastExpectedLeaderEpoch$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> partitions$1.foreach((Function1 & Serializable)tp -> BoxesRunTime.boxToInteger((int)cluster.changeLeader(tp))));
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionsWithSourceLeaderEpochBump$7(ClusterLinkTestHarness cluster$2, TopicPartition p$1, int atLeastExpectedLeaderEpoch$1) {
        return cluster$2.replicaStatusWithPartitionResult(p$1.topic(), p$1.partition()).leaderEpoch().orElseGet(() -> 0) >= atLeastExpectedLeaderEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$testAddPartitionsWithSourceLeaderEpochBump$9() {
        return "Leader epoch did not get bumped";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAddPartitionsWithSourceLeaderEpochBump$6(ClusterLinkTestHarness cluster$2, int atLeastExpectedLeaderEpoch$1, TopicPartition p) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitionsWithSourceLeaderEpochBump$7(cluster$2, p, atLeastExpectedLeaderEpoch$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader epoch did not get bumped");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private static final void verifyLeaderEpochIsBumped$1(ClusterLinkTestHarness cluster, IndexedSeq partitions$1, int atLeastExpectedLeaderEpoch$1) {
        partitions$1.foreach((Function1 & Serializable)p -> {
            ClusterLinkAsyncTaskIntegrationTest.$anonfun$testAddPartitionsWithSourceLeaderEpochBump$6(cluster, atLeastExpectedLeaderEpoch$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testIntervalChangeForPeriodicTasks$1(ClusterLinkAsyncTaskIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testIntervalChangeForPeriodicTasks$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$1(ClusterLinkAsyncTaskIntegrationTest $this, ClusterLinkDescription desc) {
        return desc.linkName().equals($this.linkName());
    }

    public static final /* synthetic */ boolean $anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$2(String linkNameTwo$1, ClusterLinkDescription x$5) {
        return x$5.linkName().equals(linkNameTwo$1);
    }

    private final void runAsserts$1(Seq describeClusterLinksResponseForBothLinks, boolean coordinator$1, String linkNameTwo$1) {
        Assertions.assertEquals((int)2, (int)describeClusterLinksResponseForBothLinks.size());
        ClusterLinkDescription linkDescription = (ClusterLinkDescription)((IterableOps)describeClusterLinksResponseForBothLinks.filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAsyncTaskIntegrationTest.$anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$1(this, desc)))).head();
        Assertions.assertNotNull((Object)linkDescription);
        scala.collection.immutable.Seq linkTaskDescriptions = CollectionConverters$.MODULE$.ListHasAsScala(linkDescription.taskDescriptions()).asScala().toSeq();
        ClusterLinkTaskDescription.ClusterLinkTaskState syncConfigsTaskState = coordinator$1 ? ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE : ClusterLinkTaskDescription.ClusterLinkTaskState.UNKNOWN;
        Assertions.assertEquals((Object)new .colon.colon((Object)new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("AclSync", ClusterLinkTaskDescription.ClusterLinkTaskState.NOT_CONFIGURED, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("TopicConfigsSync", syncConfigsTaskState, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("AutoCreateMirror", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()), (List)Nil$.MODULE$)))), (Object)linkTaskDescriptions);
        ClusterLinkDescription linkTwoDescription = (ClusterLinkDescription)((IterableOps)describeClusterLinksResponseForBothLinks.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAsyncTaskIntegrationTest.$anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$2(linkNameTwo$1, x$5)))).head();
        Assertions.assertNotNull((Object)linkTwoDescription);
        scala.collection.immutable.Seq linkTwoTaskDescriptions = CollectionConverters$.MODULE$.ListHasAsScala(linkTwoDescription.taskDescriptions()).asScala().toSeq();
        Assertions.assertEquals((Object)new .colon.colon((Object)new ClusterLinkTaskDescription("ConsumerOffsetSync", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("AclSync", ClusterLinkTaskDescription.ClusterLinkTaskState.NOT_CONFIGURED, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("TopicConfigsSync", syncConfigsTaskState, Collections.emptyList()), (List)new .colon.colon((Object)new ClusterLinkTaskDescription("AutoCreateMirror", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()), (List)Nil$.MODULE$)))), (Object)linkTwoTaskDescriptions);
    }

    public static final /* synthetic */ void $anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$3(ClusterLinkAsyncTaskIntegrationTest $this, String linkNameTwo$1, boolean coordinator$1) {
        ClusterLinkTestHarness qual$1 = $this.destCluster();
        Some x$1 = new Some((Object)new .colon.colon((Object)$this.linkName(), (List)new .colon.colon((Object)linkNameTwo$1, (List)Nil$.MODULE$)));
        int x$2 = qual$1.describeClusterLinksWithTasks$default$2();
        Seq<ClusterLinkDescription> desc = qual$1.describeClusterLinksWithTasks((Option<Seq<String>>)x$1, x$2);
        $this.runAsserts$1(desc, coordinator$1, linkNameTwo$1);
    }

    public static final /* synthetic */ void $anonfun$testTaskDescriptionsForTwoLinksOnDifferentLinkCoordinators$4(ClusterLinkAsyncTaskIntegrationTest $this, boolean coordinator$1, String linkNameTwo$1) {
        ClusterLinkTestHarness qual$2 = $this.destCluster();
        None$ x$3 = None$.MODULE$;
        int x$4 = qual$2.describeClusterLinksWithTasks$default$2();
        Seq<ClusterLinkDescription> desc = qual$2.describeClusterLinksWithTasks((Option<Seq<String>>)x$3, x$4);
        $this.runAsserts$1(desc, coordinator$1, linkNameTwo$1);
    }

    public ClusterLinkAsyncTaskIntegrationTest() {
        this.offsetToCommit = 10L;
        this.syncPeriod = 100L;
        this.consumerGroup = "testGroup";
    }
}

