/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.TopicExistsTaskErrorCode$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004)\u0001\u0001\u0006IA\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u00191\u0004\u0001)A\u0005W!)q\u0007\u0001C\u0001q!)a\f\u0001C\u0001?\")Q\r\u0001C\u0001M\")A\u000e\u0001C\u0001[\")1\u000f\u0001C\u0001i\")!\u0010\u0001C\u0001w\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0003\u0001C\t\u0003_Aq!a\r\u0001\t#\t)\u0004C\u0005\u0002P\u0001\t\n\u0011\"\u0005\u0002R\tQ3\t\\;ti\u0016\u0014H*\u001b8l\u0003V$xn\u0011:fCR,W*\u001b:s_JLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u000b\u0016\u0003\u0011a\u0017N\\6\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002'%\u0011Ad\u0005\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003)\u0019\u0018P\\2QKJLw\u000eZ\u000b\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t!Aj\u001c8h\u0003-\u0019\u0018P\\2QKJLw\u000e\u001a\u0011\u0002\u0017Q|\u0007/[2GS2$XM]\u000b\u0002WA\u0011Af\r\b\u0003[E\u0002\"A\f\u0013\u000e\u0003=R!\u0001M\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011D%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a%\u00031!x\u000e]5d\r&dG/\u001a:!\u0003Q\"Xm\u001d;BkR|W*\u001b:s_JLgn\u001a+bg.\u001cF/\u0019;f\u001b\u0006t\u0017mZ3nK:$h+\u0019:j_V\u001c8kY3oCJLwn\u001d\u000b\u0004sqr\u0004CA\u0012;\u0013\tYDE\u0001\u0003V]&$\b\"B\u001f\u0007\u0001\u0004Y\u0013AB9v_J,X\u000eC\u0003@\r\u0001\u0007\u0001)A\u0006d_>\u0014H-\u001b8bi>\u0014\bCA\u0012B\u0013\t\u0011EEA\u0004C_>dW-\u00198)\t\u0019!\u0005+\u0015\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000ba\u0001]1sC6\u001c(BA%K\u0003\u001dQW\u000f]5uKJT!a\u0013'\u0002\u000b),h.\u001b;\u000b\u00035\u000b1a\u001c:h\u0013\tyeIA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n!+\u0001\u0015|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|aut3m\\8sI&t\u0017\r^8s{m\fT\u0010\u000b\u0003\u0007)j[\u0006CA+Y\u001b\u00051&BA,G\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA-W\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005a\u0016%A/\u0002\u001f\u0005dGnQ8nE&t\u0017\r^5p]N\f\u0011\u0003^3ti\u0006+Ho\\'jeJ|'/\u001b8h)\rI\u0004-\u0019\u0005\u0006{\u001d\u0001\ra\u000b\u0005\u0006\u007f\u001d\u0001\r\u0001\u0011\u0015\u0005\u000f\u0011\u0003\u0016\u000b\u000b\u0003\b)j#G&\u0001/\u0002UQ,7\u000f^!vi>l\u0015N\u001d:pe&twMT8Pm\u0016\u0014H.\u00199qS:<Gk\u001c9jG\u001aKG\u000e^3sgR\u0019\u0011h\u001a5\t\u000buB\u0001\u0019A\u0016\t\u000b}B\u0001\u0019\u0001!)\t!!\u0005+\u0015\u0015\u0005\u0011QS6\u000eL\u0001]\u0003\u001d\"Xm\u001d;BkR|W*\u001b:s_JLgnZ!mY><8\u000fT5oW\u000e{gNZ5h+B$\u0017\r^3\u0015\u0007erw\u000eC\u0003>\u0013\u0001\u00071\u0006C\u0003@\u0013\u0001\u0007\u0001\t\u000b\u0003\n\tB\u000b\u0006\u0006B\u0005U5Jd\u0013\u0001X\u0001'i\u0016\u001cH/Q;u_6K'O]8sS:<\u0017\t\u001a3j]\u001e\fE\rZ5uS>t\u0017\r\u001c+pa&\u001cGcA\u001dvm\")QH\u0003a\u0001W!)qH\u0003a\u0001\u0001\"\"!\u0002\u0012)RQ\u0011QAKW=-\u0003q\u000b\u0001\u0005^3ti\u0006+Ho\\'jeJ|'/\u001b8h\u001d>,\u00050[:uS:<Gk\u001c9jGR\u0019\u0011\b`?\t\u000buZ\u0001\u0019A\u0016\t\u000b}Z\u0001\u0019\u0001!)\t-!\u0005+\u0015\u0015\u0006\u0017QS\u0016\u0011\u0001\u0017\u00029\u0006aB/Z:u\t\u0016dW\r^3BkR|W*\u001b:s_J,G\rV8qS\u000e\u001cH#B\u001d\u0002\b\u0005%\u0001\"B\u001f\r\u0001\u0004Y\u0003\"B \r\u0001\u0004\u0001\u0005\u0006\u0002\u0007E!FCS\u0001\u0004+[\u0003\u001fa\u0013\u0001X\u00018i\u0016\u001cH\u000fT5oW\u0012{Wm\u001d(pi\u001a\u000b\u0017\u000e\\!gi\u0016\u00148\t\\;ti\u0016\u0014(+Z:uCJ$x+\u001b;i\u0003V$x.T5se>\u0014\u0018N\\4\u0015\u000be\n)\"a\u0006\t\u000buj\u0001\u0019A\u0016\t\u000b}j\u0001\u0019\u0001!)\t5!\u0005+\u0015\u0015\u0006\u001bQS\u0016Q\u0004\u0017\u00029\u0006\u0019C/Z:u\u0003V$x.T5se>\u0014\u0018N\\4Va\u0012\fG/Z#ySN$\u0018N\\4MS:\\G#B\u001d\u0002$\u0005\u0015\u0002\"B\u001f\u000f\u0001\u0004Y\u0003\"B \u000f\u0001\u0004\u0001\u0005\u0006\u0002\bE!FCSA\u0004+[\u0003Wa\u0013\u0001X\u0001\u0010CV$x.T5se>\u0014Hk\u001c9jGR\u0019\u0011(!\r\t\u000b\u0001z\u0001\u0019\u0001\u0012\u0002;\u0011,7\u000f\u001e'j].\u0004&o\u001c9t\r>\u0014\u0018)\u001e;p\u001b&\u0014(o\u001c:j]\u001e$b!a\u000e\u0002H\u0005-\u0003\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005kRLGN\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004\u0002JA\u0001\raK\u0001\ri>\u0004\u0018n\u0019$jYR,'o\u001d\u0005\t\u0003\u001b\u0002\u0002\u0013!a\u0001\u0001\u0006\u00192m\u001c8gS\u001e,(/\u001a'j].\u0004&/\u001a4jq\u00069C-Z:u\u0019&t7\u000e\u0015:paN4uN]!vi>l\u0015N\u001d:pe&tw\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019FK\u0002A\u0003+Z#!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C\"\u0013AC1o]>$\u0018\r^5p]&!\u0011QMA.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0007\u0001\u0005%$,!\u001e\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001cI\u0003\r\t\u0007/[\u0005\u0005\u0003g\niGA\u0002UC\u001e\f#!a\u001e\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkAutoCreateMirrorIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long syncPeriod;
    private final String topicFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"").append(this.topic()).append("\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |").toString()));

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String topicFilter() {
        return this.topicFilter;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringTaskStateManagementVariousScenarios(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        scala.collection.mutable.Map autoMirrorOverrides = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorOverrides.put((Object)"metadata.max.age.ms", (Object)Long.toString(this.syncPeriod()));
        Properties linkProps = this.destLinkProps((Map<String, String>)autoMirrorOverrides);
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), Long.toString(this.syncPeriod() * 10L));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "6000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1000");
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)MisconfigurationTaskErrorCode$.MODULE$, (Object)new Some((Object)"auto.create.mirror.topics.enable is true but no topic filters are specified. No topics will be mirrored.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"auto-create-mirror"));
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("AutoCreateMirror", ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR, Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.MISCONFIGURATION_ERROR, "auto.create.mirror.topics.enable is true but no topic filters are specified. No topics will be mirrored."))));
        Map updatedPropsWithFilters = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        Set<String> x$10 = qual$2.alterClusterLink$default$4();
        boolean x$11 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$7, (Map<String, String>)updatedPropsWithFilters, x$9, x$10, x$11);
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        this.verifyTaskInformationFromDescribeClusterLinks(this.linkName(), new ClusterLinkTaskDescription("AutoCreateMirror", ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE, Collections.emptyList()));
        this.waitForAutoMirrorCreation(this.topic());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAutoMirroringSuccessMetric();
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        String topicTwo = "topic-two";
        ClusterLinkTestHarness qual$3 = this.destCluster();
        int x$13 = this.numPartitions();
        short x$14 = this.replicationFactor();
        Properties x$15 = qual$3.createTopic$default$4();
        ListenerName x$16 = qual$3.createTopic$default$5();
        Properties x$17 = qual$3.createTopic$default$6();
        qual$3.createTopic(topicTwo, x$13, x$14, x$15, x$16, x$17);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        int x$19 = this.numPartitions();
        short x$20 = this.replicationFactor();
        Properties x$21 = qual$4.createTopic$default$4();
        ListenerName x$22 = qual$4.createTopic$default$5();
        Properties x$23 = qual$4.createTopic$default$6();
        qual$4.createTopic(topicTwo, x$19, x$20, x$21, x$22, x$23);
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)TopicExistsTaskErrorCode$.MODULE$, (Object)new Some((Object)"Topic topic-two already exists on destination cluster. Will not mirror source topic.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"auto-create-mirror"));
        this.destCluster().deleteTopic(topicTwo, false);
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$);
        String validCreds = linkProps.getProperty("sasl.jaas.config");
        String invalidCreds = this.generateInvalidCredentials(this.sourceCluster());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$24 = this.linkName();
        Map x$25 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)invalidCreds)}));
        Seq<KafkaBroker> x$26 = qual$5.alterClusterLink$default$3();
        Set<String> x$27 = qual$5.alterClusterLink$default$4();
        boolean x$28 = qual$5.alterClusterLink$default$5();
        qual$5.alterClusterLink(x$24, (Map<String, String>)x$25, x$26, x$27, x$28);
        this.verifyTaskStateAndMetrics((TaskState)InErrorTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)AuthenticationTaskErrorCode$.MODULE$, (Object)new Some((Object)"Unable to list topics on the source cluster due to authentication issues.")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"auto-create-mirror"));
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$29 = this.linkName();
        Map x$30 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)validCreds)}));
        Seq<KafkaBroker> x$31 = qual$6.alterClusterLink$default$3();
        Set<String> x$32 = qual$6.alterClusterLink$default$4();
        boolean x$33 = qual$6.alterClusterLink$default$5();
        qual$6.alterClusterLink(x$29, (Map<String, String>)x$30, x$31, x$32, x$33);
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkAutoMirroringTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"auto-create-mirror"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroring(String quorum, boolean coordinator) {
        this.autoMirrorTopic(this.syncPeriod());
        String newTopic = new StringBuilder(2).append(this.topic()).append("-2").toString();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
        Set<String> x$4 = qual$1.alterClusterLink$default$4();
        boolean x$5 = qual$1.alterClusterLink$default$5();
        qual$1.alterClusterLink(x$1, (Map<String, String>)x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$6 = String.valueOf(newTopic);
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$2.createTopic$default$4();
        ListenerName x$10 = qual$2.createTopic$default$5();
        Properties x$11 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10, x$11);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString());
        Thread.sleep(this.syncPeriod() * 5L);
        Assertions.assertEquals((double)0.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-create-failed-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-created-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        String excludeTopicFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(newTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString()));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter)}));
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14, x$15, x$16);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString(), true);
        Thread.sleep(1000L);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$17 = qual$4.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$4.listMirrorTopics(x$17).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString()));
        String conflictingTopic = new StringBuilder(9).append(this.topic()).append("-conflict").toString();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$18 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        int x$19 = this.numPartitions();
        short x$20 = this.replicationFactor();
        Properties x$21 = qual$5.createTopic$default$4();
        ListenerName x$22 = qual$5.createTopic$default$5();
        Properties x$23 = qual$5.createTopic$default$6();
        qual$5.createTopic(x$18, x$19, x$20, x$21, x$22, x$23);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        int x$25 = this.numPartitions();
        short x$26 = this.replicationFactor();
        Properties x$27 = qual$6.createTopic$default$4();
        ListenerName x$28 = qual$6.createTopic$default$5();
        Properties x$29 = qual$6.createTopic$default$6();
        qual$6.createTopic(conflictingTopic, x$25, x$26, x$27, x$28, x$29);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$30 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        String x$31 = this.linkName();
        boolean x$33 = qual$7.unlinkTopic$default$4();
        boolean x$34 = qual$7.unlinkTopic$default$5();
        int x$35 = qual$7.unlinkTopic$default$6();
        qual$7.unlinkTopic(x$30, x$31, false, x$33, x$34, x$35);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$36 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$37 = this.linkName();
        boolean x$38 = qual$8.unlinkTopic$default$3();
        boolean x$39 = qual$8.unlinkTopic$default$4();
        boolean x$40 = qual$8.unlinkTopic$default$5();
        int x$41 = qual$8.unlinkTopic$default$6();
        qual$8.unlinkTopic(x$36, x$37, x$38, x$39, x$40, x$41);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$42 = this.linkName();
        boolean x$43 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$44 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$42, x$43, x$44);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringNoOverlappingTopicFilters(String quorum, boolean coordinator) {
        String topicTwo = "linkedTopicTwo";
        String multipleOverlappingTopicFilters = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(335).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |    \"name\": \"").append(topicTwo).append("\",\n          |    \"patternType\": \"literal\",\n          |    \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        Properties linkProps = this.destLinkPropsForAutoMirroring(multipleOverlappingTopicFilters, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        Properties linkPropsTwo = this.destLinkPropsForAutoMirroring(this.includeAllTopicsFilter(), this.destLinkPropsForAutoMirroring$default$2());
        Uuid linkIdTwo = this.createClusterLink(linkNameTwo, linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        InvalidConfigurationException exceptionTwo = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
            Set<String> x$4 = qual$1.alterClusterLink$default$4();
            boolean x$5 = qual$1.alterClusterLink$default$5();
            qual$1.alterClusterLink(linkNameTwo, (Map<String, String>)x$2, x$3, x$4, x$5);
        });
        Assertions.assertEquals((Object)"Found overlapping topic filter(s): new topic filter linkedTopic overlaps with existing topic filter from cluster link testLink.", (Object)exceptionTwo.getMessage());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        boolean x$7 = qual$2.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$8 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$6, x$7, x$8);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$3 = this.sourceCluster();
            String x$9 = this.linkName();
            boolean x$10 = qual$3.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$11 = qual$3.deleteClusterLink$default$3();
            qual$3.deleteClusterLink(x$9, x$10, x$11);
            if (!this.useBidirectionalLink()) {
                ClusterLinkTestHarness qual$4 = this.sourceCluster();
                boolean x$12 = qual$4.listClusterLinks$default$1();
                Option<String> x$13 = qual$4.listClusterLinks$default$2();
                Assertions.assertEquals((int)1, (int)qual$4.listClusterLinks(x$12, x$13).size());
                ClusterLinkTestHarness qual$5 = this.sourceCluster();
                boolean x$14 = qual$5.describeClusterLinks$default$1();
                Option<String> x$15 = qual$5.describeClusterLinks$default$2();
                int x$16 = qual$5.describeClusterLinks$default$3();
                boolean x$17 = qual$5.describeClusterLinks$default$4();
                Assertions.assertEquals((int)1, (int)qual$5.describeClusterLinks(x$14, x$15, x$16, x$17).size());
            }
        }
        ClusterLinkTestHarness qual$6 = this.destCluster();
        Map x$19 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$20 = qual$6.alterClusterLink$default$3();
        Set<String> x$21 = qual$6.alterClusterLink$default$4();
        boolean x$22 = qual$6.alterClusterLink$default$5();
        qual$6.alterClusterLink(linkNameTwo, (Map<String, String>)x$19, x$20, x$21, x$22);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        Map x$24 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$25 = qual$7.alterClusterLink$default$3();
        Set<String> x$26 = qual$7.alterClusterLink$default$4();
        boolean x$27 = qual$7.alterClusterLink$default$5();
        qual$7.alterClusterLink(linkNameTwo, (Map<String, String>)x$24, x$25, x$26, x$27);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.createClusterLink(this.linkName(), linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Map x$29 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$30 = qual$8.alterClusterLink$default$3();
        Set<String> x$31 = qual$8.alterClusterLink$default$4();
        boolean x$32 = qual$8.alterClusterLink$default$5();
        qual$8.alterClusterLink(linkNameTwo, (Map<String, String>)x$29, x$30, x$31, x$32);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$33 = this.linkName();
        boolean x$34 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$35 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$33, x$34, x$35);
        ClusterLinkTestHarness qual$10 = this.destCluster();
        boolean x$37 = qual$10.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$38 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(linkNameTwo, x$37, x$38);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringAllowsLinkConfigUpdate(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkPropsOne = this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkPropsOne, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForAutoMirrorCreation(this.topic());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        Map x$8 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}));
        Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        Set<String> x$10 = qual$2.alterClusterLink$default$4();
        boolean x$11 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$7, (Map<String, String>)x$8, x$9, x$10, x$11);
        String topicTwo = "linkedTopicTwo";
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        int x$13 = this.numPartitions();
        short x$14 = this.replicationFactor();
        Properties x$15 = qual$3.createTopic$default$4();
        ListenerName x$16 = qual$3.createTopic$default$5();
        Properties x$17 = qual$3.createTopic$default$6();
        qual$3.createTopic(topicTwo, x$13, x$14, x$15, x$16, x$17);
        this.produceToSourceCluster(numRecords);
        ObjectRef linkPropsTwo = ObjectRef.create((Object)this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2()));
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo$1.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        String topicFilterTwo = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        linkPropsTwo.elem = this.destLinkPropsForAutoMirroring(topicFilterTwo, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForAutoMirrorCreation(this.topic());
        this.waitForAutoMirrorCreation(topicTwo);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        Seq<KafkaBroker> x$20 = qual$4.alterClusterLink$default$3();
        Set<String> x$21 = qual$4.alterClusterLink$default$4();
        boolean x$22 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$18, (Map<String, String>)x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = this.topic();
        String x$24 = this.linkName();
        boolean x$26 = qual$5.unlinkTopic$default$3();
        boolean x$27 = qual$5.unlinkTopic$default$5();
        int x$28 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$23, x$24, x$26, false, x$27, x$28);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$32 = qual$6.unlinkTopic$default$3();
        boolean x$33 = qual$6.unlinkTopic$default$5();
        int x$34 = qual$6.unlinkTopic$default$6();
        qual$6.unlinkTopic(topicTwo, linkNameTwo, x$32, false, x$33, x$34);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$35 = this.linkName();
        Seq<KafkaBroker> x$37 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$35, true, x$37);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Seq<KafkaBroker> x$40 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(linkNameTwo, true, x$40);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringAddingAdditionalTopic(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String topicTwo = "linkedTopic2";
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topicTwo, x$8, x$9, x$10, x$11, x$12);
        String topicFilterTwo = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.linkName();
        Map x$14 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilterTwo)}));
        Seq<KafkaBroker> x$15 = qual$3.alterClusterLink$default$3();
        Set<String> x$16 = qual$3.alterClusterLink$default$4();
        boolean x$17 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$13, (Map<String, String>)x$14, x$15, x$16, x$17);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$19 = this.linkName();
        boolean x$22 = qual$4.unlinkTopic$default$5();
        int x$23 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$18, x$19, false, false, x$22, x$23);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$24 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString();
        String x$25 = this.linkName();
        boolean x$27 = qual$5.unlinkTopic$default$3();
        boolean x$28 = qual$5.unlinkTopic$default$5();
        int x$29 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$24, x$25, x$27, false, x$28, x$29);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$30 = this.linkName();
        Seq<KafkaBroker> x$32 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$30, true, x$32);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringNoExistingTopic(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$2 = qual$1.createTopic$default$2();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$7 = this.linkName();
            Map x$8 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
            Set<String> x$10 = qual$2.alterClusterLink$default$4();
            boolean x$11 = qual$2.alterClusterLink$default$5();
            qual$2.alterClusterLink(x$7, (Map<String, String>)x$8, x$9, x$10, x$11);
        });
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14, x$15, x$16);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$19 = qual$4.alterClusterLink$default$3();
        Set<String> x$20 = qual$4.alterClusterLink$default$4();
        boolean x$21 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$17, (Map<String, String>)x$18, x$19, x$20, x$21);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parseTopic(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.linkName();
        boolean x$23 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$24 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$22, x$23, x$24);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDeleteAutoMirroredTopics(String quorum, boolean coordinator) {
        this.autoMirrorTopic(this.syncPeriod());
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$1.listMirrorTopics(x$1).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$2 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$3 = this.linkName();
        boolean x$4 = qual$2.unlinkTopic$default$3();
        boolean x$5 = qual$2.unlinkTopic$default$4();
        boolean x$6 = qual$2.unlinkTopic$default$5();
        int x$7 = qual$2.unlinkTopic$default$6();
        qual$2.unlinkTopic(x$2, x$3, x$4, x$5, x$6, x$7);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.FAILED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.numPartitions());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$8 = this.topic();
        int x$9 = this.numPartitions();
        short x$10 = this.replicationFactor();
        Properties x$11 = qual$3.createTopic$default$4();
        ListenerName x$12 = qual$3.createTopic$default$5();
        Properties x$13 = qual$3.createTopic$default$6();
        qual$3.createTopic(x$8, x$9, x$10, x$11, x$12, x$13);
        this.produceToSourceCluster(20);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String excludeTopicFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString()));
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.linkName();
        Seq<KafkaBroker> x$16 = qual$4.alterClusterLink$default$3();
        Set<String> x$17 = qual$4.alterClusterLink$default$4();
        boolean x$18 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$14, (Map<String, String>)updatedProps, x$16, x$17, x$18);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        boolean x$19 = qual$5.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$5.listMirrorTopics(x$19).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$20 = this.linkName();
        boolean x$21 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$22 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$20, x$21, x$22);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLinkDoesNotFailAfterClusterRestartWithAutoMirroring(String quorum, boolean coordinator) {
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.destCluster().killAllBrokers();
        this.restartCluster(this.destCluster(), false).get();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Some x$1 = new Some((Object)this.linkName());
        boolean x$2 = qual$1.describeClusterLinks$default$1();
        int x$3 = qual$1.describeClusterLinks$default$3();
        boolean x$4 = qual$1.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> linkDescription = qual$1.describeClusterLinks(x$2, (Option<String>)x$1, x$3, x$4);
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.ACTIVE, (Object)((ClusterLinkDescription)linkDescription.head()).linkState());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringUpdateExistingLink(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)Long.toString(this.syncPeriod()))}))));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$7, x$8, x$9, x$10, x$11, x$12);
        scala.collection.mutable.Map autoMirrorProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)this.topicFilter());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$13 = this.linkName();
            Seq<KafkaBroker> x$15 = qual$3.alterClusterLink$default$3();
            Set<String> x$16 = qual$3.alterClusterLink$default$4();
            boolean x$17 = qual$3.alterClusterLink$default$5();
            qual$3.alterClusterLink(x$13, (Map<String, String>)autoMirrorProps, x$15, x$16, x$17);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.linkName();
        Seq<KafkaBroker> x$20 = qual$4.alterClusterLink$default$3();
        Set<String> x$21 = qual$4.alterClusterLink$default$4();
        boolean x$22 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$18, (Map<String, String>)autoMirrorProps, x$20, x$21, x$22);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$24 = this.linkName();
        boolean x$26 = qual$5.unlinkTopic$default$3();
        boolean x$27 = qual$5.unlinkTopic$default$5();
        int x$28 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$23, x$24, x$26, false, x$27, x$28);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$29 = this.linkName();
        boolean x$30 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$31 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$29, x$30, x$31);
    }

    public void autoMirrorTopic(long syncPeriod) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), Long.toString(syncPeriod * 10L));
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAutoMirroringSuccessMetric();
    }

    public Properties destLinkPropsForAutoMirroring(String topicFilters, boolean configureLinkPrefix) {
        scala.collection.mutable.Map autoMirrorOverrides = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)topicFilters);
        autoMirrorOverrides.put((Object)"metadata.max.age.ms", (Object)Long.toString(this.syncPeriod()));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())) && configureLinkPrefix) {
            autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), (Object)this.clusterLinkPrefix());
        }
        return this.destLinkProps((Map<String, String>)autoMirrorOverrides);
    }

    public boolean destLinkPropsForAutoMirroring$default$2() {
        return false;
    }

    public ClusterLinkAutoCreateMirrorIntegrationTest() {
        this.syncPeriod = 100L;
    }
}

