/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkPauseMirrorTopicsTaskType$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:3")})
@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAqA\u0007\u0001C\u0002\u0013\u00051\u0004\u0003\u0004%\u0001\u0001\u0006I\u0001\b\u0005\bK\u0001\u0011\r\u0011\"\u0001\u001c\u0011\u00191\u0003\u0001)A\u00059!)q\u0005\u0001C\u0001Q!)1\f\u0001C\u00019\")!\r\u0001C\u0001G\")\u0011\u000e\u0001C\u0001U\")!\u000f\u0001C\u0001g\")\u0011\u0010\u0001C\u0001u\nA4\t\\;ti\u0016\u0014H*\u001b8l\u0007>tGO]8m!2\fg.\u001a'j].\u001cuN\u001c4jOJ+7o\\;sG\u0016Le\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\b\u0010\u0003\u0011a\u0017N\\6\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u001b%\u0011a#\u0004\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u00035\u0019wN\\:v[\u0016\u0014xI]8vaV\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\rM#(/\u001b8h\u00039\u0019wN\\:v[\u0016\u0014xI]8va\u0002\n\u0001&\u001a=qK\u000e$X\r\u001a)bkN,W*\u001b:s_J$v\u000e]5dg\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\f\u0011&\u001a=qK\u000e$X\r\u001a)bkN,W*\u001b:s_J$v\u000e]5dg\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001\u0006;fgR\u0004\u0016-^:f\u00072,8\u000f^3s\u0019&t7\u000eF\u0002*_m\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012A!\u00168ji\")\u0001G\u0002a\u0001c\u00051\u0011/^8sk6\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b,\u001b\u0005)$B\u0001\u001c\u0012\u0003\u0019a$o\\8u}%\u0011\u0001hK\u0001\u0007!J,G-\u001a4\n\u0005\rR$B\u0001\u001d,\u0011\u0015ad\u00011\u0001>\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\u0005)r\u0014BA ,\u0005\u001d\u0011un\u001c7fC:DCAB!N\u001dB\u0011!iS\u0007\u0002\u0007*\u0011A)R\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005\u0019;\u0015a\u00026va&$XM\u001d\u0006\u0003\u0011&\u000bQA[;oSRT\u0011AS\u0001\u0004_J<\u0017B\u0001'D\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001P\u0003!ZH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b' \u0018d_>\u0014H-\u001b8bi>\u0014Xh_\u0019~Q\u00111\u0011k\u0016-\u0011\u0005I+V\"A*\u000b\u0005Q\u001b\u0015\u0001\u00039s_ZLG-\u001a:\n\u0005Y\u001b&\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A-\"\u0003i\u000bq\"\u00197m\u0007>l'-\u001b8bi&|gn]\u0001\u0017i\u0016\u001cHo\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR\u0019\u0011&\u00180\t\u000bA:\u0001\u0019A\u0019\t\u000bq:\u0001\u0019A\u001f)\t\u001d\tUJ\u0014\u0015\u0005\u000fE;\u0016\rL\u0001Z\u0003m!Xm\u001d;BYR,'o\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR\u0019\u0011\u0006Z3\t\u000bAB\u0001\u0019A\u0019\t\u000bqB\u0001\u0019A\u001f)\t!\tUJ\u0014\u0015\u0005\u0011E;\u0006\u000eL\u0001Z\u0003\u0019\"Xm\u001d;BYR,'o\u00117vgR,'\u000fT5oW^KG\u000f[%om\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\u000b\u0004S-d\u0007\"\u0002\u0019\n\u0001\u0004\t\u0004\"\u0002\u001f\n\u0001\u0004i\u0004\u0006B\u0005B\u001b:CC!C)X_2\n\u0001/I\u0001r\u00039Q8nQ8nE&t\u0017\r^5p]N\fa\u0004^3ti\u0016CH/\u001a:oC2L'0\u001a3QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\u0007%\"X\u000fC\u00031\u0015\u0001\u0007\u0011\u0007C\u0003=\u0015\u0001\u0007Q\b\u000b\u0003\u000b\u00036s\u0005\u0006\u0002\u0006R/bd\u0013!W\u0001%i\u0016\u001cHo\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006$v\u000e]5d\u0007J,\u0017\r^5p]R\u0019\u0011f\u001f?\t\u000bAZ\u0001\u0019A\u0019\t\u000bqZ\u0001\u0019A\u001f)\t-\tUJ\u0014\u0015\u0005\u0017E;v\u0010L\u0001ZQ\u0019\u0001\u00111A,\u0002\u0010A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0015\u000b1!\u00199j\u0013\u0011\ti!a\u0002\u0003\u0007Q\u000bw-\t\u0002\u0002\u0012\u0005Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001\u00111A,\u0002\u0016\u0005\u0012\u0011qC\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(h\r")
public class ClusterLinkControlPlaneLinkConfigResourceIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final String consumerGroup;
    private final String expectedPauseMirrorTopicsCountMetricName;

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public String expectedPauseMirrorTopicsCountMetricName() {
        return this.expectedPauseMirrorTopicsCountMetricName;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testPauseClusterLink(String quorum, boolean coordinator) {
        void var41_68;
        Tuple2 tuple2;
        void var39_62;
        Tuple2 tuple22;
        int oldNumPartitions = this.numPartitions();
        String oldDeleteRetentionMs = "10000";
        int oldOffset = 10;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, oldNumPartitions, x$3, x$4, x$5, x$6);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)oldDeleteRetentionMs)}))));
        Map availabilityMsProps = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp()), (Object)"100")}));
        Properties linkProps = this.destLinkProps((Map<String, String>)availabilityMsProps);
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty("metadata.max.age.ms", "100");
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map<String, String>)availabilityMsProps), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, oldOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.verifyConsumerOffsetMigrationMetrics();
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkPauseMirrorTopicsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)this.expectedPauseMirrorTopicsCountMetricName()));
        this.waitForRemoteLinkStateOnActiveLink(this.linkName());
        JFunction1.mcZD.sp & Serializable waitForConnectionMetric$1_predicate = (JFunction1.mcZD.sp & Serializable)x$1 -> x$1 > 0.0;
        MetricName waitForConnectionMetric$1_activeClientConnectionMetricName = ClusterLinkMetrics$.MODULE$.activeClientConnectionsCountMetricName();
        String waitForConnectionMetric$1_x$1 = waitForConnectionMetric$1_activeClientConnectionMetricName.name();
        String waitForConnectionMetric$1_x$2 = waitForConnectionMetric$1_activeClientConnectionMetricName.group();
        None$ waitForConnectionMetric$1_x$3 = None$.MODULE$;
        Map<String, String> waitForConnectionMetric$1_x$5 = this.waitForKafkaMetric$default$4();
        Seq<KafkaBroker> waitForConnectionMetric$1_x$6 = this.waitForKafkaMetric$default$5();
        boolean waitForConnectionMetric$1_x$7 = this.waitForKafkaMetric$default$6();
        boolean waitForConnectionMetric$1_x$8 = this.waitForKafkaMetric$default$7();
        this.waitForKafkaMetric(waitForConnectionMetric$1_x$1, waitForConnectionMetric$1_x$2, (Option<String>)waitForConnectionMetric$1_x$3, waitForConnectionMetric$1_x$5, waitForConnectionMetric$1_x$6, waitForConnectionMetric$1_x$7, waitForConnectionMetric$1_x$8, (Function1<Object, Object>)waitForConnectionMetric$1_predicate);
        Object var53_21 = null;
        Object var54_22 = null;
        Object var55_23 = null;
        Object var56_24 = null;
        Object var57_25 = null;
        Object var58_26 = null;
        Object var59_27 = null;
        Map pauseProps = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$122 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        Set<String> x$15 = qual$3.alterClusterLink$default$4();
        boolean x$16 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$122, (Map<String, String>)pauseProps, x$14, x$15, x$16);
        if (this.useSourceInitiatedLink()) {
            this.sourceCluster().waitForRemoteLinkState(this.linkName(), ClusterLinkDescription.LinkState.PAUSED, ClusterLinkError.NO_ERROR);
            ClusterLinkTestHarness qual$4 = this.sourceCluster();
            String x$17 = this.linkName();
            Seq<KafkaBroker> x$19 = qual$4.alterClusterLink$default$3();
            Set<String> x$20 = qual$4.alterClusterLink$default$4();
            boolean x$21 = qual$4.alterClusterLink$default$5();
            qual$4.alterClusterLink(x$17, (Map<String, String>)pauseProps, x$19, x$20, x$21);
        }
        JFunction1.mcZD.sp & Serializable waitForConnectionMetric$1_predicate2 = (JFunction1.mcZD.sp & Serializable)x$2 -> x$2 == 0.0;
        MetricName waitForConnectionMetric$1_activeClientConnectionMetricName2 = ClusterLinkMetrics$.MODULE$.activeClientConnectionsCountMetricName();
        String waitForConnectionMetric$1_x$12 = waitForConnectionMetric$1_activeClientConnectionMetricName2.name();
        String waitForConnectionMetric$1_x$22 = waitForConnectionMetric$1_activeClientConnectionMetricName2.group();
        None$ waitForConnectionMetric$1_x$32 = None$.MODULE$;
        Map<String, String> waitForConnectionMetric$1_x$52 = this.waitForKafkaMetric$default$4();
        Seq<KafkaBroker> waitForConnectionMetric$1_x$62 = this.waitForKafkaMetric$default$5();
        boolean waitForConnectionMetric$1_x$72 = this.waitForKafkaMetric$default$6();
        boolean waitForConnectionMetric$1_x$82 = this.waitForKafkaMetric$default$7();
        this.waitForKafkaMetric(waitForConnectionMetric$1_x$12, waitForConnectionMetric$1_x$22, (Option<String>)waitForConnectionMetric$1_x$32, waitForConnectionMetric$1_x$52, waitForConnectionMetric$1_x$62, waitForConnectionMetric$1_x$72, waitForConnectionMetric$1_x$82, (Function1<Object, Object>)waitForConnectionMetric$1_predicate2);
        Object var62_41 = null;
        Object var63_42 = null;
        Object var64_43 = null;
        Object var65_44 = null;
        Object var66_45 = null;
        Object var67_46 = null;
        Object var68_47 = null;
        int newNumPartitions = oldNumPartitions + 2;
        String newDeleteRetentionMs = "20000";
        int newOffset = 20;
        this.sourceCluster().createPartitions(this.topic(), newNumPartitions);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)newDeleteRetentionMs)}))));
        this.produceToSourceCluster(8);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyPausedLinkMetrics();
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), this.numPartitions());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.PAUSED, ClusterLinkDescription.LinkState.PAUSED);
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkPauseMirrorTopicsTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)this.expectedPauseMirrorTopicsCountMetricName()));
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.topic();
        boolean x$23 = qual$5.pauseTopic$default$2();
        qual$5.pauseTopic(x$22, x$23);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), this.numPartitions());
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), this.numPartitions());
        Assertions.assertThrows(ClusterLinkPausedException.class, () -> {
            ClusterLinkTestHarness qual$6 = this.destCluster();
            short x$25 = this.replicationFactor();
            String x$26 = this.linkName();
            Map<String, String> x$27 = qual$6.linkTopic$default$4();
            String x$28 = qual$6.linkTopic$default$5();
            qual$6.linkTopic("paused-topic", x$25, x$26, x$27, x$28);
        });
        Thread.sleep(250L);
        Assertions.assertEquals((int)oldNumPartitions, (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Assertions.assertEquals((Object)oldDeleteRetentionMs, (Object)this.destCluster().describeTopicConfig(this.topic()).get("delete.retention.ms").value());
        Assertions.assertEquals((long)oldOffset, (long)this.destCluster().getOffset(this.topic(), 0, this.consumerGroup()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.topic(), this.numPartitions());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long computeUntilTrue_waitTime = TestUtils$.MODULE$.computeUntilTrue$default$2();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testPauseClusterLink$6(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testPauseClusterLink$7(newNumPartitions, n)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var77_59 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple23._1$mcI$sp();
        Assertions.assertEquals((int)newNumPartitions, (int)var39_62);
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long computeUntilTrue_waitTime2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            String computeUntilTrue_result;
            if (ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testPauseClusterLink$9(newDeleteRetentionMs, computeUntilTrue_result = ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testPauseClusterLink$8(this))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var84_66 = null;
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        String destDeleteRetentionMs = (String)tuple24._1();
        Assertions.assertEquals((Object)newDeleteRetentionMs, (Object)var41_68);
        this.verifyOffsetMigration(this.topic(), 0, newOffset, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$29 = this.topic();
        String x$30 = this.linkName();
        boolean x$31 = qual$7.unlinkTopic$default$3();
        boolean x$32 = qual$7.unlinkTopic$default$4();
        boolean x$33 = qual$7.unlinkTopic$default$5();
        int x$34 = qual$7.unlinkTopic$default$6();
        qual$7.unlinkTopic(x$29, x$30, x$31, x$32, x$33, x$34);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$35 = this.linkName();
        boolean x$36 = qual$8.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$37 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$35, x$36, x$37);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkConfigs(String quorum, boolean coordinator) {
        void var35_40;
        Tuple2 tuple2;
        this.numPartitions_$eq(8);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Uuid linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.sourceLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness connectingCluster = super.connectingCluster();
        Config currConfig = connectingCluster.describeClusterLink(this.linkName());
        Assertions.assertFalse((boolean)currConfig.get("metadata.max.age.ms").isDefault());
        Assertions.assertFalse((boolean)currConfig.get("bootstrap.servers").isDefault());
        Assertions.assertTrue((boolean)currConfig.get(ClusterLinkConfig$.MODULE$.AclSyncMsProp()).isDefault());
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncMsProp()), (Object)"5000")}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5());
        currConfig = connectingCluster.describeClusterLink(this.linkName());
        Assertions.assertFalse((boolean)currConfig.get(ClusterLinkConfig$.MODULE$.AclSyncMsProp()).isDefault());
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncMsProp()), (Object)"5001")}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5());
        currConfig = connectingCluster.describeClusterLink(this.linkName());
        Assertions.assertFalse((boolean)currConfig.get(ClusterLinkConfig$.MODULE$.AclSyncMsProp()).isDefault());
        ClusterLinkTestHarness otherCluster = connectingCluster.equals(this.destCluster()) ? this.sourceCluster() : this.destCluster();
        String metadataMaxAge = "60000";
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)metadataMaxAge)}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertEquals((Object)metadataMaxAge, (Object)connectingCluster.describeClusterLink(this.linkName()).get("metadata.max.age.ms").value());
        otherCluster.killAllBrokers();
        otherCluster.startAllBrokers();
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)otherCluster.bootstrapServers(otherCluster.bootstrapServers$default$1()))}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$12 = this.linkName();
            Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"SOURCE")}));
            Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
            Set<String> x$15 = qual$3.alterClusterLink$default$4();
            boolean x$16 = qual$3.alterClusterLink$default$5();
            qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14, x$15, x$16);
        });
        Assertions.assertThrows(InvalidConfigurationException.class, () -> connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConnectionModeProp()), (Object)"INBOUND")}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5()));
        Assertions.assertEquals((Object)this.destinationLinkMode(), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().linkMode());
        Assertions.assertEquals((Object)ConnectionMode.Outbound$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)connectingCluster.brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().connectionMode());
        String trustStoreConfigName = this.useSourceInitiatedLink() ? new StringBuilder(23).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.location").toString() : "ssl.truststore.location";
        File oldFile = new File(connectingCluster.describeClusterLink(this.linkName()).get(trustStoreConfigName).value());
        File newFile = File.createTempFile("truststore", ".jks");
        Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trustStoreConfigName), (Object)newFile.getAbsolutePath())}))), connectingCluster.alterClusterLink$default$3(), connectingCluster.alterClusterLink$default$4(), connectingCluster.alterClusterLink$default$5());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        int firstDestBroker = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        java.util.Map destReassignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(firstDestBroker))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        this.destCluster().alterPartitionAssignment(destReassignment);
        this.destCluster().ensureConsistentKRaftMetadata();
        int firstSourceBroker = ((KafkaBroker)this.sourceCluster().brokers().head()).config().brokerId();
        java.util.Map sourceReassignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(firstSourceBroker))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        this.sourceCluster().alterPartitionAssignment(sourceReassignment);
        this.sourceCluster().ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.maxFetcherCount(linkId));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"3")}));
        Seq<KafkaBroker> x$19 = qual$4.alterClusterLink$default$3();
        Set<String> x$20 = qual$4.alterClusterLink$default$4();
        boolean x$21 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$17, (Map<String, String>)x$18, x$19, x$20, x$21);
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = this.maxFetcherCount(linkId);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testClusterLinkConfigs$6(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var42_37 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int threads = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)3, (int)var35_40);
        this.produceToSourceCluster(8);
        this.consume(this.destCluster(), this.consume$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAlterClusterLinkConfigs(String quorum, boolean coordinator) {
        String x$1 = this.linkName();
        Properties x$3 = this.createClusterLink$default$2();
        Option<Properties> x$4 = this.createClusterLink$default$3();
        boolean x$5 = this.createClusterLink$default$5();
        this.createClusterLink(x$1, x$3, x$4, true, x$5);
        ConfigEntry configEntry = this.destCluster().describeClusterLink(this.linkName()).get(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp());
        Assertions.assertNotNull((Object)configEntry);
        Assertions.assertTrue((boolean)configEntry.isDefault());
        Assertions.assertNotNull((Object)configEntry.value());
        String initialVal = configEntry.value();
        String newVal = Integer.toString(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(initialVal)) + 1000);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$6 = this.linkName();
        Map x$7 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp()), (Object)newVal)}));
        Seq<KafkaBroker> x$8 = qual$1.alterClusterLink$default$3();
        Set<String> x$9 = qual$1.alterClusterLink$default$4();
        boolean x$10 = qual$1.alterClusterLink$default$5();
        qual$1.alterClusterLink(x$6, (Map<String, String>)x$7, x$8, x$9, x$10);
        configEntry = this.destCluster().describeClusterLink(this.linkName()).get(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp());
        Assertions.assertNotNull((Object)configEntry);
        Assertions.assertFalse((boolean)configEntry.isDefault());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$11 = this.linkName();
        Map x$12 = (Map)Map$.MODULE$.empty();
        Set x$13 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp()}));
        Seq<KafkaBroker> x$14 = qual$2.alterClusterLink$default$3();
        boolean x$15 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$11, (Map<String, String>)x$12, x$14, (Set<String>)x$13, x$15);
        configEntry = this.destCluster().describeClusterLink(this.linkName()).get(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp());
        Assertions.assertNotNull((Object)configEntry);
        Assertions.assertTrue((boolean)configEntry.isDefault());
        Assertions.assertEquals((Object)initialVal, (Object)configEntry.value());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$16 = this.linkName();
        boolean x$17 = qual$3.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$18 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testAlterClusterLinkWithInvalidConfigs(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}))));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        Uuid linkId = this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), "{");
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.includeAllTopicsFilter().replace("topic", "group"))}));
        Seq<KafkaBroker> x$14 = qual$2.alterClusterLink$default$3();
        Set<String> x$15 = qual$2.alterClusterLink$default$4();
        boolean x$16 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$12, (Map<String, String>)x$13, x$14, x$15, x$16);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$17 = this.topic();
        short x$18 = this.replicationFactor();
        String x$19 = this.linkName();
        String x$20 = this.clusterLinkPrefix();
        Map<String, String> x$21 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$17, x$18, x$19, x$21, x$20);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$22 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$23 = this.linkName();
        boolean x$24 = qual$4.unlinkTopic$default$3();
        boolean x$25 = qual$4.unlinkTopic$default$4();
        boolean x$26 = qual$4.unlinkTopic$default$5();
        int x$27 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$22, x$23, x$24, x$25, x$26, x$27);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$28 = this.linkName();
        boolean x$29 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$30 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$28, x$29, x$30);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testExternalizedPasswordConfig(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        File propsFile = TestUtils.tempFile((String)new StringBuilder(17).append("sasl.jaas.config=").append(linkProps.getProperty("sasl.jaas.config")).toString());
        linkProps.put("sasl.jaas.config", new StringBuilder(25).append("${file:").append(propsFile.getAbsolutePath()).append(":sasl.jaas.config}").toString());
        linkProps.setProperty("config.providers", "file");
        linkProps.setProperty("config.providers.file.class", FileConfigProvider.class.getName());
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifySaslJaasConfigEncrypted(linkId);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp()), (Object)"1000")}))));
        this.verifySaslJaasConfigEncrypted(linkId);
        this.produceToSourceCluster(numRecords);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
        linkProps.setProperty("sasl.jaas.config", "someprovider:link.props:sasl.jaas.config");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            Option<Properties> x$15 = this.createClusterLink$default$3();
            boolean x$16 = this.createClusterLink$default$5();
            this.createClusterLink("invalidLink1", linkProps, x$15, true, x$16);
        });
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            Option<Properties> x$20 = this.createClusterLink$default$3();
            boolean x$21 = this.createClusterLink$default$5();
            this.createClusterLink("invalidLink2", linkProps, x$20, false, x$21);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkMetadataTopicCreation(String quorum, boolean coordinator) {
        this.destCluster().killAllBrokers();
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "2");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "1");
        this.destCluster().restartDeadBrokers(true);
        this.destCluster().updateBootstrapServers();
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.enable");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.partitions");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.replication.factor");
    }

    private final void waitForConnectionMetric$1(Function1 predicate) {
        MetricName activeClientConnectionMetricName = ClusterLinkMetrics$.MODULE$.activeClientConnectionsCountMetricName();
        String x$1 = activeClientConnectionMetricName.name();
        String x$2 = activeClientConnectionMetricName.group();
        None$ x$3 = None$.MODULE$;
        Map<String, String> x$5 = this.waitForKafkaMetric$default$4();
        Seq<KafkaBroker> x$6 = this.waitForKafkaMetric$default$5();
        boolean x$7 = this.waitForKafkaMetric$default$6();
        boolean x$8 = this.waitForKafkaMetric$default$7();
        this.waitForKafkaMetric(x$1, x$2, (Option<String>)x$3, x$5, x$6, x$7, x$8, (Function1<Object, Object>)predicate);
    }

    public static final /* synthetic */ int $anonfun$testPauseClusterLink$6(ClusterLinkControlPlaneLinkConfigResourceIntegrationTest $this) {
        return $this.destCluster().describeTopic($this.topic()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$7(int newNumPartitions$1, int x$3) {
        return x$3 == newNumPartitions$1;
    }

    public static final /* synthetic */ String $anonfun$testPauseClusterLink$8(ClusterLinkControlPlaneLinkConfigResourceIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get("delete.retention.ms").value();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$9(String newDeleteRetentionMs$1, String x$4) {
        String string = x$4;
        return !(string != null ? !string.equals(newDeleteRetentionMs$1) : newDeleteRetentionMs$1 != null);
    }

    public static final /* synthetic */ int $anonfun$testClusterLinkConfigs$5(ClusterLinkControlPlaneLinkConfigResourceIntegrationTest $this, Uuid linkId$1) {
        return $this.maxFetcherCount(linkId$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigs$6(int x$5) {
        return x$5 == 3;
    }

    public ClusterLinkControlPlaneLinkConfigResourceIntegrationTest() {
        this.consumerGroup = "testGroup";
        this.expectedPauseMirrorTopicsCountMetricName = "pause-mirror-topics";
    }

    public static final /* synthetic */ Object $anonfun$testPauseClusterLink$9$adapted(String newDeleteRetentionMs$1, String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkConfigResourceIntegrationTest.$anonfun$testPauseClusterLink$9(newDeleteRetentionMs$1, x$4));
    }
}

