/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.server.KafkaBroker;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:7")})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQA\u0015\u0001\u0005\u0002MCQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQa\u001a\u0001\u0005\u0002!DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001e\u0001\u0005\u0002aDQA \u0001\u0005\u0002}Dq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA=\u0001\u0011%\u00111\u0010\u00023\u00072,8\u000f^3s\u0019&t7nQ8oiJ|G\u000e\u00157b]\u0016d\u0015N\\6SKN|WO]2f\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0011CE\u0001\u0005Y&t7NC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\t\n\u0005e\u0001\"AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011q\u0003A\u0001#i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3EK2,G/Z!oIJ+7M]3bi\u0016d\u0015N\\6\u0015\u0007})#\u0007\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u0003\u0001\u00049\u0013AB9v_J,X\u000e\u0005\u0002)_9\u0011\u0011&\f\t\u0003U\u0005j\u0011a\u000b\u0006\u0003YQ\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\n\u0003\"B\u001a\u0003\u0001\u0004!\u0014aC2p_J$\u0017N\\1u_J\u0004\"\u0001I\u001b\n\u0005Y\n#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u0005a\"U\t\u0005\u0002:\u00056\t!H\u0003\u0002<y\u00051\u0001/\u0019:b[NT!!\u0010 \u0002\u000f),\b/\u001b;fe*\u0011q\bQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u00051\u0015\u0001K>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{:\u001awn\u001c:eS:\fGo\u001c:>wFj\b\u0006\u0002\u0002I\u001d>\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u001e\u0002\u0011A\u0014xN^5eKJL!!\u0014&\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003A\u000b\u0013!U\u0001\u0010C2d7i\\7cS:\fG/[8og\u0006\u0011C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\WI\u001d:pe\"\u000bg\u000e\u001a7j]\u001e$2a\b+V\u0011\u001513\u00011\u0001(\u0011\u0015\u00194\u00011\u00015Q\u0011\u0019\u0001\bR#)\t\rAe\n\u0017\u0017\u0002!\u0006\u0019D/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\w+\u001b;i\u001d>4\u0016\r\\5eCR,\u0017I\u001c3Ok2d7\t\\;ti\u0016\u0014\u0018\n\u001a\u000b\u0003?mCQA\n\u0003A\u0002\u001dBC\u0001\u0002\u001dE\u000b\"\"A\u0001\u0013(_Y\u0005\u0001\u0016\u0001\b;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn[\"mK\u0006tW\u000f\u001d\u000b\u0004?\u0005\u0014\u0007\"\u0002\u0014\u0006\u0001\u00049\u0003\"B2\u0006\u0001\u0004!\u0014AE;tK2Kgn[\"p_J$\u0017N\\1u_JDC!\u0002\u001dE\u000b\"\"Q\u0001\u0013(gY\u0005\u0001\u0016a\u0006;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014H*\u001b8l)\ry\u0012N\u001b\u0005\u0006M\u0019\u0001\ra\n\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0015\u0005\ra\"U\t\u000b\u0003\u0007\u0011:kG&\u00018\"\u0003=\faB_6D_6\u0014\u0017N\\1uS>t7/\u0001\u0019uKN$H)Z:de&\u0014Wm\u00117vgR,'\u000fT5oWJ+\u0017\rZ!gi\u0016\u0014xK]5uK\u000e{gn]5ti\u0016t7-\u001f\u000b\u0004?I\u001c\b\"\u0002\u0014\b\u0001\u00049\u0003\"B\u001a\b\u0001\u0004!\u0004\u0006B\u00049\t\u0016CCa\u0002%Om2\n\u0001+\u0001\u000euKN$H*[:u\u0019&t7.\u00138GC&dWO]3SKR\u0014\u0018\u0010F\u0002 sjDQA\n\u0005A\u0002\u001dBQa\r\u0005A\u0002QBC\u0001\u0003\u001dE\u000b\"\"\u0001\u0002\u0013(~Y\u0005q\u0017a\t;fgRd\u0015N\\6V]\u00064\u0018-\u001b7bE2,g+\u0019:j_V\u001c8kY3oCJLwn\u001d\u000b\u0006?\u0005\u0005\u00111\u0001\u0005\u0006M%\u0001\ra\n\u0005\u0006g%\u0001\r\u0001\u000e\u0015\u0005\u0013a\"U\tK\u0003\n\u0011:\u000bI\u0001L\u0001Q\u0003M\"Xm\u001d;DYV\u001cH/\u001a:MS:\\G)[:bE2,'I]8lKJ\u001cuN\u001c4jO^KG\u000f[#ySN$\u0018N\\4MS:\\7\u000fF\u0003 \u0003\u001f\t\t\u0002C\u0003'\u0015\u0001\u0007q\u0005C\u00034\u0015\u0001\u0007A\u0007\u000b\u0003\u000bq\u0011+\u0005&\u0002\u0006I\u001d\u0006]A&\u0001)\u00027Q,7\u000f^\"mkN$XM\u001d'j].\u001cE.[3oi\u0016C\b/\u001b:z)\u0015y\u0012QDA\u0010\u0011\u001513\u00021\u0001(\u0011\u0015\u00194\u00021\u00015Q\u0011Y\u0001\bR#)\u000b-Ae*!\n-\u0003A\u000b1#Y2uSZ,G*\u0019>z%\u0016\u001cx.\u001e:dKN$B!a\u000b\u0002^A1\u0011QFA\u001a\u0003oi!!a\f\u000b\u0007\u0005E\u0012%\u0001\u0006d_2dWm\u0019;j_:LA!!\u000e\u00020\t\u00191+Z91\t\u0005e\u00121\n\t\u0007\u0003w\t\u0019%a\u0012\u000e\u0005\u0005u\"bA\t\u0002@)\u0019\u0011\u0011\t\n\u0002\rM,'O^3s\u0013\u0011\t)%!\u0010\u0003\u00191\u000b'0\u001f*fg>,(oY3\u0011\t\u0005%\u00131\n\u0007\u0001\t-\ti\u0005DA\u0001\u0002\u0003\u0015\t!a\u0014\u0003\u0007}#\u0013'\u0005\u0003\u0002R\u0005]\u0003c\u0001\u0011\u0002T%\u0019\u0011QK\u0011\u0003\u000f9{G\u000f[5oOB\u0019\u0001%!\u0017\n\u0007\u0005m\u0013EA\u0002B]fDq!a\u0018\r\u0001\u0004\t\t'\u0001\u0004mS:\\\u0017\n\u001a\t\u0005\u0003G\ny'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0019\u0019w.\\7p]*\u00191#a\u001b\u000b\u0007\u00055\u0004)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003c\n)G\u0001\u0003Vk&$\u0017\u0001G<bSR4uN\u001d(p\u0003\u000e$\u0018N^3SKN|WO]2fgR\u0019q$a\u001e\t\u000f\u0005}S\u00021\u0001\u0002b\u00059r/Y5u\r>\u0014(+Z:pkJ\u001cWm\u001d+p\u00072|7/\u001a\u000b\u0004?\u0005u\u0004bBA@\u001d\u0001\u0007\u0011\u0011Q\u0001\ne\u0016\u001cx.\u001e:dKN\u0004b!!\f\u00024\u0005\r\u0005\u0007BAC\u0003\u0013\u0003b!a\u000f\u0002D\u0005\u001d\u0005\u0003BA%\u0003\u0013#A\"a#\u0002~\u0005\u0005\t\u0011!B\u0001\u0003\u001f\u00121a\u0018\u00134Q\u0019\u0001\u0011q\u0012(\u0002\u001cB!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016r\n1!\u00199j\u0013\u0011\tI*a%\u0003\u0007Q\u000bw-\t\u0002\u0002\u001e\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001\u0011q\u0012(\u0002\"\u0006\u0012\u00111U\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(h\u000e")
public class ClusterLinkControlPlaneLinkResourceIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateAndDeleteAndRecreateLink(String quorum, boolean coordinator) {
        void var48_52;
        Tuple2 tuple2;
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$22 = this.numPartitions();
        short x$32 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$52 = qual$1.createTopic$default$5();
        Properties x$62 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$22, x$32, x$4, x$52, x$62);
        Map propsOverride = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp()), (Object)"100")}));
        Uuid linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)propsOverride), this.sourceLinkProps((Map<String, String>)propsOverride), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Option<String> x$13 = qual$3.listClusterLinks$default$2();
        Seq<ClusterLinkListing> listing = qual$3.listClusterLinks(true, x$13);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkListing)((IterableOps)listing.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$1(this, x$1)))).head()).topics().get()).asScala().toSet());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        Option<String> x$15 = qual$4.describeClusterLinks$default$2();
        int x$16 = qual$4.describeClusterLinks$default$3();
        boolean x$17 = qual$4.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> description = qual$4.describeClusterLinks(true, x$15, x$16, x$17);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkDescription)((IterableOps)description.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$2(this, x$2)))).head()).topics().get()).asScala().toSet());
        this.waitForRemoteLinkStateOnActiveLink(this.linkName());
        Seq<LazyResource<?>> linkLazyResources = this.activeLazyResources(linkId);
        Assertions.assertNotEquals((Object)Seq$.MODULE$.empty(), linkLazyResources);
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId, this.waitAndVerifyMetricsAndMirror$default$3());
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        boolean x$18 = qual$5.describeClusterLinks$default$1();
        Option<String> x$19 = qual$5.describeClusterLinks$default$2();
        int x$20 = qual$5.describeClusterLinks$default$3();
        boolean x$21 = qual$5.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> describeResult = qual$5.describeClusterLinks(x$18, x$19, x$20, x$21);
        Assertions.assertEquals((Object)linkId, (Object)((ClusterLinkDescription)describeResult.head()).clusterLinkId());
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$222 = this.linkName();
        boolean x$23 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$24 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$222, x$23, x$24);
        this.waitForResourcesToClose(linkLazyResources);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        Option<String> x$26 = qual$7.listClusterLinks$default$2();
        listing = qual$7.listClusterLinks(true, x$26);
        Assertions.assertTrue((boolean)listing.isEmpty());
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Option<String> x$28 = qual$8.describeClusterLinks$default$2();
        int x$29 = qual$8.describeClusterLinks$default$3();
        boolean x$30 = qual$8.describeClusterLinks$default$4();
        description = qual$8.describeClusterLinks(true, x$28, x$29, x$30);
        Assertions.assertTrue((description.isEmpty() || description.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$3(x$3))) ? 1 : 0) != 0, (String)new StringBuilder(17).append("Unexpected link: ").append(description).toString());
        if (this.useSourceInitiatedLink()) {
            this.sourceCluster().waitForRemoteLinkState(this.linkName(), ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR);
        }
        KafkaBroker broker = (KafkaBroker)this.destCluster().brokers().head();
        this.destCluster().killBrokerById(broker.config().brokerId());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        boolean x$31 = qual$9.restartDeadBrokers$default$1();
        qual$9.restartDeadBrokers(x$31);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long computeUntilTrue_waitTime = TestUtils$.MODULE$.computeUntilTrue$default$2();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if (ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$5(computeUntilTrue_result = ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$4(broker))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var82_50 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq links = (Seq)tuple22._1();
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)var48_52);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$10 = this.sourceCluster();
            String x$322 = this.linkName();
            boolean x$33 = qual$10.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$34 = qual$10.deleteClusterLink$default$3();
            qual$10.deleteClusterLink(x$322, x$33, x$34);
            if (!this.useBidirectionalLink()) {
                ClusterLinkTestHarness qual$11 = this.sourceCluster();
                Option<String> x$36 = qual$11.listClusterLinks$default$2();
                listing = qual$11.listClusterLinks(true, x$36);
                Assertions.assertEquals((Object)Seq$.MODULE$.empty(), listing);
                ClusterLinkTestHarness qual$12 = this.sourceCluster();
                Option<String> x$38 = qual$12.describeClusterLinks$default$2();
                int x$39 = qual$12.describeClusterLinks$default$3();
                boolean x$40 = qual$12.describeClusterLinks$default$4();
                description = qual$12.describeClusterLinks(true, x$38, x$39, x$40);
                Assertions.assertEquals((Object)Seq$.MODULE$.empty(), description);
            }
        }
        Uuid newLinkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)propsOverride), this.sourceLinkProps((Map<String, String>)propsOverride), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$13 = this.destCluster();
        String x$41 = this.topic();
        short x$42 = this.replicationFactor();
        String x$43 = this.linkName();
        Map<String, String> x$44 = qual$13.linkTopic$default$4();
        String x$45 = qual$13.linkTopic$default$5();
        qual$13.linkTopic(x$41, x$42, x$43, x$44, x$45);
        ClusterLinkTestHarness qual$14 = this.destCluster();
        Option<String> x$47 = qual$14.listClusterLinks$default$2();
        listing = qual$14.listClusterLinks(true, x$47);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkListing)((IterableOps)listing.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$6(this, x$5)))).head()).topics().get()).asScala().toSet());
        ClusterLinkTestHarness qual$15 = this.destCluster();
        Option<String> x$49 = qual$15.describeClusterLinks$default$2();
        int x$50 = qual$15.describeClusterLinks$default$3();
        boolean x$51 = qual$15.describeClusterLinks$default$4();
        description = qual$15.describeClusterLinks(true, x$49, x$50, x$51);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkDescription)((IterableOps)description.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$7(this, x$6)))).head()).topics().get()).asScala().toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), newLinkId, false);
        this.destCluster().deleteLinkNoVerify(this.linkName(), true);
        this.destCluster().killAllBrokers();
        ClusterLinkTestHarness qual$16 = this.destCluster();
        boolean x$522 = qual$16.restartDeadBrokers$default$1();
        qual$16.restartDeadBrokers(x$522);
        this.destCluster().updateBootstrapServers();
        Option metadataManager = broker.clusterLinkManager().clusterLinkMetadataManager();
        Assertions.assertTrue((boolean)metadataManager.isDefined());
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$8(metadataManager, newLinkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$9(newLinkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!this.useSourceInitiatedLink()) {
            Properties invalidLinkProps = this.destLinkProps(this.destLinkProps$default$1());
            invalidLinkProps.setProperty("sasl.jaas.config", invalidLinkProps.getProperty("sasl.jaas.config").replace(this.linkName(), new StringBuilder(6).append("wrong-").append(this.linkName()).toString()));
            this.verifyValidateLinkFailure(invalidLinkProps, SaslAuthenticationException.class, "Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateClusterLinkErrorHandling(String quorum, boolean coordinator) {
        Properties invalidProps1 = this.props$1();
        String invalidCreds = this.generateInvalidCredentials(this.sourceCluster());
        invalidProps1.setProperty("sasl.jaas.config", invalidCreds);
        Assertions.assertThrows(SaslAuthenticationException.class, () -> {
            String x$1 = this.linkName();
            Option<Properties> x$4 = this.createClusterLink$default$3();
            boolean x$5 = this.createClusterLink$default$5();
            this.createClusterLink(x$1, invalidProps1, x$4, true, x$5);
        });
        Properties invalidProps2 = this.props$1();
        String invalidBootstrapServers = "localhost:";
        invalidProps2.setProperty("bootstrap.servers", invalidBootstrapServers);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            String x$6 = this.linkName();
            Option<Properties> x$9 = this.createClusterLink$default$3();
            boolean x$10 = this.createClusterLink$default$5();
            this.createClusterLink(x$6, invalidProps2, x$9, true, x$10);
        });
        Properties invalidProps3 = this.props$1();
        String invalidBootstrapServersInternalPort = "localhost:9071";
        invalidProps3.setProperty("bootstrap.servers", invalidBootstrapServersInternalPort);
        InvalidClusterLinkException invalidBootstrapServesInternalPortException = (InvalidClusterLinkException)Assertions.assertThrows(InvalidClusterLinkException.class, () -> {
            String x$11 = this.linkName();
            Option<Properties> x$14 = this.createClusterLink$default$3();
            boolean x$15 = this.createClusterLink$default$5();
            this.createClusterLink(x$11, invalidProps3, x$14, true, x$15);
        });
        Assertions.assertEquals((Object)ClusterLinkError.INVALID_BOOTSTRAP_INTERNAL_ENDPOINT_ERROR, (Object)invalidBootstrapServesInternalPortException.clusterLinkError());
        this.sourceCluster().killAllBrokers();
        Properties validProps = this.props$1();
        InvalidClusterLinkException bootstrapTcpConnectionFailedException = (InvalidClusterLinkException)Assertions.assertThrows(InvalidClusterLinkException.class, () -> {
            String x$16 = this.linkName();
            Option<Properties> x$19 = this.createClusterLink$default$3();
            boolean x$20 = this.createClusterLink$default$5();
            this.createClusterLink(x$16, validProps, x$19, true, x$20);
        });
        Assertions.assertEquals((Object)ClusterLinkError.BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR, (Object)bootstrapTcpConnectionFailedException.clusterLinkError());
        this.restartSource(false);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ListenerName x$21 = qual$1.bootstrapServers$default$1();
        validProps.setProperty("bootstrap.servers", qual$1.bootstrapServers(x$21));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateClusterLinkErrorHandling$5(this, validProps)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to create cluster link with valid properties");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateClusterLinkWithNoValidateAndNullClusterId(String quorum) {
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.destLinkProps(this.destLinkProps$default$1());
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.createClusterLink$default$4();
        Uuid linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$5 = qual$2.listClusterLinks$default$1();
        Option<String> x$6 = qual$2.listClusterLinks$default$2();
        Seq<ClusterLinkListing> links = qual$2.listClusterLinks(x$5, x$6);
        Assertions.assertEquals((int)1, (int)links.size());
        links.foreach((Function1 & Serializable)link -> {
            ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateClusterLinkWithNoValidateAndNullClusterId$1(this, linkId, link);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDeleteClusterLinkCleanup(String quorum, boolean useLinkCoordinator) {
        this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        Set topics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)idx -> ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testDeleteClusterLinkCleanup$1(BoxesRunTime.unboxToInt((Object)idx))).toSet();
        topics.foreach((Function1 & Serializable)topic -> {
            ClusterLinkTestHarness qual$1 = this.sourceCluster();
            int x$2 = this.numPartitions();
            short x$3 = this.replicationFactor();
            Properties x$4 = qual$1.createTopic$default$4();
            ListenerName x$5 = qual$1.createTopic$default$5();
            Properties x$6 = qual$1.createTopic$default$6();
            qual$1.createTopic((String)topic, x$2, x$3, x$4, x$5, x$6);
            ClusterLinkTestHarness qual$2 = this.destCluster();
            short x$8 = this.replicationFactor();
            String x$9 = this.linkName();
            Map<String, String> x$10 = qual$2.linkTopic$default$4();
            String x$11 = qual$2.linkTopic$default$5();
            return qual$2.linkTopic((String)topic, x$8, x$9, x$10, x$11);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        boolean x$12 = qual$3.listMirrorTopics$default$1();
        Assertions.assertEquals((int)topics.size(), (int)qual$3.listMirrorTopics(x$12).size());
        Assertions.assertThrows(ClusterLinkInUseException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$13 = this.linkName();
            boolean x$14 = qual$4.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$15 = qual$4.deleteClusterLink$default$3();
            qual$4.deleteClusterLink(x$13, x$14, x$15);
        });
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = this.linkName();
        Seq<KafkaBroker> x$18 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$16, true, x$18);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$19 = qual$6.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$6.listMirrorTopics(x$19).isEmpty());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        boolean x$20 = qual$7.listClusterLinks$default$1();
        Option<String> x$21 = qual$7.listClusterLinks$default$2();
        Assertions.assertTrue((boolean)qual$7.listClusterLinks(x$20, x$21).isEmpty());
        Assertions.assertThrows(ClusterLinkNotFoundException.class, () -> this.destCluster().describeClusterLink(this.linkName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDescribeClusterLink(String quorum, boolean coordinator) {
        Uuid linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$12 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$12);
        this.waitForFailure(destAdmin, FailureType$CorruptConfigs$.MODULE$, this.waitForFailure$default$3());
        destAdmin.close();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$13 = qual$4.describeClusterLinks$default$1();
        Option<String> x$14 = qual$4.describeClusterLinks$default$2();
        int x$15 = qual$4.describeClusterLinks$default$3();
        boolean x$16 = qual$4.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> describeResult = qual$4.describeClusterLinks(x$13, x$14, x$15, x$16);
        Assertions.assertEquals((int)1, (int)describeResult.size());
        Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)describeResult.head()).linkName());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.FAILED, (Object)((ClusterLinkDescription)describeResult.head()).linkState());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).linkMode());
        Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).connectionMode());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDescribeClusterLinkReadAfterWriteConsistency(String quorum, boolean coordinator) {
        String x$1 = this.linkName();
        Properties x$3 = this.createClusterLink$default$2();
        Option<Properties> x$4 = this.createClusterLink$default$3();
        boolean x$5 = this.createClusterLink$default$4();
        this.createClusterLink(x$1, x$3, x$4, x$5, false);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Some x$7 = new Some((Object)this.linkName());
        int x$8 = qual$1.describeClusterLinks$default$3();
        boolean x$9 = qual$1.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> destLinkDescription = qual$1.describeClusterLinks(true, (Option<String>)x$7, x$8, x$9);
        if (this.useSourceInitiatedLink()) {
            Assertions.assertEquals((int)1, (int)destLinkDescription.size());
            Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.ACTIVE, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkState());
            Assertions.assertEquals((Object)this.destinationLinkMode().name(), (Object)((ClusterLinkDescription)destLinkDescription.head()).linkMode().name());
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.INBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
        } else {
            Assertions.assertEquals((int)1, (int)destLinkDescription.size());
            Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.ACTIVE, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkState());
            Assertions.assertEquals((Object)this.destinationLinkMode().name(), (Object)((ClusterLinkDescription)destLinkDescription.head()).linkMode().name());
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
        }
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$2 = this.sourceCluster();
            Some x$11 = new Some((Object)this.linkName());
            int x$12 = qual$2.describeClusterLinks$default$3();
            boolean x$13 = qual$2.describeClusterLinks$default$4();
            Seq<ClusterLinkDescription> sourceLinkDescription = qual$2.describeClusterLinks(true, (Option<String>)x$11, x$12, x$13);
            Assertions.assertEquals((int)1, (int)sourceLinkDescription.size());
            Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkName());
            Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.ACTIVE, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkState());
            Assertions.assertEquals((Object)this.sourceLinkMode().name(), (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkMode().name());
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).connectionMode());
        }
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Some x$15 = new Some((Object)new StringBuilder(8).append(this.linkName()).append("_invalid").toString());
        boolean x$17 = qual$3.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> linkNotFoundDescription = qual$3.describeClusterLinks(true, (Option<String>)x$15, 5000, x$17);
        Assertions.assertEquals((int)0, (int)linkNotFoundDescription.size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testListLinkInFailureRetry(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        Uuid linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.destCluster().updateZkLinkConfig(linkId, "bootstrap.servers", "999.999.999.999:0000");
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.FAILED, this.waitForLinkStateOnDest$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR);
        this.verifyFailureRetryMetric((Option<String>)new Some((Object)this.linkName()));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listClusterLinks$default$1();
        Option<String> x$2 = qual$1.listClusterLinks$default$2();
        Seq<ClusterLinkListing> res1 = qual$1.listClusterLinks(x$1, x$2);
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).linkName(), (Object)this.linkName());
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).clusterLinkError(), (Object)ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ListenerName x$3 = qual$2.bootstrapServers$default$1();
        this.destCluster().updateZkLinkConfig(linkId, "bootstrap.servers", qual$2.bootstrapServers(x$3));
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        boolean x$4 = qual$3.listClusterLinks$default$1();
        Option<String> x$5 = qual$3.listClusterLinks$default$2();
        Seq<ClusterLinkListing> res2 = qual$3.listClusterLinks(x$4, x$5);
        Assertions.assertEquals((Object)((ClusterLinkListing)res2.head()).linkName(), (Object)this.linkName());
        Assertions.assertEquals((Object)((ClusterLinkListing)res2.head()).clusterLinkError(), (Object)ClusterLinkError.NO_ERROR);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$6 = this.linkName();
        Seq<KafkaBroker> x$8 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$6, true, x$8);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testListLinkInFailureRetry$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLinkUnavailableVariousScenarios(String quorum, boolean coordinator) {
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.NO_ERROR);
        this.waitForRemoteLinkStateOnActiveLink(this.linkName());
        String validCreds = linkProps.getProperty("sasl.jaas.config");
        String invalidCreds = this.generateInvalidCredentials(this.sourceCluster());
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Map x$2 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)invalidCreds)}));
        Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
        Set<String> x$4 = qual$1.alterClusterLink$default$4();
        boolean x$5 = qual$1.alterClusterLink$default$5();
        qual$1.alterClusterLink(x$1, (Map<String, String>)x$2, x$3, x$4, x$5);
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.UNAVAILABLE, this.waitForLinkStateOnDest$default$3());
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)Seq$.MODULE$.empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkCheckAvailabilityTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"check-availability"), (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)Seq$.MODULE$.empty()));
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.AUTHENTICATION_ERROR);
        this.waitForUnavailableLinkCountMetric(this.destinationLinkMode(), "authentication", this.destCluster());
        this.waitForUnavailableLink(this.linkName(), ClusterLinkError.AUTHENTICATION_ERROR, this.destCluster());
        if (this.useBidirectionalLink()) {
            this.destCluster().waitForRemoteLinkState(this.linkName(), ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN);
        } else {
            this.destCluster().waitForRemoteLinkState(this.linkName(), ClusterLinkDescription.LinkState.UNMANAGED_SOURCE, ClusterLinkError.NO_ERROR);
        }
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        Map x$7 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)validCreds)}));
        Seq<KafkaBroker> x$8 = qual$2.alterClusterLink$default$3();
        Set<String> x$9 = qual$2.alterClusterLink$default$4();
        boolean x$10 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$6, (Map<String, String>)x$7, x$8, x$9, x$10);
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.NO_ERROR);
        this.waitForRemoteLinkStateOnActiveLink(this.linkName());
        this.sourceCluster().killAllBrokers();
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.UNAVAILABLE, this.waitForLinkStateOnDest$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR);
        this.waitForUnavailableLinkCountMetric(this.destinationLinkMode(), "bootstrap_tcp_connection_failed", this.destCluster());
        this.waitForUnavailableLink(this.linkName(), ClusterLinkError.BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR, this.destCluster());
        this.restartSource(this.restartSource$default$1());
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.NO_ERROR);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDisableBrokerConfigWithExistingLinks(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        if (this.isKraftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.sourceCluster().controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        }
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        String x$15 = this.clusterLinkPrefix();
        Map<String, String> x$16 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$12, x$13, x$14, x$16, x$15);
        this.destCluster().withAdmin((Function1 & Serializable)admin -> {
            ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testClusterLinkDisableBrokerConfigWithExistingLinks$1(admin);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkClientExpiry(String quorum, boolean coordinator) {
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClientsMaxIdleMsProp()), (Object)"5000")}))));
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ByteArraySerializer x$1 = qual$1.createProducer$default$1();
        ByteArraySerializer x$2 = qual$1.createProducer$default$2();
        Properties x$3 = qual$1.createProducer$default$3();
        KafkaProducer producer = qual$1.createProducer(x$1, x$2, x$3);
        this.mirrorAndVerify$1("topic1", producer);
        this.waitForNoActiveResources(linkId);
        this.mirrorAndVerify$1("topic2", producer);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClientsMaxIdleMsProp()), (Object)Long.toString(TimeUnit.DAYS.toMillis(1L)))}))));
        this.mirrorAndVerify$1("topic3", producer);
        Assertions.assertNotEquals((Object)Seq$.MODULE$.empty(), this.activeLazyResources(linkId));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.waitForNoActiveResources(linkId);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClientsMaxIdleMsProp()), (Object)"5000")}))));
        this.mirrorAndVerify$1("topic4", producer);
        this.waitForNoActiveResources(linkId);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClientsMaxIdleMsProp()), (Object)Long.toString(TimeUnit.DAYS.toMillis(1L)))}))));
        this.mirrorAndVerify$1("topic5", producer);
        Seq<LazyResource<?>> linkLazyResources = this.activeLazyResources(linkId);
        Assertions.assertNotEquals((Object)Seq$.MODULE$.empty(), this.activeLazyResources(linkId));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$4 = this.linkName();
        boolean x$5 = qual$2.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$6 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$4, x$5, x$6);
        this.waitForResourcesToClose(linkLazyResources);
    }

    private Seq<LazyResource<?>> activeLazyResources(Uuid linkId) {
        return ((IterableOnceOps)this.destCluster().brokers().flatMap((Function1 & Serializable)broker -> (Buffer)((Buffer)TestUtils.fieldValue((Object)((ClusterLinkFactory.ClientManager)broker.clusterLinkManager().clientManager(linkId).get()), AbstractClusterLinkClientManager.class, (String)"lazyResources")).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$activeLazyResources$2(x$8))))).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForNoActiveResources(Uuid linkId) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = this.activeLazyResources(linkId)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq nonEmptyResources = (Seq)tuple22._1();
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)var3_7.toSeq());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForResourcesToClose(Seq<LazyResource<?>> resources) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$waitForResourcesToClose$1(resources)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq nonEmptyResources = (Seq)tuple22._1();
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)var3_7.toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$1(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, ClusterLinkListing x$1) {
        String string = x$1.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$2(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, ClusterLinkDescription x$2) {
        String string = x$2.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$3(ClusterLinkDescription x$3) {
        ClusterLinkDescription.LinkState linkState = x$3.linkState();
        ClusterLinkDescription.LinkState linkState2 = ClusterLinkDescription.LinkState.UNMANAGED_SOURCE;
        return !(linkState != null ? !linkState.equals(linkState2) : linkState2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$testCreateAndDeleteAndRecreateLink$4(KafkaBroker broker$1) {
        return broker$1.clusterLinkManager().listClusterLinks();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$5(Seq x$4) {
        Seq seq = x$4;
        SeqOps seqOps = Seq$.MODULE$.empty();
        return !(seq != null ? !seq.equals(seqOps) : seqOps != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$6(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, ClusterLinkListing x$5) {
        String string = x$5.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$7(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, ClusterLinkDescription x$6) {
        String string = x$6.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$8(Option metadataManager$1, Uuid newLinkId$1) {
        return !((ClusterLinkMetadataManager)metadataManager$1.get()).clusterLinkExists(newLinkId$1);
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteAndRecreateLink$9(Uuid newLinkId$1) {
        return new StringBuilder(28).append("Cluster link ").append(newLinkId$1).append(" is not deleted").toString();
    }

    private final Properties props$1() {
        Properties props = this.destLinkProps(this.destLinkProps$default$1());
        props.setProperty("metadata.max.age.ms", "100");
        props.setProperty("request.timeout.ms", "1000");
        props.setProperty("default.api.timeout.ms", "1000");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterLinkErrorHandling$5(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, Properties validProps$1) {
        try {
            String x$22 = $this.linkName();
            Option<Properties> x$25 = $this.createClusterLink$default$3();
            boolean x$26 = $this.createClusterLink$default$5();
            $this.createClusterLink(x$22, validProps$1, x$25, true, x$26);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterLinkErrorHandling$6() {
        return "Failed to create cluster link with valid properties";
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterLinkWithNoValidateAndNullClusterId$1(ClusterLinkControlPlaneLinkResourceIntegrationTest $this, Uuid linkId$1, ClusterLinkListing link) {
        Assertions.assertEquals((Object)linkId$1, (Object)link.clusterLinkId());
        Assertions.assertEquals((Object)$this.linkName(), (Object)link.linkName());
        Assertions.assertEquals((Object)((KafkaBroker)$this.sourceCluster().brokers().head()).clusterId(), (Object)link.remoteClusterId());
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLinkCleanup$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListLinkInFailureRetry$1(ClusterLinkControlPlaneLinkResourceIntegrationTest $this) {
        ClusterLinkTestHarness qual$5 = $this.destCluster();
        boolean x$9 = qual$5.listClusterLinks$default$1();
        Option<String> x$10 = qual$5.listClusterLinks$default$2();
        return qual$5.listClusterLinks(x$9, x$10).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testListLinkInFailureRetry$2() {
        return "Cluster link not removed";
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkDisableBrokerConfigWithExistingLinks$1(ConfluentAdmin admin) {
        .colon.colon resources = new .colon.colon((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (List)Nil$.MODULE$);
        Set alterOps = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("confluent.cluster.link.enable", "false"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("confluent.cluster.link.metadata.topic.enable", "false"), AlterConfigOp.OpType.SET)}));
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)resources.map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alterOps).asJavaCollection()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Throwable throwable = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.incrementalAlterConfigs(configs).all().get())).getCause();
        if (throwable instanceof InvalidRequestException) {
            InvalidRequestException invalidRequestException = (InvalidRequestException)throwable;
            Set configNames = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.cluster.link.enable", "confluent.cluster.link.metadata.topic.enable"}));
            Assertions.assertEquals((Object)new StringBuilder(41).append("Cannot update these configs dynamically: ").append(configNames).toString(), (Object)invalidRequestException.getMessage());
            return;
        }
        if (throwable != null) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(27).append("Found unexpected exception ").append(throwable).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testClusterLinkClientExpiry$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    private final void mirrorAndVerify$1(String topic, KafkaProducer producer$1) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, x$9, x$10, x$11);
        this.produceRecords((KafkaProducer<byte[], byte[]>)producer$1, topic, 10, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        this.waitForMirroring(this.destCluster(), (Seq<TopicPartition>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testClusterLinkClientExpiry$1(topic, BoxesRunTime.unboxToInt((Object)i))));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.linkName();
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$4();
        boolean x$16 = qual$3.unlinkTopic$default$5();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(topic, x$13, x$14, x$15, x$16, x$17);
    }

    public static final /* synthetic */ boolean $anonfun$activeLazyResources$2(LazyResource x$8) {
        return x$8.value().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$waitForResourcesToClose$2(LazyResource x$10) {
        return x$10.value().nonEmpty();
    }

    public static final /* synthetic */ Seq $anonfun$waitForResourcesToClose$1(Seq resources$1) {
        return (Seq)resources$1.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$waitForResourcesToClose$2(x$10)));
    }

    public static final /* synthetic */ Object $anonfun$testCreateAndDeleteAndRecreateLink$5$adapted(Seq x$4) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneLinkResourceIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$5(x$4));
    }

    public static final /* synthetic */ Object $anonfun$waitForNoActiveResources$2$adapted(Seq x$9) {
        return BoxesRunTime.boxToBoolean((boolean)x$9.isEmpty());
    }

    public static final /* synthetic */ Object $anonfun$waitForResourcesToClose$3$adapted(Seq x$11) {
        return BoxesRunTime.boxToBoolean((boolean)x$11.isEmpty());
    }
}

