/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:5")})
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005\u0002qAQ!\u0017\u0001\u0005\u0002iCQ\u0001\u0019\u0001\u0005\u0002\u0005DQa\u001a\u0001\u0005\u0002!DQA\u001c\u0001\u0005\u0002=DQA\u001d\u0001\u0005\u0002MDQ!\u001f\u0001\u0005\u0002iDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\"\u0001N\"mkN$XM\u001d'j].\u001cuN\u001c;s_2\u0004F.\u00198f\u001b&\u0014(o\u001c:SKN|WO]2f\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011q\u0002E\u0001\u0005Y&t7NC\u0001\u0012\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\b\n\u0005]q!AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00025A\u0011Q\u0003A\u0001,i\u0016\u001cHo\u0011:fCR,W*\u001b:s_J$v\u000e]5d\u0003:$g+\u001a:jMf\u001cv.\u001e:dKR{\u0007/[2JIR\u0019Qd\t\u0019\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\t\u0001\r!J\u0001\u0007cV|'/^7\u0011\u0005\u0019jcBA\u0014,!\tAs$D\u0001*\u0015\tQ##\u0001\u0004=e>|GOP\u0005\u0003Y}\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011Af\b\u0005\u0006c\t\u0001\rAM\u0001\fG>|'\u000fZ5oCR|'\u000f\u0005\u0002\u001fg%\u0011Ag\b\u0002\b\u0005>|G.Z1oQ\u0011\u0011aGQ\"\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014A\u00029be\u0006l7O\u0003\u0002<y\u00059!.\u001e9ji\u0016\u0014(BA\u001f?\u0003\u0015QWO\\5u\u0015\u0005y\u0014aA8sO&\u0011\u0011\t\u000f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013\u0001R\u0001)w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhfY8pe\u0012Lg.\u0019;pevZ\u0018' \u0015\u0005\u0005\u0019cU\n\u0005\u0002H\u00156\t\u0001J\u0003\u0002Jq\u0005A\u0001O]8wS\u0012,'/\u0003\u0002L\u0011\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\na*I\u0001P\u0003=\tG\u000e\\\"p[\nLg.\u0019;j_:\u001c\b\u0006\u0002\u0002R\u0019^\u0003\"AU+\u000e\u0003MS!\u0001\u0016\u001e\u0002\u0007\u0005\u0004\u0018.\u0003\u0002W'\nAA)[:bE2,G-I\u0001Y\u0003-!\u0006N]3bI\u0002bW-Y6\u0002+Q,7\u000f^\"sK\u0006$X-T5se>\u0014Hk\u001c9jGR\u0019Qd\u0017/\t\u000b\u0011\u001a\u0001\u0019A\u0013\t\u000bE\u001a\u0001\u0019\u0001\u001a)\t\r1$i\u0011\u0015\u0005\u0007\u0019cu\fL\u0001O\u00035\"Xm\u001d;MSN$H)Z:de&\u0014W-T5se>\u0014x+\u001b;i_V$HK]1og&$\u0018n\u001c8FeJ|'o\u001d\u000b\u0004;\t\u001c\u0007\"\u0002\u0013\u0005\u0001\u0004)\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0004\u0006\u0002\u00037\u0005\u000eCC\u0001\u0002$MM2\na*\u0001\u0016uKN$H*[:u\t\u0016\u001c8M]5cK6K'O]8s/&$\b\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]:\u0015\u0007uI'\u000eC\u0003%\u000b\u0001\u0007Q\u0005C\u00032\u000b\u0001\u0007!\u0007\u000b\u0003\u0006m\t\u001b\u0005\u0006B\u0003G\u00196d\u0013AT\u0001\u0017i\u0016\u001cH\u000fT5ti\u0012+7o\u0019:jE\u0016l\u0015N\u001d:peR\u0011Q\u0004\u001d\u0005\u0006c\u001a\u0001\rAM\u0001\u001dS:\u001cG.\u001e3f'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0016\u0013(o\u001c:t\u0003\u001d\"Xm\u001d;EKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:XSRD'+\u001a9bSJl\u0015N\u001d:pe\u0016\u0013(o\u001c:\u0015\u0007u!X\u000fC\u0003%\u000f\u0001\u0007Q\u0005C\u00032\u000f\u0001\u0007!\u0007\u000b\u0003\bm\t\u001b\u0005\u0006B\u0004G\u0019bd\u0013AT\u0001\u0012i\u0016\u001cHOU3qY&\u001c\u0017m\u0015;biV\u001cHcA\u000f|y\")A\u0005\u0003a\u0001K!)\u0011\u0007\u0003a\u0001e!\"\u0001B\u000e\"DQ\u0011Aa\tT@-\u00039\u000ba\u0002^3tiB\u000bWo]3U_BL7\rF\u0003\u001e\u0003\u000b\t9\u0001C\u0003%\u0013\u0001\u0007Q\u0005C\u00032\u0013\u0001\u0007!\u0007\u000b\u0003\nm\t\u001b\u0005&B\u0005G\u0019\u00065A&\u0001(\u0002aQ,7\u000f^'fi\u0006$\u0017\r^1DC\u000eDW-\u00169eCR,wJ\\'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0015i\u00121CA\u000b\u0011\u0015!#\u00021\u0001&\u0011\u0019\t9B\u0003a\u0001e\u0005\u0011Ro]3MS:\\7i\\8sI&t\u0017\r^8sQ\u0011QaGQ\")\u000b)1E*!\b-\u00039\u000b\u0001\u0005^3ti6K'O]8sK\u0012$v\u000e]5d\u001b\u0006\u00148.\u001a3G_J$U\r\\3uKR)Q$a\t\u0002&!)Ae\u0003a\u0001K!)\u0011g\u0003a\u0001e!\"1B\u000e\"DQ\u0015Ya\tTA\u0016Y\u0005q\u0015\u0001\t;fgR\u001cFo\u001c9NSJ\u0014xN]!gi\u0016\u0014(I]8lKJ\u0014Vm\u001d;beR$R!HA\u0019\u0003gAQ\u0001\n\u0007A\u0002\u0015BQ!\r\u0007A\u0002IBC\u0001\u0004\u001cC\u0007\"*AB\u0012'\u0002:1\na\n\u000b\u0004\u0001\u0003{a\u00151\t\t\u0004%\u0006}\u0012bAA!'\n\u0019A+Y4\"\u0005\u0005\u0015\u0013aC5oi\u0016<'/\u0019;j_:Dc\u0001AA\u001f\u0019\u0006%\u0013EAA&\u0003M\u0011\u0017M_3muMD\u0017M\u001d3`G>,h\u000e\u001e\u001e6\u0001")
public class ClusterLinkControlPlaneMirrorResourceIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    @Disabled(value="Thread leak")
    public void testCreateMirrorTopicAndVerifySourceTopicId(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        if (this.isKraftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.sourceCluster().controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        }
        Uuid sourceTopicId = this.sourceCluster().describeTopic(this.topic()).topicId();
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        String x$15 = this.clusterLinkPrefix();
        Map<String, String> x$16 = qual$2.linkTopic$default$4();
        CreateTopicsResult result = qual$2.linkTopic(x$12, x$13, x$14, x$16, x$15);
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        if (this.isKraftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.destCluster().brokers(), this.destCluster().controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        }
        ((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().clusterLinkMetadataManager().exists((Function1 & Serializable)manager -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testCreateMirrorTopicAndVerifySourceTopicId$1(this, sourceTopicId, manager)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateMirrorTopic(String quorum, boolean coordinator) {
        String retentionMs = "10000";
        Properties configs = new Properties();
        configs.put("retention.ms", retentionMs);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$22 = this.numPartitions();
        short x$32 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$22, x$32, configs, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$122 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        String x$15 = this.clusterLinkPrefix();
        Map<String, String> x$16 = qual$2.linkTopic$default$4();
        CreateTopicsResult result = qual$2.linkTopic(x$122, x$13, x$14, x$16, x$15);
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((Object)retentionMs, (Object)((Config)result.config(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()).get("retention.ms").value());
        Config topicConfig = this.destCluster().describeTopicConfig(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertEquals((Object)retentionMs, (Object)topicConfig.get("retention.ms").value());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())) && quorum.equals("zk")) {
            this.verifyLinkWithClusterLinkPrefixCountMetric(1, this.linkName(), (Option<String>)None$.MODULE$);
        }
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Option<String> x$18 = qual$3.listClusterLinks$default$2();
        Seq<ClusterLinkListing> listing = qual$3.listClusterLinks(true, x$18);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkListing)((IterableOps)listing.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testCreateMirrorTopic$1(this, x$1)))).head()).topics().get()).asScala().toSet());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        Option<String> x$20 = qual$4.describeClusterLinks$default$2();
        int x$21 = qual$4.describeClusterLinks$default$3();
        boolean x$222 = qual$4.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> description = qual$4.describeClusterLinks(true, x$20, x$21, x$222);
        Assertions.assertTrue((boolean)((IterableOnceOps)description.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testCreateMirrorTopic$2(this, x$2)))).nonEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((ClusterLinkDescription)((IterableOps)description.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testCreateMirrorTopic$3(this, x$3)))).head()).topics().get()).asScala().toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testListDescribeMirrorWithoutTransitionErrors(String quorum, boolean coordinator) {
        this.testListDescribeMirror(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testListDescribeMirrorWithTransitionErrors(String quorum, boolean coordinator) {
        this.testListDescribeMirror(true);
    }

    /*
     * WARNING - void declaration
     */
    public void testListDescribeMirror(boolean includeStateTransitionErrors) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        boolean x$7 = qual$2.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$2.listMirrorTopics(x$7));
        Uuid uuid = Uuid.ZERO_UUID;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            try {
                uuid = this.sourceCluster().describeTopic(this.topic()).topicId();
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$8 = this.topic();
        String x$10 = this.linkName();
        Map<String, String> x$11 = qual$3.linkTopic$default$4();
        String x$12 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$8, (short)2, x$10, x$11, x$12);
        long l2 = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l3 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$3(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                    Object var88_24 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l3);
                l3 += package$.MODULE$.min(l3, 1000L);
                continue;
            }
            break;
        }
        Object var40_21 = null;
        Object var45_26 = null;
        MirrorTopicDescription mirrorTopicDescription = null;
        long l4 = 15000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l5 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                try {
                    mirrorTopicDescription = this.destCluster().describeMirrorTopic(this.topic(), includeStateTransitionErrors);
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    Assertions.fail((String)"Failed to describe mirror topic");
                }
                Assertions.assertNotNull((Object)mirrorTopicDescription);
                Assertions.assertEquals((Object)uuid, (Object)mirrorTopicDescription.sourceTopicId());
                Assertions.assertEquals((Object)this.linkName(), (Object)mirrorTopicDescription.linkName());
                Assertions.assertEquals((Object)this.topic(), (Object)mirrorTopicDescription.sourceTopic());
                Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)mirrorTopicDescription.state());
                Assertions.assertTrue((mirrorTopicDescription.stateTimeMs() > 0L ? 1 : 0) != 0);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                    Object var89_32 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l5);
                l5 += package$.MODULE$.min(l5, 1000L);
                continue;
            }
            break;
        }
        Object var46_29 = null;
        Object var51_34 = null;
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$14 = this.topic();
        String x$15 = this.linkName();
        boolean x$16 = qual$5.unlinkTopic$default$3();
        boolean x$17 = qual$5.unlinkTopic$default$4();
        boolean x$18 = qual$5.unlinkTopic$default$5();
        int x$19 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$14, x$15, x$16, x$17, x$18, x$19);
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$5(this, includeStateTransitionErrors)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Mirror took too long to stop.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l7 = 15000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkTestHarness $anonfun$testListDescribeMirror$7_qual$6 = this.destCluster();
                boolean $anonfun$testListDescribeMirror$7_x$20 = $anonfun$testListDescribeMirror$7_qual$6.listMirrorTopics$default$1();
                Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), $anonfun$testListDescribeMirror$7_qual$6.listMirrorTopics($anonfun$testListDescribeMirror$7_x$20));
                Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(true));
                mirrorTopicDescription = this.destCluster().describeMirrorTopic(this.topic(), includeStateTransitionErrors);
                Assertions.assertEquals((Object)mirrorTopicDescription.state(), (Object)MirrorTopicDescription.State.STOPPED);
                Assertions.assertEquals((Object)uuid, (Object)mirrorTopicDescription.sourceTopicId());
                Assertions.assertTrue((mirrorTopicDescription.stateTimeMs() > 0L ? 1 : 0) != 0);
                Object var94_52 = null;
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    Object var90_51 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += package$.MODULE$.min(l8, 1000L);
                continue;
            }
            break;
        }
        Object var58_46 = null;
        Object var63_50 = null;
        this.destCluster().deleteTopic(this.topic(), true);
        long l9 = 15000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        long l10 = 1L;
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$8(this, includeStateTransitionErrors);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l10).append(", and then retrying.").toString();
                    Object var91_60 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l10);
                l10 += package$.MODULE$.min(l10, 1000L);
                continue;
            }
            break;
        }
        Object var64_55 = null;
        Object var69_59 = null;
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$21 = this.topic();
        String x$23 = this.linkName();
        Map<String, String> x$24 = qual$7.linkTopic$default$4();
        String x$25 = qual$7.linkTopic$default$5();
        qual$7.linkTopic(x$21, (short)2, x$23, x$24, x$25);
        long l11 = 15000L;
        TestUtils$ retry_this5 = TestUtils$.MODULE$;
        long l12 = 1L;
        long retry_startTime5 = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$10(this, includeStateTransitionErrors);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime5 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this5.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l12).append(", and then retrying.").toString();
                    Object var92_72 = null;
                    retry_this5.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this5, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l12);
                l12 += package$.MODULE$.min(l12, 1000L);
                continue;
            }
            break;
        }
        Object var70_67 = null;
        Object var75_71 = null;
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$27 = this.topic();
        boolean x$28 = qual$9.pauseTopic$default$2();
        qual$9.pauseTopic(x$27, x$28);
        long l13 = 15000L;
        TestUtils$ retry_this6 = TestUtils$.MODULE$;
        long l14 = 1L;
        long retry_startTime6 = System.currentTimeMillis();
        while (true) {
            try {
                mirrorTopicDescription = this.destCluster().describeMirrorTopic(this.topic(), includeStateTransitionErrors);
                Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)mirrorTopicDescription.state());
                Assertions.assertEquals((Object)uuid, (Object)mirrorTopicDescription.sourceTopicId());
                Assertions.assertTrue((mirrorTopicDescription.stateTimeMs() > 0L ? 1 : 0) != 0);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime6 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this6.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l14).append(", and then retrying.").toString();
                    Object var93_82 = null;
                    retry_this6.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this6, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l14);
                l14 += package$.MODULE$.min(l14, 1000L);
                continue;
            }
            break;
        }
        Object var76_77 = null;
        Object var81_81 = null;
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$10 = this.destCluster();
        String x$29 = this.linkName();
        Seq<KafkaBroker> x$31 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(x$29, true, x$31);
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testListDescribeMirror$12(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Mirror state not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDescribeMirrorWithRepairMirrorError(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArraySerializer x$7 = qual$2.createProducer$default$1();
        ByteArraySerializer x$8 = qual$2.createProducer$default$2();
        Properties x$9 = qual$2.createProducer$default$3();
        KafkaProducer producer = qual$2.createProducer(x$7, x$8, x$9);
        this.produceRecords(producer, this.topic(), numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        this.destCluster().alterBrokerConfig((Option<String>)None$.MODULE$, "confluent.cluster.link.mirror.transition.batch.size", "2");
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.topic();
        short x$11 = this.replicationFactor();
        String x$12 = this.linkName();
        Map<String, String> x$13 = qual$3.linkTopic$default$4();
        String x$14 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$10, x$11, x$12, x$13, x$14);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.MaxMessageSizeProp()), (Object)"1000")}))));
        this.produceRecords(producer, this.topic(), numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        byte[] value = TestUtils.randomBytes((int)1100);
        String x$16 = this.topic();
        Some x$18 = new Some((Object)value);
        Function1<Object, String> x$19 = this.produceRecords$default$4();
        Option<Object> x$20 = this.produceRecords$default$6();
        this.produceRecords(producer, x$16, 1, x$19, (Option<byte[]>)x$18, x$20);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        Properties x$21 = qual$4.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$4.createConfluentAdminClient(x$21), FailureType$.MODULE$.RecordTooLarge(), this.waitForFailure$default$3());
        ClusterLinkBatchAdmin batchAdmin = (ClusterLinkBatchAdmin)TestUtils.fieldValue((Object)this.repairMirrorsTask(this.linkName(), linkId), ClusterLinkRepairMirrors.class, (String)"localAdmin");
        Function0 & Serializable localAdmin = (Function0 & Serializable)() -> CloudAdmin.create((Properties)new Properties());
        TestUtils.setFieldValue((Object)batchAdmin, (String)"admin", (Object)localAdmin);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.MaxMessageSizeProp()), (Object)"10000")}))));
        this.destCluster().alterMirrors(this.topic(), AlterMirrorOp.REPAIR);
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testDescribeMirrorWithRepairMirrorError$2(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var39_38 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testReplicaStatus(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        qual$1 = this.sourceCluster();
        x$1 = this.topic();
        x$2 = this.numPartitions();
        x$3 = this.replicationFactor();
        x$4 = qual$1.createTopic$default$4();
        x$5 = qual$1.createTopic$default$5();
        x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        rs1 = this.sourceCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)2, (int)rs1.size());
        leader1 = (ReplicaStatus)((IterableOps)rs1.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$1$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)leader1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)leader1.mirrorInfo());
        follower1 = (ReplicaStatus)((IterableOps)rs1.filterNot((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$2$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)follower1.mirrorInfo());
        timestamp = Time.SYSTEM.milliseconds();
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        qual$2 = this.destCluster();
        x$7 = this.topic();
        x$8 = this.replicationFactor();
        x$9 = this.linkName();
        x$10 = qual$2.linkTopic$default$4();
        x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        expectedLeaderEpoch = this.destCluster().isKRaftTest() != false ? 0 : 1;
        var53_21 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$3(this, expectedLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Destination leader epoch not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs2 = this.destCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)4, (int)rs2.size());
        localLeader2 = (ReplicaStatus)((IterableOps)rs2.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$5$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)localLeader2.mirrorInfo().isPresent());
        mi2 = (ReplicaStatus.MirrorInfo)localLeader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi2.state());
        Assertions.assertTrue((boolean)(timestamp <= mi2.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(timestamp).append(" <= ").append(mi2.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)numRecords, (long)mi2.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        localFollower2 = (ReplicaStatus)((IterableOps)rs2.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$6$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)localFollower2.mirrorInfo());
        remoteLeader2 = (ReplicaStatus)((IterableOps)rs2.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$7$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteLeader2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteLeader2.mirrorInfo());
        remoteFollower2 = (ReplicaStatus)((IterableOps)rs2.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$8$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteFollower2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteFollower2.mirrorInfo());
        lastFetchTimeMs = mi2.lastFetchTimeMs();
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs3 = this.destCluster().replicaStatus(this.topic(), 0, false);
        Assertions.assertEquals((int)2, (int)rs3.size());
        leader3 = (ReplicaStatus)((IterableOps)rs3.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$9$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader3.mirrorInfo().isPresent());
        mi3 = (ReplicaStatus.MirrorInfo)leader3.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi3.state());
        Assertions.assertTrue((boolean)(lastFetchTimeMs <= mi3.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(lastFetchTimeMs).append(" <= ").append(mi3.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)(numRecords * 2), (long)mi3.lastFetchSourceHighWatermark());
        follower3 = (ReplicaStatus)((IterableOps)rs3.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$10$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower3.mirrorInfo());
        qual$3 = this.destCluster();
        x$12 = this.topic();
        x$13 = this.linkName();
        x$14 = this.numPartitions();
        x$15 = qual$3.unlinkTopic$default$3();
        x$16 = qual$3.unlinkTopic$default$4();
        x$17 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$16, x$17, x$14);
        var59_43 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((var63_46 = this.destCluster().replicaStatus(this.topic(), 0, true)).size() == 2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link not removed from topic's partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leader4 = (ReplicaStatus)((IterableOps)var63_46.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$13$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader4.mirrorInfo().isPresent());
        mi4 = (ReplicaStatus.MirrorInfo)leader4.mirrorInfo().get();
        v0 = mi4.state();
        var44_49 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        if (!(v0 == null ? var44_49 != null : v0.equals(var44_49) == false)) ** GOTO lbl-1000
        v1 = mi4.state();
        var45_50 = ReplicaStatus.MirrorInfo.State.STOPPED;
        if (!(v1 != null ? v1.equals(var45_50) == false : var45_50 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchTimeMs());
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        follower4 = (ReplicaStatus)((IterableOps)var63_46.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$14$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower4.mirrorInfo());
        qual$4 = this.destCluster();
        x$18 = this.linkName();
        x$19 = qual$4.deleteClusterLink$default$2();
        x$20 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$18, x$19, x$20);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testPauseTopic(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$8 = qual$2.pauseTopic$default$2();
            qual$2.pauseTopic(x$7, x$8);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$9 = this.topic();
        short x$10 = this.replicationFactor();
        String x$11 = this.linkName();
        String x$12 = this.clusterLinkPrefix();
        Map<String, String> x$13 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$9, x$10, x$11, x$13, x$12);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$15 = qual$4.pauseTopic$default$2();
        qual$4.pauseTopic(x$14, x$15);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$17 = qual$5.pauseTopic$default$2();
        qual$5.pauseTopic(x$16, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testPauseTopic$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic's partitions not paused");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyMirrorTopicCountMetric("mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)"PausedMirror")}))), this.verifyMirrorTopicCountMetric$default$3(), this.verifyMirrorTopicCountMetric$default$4());
        Seq oldLeaderOffsets = this.leaderOffsets$1();
        this.produceToSourceCluster(8);
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)oldLeaderOffsets, (Object)this.leaderOffsets$1());
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$23 = qual$7.replicaStatus$default$3();
            Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)((ReplicaStatus.MirrorInfo)((ReplicaStatus)((IterableOps)qual$7.replicaStatus(x$21, partition, x$23).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isLeader()))).head()).mirrorInfo().get()).state());
        });
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$24 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$25 = this.linkName();
        boolean x$26 = qual$8.unlinkTopic$default$3();
        boolean x$27 = qual$8.unlinkTopic$default$4();
        boolean x$28 = qual$8.unlinkTopic$default$5();
        int x$29 = qual$8.unlinkTopic$default$6();
        qual$8.unlinkTopic(x$24, x$25, x$26, x$27, x$28, x$29);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$9 = this.destCluster();
            String x$30 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$31 = qual$9.pauseTopic$default$2();
            qual$9.pauseTopic(x$30, x$31);
        });
        ClusterLinkTestHarness qual$10 = this.destCluster();
        String x$32 = this.linkName();
        boolean x$33 = qual$10.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$34 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(x$32, x$33, x$34);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMetadataCacheUpdateOnMirrorTopicStateChanges(String quorum, boolean useLinkCoordinator) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMetadataCacheUpdateOnMirrorTopicStateChanges$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"LinkCoordinator is supported one or more brokers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty("retry.backoff.ms", "1000");
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "5000");
        linkProps.setProperty("default.api.timeout.ms", "5000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        Uuid linkId = this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$2.linkTopic$default$4();
        String x$16 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$12, x$13, x$14, x$15, x$16);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.destCluster().killBroker(0);
        this.destCluster().restartDeadBroker(0, true);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$17 = this.topic();
        boolean x$18 = qual$3.pauseTopic$default$2();
        qual$3.pauseTopic(x$17, x$18);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkPausedMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkFailedMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.destCluster().deleteTopic(this.topic(), true);
        this.waitForTopicDeletionInMetadataCache(this.topic(), this.waitForTopicDeletionInMetadataCache$default$2());
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$19 = this.topic();
        int x$20 = this.numPartitions();
        short x$21 = this.replicationFactor();
        Properties x$22 = qual$4.createTopic$default$4();
        ListenerName x$23 = qual$4.createTopic$default$5();
        Properties x$24 = qual$4.createTopic$default$6();
        qual$4.createTopic(x$19, x$20, x$21, x$22, x$23, x$24);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$25 = this.topic();
        short x$26 = this.replicationFactor();
        String x$27 = this.linkName();
        Map<String, String> x$28 = qual$5.linkTopic$default$4();
        String x$29 = qual$5.linkTopic$default$5();
        qual$5.linkTopic(x$25, x$26, x$27, x$28, x$29);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$30 = this.topic();
        String x$31 = this.linkName();
        boolean x$33 = qual$6.unlinkTopic$default$3();
        boolean x$34 = qual$6.unlinkTopic$default$4();
        int x$35 = qual$6.unlinkTopic$default$6();
        qual$6.unlinkTopic(x$30, x$31, x$33, x$34, false, x$35);
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkPendingStoppedMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PENDING_STOPPED);
        this.restartSource(this.restartSource$default$1());
        this.waitForMetadataCacheUpdate(this.topic(), linkId, this.linkName(), (TopicLinkState)TopicLinkStoppedMirror$.MODULE$, this.waitForMetadataCacheUpdate$default$5(), this.waitForMetadataCacheUpdate$default$6());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$36 = this.linkName();
        boolean x$37 = qual$7.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$38 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$36, x$37, x$38);
        this.waitUntilMirrorStateIsCleared(this.topic(), this.waitUntilMirrorStateIsCleared$default$2());
        this.destCluster().deleteTopic(this.topic(), true);
        this.waitForTopicDeletionInMetadataCache(this.topic(), this.waitForTopicDeletionInMetadataCache$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirroredTopicMarkedForDelete(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$92 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$92, x$11, x$10);
        IndexedSeq partitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$1(this, BoxesRunTime.unboxToInt((Object)i)));
        int brokerId = this.destCluster().shutdownLeader((TopicPartition)partitions.head())._1$mcI$sp();
        scala.collection.immutable.Seq otherBrokers = ((IterableOnceOps)this.destCluster().brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$2(brokerId, x$9)))).toSeq();
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        otherBrokers.foreach((Function1 & Serializable)broker -> {
            ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$3(partitions, linkId, broker);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        boolean x$14 = qual$3.deleteClusterLink$default$2();
        qual$3.deleteClusterLink(x$12, x$14, (Seq<KafkaBroker>)otherBrokers);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirrorAfterBrokerRestart(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        int numRecords = 10;
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter("*")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"10000")}))));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.createConsumerAndCommitOffsets$1(this.sourceCluster(), numRecords, tp);
        Consumer destConsumer = this.createConsumerAndCommitOffsets$1(this.destCluster(), numRecords, tp);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$4();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$16, false, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PENDING_STOPPED);
        this.destCluster().killAllBrokers();
        destConsumer.close();
        this.restartDestination();
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        ListenerName x$18 = qual$4.createAdminClient$default$1();
        Properties x$19 = qual$4.createAdminClient$default$2();
        long committedOffset = ((OffsetAndMetadata)((java.util.Map)qual$4.createAdminClient(x$18, x$19).listConsumerGroupOffsets("group").partitionsToOffsetAndMetadata().get(15L, TimeUnit.SECONDS)).get(tp)).offset();
        Assertions.assertEquals((long)numRecords, (long)committedOffset);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$20 = this.linkName();
        boolean x$21 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$22 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$20, x$21, x$22);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopicAndVerifySourceTopicId$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, Uuid sourceTopicId$1, Tuple2 keyVal) {
        Object object = keyVal._1();
        String string = new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            Uuid uuid = ((ClusterLinkTopicState)keyVal._2()).sourceTopicId();
            if (!(uuid != null ? !uuid.equals(sourceTopicId$1) : sourceTopicId$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopicAndVerifySourceTopicId$1(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, Uuid sourceTopicId$1, ClusterLinkMetadataManager manager) {
        return manager.mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()}))).exists((Function1 & Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testCreateMirrorTopicAndVerifySourceTopicId$2($this, sourceTopicId$1, keyVal)));
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$1(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ClusterLinkListing x$1) {
        String string = x$1.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ClusterLinkDescription x$2) {
        String string = x$2.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$3(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ClusterLinkDescription x$3) {
        String string = x$3.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$1(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ObjectRef sourceTopicId$2) {
        try {
            sourceTopicId$2.elem = $this.sourceCluster().describeTopic($this.topic()).topicId();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        return new StringBuilder(19).append("Failed to describe ").append($this.topic()).toString();
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$3(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        ClusterLinkTestHarness qual$4 = $this.destCluster();
        boolean x$13 = qual$4.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.topic()})), qual$4.listMirrorTopics(x$13));
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$4(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ObjectRef desc$1, boolean includeStateTransitionErrors$1, ObjectRef sourceTopicId$2) {
        try {
            desc$1.elem = $this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1);
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            Assertions.fail((String)"Failed to describe mirror topic");
        }
        Assertions.assertNotNull((Object)((MirrorTopicDescription)desc$1.elem));
        Assertions.assertEquals((Object)((Uuid)sourceTopicId$2.elem), (Object)((MirrorTopicDescription)desc$1.elem).sourceTopicId());
        Assertions.assertEquals((Object)$this.linkName(), (Object)((MirrorTopicDescription)desc$1.elem).linkName());
        Assertions.assertEquals((Object)$this.topic(), (Object)((MirrorTopicDescription)desc$1.elem).sourceTopic());
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)((MirrorTopicDescription)desc$1.elem).state());
        Assertions.assertTrue((((MirrorTopicDescription)desc$1.elem).stateTimeMs() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$5(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, boolean includeStateTransitionErrors$1) {
        MirrorTopicDescription.State state = $this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$6() {
        return "Mirror took too long to stop.";
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$7(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ObjectRef desc$1, boolean includeStateTransitionErrors$1, ObjectRef sourceTopicId$2) {
        ClusterLinkTestHarness qual$6 = $this.destCluster();
        boolean x$20 = qual$6.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$6.listMirrorTopics(x$20));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.topic()})), $this.destCluster().listMirrorTopics(true));
        desc$1.elem = $this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1);
        Assertions.assertEquals((Object)((MirrorTopicDescription)desc$1.elem).state(), (Object)MirrorTopicDescription.State.STOPPED);
        Assertions.assertEquals((Object)((Uuid)sourceTopicId$2.elem), (Object)((MirrorTopicDescription)desc$1.elem).sourceTopicId());
        Assertions.assertTrue((((MirrorTopicDescription)desc$1.elem).stateTimeMs() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$8(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, boolean includeStateTransitionErrors$1) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), $this.destCluster().listMirrorTopics(true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> $this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1));
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$10(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, boolean includeStateTransitionErrors$1) {
        ClusterLinkTestHarness qual$8 = $this.destCluster();
        boolean x$26 = qual$8.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.topic()})), qual$8.listMirrorTopics(x$26));
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)$this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1).state());
    }

    public static final /* synthetic */ void $anonfun$testListDescribeMirror$11(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ObjectRef desc$1, boolean includeStateTransitionErrors$1, ObjectRef sourceTopicId$2) {
        desc$1.elem = $this.destCluster().describeMirrorTopic($this.topic(), includeStateTransitionErrors$1);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)((MirrorTopicDescription)desc$1.elem).state());
        Assertions.assertEquals((Object)((Uuid)sourceTopicId$2.elem), (Object)((MirrorTopicDescription)desc$1.elem).sourceTopicId());
        Assertions.assertTrue((((MirrorTopicDescription)desc$1.elem).stateTimeMs() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$12(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics(true).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$13() {
        return "Mirror state not removed";
    }

    public static final /* synthetic */ void $anonfun$testDescribeMirrorWithRepairMirrorError$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        MirrorTopicDescription descWithTransitionErrors = $this.destCluster().describeMirrorTopic($this.topic(), true);
        Assertions.assertNotNull((Object)descWithTransitionErrors);
        List transitionErrors = descWithTransitionErrors.mirrorStateTransitionErrors();
        String errMsg = Predef$.MODULE$.Integer2int($this.destCluster().linkCoordinator($this.linkName()).config().clusterLinkAdminRequestBatchSize()) > 1 ? "Failed to get replicas status of mirror partitions for an unknown reason." : "Failed to repair the failed mirror for an unknown reason.";
        Assertions.assertEquals(Collections.singletonList(new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR, errMsg)), (Object)transitionErrors);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$3(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, int expectedLeaderEpoch$1) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$4() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$5(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$6(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$7(ReplicaStatus rs) {
        return rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$8(ReplicaStatus rs) {
        return !rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$9(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$10(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$11(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, ObjectRef rs4$1) {
        rs4$1.elem = $this.destCluster().replicaStatus($this.topic(), 0, true);
        return ((Seq)rs4$1.elem).size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$12() {
        return "Cluster link not removed from topic's partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$13(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$14(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$5(ReplicaStatus.MirrorInfo mi) {
        ReplicaStatus.MirrorInfo.State state = mi.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PAUSED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.numPartitions()).forall((Function1)(JFunction1.mcZI.sp & Serializable)partition -> {
            ClusterLinkTestHarness qual$6 = $this.destCluster();
            String x$18 = new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString();
            boolean x$20 = qual$6.replicaStatus$default$3();
            return Option$.MODULE$.apply(((ReplicaStatus)((IterableOps)qual$6.replicaStatus(x$18, partition, x$20).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeader()))).head()).mirrorInfo().orElse(null)).exists((Function1 & Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testPauseTopic$5(mi)));
        });
    }

    public static final /* synthetic */ String $anonfun$testPauseTopic$6() {
        return "Topic's partitions not paused";
    }

    private final Seq leaderOffsets$1() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)(JFunction1.mcJI.sp & Serializable)partition -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$3 = qual$1.replicaStatus$default$3();
            return ((ReplicaStatus)((IterableOps)qual$1.replicaStatus(x$1, partition, x$3).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isLeader()))).head()).logEndOffset();
        }).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataCacheUpdateOnMirrorTopicStateChanges$2(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, KafkaBroker server) {
        return server.metadataCache().linkCoordinatorEnabled() == $this.testRunsWithLinkCoordinator();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataCacheUpdateOnMirrorTopicStateChanges$1(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this) {
        return $this.destCluster().aliveServers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMetadataCacheUpdateOnMirrorTopicStateChanges$2($this, server)));
    }

    public static final /* synthetic */ String $anonfun$testMetadataCacheUpdateOnMirrorTopicStateChanges$3() {
        return "LinkCoordinator is supported one or more brokers";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirroredTopicMarkedForDelete$1(ClusterLinkControlPlaneMirrorResourceIntegrationTest $this, int i) {
        return new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), i);
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$2(int brokerId$1, KafkaBroker x$9) {
        return x$9.config().brokerId() != brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$4(IndexedSeq partitions$1, KafkaBroker broker$1) {
        return ((SeqOps)partitions$1.flatMap((Function1 & Serializable)tp -> broker$1.replicaManager().onlinePartition(tp))).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$6() {
        return "Partitions not offline after topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$7(KafkaBroker broker$1, Uuid linkId$1) {
        return ((ClusterLinkFetcherManager)broker$1.clusterLinkManager().fetcherManager(linkId$1).get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$8() {
        return "Fetcher manager not empty after topic deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMirroredTopicMarkedForDelete$3(IndexedSeq partitions$1, Uuid linkId$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$4(partitions$1, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Partitions not offline after topic deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$7(broker, linkId$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Fetcher manager not empty after topic deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private final Consumer createConsumerAndCommitOffsets$1(ClusterLinkTestHarness cluster, int numRecords$1, TopicPartition tp$1) {
        cluster.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        cluster.consumerConfig().setProperty("session.timeout.ms", "6000");
        Consumer consumer = cluster.createConsumer(cluster.createConsumer$default$1(), cluster.createConsumer$default$2(), cluster.createConsumer$default$3(), cluster.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(this.topic()));
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, numRecords$1, 15000L);
        consumer.commitSync(Collections.singletonMap(tp$1, new OffsetAndMetadata((long)(numRecords$1 * 2))));
        return consumer;
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$1$adapted(ReplicaStatus x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$2$adapted(ReplicaStatus x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$5$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$5(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$6$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$6(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$7$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$7(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$8$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$8(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$9$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$9(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$10$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$10(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$13$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$13(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$14$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkControlPlaneMirrorResourceIntegrationTest.$anonfun$testReplicaStatus$14(rs));
    }
}

