/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.controller.ClusterLinkControlManager;
import org.apache.kafka.controller.QuorumController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u0011BQ\u0001\u0011\u0001\u0005\u0002\u0005CQ!\u0015\u0001\u0005\nICQA\u001f\u0001\u0005\nmDq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005\"CAN\u0001E\u0005I\u0011AAO\u0011%\t\t\fAI\u0001\n\u0003\ti\nC\u0004\u00024\u0002!\t!!.\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003_D\u0011\"a=\u0001#\u0003%\t!!>\t\u0013\u0005e\b!%A\u0005\u0002\u0005m(\u0001J\"mkN$XM\u001d'j].\u001cuN\u001c;s_2dWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005Q)\u0012\u0001\u00027j].T\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003M\ta\u0003^3ti\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwm\u001d\u000b\u0003K!\u0002\"A\u0007\u0014\n\u0005\u001dZ\"\u0001B+oSRDQ!\u000b\u0002A\u0002)\nqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[U\tA\u0001^3ti&\u0011q\u0006\f\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\"B!!M\u001c9{yzd\b\u0005\u00023k5\t1G\u0003\u00025Y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001a$aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\n\u0011(\u0003\u0002;w\u0005)1JU!G)*\u0011AhM\u0001\u0005)f\u0004X-A\u0004ce>\\WM]:\u001e\u0003\u0005\t1bY8oiJ|G\u000e\\3sg\u0006qC/Z:u\u00072,8\u000f^3s'R\fG/Z(o\u0003\u000e$\u0018N^3D_:$(o\u001c7mKJ\fe\u000e\u001a$pY2|w/\u001a:t)\t)#\tC\u0003*\u0007\u0001\u0007!\u0006\u000b\u0006\u0004c]BTHP E\u000b\u001ak\u0012aA\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNd\u0013aR\u0016\u0006\u0011.cej\u0014\t\u0003e%K!AS\u001a\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u00035\u000bQe\u0019:fCR,gf\u00197vgR,'O\f7j].t\u0003o\u001c7jGft3\r\\1tg:r\u0017-\\3\u0002\u000bY\fG.^3\"\u0003A\u000bae[1gW\u0006tC.\u001b8l]Q+7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWB{G.[2z\u0003=\u0011\u0018M\u001a;D_:$(o\u001c7mKJ\u001cHCA*k!\r!Fl\u0018\b\u0003+js!AV-\u000e\u0003]S!\u0001W\f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0012BA.\u001c\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00180\u0003\t1K7\u000f\u001e\u0006\u00037n\u0001\"\u0001\u00195\u000e\u0003\u0005T!AY2\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0017I*\u0011QMZ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\f1a\u001c:h\u0013\tI\u0017M\u0001\tRk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe\")\u0011\u0006\u0002a\u0001WB\u0011An\u001e\b\u0003[Rt!A\u001c:\u000f\u0005=\fhB\u0001,q\u0013\u00051\u0012BA\u0017\u0016\u0013\t\u0019H&A\u0003kk:LG/\u0003\u0002vm\u0006a\"+\u00194u\u00072,8\u000f^3s\u0013:4xnY1uS>t7i\u001c8uKb$(BA:-\u0013\tA\u0018PA\nSC\u001a$8\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cWM\u0003\u0002vm\u0006I\u0012m]:feR\u001cuN\u001c;s_2l\u0015M\\1hKJ\u001cF/\u0019;f)\u0011)C0!\u000b\t\u000bu,\u0001\u0019\u0001@\u0002\u000b1Lgn[:\u0011\u0007Qcv\u0010\u0005\u0003\u0002\u0002\u0005\rb\u0002BA\u0002\u0003;qA!!\u0002\u0002\u00189!\u0011qAA\n\u001d\u0011\tI!!\u0005\u000f\t\u0005-\u0011q\u0002\b\u0004-\u00065\u0011\"A4\n\u0005\u00154\u0017B\u0001\fe\u0013\r\t)bY\u0001\u0007G>lWn\u001c8\n\t\u0005e\u00111D\u0001\b[\u0016\u001c8/Y4f\u0015\r\t)bY\u0005\u0005\u0003?\t\t#A\u000fDe\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b\u0015\u0011\tI\"a\u0007\n\t\u0005\u0015\u0012q\u0005\u0002\n\u000b:$(/\u001f#bi\u0006TA!a\b\u0002\"!9\u00111F\u0003A\u0002\u00055\u0012!G2mkN$XM\u001d'j].\u001cuN\u001c;s_2l\u0015M\\1hKJ\u00042\u0001YA\u0018\u0013\r\t\t$\u0019\u0002\u001a\u00072,8\u000f^3s\u0019&t7nQ8oiJ|G.T1oC\u001e,'/\u0001\ruKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$X\rT5oWN$2!JA\u001c\u0011\u0015Ic\u00011\u0001lQ!1\u0011g\u000e\u001d>}}r\u0014a\b;fgR\u001cv.\u001e:dK&s\u0017\u000e^5bi\u0016$G*\u001b8l\u0007J,\u0017\r^5p]R\u0019Q%a\u0010\t\u000b%:\u0001\u0019A6)\u0011\u001d\tt\u0007O\u001f?\u007fy\nqd]3oI\u000e{g\u000e\u001e:pY2,'o\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)\u0019\t9%!\u001b\u0002tAA\u0011\u0011JA)\u0003/\niF\u0004\u0003\u0002L\u00055\u0003C\u0001,\u001c\u0013\r\tyeG\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0004\u001b\u0006\u0004(bAA(7A!\u0011\u0011JA-\u0013\u0011\tY&!\u0016\u0003\rM#(/\u001b8h!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$\u0002BA2\u00037\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003O\n\tG\u0001\u0004FeJ|'o\u001d\u0005\b\u0003WB\u0001\u0019AA7\u0003!a\u0017N\\6ECR\f\u0007\u0003\u0002+\u0002p}L1!!\u001d_\u0005\r\u0019V-\u001d\u0005\u0007E\"\u0001\r!!\u001e\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001f\u0016\u0003\u001dqW\r^<pe.LA!a \u0002z\ta1k\\2lKR\u001cVM\u001d<fe\u0006)2/\u001a8e\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\GCCA$\u0003\u000b\u000bY)!$\u0002\u0018\"9\u0011qQ\u0005A\u0002\u0005%\u0015!\u00037j].t\u0015-\\3t!\u0015!\u0016qNA,\u0011\u0019\u0011\u0017\u00021\u0001\u0002v!I\u0011qR\u0005\u0011\u0002\u0003\u0007\u0011\u0011S\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\t\u00045\u0005M\u0015bAAK7\t9!i\\8mK\u0006t\u0007\"CAM\u0013A\u0005\t\u0019AAI\u0003\u00151wN]2f\u0003}\u0019XM\u001c3EK2,G/Z\"mkN$XM\u001d'j].$C-\u001a4bk2$HeM\u000b\u0003\u0003?SC!!%\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000bi+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GM\u0003\u000257%!\u0011qVAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001 g\u0016tG\rR3mKR,7\t\\;ti\u0016\u0014H*\u001b8lI\u0011,g-Y;mi\u0012\"\u0014\u0001E:f]\u0012\fE\u000e^3s\u0007>tg-[4t)!\t9%a.\u0002<\u0006\u0005\u0007bBA]\u0019\u0001\u0007\u0011qK\u0001\tY&t7NT1nK\"9\u0011Q\u0018\u0007A\u0002\u0005}\u0016aB2p]\u001aLwm\u001d\t\t\u0003\u0013\n\t&a\u0016\u0002X!1!\r\u0004a\u0001\u0003k\n1b\u00197vgR,'\u000fT5oWRYq0a2\u0002J\u00065\u0017qZAq\u0011\u001d\tI,\u0004a\u0001\u0003/B\u0011\"a3\u000e!\u0003\u0005\r!a\u0016\u0002\u0013\rdWo\u001d;fe&#\u0007\"CA_\u001bA\u0005\t\u0019AA`\u0011%\t\t.\u0004I\u0001\u0002\u0004\t\u0019.\u0001\u0004mS:\\\u0017\n\u001a\t\u00065\u0005U\u0017\u0011\\\u0005\u0004\u0003/\\\"AB(qi&|g\u000e\u0005\u0003\u0002\\\u0006uWBAA\u000e\u0013\u0011\ty.a\u0007\u0003\tU+\u0018\u000e\u001a\u0005\n\u0003Gl\u0001\u0013!a\u0001\u0003K\fa\u0001^3oC:$\b#\u0002\u000e\u0002V\u0006]\u0013!F2mkN$XM\u001d'j].$C-\u001a4bk2$HEM\u000b\u0003\u0003WTC!a\u0016\u0002\"\u0006)2\r\\;ti\u0016\u0014H*\u001b8lI\u0011,g-Y;mi\u0012\u001aTCAAyU\u0011\ty,!)\u0002+\rdWo\u001d;fe2Kgn\u001b\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u001f\u0016\u0005\u0003'\f\t+A\u000bdYV\u001cH/\u001a:MS:\\G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u(\u0006BAs\u0003CCc\u0001\u0001B\u0001\u001d\n]\u0001\u0003\u0002B\u0002\u0005'i!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\nKb$XM\\:j_:TAAa\u0003\u0003\u000e\u0005\u0019\u0011\r]5\u000b\t\t=!\u0011C\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019h-\u0003\u0003\u0003\u0016\t\u0015!AC#yi\u0016tGmV5uQ2\u0012!\u0011D\u0012\u0003\u00057\u0001BA!\b\u0003 5\ta/C\u0002\u0003\"Y\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class ClusterLinkControllerIntegrationTest {
    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testClusterLinkConfigs(ClusterInstance clusterInstance) {
        Map<String, Errors> results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:0")}));
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        Option<String> x$5 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$3, (Map<String, String>)x$2, x$4, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=3, serverProperties={@ClusterConfigProperty(key="create.cluster.link.policy.class.name", value="kafka.link.TestCreateClusterLinkPolicy")})
    public void testClusterStateOnActiveControllerAndFollowers(ClusterInstance clusterInstance) {
        Assertions.assertTrue((boolean)clusterInstance.isKRaftTest());
        List<QuorumController> controllers = this.raftControllers((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance);
        Assertions.assertEquals((int)3, (int)controllers.size());
        controllers.foreach((Function1 & Serializable)qc -> {
            this.assertControlManagerState((List<CreateClusterLinksRequestData.EntryData>)Nil$.MODULE$, qc.clusterLinkControlManager());
            return BoxedUnit.UNIT;
        });
        String linkName = "test-link";
        Some x$2 = new Some((Object)"lkc-123");
        String x$3 = this.clusterLink$default$2();
        Map<String, String> x$4 = this.clusterLink$default$3();
        Option<Uuid> x$5 = this.clusterLink$default$4();
        CreateClusterLinksRequestData.EntryData link = this.clusterLink(linkName, x$3, x$4, x$5, (Option<String>)x$2);
        Map<String, Errors> results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)link, (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)linkName));
        controllers.foreach((Function1 & Serializable)qc -> {
            this.assertControlManagerState((List<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)link, (List)Nil$.MODULE$), qc.clusterLinkControlManager());
            return BoxedUnit.UNIT;
        });
    }

    private List<QuorumController> raftControllers(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(clusterInstance.controllersMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (QuorumController)((ControllerServer)x0$1._2()).controller();
            }
            throw new MatchError(null);
        })).toList();
    }

    /*
     * WARNING - void declaration
     */
    private void assertControlManagerState(List<CreateClusterLinksRequestData.EntryData> links, ClusterLinkControlManager clusterLinkControlManager) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$1(links, clusterLinkControlManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Number of links is not as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        links.foreach((Function1 & Serializable)link -> {
            ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$3(clusterLinkControlManager, link);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testCreateAndDeleteLinks(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        Some x$2 = new Some((Object)Uuid.randomUuid());
        String x$3 = this.clusterLink$default$2();
        Map<String, String> x$4 = this.clusterLink$default$3();
        Option<String> x$5 = this.clusterLink$default$5();
        Map<String, Errors> results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$3, x$4, (Option<Uuid>)x$2, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map configs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link.mode"), (Object)ClusterLinkConfig.LinkMode.DESTINATION.name())}));
        Some x$8 = new Some((Object)Uuid.randomUuid());
        String x$9 = this.clusterLink$default$2();
        Option<String> x$10 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$9, (Map<String, String>)configs, (Option<Uuid>)x$8, x$10), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link.mode"), (Object)"badMode")}));
        String x$13 = this.clusterLink$default$2();
        Option<Uuid> x$14 = this.clusterLink$default$4();
        Option<String> x$15 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$13, (Map<String, String>)badConfigs, x$14, x$15), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_EXISTS, (Object)results.apply((Object)"test-link"));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$1(clusterInstance)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Broker never saw new cluster link");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), true, this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)new .colon.colon((Object)this.clusterLink("another-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$)), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"another-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$3(clusterInstance)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Broker never saw cluster link get deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testSourceInitiatedLinkCreation(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        Map configs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link.mode"), (Object)ClusterLinkConfig.LinkMode.SOURCE.name())}));
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        Option<String> x$5 = this.clusterLink$default$5();
        Map<String, Errors> results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$3, (Map<String, String>)configs, x$4, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link.mode"), (Object)"badMode")}));
        Some x$8 = new Some((Object)Uuid.randomUuid());
        String x$9 = this.clusterLink$default$2();
        Option<String> x$10 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$9, (Map<String, String>)badConfigs, (Option<Uuid>)x$8, x$10), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        Some x$13 = new Some((Object)Uuid.randomUuid());
        String x$14 = this.clusterLink$default$2();
        Option<String> x$15 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", x$14, (Map<String, String>)configs, (Option<Uuid>)x$13, x$15), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
    }

    public Map<String, Errors> sendControllerCreateClusterLink(scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData> linkData, SocketServer controller) {
        CreateClusterLinksRequestData data = new CreateClusterLinksRequestData().setEntries(CollectionConverters$.MODULE$.SeqHasAsJava(linkData).asJava()).setTimeoutMs(Integer.MAX_VALUE);
        CreateClusterLinksRequest request = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(data).build();
        CreateClusterLinksResponse response = (CreateClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(CreateClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().entries()).asScala().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Errors> sendDeleteClusterLink(scala.collection.immutable.Seq<String> linkNames, SocketServer controller, boolean validateOnly, boolean force) {
        DeleteClusterLinksRequest request = (DeleteClusterLinksRequest)new DeleteClusterLinksRequest.Builder((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(linkNames).asJava(), validateOnly, force, Integer.MAX_VALUE).build();
        DeleteClusterLinksResponse response = (DeleteClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(DeleteClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().entries()).asScala().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean sendDeleteClusterLink$default$3() {
        return false;
    }

    public boolean sendDeleteClusterLink$default$4() {
        return false;
    }

    public Map<String, Errors> sendAlterConfigs(String linkName, Map<String, String> configs, SocketServer controller) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName);
        IncrementalAlterConfigsRequest request = (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(Collections.singleton(resource), Collections.singletonMap(resource, CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)configs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (key != null && value != null) {
                    return new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
                }
            }
            throw new MatchError(x0$1);
        })).asJavaCollection()), false).build();
        IncrementalAlterConfigsResponse response2 = (IncrementalAlterConfigsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(IncrementalAlterConfigsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response2.data().responses()).asScala().map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.resourceName()), (Object)Errors.forCode((short)response.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public CreateClusterLinksRequestData.EntryData clusterLink(String linkName, String clusterId, Map<String, String> configs, Option<Uuid> linkId, Option<String> tenant) {
        return new CreateClusterLinksRequestData.EntryData().setLinkName(linkName).setLinkId((Uuid)linkId.getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setClusterId(clusterId).setTenantPrefix((String)tenant.getOrElse((Function0 & Serializable)() -> null)).setConfigs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)configs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new CreateClusterLinksRequestData.ConfigData().setKey(k).setValue(v);
            }
            throw new MatchError(null);
        })).toList()).asJava());
    }

    public String clusterLink$default$2() {
        return "source-cluster";
    }

    public Map<String, String> clusterLink$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<Uuid> clusterLink$default$4() {
        return None$.MODULE$;
    }

    public Option<String> clusterLink$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$assertControlManagerState$1(List links$1, ClusterLinkControlManager clusterLinkControlManager$1) {
        return links$1.size() == clusterLinkControlManager$1.getClusterLinkControlState().links.size();
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$2() {
        return "Number of links is not as expected";
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$5(Optional linkId$1) {
        return new StringBuilder(22).append("Does not contain link ").append(linkId$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$assertControlManagerState$6(ClusterLinkControlManager clusterLinkControlManager$1, Optional linkId$1) {
        return ((Set)clusterLinkControlManager$1.getClusterLinkControlState().policyLinks.get()).contains(linkId$1.get());
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$7(Optional linkId$1) {
        return new StringBuilder(33).append("Does not contain link ").append(linkId$1.get()).append(" in policy.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assertControlManagerState$3(ClusterLinkControlManager clusterLinkControlManager$1, CreateClusterLinksRequestData.EntryData link) {
        Optional linkId = clusterLinkControlManager$1.getClusterLinkId(link.linkName());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!clusterLinkControlManager$1.getClusterLinkControlState().links.contains(linkId.get())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$6(clusterLinkControlManager$1, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$7(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$1(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$2() {
        return "Broker never saw new cluster link";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$3(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return !clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$4() {
        return "Broker never saw cluster link get deleted";
    }
}

