/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.time.Duration;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$;
import kafka.server.KafkaBroker;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.NoErrorCode$;
import kafka.server.link.TaskErrorCode;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:5")})
@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQa\u0015\u0001\u0005\u0002QCQA\u0017\u0001\u0005\u0002mCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001b\u0001\u0005\u0002%DQa\u001c\u0001\u0005\u0002ADQA\u001e\u0001\u0005\u0002]DQ! \u0001\u0005\u0002yDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u00111\u0007\u0001\u0005\n\u0005U\u0002\"CA\u001e\u0001E\u0005I\u0011BA\u001f\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\u0012Ad\u00117vgR,'\u000fT5oW\u0012\u0013\u0016J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0013'\u0005!A.\u001b8l\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003EI!AG\t\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0019\u0001\u0005aB/Z:u!\u0006,8/\u001a)f]\u0012Lgn\u001a*fa\u0006L'/T5se>\u0014Hc\u0001\u0011'gA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!QK\\5u\u0011\u00159#\u00011\u0001)\u0003\u0019\tXo\u001c:v[B\u0011\u0011\u0006\r\b\u0003U9\u0002\"a\u000b\u0012\u000e\u00031R!!L\u000b\u0002\rq\u0012xn\u001c;?\u0013\ty#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018#\u0011\u0015!$\u00011\u00016\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\u0005\u00052\u0014BA\u001c#\u0005\u001d\u0011un\u001c7fC:DCAA\u001dF\rB\u0011!hQ\u0007\u0002w)\u0011A(P\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005yz\u0014a\u00026va&$XM\u001d\u0006\u0003\u0001\u0006\u000bQA[;oSRT\u0011AQ\u0001\u0004_J<\u0017B\u0001#<\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001H\u0003!ZH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b' \u0018d_>\u0014H-\u001b8bi>\u0014Xh_\u0019~Q\u0011\u0011\u0011j\u0014)\u0011\u0005)kU\"A&\u000b\u00051[\u0014\u0001\u00039s_ZLG-\u001a:\n\u00059[%\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A)\"\u0003I\u000bq\"\u00197m\u0007>l'-\u001b8bi&|gn]\u00010i\u0016\u001cHOU3wKJ\u001cX-\u00118e'^\f\u0007OR1jYN<\u0016\u000e\u001e5O_:\u0014\u0015\u000eZ5sK\u000e$\u0018n\u001c8bY2Kgn\u001b\u000b\u0004AU3\u0006\"B\u0014\u0004\u0001\u0004A\u0003\"\u0002\u001b\u0004\u0001\u0004)\u0004\u0006B\u0002:\u000b\u001aCCaA%P32\n\u0011+A\u0013uKN$8\u000b^8q\u001b&\u0014(o\u001c:U_BL7mV5uQ&sg/\u00197jIJ+\u0017/^3tiR\u0019\u0001\u0005X/\t\u000b\u001d\"\u0001\u0019\u0001\u0015\t\u000bQ\"\u0001\u0019A\u001b)\t\u0011ITI\u0012\u0015\u0005\t%{\u0005\rL\u0001R\u00039!Xm\u001d;Ti>\u0004X*\u001b:s_J$2\u0001I2e\u0011\u00159S\u00011\u0001)\u0011\u0015!T\u00011\u00016Q\u0011)\u0011(\u0012$)\t\u0015Iuj\u001a\u0017\u0002#\u00069C/Z:u'R|\u0007/T5se>\u0014x+\u001b;i'>,(oY3DYV\u001cH/\u001a:TQV$Hm\\<o)\r\u0001#n\u001b\u0005\u0006O\u0019\u0001\r\u0001\u000b\u0005\u0006i\u0019\u0001\r!\u000e\u0015\u0005\re*e\t\u000b\u0003\u0007\u0013>sG&A)\u0002EQ,7\u000f^*u_Bl\u0015N\u001d:peR\u000b7o[*uCR,G)\u001e:j]\u001e,%O]8s)\r\u0001\u0013O\u001d\u0005\u0006O\u001d\u0001\r\u0001\u000b\u0005\u0006i\u001d\u0001\r!\u000e\u0015\u0005\u000fe*e\t\u000b\u0003\b\u0013>+H&A)\u0002SQ,7\u000f^'jeJ|'OR1jY>4XM],iK:\u001cv.\u001e:dK&\u001bXK\\1wC&d\u0017M\u00197f)\r\u0001\u00030\u001f\u0005\u0006O!\u0001\r\u0001\u000b\u0005\u0006i!\u0001\r!\u000e\u0015\u0005\u0011e*e\t\u000b\u0003\t\u0013>cH&A)\u0002SQ,7\u000f\u001e*pY2\u0014\u0017mY6NSJ\u0014xN\u001d$s_6\u0004VM\u001c3j]\u001e\u001cFo\u001c9qK\u0012\u001cF/\u0019;f)\u0011\u0001s0!\u0001\t\u000b\u001dJ\u0001\u0019\u0001\u0015\t\u000bQJ\u0001\u0019A\u001b)\t%ITI\u0012\u0015\u0006\u0013%{\u0015q\u0001\u0017\u0002#\u0006QC/Z:u%>dGNY1dW6K'O]8s\r\u0006LGn](o+:\u001cX\u000f\u001d9peR,Gm\u0015;bi\u0016\u001cH#\u0002\u0011\u0002\u000e\u0005=\u0001\"B\u0014\u000b\u0001\u0004A\u0003\"\u0002\u001b\u000b\u0001\u0004)\u0004\u0006\u0002\u0006:\u000b\u001aCSAC%P\u0003+a\u0013!U\u00014i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u!J|Wn\u001c;fI6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$R\u0001IA\u000e\u0003;AQaJ\u0006A\u0002!BQ\u0001N\u0006A\u0002UBCaC\u001dF\r\"*1\"S(\u0002$1\n\u0011+A\u001buKN$H*Y:u\r\u0016$8\r[3e\u001f\u001a47/\u001a;GC&dW\rZ(wKJl\u0015N\u001d:peR{\u0007/[2EKN\u001c'/\u001b9uS>tG#\u0002\u0011\u0002*\u0005-\u0002\"B\u0014\r\u0001\u0004A\u0003\"\u0002\u001b\r\u0001\u0004)\u0004\u0006\u0002\u0007:\u000b\u001aCS\u0001D%P\u0003ca\u0013!U\u00013i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]R\u0019\u0001%a\u000e\t\u0011\u0005eR\u0002%AA\u0002U\nq\u0001\u001d:p[>$X-\u0001\u001fuKN$H*Y:u\r\u0016$8\r[3e\u001f\u001a47/\u001a;Ti>\u0004\b/\u001a3NSJ\u0014xN\u001d+pa&\u001cG)Z:de&\u0004H/[8oI\u0011,g-Y;mi\u0012\nTCAA U\r)\u0014\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\n\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YC/Z:u'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:U_BL7m],ji\"\u001cuN\u001c;s_2dWM]\"iC:<W\rF\u0003!\u0003/\nI\u0006C\u0003(\u001f\u0001\u0007\u0001\u0006C\u00035\u001f\u0001\u0007Q\u0007\u000b\u0003\u0010s\u00153\u0005&B\bJ\u001f\u0006}CFAA1C\t\t\u0019'\u0001\b{W\u000e{WNY5oCRLwN\\:)\r\u0001\t9gTA:!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7{\u0005\u0019\u0011\r]5\n\t\u0005E\u00141\u000e\u0002\u0004)\u0006<\u0017EAA;\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\r\u0001\t9gTA=C\t\tY(A\ncCj,GNO:iCJ$wlY8v]RTT\u0007")
public class ClusterLinkDRIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testPausePendingRepairMirror(String quorum, boolean coordinator) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArraySerializer x$7 = qual$2.createProducer$default$1();
        ByteArraySerializer x$8 = qual$2.createProducer$default$2();
        Properties x$9 = qual$2.createProducer$default$3();
        KafkaProducer producer = qual$2.createProducer(x$7, x$8, x$9);
        this.produceRecords(producer, this.topic(), numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.MaxMessageSizeProp()), (Object)"1000")}))));
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.topic();
        short x$11 = this.replicationFactor();
        String x$12 = this.linkName();
        Map<String, String> x$13 = qual$3.linkTopic$default$4();
        String x$14 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$10, x$11, x$12, x$13, x$14);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        byte[] value = TestUtils.randomBytes((int)1100);
        String x$16 = this.topic();
        Some x$18 = new Some((Object)value);
        Function1<Object, String> x$19 = this.produceRecords$default$4();
        Option<Object> x$20 = this.produceRecords$default$6();
        this.produceRecords(producer, x$16, 1, x$19, (Option<byte[]>)x$18, x$20);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        Properties x$21 = qual$4.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$4.createConfluentAdminClient(x$21), FailureType$.MODULE$.RecordTooLarge(), this.waitForFailure$default$3());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.topic();
        boolean x$23 = qual$5.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.FAILED, (Object)qual$5.describeMirrorTopic(x$22, x$23).state());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.FAILED, this.topic(), this.numPartitions());
        ClusterLinkRepairMirrors repairMirrors = this.repairMirrorsTask(this.linkName(), linkId);
        repairMirrors.shutdown();
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.MaxMessageSizeProp()), (Object)"10000")}))));
        this.destCluster().alterMirrors(this.topic(), AlterMirrorOp.REPAIR);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$24 = this.topic();
        boolean x$25 = qual$6.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PENDING_REPAIR, (Object)qual$6.describeMirrorTopic(x$24, x$25).state());
        this.destCluster().alterMirrors(this.topic(), AlterMirrorOp.PAUSE);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$26 = this.topic();
        boolean x$27 = qual$7.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)qual$7.describeMirrorTopic(x$26, x$27).state());
        this.destCluster().alterMirrors(this.topic(), AlterMirrorOp.RESUME);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_REPAIR, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$28 = this.topic();
        boolean x$29 = qual$8.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PENDING_REPAIR, (Object)qual$8.describeMirrorTopic(x$28, x$29).state());
        TestUtils.setFieldValueInSuperClassOfSuperClass((Object)repairMirrors, (String)"isShuttingDown", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        repairMirrors.startup();
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)this.destCluster().linkCoordinator(this.linkName()).clusterLinkManager().destClientManager(linkId).get();
        ClusterLinkTopicState mirrorState = (ClusterLinkTopicState)clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).apply((Object)this.topic());
        clientManager.taskManager().clusterLinkRepairMirrors().maybeAddTask(this.topic(), mirrorState, (Option)None$.MODULE$, clientManager);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$30 = this.topic();
        boolean x$31 = qual$9.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)qual$9.describeMirrorTopic(x$30, x$31).state());
        String x$33 = this.topic();
        Some x$35 = new Some((Object)value);
        Function1<Object, String> x$36 = this.produceRecords$default$4();
        Option<Object> x$37 = this.produceRecords$default$6();
        this.produceRecords(producer, x$33, 1, x$36, (Option<byte[]>)x$35, x$37);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$10 = this.destCluster();
        String x$38 = this.linkName();
        boolean x$39 = qual$10.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$40 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(x$38, x$39, x$40);
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testReverseAndSwapFailsWithNonBidirectionalLink(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().alterMirrors(this.topic(), AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirrorTopicWithInvalidRequest(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$8 = this.linkName();
            boolean x$11 = qual$2.unlinkTopic$default$5();
            int x$12 = qual$2.unlinkTopic$default$6();
            qual$2.unlinkTopic(x$7, x$8, false, false, x$11, x$12);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$14 = this.numPartitions();
        short x$15 = this.replicationFactor();
        Properties x$16 = qual$3.createTopic$default$4();
        ListenerName x$17 = qual$3.createTopic$default$5();
        Properties x$18 = qual$3.createTopic$default$6();
        qual$3.createTopic(x$13, x$14, x$15, x$16, x$17, x$18);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$20 = this.linkName();
            boolean x$23 = qual$4.unlinkTopic$default$5();
            int x$24 = qual$4.unlinkTopic$default$6();
            qual$4.unlinkTopic(x$19, x$20, false, false, x$23, x$24);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$25 = this.topic();
        short x$26 = this.replicationFactor();
        String x$27 = this.linkName();
        String x$28 = this.clusterLinkPrefix();
        Map<String, String> x$29 = qual$5.linkTopic$default$4();
        qual$5.linkTopic(x$25, x$26, x$27, x$29, x$28);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$30 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$31 = this.linkName();
        boolean x$32 = qual$6.unlinkTopic$default$3();
        boolean x$33 = qual$6.unlinkTopic$default$4();
        boolean x$34 = qual$6.unlinkTopic$default$5();
        int x$35 = qual$6.unlinkTopic$default$6();
        qual$6.unlinkTopic(x$30, x$31, x$32, x$33, x$34, x$35);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.numPartitions());
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$36 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$37 = this.linkName();
            boolean x$40 = qual$7.unlinkTopic$default$5();
            int x$41 = qual$7.unlinkTopic$default$6();
            qual$7.unlinkTopic(x$36, x$37, false, false, x$40, x$41);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$42 = this.linkName();
        boolean x$43 = qual$8.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$44 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$42, x$43, x$44);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirror(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$5();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, false, x$16, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.assertClusterLinkMirrorTransitionMetricMaxVal(ClusterLinkMetrics$.MODULE$.metricsGroup(), "pending_stopped", (Seq<TaskErrorCode>)new .colon.colon((Object)NoErrorCode$.MODULE$, (List)Nil$.MODULE$), 1.0, (Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().linkCoordinator(this.linkName()), (List)Nil$.MODULE$), this.destCluster().nonLinkCoordinators(this.linkName()), this.assertClusterLinkMirrorTransitionMetricMaxVal$default$7());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.topic();
        short x$19 = this.replicationFactor();
        String x$20 = this.linkName();
        String x$21 = this.clusterLinkPrefix();
        Map<String, String> x$22 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(x$18, x$19, x$20, x$22, x$21);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$24 = this.linkName();
        boolean x$25 = qual$5.unlinkTopic$default$3();
        boolean x$26 = qual$5.unlinkTopic$default$4();
        boolean x$27 = qual$5.unlinkTopic$default$5();
        int x$28 = qual$5.unlinkTopic$default$6();
        qual$5.unlinkTopic(x$23, x$24, x$25, x$26, x$27, x$28);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        this.assertClusterLinkMirrorTransitionMetricMaxVal(ClusterLinkMetrics$.MODULE$.metricsGroup(), "pending_stopped", (Seq<TaskErrorCode>)new .colon.colon((Object)NoErrorCode$.MODULE$, (List)Nil$.MODULE$), 1.0, (Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().linkCoordinator(this.linkName()), (List)Nil$.MODULE$), this.destCluster().nonLinkCoordinators(this.linkName()), this.assertClusterLinkMirrorTransitionMetricMaxVal$default$7());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$29 = this.linkName();
        boolean x$30 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$31 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$29, x$30, x$31);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirrorWithSourceClusterShutdown(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Uuid sourceTopicId = this.sourceCluster().describeTopic(this.topic()).topicId();
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$5();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, false, x$16, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.restartSource(this.restartSource$default$1());
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.topic();
        String x$19 = this.linkName();
        boolean x$21 = qual$4.unlinkTopic$default$3();
        boolean x$22 = qual$4.unlinkTopic$default$4();
        int x$23 = qual$4.unlinkTopic$default$6();
        qual$4.unlinkTopic(x$18, x$19, x$21, x$22, false, x$23);
        Thread.sleep(1000L);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        Assertions.assertThrows(ClusterLinkInUseException.class, () -> {
            ClusterLinkTestHarness qual$5 = this.destCluster();
            String x$24 = this.linkName();
            boolean x$25 = qual$5.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$26 = qual$5.deleteClusterLink$default$3();
            qual$5.deleteClusterLink(x$24, x$25, x$26);
        });
        this.restartSource(this.restartSource$default$1());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        this.restartSource(this.restartSource$default$1());
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$27 = this.topic();
        String x$28 = this.linkName();
        boolean x$30 = qual$6.unlinkTopic$default$3();
        boolean x$31 = qual$6.unlinkTopic$default$4();
        int x$32 = qual$6.unlinkTopic$default$6();
        qual$6.unlinkTopic(x$27, x$28, x$30, x$31, false, x$32);
        Thread.sleep(1000L);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$33 = this.topic();
        boolean x$34 = qual$7.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)sourceTopicId, (Object)qual$7.describeMirrorTopic(x$33, x$34).sourceTopicId());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$35 = this.topic();
        String x$36 = this.linkName();
        boolean x$38 = qual$8.unlinkTopic$default$3();
        boolean x$39 = qual$8.unlinkTopic$default$5();
        int x$40 = qual$8.unlinkTopic$default$6();
        qual$8.unlinkTopic(x$35, x$36, x$38, false, x$39, x$40);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$41 = this.linkName();
        boolean x$42 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$43 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$41, x$42, x$43);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirrorTaskStateDuringError(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.restartSource(this.restartSource$default$1());
        this.restartMirrorTopic$2();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$4();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$16, false, x$17);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.assertClusterLinkMirrorTransitionMetricMaxVal(ClusterLinkMetrics$.MODULE$.metricsGroup(), "pending_stopped", (Seq<TaskErrorCode>)new .colon.colon((Object)InternalTaskErrorCode$.MODULE$, (List)Nil$.MODULE$), 1.0, (Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().linkCoordinator(this.linkName()), (List)Nil$.MODULE$), this.destCluster().nonLinkCoordinators(this.linkName()), this.assertClusterLinkMirrorTransitionMetricMaxVal$default$7());
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkDRIntegrationTest.$anonfun$testStopMirrorTaskStateDuringError$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var39_29 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var27_24 = null;
        Object var32_28 = null;
        this.restartSource(this.restartSource$default$1());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        long l3 = 15000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkDRIntegrationTest.$anonfun$testStopMirrorTaskStateDuringError$2(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var40_36 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var33_31 = null;
        Object var38_35 = null;
        this.assertClusterLinkMirrorTransitionMetricMaxVal(ClusterLinkMetrics$.MODULE$.metricsGroup(), "pending_stopped", (Seq<TaskErrorCode>)new .colon.colon((Object)NoErrorCode$.MODULE$, (List)Nil$.MODULE$), 1.0, (Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().linkCoordinator(this.linkName()), (List)Nil$.MODULE$), this.destCluster().nonLinkCoordinators(this.linkName()), this.assertClusterLinkMirrorTransitionMetricMaxVal$default$7());
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$20 = this.linkName();
        boolean x$21 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$22 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$20, x$21, x$22);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirrorFailoverWhenSourceIsUnavailable(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDRIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Destination leader epoch not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        this.updateCredentials(connectionTarget);
        this.waitUntilOneOfMirrorStates((Set<ReplicaStatus.MirrorInfo.State>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.SOURCE_AUTHENTICATION_FAILED, ReplicaStatus.MirrorInfo.State.SOURCE_UNAVAILABLE}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.UNAVAILABLE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        int x$15 = this.numPartitions();
        boolean x$16 = qual$3.unlinkTopic$default$3();
        boolean x$17 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$12, x$13, x$16, false, x$17, x$15);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testRollbackMirrorFromPendingStoppedState(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$16 = qual$3.unlinkTopic$default$4();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, false, x$16, false, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PENDING_STOPPED);
        this.destCluster().alterMirrors(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.ROLLBACK);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.restartSource(this.restartSource$default$1());
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testRollbackMirrorFailsOnUnsupportedStates(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().alterMirrors(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.ROLLBACK));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$13 = qual$3.pauseTopic$default$2();
        qual$3.pauseTopic(x$12, x$13);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().alterMirrors(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.ROLLBACK));
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().alterMirrors(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.ROLLBACK));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLastFetchedOffsetPromotedMirrorTopicDescription(String quorum, boolean coordinator) {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLastFetchedOffsetFailedOverMirrorTopicDescription(String quorum, boolean coordinator) {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testLastFetchedOffsetStoppedMirrorTopicDescription(boolean promote) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDRIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Destination leader epoch not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$14 = qual$3.replicaStatus$default$3();
        ReplicaStatus leader = (ReplicaStatus)((IterableOps)qual$3.replicaStatus(x$12, 0, x$14).filter((Function1 & Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDRIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(rs)))).head();
        Assertions.assertTrue((boolean)leader.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi.state());
        Assertions.assertEquals((long)numRecords, (long)mi.lastFetchSourceHighWatermark());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$16 = this.linkName();
        int x$18 = this.numPartitions();
        boolean x$19 = qual$4.unlinkTopic$default$3();
        boolean x$20 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$15, x$16, x$19, promote, x$20, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$23 = qual$5.replicaStatus$default$3();
        ReplicaStatus leader2 = (ReplicaStatus)((IterableOps)qual$5.replicaStatus(x$21, 0, x$23).filter((Function1 & Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDRIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(rs)))).head();
        Assertions.assertTrue((boolean)leader2.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi2 = (ReplicaStatus.MirrorInfo)leader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.STOPPED, (Object)mi2.state());
        Assertions.assertEquals((long)-1L, (long)mi2.lastFetchSourceHighWatermark());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$24 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$25 = qual$6.describeMirrorTopic$default$2();
        MirrorTopicDescription desc = qual$6.describeMirrorTopic(x$24, x$25);
        Assertions.assertEquals((Object)desc.state(), (Object)MirrorTopicDescription.State.STOPPED);
        Assertions.assertEquals((int)1, (int)desc.stoppedLogEndOffsets().size());
        Assertions.assertEquals((long)numRecords, (long)Predef$.MODULE$.Long2long((Long)desc.stoppedLogEndOffsets().get(0)));
    }

    private boolean testLastFetchedOffsetStoppedMirrorTopicDescription$default$1() {
        return true;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testStoppedMirrorTopicsWithControllerChange(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$22 = this.numPartitions();
        short x$32 = this.replicationFactor();
        Properties x$42 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$22, x$32, x$42, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$122 = this.topic();
        boolean x$13 = qual$3.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)qual$3.describeMirrorTopic(x$122, x$13).state());
        int originalControllerId = this.destCluster().controllerId();
        this.destCluster().changeController();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.topic();
        boolean x$15 = qual$4.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)qual$4.describeMirrorTopic(x$14, x$15).state());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), true, false, true, this.numPartitions());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = this.topic();
        boolean x$17 = qual$5.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)MirrorTopicDescription.State.STOPPED, (Object)qual$5.describeMirrorTopic(x$16, x$17).state());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$18 = this.linkName();
        boolean x$19 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$20 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$18, x$19, x$20);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        ByteArraySerializer x$21 = qual$7.createProducer$default$1();
        ByteArraySerializer x$222 = qual$7.createProducer$default$2();
        Properties x$23 = qual$7.createProducer$default$3();
        KafkaProducer producer = qual$7.createProducer(x$21, x$222, x$23);
        this.produceRecords(producer, this.topic(), 1, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        this.destCluster().changeControllerToSpecificBroker(originalControllerId);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        Buffer replicaIds = (Buffer)((IterableOps)((Buffer)((IterableOps)this.destCluster().brokers().map((Function1 & Serializable)x$1 -> x$1.replicaManager())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDRIntegrationTest.$anonfun$testStoppedMirrorTopicsWithControllerChange$2(tp, x$2)))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDRIntegrationTest.$anonfun$testStoppedMirrorTopicsWithControllerChange$3(tp, x$3)))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)ClusterLinkDRIntegrationTest.$anonfun$testStoppedMirrorTopicsWithControllerChange$4(x$4)));
        int shutdownBrokerCount = BoxesRunTime.unboxToInt((Object)replicaIds.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(x0$1, x1$1) -> {
            int shutDownBroker = 0;
            if (x1$1 != originalControllerId) {
                this.destCluster().shutdownBroker(x1$1);
                shutDownBroker = 1;
            }
            return x0$1 + shutDownBroker;
        }));
        Assertions.assertNotSame((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)shutdownBrokerCount), (String)new StringBuilder(56).append("No broker is shutdown with replicaIds ").append(replicaIds).append(" and controllerId ").append(originalControllerId).toString());
        this.produceRecords(producer, this.topic(), 1, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        producer.close();
    }

    private final void restartMirrorTopic$1() {
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        short x$2 = this.replicationFactor();
        String x$3 = this.linkName();
        Map<String, String> x$4 = qual$1.linkTopic$default$4();
        String x$5 = qual$1.linkTopic$default$5();
        qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
    }

    private final void restartMirrorTopic$2() {
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        short x$2 = this.replicationFactor();
        String x$3 = this.linkName();
        Map<String, String> x$4 = qual$1.linkTopic$default$4();
        String x$5 = qual$1.linkTopic$default$5();
        qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
    }

    public static final /* synthetic */ void $anonfun$testStopMirrorTaskStateDuringError$1(ClusterLinkDRIntegrationTest $this) {
        MirrorTopicDescription descWithTransitionErrors = $this.destCluster().describeMirrorTopic($this.topic(), true);
        Assertions.assertNotNull((Object)descWithTransitionErrors);
        java.util.List transitionErrors = descWithTransitionErrors.mirrorStateTransitionErrors();
        Assertions.assertEquals((int)1, (int)transitionErrors.size());
        Assertions.assertEquals((Object)new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR, "Failed to describe topic configs for an unknown reason."), transitionErrors.get(0));
        ClusterLinkTestHarness qual$4 = $this.destCluster();
        String x$18 = $this.topic();
        boolean x$19 = qual$4.describeMirrorTopic$default$2();
        MirrorTopicDescription descWithoutTransitionErrors = qual$4.describeMirrorTopic(x$18, x$19);
        Assertions.assertNotNull((Object)descWithoutTransitionErrors);
        Assertions.assertEquals((int)0, (int)descWithoutTransitionErrors.mirrorStateTransitionErrors().size());
    }

    public static final /* synthetic */ void $anonfun$testStopMirrorTaskStateDuringError$2(ClusterLinkDRIntegrationTest $this) {
        MirrorTopicDescription desc = $this.destCluster().describeMirrorTopic($this.topic(), true);
        Assertions.assertNotNull((Object)desc);
        java.util.List transitionErrors = desc.mirrorStateTransitionErrors();
        Assertions.assertEquals((int)0, (int)transitionErrors.size());
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(ClusterLinkDRIntegrationTest $this, int expectedLeaderEpoch$1) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$testMirrorFailoverWhenSourceIsUnavailable$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(ClusterLinkDRIntegrationTest $this, int expectedLeaderEpoch$2) {
        return $this.destCluster().leaderEpoch(new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), 0)) >= expectedLeaderEpoch$2;
    }

    public static final /* synthetic */ String $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testStoppedMirrorTopicsWithControllerChange$2(TopicPartition tp$1, ReplicaManager x$2) {
        return x$2.getLog(tp$1).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testStoppedMirrorTopicsWithControllerChange$3(TopicPartition tp$1, ReplicaManager x$3) {
        return x$3.onlinePartition(tp$1).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$testStoppedMirrorTopicsWithControllerChange$4(ReplicaManager x$4) {
        return x$4.config().brokerId();
    }
}

