/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager$;
import kafka.durability.audit.manager.BrokerAuditManagerTrait;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.RetentionConfigChangeRequest;
import kafka.durability.db.PartitionState;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.network.Processor;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u001e<\u0001\u0001CQ!\u0012\u0001\u0005\u0002\u0019Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0013\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\n#\u0002\u0001\r\u00111A\u0005\u0012IC\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0003.\t\u0013\u0001\u0004\u0001\u0019!A!B\u0013\u0019\u0006\"C1\u0001\u0001\u0004\u0005\r\u0011\"\u0005S\u0011%\u0011\u0007\u00011AA\u0002\u0013E1\rC\u0005f\u0001\u0001\u0007\t\u0011)Q\u0005'\"Ia\r\u0001a\u0001\u0002\u0004%\tb\u001a\u0005\n]\u0002\u0001\r\u00111A\u0005\u0012=D\u0011\"\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u00025\t\u0013I\u0004\u0001\u0019!a\u0001\n#9\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0005u\u0011%1\b\u00011A\u0001B\u0003&\u0001\u000eC\u0005x\u0001\u0001\u0007\t\u0019!C\u0001q\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0007\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\n\u0003'\u0001!\u0019!C\u0001\u0003+A\u0001\"!\u000b\u0001A\u0003%\u0011q\u0003\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003+A\u0001\"!\f\u0001A\u0003%\u0011q\u0003\u0005\n\u0003_\u0001!\u0019!C\u0001\u0003cA\u0001\"a\u0011\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u000b\u0002!\u0019!C\u0001\u0003cA\u0001\"a\u0012\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003\u0017B\u0001\"!\u0017\u0001A\u0003%\u0011Q\n\u0005\n\u00037\u0002!\u0019!C\u0001\u0003;B\u0001\"!\u001a\u0001A\u0003%\u0011q\f\u0005\n\u0003O\u0002!\u0019!C\u0001\u0003\u0017B\u0001\"!\u001b\u0001A\u0003%\u0011Q\n\u0005\n\u0003W\u0002!\u0019!C\u0001\u0003\u0017B\u0001\"!\u001c\u0001A\u0003%\u0011Q\n\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0003\t\t\bC\u0006\u0002\b\u0002\u0001\r\u00111A\u0005\u0002\u0005%\u0005bCAG\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gB1\"a$\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002r!Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011AAJ\u0011-\t9\n\u0001a\u0001\u0002\u0003\u0006K!a\u001d\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011CAc\u0011%\tY\u000fAI\u0001\n#\ti\u000fC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0005\u0003\u0006!9!\u0011\u0002\u0001\u0005\n\t-\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u0005{\u0001A\u0011\u0001B \u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\t]\u0003\u0001\"\u0001\u0003Z!9!Q\f\u0001\u0005\u0002\t}\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011)\b\u0001C\u0005\u0005o\u0012\u0011f\u00117vgR,'\u000fT5oW\u0012+(/\u00192jY&$\u00180Q;eSRLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u001f>\u0003\u0011a\u0017N\\6\u000b\u0003y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0003B\u0011!iQ\u0007\u0002w%\u0011Ai\u000f\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0005C\u0001\"\u0001\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n)1\u000b[8si\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u00031\u0019x.\u001e:dK\n\u0013xn[3s+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,>\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001,\u0016\u0002\f\u0017\u000647.\u0019\"s_.,'/\u0001\tt_V\u00148-\u001a\"s_.,'o\u0018\u0013fcR\u00111L\u0018\t\u0003\u0017rK!!\u0018'\u0003\tUs\u0017\u000e\u001e\u0005\b?\u0016\t\t\u00111\u0001T\u0003\rAH%M\u0001\u000eg>,(oY3Ce>\\WM\u001d\u0011\u0002\u0015\u0011,7\u000f\u001e\"s_.,'/\u0001\beKN$(I]8lKJ|F%Z9\u0015\u0005m#\u0007bB0\t\u0003\u0003\u0005\raU\u0001\fI\u0016\u001cHO\u0011:pW\u0016\u0014\b%A\u0005t_V\u00148-\u001a'pOV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l{\u0005\u0019An\\4\n\u00055T'aC!cgR\u0014\u0018m\u0019;M_\u001e\fQb]8ve\u000e,Gj\\4`I\u0015\fHCA.q\u0011\u001dy6\"!AA\u0002!\f!b]8ve\u000e,Gj\\4!\u0003\u001d!Wm\u001d;M_\u001e\f1\u0002Z3ti2{wm\u0018\u0013fcR\u00111,\u001e\u0005\b?:\t\t\u00111\u0001i\u0003!!Wm\u001d;M_\u001e\u0004\u0013!C0uKN$\u0018J\u001c4p+\u0005I\bc\u0001>\u0002\b5\t1P\u0003\u0002}{\u0006\u0019\u0011\r]5\u000b\u0005y|\u0018a\u00026va&$XM\u001d\u0006\u0005\u0003\u0003\t\u0019!A\u0003kk:LGO\u0003\u0002\u0002\u0006\u0005\u0019qN]4\n\u0007\u0005%1P\u0001\u0005UKN$\u0018J\u001c4p\u00035yF/Z:u\u0013:4wn\u0018\u0013fcR\u00191,a\u0004\t\u000f}\u000b\u0012\u0011!a\u0001s\u0006Qq\f^3ti&sgm\u001c\u0011\u0002)M|WO]2f)>\u0004\u0018n\u0019)beRLG/[8o+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\u0015RBAA\u000e\u0015\u0011\ti\"a\b\u0002\r\r|W.\\8o\u0015\rq\u0014\u0011\u0005\u0006\u0005\u0003G\t\u0019!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003O\tYB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002+M|WO]2f)>\u0004\u0018n\u0019)beRLG/[8oA\u0005\u0011B-Z:u)>\u0004\u0018n\u0019)beRLG/[8o\u0003M!Wm\u001d;U_BL7\rU1si&$\u0018n\u001c8!\u0003a\u0019x.\u001e:dKR{\u0007/[2QCJ$\u0018\u000e^5p]2K7\u000f^\u000b\u0003\u0003g\u0001b!!\u000e\u0002@\u0005]QBAA\u001c\u0015\u0011\tI$a\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003{\tAA[1wC&!\u0011\u0011IA\u001c\u0005\u0011a\u0015n\u001d;\u00023M|WO]2f)>\u0004\u0018n\u0019)beRLG/[8o\u0019&\u001cH\u000fI\u0001\u0017I\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eT5ti\u00069B-Z:u)>\u0004\u0018n\u0019)beRLG/[8o\u0019&\u001cH\u000fI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4feV\u0011\u0011Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)!\u00111KA\u0011\u0003\u0015awn\u001a\u001bk\u0013\u0011\t9&!\u0015\u0003\r1{wmZ3s\u0003]qW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b%A\nO/B\u0013xnY3tg>\u0014Hj\\4MKZ,G.\u0006\u0002\u0002`A!\u0011qJA1\u0013\u0011\t\u0019'!\u0015\u0003\u000b1+g/\u001a7\u0002)9;\u0006K]8dKN\u001cxN\u001d'pO2+g/\u001a7!\u0003=i\u0017\r^3sS\u0006d\u0017N_1uS>t\u0017\u0001E7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u0003%1\u0018\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n\u0001\u0003Z3ti\u0006+H-\u001b;NC:\fw-\u001a:\u0016\u0005\u0005M\u0004\u0003BA;\u0003\u0007k!!a\u001e\u000b\t\u0005e\u00141P\u0001\b[\u0006t\u0017mZ3s\u0015\u0011\ti(a \u0002\u000b\u0005,H-\u001b;\u000b\u0007\u0005\u0005U(\u0001\u0006ekJ\f'-\u001b7jifLA!!\"\u0002x\t\u0011\"I]8lKJ\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u0003Q!Wm\u001d;Bk\u0012LG/T1oC\u001e,'o\u0018\u0013fcR\u00191,a#\t\u0011}#\u0013\u0011!a\u0001\u0003g\n\u0011\u0003Z3ti\u0006+H-\u001b;NC:\fw-\u001a:!\u0003I\u0019x.\u001e:dK\u0006+H-\u001b;NC:\fw-\u001a:\u0002-M|WO]2f\u0003V$\u0017\u000e^'b]\u0006<WM]0%KF$2aWAK\u0011!yv%!AA\u0002\u0005M\u0014aE:pkJ\u001cW-Q;eSRl\u0015M\\1hKJ\u0004\u0013!D2p]\u001aLw-\u001e:f\u001b>\u001c7\u000eF\u0002\\\u0003;Cq!a(*\u0001\u0004\t\t+A\u0004dYV\u001cH/\u001a:\u0011\u0007\t\u000b\u0019+C\u0002\u0002&n\u0012ac\u00117vgR,'\u000fT5oWR+7\u000f\u001e%be:,7o]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00047\u0006-\u0006BBAWU\u0001\u0007\u00110\u0001\u0005uKN$\u0018J\u001c4pQ\rQ\u0013\u0011\u0017\t\u0004u\u0006M\u0016bAA[w\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u0017\u0015\u0004W\u0005u\u0006c\u0001>\u0002@&\u0019\u0011\u0011Y>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017AC5oSRL\u0017\r\\5{KR)1,a2\u0002R\"I\u0011\u0011\u001a\u0017\u0011\u0002\u0003\u0007\u00111Z\u0001\u0010GJ,\u0017\r^3U_BL7M\u00127bOB\u00191*!4\n\u0007\u0005=GJA\u0004C_>dW-\u00198\t\u0013\u0005MG\u0006%AA\u0002\u0005U\u0017A\u00037j].\u0004&/\u001a4jqB!\u0011q[As\u001d\u0011\tI.!9\u0011\u0007\u0005mG*\u0004\u0002\u0002^*\u0019\u0011q\\ \u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u000fT\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rH*\u0001\u000bj]&$\u0018.\u00197ju\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003_TC!a3\u0002r.\u0012\u00111\u001f\t\u0005\u0003k\fy0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003%)hn\u00195fG.,GMC\u0002\u0002~2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\t!a>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bj]&$\u0018.\u00197ju\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000fQC!!6\u0002r\u0006is/Y5u+:$\u0018\u000e\\!mYB+g\u000eZ5oO\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001c\u0018I]3GYV\u001c\b.\u001a3\u0015\u0007m\u0013i\u0001C\u0004\u0003\u0010=\u0002\r!a\u001d\u0002\u0019\u0005,H-\u001b;NC:\fw-\u001a:\u0002\u000f\r|gn];nKRA!Q\u0003B\u0017\u0005_\u0011\u0019\u0004\u0005\u0004\u0003\u0018\tu!\u0011E\u0007\u0003\u00053Q1Aa\u0007M\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005?\u0011IBA\u0002TKF\u0004Ra\u0013B\u0012\u0005OI1A!\nM\u0005\u0015\t%O]1z!\rY%\u0011F\u0005\u0004\u0005Wa%\u0001\u0002\"zi\u0016Dq!a(1\u0001\u0004\t\t\u000bC\u0004\u00032A\u0002\r!a\r\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]2K7\u000f\u001e\u0005\b\u0005k\u0001\u0004\u0019\u0001B\u001c\u0003)qW/\u001c*fG>\u0014Hm\u001d\t\u0004\u0017\ne\u0012b\u0001B\u001e\u0019\n\u0019\u0011J\u001c;\u0002gQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;EKN$\u0018N\\1uS>tG*Y4hS:<Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$HcA.\u0003B!9!1I\u0019A\u0002\u0005U\u0017AB9v_J,X.\u0001\u0018uKN$H)\u001e:bE&d\u0017\u000e^=Bk\u0012LG\u000fR3ti&t\u0017\r^5p]2\u000bwmZ5oO\u001a\u000b'OQ3iS:$GcA.\u0003J!9!1\t\u001aA\u0002\u0005U\u0017a\u000b;fgR$UO]1cS2LG/_!mY><X\rZ'jeJ|'o\u0015;bi\u0016$&/\u00198tSRLwN\\:\u0015\u0007m\u0013y\u0005C\u0004\u0003DM\u0002\r!!6\u0002mQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;T_V\u00148-\u001a+pa&\u001c'+Z2sK\u0006$\u0018n\u001c8XSRDw.\u001e;U_BL7-\u00133\u0015\u0007m\u0013)\u0006C\u0004\u0003DQ\u0002\r!!6\u0002]Q,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;Qe>$WoY3U_N#x\u000e\u001d9fI6K'O]8s)>\u0004\u0018n\u0019\u000b\u00047\nm\u0003b\u0002B\"k\u0001\u0007\u0011Q[\u00019i\u0016\u001cH\u000fR;sC\nLG.\u001b;z\u0003V$\u0017\u000e^*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK>s7\u000b^8qa\u0016$W*\u001b:s_J$v\u000e]5d)\rY&\u0011\r\u0005\b\u0005\u00072\u0004\u0019AAk\u0003!\"Xm\u001d;EkJ\f'-\u001b7jif\fU\u000fZ5u%\u0016$XM\u001c;j_:\u001cuN\u001c4jO\u000eC\u0017M\\4f)\rY&q\r\u0005\b\u0005\u0007:\u0004\u0019AAk\u0003\u0005:\u0018-\u001b;G_J\u001cv.\u001e:dK\u0016\u0003xn\u00195BQ\u0016\fGm\u00144EKN$Hj\\4t)\u001dY&Q\u000eB8\u0005cBq!a\u00059\u0001\u0004\t9\u0002C\u0004\u0002,a\u0002\r!a\u0006\t\u000f\tM\u0004\b1\u0001\u00038\u00059Q.\u001b8ES\u001a4\u0017a\u0005:fGJ,\u0017\r^3T_V\u00148-\u001a+pa&\u001cGcA.\u0003z!9!QG\u001dA\u0002\t]\u0002f\u0002\u0001\u0003~\t\r%Q\u0011\t\u0004u\n}\u0014b\u0001BAw\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\t\u001d\u0015aC5oi\u0016<'/\u0019;j_:\u0004")
public class ClusterLinkDurabilityAuditIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private KafkaBroker sourceBroker;
    private KafkaBroker destBroker;
    private AbstractLog sourceLog;
    private AbstractLog destLog;
    private TestInfo _testInfo;
    private final TopicPartition sourceTopicPartition;
    private final TopicPartition destTopicPartition;
    private final List<TopicPartition> sourceTopicPartitionList;
    private final List<TopicPartition> destTopicPartitionList;
    private final Logger networkProcessorLogger;
    private final Level NWProcessorLogLevel;
    private final Logger materialization;
    private final Logger validator;
    private BrokerAuditManager destAuditManager;
    private BrokerAuditManager sourceAuditManager;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    public KafkaBroker sourceBroker() {
        return this.sourceBroker;
    }

    public void sourceBroker_$eq(KafkaBroker x$1) {
        this.sourceBroker = x$1;
    }

    public KafkaBroker destBroker() {
        return this.destBroker;
    }

    public void destBroker_$eq(KafkaBroker x$1) {
        this.destBroker = x$1;
    }

    public AbstractLog sourceLog() {
        return this.sourceLog;
    }

    public void sourceLog_$eq(AbstractLog x$1) {
        this.sourceLog = x$1;
    }

    public AbstractLog destLog() {
        return this.destLog;
    }

    public void destLog_$eq(AbstractLog x$1) {
        this.destLog = x$1;
    }

    public TestInfo _testInfo() {
        return this._testInfo;
    }

    public void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    public TopicPartition sourceTopicPartition() {
        return this.sourceTopicPartition;
    }

    public TopicPartition destTopicPartition() {
        return this.destTopicPartition;
    }

    public List<TopicPartition> sourceTopicPartitionList() {
        return this.sourceTopicPartitionList;
    }

    public List<TopicPartition> destTopicPartitionList() {
        return this.destTopicPartitionList;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Level NWProcessorLogLevel() {
        return this.NWProcessorLogLevel;
    }

    public Logger materialization() {
        return this.materialization;
    }

    public Logger validator() {
        return this.validator;
    }

    public BrokerAuditManager destAuditManager() {
        return this.destAuditManager;
    }

    public void destAuditManager_$eq(BrokerAuditManager x$1) {
        this.destAuditManager = x$1;
    }

    public BrokerAuditManager sourceAuditManager() {
        return this.sourceAuditManager;
    }

    public void sourceAuditManager_$eq(BrokerAuditManager x$1) {
        this.sourceAuditManager = x$1;
    }

    public void configureMock(ClusterLinkTestHarness cluster) {
        cluster.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        cluster.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        cluster.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        cluster.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        cluster.serverConfig().setProperty("confluent.durability.audit.idempotent.producer", Boolean.toString(false));
        cluster.serverConfig().setProperty("confluent.durability.audit.checks", "MirrorTopicAudit");
        cluster.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType,MirrorStateChangeType,ClusterLinkTruncationType");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(true));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "1");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(true));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierS3BucketProp(), "my-bucket");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        cluster.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        cluster.serverConfig().setProperty("retention.bytes", "-1");
        cluster.serverConfig().put("confluent.cluster.link.metadata.topic.partitions", "1");
        cluster.serverConfig().put("confluent.cluster.link.metadata.topic.replication.factor", "1");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo_$eq(testInfo);
        if (((Method)testInfo.getTestMethod().get()).toString().contains("UncleanSourceLeaderElection")) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 1));
        } else if (((Method)testInfo.getTestMethod().get()).toString().contains("SourceTopicRecreation")) {
            None$ x$12 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 3));
            None$ x$16 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 1));
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.6");
        } else {
            None$ x$20 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$20, 0, 1));
            None$ x$24 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$24, 100, 1));
        }
        this.configureMock(this.sourceCluster());
        this.configureMock(this.destCluster());
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(boolean createTopicFlag, String linkPrefix) {
        this.sourceCluster().waitUntilLogCreatedOnBrokers(this.sourceTopicPartition());
        this.sourceBroker_$eq(this.sourceCluster().partitionLeader(this.sourceTopicPartition()));
        this.destCluster().waitUntilLogCreatedOnBrokers(this.destTopicPartition());
        this.destBroker_$eq(this.destCluster().partitionLeader(this.destTopicPartition()));
        this.destAuditManager_$eq((BrokerAuditManager)this.destBroker().auditManager().get());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$initialize$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Source log not ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = this.sourceBroker().replicaManager().logManager();
        TopicPartition x$3 = this.sourceTopicPartition();
        boolean x$4 = qual$2.getLog$default$2();
        this.sourceLog_$eq((AbstractLog)qual$2.getLog(x$3, x$4).get());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$initialize$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Destination log not ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        LogManager qual$4 = this.destBroker().replicaManager().logManager();
        TopicPartition x$7 = this.destTopicPartition();
        boolean x$8 = qual$4.getLog$default$2();
        this.destLog_$eq((AbstractLog)qual$4.getLog(x$7, x$8).get());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
    }

    public boolean initialize$default$1() {
        return true;
    }

    public String initialize$default$2() {
        return this.clusterLinkPrefix();
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilAllPendingDurabilityEventsAreFlushed(BrokerAuditManager auditManager) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(auditManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$2(auditManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Seq<byte[]> consume(ClusterLinkTestHarness cluster, List<TopicPartition> topicPartitionList, int numRecords) {
        Consumer consumer = cluster.createConsumer(cluster.createConsumer$default$1(), cluster.createConsumer$default$2(), cluster.createConsumer$default$3(), cluster.createConsumer$default$4());
        consumer.assign(topicPartitionList);
        Seq records = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L).map((Function1 & Serializable)x$8 -> (byte[])x$8.value());
        consumer.close();
        return records;
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditDestinationLaggingLogStartOffset(String quorum) {
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        this.produceToSourceAndWaitForMirror(51);
        Assertions.assertEquals((int)51, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 51).length());
        Assertions.assertEquals((int)51, (int)this.consume(this.destCluster(), this.destTopicPartitionList(), 51).length());
        AbstractLog qual$1 = this.sourceLog();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        AbstractLog qual$2 = this.destLog();
        Option x$3 = qual$2.roll$default$1();
        long x$4 = qual$2.roll$default$2();
        qual$2.roll(x$3, x$4);
        this.produceToSourceAndWaitForMirror(51);
        Assertions.assertEquals((int)102, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 102).length());
        Assertions.assertEquals((int)102, (int)this.consume(this.destCluster(), this.destTopicPartitionList(), 102).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed waiting for dest audit manager to contain partition state");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.sourceLog().maybeIncrementLogStartOffset(55L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.sourceLog().deleteOldSegments();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((DurabilityMetricsManager.LostMessage)this.destAuditManager().metricsManager().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.MirrorPartitionLapse())).count() == 0L ? 1 : 0) != 0, (String)new StringBuilder(12).append("total lost: ").append(((DurabilityMetricsManager.LostMessage)this.destAuditManager().metricsManager().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.MirrorPartitionLapse())).count()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditDestinationLaggingFarBehind(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        this.produceToSourceAndWaitForMirror(51);
        Assertions.assertEquals((int)51, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 51).length());
        Assertions.assertEquals((int)51, (int)this.consume(this.destCluster(), this.destTopicPartitionList(), 51).length());
        AbstractLog qual$1 = this.sourceLog();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        AbstractLog qual$2 = this.destLog();
        Option x$3 = qual$2.roll$default$1();
        long x$4 = qual$2.roll$default$2();
        qual$2.roll(x$3, x$4);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$5 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$5);
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.PAUSE), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed waiting for dest audit manager to contain partition state");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(51);
        Assertions.assertEquals((int)102, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 102).length());
        AbstractLog qual$4 = this.sourceLog();
        Option x$6 = qual$4.roll$default$1();
        long x$7 = qual$4.roll$default$2();
        qual$4.roll(x$6, x$7);
        this.produceToSourceCluster(51);
        Assertions.assertEquals((int)153, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 153).length());
        AbstractLog qual$5 = this.sourceLog();
        Option x$8 = qual$5.roll$default$1();
        long x$9 = qual$5.roll$default$2();
        qual$5.roll(x$8, x$9);
        this.produceToSourceCluster(7);
        Assertions.assertEquals((int)160, (int)this.consume(this.sourceCluster(), this.sourceTopicPartitionList(), 160).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        this.sourceLog().maybeIncrementLogStartOffset(153L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.sourceLog().deleteOldSegments();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$7(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.RESUME), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$8(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$12(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$13(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$14(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$15(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        this.produceToSourceAndWaitForMirror(40);
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDestinationLaggingFarBehind$17(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((DurabilityMetricsManager.LostMessage)this.destAuditManager().metricsManager().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.MirrorPartitionLapse())).count() == 0L ? 1 : 0) != 0, (String)new StringBuilder(12).append("total lost: ").append(((DurabilityMetricsManager.LostMessage)this.destAuditManager().metricsManager().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.MirrorPartitionLapse())).count()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAllowedMirrorStateTransitions(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.PAUSE), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.RESUME), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.FAILOVER), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAllowedMirrorStateTransitions$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditSourceTopicRecreationWithoutTopicId(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        this.sourceCluster().changeLeader(this.sourceTopicPartition());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> this.produceToSourceCluster(10));
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        destAdmin.alterMirrors(Collections.singletonMap(destTopic, AlterMirrorOp.PAUSE), new AlterMirrorsOptions());
        this.waitForMirrorState(destAdmin, destTopic, MirrorTopicDescription.State.PAUSED);
        this.recreateSourceTopic(25);
        this.waitForSourceEpochAheadOfDestLogs(this.sourceTopicPartition(), this.destTopicPartition(), 2);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        Properties x$2 = qual$2.createConfluentAdminClient$default$1();
        destAdmin = qual$2.createConfluentAdminClient(x$2);
        destAdmin.alterMirrors(Collections.singletonMap(destTopic, AlterMirrorOp.RESUME), new AlterMirrorsOptions());
        this.waitForMirrorState(destAdmin, destTopic, MirrorTopicDescription.State.ACTIVE);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destBroker_$eq(this.destCluster().partitionLeader(this.destTopicPartition()));
        LogManager qual$3 = this.destBroker().replicaManager().logManager();
        TopicPartition x$3 = this.destTopicPartition();
        boolean x$4 = qual$3.getLog$default$2();
        this.destLog_$eq((AbstractLog)qual$3.getLog(x$3, x$4).get());
        this.destAuditManager_$eq((BrokerAuditManager)this.destBroker().auditManager().get());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((DurabilityMetricsManager.LostMessage)this.destAuditManager().metricsManager().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.MirrorPartitionLapse())).count() == 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditProduceToStoppedMirrorTopic(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.FAILOVER), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        ByteArraySerializer x$2 = qual$2.createProducer$default$1();
        ByteArraySerializer x$3 = qual$2.createProducer$default$2();
        Properties x$4 = qual$2.createProducer$default$3();
        KafkaProducer producer = qual$2.createProducer(x$2, x$3, x$4);
        this.produceRecords(producer, destTopic, 10, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        producer.close();
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> this.produceToSourceCluster(10));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        destAdmin.alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.FAILOVER), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$7(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        this.destLog().maybeIncrementLogStartOffset(25L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$8(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    public void testDurabilityAuditRetentionConfigChange(String quorum) {
        String destTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        this.initialize(this.initialize$default$1(), this.initialize$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> this.produceToSourceCluster(10));
        BrokerAuditManagerTrait.submitAuditRequest$((BrokerAuditManagerTrait)BrokerAuditManager$.MODULE$, (AuditManagerRequest)new RetentionConfigChangeRequest(new TopicIdPartition((Uuid)this.destLog().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.destTopicPartition()), BoxesRunTime.unboxToInt((Object)this.destLog().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), this.destLog().config().retentionSize, this.destLog().config().retentionMs, this.destLog().config().compact()));
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Retention event not propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        BrokerAuditManagerTrait.submitAuditRequest$((BrokerAuditManagerTrait)BrokerAuditManager$.MODULE$, (AuditManagerRequest)new RetentionConfigChangeRequest(new TopicIdPartition((Uuid)this.destLog().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.destTopicPartition()), BoxesRunTime.unboxToInt((Object)this.destLog().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), 1000L, -1L, this.destLog().config().compact()));
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$8(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$9(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        qual$1.createConfluentAdminClient(x$1).alterMirrors(Collections.singletonMap(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), AlterMirrorOp.FAILOVER), new AlterMirrorsOptions());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, destTopic, this.numPartitions());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$10(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$11(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
        BrokerAuditManagerTrait.submitAuditRequest$((BrokerAuditManagerTrait)BrokerAuditManager$.MODULE$, (AuditManagerRequest)new RetentionConfigChangeRequest(new TopicIdPartition((Uuid)this.destLog().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.destTopicPartition()), BoxesRunTime.unboxToInt((Object)this.destLog().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), 2000L, 1000L, this.destLog().config().compact()));
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.destAuditManager());
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditRetentionConfigChange$14(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Retention event not propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.destAuditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForSourceEpochAheadOfDestLogs(TopicPartition sourceTopicPartition, TopicPartition destTopicPartition, int minDiff) {
        long l = 1L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkDurabilityAuditIntegrationTest.$anonfun$waitForSourceEpochAheadOfDestLogs$1(this, sourceTopicPartition, destTopicPartition, minDiff)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader epoch not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void recreateSourceTopic(int numRecords) {
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, 2, x$4, x$5, x$6);
        this.sourceCluster().changeLeader(this.sourceTopicPartition());
        this.produceToSourceCluster(numRecords);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(ClusterLinkDurabilityAuditIntegrationTest $this) {
        LogManager qual$1 = $this.sourceBroker().replicaManager().logManager();
        TopicPartition x$1 = $this.sourceTopicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$initialize$2() {
        return "Source log not ready";
    }

    public static final /* synthetic */ boolean $anonfun$initialize$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        LogManager qual$3 = $this.destBroker().replicaManager().logManager();
        TopicPartition x$5 = $this.destTopicPartition();
        boolean x$6 = qual$3.getLog$default$2();
        return qual$3.getLog(x$5, x$6).isDefined();
    }

    public static final /* synthetic */ String $anonfun$initialize$4() {
        return "Destination log not ready";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(BrokerAuditManager auditManager$1) {
        Tuple2 tuple2 = auditManager$1.getQueuedEvents();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        return tuple2 != null && tuple2.equals(sp2);
    }

    public static final /* synthetic */ String $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$2(BrokerAuditManager auditManager$1) {
        return new StringBuilder(89).append("Failed to flush all the events from durability audit queue. audit manager is ").append(auditManager$1.getQueuedEvents()).append(", state is: ").append(auditManager$1.isRunning()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$1(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$2() {
        return "failed waiting for dest audit manager to contain partition state";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).highWatermark() == 102L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.sourceLog().logStartOffset() == $this.destLog().logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$6(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(48).append("source start offset is: ").append($this.sourceLog().logStartOffset()).append(", dest start offset is: ").append($this.destLog().logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$7(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).startOffset() == 55L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingLogStartOffset$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(32).append("current start offset is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).startOffset()).append(", dest: ").append($this.destLog().logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$1(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$2() {
        return "failed waiting for dest audit manager to contain partition state";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().exists((Function1 & Serializable)mirror -> BoxesRunTime.boxToBoolean((boolean)mirror.equals("PausedMirror")));
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$6(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.sourceLog().logStartOffset() == 153L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$7(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(24).append("source start offset is: ").append($this.sourceLog().logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().exists((Function1 & Serializable)mirror -> BoxesRunTime.boxToBoolean((boolean)mirror.equals("Mirror")));
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$10(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$11(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.sourceLog().logStartOffset() == $this.destLog().logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$12(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(48).append("source start offset is: ").append($this.sourceLog().logStartOffset()).append(", dest start offset is: ").append($this.destLog().logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$13(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.sourceLog().highWatermark() == $this.destLog().highWatermark();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$14(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(48).append("source start offset is: ").append($this.sourceLog().highWatermark()).append(", dest start offset is: ").append($this.destLog().highWatermark()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$15(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).startOffset() == 153L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$16() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDestinationLaggingFarBehind$17(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).highWatermark() == 200L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDestinationLaggingFarBehind$18() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAllowedMirrorStateTransitions$1(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAllowedMirrorStateTransitions$2(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(51).append($this.destTopicPartition()).append(" is not registered in the durability audit database").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAllowedMirrorStateTransitions$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        Option mirrorState = ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState();
        return !mirrorState.isEmpty() && ((String)mirrorState.get()).equals("Mirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAllowedMirrorStateTransitions$4(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(24).append("current mirror state is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAllowedMirrorStateTransitions$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("PausedMirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAllowedMirrorStateTransitions$6(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAllowedMirrorStateTransitions$7(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("Mirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAllowedMirrorStateTransitions$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAllowedMirrorStateTransitions$9(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("StoppedMirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAllowedMirrorStateTransitions$10(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$2(ClusterLinkDurabilityAuditIntegrationTest $this) {
        boolean x$6;
        TopicPartition x$5;
        LogManager qual$4 = $this.destBroker().replicaManager().logManager();
        return ((AbstractLog)qual$4.getLog(x$5 = $this.destTopicPartition(), x$6 = qual$4.getLog$default$2()).get()).highWatermark() == 25L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(32).append("current dest high watermark is: ").append($this.destLog().highWatermark()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$4(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).highWatermark() == 25L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditSourceTopicRecreationWithoutTopicId$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(35).append("current HWM in the DA database is: ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).highWatermark()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$1(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$2(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(51).append($this.destTopicPartition()).append(" is not registered in the durability audit database").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        Option mirrorState = ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState();
        return !mirrorState.isEmpty() && ((String)mirrorState.get()).equals("Mirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$4(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(24).append("current mirror state is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("StoppedMirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$6(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$7(ClusterLinkDurabilityAuditIntegrationTest $this) {
        boolean x$6;
        TopicPartition x$5;
        LogManager qual$3 = $this.destBroker().replicaManager().logManager();
        return ((AbstractLog)qual$3.getLog(x$5 = $this.destTopicPartition(), x$6 = qual$3.getLog$default$2()).get()).highWatermark() == 10L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditProduceToStoppedMirrorTopic$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(32).append("current dest high watermark is: ").append($this.destLog().highWatermark()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$2(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$3(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(51).append($this.destTopicPartition()).append(" is not registered in the durability audit database").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$4(ClusterLinkDurabilityAuditIntegrationTest $this) {
        Option mirrorState = ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState();
        return !mirrorState.isEmpty() && ((String)mirrorState.get()).equals("Mirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$5(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(24).append("current mirror state is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$6(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("StoppedMirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$7(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$9(PartitionState x$11) {
        return x$11.startOffset() == 25L;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return $this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$9(x$11)));
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic$10(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(30).append("current start offset in DB is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).startOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditRetentionConfigChange$4(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).retentionSz() == $this.destLog().config().retentionSize;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditRetentionConfigChange$5() {
        return "Retention event not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditRetentionConfigChange$8(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).retentionSz() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditRetentionConfigChange$9(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(59).append("Retention event not propagated, current retention size is: ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).retentionSz()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditRetentionConfigChange$10(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return ((String)((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState().get()).equals("StoppedMirror");
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditRetentionConfigChange$11(ClusterLinkDurabilityAuditIntegrationTest $this) {
        return new StringBuilder(53).append("current mirror state in durability audit database is ").append(((PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get()).mirrorState()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditRetentionConfigChange$14(ClusterLinkDurabilityAuditIntegrationTest $this) {
        PartitionState destState = (PartitionState)$this.destAuditManager().db().fetchPartitionState($this.destTopicPartition()).get();
        return destState.retentionSz() == 2000L && destState.retentionMs() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditRetentionConfigChange$15() {
        return "Retention event not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$waitForSourceEpochAheadOfDestLogs$1(ClusterLinkDurabilityAuditIntegrationTest $this, TopicPartition sourceTopicPartition$1, TopicPartition destTopicPartition$1, int minDiff$1) {
        LogManager qual$1 = $this.destCluster().partitionLeader(destTopicPartition$1).replicaManager().logManager();
        boolean x$2 = qual$1.getLog$default$2();
        if ($this.sourceCluster().leaderEpoch(sourceTopicPartition$1) - BoxesRunTime.unboxToInt((Object)((AbstractLog)qual$1.getLog(destTopicPartition$1, x$2).get()).latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < minDiff$1) {
            $this.sourceCluster().changeLeader(sourceTopicPartition$1);
            return false;
        }
        return true;
    }

    public static final /* synthetic */ String $anonfun$waitForSourceEpochAheadOfDestLogs$3() {
        return "Leader epoch not updated";
    }

    public ClusterLinkDurabilityAuditIntegrationTest() {
        this.numPartitions_$eq(1);
        this.replicationFactor = 1;
        this.clusterLinkPrefix_$eq("link1_");
        this.sourceTopicPartition = new TopicPartition(this.topic(), 0);
        this.destTopicPartition = new TopicPartition(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0);
        this.sourceTopicPartitionList = Collections.singletonList(this.sourceTopicPartition());
        this.destTopicPartitionList = Collections.singletonList(this.destTopicPartition());
        this.networkProcessorLogger = Logger.getLogger(Processor.class);
        this.NWProcessorLogLevel = this.networkProcessorLogger().getLevel();
        this.materialization = Logger.getLogger(BrokerDurabilityEventsMaterialize.class);
        this.validator = Logger.getLogger(BrokerValidator.class);
    }
}

