/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType;
import kafka.link.FailureType$;
import kafka.link.FailureType$AuthenticationFailure$;
import kafka.link.FailureType$AuthorizationFailure$;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.link.FailureType$NetworkFailure$;
import kafka.link.FailureType$TruncationBelowHighWatermark$;
import kafka.link.FailureType$UndecodableConfigs$;
import kafka.log.AbstractLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkRetryTaskTaskType$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.UnknownTaskState$;
import kafka.utils.CoreUtils$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:large"), @Tag(value="bazel:shard_count:14")})
@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001B\u00181\u0001UBQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001C\u0002\u0013\u0005c\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0005H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n#\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0004X\u0001\t\u0007I\u0011\u0003*\t\ra\u0003\u0001\u0015!\u0003T\u0011\u001dI\u0006A1A\u0005\niCaA\u0018\u0001!\u0002\u0013Y\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%q\u0007\u00011AA\u0002\u0013%q\u000eC\u0005v\u0001\u0001\u0007\t\u0011)Q\u0005C\"Ia\u000f\u0001a\u0001\u0002\u0004%Ia\u001e\u0005\n}\u0002\u0001\r\u00111A\u0005\n}D!\"a\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003y\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!!5\u0001\t\u0003\t\u0019\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0005\u0001\u0011E!1\u0002\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003T\u0001!\tA!\u0016\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!9!q\u000e\u0001\u0005\u0002\tE\u0004b\u0002B?\u0001\u0011\u0005!q\u0010\u0005\b\u0005\u0017\u0003A\u0011\u0001BG\u0011\u001d\u0011I\n\u0001C\u0001\u00057CqAa*\u0001\t\u0003\u0011I\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\t\u0005\u0007\u0001\"\u0005\u0003D\"I!\u0011\u001d\u0001\u0012\u0002\u0013E!1\u001d\u0005\b\u0005s\u0004A\u0011\u0002B~\u0011\u001d\u0011i\u0010\u0001C\u0005\u0005\u007fDqaa\n\u0001\t\u0013\u0011YP\u0001\fDYV\u001cH/\u001a:MS:\\g)Y5mkJ,G+Z:u\u0015\t\t$'\u0001\u0003mS:\\'\"A\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000e\t\u0003oaj\u0011\u0001M\u0005\u0003sA\u0012!%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].Le\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001=!\t9\u0004!A\tsKBd\u0017nY1uS>tg)Y2u_J,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0006'\"|'\u000f^\u0001\u0013e\u0016\u0004H.[2bi&|gNR1di>\u0014\b%A\u0007d_:\u001cX/\\3s\u000fJ|W\u000f]\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0005Y\u0006twMC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%AB*ue&tw-\u0001\bd_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0011\u0002\rMLhnY't+\u0005\u0019\u0006C\u0001!U\u0013\t)\u0016I\u0001\u0003M_:<\u0017aB:z]\u000el5\u000fI\u0001\be\u0016$(/_'t\u0003!\u0011X\r\u001e:z\u001bN\u0004\u0013A\u00038v[J+7m\u001c:egV\t1\f\u0005\u0002A9&\u0011Q,\u0011\u0002\u0004\u0013:$\u0018a\u00038v[J+7m\u001c:eg\u0002\n\u0011\u0002Z3ti\u0006#W.\u001b8\u0016\u0003\u0005\u0004\"A\u00197\u000e\u0003\rT!\u0001Z3\u0002\u000b\u0005$W.\u001b8\u000b\u0005\u0019<\u0017aB2mS\u0016tGo\u001d\u0006\u0003g!T!!\u001b6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0017aA8sO&\u0011Qn\u0019\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u00035!Wm\u001d;BI6Lgn\u0018\u0013fcR\u0011\u0001o\u001d\t\u0003\u0001FL!A]!\u0003\tUs\u0017\u000e\u001e\u0005\bi6\t\t\u00111\u0001b\u0003\rAH%M\u0001\u000bI\u0016\u001cH/\u00113nS:\u0004\u0013A\u00027j].LE-F\u0001y!\tIH0D\u0001{\u0015\tYx-\u0001\u0004d_6lwN\\\u0005\u0003{j\u0014A!V;jI\u0006QA.\u001b8l\u0013\u0012|F%Z9\u0015\u0007A\f\t\u0001C\u0004u!\u0005\u0005\t\u0019\u0001=\u0002\u000f1Lgn[%eA\u0005)1/\u001a;VaR\u0019\u0001/!\u0003\t\u000f\u0005-!\u00031\u0001\u0002\u000e\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u0010\u0005uQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0018\u0005e\u0011a\u00026va&$XM\u001d\u0006\u0004\u00037Q\u0017!\u00026v]&$\u0018\u0002BA\u0010\u0003#\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004%\u0005\r\u0002\u0003BA\b\u0003KIA!a\n\u0002\u0012\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002MQ,7\u000f^'jeJ|'\u000fV8qS\u000e|\u0005/\u001a:bi&|gn](o\u0019&t7NR1jYV\u0014X\rF\u0003q\u0003[\t)\u0005C\u0004\u00020M\u0001\r!!\r\u0002\rE,xN];n!\u0011\t\u0019$!\u0011\u000f\t\u0005U\u0012Q\b\t\u0004\u0003o\tUBAA\u001d\u0015\r\tY\u0004N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}\u0012)\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u001f\u0006\r#bAA \u0003\"9\u0011qI\nA\u0002\u0005%\u0013aC2p_J$\u0017N\\1u_J\u00042\u0001QA&\u0013\r\ti%\u0011\u0002\b\u0005>|G.Z1oQ\u001d\u0019\u0012\u0011KA/\u0003?\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0005\u0003/\n)\"\u0001\u0004qCJ\fWn]\u0005\u0005\u00037\n)FA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011\u0011M\u0001)w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhfY8pe\u0012Lg.\u0019;pevZ\u0018' \u0015\b'\u0005\u0015\u0014\u0011OA:!\u0011\t9'!\u001c\u000e\u0005\u0005%$\u0002BA6\u0003+\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003_\nIG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002v\u0005\u0012\u0011qO\u0001\u000fu.\u001cu.\u001c2j]\u0006$\u0018n\u001c8t\u0003u!Xm\u001d;T_V\u00148-Z\"mkN$XM\u001d(pi\u00063\u0018-\u001b7bE2,G#\u00029\u0002~\u0005}\u0004bBA\u0018)\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003\u000f\"\u0002\u0019AA%Q\u001d!\u0012\u0011KA/\u0003?Bs\u0001FA3\u0003c\n)\t\f\u0002\u0002\b\u0006\u0012\u0011\u0011R\u0001\u0010C2d7i\\7cS:\fG/[8og\u0006IB/Z:u\t\u0016dW\r^3MS:\\G)\u001e:j]\u001e\u0014V\r\u001e:z)\u0015\u0001\u0018qRAI\u0011\u001d\ty#\u0006a\u0001\u0003cAq!a\u0012\u0016\u0001\u0004\tI\u0005K\u0004\u0016\u0003#\ni&a\u0018)\u000fU\t)'!\u001d\u0002\u00182\u0012\u0011QO\u0001\u001di\u0016\u001cHOU3uef$\u0016m]6Ti\u0006$X-T1oC\u001e,W.\u001a8u)\u0015\u0001\u0018QTAP\u0011\u001d\tyC\u0006a\u0001\u0003cAq!a\u0012\u0017\u0001\u0004\tI\u0005K\u0004\u0017\u0003#\ni&a\u0018)\u000fY\t)'!\u001d\u0002&2\u0012\u0011QO\u0001\u001ai\u0016\u001cH/Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rF\u0003q\u0003W\u000bi\u000bC\u0004\u00020]\u0001\r!!\r\t\u000f\u0005\u001ds\u00031\u0001\u0002J!:q#!\u0015\u0002^\u0005}\u0003fB\f\u0002f\u0005E\u00141\u0017\u0017\u0003\u0003\u000f\u000b\u0001\u0004^3ti\u0006+H\u000f[8sSj\fG/[8o\r\u0006LG.\u001e:f)\u0015\u0001\u0018\u0011XA^\u0011\u001d\ty\u0003\u0007a\u0001\u0003cAq!a\u0012\u0019\u0001\u0004\tI\u0005K\u0004\u0019\u0003#\ni&a\u0018)\u000fa\t)'!\u001d\u0002B2\u0012\u0011qQ\u0001\u0013i\u0016\u001cHoQ8seV\u0004HoQ8oM&<7\u000fF\u0003q\u0003\u000f\fI\rC\u0004\u00020e\u0001\r!!\r\t\u000f\u0005\u001d\u0013\u00041\u0001\u0002J!:\u0011$!\u0015\u0002^\u0005}\u0003fB\r\u0002f\u0005E\u0014q\u001a\u0017\u0003\u0003k\na\u0003^3tiVsG-Z2pI\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0006a\u0006U\u0017q\u001b\u0005\b\u0003_Q\u0002\u0019AA\u0019\u0011\u001d\t9E\u0007a\u0001\u0003\u0013BsAGA)\u0003;\ny\u0006K\u0004\u001b\u0003K\n\t(!8-\u0005\u0005U\u0014A\b;fgRd\u0015n\u001d;EKN\u001c'/\u001b2f/&$\bn\\;u\u0007>tg-[4t)\u0015\u0001\u00181]As\u0011\u001d\tyc\u0007a\u0001\u0003cAq!a\u0012\u001c\u0001\u0004\tI\u0005K\u0004\u001c\u0003#\ni&a\u0018)\u000fm\t)'!\u001d\u0002l2\u0012\u0011QO\u0001\u0016i\u0016\u001cHoU8ve\u000e,Gk\u001c9jG\u0012+G.\u001a;f)\u0015\u0001\u0018\u0011_Az\u0011\u001d\ty\u0003\ba\u0001\u0003cAq!a\u0012\u001d\u0001\u0004\tI\u0005K\u0004\u001d\u0003#\ni&a\u0018)\u000fq\t)'!\u001d\u0002z2\u0012\u0011qQ\u0001\u0014i\u0016\u001cHoQ8o]\u0016\u001cG/[8o#V|G/\u0019\u000b\u0006a\u0006}(\u0011\u0001\u0005\b\u0003_i\u0002\u0019AA\u0019\u0011\u001d\t9%\ba\u0001\u0003\u0013Bs!HA)\u0003;\ny\u0006K\u0004\u001e\u0003K\n\tHa\u0002-\u0005\u0005\u001d\u0015\u0001I1tg\u0016\u0014H/\u00117m\u00072LWM\u001c;D_:tWm\u0019;j_:\u001c8\t\\8tK\u0012$2\u0001\u001dB\u0007\u0011\u001d\u0011yA\ba\u0001\u0005#\tqa]3sm\u0016\u00148\u000f\u0005\u0004\u0003\u0014\te!QD\u0007\u0003\u0005+Q1Aa\u0006B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00057\u0011)BA\u0002TKF\u0004BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0004\u0005G\u0011\u0014AB:feZ,'/\u0003\u0003\u0003(\t\u0005\"aC&bM.\f'I]8lKJ\fQ\u0006^3tiN{WO]2f)>\u0004\u0018n\u0019*fGJ,\u0017\r^3EKR,7\r^5p]V\u001b\u0018N\\4U_BL7-\u00133t)\u0015\u0001(Q\u0006B\u0018\u0011\u001d\tyc\ba\u0001\u0003cAq!a\u0012 \u0001\u0004\tI\u0005K\u0004 \u0003#\ni&a\u0018)\u000f}\t)'!\u001d\u000361\u0012\u0011qQ\u0001\u0018i\u0016\u001cHoU8ve\u000e,G*Z1eKJ\u001c\u0005.\u00198hKN$R\u0001\u001dB\u001e\u0005{Aq!a\f!\u0001\u0004\t\t\u0004C\u0004\u0002H\u0001\u0002\r!!\u0013)\u000f\u0001\n\t&!\u0018\u0002`!:\u0001%!\u001a\u0002r\t\rCFAA;\u0003E\"Xm\u001d;V]\u000edW-\u00198T_V\u00148-\u001a'fC\u0012,'/\u00127fGRLwN\\,ji\"$Um\u001d;Fa>\u001c\u0007.\u00115fC\u0012$R\u0001\u001dB%\u0005\u0017Bq!a\f\"\u0001\u0004\t\t\u0004C\u0004\u0002H\u0005\u0002\r!!\u0013)\u000f\u0005\n\t&!\u0018\u0002`!:\u0011%!\u001a\u0002r\tECFAA;\u0003y!Xm\u001d;ESN\fG\u000e\\8x)J,hnY1uS>t')\u001a7po\";V\nF\u0003q\u0005/\u0012I\u0006C\u0004\u00020\t\u0002\r!!\r\t\u000f\u0005\u001d#\u00051\u0001\u0002J!:!%!\u0015\u0002^\u0005}\u0003f\u0002\u0012\u0002f\u0005E$q\f\u0017\u0003\u0003k\nQ\u0003^3ti\u0012+7\u000f\u001e'fC\u0012,'o\u00115b]\u001e,7\u000fF\u0003q\u0005K\u00129\u0007C\u0004\u00020\r\u0002\r!!\r\t\u000f\u0005\u001d3\u00051\u0001\u0002J!:1%!\u0015\u0002^\u0005}\u0003fB\u0012\u0002f\u0005E$Q\u000e\u0017\u0003\u0003k\nQ\u0004^3ti\u0012+7\u000f\u001e$pY2|w/\u001a:BQ\u0016\fGm\u00144MK\u0006$WM\u001d\u000b\u0006a\nM$Q\u000f\u0005\b\u0003_!\u0003\u0019AA\u0019\u0011\u001d\t9\u0005\na\u0001\u0003\u0013Bs\u0001JA)\u0003;\ny\u0006K\u0004%\u0003K\n\tHa\u001f-\u0005\u0005U\u0014A\f;fgR$Um\u001d;SKBd\u0017nY1uS>tgj\u001c;J[B\f7\r^3e\u0005f\u001cv.\u001e:dK\u001a\u000b\u0017\u000e\\;sKN$R\u0001\u001dBA\u0005\u0007Cq!a\f&\u0001\u0004\t\t\u0004C\u0004\u0002H\u0015\u0002\r!!\u0013)\u000f\u0015\n\t&!\u0018\u0002`!:Q%!\u001a\u0002r\t%EFAAD\u0003\t#Xm\u001d;EKN$(+\u001a9mS\u000e\fG/[8o\u001d>$\u0018*\u001c9bGR,GMQ=T_V\u00148-\u001a$bS2,(/Z:XSRDw\n\u001c3NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e\u000b\u0006a\n=%\u0011\u0013\u0005\b\u0003_1\u0003\u0019AA\u0019\u0011\u001d\t9E\na\u0001\u0003\u0013BsAJA)\u0003;\ny\u0006K\u0004'\u0003K\n\tHa&-\u0005\u0005\u001d\u0015\u0001\b;fgR$Um\u001d;j]\u0006$\u0018n\u001c8IS\u001eDw+\u0019;fe6\f'o\u001b\u000b\u0006a\nu%q\u0014\u0005\b\u0003_9\u0003\u0019AA\u0019\u0011\u001d\t9e\na\u0001\u0003\u0013BsaJA)\u0003;\ny\u0006K\u0004(\u0003K\n\tH!*-\u0005\u0005\u001d\u0015a\u000f;fgRtu\u000e\u0016:v]\u000e\fG/[8o\u0005\u0016dwn\u001e%jO\"<\u0016\r^3s[\u0006\u00148nV5uQ\u0016k\u0007\u000f^=MK\u0006$WM]#q_\u000eD7)Y2iKR\u0019\u0001Oa+\t\u000f\u0005=\u0002\u00061\u0001\u00022!:\u0001&!\u0015\u0002^\u0005}\u0003f\u0002\u0015\u0002f\u0005E$\u0011\u0017\u0017\u0003\u0003\u000f\u000bQ\u0006^3ti\u0012+G.\u001a;f\u0003V$xn\u0011:fCR,G-T5se>\u0014Hk\u001c9jG\u001a{'OR1jY\u0016$G*\u001b8l)\u0015\u0001(q\u0017B]\u0011\u001d\ty#\u000ba\u0001\u0003cAq!a\u0012*\u0001\u0004\tI\u0005K\u0004*\u0003#\ni&a\u0018)\u000f%\n)'!\u001d\u0003@2\u0012\u0011qQ\u0001\u0019m\u0016\u0014\u0018NZ=GC&dWO]3B]\u0012\u0014VmY8wKJLH#\u00039\u0003F\n='\u0011\u001cBo\u0011\u001d\u00119M\u000ba\u0001\u0005\u0013\f1BZ1jYV\u0014X\rV=qKB\u0019qGa3\n\u0007\t5\u0007GA\u0006GC&dWO]3UsB,\u0007b\u0002BiU\u0001\u0007!1[\u0001\rgR\f'\u000f\u001e$bS2,(/\u001a\t\u0005\u0001\nU\u0007/C\u0002\u0003X\u0006\u0013\u0011BR;oGRLwN\u001c\u0019\t\u000f\tm'\u00061\u0001\u0003T\u0006Y1\u000f^8q\r\u0006LG.\u001e:f\u0011%\u0011yN\u000bI\u0001\u0002\u0004\tI%A\u0013wKJLg-_!wC&d\u0017MY5mSRLX*\u001a;sS\u000e\fe\r^3s%\u0016\u001cwN^3ss\u0006\u0011c/\u001a:jMf4\u0015-\u001b7ve\u0016\fe\u000e\u001a*fG>4XM]=%I\u00164\u0017-\u001e7uIQ*\"A!:+\t\u0005%#q]\u0016\u0003\u0005S\u0004BAa;\u0003v6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0A\u0005v]\u000eDWmY6fI*\u0019!1_!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003x\n5(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006yq/Y5u\r>\u0014(+Z2pm\u0016\u0014\u0018\u0010F\u0001q\u0003)\t7\r\u001c\"j]\u0012Lgn\u001a\u000b\u0007\u0007\u0003\u0019ia!\b\u0011\t\r\r1\u0011B\u0007\u0003\u0007\u000bQ1aa\u0002{\u0003\r\t7\r\\\u0005\u0005\u0007\u0017\u0019)A\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDqaa\u0004.\u0001\u0004\u0019\t\"\u0001\u0007sKN|WO]2f)f\u0004X\r\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\r\u00199B_\u0001\te\u0016\u001cx.\u001e:dK&!11DB\u000b\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u0011\u001d\u0019y\"\fa\u0001\u0007C\ta\u0002]3s[&\u001c8/[8o)f\u0004X\r\u0005\u0003\u0004\u0004\r\r\u0012\u0002BB\u0013\u0007\u000b\u0011\u0011#Q2m!\u0016\u0014X.[:tS>tG+\u001f9f\u0003-\tG\r\u001a'j].\f5\r\\:)\u000f\u0001\u0019Y#!\u001d\u00042A!\u0011qBB\u0017\u0013\u0011\u0019y#!\u0005\u0003\u0007Q\u000bw-\t\u0002\u00044\u0005Y\u0011N\u001c;fOJ\fG/[8oQ\u001d\u000111FA9\u0007o\t#a!\u000f\u0002!\t\f'0\u001a7;g&TXM\u000f7be\u001e,\u0007f\u0002\u0001\u0004,\u0005E4QH\u0011\u0003\u0007\u007f\tACY1{K2T4\u000f[1sI~\u001bw.\u001e8uuE\"\u0004")
public class ClusterLinkFailureTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor = (short)3;
    private final String consumerGroup;
    private final long syncMs;
    private final long retryMs;
    private final int numRecords;
    private ConfluentAdmin destAdmin;
    private Uuid linkId;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public long syncMs() {
        return this.syncMs;
    }

    public long retryMs() {
        return this.retryMs;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(ConfluentAdmin x$1) {
        this.destAdmin = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private void linkId_$eq(Uuid x$1) {
        this.linkId = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClassName(testInfo));
            this.sourceCluster().serverConfig().setProperty("super.users", new StringBuilder(11).append("User:").append(JaasTestUtils$.MODULE$.KafkaScramAdmin()).append(";User:").append(JaasTestUtils$.MODULE$.KafkaScramUser2()).toString());
        }
        super.setUp(testInfo);
        this.addLinkAcls();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$9 = qual$1.createConfluentAdminClient$default$1();
        this.destAdmin_$eq(qual$1.createConfluentAdminClient(x$9));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorTopicOperationsOnLinkFailure(String quorum, boolean coordinator) {
        void var12_16;
        Tuple2 tuple2;
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid");
        this.waitForFailure(this.destAdmin(), FailureType$CorruptConfigs$.MODULE$, this.waitForFailure$default$3());
        String topic2 = "linkedTopic2";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic2, x$2, 2, x$4, x$5, x$6);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$9 = this.linkName();
            Map<String, String> x$10 = qual$2.linkTopic$default$4();
            String x$11 = qual$2.linkTopic$default$5();
            qual$2.linkTopic(topic2, (short)2, x$9, x$10, x$11);
        });
        this.destCluster().deleteTopic(this.topic(), true);
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode).name());
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var24_14 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple22._1();
        Assertions.assertTrue((boolean)var12_16.available(), (String)"Link not available");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, (short)2, x$14, x$15, x$16);
        this.waitForRecovery();
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceClusterNotAvailable(String quorum, boolean coordinator) {
        this.verifyFailureAndRecovery(FailureType$NetworkFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().killAllBrokers(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.restartCluster(this.sourceCluster(), this.restartCluster$default$2()), true);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDeleteLinkDuringRetry(String quorum, boolean coordinator) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().updateZkLinkConfig(this.linkId(), "bootstrap.servers", "999.999.999.999:0000");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDeleteLinkDuringRetry$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyFailureRetryMetric((Option<String>)new Some((Object)this.linkName()));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Seq<KafkaBroker> x$3 = qual$1.deleteClusterLink$default$3();
        qual$1.deleteClusterLink(x$1, true, x$3);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$42 = qual$2.listClusterLinks$default$1();
        Option<String> x$5 = qual$2.listClusterLinks$default$2();
        Assertions.assertTrue((boolean)qual$2.listClusterLinks(x$42, x$5).isEmpty());
        Assertions.assertFalse((boolean)this.destCluster().brokers().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDeleteLinkDuringRetry$3(this, x$4))));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testRetryTaskStateManagement(String quorum, boolean coordinator) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().updateZkLinkConfig(this.linkId(), "bootstrap.servers", "999.999.999.999:0000");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testRetryTaskStateManagement$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyFailureRetryMetric((Option<String>)new Some((Object)this.linkName()));
        this.verifyTaskStateAndMetrics((TaskState)ActiveTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)((Seq)package$.MODULE$.Seq().empty()), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkRetryTaskTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)new Some((Object)"retry-task"), (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().empty()));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Seq<KafkaBroker> x$3 = qual$1.deleteClusterLink$default$3();
        qual$1.deleteClusterLink(x$1, true, x$3);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$4 = qual$2.listClusterLinks$default$1();
        Option<String> x$52 = qual$2.listClusterLinks$default$2();
        Assertions.assertTrue((boolean)qual$2.listClusterLinks(x$4, x$52).isEmpty());
        Assertions.assertFalse((boolean)this.destCluster().brokers().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testRetryTaskStateManagement$4(this, x$5))));
        this.verifyTaskStateAndMetrics((TaskState)UnknownTaskState$.MODULE$, (Seq<Tuple2<TaskErrorCode, Option<String>>>)new .colon.colon((Object)new Tuple2((Object)LinkNotFoundTaskErrorCode$.MODULE$, (Object)new Some((Object)"Failed to find link")), (List)Nil$.MODULE$), this.linkName(), (Function2<ClusterLinkFactory.LinkManager, String, Option<TaskDescription>>)(Function2 & Serializable)(linkManager, linkName) -> this.taskDesc((TaskType)ClusterLinkRetryTaskTaskType$.MODULE$, (ClusterLinkFactory.LinkManager)linkManager, (String)linkName), (Option<String>)None$.MODULE$, (Seq<KafkaBroker>)this.destCluster().brokers().toSeq(), (Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().empty()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAuthenticationFailure(String quorum, boolean coordinator) {
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        ObjectRef newJaasConfig = ObjectRef.create(null);
        this.verifyFailureAndRecovery(FailureType$AuthenticationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            newJaasConfig$1.elem = this.updateCredentials(connectionTarget);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)((String)newJaasConfig$1.elem))})))), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAuthorizationFailure(String quorum, boolean coordinator) {
        AclBinding denyTopicAcl = this.aclBinding(ResourceType.TOPIC, AclPermissionType.DENY);
        this.verifyFailureAndRecovery(FailureType$AuthorizationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().deleteAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testCorruptConfigs(String quorum, boolean coordinator) {
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.verifyFailureAndRecovery(FailureType$CorruptConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> ClusterLinkFailureTest.$anonfun$testCorruptConfigs$2(this, (Product)destConnectionMode)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testUndecodableConfigs(String quorum, boolean coordinator) {
        Properties linkConfigs = new Properties();
        this.verifyFailureAndRecovery(FailureType$UndecodableConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.makeConfigUndecodable$1(linkConfigs), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.reconfigureLink$1(linkConfigs), this.verifyFailureAndRecovery$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testListDescribeWithoutConfigs(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().updateZkLinkConfig(this.linkId(), "bootstrap.servers", "invalid");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listClusterLinks$default$1();
        Option<String> x$2 = qual$1.listClusterLinks$default$2();
        Seq<ClusterLinkListing> res1 = qual$1.listClusterLinks(x$1, x$2);
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).linkName(), (Object)this.linkName());
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).clusterLinkError(), (Object)ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR);
        this.createClusterLink("test-link2", this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$3 = qual$2.describeClusterLinks$default$1();
        Option<String> x$4 = qual$2.describeClusterLinks$default$2();
        int x$5 = qual$2.describeClusterLinks$default$3();
        boolean x$6 = qual$2.describeClusterLinks$default$4();
        Seq<ClusterLinkDescription> res2 = qual$2.describeClusterLinks(x$3, x$4, x$5, x$6);
        Assertions.assertEquals((int)res2.size(), (int)2);
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$3(this, x$7)))).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$4(x$8))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$5(x$9)))).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$6(x$10))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$7(this, x$11)))).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$8(x$12))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$9(x$13)))).exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$10(x$14))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceTopicDelete(String quorum, boolean coordinator) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        Uuid sourceTopicId = this.sourceCluster().describeTopic(this.topic()).topicId();
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicMayBeDeleted(), this.waitForFailure$default$3());
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        boolean x$2 = qual$1.describeMirrorTopic$default$2();
        Assertions.assertEquals((Object)sourceTopicId, (Object)qual$1.describeMirrorTopic(x$1, x$2).sourceTopicId());
        Properties topicProps = new Properties();
        topicProps.put("max.message.bytes", "100000");
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$3 = this.topic();
        short x$5 = this.replicationFactor();
        ListenerName x$7 = qual$2.createTopic$default$5();
        Properties x$8 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$3, 1, x$5, topicProps, x$7, x$8);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        Assertions.assertEquals((int)this.numPartitions(), (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Option maxMessageSize = Option$.MODULE$.apply((Object)this.destCluster().describeTopicConfig(this.topic()).get("max.message.bytes"));
        Assertions.assertTrue((boolean)maxMessageSize.nonEmpty());
        Assertions.assertNotEquals((Object)"100000", (Object)((ConfigEntry)maxMessageSize.get()).value());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicMayBeDeleted(), this.waitForFailure$default$3());
        String x$9 = this.topic();
        Seq<KafkaBroker> x$11 = this.verifyMirror$default$2();
        boolean x$12 = this.verifyMirror$default$4();
        this.verifyMirror(x$9, x$11, false, x$12);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testConnectionQuota(String quorum, boolean coordinator) {
        this.verifyFailureAndRecovery(FailureType$NetworkFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.setMaxClientConnections$1(1), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.setMaxClientConnections$1(1000), this.verifyFailureAndRecovery$default$4());
        this.assertAllClientConnectionsClosed((Seq<KafkaBroker>)this.destCluster().brokers());
    }

    /*
     * WARNING - void declaration
     */
    public void assertAllClientConnectionsClosed(Seq<KafkaBroker> servers) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$assertAllClientConnectionsClosed$1(this, servers)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"All client connections should be closed on deleting the link");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceTopicRecreateDetectionUsingTopicIds(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(300000L, 300000L, this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(this, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Destination epoch not bumped");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(5);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        this.truncate(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicIdChanged(), this.waitForFailure$default$3());
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        String x$7 = this.topic();
        Seq<KafkaBroker> x$10 = this.verifyMirror$default$2();
        this.verifyMirror(x$7, x$10, false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testSourceLeaderChanges(String quorum, boolean coordinator) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        this.verifyMirrorWithSourceEpochChanges(false, this.verifyMirrorWithSourceEpochChanges$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyLinkedLeaderChangeMetrics();
        String x$1 = this.topic();
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        boolean x$4 = this.verifyMirror$default$3();
        this.verifyMirror(x$1, x$3, x$4, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testUncleanSourceLeaderElectionWithDestEpochAhead(String quorum, boolean coordinator) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        this.verifyMirrorWithSourceEpochChanges(true, this.verifyMirrorWithSourceEpochChanges$default$2());
        this.verifyLinkedLeaderChangeMetrics();
        String x$1 = this.topic();
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        boolean x$4 = this.verifyMirror$default$3();
        this.verifyMirror(x$1, x$3, x$4, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDisallowTruncationBelowHWM(String quorum, boolean coordinator) {
        this.destCluster().killAllBrokers();
        this.destCluster().updateBrokerConfig((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.cluster.link.allow.truncation.below.hwm"), (Object)"false")}))));
        this.destCluster().restartDeadBrokers(true);
        this.destCluster().updateBootstrapServers();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        this.destAdmin_$eq(qual$1.createConfluentAdminClient(x$1));
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        this.destCluster().brokers().foreach((Function1 & Serializable)broker -> {
            ClusterLinkFailureTest.$anonfun$testDisallowTruncationBelowHWM$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.verifyMirrorWithSourceEpochChanges(false, false);
        this.waitForFailure(this.destAdmin(), FailureType$TruncationBelowHighWatermark$.MODULE$, this.waitForFailure$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDestLeaderChanges(String quorum, boolean coordinator) {
        void var20_20;
        void var18_18;
        this.numPartitions_$eq(this.sourceCluster().brokerCount());
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader1 = tuple2._1$mcI$sp();
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1$adapted(this, (int)var18_18, arg_0))), this.waitForMirror$default$2());
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        this.destCluster().startBroker((int)var18_18);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2$adapted(this, (int)var20_20, arg_0))), this.waitForMirror$default$2());
        this.destCluster().startBroker((int)var20_20);
        this.produceToSourceCluster(this.numPartitions());
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDestFollowerAheadOfLeader(String quorum, boolean coordinator) {
        void var22_22;
        void var20_20;
        void var17_17;
        void var16_16;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, 2, x$4, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, (short)2, x$9, x$10, x$11);
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int destBroker1 = tuple2._1$mcI$sp();
        int destLeaderEpoch1 = tuple2._2$mcI$sp();
        int destBroker2 = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, (int)var16_16, (int)var17_17, 15000L);
        this.produceToSourceCluster(100);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> {
            this.sourceCluster().bounceLeader(tp);
            this.produceToSourceCluster(100);
        });
        Tuple2<Object, Object> tuple22 = this.sourceCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int sourceBroker1 = tuple22._1$mcI$sp();
        this.produceToSourceCluster(100);
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().serverWithBrokerId(destBroker2), (List)Nil$.MODULE$), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple23 = this.destCluster().shutdownLeader(tp);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int destLeaderEpoch2 = tuple23._2$mcI$sp();
        this.sourceCluster().shutdownLeader(tp);
        this.truncate(100);
        this.sourceCluster().startBroker((int)var20_20);
        this.destCluster().startBroker((int)var16_16);
        int newLeader = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, destBroker2, (int)var22_22, 15000L);
        Assertions.assertEquals((int)var16_16, (int)newLeader);
        this.destCluster().startBroker(destBroker2);
        this.produceToSourceCluster(100);
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestReplicationNotImpactedBySourceFailures(String quorum, boolean coordinator) {
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(new Properties(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        Seq<KafkaBroker> x$4 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$4, false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestReplicationNotImpactedBySourceFailuresWithOldMessageFormat(String quorum, boolean coordinator) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("message.format.version", "0.9.0");
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        Seq<KafkaBroker> x$4 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$4, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestinationHighWatermark(String quorum, boolean coordinator) {
        void var59_43;
        Tuple2 tuple2;
        void var56_36;
        Tuple2 tuple22;
        void var53_29;
        Tuple2 tuple23;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, props, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        LongRef startOffset = LongRef.create((long)0L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.destCluster().brokers(), tp, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        Buffer destReplicaManagers = (Buffer)((IterableOps)this.destCluster().brokers().map((Function1 & Serializable)x$23 -> x$23.replicaManager())).filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$9(tp, x$24)));
        ReplicaManager sourceReplicaManager = this.sourceCluster().partitionLeader(tp).replicaManager();
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        destReplicaManagers.foreach((Function1 & Serializable)replicaManager -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$10(this, tp, startOffset, replicaManager);
            return BoxedUnit.UNIT;
        });
        startOffset.elem = 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$25 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$11(x$25);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(100);
        long verifyLog$1_highWatermark = this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)sourceReplicaManager.getLog(tp).get();
        int verifyLog$1_endOffset = this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var67_26 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset.elem, (long)var53_29, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var74_33 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var56_36, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var81_40 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var59_43, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        Object var50_21 = null;
        tuple24 = null;
        tuple25 = null;
        tuple26 = null;
        destReplicaManagers.foreach((Function1 & Serializable)replicaManager -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$12(this, tp, startOffset, replicaManager);
            return BoxedUnit.UNIT;
        });
        int follower = ((ReplicaManager)((IterableOps)destReplicaManagers.filter((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$13(tp, x$26)))).head()).config().brokerId();
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        long x$12 = this.producedRecords().size() - 100;
        ReplicaManager x$13 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$13, x$12, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$15(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Fetcher count is not zero after pausing cluster link");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset() - 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$27 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$17(x$27);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        startOffset.elem -= 50L;
        long x$14 = startOffset.elem;
        ReplicaManager x$15 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$15, x$14, tp, startOffset);
        startOffset.elem += 50L;
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$18(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Fetcher count is not zero after pausing cluster link");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset();
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$28 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$20(x$28);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$16 = this.linkName();
        Map x$17 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        .colon.colon x$18 = new .colon.colon((Object)this.destCluster().partitionLeader(tp), (List)Nil$.MODULE$);
        Set<String> x$192 = qual$3.alterClusterLink$default$4();
        boolean x$20 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$16, (Map<String, String>)x$17, (Seq<KafkaBroker>)x$18, x$192, x$20);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.bufferedProduceToSource$1(100);
        long x$21 = startOffset.elem;
        ReplicaManager x$22 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$22, x$21, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.produceToSourceCluster(100);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().startBroker(follower);
        this.verifyLog$1(this.destCluster().serverWithBrokerId(follower).replicaManager(), this.verifyLog$default$2$1(), tp, startOffset);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache(String quorum) {
        Assumptions.assumeTrue((boolean)this.clusterLinkPrefix().isEmpty());
        this.verifyNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDeleteAutoCreatedMirrorTopicForFailedLink(String quorum, boolean coordinator) {
        String autoCreatedTopic = "autoCreatedTopic";
        String nonAutoCreatedTopic = "nonAutoCreatedTopic";
        String topicFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(autoCreatedTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)})))));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(autoCreatedTopic, x$2, 2, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(nonAutoCreatedTopic, x$8, 2, x$10, x$11, x$12);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = this.linkName();
        Map<String, String> x$16 = qual$3.linkTopic$default$4();
        String x$17 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(nonAutoCreatedTopic, (short)2, x$15, x$16, x$17);
        this.waitForAutoMirrorCreation(autoCreatedTopic);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"999.999.999.999:0000")}));
        Seq<KafkaBroker> x$21 = qual$4.alterClusterLink$default$3();
        Set<String> x$22 = qual$4.alterClusterLink$default$4();
        qual$4.alterClusterLink(x$18, (Map<String, String>)x$19, x$21, x$22, false);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().deleteTopic(this.topic(), true);
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(autoCreatedTopic, false));
        this.destCluster().killAllBrokers();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        boolean x$23 = qual$5.restartDeadBrokers$default$1();
        qual$5.restartDeadBrokers(x$23);
        this.destCluster().updateBootstrapServers();
        this.destCluster().deleteTopic(nonAutoCreatedTopic, true);
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(autoCreatedTopic, false));
    }

    public void verifyFailureAndRecovery(FailureType failureType, Function0<BoxedUnit> startFailure, Function0<BoxedUnit> stopFailure, boolean verifyAvailabilityMetricAfterRecovery) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        startFailure.apply$mcV$sp();
        this.waitForFailure(this.destAdmin(), failureType, this.waitForFailure$default$3());
        stopFailure.apply$mcV$sp();
        this.waitForRecovery();
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyOffsetMigration(this.topic(), 0, 10L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        if (verifyAvailabilityMetricAfterRecovery) {
            double unavailabilityCount = this.unavailabilityCountMetricValueOnDest(this.linkName(), this.unavailabilityCountMetricValueOnDest$default$2());
            Thread.sleep(5L * this.retryMs());
            Assertions.assertEquals((double)unavailabilityCount, (double)this.unavailabilityCountMetricValueOnDest(this.linkName(), this.unavailabilityCountMetricValueOnDest$default$2()), (double)0.0);
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$4 = qual$1.unlinkTopic$default$3();
        boolean x$5 = qual$1.unlinkTopic$default$5();
        int x$6 = qual$1.unlinkTopic$default$6();
        qual$1.unlinkTopic(x$1, x$2, x$4, false, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        boolean x$8 = qual$2.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$9 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$7, x$8, x$9);
    }

    public boolean verifyFailureAndRecovery$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForRecovery() {
        void var5_13;
        Tuple2 tuple2;
        void var2_6;
        Tuple2 tuple22;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_4 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple23._1();
        Assertions.assertTrue((boolean)var2_6.available(), (String)"Link not available");
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        Set activePartitionState = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE}));
        long l2 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Set computeUntilTrue_result;
            if (ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState, computeUntilTrue_result = this.mirrorPartitionStates(this.destAdmin(), this.mirrorPartitionStates$default$2()))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var19_11 = null;
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        Set actualStates = (Set)tuple24._1();
        Assertions.assertEquals((Object)activePartitionState, (Object)var5_13);
        this.waitForLinkCountMetric(this.destinationLinkMode(), "active", this.destCluster());
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)this.numPartitions(), (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-partition-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        this.kafkaMetricMaxValue(this.destCluster().aliveServers(), "broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), (Option<String>)new Some((Object)this.linkName()), (Map<String, String>)((Map)Map$.MODULE$.empty()), false, this.kafkaMetricMaxValue$default$7(), this.kafkaMetricMaxValue$default$8());
    }

    private AclBinding aclBinding(ResourceType resourceType, AclPermissionType permissionType) {
        ResourcePattern resource = new ResourcePattern(resourceType, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(new StringBuilder(5).append("User:").append(this.linkUserName(this.linkName())).toString(), "*", AclOperation.ALL, permissionType);
        return new AclBinding(resource, ace);
    }

    private void addLinkAcls() {
        this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)this.aclBinding(ResourceType.TOPIC, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.CLUSTER, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.GROUP, AclPermissionType.ALLOW), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLinkDuringRetry$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLinkDuringRetry$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLinkDuringRetry$3(ClusterLinkFailureTest $this, KafkaBroker x$4) {
        return ((ClusterLinkManager)x$4.clusterLinkManager()).getLinkRetryState($this.linkName()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRetryTaskStateManagement$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testRetryTaskStateManagement$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryTaskStateManagement$4(ClusterLinkFailureTest $this, KafkaBroker x$5) {
        return ((ClusterLinkManager)x$5.clusterLinkManager()).getLinkRetryState($this.linkName()).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testCorruptConfigs$2(ClusterLinkFailureTest $this, Product destConnectionMode$1) {
        $this.destCluster().updateZkLinkConfig($this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode$1).name());
    }

    private final void makeConfigUndecodable$1(Properties linkConfigs$1) {
        Properties props = ((KafkaServer)this.destCluster().servers().head()).zkClient().getEntityConfigs("cluster-links", CoreUtils$.MODULE$.toJavaUUID(this.linkId()).toString());
        Properties decodedProps = ((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().configEncoder().decode(props);
        linkConfigs$1.putAll((java.util.Map<?, ?>)decodedProps);
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "bad-secret");
        Properties newProps = new SecureLinkConfigEncoder(KafkaConfig$.MODULE$.fromProps(brokerProps)).encode(decodedProps);
        new AdminZkClient(((KafkaServer)this.destCluster().servers().head()).zkClient(), (Option)None$.MODULE$).changeClusterLinkConfig(this.linkId(), newProps);
    }

    public static final /* synthetic */ boolean $anonfun$testUndecodableConfigs$2(Tuple2 x$6) {
        Object object = x$6._1();
        String string = ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp();
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final void reconfigureLink$1(Properties linkConfigs$1) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkName());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)this.destAdmin().describeConfigs(Collections.singleton(resource)).all(), (Class<? extends Throwable>)InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(linkConfigs$1).asScala().filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testUndecodableConfigs$2(x$6))))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(linkConfigs$1).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeWithoutConfigs$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$3(ClusterLinkFailureTest $this, ClusterLinkDescription x$7) {
        return x$7.linkName().equals($this.linkName());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$4(ClusterLinkDescription x$8) {
        return x$8.linkState().equals((Object)ClusterLinkDescription.LinkState.FAILED);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$5(ClusterLinkDescription x$9) {
        return x$9.linkName().equals("test-link2");
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$6(ClusterLinkDescription x$10) {
        return x$10.linkState().equals((Object)ClusterLinkDescription.LinkState.ACTIVE);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$7(ClusterLinkFailureTest $this, ClusterLinkDescription x$11) {
        return x$11.linkName().equals($this.linkName());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$8(ClusterLinkDescription x$12) {
        return x$12.clusterLinkError().equals((Object)ClusterLinkError.UNRESOLVABLE_BOOTSTRAP_ERROR);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$9(ClusterLinkDescription x$13) {
        return x$13.linkName().equals("test-link2");
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$10(ClusterLinkDescription x$14) {
        return x$14.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR);
    }

    private final void setMaxClientConnections$1(int maxCount) {
        ClusterLinkTestHarness qual$1 = this.destCluster();
        ListenerName x$1 = qual$1.createSuperuserAdminClient$default$1();
        Properties x$2 = qual$1.createSuperuserAdminClient$default$2();
        qual$1.createSuperuserAdminClient(x$1, x$2).incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry("confluent.cluster.link.max.client.connections", String.valueOf(maxCount)), AlterConfigOp.OpType.SET)))).all().get();
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
    }

    private final int activeClientConnections$1(Seq servers$1) {
        MetricName activeClientConnectionMetricName = ClusterLinkMetrics$.MODULE$.activeClientConnectionsCountMetricName();
        String x$2 = activeClientConnectionMetricName.name();
        String x$3 = activeClientConnectionMetricName.group();
        None$ x$4 = None$.MODULE$;
        Map<String, String> x$6 = this.kafkaMetricMaxValue$default$5();
        boolean x$7 = this.kafkaMetricMaxValue$default$6();
        boolean x$8 = this.kafkaMetricMaxValue$default$7();
        return (int)this.kafkaMetricMaxValue((Seq<KafkaBroker>)servers$1, x$2, x$3, (Option<String>)x$4, x$6, x$7, x$8, true);
    }

    public static final /* synthetic */ boolean $anonfun$assertAllClientConnectionsClosed$1(ClusterLinkFailureTest $this, Seq servers$1) {
        return $this.activeClientConnections$1(servers$1) == 0;
    }

    public static final /* synthetic */ String $anonfun$assertAllClientConnectionsClosed$2() {
        return "All client connections should be closed on deleting the link";
    }

    public static final /* synthetic */ boolean $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(ClusterLinkFailureTest $this, TopicPartition tp$1) {
        return $this.destCluster().leaderEpoch(tp$1) > 0;
    }

    public static final /* synthetic */ String $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$2() {
        return "Destination epoch not bumped";
    }

    public static final /* synthetic */ void $anonfun$testDisallowTruncationBelowHWM$1(ClusterLinkFailureTest $this, KafkaBroker broker) {
        TestUtils.setFieldValue((Object)((ClusterLinkFetcherManager)broker.clusterLinkManager().fetcherManager($this.linkId()).get()), (String)"isCloudToCloudLink", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$1(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$15) {
        KafkaBroker kafkaBroker = x$15;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader1$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$2(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$16) {
        KafkaBroker kafkaBroker = x$16;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader2$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    private static final String logDesc$1(ReplicaManager replicaManager$1, TopicPartition tp$3, AbstractLog log$1, LongRef startOffset$1, int endOffset$1, long highWatermark$1) {
        return new StringBuilder(67).append("isLeader=").append(replicaManager$1.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(log$1.logStartOffset()).append(", end=").append(log$1.logEndOffset()).append(", hwm=").append(log$1.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset$1).append(", hwm=").append(highWatermark$1).append(")").toString();
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$2(AbstractLog log$1) {
        return log$1.logStartOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$3(LongRef startOffset$1, long x$20) {
        return x$20 == startOffset$1.elem;
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$4(AbstractLog log$1) {
        return log$1.logEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$5(int endOffset$1, long x$21) {
        return x$21 == (long)endOffset$1;
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$6(AbstractLog log$1) {
        return log$1.highWatermark();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$7(long highWatermark$1, long x$22) {
        return x$22 == highWatermark$1;
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLog$1(ReplicaManager replicaManager, long highWatermark, TopicPartition tp$3, LongRef startOffset$1) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        AbstractLog log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int endOffset = this.producedRecords().size();
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l2 = log.logStartOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l4 = log.logEndOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long computeUntilTrue_waitTime3 = 15000L;
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l6 = log.highWatermark();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime3), (long)computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
    }

    private final ReplicaManager verifyLog$default$1$1(TopicPartition tp$3) {
        return this.destCluster().partitionLeader(tp$3).replicaManager();
    }

    private final long verifyLog$default$2$1() {
        return this.producedRecords().size();
    }

    private final void bufferedProduceToSource$1(int numRecords) {
        this.sourceCluster().producerConfig().setProperty("linger.ms", "100");
        this.produceToSourceCluster(numRecords);
        this.sourceCluster().producerConfig().remove("linger.ms");
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$9(TopicPartition tp$3, ReplicaManager x$24) {
        return x$24.getLog(tp$3).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$10(ClusterLinkFailureTest $this, TopicPartition tp$3, LongRef startOffset$1, ReplicaManager replicaManager) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        long verifyLog$1_highWatermark = $this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int verifyLog$1_endOffset = $this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$11(Map x$25) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$12(ClusterLinkFailureTest $this, TopicPartition tp$3, LongRef startOffset$1, ReplicaManager replicaManager) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        long verifyLog$1_highWatermark = $this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int verifyLog$1_endOffset = $this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$14(Partition p) {
        return !p.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$13(TopicPartition tp$3, ReplicaManager x$26) {
        return x$26.onlinePartition(tp$3).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$14(p)));
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$15(ClusterLinkFailureTest $this) {
        return $this.maxFetcherCount($this.linkId()) == 0;
    }

    public static final /* synthetic */ String $anonfun$testDestinationHighWatermark$16() {
        return "Fetcher count is not zero after pausing cluster link";
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$17(Map x$27) {
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$18(ClusterLinkFailureTest $this) {
        return $this.maxFetcherCount($this.linkId()) == 0;
    }

    public static final /* synthetic */ String $anonfun$testDestinationHighWatermark$19() {
        return "Fetcher count is not zero after pausing cluster link";
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$20(Map x$28) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$waitForRecovery$4(Set activePartitionState$1, Set x$30) {
        Set set = x$30;
        return !(set != null ? !set.equals(activePartitionState$1) : activePartitionState$1 != null);
    }

    public ClusterLinkFailureTest() {
        this.consumerGroup = "testGroup";
        this.syncMs = 100L;
        this.retryMs = 1000L;
        this.numRecords = 20;
    }

    public static final /* synthetic */ Object $anonfun$testMirrorTopicOperationsOnLinkFailure$3$adapted(ClusterLinkListing x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.available());
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$1$adapted(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$15) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1($this, leader1$1, x$15));
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$2$adapted(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$16) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2($this, leader2$1, x$16));
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$2$adapted(ClusterLinkListing x$29) {
        return BoxesRunTime.boxToBoolean((boolean)x$29.available());
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$4$adapted(Set activePartitionState$1, Set x$30) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState$1, x$30));
    }
}

