/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType;
import kafka.link.FailureType$;
import kafka.link.FailureType$CircularMirror$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:4")})
@ScalaSignature(bytes="\u0006\u0005\u0005=x!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%)\u0001\u000e\u0005\u0007q\u0005\u0001\u000bQB\u001b\u0007\t%\u0012\u0003!\u000f\u0005\u0006c\u0015!\t!\u0010\u0005\b\u007f\u0015\u0011\r\u0011\"\u0011A\u0011\u0019!U\u0001)A\u0005\u0003\"IQ)\u0002a\u0001\u0002\u0003\u0006KA\u0012\u0005\u0006%\u0016!\te\u0015\u0005\u0006;\u0016!\tA\u0018\u0005\u0006G\u0016!\tA\u0018\u0005\u0006K\u0016!\tA\u0018\u0005\u0006O\u0016!\tA\u0018\u0005\u0006S\u0016!\tA\u0018\u0005\u0006W\u0016!\tA\u0018\u0005\u0006[\u0016!\tA\u001c\u0005\b\u0003\u001f)A\u0011AA\t\u0011\u001d\tY\"\u0002C\u0001\u0003;Aa!a\n\u0006\t\u0003q\u0006BBA\u0016\u000b\u0011\u0005a\fC\u0004\u00020\u0015!I!!\r\t\u0013\u0005}R!%A\u0005\n\u0005\u0005\u0003bBA,\u000b\u0011%\u0011\u0011\f\u0005\b\u0003G*A\u0011BA3\u0011\u001d\tI'\u0002C\u0005\u0003WBa!!\u001f\u0006\t\u0003q\u0006bBA?\u000b\u0011\u0005\u0011q\u0010\u0005\b\u0003k+A\u0011AA\\\u0011\u001d\t\u0019-\u0002C\u0005\u0003\u000bD\u0011\"!6\u0006#\u0003%I!a6\t\u0013\u0005mW!%A\u0005\n\u0005]\u0017\u0001F\"mkN$XM\u001d'j].L%\r\u001d\u001a7)\u0016\u001cHO\u0003\u0002$I\u0005!A.\u001b8l\u0015\u0005)\u0013!B6bM.\f7\u0001\u0001\t\u0003Q\u0005i\u0011A\t\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u00132qeY\"Vm\u001d;\u0014\u0005\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002O\u0005iB+Z:u/&$\b\u000eU1sC6,G/\u001a:ju\u0016$Gk\u001c9jG&#7/F\u00016\u001f\u00051\u0014%A\u001c\u0002;m$\u0017n\u001d9mCft\u0015-\\3~]U\u001cX\rV8qS\u000eLEm]\u001f|au\fa\u0004V3ti^KG\u000f\u001b)be\u0006lW\r^3sSj,G\rV8qS\u000eLEm\u001d\u0011\u0014\u0005\u0015Q\u0004C\u0001\u0015<\u0013\ta$E\u0001\u0012BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u000b\u0002}A\u0011\u0001&B\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014X#A!\u0011\u00051\u0012\u0015BA\".\u0005\u0015\u0019\u0006n\u001c:u\u0003I\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0013}#Xm\u001d;J]\u001a|\u0007CA$Q\u001b\u0005A%BA%K\u0003\r\t\u0007/\u001b\u0006\u0003\u00172\u000bqA[;qSR,'O\u0003\u0002N\u001d\u0006)!.\u001e8ji*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u0011Q+7\u000f^%oM>\fQa]3u+B$\"\u0001V,\u0011\u00051*\u0016B\u0001,.\u0005\u0011)f.\u001b;\t\u000baS\u0001\u0019\u0001$\u0002\u0011Q,7\u000f^%oM>D#A\u0003.\u0011\u0005\u001d[\u0016B\u0001/I\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001ci\u0016\u001cHoU8ve\u000e,7\t[1oO\u0016\u0004&o\u001c9bO\u0006$\u0018n\u001c8\u0015\u0003QC#a\u00031\u0011\u0005\u001d\u000b\u0017B\u00012I\u0005\u0011!Vm\u001d;\u0002cQ,7\u000f^+oG2,\u0017M\\*pkJ\u001cW\rT3bI\u0016\u0014X\t\\3di&|gnV5uQ\u0012+7\u000f^#q_\u000eD\u0017\t[3bI\"\u0012A\u0002Y\u0001<i\u0016\u001cHOT8UeVt7-\u0019;j_:\u0014U\r\\8x\u0011&<\u0007nV1uKJl\u0017M]6XSRDW)\u001c9us2+\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007FA\u0007a\u0003)\"Xm\u001d;NSJ\u0014xN],ji\"\u001cv.\u001e:dK\u001a\u000b\u0017\u000e\\;sKN<\u0016\u000e\u001e5PY\u0012$Um\u001d;Ja\nD#A\u00041\u0002YQ,7\u000f^'jeJ|'oV5uQN{WO]2f\r\u0006LG.\u001e:fg^KG\u000f[(mIN{WO]2f\u0013B\u0014\u0007FA\ba\u0003\t\"Xm\u001d;O_:luN\\8u_:L7mU8ve\u000e,G*Z1eKJ,\u0005o\\2ig\"\u0012\u0001\u0003Y\u00013i\u0016\u001cHoU8ve\u000e,Gk\u001c9jGJ+7M]3bi\u0016$U\r^3di\u0016$w+\u001b;i5\u0016\u0014xnU8ve\u000e,W\t]8dQR\u0011Ak\u001c\u0005\u0006aF\u0001\r!]\u0001\fkN,Gk\u001c9jG&#7\u000f\u0005\u0002-e&\u00111/\f\u0002\b\u0005>|G.Z1oQ\u0011\tRo\u001f\u001c\u0011\u0005YLX\"A<\u000b\u0005aT\u0015A\u00029be\u0006l7/\u0003\u0002{o\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.\u001a\u0015\u0007#u\f9!!\u0003\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\ta^\u0001\taJ|g/\u001b3fe&\u0019\u0011QA@\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u00111BA\u00073\u0005\t\u0011$\u0001\u0001\u0002aQ,7\u000f^*pkJ\u001cW\rV8qS\u000e\u0014Vm\u0019:fCR,G)\u001a;fGR,GmV5uQ\n\u000b7m[<be\u0012,\u0005o\\2i)\r!\u00161\u0003\u0005\u0006aJ\u0001\r!\u001d\u0015\u0005%U\\h\u0007\u000b\u0004\u0013{\u0006\u001d\u0011\u0011\u0004\u0017\u0005\u0003\u0017\ti!\u0001\u001buKN$8k\\;sG\u0016$v\u000e]5d%\u0016\u001c'/Z1uK\u0012+G/Z2uK\u0012<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tG/\u00129pG\"$2\u0001VA\u0010\u0011\u0015\u00018\u00031\u0001rQ\u0011\u0019Ro\u001f\u001c)\rMi\u0018qAA\u0013Y\u0011\tY!!\u0004\u0002WQ,7\u000f^*pkJ\u001cW\rV8qS\u000e\u0014Vm\u0019:fCR,G)\u001a;fGR,GmV5uQR{\u0007/[2JIND#\u0001\u00061\u0002cQ,7\u000f^*pkJ\u001cW\rV8qS\u000e\u0014Vm\u0019:fCR,gj\u001c;EKR,7\r^3e/&$\bn\\;u)>\u0004\u0018nY%eg\"\u0012Q\u0003Y\u0001\u001dg\u0016$X\u000b]*pkJ\u001cW\rV8qS\u000e$U\r\\3uS>tG+Z:u)\u0015!\u00161GA\u001b\u0011\u0015\u0001h\u00031\u0001r\u0011%\t9D\u0006I\u0001\u0002\u0004\tI$\u0001\u0006ok6\u0014VmY8sIN\u00042\u0001LA\u001e\u0013\r\ti$\f\u0002\u0004\u0013:$\u0018AJ:fiV\u00038k\\;sG\u0016$v\u000e]5d\t\u0016dW\r^5p]R+7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\t\u0016\u0005\u0003s\t)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t&L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0001\u0018-^:f\u001fJ,f\u000e]1vg\u0016d\u0015N\\6\u0015\u000bQ\u000bY&a\u0018\t\r\u0005u\u0003\u00041\u0001r\u0003\u0015\u0001\u0018-^:f\u0011\u001d\t\t\u0007\u0007a\u0001\u0003s\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u0004:fGJ,\u0017\r^3U_BL7\rF\u0002U\u0003OBq!a\u000e\u001a\u0001\u0004\tI$A\u0012wKJLg-\u001f$bS2,Gm\u0015;bi\u0016\fe\r^3s)>\u0004\u0018n\u0019*fGJ,\u0017\r^3\u0015\u000bQ\u000bi'a\u001c\t\u000bAT\u0002\u0019A9\t\u000f\u0005E$\u00041\u0001\u0002t\u0005Qb-Y5mkJ,G+\u001f9f/&$\bn\\;u)>\u0004\u0018nY%egB\u0019\u0001&!\u001e\n\u0007\u0005]$EA\u0006GC&dWO]3UsB,\u0017A\u0005;fgR\u001c\u0015N]2vY\u0006\u0014X*\u001b:s_JD#a\u00071\u0002/Q,7\u000f^'jeJ|'\u000fT3hC\u000eL(+Z2pe\u0012\u001cH#\u0002+\u0002\u0002\u0006m\u0005bBAB9\u0001\u0007\u0011QQ\u0001\u0007cV|'/^7\u0011\t\u0005\u001d\u0015Q\u0013\b\u0005\u0003\u0013\u000b\t\nE\u0002\u0002\f6j!!!$\u000b\u0007\u0005=e%\u0001\u0004=e>|GOP\u0005\u0004\u0003'k\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0006e%AB*ue&twMC\u0002\u0002\u00146Ba!!(\u001d\u0001\u0004\t\u0018aC2p_J$\u0017N\\1u_JDS\u0001H;|\u0003C\u000b#!a)\u0002Qm$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL2p_J$\u0017N\\1u_Jl40M?)\u000fq\t9+!,\u00020B\u0019a0!+\n\u0007\u0005-vP\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u00022\u0006\u0012\u00111W\u0001\u000fu.\u001cu.\u001c2j]\u0006$\u0018n\u001c8t\u0003M\"Xm\u001d;NSJ\u0014xN\u001d'fO\u0006\u001c\u0017PU3d_J$7\u000f\u00165s_^\u001chj\\#yG\u0016\u0004H/[8o/\",g.\u00117m_^,G\rF\u0003U\u0003s\u000bY\fC\u0004\u0002\u0004v\u0001\r!!\"\t\r\u0005uU\u00041\u0001rQ\u0015iRo_AQQ\u001di\u0012qUAW\u0003\u0003d#!!-\u0002\u001bM,G/\u00169DYV\u001cH/\u001a:t)\u0015!\u0016qYAi\u0011%\tIM\bI\u0001\u0002\u0004\tY-A\u0004eKN$\u0018J\u00199\u0011\u000b1\ni-!\"\n\u0007\u0005=WF\u0001\u0004PaRLwN\u001c\u0005\n\u0003't\u0002\u0013!a\u0001\u0003\u0017\f\u0011b]8ve\u000e,\u0017J\u00199\u0002/M,G/\u00169DYV\u001cH/\u001a:tI\u0011,g-Y;mi\u0012\nTCAAmU\u0011\tY-!\u0012\u0002/M,G/\u00169DYV\u001cH/\u001a:tI\u0011,g-Y;mi\u0012\u0012\u0004fB\u0003\u0002`\u00065\u0016Q\u001d\t\u0004\u000f\u0006\u0005\u0018bAAr\u0011\n\u0019A+Y4\"\u0005\u0005\u001d\u0018aC5oi\u0016<'/\u0019;j_:Ds!BAp\u0003[\u000bY/\t\u0002\u0002n\u0006\u0019\"-\u0019>fYj\u001a\b.\u0019:e?\u000e|WO\u001c;;i\u0001")
public class ClusterLinkIbp26Test
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private TestInfo _testInfo;

    public static String TestWithParameterizedTopicIds() {
        return "{displayName}.useTopicIds={0}";
    }

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @Test
    public void testSourceChangePropagation() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$4 = qual$1.createDestClusterLink$default$3();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$4, 10000L, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(false, this.verifyMirrorWithSourceEpochChanges$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
    }

    @Test
    public void testUncleanSourceLeaderElectionWithDestEpochAhead() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = qual$1.createDestClusterLink$default$3();
        long x$4 = qual$1.createDestClusterLink$default$4();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$3, x$4, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(true, this.verifyMirrorWithSourceEpochChanges$default$2());
        this.verifyLinkedLeaderChangeMetrics();
        String x$7 = this.topic();
        Seq<KafkaBroker> x$9 = this.verifyMirror$default$2();
        boolean x$10 = this.verifyMirror$default$3();
        this.verifyMirror(x$7, x$9, x$10, false);
    }

    @Test
    public void testNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache() {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.verifyNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache();
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldDestIpb() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        String sourceClusterId = ((KafkaBroker)this.sourceCluster().aliveBrokers().head()).clusterId();
        int recordsBeforeSourceFailure = 10;
        Properties x$22 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$1();
        int x$3 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(x$22, recordsBeforeSourceFailure, x$3);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        KafkaBroker destLeader = this.destCluster().partitionLeader(tp);
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)destLeader, (List)Nil$.MODULE$), this.waitForMirror$default$2());
        ((IterableOnceOps)this.destCluster().brokers().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(destLeader, x$2)))).foreach((Function1 & Serializable)follower -> {
            ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(this, recordsBeforeSourceFailure, tp, follower);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$4 = this.topic();
        String x$5 = this.linkName();
        boolean x$8 = qual$1.unlinkTopic$default$3();
        int x$9 = qual$1.unlinkTopic$default$6();
        qual$1.unlinkTopic(x$4, x$5, x$8, false, false, x$9);
        InvalidRequestException e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            Properties x$11 = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"BIDIRECTIONAL")}))));
            Some x$12 = new Some((Object)sourceClusterId);
            boolean x$13 = qual$2.createClusterLink$default$4();
            qual$2.createClusterLink("someLink", x$11, (Option<String>)x$12, x$13);
        });
        Assertions.assertTrue((boolean)e.getMessage().contains("Bi-directional links are supported only with IBP 3.1-IV0 and above"), (String)e.getMessage());
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldSourceIpb() {
        Some x$1 = new Some((Object)"2.4");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        Properties topicConfig = new Properties();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$3 = this.topic();
        Seq<KafkaBroker> x$6 = this.verifyMirror$default$2();
        this.verifyMirror(x$3, x$6, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonMonotonicSourceLeaderEpochs() {
        void var11_11;
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("min.insync.replicas", "1");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$3 = this.topic();
        int x$4 = this.numPartitions();
        ListenerName x$7 = qual$1.createTopic$default$5();
        Properties x$8 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$3, x$4, 1, topicConfigs, x$7, x$8);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        this.produceToSourceCluster(10);
        Tuple2<Object, Object> tuple2 = this.sourceCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader = tuple2._1$mcI$sp();
        this.sourceCluster().startBroker((int)var11_11);
        this.produceToSourceCluster(10);
        int sourceEpoch = this.sourceCluster().leaderEpoch(tp);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$9 = this.linkName();
        ClusterLinkTestHarness x$10 = this.sourceCluster();
        long x$12 = qual$2.createDestClusterLink$default$3();
        long x$13 = qual$2.createDestClusterLink$default$5();
        Properties x$14 = qual$2.createDestClusterLink$default$6();
        qual$2.createDestClusterLink(x$9, x$10, x$12, 10000L, x$13, x$14);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = this.topic();
        String x$17 = this.linkName();
        Map<String, String> x$18 = qual$3.linkTopic$default$4();
        String x$19 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$15, (short)3, x$17, x$18, x$19);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Partition sourcePartition = this.sourceCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)0));
        this.produceToSourceCluster(10);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)sourceEpoch));
        this.sourceCluster().consumerConfig().setProperty("auto.offset.reset", "earliest");
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ByteArrayDeserializer x$20 = qual$4.createConsumer$default$1();
        ByteArrayDeserializer x$21 = qual$4.createConsumer$default$2();
        Properties x$22 = qual$4.createConsumer$default$3();
        List<String> x$23 = qual$4.createConsumer$default$4();
        Consumer sourceConsumer = qual$4.createConsumer(x$20, x$21, x$22, x$23);
        sourceConsumer.assign(Collections.singleton(tp));
        Seq sourceRecords = TestUtils$.MODULE$.consumeRecords(sourceConsumer, 30, 15000L);
        ((IterableOnceOps)sourceRecords.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkIbp26Test.$anonfun$testNonMonotonicSourceLeaderEpochs$1(sourceEpoch, sourceRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        Partition destPartition = this.destCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        Assertions.assertTrue((destPartition.getLeaderEpoch() >= sourceEpoch ? 1 : 0) != 0, (String)new StringBuilder(29).append("Unexpected dest leader epoch ").append(destPartition.getLeaderEpoch()).toString());
        Assertions.assertEquals((long)20L, (long)destPartition.localLogOrException().logEndOffset());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        Properties x$24 = qual$5.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$5.createConfluentAdminClient(x$24), FailureType$.MODULE$.NonMonotonicLogAppendEpoch(), this.waitForFailure$default$3());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithZeroSourceEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 20);
        this.recreateTopic(5);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.UnexpectedTruncation());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithBackwardEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 20);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.recreateTopic(5);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.SourceTopicMayBeDeleted());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithInconsistentEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 10);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> this.produceToSourceCluster(10));
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        int numRecordsMirrored = this.producedRecords().size();
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.produceToSourceCluster(10);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(10);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.truncate(this.producedRecords().size() - numRecordsMirrored);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.UnexpectedTruncation());
    }

    @Test
    public void testSourceTopicRecreateDetectedWithTopicIds() {
        this.setUpSourceTopicDeletionTest(true, 10);
        this.produceToSourceCluster(20);
        int numRecordsRetained = this.producedRecords().size();
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.sourceCluster().changeLeader(new TopicPartition(this.topic(), 0));
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.truncate(this.producedRecords().size() - numRecordsRetained);
        this.verifyFailedStateAfterTopicRecreate(true, FailureType$.MODULE$.SourceTopicIdChanged());
    }

    @Test
    public void testSourceTopicRecreateNotDetectedWithoutTopicIds() {
        this.setUpSourceTopicDeletionTest(false, 10);
        this.produceToSourceCluster(20);
        this.truncate(20);
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.sourceCluster().changeLeader(new TopicPartition(this.topic(), 0));
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    private void setUpSourceTopicDeletionTest(boolean useTopicIds, int numRecords) {
        this.numPartitions_$eq(1);
        None$ ibp = useTopicIds ? None$.MODULE$ : new Some((Object)"2.6");
        this.setUpClusters((Option<String>)ibp, (Option<String>)ibp);
        int retryMs = useTopicIds ? 60000 : 1000;
        this.setupLinkAndMirrorForFailureTest(20000L, retryMs, "testGroup", this.setupLinkAndMirrorForFailureTest$default$4());
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    private int setUpSourceTopicDeletionTest$default$2() {
        return 20;
    }

    private void pauseOrUnpauseLink(boolean pause, int numPartitions) {
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)Boolean.toString(pause))}))));
        if (pause) {
            this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), numPartitions);
            return;
        }
    }

    private void recreateTopic(int numRecords) {
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
    }

    private void verifyFailedStateAfterTopicRecreate(boolean useTopicIds, FailureType failureTypeWithoutTopicIds) {
        FailureType failureType = useTopicIds ? FailureType$.MODULE$.SourceTopicIdChanged() : failureTypeWithoutTopicIds;
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$1.createConfluentAdminClient(x$1), failureType, this.waitForFailure$default$3());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().killAllBrokers();
        ConfluentAdmin destAdmin = (ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get();
        this.waitForFailure(destAdmin, failureType, this.topic());
        String x$2 = this.topic();
        Seq<KafkaBroker> x$5 = this.verifyMirror$default$2();
        this.verifyMirror(x$2, x$5, false, false);
    }

    @Test
    public void testCircularMirror() {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties linkPropOverrides = new Properties();
        linkPropOverrides.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$3 = this.linkName();
        ClusterLinkTestHarness x$4 = this.sourceCluster();
        long x$6 = qual$1.createDestClusterLink$default$3();
        long x$7 = qual$1.createDestClusterLink$default$4();
        long x$8 = qual$1.createDestClusterLink$default$5();
        Uuid linkId = qual$1.createDestClusterLink(x$3, x$4, x$6, x$7, x$8, linkPropOverrides);
        Properties linkProps = new Properties();
        ClusterLinkTestHarness qual$2 = this.destCluster();
        ListenerName x$9 = qual$2.bootstrapServers$default$1();
        linkProps.put("bootstrap.servers", qual$2.bootstrapServers(x$9));
        linkProps.putAll((java.util.Map<?, ?>)this.destCluster().clientSecurityProps(this.linkName()));
        linkProps.put("sasl.jaas.config", this.createLinkCredentials(this.linkName(), this.destCluster(), this.createLinkCredentials$default$3()));
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$10 = this.linkName();
        ClusterLinkTestHarness x$11 = this.destCluster();
        long x$13 = qual$3.createDestClusterLink$default$3();
        long x$14 = qual$3.createDestClusterLink$default$4();
        long x$15 = qual$3.createDestClusterLink$default$5();
        Uuid sourceLinkId = qual$3.createDestClusterLink(x$10, x$11, x$13, x$14, x$15, linkPropOverrides);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$16 = this.topic();
        int x$17 = this.numPartitions();
        short x$18 = this.replicationFactor();
        Properties x$19 = qual$4.createTopic$default$4();
        ListenerName x$20 = qual$4.createTopic$default$5();
        Properties x$21 = qual$4.createTopic$default$6();
        qual$4.createTopic(x$16, x$17, x$18, x$19, x$20, x$21);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.topic();
        short x$23 = this.replicationFactor();
        String x$24 = this.linkName();
        Map<String, String> x$25 = qual$5.linkTopic$default$4();
        String x$26 = qual$5.linkTopic$default$5();
        qual$5.linkTopic(x$22, x$23, x$24, x$25, x$26);
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        String x$27 = this.topic();
        short x$28 = this.replicationFactor();
        String x$29 = this.linkName();
        Map<String, String> x$30 = qual$6.linkTopic$default$4();
        String x$31 = qual$6.linkTopic$default$5();
        qual$6.linkTopic(x$27, x$28, x$29, x$30, x$31);
        ClusterLinkTestHarness qual$7 = this.sourceCluster();
        Properties x$32 = qual$7.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$7.createConfluentAdminClient(x$32);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Properties x$33 = qual$8.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$8.createConfluentAdminClient(x$33);
        this.waitForReplicaState$1(sourceAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForReplicaState$1(destAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForBlockedPartition$1(sourceLinkId, linkId, tp);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$34 = this.topic();
        String x$35 = this.linkName();
        int x$37 = this.numPartitions();
        boolean x$38 = qual$9.unlinkTopic$default$3();
        boolean x$39 = qual$9.unlinkTopic$default$5();
        qual$9.unlinkTopic(x$34, x$35, x$38, false, x$39, x$37);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$10 = this.destCluster();
        ByteArraySerializer x$40 = qual$10.createProducer$default$1();
        ByteArraySerializer x$41 = qual$10.createProducer$default$2();
        Properties x$42 = qual$10.createProducer$default$3();
        KafkaProducer producer = qual$10.createProducer(x$40, x$41, x$42);
        this.produceRecords(producer, this.topic(), 20, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        producer.close();
        this.waitForMirror((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.waitForMirror$default$2());
        this.waitForReplicaState$1(sourceAdmin, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorLegacyRecords(String quorum, boolean coordinator) {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.sourceCluster().producerConfig().setProperty("enable.idempotence", "false");
        this.createClusterLink(this.linkName(), this.destLinkProps(this.destLinkProps$default$1()), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ByteArraySerializer x$3 = qual$1.createProducer$default$1();
        ByteArraySerializer x$4 = qual$1.createProducer$default$2();
        Properties x$5 = qual$1.createProducer$default$3();
        KafkaProducer sourceProducer = qual$1.createProducer(x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArrayDeserializer x$6 = qual$2.createConsumer$default$1();
        ByteArrayDeserializer x$7 = qual$2.createConsumer$default$2();
        Properties x$8 = qual$2.createConsumer$default$3();
        List<String> x$9 = qual$2.createConsumer$default$4();
        Consumer sourceConsumer = qual$2.createConsumer(x$6, x$7, x$8, x$9);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$10 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$10);
        this.verifyMessageFormat$1("topicv0", "0.9.0", false, sourceProducer, sourceConsumer, destAdmin);
        this.verifyMessageFormat$1("topicv1", "0.10.0", true, sourceProducer, sourceConsumer, destAdmin);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$11 = this.linkName();
        boolean x$12 = qual$4.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$13 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$11, x$12, x$13);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorLegacyRecordsThrowsNoExceptionWhenAllowed(String quorum, boolean coordinator) {
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.allow.legacy.message.format", "true");
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.sourceCluster().producerConfig().setProperty("enable.idempotence", "false");
        this.createClusterLink(this.linkName(), this.destLinkProps(this.destLinkProps$default$1()), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ByteArraySerializer x$3 = qual$1.createProducer$default$1();
        ByteArraySerializer x$4 = qual$1.createProducer$default$2();
        Properties x$5 = qual$1.createProducer$default$3();
        KafkaProducer sourceProducer = qual$1.createProducer(x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArrayDeserializer x$6 = qual$2.createConsumer$default$1();
        ByteArrayDeserializer x$7 = qual$2.createConsumer$default$2();
        Properties x$8 = qual$2.createConsumer$default$3();
        List<String> x$9 = qual$2.createConsumer$default$4();
        Consumer sourceConsumer = qual$2.createConsumer(x$6, x$7, x$8, x$9);
        this.verifyMessageFormat$2("topicv0", "0.9.0", sourceProducer, sourceConsumer);
        this.verifyMessageFormat$2("topicv1", "0.10.0", sourceProducer, sourceConsumer);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.linkName();
        boolean x$11 = qual$3.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$12 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$10, x$11, x$12);
    }

    private void setUpClusters(Option<String> destIbp, Option<String> sourceIbp) {
        destIbp.foreach((Function1 & Serializable)ibp -> this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        sourceIbp.foreach((Function1 & Serializable)ibp -> this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        super.setUp(this._testInfo);
    }

    private Option<String> setUpClusters$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setUpClusters$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(KafkaBroker destLeader$1, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        return !(kafkaBroker != null ? !kafkaBroker.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(ClusterLinkIbp26Test $this, int recordsBeforeSourceFailure$1, TopicPartition tp$1, KafkaBroker follower) {
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)recordsBeforeSourceFailure$1)), $this.logEndOffset(follower, tp$1));
    }

    public static final /* synthetic */ void $anonfun$testNonMonotonicSourceLeaderEpochs$1(int sourceEpoch$1, Seq sourceRecords$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Integer leaderEpoch = (Integer)record.leaderEpoch().get();
            Assertions.assertEquals((int)(index >= 10 && index < 20 ? sourceEpoch$1 : 0), (Integer)leaderEpoch, (String)new StringBuilder(35).append("Unexpected epoch at index ").append(index).append(", epochs=").append(sourceRecords$1.map((Function1 & Serializable)x$3 -> x$3.leaderEpoch())).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForReplicaState$1(ConfluentAdmin admin, scala.collection.immutable.Set expectedStates) {
        void var4_8;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = this.mirrorPartitionStates(admin, this.mirrorPartitionStates$default$2())).subsetOf((Set)expectedStates)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set actualStates = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)var4_8.subsetOf((Set)expectedStates), (String)new StringBuilder(25).append("Expected subset of ").append(expectedStates).append(", got ").append(var4_8).toString());
    }

    private static final ConcurrentHashMap waitingPartitions$1(ClusterLinkTestHarness cluster, Uuid linkId, TopicPartition tp$2) {
        return (ConcurrentHashMap)TestUtils.fieldValue((Object)cluster.partitionLeader(tp$2).clusterLinkManager().fetcherManager(linkId).get(), ClusterLinkFetcherManager.class, (String)"waitingPartitions");
    }

    public static final /* synthetic */ boolean $anonfun$testCircularMirror$3(ConcurrentHashMap sourceWaitingPartitions$1, TopicPartition tp$2, ConcurrentHashMap destWaitingPartitions$1) {
        return sourceWaitingPartitions$1.containsKey(tp$2) || destWaitingPartitions$1.containsKey(tp$2);
    }

    public static final /* synthetic */ String $anonfun$testCircularMirror$4() {
        return "Partition not blocked after consecutive epoch bumps";
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForBlockedPartition$1(Uuid sourceLinkId$1, Uuid linkId$1, TopicPartition tp$2) {
        ConcurrentHashMap sourceWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.sourceCluster(), sourceLinkId$1, tp$2);
        ConcurrentHashMap destWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.destCluster(), linkId$1, tp$2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIbp26Test.$anonfun$testCircularMirror$3(sourceWaitingPartitions, tp$2, destWaitingPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Partition not blocked after consecutive epoch bumps");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirrorLegacyRecords$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    private final void waitForMirrorOffsets$1(String topic) {
        IndexedSeq mirrorPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> ClusterLinkIbp26Test.$anonfun$testMirrorLegacyRecords$1(topic, BoxesRunTime.unboxToInt((Object)i)));
        scala.collection.immutable.Map offsetsByPartition = ((IterableOnceOps)mirrorPartitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.nextOffset(tp.partition()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.waitForMirrorPartitions((Seq<TopicPartition>)mirrorPartitions, (Map<TopicPartition, Object>)offsetsByPartition, this.destCluster().aliveServers(), 15000L, this.waitForMirrorPartitions$default$5());
    }

    private final void verifyMessageFormat$1(String topic, String messageFormat, boolean verifyRepair, KafkaProducer sourceProducer$1, Consumer sourceConsumer$1, ConfluentAdmin destAdmin$1) {
        int numRecords = 20;
        Properties topicProps = new Properties();
        topicProps.setProperty("message.format.version", messageFormat);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicProps, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, x$9, x$10, x$11);
        this.producedRecords().clear();
        this.produceRecords((KafkaProducer<byte[], byte[]>)sourceProducer$1, topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        sourceConsumer$1.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions("", topic, this.partitions$default$3())).asJava());
        String x$14 = this.consumeRecords$default$2();
        this.consumeRecords((Consumer<byte[], byte[]>)sourceConsumer$1, x$14, topic);
        this.waitForFailure(destAdmin$1, FailureType$.MODULE$.UnsupportedMessageFormat(), topic);
        if (verifyRepair) {
            this.destCluster().alterBrokerConfig((Option<String>)None$.MODULE$, "confluent.cluster.link.allow.legacy.message.format", "true");
            this.destCluster().alterMirrors(topic, AlterMirrorOp.REPAIR);
            this.waitForMirrorState(destAdmin$1, topic, MirrorTopicDescription.State.ACTIVE);
            this.waitForMirrorOffsets$1(topic);
            this.produceRecords((KafkaProducer<byte[], byte[]>)sourceProducer$1, topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
            this.waitForMirrorOffsets$1(topic);
            ClusterLinkTestHarness qual$3 = this.destCluster();
            ByteArrayDeserializer x$15 = qual$3.createConsumer$default$1();
            ByteArrayDeserializer x$16 = qual$3.createConsumer$default$2();
            Properties x$17 = qual$3.createConsumer$default$3();
            List<String> x$18 = qual$3.createConsumer$default$4();
            Consumer destConsumer = qual$3.createConsumer(x$15, x$16, x$17, x$18);
            destConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions("", topic, this.partitions$default$3())).asJava());
            String x$21 = this.consumeRecords$default$2();
            this.consumeRecords(destConsumer, x$21, topic);
        }
        ClusterLinkTestHarness qual$4 = this.destCluster();
        ListenerName x$23 = qual$4.deleteTopic$default$2();
        qual$4.deleteTopic(topic, x$23);
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        ListenerName x$25 = qual$5.deleteTopic$default$2();
        qual$5.deleteTopic(topic, x$25);
    }

    private final void verifyMessageFormat$2(String topic, String messageFormat, KafkaProducer sourceProducer$2, Consumer sourceConsumer$2) {
        int numRecords = 20;
        Properties topicProps = new Properties();
        topicProps.setProperty("message.format.version", messageFormat);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicProps, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, x$9, x$10, x$11);
        this.producedRecords().clear();
        this.produceRecords((KafkaProducer<byte[], byte[]>)sourceProducer$2, topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
        sourceConsumer$2.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions("", topic, this.partitions$default$3())).asJava());
        String x$14 = this.consumeRecords$default$2();
        this.consumeRecords((Consumer<byte[], byte[]>)sourceConsumer$2, x$14, topic);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        boolean x$16 = qual$3.describeMirrorTopic$default$2();
        MirrorTopicDescription destTopic = qual$3.describeMirrorTopic(topic, x$16);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)destTopic.state());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)destTopic.mirrorTopicError());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        ListenerName x$18 = qual$4.deleteTopic$default$2();
        qual$4.deleteTopic(topic, x$18);
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        ListenerName x$20 = qual$5.deleteTopic$default$2();
        qual$5.deleteTopic(topic, x$20);
    }

    public ClusterLinkIbp26Test() {
        None$ x$4 = None$.MODULE$;
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
        None$ x$8 = None$.MODULE$;
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        this.replicationFactor = (short)3;
    }

    public static final /* synthetic */ Object $anonfun$testCircularMirror$2$adapted(scala.collection.immutable.Set expectedStates$1, scala.collection.immutable.Set x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.subsetOf((Set)expectedStates$1));
    }
}

