/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.TopicLinkMirror$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u001d4AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C\u0001+!)\u0011\n\u0001C\u0001\u0015\")\u0001\u000b\u0001C\u0001#\")q\u000b\u0001C\u00011\n\t3\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0001\"C\u0001\u0005Y&t7NC\u0001\u000b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0007\u0011\u00059yQ\"A\u0004\n\u0005A9!AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011a\u0002A\u0001%i\u0016\u001cH/T5se>\u0014Hk\u001c9jG\u000e{WO\u001c;G_JlU\u000f\u001c;ja2,G*\u001b8lgR\u0019a\u0003H\u0015\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006;\t\u0001\rAH\u0001\u0007cV|'/^7\u0011\u0005}1cB\u0001\u0011%!\t\t\u0003$D\u0001#\u0015\t\u00193\"\u0001\u0004=e>|GOP\u0005\u0003Ka\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\u0019\u0019FO]5oO*\u0011Q\u0005\u0007\u0005\u0006U\t\u0001\raK\u0001\fG>|'\u000fZ5oCR|'\u000f\u0005\u0002\u0018Y%\u0011Q\u0006\u0007\u0002\b\u0005>|G.Z1oQ\u0011\u0011qf\u000f\u001f\u0011\u0005AJT\"A\u0019\u000b\u0005I\u001a\u0014A\u00029be\u0006l7O\u0003\u00025k\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001c8\u0003\u0015QWO\\5u\u0015\u0005A\u0014aA8sO&\u0011!(\r\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!P\u0001)w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhfY8pe\u0012Lg.\u0019;pevZ\u0018' \u0015\u0005\u0005}*e\t\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cc\u0005A\u0001O]8wS\u0012,'/\u0003\u0002E\u0003\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\nq)I\u0001I\u0003=\tG\u000e\\\"p[\nLg.\u0019;j_:\u001c\u0018A\t;fgR\u0014%o\\6feR{\u0007/[2Ti\u0006$8OR8s\u001b&\u0014(o\u001c:U_BL7\rF\u0002\u0017\u00172CQ!H\u0002A\u0002yAQAK\u0002A\u0002-BCaA\u0018<y!\"1aP#PY\u00059\u0015!\u0004;fgR\u0014\u0006o\\'fiJL7\rF\u0002\u0017%NCQ!\b\u0003A\u0002yAQA\u000b\u0003A\u0002-BC\u0001B\u0018<y!\"AaP#WY\u00059\u0015!\u0006;fgR\u001cuN\u001c8fGRLwN\\'fiJL7m\u001d\u000b\u0004-eS\u0006\"B\u000f\u0006\u0001\u0004q\u0002\"\u0002\u0016\u0006\u0001\u0004Y\u0003\u0006B\u00030wqBC!B F;2\nq\t\u000b\u0003\u0001?\u0016+\u0007C\u00011d\u001b\u0005\t'B\u000124\u0003\r\t\u0007/[\u0005\u0003I\u0006\u00141\u0001V1hC\u00051\u0017aC5oi\u0016<'/\u0019;j_:\u0004")
public class ClusterLinkMetricsIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirrorTopicCountForMultipleLinks(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        String secondLink = new StringBuilder(3).append(this.linkName()).append("Two").toString();
        String secondTopic = new StringBuilder(3).append(this.topic()).append("Two").toString();
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        int x$13 = this.numPartitions();
        short x$14 = this.replicationFactor();
        Properties x$15 = qual$3.createTopic$default$4();
        ListenerName x$16 = qual$3.createTopic$default$5();
        Properties x$17 = qual$3.createTopic$default$6();
        qual$3.createTopic(secondTopic, x$13, x$14, x$15, x$16, x$17);
        this.createClusterLink(secondLink, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        short x$19 = this.replicationFactor();
        Map<String, String> x$21 = qual$4.linkTopic$default$4();
        String x$22 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(secondTopic, x$19, secondLink, x$21, x$22);
        this.verifyMirrorTopicCount("mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), 1, this.linkName(), this.verifyMirrorTopicCount$default$5());
        this.verifyMirrorTopicCount("mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), 1, secondLink, this.verifyMirrorTopicCount$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testBrokerTopicStatsForMirrorTopic(String quorum, boolean coordinator) {
        String string;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        String x$15 = this.clusterLinkPrefix();
        Map<String, String> x$16 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$12, x$13, x$14, x$16, x$15);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            String prefixedTopic = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            string = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.MirrorBytesInPerSec()).append(",topic=").append(prefixedTopic).toString();
        } else {
            string = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.MirrorBytesInPerSec()).append(",topic=").append(this.topic()).toString();
        }
        String mirrorBytesIn = string;
        String totalMirrorBytesIn = BrokerTopicStats$.MODULE$.MirrorBytesInPerSec();
        this.produceToSourceCluster(1000);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkMetricsIntegrationTest.$anonfun$testBrokerTopicStatsForMirrorTopic$1(mirrorBytesIn)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkMetricsIntegrationTest.$anonfun$testBrokerTopicStatsForMirrorTopic$2(mirrorBytesIn));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long initialMirrorBytesIn = TestUtils$.MODULE$.meterCount(mirrorBytesIn);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkMetricsIntegrationTest.$anonfun$testBrokerTopicStatsForMirrorTopic$3(totalMirrorBytesIn)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ClusterLinkMetricsIntegrationTest.$anonfun$testBrokerTopicStatsForMirrorTopic$4(totalMirrorBytesIn));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long initialTotalMirrorBytesIn = TestUtils$.MODULE$.meterCount(totalMirrorBytesIn);
        this.produceToSourceCluster(2000);
        long l3 = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkMetricsIntegrationTest.$anonfun$testBrokerTopicStatsForMirrorTopic$5(mirrorBytesIn, initialMirrorBytesIn, totalMirrorBytesIn, initialTotalMirrorBytesIn);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var45_36 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testRpoMetric(String quorum, boolean coordinator) {
        int numPartitions = 1;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, numPartitions, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp()), (Object)"60000")}))));
        String x$7 = this.linkName();
        Option<Properties> x$10 = this.createClusterLink$default$3();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, linkProps, x$10, true, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$2.linkTopic$default$4();
        String x$16 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$12, x$13, x$14, x$15, x$16);
        this.produceToSourceCluster(1000);
        this.verifyRpoMetric(this.linkName(), this.topic());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$17 = this.topic();
        String x$18 = this.linkName();
        boolean x$21 = qual$3.unlinkTopic$default$3();
        boolean x$22 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$17, x$18, x$21, false, x$22, numPartitions);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$4.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$25 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$23, x$24, x$25);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testConnectionMetrics(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix()))) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.verifyNoClusterLinkConnections(this.destCluster(), "paused");
        this.verifyNoClusterLinkConnections(this.sourceCluster(), "paused");
        this.sourceCluster().alterPartitionAssignmentAndWait(this.topic(), (Map<Object, Seq<Object>>)this.assignment$1(this.sourceCluster()));
        this.destCluster().alterPartitionAssignmentAndWait(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), (Map<Object, Seq<Object>>)this.assignment$1(this.destCluster()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Properties x$14 = this.verifyBasicLinkMetrics$default$2();
        this.verifyBasicLinkMetrics(linkId, x$14, true);
        this.verifyClusterLinkConnectionMetrics(this.verifyClusterLinkConnectionMetrics$default$1(), this.verifyClusterLinkConnectionMetrics$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$16 = this.linkName();
        int x$17 = this.numPartitions();
        boolean x$18 = qual$3.unlinkTopic$default$3();
        boolean x$19 = qual$3.unlinkTopic$default$4();
        boolean x$20 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$15, x$16, x$18, x$19, x$20, x$17);
        this.consume(this.destCluster(), this.consume$default$2());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$21 = this.linkName();
        boolean x$22 = qual$4.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$23 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$21, x$22, x$23);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$5 = this.sourceCluster();
            String x$24 = this.linkName();
            boolean x$25 = qual$5.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$26 = qual$5.deleteClusterLink$default$3();
            qual$5.deleteClusterLink(x$24, x$25, x$26);
        }
        this.verifyNoClusterLinkConnections(this.destCluster(), "deleted");
        this.verifyNoClusterLinkConnections(this.sourceCluster(), "deleted");
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicStatsForMirrorTopic$1(String mirrorBytesIn$1) {
        try {
            TestUtils$.MODULE$.meterCount(mirrorBytesIn$1);
            return true;
        }
        catch (AssertionFailedError assertionFailedError) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$testBrokerTopicStatsForMirrorTopic$2(String mirrorBytesIn$1) {
        return new StringBuilder(22).append("Failed to find metric ").append(mirrorBytesIn$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicStatsForMirrorTopic$3(String totalMirrorBytesIn$1) {
        try {
            TestUtils$.MODULE$.meterCount(totalMirrorBytesIn$1);
            return true;
        }
        catch (AssertionFailedError assertionFailedError) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$testBrokerTopicStatsForMirrorTopic$4(String totalMirrorBytesIn$1) {
        return new StringBuilder(22).append("Failed to find metric ").append(totalMirrorBytesIn$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicStatsForMirrorTopic$5(String mirrorBytesIn$1, long initialMirrorBytesIn$1, String totalMirrorBytesIn$1, long initialTotalMirrorBytesIn$1) {
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(mirrorBytesIn$1) > initialMirrorBytesIn$1 ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(totalMirrorBytesIn$1) > initialTotalMirrorBytesIn$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testConnectionMetrics$1(KafkaBroker linkCoordinator$1, KafkaBroker x$1) {
        return x$1 == linkCoordinator$1;
    }

    private final Map assignment$1(ClusterLinkTestHarness cluster) {
        KafkaBroker linkCoordinator = cluster.linkCoordinator(this.linkName());
        return (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{linkCoordinator.config().brokerId(), ((KafkaBroker)((IterableOps)cluster.brokers().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsIntegrationTest.$anonfun$testConnectionMetrics$1(linkCoordinator, x$1)))).head()).config().brokerId()})))}));
    }
}

