/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.LinkState;
import kafka.server.link.PausedClusterLink$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.UnavailableClusterLink$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005u4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)q\u0006\u0001C\u0001a!)Q\u000b\u0001C\u0001-\")1\f\u0001C\u00019\")a\u000e\u0001C\u0001_\nQ3\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t%\u0016$Wo\u0019;j_:Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0005\u000b\u0003\u0011a\u0017N\\6\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005!\u0002CA\b\u0001\u0003\u0015\u0019X\r^+q)\t9R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0003V]&$\b\"\u0002\u0010\u0003\u0001\u0004y\u0012\u0001\u0003;fgRLeNZ8\u0011\u0005\u0001JS\"A\u0011\u000b\u0005\t\u001a\u0013aA1qS*\u0011A%J\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1s%A\u0003kk:LGOC\u0001)\u0003\ry'oZ\u0005\u0003U\u0005\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u00051\u0002\"\u0001I\u0017\n\u00059\n#A\u0003\"fM>\u0014X-R1dQ\u0006\u0001C/Z:u\u001bVdG/\u001b9mK2Kgn[:TK2,7\r^8s\u001b\u0016$(/[2t)\t9\u0012\u0007C\u00033\u0007\u0001\u00071'\u0001\u0004rk>\u0014X/\u001c\t\u0003imr!!N\u001d\u0011\u0005YJR\"A\u001c\u000b\u0005ab\u0011A\u0002\u001fs_>$h(\u0003\u0002;3\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ\u0014\u0004\u000b\u0003\u0004\u007f\u00153\u0005C\u0001!D\u001b\u0005\t%B\u0001\"$\u0003\u0019\u0001\u0018M]1ng&\u0011A)\u0011\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013aR\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\t\rIu\n\u0015\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u0006\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003\u001d.\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA)TC\u0005\u0011\u0016!B6sC\u001a$\u0018%\u0001+\u0002\u0005i\\\u0017!\t;fgR\u0014V\rZ;dK\u0012d\u0015N\\6NSJ\u0014xN]\"pk:$X*\u001a;sS\u000e\u001cHCA\fX\u0011\u0015\u0011D\u00011\u00014Q\u0011!q(\u0012$)\t\u0011IuJ\u0017\u0017\u0003#N\u000bA\u0004^3ti2Kgn[3e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,7\u000fF\u0002\u0018;zCQAM\u0003A\u0002MBQaX\u0003A\u0002\u0001\f1bY8pe\u0012Lg.\u0019;peB\u0011\u0001$Y\u0005\u0003Ef\u0011qAQ8pY\u0016\fg\u000e\u000b\u0003\u0006\u007f\u0015#\u0017%A3\u0002Qm$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL2p_J$\u0017N\\1u_Jl40M?)\t\u00159'n\u001b\t\u0003\u0015\"L!![&\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u00031\f\u0013!\\\u0001\u000fu.\u001cu.\u001c2j]\u0006$\u0018n\u001c8t\u0003\u0019\"Xm\u001d;NSJ\u0014xN\u001d+sC:\u001c\u0018\u000e^5p]N<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0019&t7n\u001d\u000b\u0004/A\f\b\"\u0002\u001a\u0007\u0001\u0004\u0019\u0004\"B0\u0007\u0001\u0004\u0001\u0007\u0006\u0002\u0004@\u000b\u0012DCAB4ki2\nQ/I\u0001w\u0003]\u0019wn\u001c:eS:\fGo\u001c:D_6\u0014\u0017N\\1uS>t7\u000f\u000b\u0003\u0001q*\\\bC\u0001\u0011z\u0013\tQ\u0018EA\u0002UC\u001e\f\u0013\u0001`\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class ClusterLinkMetricsReductionIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.enable.metrics.reduction", "true");
        }
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.availability.check.mode", ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR.name());
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.enable.local.admin", "true");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.mirror.transition.batch.size", "50");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.admin.request.batch.size", "100");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.admin.max.in.flight.requests", "3");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.num.background.threads", "2");
        } else {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.mirror.transition.batch.size", Integer.toString(Integer.MAX_VALUE));
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.admin.request.batch.size", "1");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.num.background.threads", "1");
        }
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testMultipleLinksSelectorMetrics(String quorum) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1 & Serializable)i -> ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMultipleLinksSelectorMetrics$4(this, BoxesRunTime.unboxToInt((Object)i)));
        String groupName = new StringBuilder(21).append("cluster-link-").append(ClusterLinkClientType.Metadata$.MODULE$.name()).append("-metrics").toString();
        this.assertNoLinkTagExists$1(groupName, "request-rate");
        this.assertNoLinkTagExists$1(groupName, "response-rate");
        this.assertNoLinkTagExists$1(groupName, "outgoing-byte-rate");
        this.assertNoLinkTagExists$1(groupName, "incoming-byte-rate");
        groupName = new StringBuilder(21).append("cluster-link-").append(ClusterLinkClientType.ClientAdmin$.MODULE$.name()).append("-metrics").toString();
        this.assertNoLinkTagExists$1(groupName, "request-rate");
        this.assertNoLinkTagExists$1(groupName, "response-rate");
        this.assertNoLinkTagExists$1(groupName, "outgoing-byte-rate");
        this.assertNoLinkTagExists$1(groupName, "incoming-byte-rate");
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String nextLink = new StringBuilder(0).append(this.linkName()).append(i).toString();
            String nextTopic = new StringBuilder(0).append(this.topic()).append(i).toString();
            ClusterLinkTestHarness qual$3 = this.destCluster();
            boolean x$15 = qual$3.unlinkTopic$default$3();
            boolean x$16 = qual$3.unlinkTopic$default$5();
            int x$17 = qual$3.unlinkTopic$default$6();
            qual$3.unlinkTopic(nextTopic, nextLink, x$15, false, x$16, x$17);
            ClusterLinkTestHarness qual$4 = this.destCluster();
            boolean x$19 = qual$4.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$20 = qual$4.deleteClusterLink$default$3();
            qual$4.deleteClusterLink(nextLink, x$19, x$20);
        });
        groupName = new StringBuilder(21).append("cluster-link-").append(ClusterLinkClientType.Metadata$.MODULE$.name()).append("-metrics").toString();
        this.assertNoLinkTagExists$1(groupName, "request-rate");
        this.assertNoLinkTagExists$1(groupName, "response-rate");
        this.assertNoLinkTagExists$1(groupName, "outgoing-byte-rate");
        this.assertNoLinkTagExists$1(groupName, "incoming-byte-rate");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testReducedLinkMirrorCountMetrics(String quorum) {
        .colon.colon linkStates = new .colon.colon((Object)ActiveClusterLink$.MODULE$, (List)new .colon.colon((Object)PausedClusterLink$.MODULE$, (List)new .colon.colon((Object)UnavailableClusterLink$.MODULE$, (List)Nil$.MODULE$)));
        linkStates.foreach((Function1 & Serializable)state -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$2(this, state);
            return BoxedUnit.UNIT;
        });
        TopicLinkState$.MODULE$.states().foreach((Function1 & Serializable)state -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$3(this, state);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = TimeUnit.SECONDS.toMillis(60L);
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"ACTIVE state link-count not populated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = TimeUnit.SECONDS.toMillis(60L);
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"MIRROR state mirror-topic-count not populated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.verifyLinkCountMetric(this.destinationLinkMode(), "active", this.destCluster());
        this.verifyMirrorTopicCount("mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), 1, this.linkName(), this.verifyMirrorTopicCount$default$5());
        ((IterableOnceOps)linkStates.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$8(s)))).foreach((Function1 & Serializable)state -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$9(this, state);
            return BoxedUnit.UNIT;
        });
        TopicLinkState$.MODULE$.states().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$10(s))).foreach((Function1 & Serializable)state -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$11(this, state);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testLinkedLeaderEpochChanges(String quorum, boolean coordinator) {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        this.verifyMirrorWithSourceEpochChanges(false, this.verifyMirrorWithSourceEpochChanges$default$2());
        this.verifyLinkedLeaderChangeMetrics();
        String x$1 = this.topic();
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        boolean x$4 = this.verifyMirror$default$3();
        this.verifyMirror(x$1, x$3, x$4, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"coordinatorCombinations"})
    public void testMirrorTransitionsWithMultipleLinks(String quorum, boolean coordinator) {
        this.numPartitions_$eq(2);
        scala.collection.immutable.Map topicsByLink = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append("link").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)t -> ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMirrorTransitionsWithMultipleLinks$2(i, BoxesRunTime.unboxToInt((Object)t))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable topics = (Iterable)topicsByLink.values().flatten(Predef$.MODULE$.$conforms());
        int numRecords = 20;
        Map linkPropOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter("*"))}));
        Properties linkProps = this.destLinkProps((Map<String, String>)linkPropOverrides);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        Properties x$12 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$1.createConfluentAdminClient(x$12);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        Properties x$2 = qual$2.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$2.createConfluentAdminClient(x$2);
        topicsByLink.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMirrorTransitionsWithMultipleLinks$3(this, linkProps, x0$1);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        ByteArraySerializer x$14 = qual$5.createProducer$default$1();
        ByteArraySerializer x$15 = qual$5.createProducer$default$2();
        Properties x$16 = qual$5.createProducer$default$3();
        KafkaProducer producer = qual$5.createProducer(x$14, x$15, x$16);
        topics.foreach((Function1 & Serializable)topic -> {
            IndexedSeq partitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)p -> ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMirrorTransitionsWithMultipleLinks$6(topic, BoxesRunTime.unboxToInt((Object)p)));
            this.produceRecords((KafkaProducer<byte[], byte[]>)producer, (String)topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5(), this.produceRecords$default$6());
            this.waitForMirroring(this.destCluster(), (Seq<TopicPartition>)partitions);
            return sourceAdmin.alterConsumerGroupOffsets("group", CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new OffsetAndMetadata(50L)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        });
        producer.close();
        java.util.Map ops = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)topicsByLink.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)AlterMirrorOp.PROMOTE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        destAdmin.alterMirrors(ops, (AlterMirrorsOptions)new AlterMirrorsOptions().timeoutMs(Predef$.MODULE$.int2Integer(60000))).all().get(60000L, TimeUnit.MILLISECONDS);
        Iterable partitions = (Iterable)topics.flatMap((Function1 & Serializable)topic -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)p -> ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMirrorTransitionsWithMultipleLinks$10(topic, BoxesRunTime.unboxToInt((Object)p))));
        this.destCluster().waitForMirrorStates(destAdmin, ReplicaStatus.MirrorInfo.State.STOPPED, (Set<TopicPartition>)partitions.toSet());
        topicsByLink.keySet().foreach((Function1 & Serializable)linkName -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMirrorTransitionsWithMultipleLinks$11(this, linkName);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMultipleLinksSelectorMetrics$2(String group$1, String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.group();
            if (!(string != null ? !string.equals(group$1) : group$1 != null)) {
                String string2 = metricName.name();
                if (!(string2 != null ? !string2.equals(name$1) : name$1 != null)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMultipleLinksSelectorMetrics$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((MetricName)x0$2._1()).tags().containsKey("link-name");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMultipleLinksSelectorMetrics$1(String group$1, String name$1, KafkaBroker server) {
        scala.collection.immutable.Seq values = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(server.metrics().metrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMultipleLinksSelectorMetrics$2(group$1, name$1, x0$1)))).toSeq();
        Assertions.assertEquals((int)1, (int)values.size(), (String)new StringBuilder(63).append("Only one instance of Metric name: ").append(name$1).append(" should be present in group: ").append(group$1).toString());
        scala.collection.immutable.Seq valuesWithLinkTag = (scala.collection.immutable.Seq)values.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMultipleLinksSelectorMetrics$3(x0$2)));
        if (valuesWithLinkTag.nonEmpty()) {
            throw new AssertionError((Object)new StringBuilder(47).append("Metric name: ").append(name$1).append(" should not contain link-name tag ").append(valuesWithLinkTag).toString());
        }
    }

    private final void assertNoLinkTagExists$1(String group, String name) {
        this.destCluster().aliveServers().foreach((Function1 & Serializable)server -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testMultipleLinksSelectorMetrics$1(group, name, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ CreateTopicsResult $anonfun$testMultipleLinksSelectorMetrics$4(ClusterLinkMetricsReductionIntegrationTest $this, int i) {
        String nextLink = new StringBuilder(0).append($this.linkName()).append(i).toString();
        String nextTopic = new StringBuilder(0).append($this.topic()).append(i).toString();
        ClusterLinkTestHarness qual$1 = $this.sourceCluster();
        int x$2 = $this.numPartitions();
        short x$3 = $this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(nextTopic, x$2, x$3, x$4, x$5, x$6);
        $this.createClusterLink(nextLink, $this.createClusterLink$default$2(), $this.createClusterLink$default$3(), $this.createClusterLink$default$4(), $this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = $this.destCluster();
        short x$8 = $this.replicationFactor();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        return qual$2.linkTopic(nextTopic, x$8, nextLink, x$10, x$11);
    }

    public static final /* synthetic */ void $anonfun$testReducedLinkMirrorCountMetrics$1(ClusterLinkMetricsReductionIntegrationTest $this, String metricName$1, String state$1, DoubleRef maxValue$1, KafkaBroker server) {
        Object[] objectArray = new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)state$1)};
        double brokerValue = $this.kafkaBrokerMetricValue(server, metricName$1, ClusterLinkMetrics$.MODULE$.metricsGroup(), (Option<String>)new Some((Object)$this.linkName()), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), $this.kafkaBrokerMetricValue$default$6(), $this.kafkaBrokerMetricValue$default$7());
        if (brokerValue > maxValue$1.elem) {
            maxValue$1.elem = brokerValue;
            return;
        }
    }

    private final double metricMaxValue$1(String metricName, String state) {
        DoubleRef maxValue = DoubleRef.create((double)-1.0);
        this.destCluster().aliveServers().foreach((Function1 & Serializable)server -> {
            ClusterLinkMetricsReductionIntegrationTest.$anonfun$testReducedLinkMirrorCountMetrics$1(this, metricName, state, maxValue, server);
            return BoxedUnit.UNIT;
        });
        return maxValue.elem;
    }

    private final double mirrorTopicCount$1(String state) {
        return this.metricMaxValue$1("mirror-topic-count", state);
    }

    private final double linkCount$1(String state) {
        return this.metricMaxValue$1("link-count", state);
    }

    public static final /* synthetic */ void $anonfun$testReducedLinkMirrorCountMetrics$2(ClusterLinkMetricsReductionIntegrationTest $this, LinkState state) {
        Assertions.assertEquals((double)-1.0, (double)$this.linkCount$1(state.name()), (String)new StringBuilder(42).append("state=").append(state).append(" link-count metric should not exists").toString());
    }

    public static final /* synthetic */ void $anonfun$testReducedLinkMirrorCountMetrics$3(ClusterLinkMetricsReductionIntegrationTest $this, TopicLinkState state) {
        Assertions.assertEquals((double)-1.0, (double)$this.mirrorTopicCount$1(state.name()), (String)new StringBuilder(50).append("state=").append(state).append(" mirror-topic-count metric should not exists").toString());
    }

    public static final /* synthetic */ boolean $anonfun$testReducedLinkMirrorCountMetrics$4(ClusterLinkMetricsReductionIntegrationTest $this) {
        return $this.linkCount$1(ActiveClusterLink$.MODULE$.name()) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$testReducedLinkMirrorCountMetrics$5() {
        return "ACTIVE state link-count not populated";
    }

    public static final /* synthetic */ boolean $anonfun$testReducedLinkMirrorCountMetrics$6(ClusterLinkMetricsReductionIntegrationTest $this) {
        return $this.mirrorTopicCount$1(TopicLinkMirror$.MODULE$.name()) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$testReducedLinkMirrorCountMetrics$7() {
        return "MIRROR state mirror-topic-count not populated";
    }

    public static final /* synthetic */ boolean $anonfun$testReducedLinkMirrorCountMetrics$8(LinkState s) {
        return !s.name().equals(ActiveClusterLink$.MODULE$.name());
    }

    public static final /* synthetic */ void $anonfun$testReducedLinkMirrorCountMetrics$9(ClusterLinkMetricsReductionIntegrationTest $this, LinkState state) {
        Assertions.assertEquals((double)-1.0, (double)$this.linkCount$1(state.name()), (String)new StringBuilder(42).append("state=").append(state).append(" link-count metric should not exists").toString());
    }

    public static final /* synthetic */ boolean $anonfun$testReducedLinkMirrorCountMetrics$10(TopicLinkState s) {
        return !s.name().equals(TopicLinkMirror$.MODULE$.name());
    }

    public static final /* synthetic */ void $anonfun$testReducedLinkMirrorCountMetrics$11(ClusterLinkMetricsReductionIntegrationTest $this, TopicLinkState state) {
        Assertions.assertEquals((double)-1.0, (double)$this.mirrorTopicCount$1(state.name()), (String)new StringBuilder(50).append("state=").append(state).append(" mirror-topic-count metric should not exists").toString());
    }

    public static final /* synthetic */ String $anonfun$testMirrorTransitionsWithMultipleLinks$2(int i$1, int t) {
        return new StringBuilder(5).append("topic").append(i$1).append(t).toString();
    }

    public static final /* synthetic */ void $anonfun$testMirrorTransitionsWithMultipleLinks$3(ClusterLinkMetricsReductionIntegrationTest $this, Properties linkProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String linkName = (String)x0$1._1();
            IndexedSeq topics = (IndexedSeq)x0$1._2();
            $this.createClusterLink(linkName, linkProps$1, $this.createClusterLink$default$3(), $this.createClusterLink$default$4(), $this.createClusterLink$default$5());
            topics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkTestHarness qual$3 = $this.sourceCluster();
                int x$4 = $this.numPartitions();
                short x$5 = $this.replicationFactor();
                Properties x$6 = qual$3.createTopic$default$4();
                ListenerName x$7 = qual$3.createTopic$default$5();
                Properties x$8 = qual$3.createTopic$default$6();
                qual$3.createTopic((String)topic, x$4, x$5, x$6, x$7, x$8);
                ClusterLinkTestHarness qual$4 = $this.destCluster();
                short x$10 = $this.replicationFactor();
                Map<String, String> x$12 = qual$4.linkTopic$default$4();
                String x$13 = qual$4.linkTopic$default$5();
                return qual$4.linkTopic((String)topic, x$10, linkName, x$12, x$13);
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirrorTransitionsWithMultipleLinks$6(String topic$1, int p) {
        return new TopicPartition(topic$1, p);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirrorTransitionsWithMultipleLinks$10(String topic$2, int p) {
        return new TopicPartition(topic$2, p);
    }

    public static final /* synthetic */ void $anonfun$testMirrorTransitionsWithMultipleLinks$11(ClusterLinkMetricsReductionIntegrationTest $this, String linkName) {
        ClusterLinkTestHarness qual$6 = $this.destCluster();
        boolean x$18 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$19 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(linkName, x$18, x$19);
    }
}

