/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005=4A\u0001C\u0005\u0001\u001d!)1\u0003\u0001C\u0001)!9a\u0003\u0001b\u0001\n\u00039\u0002B\u0002\u0010\u0001A\u0003%\u0001\u0004C\u0004 \u0001\t\u0007I\u0011\u0001\u0011\t\r%\u0002\u0001\u0015!\u0003\"\u0011\u0015Q\u0003\u0001\"\u0011,\u0011\u0015\t\u0005\u0001\"\u0001C\u0005!\u001aE.^:uKJd\u0015N\\6SKF,Xm\u001d;S_V$\u0018N\\4J]R,wM]1uS>tG+Z:u\u0015\tQ1\"\u0001\u0003mS:\\'\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Ei\u0011!C\u0005\u0003%%\u0011!%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].Le\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0016!\t\u0001\u0002!\u0001\u0006ts:\u001c\u0007+\u001a:j_\u0012,\u0012\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0005\u0019>tw-A\u0006ts:\u001c\u0007+\u001a:j_\u0012\u0004\u0013!D2p]N,X.\u001a:He>,\b/F\u0001\"!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0017AD2p]N,X.\u001a:He>,\b\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003Y=\u0002\"!G\u0017\n\u00059R\"\u0001B+oSRDQ\u0001\r\u0004A\u0002E\n\u0001\u0002^3ti&sgm\u001c\t\u0003emj\u0011a\r\u0006\u0003iU\n1!\u00199j\u0015\t1t'A\u0004kkBLG/\u001a:\u000b\u0005aJ\u0014!\u00026v]&$(\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=g\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0007}A\u0011!gP\u0005\u0003\u0001N\u0012!BQ3g_J,W)Y2i\u0003e\"Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cHOU8vi&tw\rT1uKN$(+Z9vKN$h+\u001a:tS>tGc\u0001\u0017D\u001f\")Ai\u0002a\u0001\u000b\u00061\u0011/^8sk6\u0004\"AR'\u000f\u0005\u001d[\u0005C\u0001%\u001b\u001b\u0005I%B\u0001&\u000e\u0003\u0019a$o\\8u}%\u0011AJG\u0001\u0007!J,G-\u001a4\n\u0005!r%B\u0001'\u001b\u0011\u0015\u0001v\u00011\u0001R\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\u0005e\u0011\u0016BA*\u001b\u0005\u001d\u0011un\u001c7fC:DCaB+\\9B\u0011a+W\u0007\u0002/*\u0011\u0001,N\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005i;&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005i\u0016\u0001K>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{:\u001awn\u001c:eS:\fGo\u001c:>wFj\b\u0006B\u0004`K\u001a\u0004\"\u0001Y2\u000e\u0003\u0005T!AY,\u0002\u0011A\u0014xN^5eKJL!\u0001Z1\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003\u001d\f\u0013\u0001[\u0001\u0010C2d7i\\7cS:\fG/[8og\"\"\u0001A[3n!\t\u00114.\u0003\u0002mg\t\u0019A+Y4\"\u00039\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClusterLinkRequestRoutingIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long syncPeriod;
    private final String consumerGroup;

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        None$ x$3 = None$.MODULE$;
        int x$4 = 2;
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$3, 0, x$4));
        None$ x$8 = None$.MODULE$;
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        super.setUp(testInfo);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDescribeClusterLinkRequestRoutingLatestRequestVersion(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkRequestRoutingIntegrationTest.$anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to get correct FindCoordinator response");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l3 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkRequestRoutingIntegrationTest.$anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$5(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                    Object var22_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l3);
                l3 += package$.MODULE$.min(l3, 1000L);
                continue;
            }
            break;
        }
        Object var10_8 = null;
        Object var15_12 = null;
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkRequestRoutingIntegrationTest.$anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to get expected response from link coordinator");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$3(ClusterLinkRequestRoutingIntegrationTest $this, int linkCoordinatorBrokerId$1, SocketServer broker) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.CLUSTER_LINK.id()).setKey($this.linkName())).build();
        FindCoordinatorResponse response = (FindCoordinatorResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, broker, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return response.data().coordinators().size() == 1 && ((FindCoordinatorResponseData.Coordinator)response.data().coordinators().get(0)).nodeId() == linkCoordinatorBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$1(ClusterLinkRequestRoutingIntegrationTest $this) {
        int linkCoordinatorBrokerId = $this.destCluster().linkCoordinator($this.linkName()).config().brokerId();
        return ((scala.collection.immutable.Seq)$this.destCluster().brokers().toSeq().map((Function1 & Serializable)x$1 -> x$1.socketServer())).forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRequestRoutingIntegrationTest.$anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$3($this, linkCoordinatorBrokerId, broker)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$4() {
        return "Failed to get correct FindCoordinator response";
    }

    public static final /* synthetic */ void $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$5(ClusterLinkRequestRoutingIntegrationTest $this) {
        SocketServer linkCoordinator = $this.destCluster().linkCoordinator($this.linkName()).socketServer();
        DescribeClusterLinksRequest request = (DescribeClusterLinksRequest)new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singletonList($this.linkName())), false, true, 60000).build();
        DescribeClusterLinksResponse response = (DescribeClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, linkCoordinator, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), ClassTag$.MODULE$.apply(DescribeClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        Assertions.assertEquals((int)4, (int)((DescribeClusterLinksResponseData.EntryData)response.data().entries().get(0)).tasks().size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$8(ClusterLinkRequestRoutingIntegrationTest $this, SocketServer socketServer) {
        DescribeClusterLinksRequest request = (DescribeClusterLinksRequest)new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singletonList($this.linkName())), false, true, 60000).build();
        DescribeClusterLinksResponse response = (DescribeClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socketServer, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), ClassTag$.MODULE$.apply(DescribeClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return Errors.NOT_COORDINATOR.code() == response.data().errorCode();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$6(ClusterLinkRequestRoutingIntegrationTest $this) {
        Seq nonLinkCoordinators = (Seq)$this.destCluster().nonLinkCoordinators($this.linkName()).map((Function1 & Serializable)x$2 -> x$2.socketServer());
        return nonLinkCoordinators.nonEmpty() && nonLinkCoordinators.forall((Function1 & Serializable)socketServer -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRequestRoutingIntegrationTest.$anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$8($this, socketServer)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeClusterLinkRequestRoutingLatestRequestVersion$9() {
        return "Failed to get expected response from link coordinator";
    }

    public ClusterLinkRequestRoutingIntegrationTest() {
        this.syncPeriod = 100L;
        this.consumerGroup = "testGroup";
    }
}

