/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import io.confluent.kafka.replication.push.ReplicationState;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:4")})
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YA\u0011\u0002\u0007\u0001A\u0002\u0003\u0005\u000b\u0015B\r\t\u000b\u0015\u0002A\u0011\t\u0014\t\u000bM\u0002A\u0011\u0002\u001b\t\u000fu\u0002\u0011\u0013!C\u0005}!)\u0011\n\u0001C\u0001\u0015\")A\u000f\u0001C\u0001k\")A\u0010\u0001C\u0005{\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M!\u0001G\"p[B\f7\r^3e\u001b&\u0014(o\u001c:U_BL7\rV3ti*\u0011A\"D\u0001\u0005Y&t7NC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0006\n\u0005QY!AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011!\u0003A\u0001\n?R,7\u000f^%oM>\u0004\"AG\u0012\u000e\u0003mQ!\u0001H\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001f?\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0011\"\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0013aA8sO&\u0011Ae\u0007\u0002\t)\u0016\u001cH/\u00138g_\u0006)1/\u001a;VaR\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0005+:LG\u000fC\u0003/\u0007\u0001\u0007\u0011$\u0001\u0005uKN$\u0018J\u001c4pQ\t\u0019\u0001\u0007\u0005\u0002\u001bc%\u0011!g\u0007\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!D:fiV\u00038\t\\;ti\u0016\u00148\u000f\u0006\u0002(k!9a\u0007\u0002I\u0001\u0002\u00049\u0014aD2mK\u0006tWM]%oi\u0016\u0014h/\u00197\u0011\u0007!B$(\u0003\u0002:S\t1q\n\u001d;j_:\u0004\"\u0001K\u001e\n\u0005qJ#aA%oi\u000692/\u001a;Va\u000ecWo\u001d;feN$C-\u001a4bk2$H%M\u000b\u0002\u007f)\u0012q\u0007Q\u0016\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\nk:\u001c\u0007.Z2lK\u0012T!AR\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002I\u0007\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021Q,7\u000f^\"p[B\f7\r^3e\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0003(\u0017bk\u0006\"\u0002'\u0007\u0001\u0004i\u0015AB9v_J,X\u000e\u0005\u0002O+:\u0011qj\u0015\t\u0003!&j\u0011!\u0015\u0006\u0003%>\ta\u0001\u0010:p_Rt\u0014B\u0001+*\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QK\u0003\"B-\u0007\u0001\u0004Q\u0016aC2p_J$\u0017N\\1u_J\u0004\"\u0001K.\n\u0005qK#a\u0002\"p_2,\u0017M\u001c\u0005\u0006=\u001a\u0001\r!T\u0001\u0011Y>\u001c\u0017\r\u001c*fa2L7-\u0019;j_:DCA\u00021gOB\u0011\u0011\rZ\u0007\u0002E*\u00111-H\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005\u0015\u0014'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005A\u0017!P>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{:\u001awn\u001c:eS:\fGo\u001c:>wFjh\u0006\\8dC2\u0014V\r\u001d7jG\u0006$\u0018n\u001c8>wJj\b\u0006\u0002\u0004kaF\u0004\"a\u001b8\u000e\u00031T!!\u001c2\u0002\u0011A\u0014xN^5eKJL!a\u001c7\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003I\f\u0013a]\u0001)cV|'/^7D_>\u0014H-\u001b8bi>\u0014(+\u001a9mS\u000e\fG/[8o\u0007>l'-\u001b8bi&|gn]\u0001(i\u0016\u001cHoQ8na\u0006\u001cG/\u001a3NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u0019><7\t\\3b]&tw\r\u0006\u0003(m^D\b\"\u0002'\b\u0001\u0004i\u0005\"B-\b\u0001\u0004Q\u0006\"\u00020\b\u0001\u0004i\u0005\u0006B\u0004aM\u001eDCa\u00026qw2\n!/\u0001\nxC&$hi\u001c:M_\u001e\u001cE.Z1oS:<G\u0003B\u0014\u007f\u0003\u000fAaa \u0005A\u0002\u0005\u0005\u0011aB2mkN$XM\u001d\t\u0004%\u0005\r\u0011bAA\u0003\u0017\t12\t\\;ti\u0016\u0014H*\u001b8l)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0004\u0002\n!\u0001\r!a\u0003\u0002\r=4gm]3u!\rA\u0013QB\u0005\u0004\u0003\u001fI#\u0001\u0002'p]\u001e\fa\"\u00199qK:$\u0017\t^(gMN,G\u000fF\u0003(\u0003+\tI\u0002\u0003\u0004\u0002\u0018%\u0001\rAO\u0001\na\u0006\u0014H/\u001b;j_:Dq!!\u0003\n\u0001\u0004\tY\u0001\u000b\u0004\u0001\u0003;\u0001\u00181\u0005\t\u00045\u0005}\u0011bAA\u00117\t\u0019A+Y4\"\u0005\u0005\u0015\u0012aC5oi\u0016<'/\u0019;j_:Dc\u0001AA\u000fa\u0006%\u0012EAA\u0016\u0003M\u0011\u0017M_3muMD\u0017M\u001d3`G>,h\u000e\u001e\u001e5\u0001")
public class CompactedMirrorTopicTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$3 = None$.MODULE$;
            int x$4 = 2;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$3, 0, x$4));
            None$ x$7 = None$.MODULE$;
            int x$8 = 2;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$7, 100, x$8));
            return;
        }
        if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$11 = None$.MODULE$;
            int x$12 = 2;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$11, 0, x$12));
            None$ x$15 = None$.MODULE$;
            int x$16 = 2;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$15, 100, x$16));
            return;
        }
    }

    private void setUpClusters(Option<Object> cleanerInterval) {
        this.sourceCluster().producerConfig().setProperty("batch.size", "150");
        cleanerInterval.foreach((Function1 & Serializable)intervalMs -> CompactedMirrorTopicTest.$anonfun$setUpClusters$1(this, BoxesRunTime.unboxToInt((Object)intervalMs)));
        super.setUp(this._testInfo);
        this.numPartitions_$eq(2);
        Properties topicProps = new Properties();
        topicProps.put("cleanup.policy", "compact");
        topicProps.put("segment.bytes", "1000");
        topicProps.put("min.compaction.lag.ms", "5");
        topicProps.put("max.compaction.lag.ms", "2000");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, topicProps, x$5, x$6);
    }

    private Option<Object> setUpClusters$default$1() {
        return None$.MODULE$;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}.localReplication={2}")
    @MethodSource(value={"quorumCoordinatorReplicationCombinations"})
    public void testCompactedMirrorTopic(String quorum, boolean coordinator, String localReplication) {
        this.setUpClusters((Option<Object>)None$.MODULE$);
        this.produceToSourceCluster(10);
        this.appendRecords$1(100L);
        this.appendRecords$1(0xFFFFFFFEL);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = qual$1.createDestClusterLink$default$3();
        long x$4 = qual$1.createDestClusterLink$default$4();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().maybeWaitUntilReplicasInPushMode(new TopicPartition(this.topic(), 0));
        Assertions.assertFalse((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.destCluster().brokers(), new TopicPartition(this.topic(), 0), ReplicationState.Mode.PUSH));
        this.appendRecords$1(10L);
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}.localReplication={2}")
    @MethodSource(value={"quorumCoordinatorReplicationCombinations"})
    public void testCompactedMirrorTopicWithLogCleaning(String quorum, boolean coordinator, String localReplication) {
        this.setUpClusters((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = qual$1.createDestClusterLink$default$3();
        long x$4 = qual$1.createDestClusterLink$default$4();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        ByteArraySerializer x$12 = qual$3.createProducer$default$1();
        ByteArraySerializer x$13 = qual$3.createProducer$default$2();
        Properties x$14 = qual$3.createProducer$default$3();
        KafkaProducer producer = qual$3.createProducer(x$12, x$13, x$14);
        this.produceRecords(producer, this.topic(), 500, (Function1<Object, String>)(Function1 & Serializable)index -> CompactedMirrorTopicTest.$anonfun$testCompactedMirrorTopicWithLogCleaning$1(BoxesRunTime.unboxToInt((Object)index)), this.produceRecords$default$5(), this.produceRecords$default$6());
        this.waitForLogCleaning(this.sourceCluster(), 400L);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitForLogCleaning(this.destCluster(), 400L);
    }

    private void waitForLogCleaning(ClusterLinkTestHarness cluster, long offset) {
        this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).foreach((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)CompactedMirrorTopicTest.$anonfun$waitForLogCleaning$1(cluster, offset, tp)));
    }

    private void appendAtOffset(int partition, long offset) {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ByteBufferOutputStream bytesOut = new ByteBufferOutputStream(buf);
        long nowMs = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bytesOut, 2, CompressionType.NONE, TimestampType.CREATE_TIME, offset, nowMs, 0L, (short)0, 0, false, false, 0, buf.capacity());
        byte[] key = new StringBuilder(4).append("key-").append(offset).toString().getBytes();
        byte[] value = new StringBuilder(6).append("value-").append(offset).toString().getBytes();
        builder.append(nowMs, key, value);
        MemoryRecords records = builder.build();
        TopicPartition tp = new TopicPartition(this.topic(), partition);
        LogManager qual$1 = this.sourceCluster().partitionLeader(tp).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        ((AbstractLog)qual$1.getLog(tp, x$2).get()).appendAsFollower(records);
        this.producedRecords().$plus$eq((Object)new AbstractClusterLinkIntegrationTest.SourceRecord(this, this.topic(), partition, key, value, offset));
    }

    public static final /* synthetic */ Object $anonfun$setUpClusters$1(CompactedMirrorTopicTest $this, int intervalMs) {
        $this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(intervalMs));
        $this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(intervalMs));
        return $this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), Integer.toString(intervalMs));
    }

    private final void appendRecords$1(long offsetInterval) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            long startOffset = this.nextOffset(partition);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.appendAtOffset(partition, startOffset + (long)i * offsetInterval + (long)partition));
        });
    }

    public static final /* synthetic */ String $anonfun$testCompactedMirrorTopicWithLogCleaning$1(int index) {
        return new StringBuilder(4).append("key ").append(index % 5).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForLogCleaning$1(ClusterLinkTestHarness cluster$1, long offset$1, TopicPartition tp) {
        return cluster$1.partitionLeader(tp).logManager().cleaner().awaitCleaned(tp, offset$1, 15000L);
    }
}

