/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkStopMirrorTopicTaskType$;
import kafka.server.link.TaskType;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rB\u0011\"\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0014\t\u0013M\u0002\u0001\u0019!a\u0001\n\u0013!\u0004\"C\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003(\u0011%q\u0004\u00011AA\u0002\u0013%q\bC\u0005D\u0001\u0001\u0007\t\u0019!C\u0005\t\"Ia\t\u0001a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\n}B\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u0013-\u0003\u0001\u0019!A!B\u0013\u0001\u0005\"\u0002'\u0001\t\u0003j\u0005\"\u0002+\u0001\t\u0013)\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u00021\u0001\t\u0003Y\u0006\"\u00022\u0001\t\u0003\u0019\u0007bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\u0007\u0003?\u0001A\u0011A.\t\r\u0005\r\u0002\u0001\"\u0001\\\u0011\u0019\t9\u0003\u0001C\u00017\"1\u00111\u0006\u0001\u0005\u0002mCa!a\f\u0001\t\u0003Y\u0006BBA\u001a\u0001\u0011%1L\u0001\u0010MS:\\7i\\8sI&t\u0017\r^8s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0011DG\u0001\u0005Y&t7NC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0001S\"\u0001\r\n\u0005\u0005B\"AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011q\u0004A\u0001\n?R,7\u000f^%oM>,\u0012a\n\t\u0003QEj\u0011!\u000b\u0006\u0003U-\n1!\u00199j\u0015\taS&A\u0004kkBLG/\u001a:\u000b\u00059z\u0013!\u00026v]&$(\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023S\tAA+Z:u\u0013:4w.A\u0007`i\u0016\u001cH/\u00138g_~#S-\u001d\u000b\u0003km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012A!\u00168ji\"9AhAA\u0001\u0002\u00049\u0013a\u0001=%c\u0005Qq\f^3ti&sgm\u001c\u0011\u00023\u0015t\u0017M\u00197f'>,(oY3NKR\fG-\u0019;b)>\u0004\u0018nY\u000b\u0002\u0001B\u0011a'Q\u0005\u0003\u0005^\u0012qAQ8pY\u0016\fg.A\u000ff]\u0006\u0014G.Z*pkJ\u001cW-T3uC\u0012\fG/\u0019+pa&\u001cw\fJ3r)\t)T\tC\u0004=\r\u0005\u0005\t\u0019\u0001!\u00025\u0015t\u0017M\u00197f'>,(oY3NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002/\u0015t\u0017M\u00197f\t\u0016\u001cH/T3uC\u0012\fG/\u0019+pa&\u001c\u0017aG3oC\ndW\rR3ti6+G/\u00193bi\u0006$v\u000e]5d?\u0012*\u0017\u000f\u0006\u00026\u0015\"9A(CA\u0001\u0002\u0004\u0001\u0015\u0001G3oC\ndW\rR3ti6+G/\u00193bi\u0006$v\u000e]5dA\u0005)1/\u001a;VaR\u0011QG\u0014\u0005\u0006\u001f.\u0001\raJ\u0001\ti\u0016\u001cH/\u00138g_\"\u00121\"\u0015\t\u0003QIK!aU\u0015\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0007tKR,\bo\u00117vgR,'o\u001d\u000b\u0005kYC\u0016\fC\u0003X\u0019\u0001\u0007\u0001)A\bt_V\u00148-Z%oSRL\u0017\r^3e\u0011\u0015qD\u00021\u0001A\u0011\u00159E\u00021\u0001A\u0003\u001d\"Xm\u001d;EKN$\u0018J\\5uS\u0006$X\rZ\"p]R\u0014x\u000e\u001c7feR{7i\u001c8ue>dG.\u001a:\u0015\u0003UB#!D/\u0011\u0005!r\u0016BA0*\u0005\u0011!Vm\u001d;\u0002SQ,7\u000f^*pkJ\u001cW-\u00138ji&\fG/\u001a3D_:$(o\u001c7mKJ$vnQ8oiJ|G\u000e\\3sQ\tqQ,A\u0013uKN$H)Z:u\u0013:LG/[1uK\u0012d\u0015N\\6D_>\u0014H\rV8MS:\\7i\\8sIR\u0019Q\u0007Z9\t\u000b\u0015|\u0001\u0019\u00014\u0002\rE,xN];n!\t9gN\u0004\u0002iYB\u0011\u0011nN\u0007\u0002U*\u00111\u000eH\u0001\u0007yI|w\u000e\u001e \n\u00055<\u0014A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\u001c\t\u000bI|\u0001\u0019\u0001!\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0015\u0005\u001fQT8\u0010\u0005\u0002vq6\taO\u0003\u0002xW\u00051\u0001/\u0019:b[NL!!\u001f<\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001?\u0002Qm$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL2p_J$\u0017N\\1u_Jl40M?)\r=q\u0018\u0011BA\u0006!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001w\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA\u0004\u0003\u0003\u0011A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#!!\u0004\"\u0005\u0005=\u0011aD1mY\u000e{WNY5oCRLwN\\:\u0002OQ,7\u000f^*pkJ\u001cW-\u00138ji&\fG/\u001a3MS:\\7i\\8sIR{G*\u001b8l\u0007>|'\u000f\u001a\u000b\u0006k\u0005U\u0011q\u0003\u0005\u0006KB\u0001\rA\u001a\u0005\u0006eB\u0001\r\u0001\u0011\u0015\u0005!QT8\u0010\u000b\u0004\u0011}\u0006%\u0011Q\u0004\u0017\u0003\u0003\u001b\ta\u0005^3ti\u0012+7\u000f^%oSRL\u0017\r^3e\u0007>tGO]8mY\u0016\u0014Hk\u001c'j].\u001cun\u001c:eQ\t\tR,\u0001\u0015uKN$8k\\;sG\u0016Le.\u001b;jCR,GmQ8oiJ|G\u000e\\3s)>d\u0015N\\6D_>\u0014H\r\u000b\u0002\u0013;\u00061C/Z:u\t\u0016\u001cH/\u00138ji&\fG/\u001a3MS:\\7i\\8sIR{7i\u001c8ue>dG.\u001a:)\u0005Mi\u0016\u0001\u000b;fgR\u001cv.\u001e:dK&s\u0017\u000e^5bi\u0016$G*\u001b8l\u0007>|'\u000f\u001a+p\u0007>tGO]8mY\u0016\u0014\bF\u0001\u000b^\u00039\"Xm\u001d;MS:\\7i\\8sI&t\u0017\r^8s'R|\u0007o\u001d*v]:Lgn\u001a+bg.\u001cxJ\u001c$bS2|g/\u001a:)\u0005Ui\u0016a\u0006<fe&4\u0017pQ8pe\u0012Lg.\u0019;pe\u000eC\u0017M\\4fQ\u001d\u0001\u0011qGA\u0005\u0003{\u00012\u0001KA\u001d\u0013\r\tY$\u000b\u0002\u0004)\u0006<\u0017EAA \u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class LinkCoordinatorIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;
    private boolean enableSourceMetadataTopic;
    private boolean enableDestMetadataTopic;

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    private boolean enableSourceMetadataTopic() {
        return this.enableSourceMetadataTopic;
    }

    private void enableSourceMetadataTopic_$eq(boolean x$1) {
        this.enableSourceMetadataTopic = x$1;
    }

    private boolean enableDestMetadataTopic() {
        return this.enableDestMetadataTopic;
    }

    private void enableDestMetadataTopic_$eq(boolean x$1) {
        this.enableDestMetadataTopic = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo_$eq(testInfo);
    }

    private void setupClusters(boolean sourceInitiated, boolean enableSourceMetadataTopic, boolean enableDestMetadataTopic) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo()) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$12 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 3));
            None$ x$16 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 3));
        }
        this.useSourceInitiatedLink_$eq(sourceInitiated);
        this.enableSourceMetadataTopic_$eq(enableSourceMetadataTopic);
        this.enableDestMetadataTopic_$eq(enableDestMetadataTopic);
        if (enableSourceMetadataTopic) {
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        if (enableDestMetadataTopic) {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        super.setUp(this._testInfo());
    }

    @Test
    public void testDestInitiatedControllerToController() {
        this.setupClusters(false, false, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToController() {
        this.setupClusters(true, false, false);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestInitiatedLinkCoordToLinkCoord(String quorum, boolean coordinator) {
        this.setupClusters(false, true, true);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceInitiatedLinkCoordToLinkCoord(String quorum, boolean coordinator) {
        this.setupClusters(true, true, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedControllerToLinkCoord() {
        this.setupClusters(false, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToLinkCoord() {
        this.setupClusters(true, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedLinkCoordToController() {
        this.setupClusters(false, true, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedLinkCoordToController() {
        this.setupClusters(true, true, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testLinkCoordinatorStopsRunningTasksOnFailover() {
        this.setupClusters(false, true, true);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$15 = qual$3.unlinkTopic$default$3();
        boolean x$16 = qual$3.unlinkTopic$default$4();
        int x$17 = qual$3.unlinkTopic$default$6();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$16, false, x$17);
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.verifyCoordinatorChangeHandlesStoppingAndStartingTasks(this.destCluster(), linkId, this.topic(), (TaskType)ClusterLinkStopMirrorTopicTaskType$.MODULE$, this.enableDestMetadataTopic(), this.enableSourceMetadataTopic());
        this.restartSource(this.restartSource$default$1());
        this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.topic(), this.numPartitions());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
    }

    private void verifyCoordinatorChange() {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.destCluster(), this.enableDestMetadataTopic(), this.enableSourceMetadataTopic());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.sourceCluster(), this.enableDestMetadataTopic(), this.enableSourceMetadataTopic());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
    }
}

