/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.SyncConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:6")})
@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAq\u0001\b\u0001C\u0002\u0013\u0005Q\u0004\u0003\u0004'\u0001\u0001\u0006IA\b\u0005\u0006O\u0001!\t\u0005\u000b\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006S\u0002!\tA\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006e\u0002!\t!\u001d\u0005\u0006g\u0002!\t!\u001d\u0005\u0006i\u0002!\t!\u001d\u0005\u0006k\u0002!IA\u001e\u0005\u0006y\u0002!I! \u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0005yi\u0015N\u001d:peR{\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t)\u0016\u001cHO\u0003\u0002\u0011#\u0005!A.\u001b8l\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0003\u0001U\u0001\"AF\f\u000e\u0003=I!\u0001G\b\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0017\u0001\u0005\u0019Bo\u001c9jGNKhnY%oi\u0016\u0014h/\u00197NgV\ta\u0004\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!A.\u00198h\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\rM#(/\u001b8h\u0003Q!x\u000e]5d'ft7-\u00138uKJ4\u0018\r\\'tA\u0005)1/\u001a;VaR\u0011\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000fC\u00031\t\u0001\u0007\u0011'\u0001\u0005uKN$\u0018J\u001c4p!\t\u00114(D\u00014\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000f),\b/\u001b;fe*\u0011\u0001(O\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002u\u0005\u0019qN]4\n\u0005q\u001a$\u0001\u0003+fgRLeNZ8)\u0005\u0011q\u0004C\u0001\u001a@\u0013\t\u00015G\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0004^3tiR{\u0007/[2D_:4\u0017nZ*z]\u000eLen\u00197vI\u0016$2!K\"P\u0011\u0015!U\u00011\u0001F\u0003\u0019\tXo\u001c:v[B\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u0016\u000e\u0003%S!AS\n\u0002\rq\u0012xn\u001c;?\u0013\ta5&\u0001\u0004Qe\u0016$WMZ\u0005\u0003K9S!\u0001T\u0016\t\u000bA+\u0001\u0019A)\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\t\u0003UIK!aU\u0016\u0003\u000f\t{w\u000e\\3b]\"\"Q!V.]!\t1\u0016,D\u0001X\u0015\tAV'\u0001\u0004qCJ\fWn]\u0005\u00035^\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003u\u000b\u0001f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\r|wN\u001d3j]\u0006$xN]\u001f|cuDC!B0fMB\u0011\u0001mY\u0007\u0002C*\u0011!mV\u0001\taJ|g/\u001b3fe&\u0011A-\u0019\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0002O\u0006\n\u0001.A\bbY2\u001cu.\u001c2j]\u0006$\u0018n\u001c8t\u0003\u0001\"Xm\u001d;U_BL7mQ8oM&<7+\u001f8d\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=\u0015\u0007%ZG\u000eC\u0003E\r\u0001\u0007Q\tC\u0003Q\r\u0001\u0007\u0011\u000b\u000b\u0003\u0007+nc\u0006\u0006\u0002\u0004`K>d\u0013aZ\u0001\u0013m\u0016\u0014\u0018NZ=J]Z\fG.\u001b3WC2,X\rF\u0001*\u0003M2XM]5gs6K'O]8s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8Pm\u0016\u0014(/\u001b3fg\u0006cw/Y=t'ft7mQ8oM&<7/\u0001\bwKJLg-_(wKJ\u0014\u0018\u000eZ3\u0002\u001bY,'/\u001b4z\t\u00164\u0017-\u001e7u\u00031\u0019wN\u001c4jO2K7\u000f^(g)\t)u\u000fC\u0003y\u0017\u0001\u0007\u00110A\u0003fY\u0016l7\u000fE\u0002+u\u0016K!a_\u0016\u0003\u0015q\u0012X\r]3bi\u0016$g(\u0001\u0007baB,g\u000eZ!mo\u0006L8\u000f\u0006\u0002F}\")q\u0010\u0004a\u0001\u000b\u0006\u0011Ao\\\u0001\u0014m\u0016\u0014\u0018NZ=D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\bS\u0005\u0015\u0011\u0011BA\n\u0011\u0019\t9!\u0004a\u0001\u000b\u0006AA.\u001b8l\u001d\u0006lW\rC\u0004\u0002\f5\u0001\r!!\u0004\u0002!Q|\u0007/[2Ts:\u001c\u0017J\\2mk\u0012,\u0007\u0003\u0002$\u0002\u0010\u0015K1!!\u0005O\u0005\r\u0019V\r\u001e\u0005\b\u0003+i\u0001\u0019AA\f\u00039\u0019\u0018P\\2D_:4\u0017n\u001a+za\u0016\u0004B!!\u0007\u0002(9!\u00111DA\u0012\u001d\u0011\ti\"!\t\u000f\u0007!\u000by\"C\u0001\u0013\u0013\t\u0001\u0012#C\u0002\u0002&=\tabU=oG\u000e{gNZ5h)f\u0004X-\u0003\u0003\u0002*\u0005-\"AD*z]\u000e\u001cuN\u001c4jORK\b/\u001a\u0006\u0004\u0003Ky\u0001F\u0002\u0001\u00020\u0015\f)\u0004E\u00023\u0003cI1!a\r4\u0005\r!\u0016mZ\u0011\u0003\u0003o\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\"2\u0001!a\ff\u0003w\t#!!\u0010\u0002'\t\f'0\u001a7;g\"\f'\u000fZ0d_VtGO\u000f\u001c")
public class MirrorTopicConfigSyncRulesTest
extends AbstractClusterLinkIntegrationTest {
    private final String topicSyncIntervalMs;

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.linkTestInfo_$eq(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTopicConfigSyncInclude(String quorum, boolean coordinator) {
        this.createAndStartClusters(this.createAndStartClusters$default$1());
        this.verifyInvalidValue();
        this.verifyMirrorTopicCreationOverridesAlwaysSyncConfigs();
        this.verifyOverride();
        this.verifyDefault();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTopicConfigSyncCompatibility(String quorum, boolean coordinator) {
        Set minimalConfigs = MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs();
        Set newTopicConfigs = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.timestamp.before.max.ms", "message.timestamp.after.max.ms"})));
        Set unknownConfigs = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown.config"})));
        Set missingAlwaysConfigs = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.message.bytes"})));
        Set emptyConfigs = Predef$.MODULE$.Set().empty();
        Set independentConfigs = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.prefer.tier.fetch.ms"})));
        Set corruptConfigs = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bad\u001f"})));
        Map links = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minimalConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)minimalConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newTopicConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)newTopicConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unknownConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)unknownConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"missingAlwaysConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)missingAlwaysConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"emptyConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)emptyConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"independentConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)independentConfigs.mkString(","))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"corruptConfigs"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)corruptConfigs.mkString(","))})))}));
        this.createAndStartClusters((Map<String, Map<String, String>>)links);
        this.verifyCompatibility("minimalConfigs", (Set<String>)minimalConfigs, SyncConfigType$.MODULE$.Valid());
        this.verifyCompatibility("newTopicConfigs", (Set<String>)newTopicConfigs, SyncConfigType$.MODULE$.Valid());
        this.verifyCompatibility("unknownConfigs", (Set<String>)unknownConfigs, SyncConfigType$.MODULE$.UnknownConfig());
        this.verifyCompatibility("missingAlwaysConfigs", (Set<String>)missingAlwaysConfigs, SyncConfigType$.MODULE$.MissingAlways());
        this.verifyCompatibility("emptyConfigs", (Set<String>)emptyConfigs, SyncConfigType$.MODULE$.Empty());
        this.verifyCompatibility("independentConfigs", (Set<String>)independentConfigs, SyncConfigType$.MODULE$.Independent());
        this.verifyCompatibility("corruptConfigs", (Set<String>)corruptConfigs, SyncConfigType$.MODULE$.Corrupt());
    }

    public void verifyInvalidValue() {
        String linkName = UUID.randomUUID().toString();
        new .colon.colon((Object)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.bytes"}).mkString(","), (List)new .colon.colon((Object)this.appendAlways(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}).mkString(",")), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)value -> {
            Properties linkConfigOverrides = new Properties(this, (String)value){
                {
                    this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), value$1);
                    this.putAll((java.util.Map<?, ?>)$outer.destLinkProps($outer.destLinkProps$default$1()));
                }
            };
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        });
    }

    public void verifyMirrorTopicCreationOverridesAlwaysSyncConfigs() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"flush.ms"}).mkString(","));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$1);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        Map mirrorTopicConfigsOverride = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush.ms"), (Object)"14141414")}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            short x$2 = this.replicationFactor();
            String x$5 = qual$1.linkTopic$default$5();
            qual$1.linkTopic(topic, x$2, linkName, (Map<String, String>)mirrorTopicConfigsOverride, x$5);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyOverride() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min.compaction.lag.ms", "flush.ms"}).mkString(","));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$2);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        String minCompactionLagMs = "2222";
        String flushMs = "4444";
        String maxMessageBytesOverride = "3333333";
        String tierEnable = "true";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs, maxMessageBytesOverride, tierEnable){
            {
                this.put("min.compaction.lag.ms", minCompactionLagMs$1);
                this.put("flush.ms", flushMs$1);
                this.put("max.message.bytes", maxMessageBytesOverride$1);
                this.put("confluent.tier.enable", tierEnable$1);
            }
        };
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, linkName, x$10, x$11);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$1(this, topic, maxMessageBytesOverride)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"max.message.bytes should sync");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map expect = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.compaction.lag.ms"), (Object)minCompactionLagMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush.ms"), (Object)flushMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.enable"), (Object)Boolean.toString(false))}));
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, (Map<String, String>)expect), (String)"min.compaction.lag.ms should sync, flush.ms should sync, confluent.tier.enable shouldn't sync");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDefault() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String minCompactionLagMs = "3333333333";
        String flushMs = "11111111";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs){
            {
                this.put("min.compaction.lag.ms", minCompactionLagMs$2);
                this.put("flush.ms", flushMs$2);
            }
        };
        this.createClusterLink(linkName, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, linkName, x$10, x$11);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$1(this, topic, minCompactionLagMs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"min.compaction.lag.ms should sync by default");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, "flush.ms", Long.toString(Long.MAX_VALUE)), (String)"flush.ms shouldn't sync");
    }

    private String configListOf(scala.collection.immutable.Seq<String> elems) {
        return elems.mkString(",");
    }

    private String appendAlways(String to) {
        List elems = (List)new .colon.colon((Object)to, (List)Nil$.MODULE$).$plus$plus((IterableOnce)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().toList());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("elems = ").append(elems).toString());
        return elems.mkString(",");
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCompatibility(String linkName, Set<String> topicSyncInclude, Enumeration.Value syncConfigType) {
        void var42_46;
        Tuple2 tuple2;
        Map sourceTopicConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retention.bytes"), (Object)"1111111"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"22222"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"333333"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.prefer.tier.fetch.ms"), (Object)"44444"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.timestamp.after.max.ms"), (Object)"666666"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.timestamp.before.max.ms"), (Object)"777777")}));
        String topic = new StringBuilder(5).append(linkName).append("Topic").toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.mapToProps((Map<String, String>)sourceTopicConfigs);
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        Enumeration.Value value = syncConfigType;
        Enumeration.Value value2 = SyncConfigType$.MODULE$.Valid();
        boolean linkConfigValidForCurrentVersion = !(value != null ? !value.equals(value2) : value2 != null);
        ObjectRef configuredSyncConfigs = ObjectRef.create(topicSyncInclude);
        Enumeration.Value value3 = syncConfigType;
        Enumeration.Value value4 = SyncConfigType$.MODULE$.Corrupt();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            this.waitForLinkState(linkName, ClusterLinkDescription.LinkState.FAILED, this.destCluster(), 10000L);
            Assertions.assertThrows(InvalidConfigurationException.class, () -> this.describeSyncConfigs$1(linkName));
            configuredSyncConfigs.elem = (Set)topicSyncInclude.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("bad")));
            ClusterLinkTestHarness qual$2 = this.destCluster();
            Map x$8 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)((Set)configuredSyncConfigs.elem).mkString(","))}));
            Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
            Set<String> x$10 = qual$2.alterClusterLink$default$4();
            boolean x$11 = qual$2.alterClusterLink$default$5();
            qual$2.alterClusterLink(linkName, (Map<String, String>)x$8, x$9, x$10, x$11);
            linkConfigValidForCurrentVersion = true;
        }
        this.waitForLinkState(linkName, ClusterLinkDescription.LinkState.ACTIVE, this.destCluster(), 10000L);
        Assertions.assertEquals((Object)((Set)configuredSyncConfigs.elem), (Object)this.describeSyncConfigs$1(linkName));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ListenerName x$12 = qual$3.createAdminClient$default$1();
        Properties x$13 = qual$3.createAdminClient$default$2();
        Admin destAdmin = qual$3.createAdminClient(x$12, x$13);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        short x$15 = this.replicationFactor();
        Map<String, String> x$17 = qual$4.linkTopic$default$4();
        String x$18 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(topic, x$15, linkName, x$17, x$18);
        sourceTopicConfigs.foreach((Function1 & Serializable)x0$1 -> {
            MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$4(configuredSyncConfigs, topic, destAdmin, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newSourceTopicConfigs = sourceTopicConfigs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)Integer.toString(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v)) + 1));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.sourceCluster().alterTopic(topic, (Map<String, String>)newSourceTopicConfigs);
        newSourceTopicConfigs.foreach((Function1 & Serializable)x0$1 -> {
            MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$4(configuredSyncConfigs, topic, destAdmin, x0$1);
            return BoxedUnit.UNIT;
        });
        Map newConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)"10000")}));
        if (linkConfigValidForCurrentVersion) {
            ClusterLinkTestHarness qual$5 = this.destCluster();
            Seq<KafkaBroker> x$21 = qual$5.alterClusterLink$default$3();
            Set<String> x$22 = qual$5.alterClusterLink$default$4();
            boolean x$23 = qual$5.alterClusterLink$default$5();
            qual$5.alterClusterLink(linkName, (Map<String, String>)newConfigs, x$21, x$22, x$23);
        } else {
            Assertions.assertThrows(InvalidConfigurationException.class, () -> {
                ClusterLinkTestHarness qual$6 = this.destCluster();
                Seq<KafkaBroker> x$26 = qual$6.alterClusterLink$default$3();
                Set<String> x$27 = qual$6.alterClusterLink$default$4();
                boolean x$28 = qual$6.alterClusterLink$default$5();
                qual$6.alterClusterLink(linkName, (Map<String, String>)newConfigs, x$26, x$27, x$28);
            });
        }
        Set validSyncInclude = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.bytes"})));
        Map validConfigs = (Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)validSyncInclude.mkString(","))}))).$plus$plus((IterableOnce)newConfigs);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        Seq<KafkaBroker> x$31 = qual$7.alterClusterLink$default$3();
        Set<String> x$32 = qual$7.alterClusterLink$default$4();
        boolean x$33 = qual$7.alterClusterLink$default$5();
        qual$7.alterClusterLink(linkName, (Map<String, String>)validConfigs, x$31, x$32, x$33);
        Assertions.assertEquals((Object)validSyncInclude, (Object)this.describeSyncConfigs$1(linkName));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            String computeUntilTrue_result;
            if (MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$10(computeUntilTrue_result = MirrorTopicConfigSyncRulesTest.topicConfig$1(topic, "retention.bytes", destAdmin))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var57_44 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String retentionBytes = (String)tuple22._1();
        Assertions.assertEquals((Object)"1111112", (Object)var42_46, (String)"Config not synced for retention.bytes");
        ClusterLinkTestHarness qual$8 = this.destCluster();
        int x$36 = this.numPartitions();
        boolean x$37 = qual$8.unlinkTopic$default$3();
        boolean x$38 = qual$8.unlinkTopic$default$4();
        boolean x$39 = qual$8.unlinkTopic$default$5();
        qual$8.unlinkTopic(topic, linkName, x$37, x$38, x$39, x$36);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        boolean x$41 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$42 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(linkName, x$41, x$42);
    }

    public static final /* synthetic */ boolean $anonfun$verifyOverride$1(MirrorTopicConfigSyncRulesTest $this, String topic$2, String maxMessageBytesOverride$1) {
        return $this.destCluster().describeTopicConfigEquals(topic$2, "max.message.bytes", maxMessageBytesOverride$1);
    }

    public static final /* synthetic */ String $anonfun$verifyOverride$2() {
        return "max.message.bytes should sync";
    }

    public static final /* synthetic */ boolean $anonfun$verifyDefault$1(MirrorTopicConfigSyncRulesTest $this, String topic$3, String minCompactionLagMs$2) {
        return $this.destCluster().describeTopicConfigEquals(topic$3, "min.compaction.lag.ms", minCompactionLagMs$2);
    }

    public static final /* synthetic */ String $anonfun$verifyDefault$2() {
        return "min.compaction.lag.ms should sync by default";
    }

    private final Set describeSyncConfigs$1(String linkName$3) {
        String value = this.destCluster().describeClusterLink(linkName$3).get(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).value();
        if (value.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])value.split(",")).toSet();
    }

    private static final String topicConfig$1(String topic, String configName, Admin destAdmin$1) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        try {
            return (String)Option$.MODULE$.apply((Object)((Config)((java.util.Map)destAdmin$1.describeConfigs(Collections.singleton(resource)).all().get(15L, TimeUnit.SECONDS)).get(resource)).get(configName)).map((Function1 & Serializable)x$2 -> x$2.value()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyCompatibility$5(String topic$4, String name$1, Admin destAdmin$1) {
        return MirrorTopicConfigSyncRulesTest.topicConfig$1(topic$4, name$1, destAdmin$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyCompatibility$6(String sourceValue$1, String x$3) {
        String string = x$3;
        return !(string != null ? !string.equals(sourceValue$1) : sourceValue$1 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyCompatibility$4(ObjectRef configuredSyncConfigs$1, String topic$4, Admin destAdmin$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            String sourceValue = (String)x0$1._2();
            if ((((Set)configuredSyncConfigs$1.elem).contains((Object)name) || MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().contains((Object)name)) && !MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs().contains((Object)name)) {
                void var7_11;
                Tuple2 tuple2;
                long l = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    String computeUntilTrue_result;
                    if (MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$6(sourceValue, computeUntilTrue_result = MirrorTopicConfigSyncRulesTest.topicConfig$1(topic$4, name, destAdmin$1))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var14_9 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                String mirrorValue = (String)tuple22._1();
                Assertions.assertEquals((Object)sourceValue, (Object)var7_11, (String)new StringBuilder(22).append("Config not synced for ").append(name).toString());
                return;
            }
            Assertions.assertNotEquals((Object)sourceValue, (Object)MirrorTopicConfigSyncRulesTest.topicConfig$1(topic$4, name, destAdmin$1), (String)new StringBuilder(27).append("Unexpected config sync for ").append(name).toString());
            return;
        }
        throw new MatchError(null);
    }

    private static final void verifyMirrorTopicConfigs$1(Map sourceConfigs, ObjectRef configuredSyncConfigs$1, String topic$4, Admin destAdmin$1) {
        sourceConfigs.foreach((Function1 & Serializable)x0$1 -> {
            MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$4(configuredSyncConfigs, topic, destAdmin, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$verifyCompatibility$9(String topic$4, Admin destAdmin$1) {
        return MirrorTopicConfigSyncRulesTest.topicConfig$1(topic$4, "retention.bytes", destAdmin$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyCompatibility$10(String x$4) {
        String string = x$4;
        String string2 = "1111112";
        return string != null && string.equals(string2);
    }

    public MirrorTopicConfigSyncRulesTest() {
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
    }

    public static final /* synthetic */ Object $anonfun$verifyCompatibility$10$adapted(String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$10(x$4));
    }

    public static final /* synthetic */ Object $anonfun$verifyCompatibility$6$adapted(String sourceValue$1, String x$3) {
        return BoxesRunTime.boxToBoolean((boolean)MirrorTopicConfigSyncRulesTest.$anonfun$verifyCompatibility$6(sourceValue$1, x$3));
    }
}

