/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.Implicits;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t=e!\u0002\u001b6\u0003\u0003Q\u0004\"B!\u0001\t\u0003\u0011\u0005\"C#\u0001\u0001\u0004\u0005\r\u0011\"\u0001G\u0011%Q\u0005\u00011AA\u0002\u0013\u00051\nC\u0005R\u0001\u0001\u0007\t\u0011)Q\u0005\u000f\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u0002/\u0001A\u0003%A\u000bC\u0004^\u0001\t\u0007I\u0011\u00020\t\r)\u0004\u0001\u0015!\u0003`\u0011\u001dY\u0007A1A\u0005\n1Da\u0001\u001d\u0001!\u0002\u0013i\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000f]\u0004!\u0019!C\u0005q\"1A\u0010\u0001Q\u0001\neDq! \u0001C\u0002\u0013%A\u000e\u0003\u0004\u007f\u0001\u0001\u0006I!\u001c\u0005\b\u007f\u0002\u0011\r\u0011\"\u0003m\u0011\u001d\t\t\u0001\u0001Q\u0001\n5D\u0001\"a\u0001\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003z\u0011\u001d\t9\u0001\u0001D\u0001\u0003\u0013Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002@\u0001!\t!!\u0011\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005-\u0004\"CAA\u0001E\u0005I\u0011AAB\u0011%\t9\tAI\u0001\n\u0003\tI\tC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\u0010\"I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003+\u0003\u0011\u0013!C\u0001\u0003\u0013Cq!a&\u0001\t\u0003\tI\nC\u0005\u0002h\u0002\t\n\u0011\"\u0001\u0002\u0004\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003W\u0004\u0011\u0013!C\u0001\u0003\u0013C\u0011\"!<\u0001#\u0003%\t!a$\t\u0013\u0005=\b!%A\u0005\u0002\u0005%\u0005\"CAy\u0001E\u0005I\u0011AAH\u0011%\t\u0019\u0010AI\u0001\n\u0003\ty\tC\u0005\u0002v\u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011q\u001f\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0003{\u0004\u0011\u0013!C\u0001\u0003WB\u0011\"a@\u0001#\u0003%\t!a$\t\u0011\t\u0005\u0001\u00011A\u0005\n1D\u0011Ba\u0001\u0001\u0001\u0004%IA!\u0002\t\u000f\t%\u0001\u0001)Q\u0005[\"1!1\u0002\u0001\u0005\u00021DqA!\u0004\u0001\t\u0003\t9\u0003C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u0013\te\u0003!%A\u0005\u0002\u0005=\u0005\"\u0003B.\u0001E\u0005I\u0011\u0001B/\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqAa\u001f\u0001\t\u0003\u0011iHA\u0011BEN$(/Y2u\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u00027o\u0005\u0019An\\4\u000b\u0003a\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\"\u0011\u0005\u0011\u0003Q\"A\u001b\u0002\u000f\rdW-\u00198feV\tq\t\u0005\u0002E\u0011&\u0011\u0011*\u000e\u0002\u000b\u0019><7\t\\3b]\u0016\u0014\u0018aC2mK\u0006tWM]0%KF$\"\u0001T(\u0011\u0005qj\u0015B\u0001(>\u0005\u0011)f.\u001b;\t\u000fA\u001b\u0011\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\rdW-\u00198fe\u0002\na\u0001\\8h\t&\u0014X#\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016AA5p\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\t\u0019KG.Z\u0001\bY><G)\u001b:!\u0003\u0011awnZ:\u0016\u0003}\u00032\u0001Y3h\u001b\u0005\t'B\u00012d\u0003\u001diW\u000f^1cY\u0016T!\u0001Z\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002gC\nQA*[:u\u0005V4g-\u001a:\u0011\u0005\u0011C\u0017BA56\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000b1|wm\u001d\u0011\u0002+\u0011,g-Y;mi6\u000b\u00070T3tg\u0006<WmU5{KV\tQ\u000e\u0005\u0002=]&\u0011q.\u0010\u0002\u0004\u0013:$\u0018A\u00063fM\u0006,H\u000e^'bq6+7o]1hKNK'0\u001a\u0011\u0002;\u0011,g-Y;mi6Kgn\u00117fC:\f'\r\\3ESJ$\u0018PU1uS>,\u0012a\u001d\t\u0003yQL!!^\u001f\u0003\u000b\u0019cw.\u0019;\u0002=\u0011,g-Y;mi6Kgn\u00117fC:\f'\r\\3ESJ$\u0018PU1uS>\u0004\u0013!\u00073fM\u0006,H\u000e^'j]\u000e{W\u000e]1di&|g\u000eT1h\u001bN+\u0012!\u001f\t\u0003yiL!a_\u001f\u0003\t1{gnZ\u0001\u001bI\u00164\u0017-\u001e7u\u001b&t7i\\7qC\u000e$\u0018n\u001c8MC\u001el5\u000bI\u0001\u0013I\u00164\u0017-\u001e7u\t\u0016dW\r^3EK2\f\u00170A\neK\u001a\fW\u000f\u001c;EK2,G/\u001a#fY\u0006L\b%\u0001\neK\u001a\fW\u000f\u001c;TK\u001elWM\u001c;TSj,\u0017a\u00053fM\u0006,H\u000e^*fO6,g\u000e^*ju\u0016\u0004\u0013!\u00073fM\u0006,H\u000e^'bq\u000e{W\u000e]1di&|g\u000eT1h\u001bN\f!\u0004Z3gCVdG/T1y\u0007>l\u0007/Y2uS>tG*Y4Ng\u0002\nA\u0001^5nKV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\t#\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0011)H/\u001b7\u000b\t\u0005U\u0011qC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007a\nIB\u0003\u0003\u0002\u001c\u0005u\u0011AB1qC\u000eDWM\u0003\u0002\u0002 \u0005\u0019qN]4\n\t\u0005\r\u0012q\u0002\u0002\t\u001b>\u001c7\u000eV5nK\u0006AA/Z1sI><h\u000eF\u0001MQ\r1\u00121\u0006\t\u0005\u0003[\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t\u0007/\u001b\u0006\u0005\u0003k\t9$A\u0004kkBLG/\u001a:\u000b\t\u0005e\u0012QD\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003{\tyCA\u0005BMR,'/R1dQ\u0006\u0019Bn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fgR\u0001\u00121IA'\u0003#\n)&!\u0017\u0002^\u0005\u0005\u0014Q\r\t\u0005\u0003\u000b\nI%\u0004\u0002\u0002H)\u0019\u0011\u0011\u0003-\n\t\u0005-\u0013q\t\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"CA(/A\u0005\t\u0019AA\"\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u0005\u0007\u0003':\u0002\u0019A7\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"A\u0011qK\f\u0011\u0002\u0003\u00071/\u0001\fnS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p\u0011!\tYf\u0006I\u0001\u0002\u0004I\u0018AE7j]\u000e{W\u000e]1di&|g\u000eT1h\u001bND\u0001\"a\u0018\u0018!\u0003\u0005\r!\\\u0001\fI\u0016dW\r^3EK2\f\u0017\u0010\u0003\u0005\u0002d]\u0001\n\u00111\u0001n\u0003-\u0019XmZ7f]R\u001c\u0016N_3\t\u0011\u0005\u001dt\u0003%AA\u0002e\f!#\\1y\u0007>l\u0007/Y2uS>tG*Y4Ng\u0006iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002n)\"\u00111IA8W\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA>{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0014Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\b7pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015%fA:\u0002p\u0005iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\f*\u001a\u00110a\u001c\u0002;1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uIU*\"!!%+\u00075\fy'A\u000fm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012:\u0014aC7bW\u0016\u001cE.Z1oKJ$\u0012dRAN\u0003\u0007\f)-!3\u0002N\u0006=\u0017\u0011[Aj\u0003+\f9.!9\u0002d\"9\u0011Q\u0014\u0010A\u0002\u0005}\u0015A\u00039beRLG/[8ogB1\u0011\u0011UAY\u0003osA!a)\u0002.:!\u0011QUAV\u001b\t\t9KC\u0002\u0002*f\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0007\u0005=V(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0016Q\u0017\u0002\t\u0013R,'/\u00192mK*\u0019\u0011qV\u001f\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wSA!!0\u0002\u0018\u000511m\\7n_:LA!!1\u0002<\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CA,=A\u0005\t\u0019A:\t\u0011\u0005\u001dg\u0004%AA\u00025\f!B\\;n)\"\u0014X-\u00193t\u0011!\tYM\bI\u0001\u0002\u0004I\u0018!\u00032bG.|gMZ't\u0011!\t\u0019F\bI\u0001\u0002\u0004i\u0007\u0002CA.=A\u0005\t\u0019A=\t\u0011\u0005}c\u0004%AA\u00025D\u0001\"a\u0019\u001f!\u0003\u0005\r!\u001c\u0005\t\u0003Or\u0002\u0013!a\u0001s\"I\u0011\u0011\u001c\u0010\u0011\u0002\u0003\u0007\u00111\\\u0001\u0014G2,\u0017M\\3s\u0013>\u0014UO\u001a4feNK'0\u001a\t\u0005y\u0005uW.C\u0002\u0002`v\u0012aa\u00149uS>t\u0007\"CA(=A\u0005\t\u0019AA\"\u0011!\t)O\bI\u0001\u0002\u0004i\u0017\u0001\b7pO\u0012+G.\u001a;j_:l\u0015\r_*fO6,g\u000e^:QKJ\u0014VO\\\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIM\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$C'A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012:\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H\u0005O\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0003Yi\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIE\u0002TCAA~U\u0011\tY.a\u001c\u0002-5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE\na#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$\u0013GM\u0001\u0004GR\u0014\u0018aB2ue~#S-\u001d\u000b\u0004\u0019\n\u001d\u0001b\u0002),\u0003\u0003\u0005\r!\\\u0001\u0005GR\u0014\b%A\u0004d_VtG/\u001a:\u0002\u0015%t7mQ8v]R,'/A\u0005xe&$X\rR;qgRq!1\u0003B\u0019\u0005k\u0011IDa\u000f\u0003L\t=\u0003C\u0002B\u000b\u0005/\u0011Y\"D\u0001d\u0013\r\u0011Ib\u0019\u0002\u0004'\u0016\f\bc\u0002\u001f\u0003\u001e5\u0014\t#_\u0005\u0004\u0005?i$A\u0002+va2,7\u0007\u0005\u0003\u0003$\t-b\u0002\u0002B\u0013\u0005O\u00012!!*>\u0013\r\u0011I#P\u0001\u0007!J,G-\u001a4\n\t\t5\"q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t%R\b\u0003\u0004\u00034=\u0002\r!\\\u0001\b]Vl7*Z=t\u0011\u0019\u00119d\fa\u0001[\u00069a.^7EkB\u001c\b\"\u0002\u001c0\u0001\u00049\u0007b\u0002B\u001f_\u0001\u0007!qH\u0001\u0006G>$Wm\u0019\t\u0005\u0005\u0003\u00129%\u0004\u0002\u0003D)!!QIA^\u0003\u0019\u0011XmY8sI&!!\u0011\nB\"\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007\u0002\u0003B'_A\u0005\t\u0019A7\u0002\u0011M$\u0018M\u001d;LKfD\u0011B!\u00150!\u0003\u0005\rAa\u0015\u0002\u00155\fw-[2WC2,X\rE\u0002=\u0005+J1Aa\u0016>\u0005\u0011\u0011\u0015\u0010^3\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t}#\u0006\u0002B*\u0003_\n1d\u0019:fCR,G*\u0019:hKNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$H\u0003\u0003B3\u0005c\u0012)H!\u001f\u0011\u000fq\u00129G!\t\u0003l%\u0019!\u0011N\u001f\u0003\rQ+\b\u000f\\33!\u0011\u0011\tE!\u001c\n\t\t=$1\t\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\r\tM$\u00071\u0001n\u0003\rYW-\u001f\u0005\b\u0005o\u0012\u0004\u0019\u0001B*\u0003QiWm]:bO\u00164uN]7biZ+'o]5p]\"9!Q\b\u001aA\u0002\t}\u0012\u0001C2m_N,Gj\\4\u0015\u00071\u0013y\bC\u00037g\u0001\u0007q\rK\u0004\u0001\u0005\u0007\u0013IIa#\u0011\t\u00055\"QQ\u0005\u0005\u0005\u000f\u000byCA\u0002UC\u001e\fQA^1mk\u0016\f#A!$\u0002\u0017%tG/Z4sCRLwN\u001c")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils.tempDirectory(null, null);
    private final ListBuffer<AbstractLog> logs = ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultMinCompactionLagMS;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;
    private final long defaultMaxCompactionLagMs = Long.MAX_VALUE;
    private int ctr = 0;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<AbstractLog> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultMinCompactionLagMS() {
        return this.defaultMinCompactionLagMS;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    private long defaultMaxCompactionLagMs() {
        return this.defaultMaxCompactionLagMs;
    }

    public abstract MockTime time();

    @AfterEach
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler.shutdown();
        this.logs().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs) {
        Properties props = new Properties();
        props.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        props.put("segment.index.bytes", Predef$.MODULE$.int2Integer(102400));
        props.put("file.delete.delay.ms", Predef$.MODULE$.int2Integer(deleteDelay));
        props.put("cleanup.policy", "compact");
        props.put("min.cleanable.dirty.ratio", Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put("min.compaction.lag.ms", Predef$.MODULE$.long2Long(minCompactionLagMs));
        props.put("max.compaction.lag.ms", Predef$.MODULE$.long2Long(maxCompactionLagMs));
        new Implicits.PropertiesOps(props).$plus$plus$eq(propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultMinCompactionLagMS();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public long logConfigProperties$default$7() {
        return this.defaultMaxCompactionLagMs();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backoffMs, int maxMessageSize, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs, Option<Object> cleanerIoBufferSize, Properties propertyOverrides, int logDeletionMaxSegmentsPerRun) {
        Pool logMap = new Pool((Option)None$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            File dir = new File(this.logDir(), new StringBuilder(1).append(partition.topic()).append("-").append(partition.partition()).toString());
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, minCompactionLagMs, deleteDelay, segmentSize, maxCompactionLagMs));
            MockScheduler x$5 = $this.time().scheduler;
            MockTime x$6 = this.time();
            BrokerTopicStats x$7 = new BrokerTopicStats();
            Metrics x$8 = new Metrics();
            ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
            int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
            TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
            None$ x$14 = None$.MODULE$;
            ChecksumParams x$17 = ChecksumParams.EMPTY;
            None$ x$18 = None$.MODULE$;
            LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            None$ x$20 = None$.MODULE$;
            ConcurrentHashMap x$21 = new ConcurrentHashMap();
            MergedLog log = MergedLog$.MODULE$.apply(dir, logConfig, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, x$10, x$11, (Option)x$18, x$12, x$13, true, (Option)x$14, true, x$19, (Option)x$20, x$21, x$17);
            logMap.put(partition, (Object)log);
            return (ListBuffer)this.logs().$plus$eq((Object)log);
        });
        CleanerConfig cleanerConfig = new CleanerConfig(numThreads, 0x400000L, 0.9, BoxesRunTime.unboxToInt((Object)cleanerIoBufferSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> maxMessageSize / 2)), maxMessageSize, Double.MAX_VALUE, backoffMs, true, logDeletionMaxSegmentsPerRun, "MD5", true);
        return new LogCleaner(cleanerConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logMap, new LogDirFailureChannel(1), (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultMinCompactionLagMS();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public long makeCleaner$default$9() {
        return this.defaultMaxCompactionLagMs();
    }

    public Option<Object> makeCleaner$default$10() {
        return None$.MODULE$;
    }

    public Properties makeCleaner$default$11() {
        return new Properties();
    }

    public int makeCleaner$default$12() {
        return Integer.MAX_VALUE;
    }

    private int ctr() {
        return this.ctr;
    }

    private void ctr_$eq(int x$1) {
        this.ctr = x$1;
    }

    public int counter() {
        return this.ctr();
    }

    public void incCounter() {
        this.ctr_$eq(this.ctr() + 1);
    }

    public Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$3 -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$1(this, startKey, numKeys, log, codec, magicValue, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public int writeDups$default$5() {
        return 0;
    }

    public byte writeDups$default$6() {
        return 2;
    }

    public Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion, CompressionType codec) {
        String value = AbstractLogCleanerIntegrationTest.messageValue$1(128);
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec, x$5, messageFormatVersion);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    public void closeLog(AbstractLog log) {
        log.close();
        this.logs().$minus$eq((Object)log);
    }

    public static final /* synthetic */ Tuple3 $anonfun$writeDups$2(AbstractLogCleanerIntegrationTest $this, AbstractLog log$1, CompressionType codec$1, byte magicValue$1, int key) {
        String value = Integer.toString($this.counter());
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        LogAppendInfo appendInfo = log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, x$5, magicValue$1), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(AbstractLogCleanerIntegrationTest $this, int startKey$1, int numKeys$1, AbstractLog log$1, CompressionType codec$1, byte magicValue$1, int x$3) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, magicValue$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray((ClassTag)ClassTag$.MODULE$.Char()));
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultMinCompactionLagMS = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 2048;
    }
}

