/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.MergedLog;
import kafka.utils.TestUtils$;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013\u0005A\u0005\u0003\u00043\u0001\u0001\u0006I!\n\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0003\\\u0001\u0011\u0005A\nC\u0003a\u0001\u0011%\u0011\rC\u0003z\u0001\u0011%!\u0010\u0003\u0004z\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBa!!\u0017\u0001\t\u0003a\u0005BBA/\u0001\u0011\u0005A\n\u0003\u0004\u0002b\u0001!\t\u0001\u0014\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Ca!!-\u0001\t\u0003a%!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRT!a\u0006\r\u0002\u00071|wMC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\f\n\u0005}1\"!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001#!\ti\u0002!A\u0003d_\u0012,7-F\u0001&!\t1\u0003'D\u0001(\u0015\tA\u0013&\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003U-\naaY8n[>t'BA\r-\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\n\u0005E:#aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002\r\r|G-Z2!\u0003\u0011!\u0018.\\3\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0003u-\naa]3sm\u0016\u0014\u0018B\u0001\u001f8\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%!B!se\u0006L\bCA$I\u001b\u0005I\u0013BA%*\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\tQ\n\u0005\u0002B\u001d&\u0011qJ\u0011\u0002\u0005+:LG\u000f\u000b\u0002\t#B\u0011!+W\u0007\u0002'*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u001dQW\u000f]5uKJT!\u0001\u0017\u0018\u0002\u000b),h.\u001b;\n\u0005i\u001b&!C!gi\u0016\u0014X)Y2i\u0003i\"Xm\u001d;NCJ\\7\u000fU1si&$\u0018n\u001c8t\u0003N|eM\u001a7j]\u0016\fe\u000e\u001a)paVd\u0017\r^3t+:\u001cG.Z1oC\ndW-T3ue&\u001c7\u000f\u000b\u0002\n;B\u0011!KX\u0005\u0003?N\u0013A\u0001V3ti\u0006Iq-\u001a;NKR\u0014\u0018n\u0019\u000b\u0003E:\u0004\"a\u00197\u000e\u0003\u0011T!!\u001a4\u0002\t\r|'/\u001a\u0006\u0003O\"\fq!\\3ue&\u001c7O\u0003\u0002jU\u00061\u00110Y7nKJT\u0011a[\u0001\u0004G>l\u0017BA7e\u0005\u0019iU\r\u001e:jG\")qN\u0003a\u0001a\u00061a-\u001b7uKJ\u0004B!Q9tm&\u0011!O\u0011\u0002\n\rVt7\r^5p]F\u0002\"a\u0019;\n\u0005U$'AC'fiJL7MT1nKB\u0011\u0011i^\u0005\u0003q\n\u0013qAQ8pY\u0016\fg.\u0001\u0005hKR<\u0015-^4f+\rY\u00181\u0001\u000b\u0004y\u0006U\u0001cA2~\u007f&\u0011a\u0010\u001a\u0002\u0006\u000f\u0006,x-\u001a\t\u0005\u0003\u0003\t\u0019\u0001\u0004\u0001\u0005\u000f\u0005\u00151B1\u0001\u0002\b\t\tA+\u0005\u0003\u0002\n\u0005=\u0001cA!\u0002\f%\u0019\u0011Q\u0002\"\u0003\u000f9{G\u000f[5oOB\u0019\u0011)!\u0005\n\u0007\u0005M!IA\u0002B]fDq!a\u0006\f\u0001\u0004\tI\"\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004B!a\u0007\u0002*9!\u0011QDA\u0013!\r\tyBQ\u0007\u0003\u0003CQ1!a\t\u001b\u0003\u0019a$o\\8u}%\u0019\u0011q\u0005\"\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9CQ\u000b\u0005\u0003c\t9\u0004\u0006\u0004\u00024\u0005e\u00121\b\t\u0005Gv\f)\u0004\u0005\u0003\u0002\u0002\u0005]BaBA\u0003\u0019\t\u0007\u0011q\u0001\u0005\b\u0003/a\u0001\u0019AA\r\u0011\u001d\ti\u0004\u0004a\u0001\u00033\t1\"\\3ue&\u001c7kY8qK\u0006Aq-\u001a;NKR,'\u000f\u0006\u0004\u0002D\u0005%\u00131\n\t\u0004G\u0006\u0015\u0013bAA$I\n)Q*\u001a;fe\"9\u0011qC\u0007A\u0002\u0005e\u0001bBA\u001f\u001b\u0001\u0007\u0011\u0011D\u0001\rO\u0016$\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u0003#\n9\u0006E\u0002d\u0003'J1!!\u0016e\u0005%A\u0015n\u001d;pOJ\fW\u000eC\u0004\u0002\u00189\u0001\r!!\u0007\u0002MQ,7\u000f^\"p[B\f7\r^5p]RC'/Z1eg\u000e\u0003X/T3uKJ\u0014UM\\2i[\u0006\u00148\u000e\u000b\u0002\u0010;\u00069B/Z:u\u001b\u0006DHj\\4D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0015\u0003!u\u000bQ\u0003^3ti\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000f\u000b\u0002\u0012;\u0006Y!/Z1e\rJ|W\u000eT8h)\u0011\tI'!!\u0011\r\u0005-\u0014\u0011OA;\u001b\t\tiGC\u0002\u0002p\t\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1cY\u0016\u0004r!QA<\u0003w\nY(C\u0002\u0002z\t\u0013a\u0001V;qY\u0016\u0014\u0004cA!\u0002~%\u0019\u0011q\u0010\"\u0003\u0007%sG\u000f\u0003\u0004\u0018%\u0001\u0007\u00111\u0011\t\u0004;\u0005\u0015\u0015bAAD-\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u000319(/\u001b;f\u0017\u0016LH)\u001e9t)A\ti)a%\u0002\u0018\u0006m\u0015QTAP\u0003S\u000bi\u000b\u0005\u0004\u0002l\u0005=\u0015QO\u0005\u0005\u0003#\u000biGA\u0002TKFDq!!&\u0014\u0001\u0004\tY(A\u0004ok6\\U-_:\t\u000f\u0005e5\u00031\u0001\u0002|\u00059a.^7EkB\u001c\bBB\f\u0014\u0001\u0004\t\u0019\tC\u0003$'\u0001\u0007Q\u0005C\u0004\u0002\"N\u0001\r!a)\u0002\u0013QLW.Z:uC6\u0004\bcA!\u0002&&\u0019\u0011q\u0015\"\u0003\t1{gn\u001a\u0005\b\u0003W\u001b\u0002\u0019AA>\u0003)\u0019H/\u0019:u-\u0006dW/\u001a\u0005\b\u0003_\u001b\u0002\u0019AA>\u0003\u0011\u0019H/\u001a9\u0002%Q,7\u000f^%t)\"\u0014X-\u00193GC&dW\r\u001a\u0015\u0003)u\u0003")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        ArraySeq.ofRef x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, 100L, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$122));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        this.cleaner().logs().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(x$1);
            return BoxedUnit.UNIT;
        });
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There should be 2 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log2.localLogSegments()).asScala().last()).baseOffset())._2$mcJ$sp();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 1000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.cleaner().logs().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(x$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes.value()));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 2000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"There should be 1 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes2 = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.cleaner().logs().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes2.value()));
    }

    private Metric getMetric(Function1<MetricName, Object> filter) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(metricName, mName));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$2(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Meter getMeter(String metricName, String metricScope) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMeter$1(metricName, metricScope, k));
        return (Meter)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Histogram getHistogram(String metricName) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getHistogram$1(metricName, k));
        return (Histogram)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    @Test
    public void testCompactionThreadsCpuMeterBenchmark() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        this.cleaner().startup();
        new ThreadsCpuMeter(((IterableOnceOps)this.cleaner().cleaners().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getId()))).toSeq()).runCpuUtilizationBenchmark();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get(topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The first call to CPU stats should return 0 as we do not have reference values");
        this.time().sleep((long)(maxCompactionLagMs / 2));
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep((long)(maxCompactionLagMs / 2 + 1));
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1(), log.roll$default$2());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, firstBlockCleanableSegmentOffset, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.getGauge("compaction-cpu-utilization-percent").value();
        this.time().sleep((long)(maxCompactionLagMs + 1));
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$17 = activeSegAtT1.baseOffset();
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, x$17, x$18);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
        Assertions.assertNotEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The subsequents calls to CPU stats metric after some valid cleanup should return a non-zero value");
    }

    @Test
    public void testCompactionMetrics() {
        double eps = 1.0E-6;
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get(topicPartitions[0]);
        this.writeKeyDups(100, 3, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSeg = log.activeSegment();
        this.cleaner().startup();
        Meter readBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Histogram achievedCleaningRatio = this.getHistogram("AchievedCleaningRatio");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.time().sleep((long)(maxCompactionLagMs / 2));
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.writeKeyDups(100, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 0);
        long expectedReadBytes = log.size();
        log.roll(log.roll$default$1(), log.roll$default$2());
        long blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep((long)maxCompactionLagMs);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, blockCleanableSegmentOffset, x$15);
        Assertions.assertEquals((long)expectedReadBytes, (long)readBytesPerSec.count(), (String)new StringBuilder(35).append("log cleaner should have read ").append(expectedReadBytes).append(" bytes").toString());
        Assertions.assertEquals((long)log.size(), (long)writeBytesPerSec.count(), (String)new StringBuilder(8).append("a ").append(log.size()).append(" bytes").toString());
        Assertions.assertEquals((double)100.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        Meter readBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Assertions.assertEquals((long)readBytesPerSec.count(), (long)readBytesPerSecForLocal.count());
        Assertions.assertEquals((long)writeBytesPerSec.count(), (long)writeBytesPerSecForLocal.count());
        log.size();
        this.writeKeyDups(75, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        activeSeg = log.activeSegment();
        log.roll(log.roll$default$1(), log.roll$default$2());
        blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep((long)(maxCompactionLagMs * 2));
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, blockCleanableSegmentOffset, x$18);
        Assertions.assertTrue((achievedCleaningRatio.mean() < (double)100 ? 1 : 0) != 0, (String)"achieved cleaning ratio should be less than 100");
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$5 -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)x$5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$62 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, 100000, x$62, x$7, x$8, x$9, x$10, x$11, x$12));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable)x$6 -> {
            x$6.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Threads didn't terminate unexpectedly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = log.activeSegment().log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(Tuple2 x$1) {
        if (x$1 != null) {
            AbstractLog log = (AbstractLog)x$1._2();
            ((MergedLog)log).computeLogSizeDetails().cancel(true);
            ((MergedLog)log).updateSizeDetails();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(Tuple2 x$2) {
        return ((AbstractLog)x$2._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(Tuple2 x$3) {
        return ((AbstractLog)x$3._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$2(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeter$1(String metricName$3, String metricScope$2, MetricName k) {
        return k.getName().endsWith(metricName$3) && k.getScope().endsWith(metricScope$2);
    }

    public static final /* synthetic */ boolean $anonfun$getHistogram$1(String metricName$4, MetricName k) {
        return k.getName().endsWith(metricName$4) && k.getScope() == null;
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int x$5) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

