/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogLoader;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.OffsetsToClean;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}e\u0001B,Y\u0001uCQA\u001b\u0001\u0005\u0002-DqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004y\u0001\u0001\u0006I\u0001\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0001p\u0011\u0019Q\b\u0001)A\u0005a\"91\u0010\u0001b\u0001\n\u0003y\u0007B\u0002?\u0001A\u0003%\u0001\u000fC\u0004~\u0001\t\u0007I\u0011A8\t\ry\u0004\u0001\u0015!\u0003q\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0001\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005\u0005\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0001\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0018\u0001\u0001\u0006I!a\t\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0002\u0002CA$\u0001\u0001\u0006I!!\u000e\t\u0013\u0005%\u0003A1A\u0005\u0002\u0005-\u0003\u0002CA.\u0001\u0001\u0006I!!\u0014\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA4\u0001\u0001\u0006I!!\u0019\t\u0013\u0005%\u0004A1A\u0005\u0002\u0005-\u0004\u0002CA:\u0001\u0001\u0006I!!\u001c\t\u0013\u0005U\u0004A1A\u0005\u0002\u0005]\u0004\u0002CAH\u0001\u0001\u0006I!!\u001f\u0007\r\u0005E\u0005\u0001AAJ\u00111\tYJ\u0007B\u0001B\u0003%\u0011QTA[\u00111\t9L\u0007B\u0001B\u0003%\u0011\u0011XAc\u00111\t9M\u0007B\u0001B\u0003%\u0011\u0011ZAh\u0011\u0019Q'\u0004\"\u0001\u0002R\"9\u0011Q\u001c\u000e\u0005B\u0005}\u0007bBAx5\u0011\u0005\u0013\u0011\u001f\u0005\n\u0005'Q\u0012\u0013!C\u0001\u0005+A\u0011Ba\u000b\u001b#\u0003%\tA!\f\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!1\n\u0001\u0005\n\t5\u0003b\u0002B/\u0001\u0011\u0005!1\u0007\u0005\b\u0005O\u0002A\u0011\u0001B\u001a\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005gAqAa\u001c\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003t\u0001!\tAa\r\t\u000f\t]\u0004\u0001\"\u0001\u00034!9!1\u0010\u0001\u0005\u0002\tM\u0002b\u0002B@\u0001\u0011\u0005!1\u0007\u0005\b\u0005\u0007\u0003A\u0011\u0001B\u001a\u0011\u001d\u00119\t\u0001C\u0001\u0005gAqAa#\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003\u0010\u0002!\tAa\r\t\u000f\tM\u0005\u0001\"\u0001\u00034!9!q\u0013\u0001\u0005\u0002\tM\u0002b\u0002BN\u0001\u0011\u0005!1\u0007\u0005\b\u0005?\u0003A\u0011\u0001B\u001a\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005gAqAa*\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003,\u0002!\tAa\r\t\u000f\t=\u0006\u0001\"\u0001\u00034!9!1\u0017\u0001\u0005\u0002\tM\u0002b\u0002B\\\u0001\u0011\u0005!1\u0007\u0005\b\u0005w\u0003A\u0011\u0001B\u001a\u0011\u001d\u0011y\f\u0001C\u0001\u0005gAqAa1\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003H\u0002!\tAa\r\t\u000f\t-\u0007\u0001\"\u0001\u00034!9!q\u001a\u0001\u0005\u0002\tM\u0002b\u0002Bj\u0001\u0011\u0005!1\u0007\u0005\b\u0005/\u0004A\u0011\u0001B\u001a\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005gAqAa8\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003d\u0002!\tAa\r\t\u000f\t\u001d\b\u0001\"\u0001\u00034!9!1\u001e\u0001\u0005\u0002\tM\u0002b\u0002Bx\u0001\u0011\u0005!1\u0007\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005sDqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\f\u0001!Ia!\u0004\t\u0013\r\u0005\u0002!%A\u0005\n\r\r\u0002\"CB\u0014\u0001E\u0005I\u0011BB\u0015\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_A\u0011b!\u0012\u0001#\u0003%Iaa\u0012\t\u000f\r-\u0003\u0001\"\u0003\u0004N!91Q\f\u0001\u0005\n\r}\u0003bBB4\u0001\u0011%1\u0011\u000e\u0005\n\u0007s\u0002\u0011\u0013!C\u0005\u0007SAqaa\u001f\u0001\t\u0013\u0019i\bC\u0004\u0004\u0018\u0002!Ia!'\u0003+1{wm\u00117fC:,'/T1oC\u001e,'\u000fV3ti*\u0011\u0011LW\u0001\u0004Y><'\"A.\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g!\t)\u0007.D\u0001g\u0015\t9',A\u0003vi&d7/\u0003\u0002jM\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001m!\ti\u0007!D\u0001Y\u0003\u0019!X\u000e\u001d#jeV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0011\u0011n\u001c\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\bi6\u0004H)\u001b:3\u0003!!X\u000e\u001d#jeJ\u0002\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000f1|w\rR5se\u0005AAn\\4ESJ\u0014\u0004%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003+i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0007G>lWn\u001c8\u000b\u0007m\u000biA\u0003\u0003\u0002\u0010\u0005E\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0014\u0005\u0019qN]4\n\t\u0005]\u0011q\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B/\u0001\u0003vi&d\u0017\u0002BA\u0017\u0003O\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0007\t\u0005\u0003o\t\u0019%\u0004\u0002\u0002:)\u0019\u0011,a\u000f\u000b\t\u0005u\u0012qH\u0001\nS:$XM\u001d8bYNTA!!\u0011\u0002\f\u000591\u000f^8sC\u001e,\u0017\u0002BA#\u0003s\u0011\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0003uS6,WCAA'!\u0011\ty%a\u0016\u000e\u0005\u0005E#\u0002BA\u0015\u0003'RA!!\u0016\u0002\f\u000511/\u001a:wKJLA!!\u0017\u0002R\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0004pM\u001a\u001cX\r^\u000b\u0003\u0003C\u00022aXA2\u0013\r\t)\u0007\u0019\u0002\u0004\u0013:$\u0018aB8gMN,G\u000fI\u0001\u001baJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0003\u0003[\u0002B!a\u000e\u0002p%!\u0011\u0011OA\u001d\u0005i\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5h\u0003m\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5hA\u0005\u00112\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\tI\b\u0005\u0005\u0002|\u0005\u0015\u00151AAE\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0007\u0003\u0017AC2pY2,7\r^5p]&!\u0011qQA?\u0005\ri\u0015\r\u001d\t\u0004?\u0006-\u0015bAAGA\n!Aj\u001c8h\u0003M\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:!\u0005UaunZ\"mK\u0006tWM]'b]\u0006<WM]'pG.\u001c2AGAK!\ri\u0017qS\u0005\u0004\u00033C&!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u00069An\\4ESJ\u001c\b#BAP\u0003_\u0003h\u0002BAQ\u0003WsA!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003Oc\u0016A\u0002\u001fs_>$h(C\u0001b\u0013\r\ti\u000bY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.\u0002LA!a'\u0002\u0018\u0006!An\\4t!\u001d)\u00171XA\u0002\u0003\u007fK1!!0g\u0005\u0011\u0001vn\u001c7\u0011\u00075\f\t-C\u0002\u0002Db\u00131\"\u00112tiJ\f7\r\u001e'pO&!\u0011qWAL\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB!\u0011qGAf\u0013\u0011\ti-!\u000f\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0013\u0011\t9-a&\u0015\u0011\u0005M\u0017q[Am\u00037\u00042!!6\u001b\u001b\u0005\u0001\u0001bBAN=\u0001\u0007\u0011Q\u0014\u0005\b\u0003os\u0002\u0019AA]\u0011\u001d\t9M\ba\u0001\u0003\u0013\fQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002bBA\u00111]Av\u0003\u0007\tII\u0004\u0003\u0002f\u0006\u001d\bcAARA&\u0019\u0011\u0011\u001e1\u0002\rA\u0013X\rZ3g\u0013\u0011\t9)!<\u000b\u0007\u0005%\b-A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$\u0002\"a=\u0002z\u0006u(Q\u0002\t\u0004?\u0006U\u0018bAA|A\n!QK\\5u\u0011\u0019\tY\u0010\ta\u0001a\u00069A-\u0019;b\t&\u0014\b\"CA\u0000AA\u0005\t\u0019\u0001B\u0001\u0003Y\u0001\u0018M\u001d;ji&|g\u000eV8Va\u0012\fG/Z(s\u0003\u0012$\u0007#B0\u0003\u0004\t\u001d\u0011b\u0001B\u0003A\n1q\n\u001d;j_:\u0004ra\u0018B\u0005\u0003\u0007\tI)C\u0002\u0003\f\u0001\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B\bAA\u0005\t\u0019\u0001B\t\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8SK6|g/\u001a\t\u0006?\n\r\u00111A\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]!\u0006\u0002B\u0001\u00053Y#Aa\u0007\u0011\t\tu!qE\u0007\u0003\u0005?QAA!\t\u0003$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005K\u0001\u0017AC1o]>$\u0018\r^5p]&!!\u0011\u0006B\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=\"\u0006\u0002B\t\u00053\t\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003gD3a\tB\u001c!\u0011\u0011IDa\u0012\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\t1!\u00199j\u0015\u0011\u0011\tEa\u0011\u0002\u000f),\b/\u001b;fe*!!QIA\t\u0003\u0015QWO\\5u\u0013\u0011\u0011IEa\u000f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017aG:fiV\u0004\u0018J\\2sK\u0006\u001c\u0018N\\4ms\u001aKG\u000e\u001e5z\u0019><7\u000f\u0006\u0005\u0002:\n=#Q\u000bB-\u0011\u001d\u0011\t\u0006\na\u0001\u0005'\n!\u0002]1si&$\u0018n\u001c8t!\u0019\ty*a,\u0002\u0004!9!q\u000b\u0013A\u0002\u0005\u0005\u0014aD:uCJ$h*^7CCR\u001c\u0007.Z:\t\u000f\tmC\u00051\u0001\u0002b\u0005q!-\u0019;dQ&s7M]3nK:$\u0018A\u000f;fgR\u001c\u0005.Z2l\u00072,\u0017M\\5oO\u0006\u0013wN\u001d;fI\u000eCWmY6t\r>\u0014hI]8{K:dunZ*uCJ$xJ\u001a4tKR\u001cF/\u0019;fQ\r)#\u0011\r\t\u0005\u0005s\u0011\u0019'\u0003\u0003\u0003f\tm\"\u0001\u0002+fgR\f\u0011\u0007^3ti\u00063x.\u001b3NCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006L8)\u00197dk2\fG/[8o\u0019\u0006<W*\u0019=WC2,X\rK\u0002'\u0005C\n!\u0005^3ti6\u000b\u0007pQ8na\u0006\u001cG/[8o\u0019\u0006<gi\u001c:dKNdunZ\"mK\u0006t\u0007fA\u0014\u0003b\u0005aC/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004Q\t\u0005\u0014A\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4XSRDG+[3s\u0007>l\u0007/Y2u\r\u0016\fG/\u001e:f\u000b:\f'\r\\3eQ\rI#\u0011M\u00019i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pOJ+G/\u001e:og2{wmV5uQ\u0012K'\u000f^5fgR\u0014\u0016\r^5pQ\rQ#\u0011M\u0001:i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fgVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\u001a1F!\u0019\u0002qQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKNLe\u000e\u0015:pOJ,7o\u001d)beRLG/[8og\"\u001aAF!\u0019\u0002)R,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN\u0014u\u000e\u001e5J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn]!oIVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\u001aQF!\u0019\u0002SQ,7\u000f\u001e#jeRLxJ\u001a4tKR\u0014Vm]3u\u0013\u001ad\u0015M]4feRC\u0017M\\#oI>3gm]3uQ\rq#\u0011M\u0001-i\u0016\u001cH\u000fR5sif|eMZ:fiJ+7/\u001a;JMNk\u0017\r\u001c7feRC\u0017M\\*uCJ$xJ\u001a4tKRD3a\fB1\u0003M\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;MCJ<WM\u001d+iC:\f5\r^5wKN+w-\\3oi\n\u000b7/Z(gMN,G\u000fK\u00021\u0005C\n\u0001\u0007^3ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e'be\u001e,'\u000f\u00165b]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$\bfA\u0019\u0003b\u0005!E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:DY\u0016\fg.\u001e9Q_2L7-\u001f#fY\u0016$X\rT8hg\"\u001a!G!\u0019\u0002\u0011R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\u0007>l\u0007/Y2u\t\u0016dW\r^3M_\u001e\u001c\bfA\u001a\u0003b\u0005\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGRdunZ:)\u0007Q\u0012\t'A\u0016uKN$Hj\\4t+:$WM]\"mK\u0006tW\u000f]%oK2Lw-\u001b2mK\u001a{'oQ8na\u0006\u001cG/[8oQ\r)$\u0011M\u00010i\u0016\u001cH/\u00169eCR,7\t[3dWB|\u0017N\u001c;t'\"|W\u000f\u001c3BI\u0012|eMZ:fiR{\u0007+\u0019:uSRLwN\u001c\u0015\u0004m\t\u0005\u0014A\f;fgR,\u0006\u000fZ1uK\u000eCWmY6q_&tGo]*i_VdGMU3n_Z,\u0007+\u0019:uSRLwN\u001c#bi\u0006D3a\u000eB1\u00035\"Xm\u001d;IC:$G.\u001a'pO\u0012K'OR1jYV\u0014Xm\u00155pk2$'+Z7pm\u0016$\u0015N]!oI\u0012\u000bG/\u0019\u0015\u0004q\t\u0005\u0014!\f;fgRl\u0015-\u001f2f)J,hnY1uK\u000eCWmY6q_&tGo\u00155pk2$GK];oG\u0006$X\rR1uC\"\u001a\u0011H!\u0019\u0002yQ,7\u000f^!mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ\u001c\u0006n\\;mIJ+Wn\u001c<f\t\u0006$\u0018-\u00138Te\u000e$\u0015N]!oI\u0006#G-\u00138OK^$\u0015N\u001d\u0015\u0004u\t\u0005\u0014\u0001\u000b;fgR\u001cuN\\2veJ,g\u000e\u001e'pO\u000ecW-\u00198va\u0006sG\rT8h)J,hnY1uS>t\u0007fA\u001e\u0003b\u0005AC/Z:u\u0007>t7-\u001e:sK:$Hj\\4DY\u0016\fg.\u001e9B]\u0012$v\u000e]5d\t\u0016dW\r^5p]\"\u001aAH!\u0019\u0002\u0005R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u001d>$8i\u001c8tS\u0012,'/\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000fK\u0002>\u0005C\n\u0001\u0004^3ti\u000e{W\u000e]1di\u0016$')\u001f;fg6+GO]5dQ\rq$\u0011M\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_JtuN\\3)\u0007}\u0012\t'A\u0011uKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go]!di&4XmU3h[\u0016tG\u000fK\u0002A\u0005C\n1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:US6,\u0007fA!\u0003b\u0005\u0001C/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN4uN]*i_J$H+[7fQ\r\u0011%\u0011M\u0001)i\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:OK\u0016$7o\u00115fG.\u0004x.\u001b8u%\u0016\u001cX\r\u001e\u0015\u0004\u0007\n\u0005\u0014A\u000b;fgR,f\u000eZ3dS\u0012,G\r\u0016:b]N\f7\r^5p]\u0006dG)\u0019;b\u001d>$8\t\\3b]\u0006\u0014G.\u001a\u0015\u0004\t\n\u0005\u0014\u0001\u0005;fgR$uN\\3DY\u0016\fg.\u001b8hQ\r)%\u0011M\u0001\u0011i\u0016\u001cH\u000fR8oK\u0012+G.\u001a;j]\u001eD3A\u0012B1\u0003=\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8DY\u0016\fg.\u001b8hQ\r9%\u0011M\u00011i\u0016\u001cHo\u00115fG.\u0004x.\u001b8u+B$\u0017\r^3e\r>\u0014\u0018J\u001c<bY&$wJ\u001a4tKRtu\u000e^*fY\u0016\u001cG/\u001a3)\u0007!\u0013\t'\u0001\u000bde\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM\u001d\u000b\u0005\u0003+\u00139\u0010\u0003\u0004Z\u0013\u0002\u0007\u0011q\u0018\u000b\u0005\u0003+\u0013Y\u0010C\u0004\u00028*\u0003\rA!@\u0011\r\u0005\r(q`A`\u0013\u0011\u0019\t!!<\u0003\u0007M+G/\u0001\rde\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM]'pG.$B!a5\u0004\b!91\u0011B&A\u0002\u0005e\u0016\u0001\u00029p_2\f\u0011b\u0019:fCR,Gj\\4\u0015\u0015\u0005}6qBB\n\u0007;\u0019y\u0002C\u0004\u0004\u00121\u0003\r!!\u0019\u0002\u0017M,w-\\3oiNK'0\u001a\u0005\b\u0007+a\u0005\u0019AB\f\u00035\u0019G.Z1okB\u0004v\u000e\\5dsB!\u00111]B\r\u0013\u0011\u0019Y\"!<\u0003\rM#(/\u001b8h\u0011!yH\n%AA\u0002\u0005\r\u0001bB>M!\u0003\u0005\r\u0001]\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0007KQC!a\u0001\u0003\u001a\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u0006\u0016\u0004a\ne\u0011aG2sK\u0006$X\rT8x%\u0016$XM\u001c;j_:dunZ\"p]\u001aLw\r\u0006\u0006\u00026\rE21GB\u001b\u0007\u007fAqa!\u0005P\u0001\u0004\t\t\u0007C\u0004\u0004\u0016=\u0003\raa\u0006\t\u000f\r]r\n1\u0001\u0004:\u0005QA/[3s\u000b:\f'\r\\3\u0011\u0007}\u001bY$C\u0002\u0004>\u0001\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0004B=\u0003\n\u00111\u0001\u0004D\u0005\u0011R.\u0019=D_6\u0004\u0018m\u0019;j_:d\u0015mZ't!\u0015y&1AAE\u0003\u0015\u001a'/Z1uK2{wOU3uK:$\u0018n\u001c8M_\u001e\u001cuN\u001c4jO\u0012\"WMZ1vYR$C'\u0006\u0002\u0004J)\"11\tB\r\u000319(/\u001b;f%\u0016\u001cwN\u001d3t))\t\u0019pa\u0014\u0004R\rU3\u0011\f\u0005\u00073F\u0003\r!a0\t\u000f\rM\u0013\u000b1\u0001\u0002b\u0005Qa.^7CCR\u001c\u0007.Z:\t\u000f\r]\u0013\u000b1\u0001\u0002b\u0005y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007\u000eC\u0004\u0004\\E\u0003\r!!\u0019\u0002#\t\fGo\u00195fgB+'oU3h[\u0016tG/A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003g\u001c\tga\u0019\t\re\u0013\u0006\u0019AA`\u0011\u001d\u0019)G\u0015a\u0001\u0003C\n!B\\;n%\u0016\u001cwN\u001d3t\u0003\u001di\u0017m[3M_\u001e$baa\u001b\u0004r\rU\u0004cA7\u0004n%\u00191q\u000e-\u0003\u00135+'oZ3e\u0019><\u0007\u0002CB:'B\u0005\t\u0019\u00019\u0002\u0007\u0011L'\u000fC\u0004\u0004xM\u0003\r!!\u000e\u0002\r\r|gNZ5h\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$H%M\u0001\be\u0016\u001cwN\u001d3t)!\u0019yha#\u0004\u0010\u000eM\u0005\u0003BBA\u0007\u000fk!aa!\u000b\t\r\u0015\u0015qA\u0001\u0007e\u0016\u001cwN\u001d3\n\t\r%51\u0011\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\r5U\u000b1\u0001\u0002b\u0005\u00191.Z=\t\u000f\rEU\u000b1\u0001\u0002b\u0005)a/\u00197vK\"91QS+A\u0002\u0005%\u0015!\u0003;j[\u0016\u001cH/Y7q\u000351XM]5gs6+GO]5dgR!\u00111_BN\u0011\u001d\u0019iJ\u0016a\u0001\u0003+\u000bab\u00197fC:,'/T1oC\u001e,'\u000f")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka");
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka");
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir(), (boolean)false);
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Pool<TopicPartition, AbstractLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testCheckCleaningAbortedChecksForFrozenLogStartOffsetState() {
        TopicPartition tp = new TopicPartition("test-topic", 0);
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)mockLog);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        cleanerManager.checkCleaningAborted(tp);
        Object object = cleanerManager.cleaningState(tp).get();
        LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
        Assertions.assertTrue((object != null && object.equals(logCleaningInProgress$) ? 1 : 0) != 0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleanerManager.checkCleaningAborted(tp));
    }

    @Test
    public void testAvoidMaxCompactionDelayCalculationLagMaxValue() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(logSegmentSize));
        logProps.put("retention.ms", "1");
        logProps.put("cleanup.policy", "compact");
        logProps.put("max.compaction.lag.ms", Long.toString(Long.MAX_VALUE));
        LogConfig config = new LogConfig((Map)logProps);
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = 600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Optional leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), ChecksumParams.EMPTY);
        Metrics metrics = new Metrics();
        MockScheduler x$4 = this.time().scheduler;
        MockTime x$5 = this.time();
        ChecksumParams x$13 = ChecksumParams.EMPTY;
        ConcurrentHashMap x$14 = new ConcurrentHashMap();
        boolean x$15 = false;
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)x$4, (Time)x$5, logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, x$14, x$13, x$15).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler, (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, ChecksumParams.EMPTY);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler, (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, tierPartitionState){

            public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
            {
                None$ x$8 = None$.MODULE$;
                TierLogComponents x$11 = TierLogComponents$.MODULE$.EMPTY();
                ChecksumParams x$12 = ChecksumParams.EMPTY;
                None$ x$13 = None$.MODULE$;
                super(localLog$1, 0L, true, metrics$1, leaderEpochCache$1, producerIdExpirationCheckIntervalMs$1, producerStateManager$1, (Option)x$8, true, tierPartitionState$1, x$11, (Option)x$13, x$12);
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertFalse((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testMaxCompactionLagForcesLogClean() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(logSegmentSize));
        logProps.put("cleanup.policy", "compact");
        logProps.put("max.compaction.lag.ms", "10");
        logProps.put("min.cleanable.dirty.ratio", "1.00");
        LogConfig config = new LogConfig((Map)logProps);
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Optional leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), ChecksumParams.EMPTY);
        MockScheduler x$4 = this.time().scheduler;
        MockTime x$5 = this.time();
        ChecksumParams x$13 = ChecksumParams.EMPTY;
        ConcurrentHashMap x$14 = new ConcurrentHashMap();
        boolean x$15 = false;
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)x$4, (Time)x$5, logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, x$14, x$13, x$15).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler, (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, ChecksumParams.EMPTY);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler, (Time)this.time());
        None$ x$23 = None$.MODULE$;
        TierLogComponents x$26 = TierLogComponents$.MODULE$.EMPTY();
        ChecksumParams x$27 = ChecksumParams.EMPTY;
        None$ x$28 = None$.MODULE$;
        MergedLog log = new MergedLog(localLog, 0L, true, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, (Option)x$23, true, tierPartitionState, x$26, (Option)x$28, x$27);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
        this.verifyMetrics(cleanerManager);
        this.time().sleep(11L);
        Assertions.assertTrue((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact", false, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = 600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Optional leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), ChecksumParams.EMPTY);
        MockScheduler x$4 = this.time().scheduler;
        MockTime x$5 = this.time();
        ChecksumParams x$13 = ChecksumParams.EMPTY;
        ConcurrentHashMap x$14 = new ConcurrentHashMap();
        boolean x$15 = false;
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)x$4, (Time)x$5, logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, x$14, x$13, x$15).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler, (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, ChecksumParams.EMPTY);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler, (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, tierPartitionState){

            public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
            {
                None$ x$8 = None$.MODULE$;
                TierLogComponents x$11 = TierLogComponents$.MODULE$.EMPTY();
                ChecksumParams x$12 = ChecksumParams.EMPTY;
                None$ x$13 = None$.MODULE$;
                super(localLog$2, 0L, true, metrics$2, leaderEpochCache$2, producerIdExpirationCheckIntervalMs$2, producerStateManager$2, (Option)x$8, true, tierPartitionState$2, x$11, (Option)x$13, x$12);
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)log, (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogWithTierCompactFeatureEnabled() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.time(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        boolean tierCleanerFeatureEnabled = true;
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, tierCleanerFeatureEnabled, TierPartitionStateCleanupConfig.EMPTY, false, -1), (Option)None$.MODULE$);
        MockScheduler x$5 = this.time().scheduler;
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = this.time();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        None$ x$12 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$19 = None$.MODULE$;
        ChecksumParams x$20 = ChecksumParams.EMPTY;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        MergedLog log = MergedLog$.MODULE$.apply(tpDir, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, (Time)x$8, 300000, x$10, 600000, (Option)x$12, logDirFailureChannel, tierLogComponents, true, (Option)x$16, true, x$18, (Option)x$19, x$21, x$20);
        log.assignTopicId(Uuid.randomUuid(), 1);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        AbstractLog log = this.createLog(2048, "compact", tp, this.logDir());
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        log.maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        AbstractLog log = this.createLog(2048, "compact", tp, this.logDir());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(log.config().segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(log.config().retentionMs));
        logProps.put("cleanup.policy", "compact");
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        logProps.put("cleanup.policy", "delete");
        LogConfig config2 = new LogConfig((Map)logProps);
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCompactedBytesMetric() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log_1 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-1", 0), this.logDir());
        AbstractLog log_2 = this.createLog(records.sizeInBytes() * 5, "compact,delete", new TopicPartition("topic-2", 2), this.logDir());
        AbstractLog log_3 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-2", 5), this.logDir());
        AbstractLog log_4 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-2", 10), this.logDir2());
        AbstractLog log_5 = this.createLog(records.sizeInBytes() * 5, "compact,delete", new TopicPartition("topic-1", 2), this.logDir2());
        AbstractLog log_6 = this.createLog(records.sizeInBytes() * 5, "delete", new TopicPartition("topic-3", 2), this.logDir());
        AbstractLog log_7 = this.createLog(records.sizeInBytes() * 5, "delete", new TopicPartition("topic-4", 2), this.logDir2());
        Set logs = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log_1, log_2, log_3, log_4, log_5, log_6, log_7}));
        IntRef numBatches = IntRef.create((int)5);
        logs.foreach((Function1 & Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$1(this, numBatches, log);
            return BoxedUnit.UNIT;
        });
        this.createCleanerManager((Set<AbstractLog>)logs);
        long logDirSize = log_1.size() + log_2.size() + log_3.size();
        long logDir2Size = log_4.size() + log_5.size();
        Assertions.assertTrue((logDirSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDir2Size > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDirSize != logDir2Size ? 1 : 0) != 0);
        logs.foreach((Function1 & Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$4(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir2().getAbsolutePath()).value()));
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep((long)(compactionLag + 1));
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep((long)(compactionLag + 1));
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(3L);
        this.time().sleep((long)(compactionLag + 1));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, AppendOrigin.COORDINATOR, log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep((long)(compactionLag + 1));
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((AbstractLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    private LogCleanerManager createCleanerManager(AbstractLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManager createCleanerManager(Set<AbstractLog> logs) {
        Pool compactedLogs = new Pool((Option)None$.MODULE$);
        logs.foreach((Function1 & Serializable)log -> (AbstractLog)compactedLogs.put((Object)log.topicPartition(), log));
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), compactedLogs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, AbstractLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private AbstractLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition, File logDir) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy, false, (Option<Object>)None$.MODULE$);
        File partitionDir = new File(logDir, LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$15 = None$.MODULE$;
        ChecksumParams x$17 = ChecksumParams.EMPTY;
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, x$10, x$11, (Option)x$18, x$12, x$13, true, (Option)x$15, true, x$19, (Option)x$20, x$21, x$17);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private File createLog$default$4() {
        return this.logDir();
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy, boolean tierEnable, Option<Object> maxCompactionLagMs) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        logProps.put("confluent.tier.enable", Boolean.toString(tierEnable));
        logProps.put("confluent.tier.cleaner.enable", "true");
        maxCompactionLagMs.foreach((Function1 & Serializable)lag -> logProps.put("max.compaction.lag.ms", Long.toString(BoxesRunTime.unboxToLong((Object)lag))));
        return new LogConfig((Map)logProps);
    }

    private Option<Object> createLowRetentionLogConfig$default$4() {
        return None$.MODULE$;
    }

    private void writeRecords(AbstractLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1(), log.roll$default$2());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(AbstractLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private MergedLog makeLog(File dir, LogConfig config) {
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$13 = None$.MODULE$;
        TierLogComponents x$14 = TierLogComponents$.MODULE$.EMPTY();
        ChecksumParams x$17 = ChecksumParams.EMPTY;
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, x$10, x$11, (Option)x$18, x$12, x$14, true, (Option)x$13, true, x$19, (Option)x$20, x$21, x$17);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private void verifyMetrics(LogCleanerManager cleanerManager) {
        long cleanBytes = cleanerManager.cleanBytesLast().get();
        long cleanableBytes = cleanerManager.cleanableBytesLast().get();
        long uncleanableBytes = cleanerManager.uncleanableBytesLast().get();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)cleanerManager.logs().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)LogCleanerManagerTest.$anonfun$verifyMetrics$1(cleanerManager, x0$1)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)(cleanBytes + cleanableBytes + uncleanableBytes));
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        AbstractLog log = $this.createLog(2048, "compact", tp, $this.logDir());
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$1(LogCleanerManagerTest $this, IntRef numBatches$2, AbstractLog log) {
        $this.writeRecords(log, numBatches$2.elem, 1, 5);
        numBatches$2.elem += 10;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$2(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    private static final Metric getMetric$1(Function1 filter) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$2(filter, x0$1)))).head())._2();
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$3(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        Function1 & Serializable getMetric$1_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$3(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$2(filter, x0$1)))).head())._2());
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$4(AbstractLog log) {
        ((MergedLog)log).computeLogSizeDetails().cancel(true);
        ((MergedLog)log).updateSizeDetails();
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, AbstractLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1(), log$2.roll$default$2());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ long $anonfun$verifyMetrics$1(LogCleanerManager cleanerManager$5, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            if (cleanerManager$5.isUncleanablePartition(log, topicPartition)) {
                return 0L;
            }
            return log.size();
        }
        throw new MatchError(null);
    }

    public LogCleanerManagerTest() {
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("cleanup.policy", "compact");
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

