/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@Tags(value={@Tag(value="bazel:size:large"), @Tag(value="bazel:shard_count:3")})
@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\f\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019A\u0005\u0001)A\u0005y!)\u0011\n\u0001C\u0001\u0015\"9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a\"\u0001\t\u0003\tI\tC\u0004\u0002\u0012\u0002!I!a%\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011q\u001d\u0001\u0005\n\u0005%\bb\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_A\u0011Ba\u0013\u0001#\u0003%IA!\u0014\b\u000b1l\u0002\u0012A7\u0007\u000bqi\u0002\u0012\u00018\t\u000b\u001d\"B\u0011\u0001:\u0007\tM$\u0002\u0001\u001e\u0005\u0007OY!\t!!\u0001\t\u000f\u0005\u001da\u0003\"\u0011\u0002\n\u00191\u0011Q\t\u000b\u0001\u0003\u000fBaaJ\r\u0005\u0002\u0005%\u0003bBA\u00043\u0011\u0005\u0013Q\n\u0002'\u0019><7\t\\3b]\u0016\u0014\b+\u0019:b[\u0016$XM]5{K\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u0010 \u0003\rawn\u001a\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001$!\t!S%D\u0001\u001e\u0013\t1SDA\u0011BEN$(/Y2u\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011A\u0005A\u0001\u0005i&lW-F\u0001-!\tis'D\u0001/\u0015\ty\u0003'\u0001\u0003vi&d'BA\u00193\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001e\r\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029]\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005a\u0004cA\u001fA\u00056\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0003BeJ\f\u0017\u0010\u0005\u0002D\r6\tAI\u0003\u0002Fe\u000511m\\7n_:L!a\u0012#\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000f\u0006\u0002L\u001dB\u0011Q\bT\u0005\u0003\u001bz\u0012A!\u00168ji\")qJ\u0002a\u0001!\u0006)1m\u001c3fGB\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bR\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005U\u0013&aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3)\u0005\u00199\u0006C\u0001-`\u001b\u0005I&B\u0001.\\\u0003\u0019\u0001\u0018M]1ng*\u0011A,X\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqV'A\u0003kk:LG/\u0003\u0002a3\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t\u0019\u0011\u0007.\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kf\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003O\u0012\u0014q\"\u0011:hk6,g\u000e^:T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002UB\u00111N\u0006\b\u0003IM\ta\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u!\t!Cc\u0005\u0002\u0015_B\u0011Q\b]\u0005\u0003cz\u0012a!\u00118z%\u00164G#A7\u0003\u001f\u0005cGnQ8naJ,7o]5p]N\u001c2AF;~!\t180D\u0001x\u0015\tA\u00180\u0001\u0003mC:<'\"\u0001>\u0002\t)\fg/Y\u0005\u0003y^\u0014aa\u00142kK\u000e$\bCA2\u007f\u0013\tyHMA\tBe\u001e,X.\u001a8ugB\u0013xN^5eKJ$\"!a\u0001\u0011\u0007\u0005\u0015a#D\u0001\u0015\u0003A\u0001(o\u001c<jI\u0016\f%oZ;nK:$8\u000f\u0006\u0003\u0002\f\u0005E\u0002\u0007BA\u0007\u0003?\u0001b!a\u0004\u0002\u0018\u0005mQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\rM$(/Z1n\u0015\ty\u00130\u0003\u0003\u0002\u001a\u0005E!AB*ue\u0016\fW\u000e\u0005\u0003\u0002\u001e\u0005}A\u0002\u0001\u0003\f\u0003CA\u0012\u0011!A\u0001\u0006\u0003\t\u0019CA\u0002`IE\nB!!\n\u0002,A\u0019Q(a\n\n\u0007\u0005%bHA\u0004O_RD\u0017N\\4\u0011\u0007\r\fi#C\u0002\u00020\u0011\u0014\u0011\"\u0011:hk6,g\u000e^:\t\u000f\u0005M\u0002\u00041\u0001\u00026\u000591m\u001c8uKb$\b\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\nKb$XM\\:j_:T1!a\u0010\\\u0003\r\t\u0007/[\u0005\u0005\u0003\u0007\nID\u0001\tFqR,gn]5p]\u000e{g\u000e^3yi\nYQ\t_2mk\u0012,'l\u001d;e'\rIR/ \u000b\u0003\u0003\u0017\u00022!!\u0002\u001a)\u0011\ty%!\u00171\t\u0005E\u0013Q\u000b\t\u0007\u0003\u001f\t9\"a\u0015\u0011\t\u0005u\u0011Q\u000b\u0003\f\u0003/Z\u0012\u0011!A\u0001\u0006\u0003\t\u0019CA\u0002`IIBq!a\r\u001c\u0001\u0004\t)$A\u0014uKN$8\t\\3b]N\u001cu.\u001c2j]\u0016$7i\\7qC\u000e$\u0018I\u001c3EK2,G/\u001a+pa&\u001cGcA&\u0002`!)qj\u0002a\u0001!\"\u0012qa\u0016\u0015\u0005\u000f\tD\u0017.\u0001\u0010uKN$8\t\\3b]\u0016\u0014x+\u001b;i\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;WaQ\u00191*!\u001b\t\u000b=C\u0001\u0019\u0001))\u0005!9\u0006&\u0002\u0005cQ\u0006=4EAA9!\tY\u0017$A\u0013uKN$8\t\\3b]&twMT3ti\u0016$W*Z:tC\u001e,7oV5uQZ\u0003\u0014I\u001c3WcQ\u00191*a\u001e\t\u000b=K\u0001\u0019\u0001))\u0005%9\u0006&B\u0005cQ\u0006=\u0014!M2mK\u0006tWM\u001d'pO\u0012+G.\u001a;f\u001b\u0006D8+Z4nK:$8\u000fU3s%Vt7i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u000b\u0004\u0017\u0006\u0005\u0005\"B(\u000b\u0001\u0004\u0001\u0006F\u0001\u0006XQ\u0011Q!\r[5\u0002/\rdW-\u00198fe\u000e{gNZ5h+B$\u0017\r^3UKN$HcA&\u0002\f\")qj\u0003a\u0001!\"\u00121b\u0016\u0015\u0005\u0017\tD\u0017.\u0001\u000flC\u001a\\\u0017mQ8oM&<w+\u001b;i\u00072,\u0017M\\3s\u0007>tg-[4\u0015\t\u0005U\u0015q\u0014\t\u0005\u0003/\u000bY*\u0004\u0002\u0002\u001a*\u0011\u0011gH\u0005\u0005\u0003;\u000bIJA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBAQ\u0019\u0001\u0007\u00111U\u0001\u000eG2,\u0017M\\3s\u0007>tg-[4\u0011\t\u0005\u0015\u0016\u0011W\u0007\u0003\u0003OS1AHAU\u0015\u0011\tY+!,\u0002\u0013%tG/\u001a:oC2\u001c(bAAXe\u000591\u000f^8sC\u001e,\u0017\u0002BAZ\u0003O\u0013Qb\u00117fC:,'oQ8oM&<\u0017\u0001E2iK\u000e\\G*Y:u\u00072,\u0017M\\3e)\u001dY\u0015\u0011XAj\u0003;Dq!a/\u000e\u0001\u0004\ti,A\u0003u_BL7\r\u0005\u0003\u0002@\u00065g\u0002BAa\u0003\u0013\u00042!a1?\u001b\t\t)MC\u0002\u0002H\u0006\na\u0001\u0010:p_Rt\u0014bAAf}\u00051\u0001K]3eK\u001aLA!a4\u0002R\n11\u000b\u001e:j]\u001eT1!a3?\u0011\u001d\t).\u0004a\u0001\u0003/\f1\u0002]1si&$\u0018n\u001c8JIB\u0019Q(!7\n\u0007\u0005mgHA\u0002J]RDq!a8\u000e\u0001\u0004\t\t/\u0001\u0006gSJ\u001cH\u000fR5sif\u00042!PAr\u0013\r\t)O\u0010\u0002\u0005\u0019>tw-\u0001\u000edQ\u0016\u001c7\u000eT8h\u0003\u001a$XM]!qa\u0016tG-\u001b8h\tV\u00048\u000fF\u0004L\u0003W\f\u00190a>\t\ryq\u0001\u0019AAw!\r!\u0013q^\u0005\u0004\u0003cl\"aC!cgR\u0014\u0018m\u0019;M_\u001eDq!!>\u000f\u0001\u0004\t\t/A\u0005ti\u0006\u0014HoU5{K\"9\u0011\u0011 \bA\u0002\u0005m\u0018aB1qa\u0016tGm\u001d\t\u0007\u0003{\u0014\u0019Aa\u0002\u000e\u0005\u0005}(b\u0001B\u0001}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0015\u0011q \u0002\u0004'\u0016\f\b#C\u001f\u0003\n\u0005]\u0017QXAq\u0013\r\u0011YA\u0010\u0002\u0007)V\u0004H.Z\u001a\u0002\u000bQ|W*\u00199\u0015\t\tE!Q\u0004\t\t\u0003{\u0014\u0019\"a6\u0003\u0018%!!QCA\u0000\u0005\ri\u0015\r\u001d\t\b{\te\u0011QXAq\u0013\r\u0011YB\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t}q\u00021\u0001\u0003\"\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0004\u0002~\n\r\"qA\u0005\u0005\u0005K\tyP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\t\t\u0005\"1\u0006\u0005\u0007=A\u0001\r!!<\u00023]\u0014\u0018\u000e^3EkB\u001c8+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u000b\u000f\u0003w\u0014\tD!\u000e\u0003:\tm\"Q\bB!\u0011\u001d\u0011\u0019$\u0005a\u0001\u0003/\fqA\\;n\u0017\u0016L8\u000fC\u0004\u00038E\u0001\r!a6\u0002\u000f9,X\u000eR;qg\"1a$\u0005a\u0001\u0003[DQaT\tA\u0002AC\u0011Ba\u0010\u0012!\u0003\u0005\r!a6\u0002\u0011M$\u0018M\u001d;LKfDqAa\u0011\u0012\u0001\u0004\u0011)%\u0001\u0006nC\u001eL7MV1mk\u0016\u00042!\u0010B$\u0013\r\u0011IE\u0010\u0002\u0005\u0005f$X-A\u0012xe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t=#\u0006BAl\u0005#Z#Aa\u0015\u0011\t\tU#qL\u0007\u0003\u0005/RAA!\u0017\u0003\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005;r\u0014AC1o]>$\u0018\r^5p]&!!\u0011\rB,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0007\u0001\t\u0015\u0004N!\u001c\u0011\t\t\u001d$\u0011N\u0007\u0003\u0003{IAAa\u001b\u0002>\t\u0019A+Y4\"\u0005\t=\u0014\u0001\u00052bu\u0016d'h]5{Kjb\u0017M]4fQ\u0019\u0001!Q\r5\u0003t\u0005\u0012!QO\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(h\r")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType codec) {
        void var4_4;
        void var5_5;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var5_5.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var5_5, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$13 = largeMessageKey + 1;
        byte x$18 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(100, 3, log, codec, x$13, x$18);
        Seq appends2 = (Seq)((IterableOps)appends.$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var4_4, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dups);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), null).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType codec) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        var5_5.localLogSegments().forEach(x$4 -> x$4.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long endOffset = var5_5.logEndOffset();
        var5_5.localLogSegments().forEach(x$5 -> x$5.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$4((AbstractLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion of old segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cleaner().shutdown();
        this.closeLog((AbstractLog)var5_5);
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, codec);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        AbstractLog log2 = (AbstractLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((AbstractLog)var9_11);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)var10_12), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType codec) {
        void var4_4;
        void var5_5;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = CompressionType.NONE.equals(codec) ? var5_5.sizeInBytes() : var5_5.sizeInBytes() + 6;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$82 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$82, x$9, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        int x$18 = this.logConfigProperties$default$6();
        long x$19 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, maxMessageSize, x$15, x$16, x$17, x$18, x$19);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$25 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, x$25, (byte)0);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$31 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(40, 3, log, codec, x$31, (byte)0);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var5_5, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        props.put("message.format.version", MetadataVersion.IBP_0_11_0_IV0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(40, 3, log, codec, 30, (byte)1);
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(5, 3, log, codec, 15, (byte)2);
        Seq appends2 = (Seq)((IterableOps)((IterableOps)((IterableOps)appends.$plus$plus(dupsV0)).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var4_4, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dupsV1)).$plus$plus(dupsV2);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        int maxMessageSize = 192;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        long x$92 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$8, 256, x$92, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$15 = this.logConfigProperties$default$1();
        float x$16 = this.logConfigProperties$default$3();
        long x$17 = this.logConfigProperties$default$4();
        int x$18 = this.logConfigProperties$default$5();
        long x$19 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$15, maxMessageSize, x$16, x$17, x$18, 256, x$19);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$25 = 0;
        Seq appendsV0 = this.writeDupsSingleMessageSet(2, 3, log, codec, x$25, (byte)0);
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 3, (byte)0));
        props.put("message.format.version", MetadataVersion.IBP_0_10_0_IV1.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq appendsV1 = this.writeDupsSingleMessageSet(2, 2, log, codec, 4, (byte)1);
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 4, (byte)1));
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, codec, 6, (byte)1));
        Seq appends = (Seq)appendsV0.$plus$plus((IterableOnce)appendsV1);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest(CompressionType codec) {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()), 1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        long x$8 = this.makeCleaner$default$6();
        int x$9 = this.makeCleaner$default$7();
        int x$10 = this.makeCleaner$default$8();
        long x$11 = this.makeCleaner$default$9();
        Option<Object> x$12 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, 100L, x$7, x$8, x$9, x$10, x$11, x$12, logProps, 0));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.startCleanerAndCheckCompactionProgress$1(log, codec, retentionMs);
        Assertions.assertFalse((log.logStartOffset() == log.logEndOffset() ? 1 : 0) != 0);
        long endOffset = log.logEndOffset();
        this.reconfigureMaxSegmentDeletedPerRun$1(log.numberOfSegments());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$3(log, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion of old segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)log.numberOfSegments());
        this.cleaner().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType codec) {
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var4_4.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, 1L, maxMessageSize, x$7, x$8, x$9, x$10, (Option<Object>)x$4, x$11, x$122));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, 100000, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private KafkaConfig kafkaConfigWithCleanerConfig(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), Integer.toString(cleanerConfig.numThreads));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), Long.toString(cleanerConfig.dedupeBufferSize));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), Double.toString(cleanerConfig.dedupeBufferLoadFactor));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), Integer.toString(cleanerConfig.ioBufferSize));
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(cleanerConfig.maxMessageSize));
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), Long.toString(cleanerConfig.backoffMs));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), Double.toString(cleanerConfig.maxIoBytesPerSecond));
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), Integer.toString(cleanerConfig.logDeletionMaxSegmentsPerRun));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(AbstractLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((IterableOnceOps)messages.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
                String value = (String)x0$1._2();
                long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(AbstractLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)deepLogEntry -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2())));
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, AbstractLog log, CompressionType codec, int startKey, byte magicValue) {
        void withRecords_timestampType;
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$13 -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)x$13)));
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                String payload = (String)x0$1._2();
                return new SimpleRecord(Integer.toString(key).getBytes(), payload.getBytes());
            }
            throw new MatchError(null);
        });
        SimpleRecord[] withRecords_records = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_9 = null;
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (CompressionType)codec, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((IndexedSeqOps)kvs.zip((IterableOnce)offsets)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Tuple2 kv = (Tuple2)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            }
            throw new MatchError(null);
        });
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType codec$1) {
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()), 1));
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, codec$1, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$4(AbstractLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1 && log$1.numberOfSegments() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$5() {
        return "Timed out waiting for deletion of old segments";
    }

    private final void reconfigureMaxSegmentDeletedPerRun$1(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(this.cleaner().currentConfig().numThreads, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, this.cleaner().currentConfig().ioBufferSize, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true, logDeletionMaxSegmentsPerRun, "MD5", false));
        this.cleaner().reconfigure(oldConfig, newConfig);
    }

    private final void startCleanerAndCheckCompactionProgress$1(AbstractLog log$2, CompressionType codec$2, Integer retentionMs$2) {
        this.writeDups(100, 3, log$2, codec$2, this.writeDups$default$5(), this.writeDups$default$6());
        log$2.updateHighWatermark(log$2.logEndOffset());
        log$2.localLogSegments().forEach(x$10 -> x$10.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs$2))));
        long startSize = log$2.size();
        long firstDirty = log$2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = log$2.localLogSegments().stream().mapToInt(x$11 -> x$11.size()).sum();
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$3(AbstractLog log$2, long endOffset$2) {
        return log$2.logStartOffset() == endOffset$2;
    }

    public static final /* synthetic */ String $anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$4() {
        return "Timed out waiting for deletion of old segments";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int x$13) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$14)))), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$14) {
            CompressionType compressionType = x$14;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

