/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\tuf\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013%A\n\u0003\u0004T\u0001\u0001\u0006I!\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019a\u0006\u0001)A\u0005-\"9Q\f\u0001b\u0001\n\u0013q\u0006B\u00026\u0001A\u0003%q\fC\u0004l\u0001\t\u0007I\u0011\u00027\t\rU\u0004\u0001\u0015!\u0003n\u0011\u001d1\bA1A\u0005\n1Daa\u001e\u0001!\u0002\u0013i\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003{\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\f\u0001\t\u0003\t\t\u0002C\u0004\u0002:\u0001!\t!!\u0005\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002\u0012!9\u0011\u0011\b\u0001\u0005\u0002\u0005\u001dcABA)\u0001\u0011\t\u0019\u0006C\u0005='\t\u0005\t\u0015!\u0003\u0002L!Q\u0011qN\n\u0003\u0002\u0003\u0006I!!\u001d\t\r\u001d\u001bB\u0011AA<\u0011%\t\ti\u0005b\u0001\n\u0003\t\u0019\t\u0003\u0005\u0003LM\u0001\u000b\u0011BAC\u0011\u001d\u0011ie\u0005C!\u0003#1aAa\u0014\u0001\t\tE\u0003\"\u0003\u001f\u001b\u0005\u0003\u0005\u000b\u0011BA&\u0011)\tyG\u0007B\u0001B\u0003%\u0011Q\u0018\u0005\u0007\u000fj!\tAa\u0015\t\u000f\t5#\u0004\"\u0011\u0002\u0012!9!1\f\u0001\u0005\n\tu\u0003\"\u0003B:\u0001E\u0005I\u0011\u0002B;\u0011\u001d\u0011I\b\u0001C\u0005\u0005w2a!a&\u0001\t\u0006e\u0005BCA]E\tU\r\u0011\"\u0001\u0002<\"Q\u00111\u0019\u0012\u0003\u0012\u0003\u0006I!!0\t\u0015\u0005\u0015'E!f\u0001\n\u0003\t9\r\u0003\u0006\u0002J\n\u0012\t\u0012)A\u0005\u0003cBaa\u0012\u0012\u0005\u0002\u0005-\u0007bBAiE\u0011\u0005\u00131\u001b\u0005\n\u0003K\u0014\u0013\u0011!C\u0001\u0003OD\u0011\"!<##\u0003%\t!a<\t\u0013\t\u0015!%%A\u0005\u0002\t\u001d\u0001\"\u0003B\u0006E\u0005\u0005I\u0011\tB\u0007\u0011%\u0011\u0019BIA\u0001\n\u0003\t9\rC\u0005\u0003\u0016\t\n\t\u0011\"\u0001\u0003\u0018!I!1\u0005\u0012\u0002\u0002\u0013\u0005#Q\u0005\u0005\n\u0005_\u0011\u0013\u0011!C\u0001\u0005cA\u0011Ba\u000f#\u0003\u0003%\tE!\u0010\t\u0013\t\u0005#%!A\u0005B\t\r\u0003\"\u0003B#E\u0005\u0005I\u0011\tB$\u000f%\u00119\tAA\u0001\u0012\u0013\u0011IIB\u0005\u0002\u0018\u0002\t\t\u0011#\u0003\u0003\f\"1q)\u000eC\u0001\u0005;C\u0011\"!56\u0003\u0003%)Ea(\t\u0013\t\u0005V'!A\u0005\u0002\n\r\u0006\"\u0003BUk\u0005\u0005I\u0011\u0011BV\u0005IaunZ\"p]\u000e,(O]3oGf$Vm\u001d;\u000b\u0005qj\u0014a\u00017pO*\ta(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013B\u0011!\nA\u0007\u0002w\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+P\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005I{%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0007e\u0006tGm\\7\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!W\"\u0002\tU$\u0018\u000e\\\u0005\u00037b\u0013aAU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\ng\u000eDW\rZ;mKJ,\u0012a\u0018\t\u0003A\"l\u0011!\u0019\u0006\u00033\nT!\u0001U2\u000b\u0005y\"'BA3g\u0003\u0019\t\u0007/Y2iK*\tq-A\u0002pe\u001eL!![1\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\rQl\u0007\u000fR5s+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\tIwNC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u00039\u0019\u0007.Z2lgVl\u0007+\u0019:b[N,\u0012A\u001f\t\u0004w\u0006%Q\"\u0001?\u000b\u0005ut\u0018\u0001C2iK\u000e\\7/^7\u000b\u0007}\f\t!A\u0004ti>\u0014\u0018mZ3\u000b\u0007y\n\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C2p]\u001adW/\u001a8u\u0015\u0005\u0001\u0018bAA\u0006y\nq1\t[3dWN,X\u000eU1sC6\u001c\u0018aD2iK\u000e\\7/^7QCJ\fWn\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005M\u0001c\u0001\"\u0002\u0016%\u0019\u0011qC\"\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u001d\u0005m\u0001\u0003BA\u000f\u0003Wi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0004CBL'\u0002BA\u0013\u0003O\tqA[;qSR,'OC\u0002\u0002*\u0019\fQA[;oSRLA!!\f\u0002 \tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011MDW\u000f\u001e3po:D3aDA\u001a!\u0011\ti\"!\u000e\n\t\u0005]\u0012q\u0004\u0002\n\u0003\u001a$XM]#bG\"\fa\u0004^3tiVs7m\\7nSR$X\r\u001a#bi\u0006tu\u000e^\"p]N,X.\u001a3)\u0007A\ti\u0004\u0005\u0003\u0002\u001e\u0005}\u0012\u0002BA!\u0003?\u0011A\u0001V3ti\u0006\u0011D/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a$sKF,XM\u001c;TK\u001elWM\u001c;S_2d7\u000fK\u0002\u0012\u0003{!B!a\u0005\u0002J!1AH\u0005a\u0001\u0003\u0017\u00022ASA'\u0013\r\tye\u000f\u0002\f\u0003\n\u001cHO]1di2{wM\u0001\u0007D_:\u001cX/\\3s)\u0006\u001c8nE\u0003\u0014\u0003+\n\t\u0007\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY&]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002`\u0005e#AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002d\u0005-\u00141C\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005e\u000b\u0018\u0002BA7\u0003K\u0012\u0001bQ1mY\u0006\u0014G.Z\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bc\u0001\"\u0002t%\u0019\u0011QO\"\u0003\u0007%sG\u000f\u0006\u0004\u0002z\u0005u\u0014q\u0010\t\u0004\u0003w\u001aR\"\u0001\u0001\t\rq2\u0002\u0019AA&\u0011\u001d\tyG\u0006a\u0001\u0003c\nqbY8ogVlW\r\u001a\"bi\u000eDWm]\u000b\u0003\u0003\u000b\u0003b!a\"\u0002\u0012\u0006UUBAAE\u0015\u0011\tY)!$\u0002\u000f5,H/\u00192mK*\u0019\u0011qR\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u0006%%A\u0003'jgR\u0014UO\u001a4feB\u0019\u00111\u0010\u0012\u0003\u0019\u0019+Go\u00195fI\n\u000bGo\u00195\u0014\r\t\n\u00151TAQ!\r\u0011\u0015QT\u0005\u0004\u0003?\u001b%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003G\u000b\u0019L\u0004\u0003\u0002&\u0006=f\u0002BAT\u0003[k!!!+\u000b\u0007\u0005-v(\u0001\u0004=e>|GOP\u0005\u0002\t&\u0019\u0011\u0011W\"\u0002\u000fA\f7m[1hK&!\u0011QWA\\\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\tlQ\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$XCAA_!\r\u0011\u0015qX\u0005\u0004\u0003\u0003\u001c%\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005)Q\r]8dQV\u0011\u0011\u0011O\u0001\u0007KB|7\r\u001b\u0011\u0015\r\u0005U\u0015QZAh\u0011\u001d\tIl\na\u0001\u0003{Cq!!2(\u0001\u0004\t\t(\u0001\u0005u_N#(/\u001b8h)\t\t)\u000e\u0005\u0003\u0002X\u0006}g\u0002BAm\u00037\u00042!a*D\u0013\r\tinQ\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00181\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u7)\u0001\u0003d_BLHCBAK\u0003S\fY\u000fC\u0005\u0002:&\u0002\n\u00111\u0001\u0002>\"I\u0011QY\u0015\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tP\u000b\u0003\u0002>\u0006M8FAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}8)\u0001\u0006b]:|G/\u0019;j_:LAAa\u0001\u0002z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0002\u0016\u0005\u0003c\n\u00190A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u001f\u0001B!a\u0016\u0003\u0012%!\u0011\u0011]A-\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0007\u0003 A\u0019!Ia\u0007\n\u0007\tu1IA\u0002B]fD\u0011B!\t/\u0003\u0003\u0005\r!!\u001d\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0003\u0005\u0004\u0003*\t-\"\u0011D\u0007\u0003\u0003\u001bKAA!\f\u0002\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019D!\u000f\u0011\u0007\t\u0013)$C\u0002\u00038\r\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003\"A\n\t\u00111\u0001\u0003\u001a\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011yAa\u0010\t\u0013\t\u0005\u0012'!AA\u0002\u0005E\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0014AB3rk\u0006d7\u000f\u0006\u0003\u00034\t%\u0003\"\u0003B\u0011g\u0005\u0005\t\u0019\u0001B\r\u0003A\u0019wN\\:v[\u0016$')\u0019;dQ\u0016\u001c\b%\u0001\u0003dC2d'!\u0004'pO\u0006\u0003\b/\u001a8e)\u0006\u001c8nE\u0003\u001b\u0003+\n\t\u0007\u0006\u0004\u0003V\t]#\u0011\f\t\u0004\u0003wR\u0002B\u0002\u001f\u001e\u0001\u0004\tY\u0005C\u0004\u0002pu\u0001\r!!0\u0002\u0013\r\u0014X-\u0019;f\u0019><G\u0003BA&\u0005?B\u0011B!\u0019 !\u0003\u0005\rAa\u0019\u0002\r\r|gNZ5h!\u0011\u0011)Ga\u001c\u000e\u0005\t\u001d$b\u0001\u001f\u0003j)!!1\u000eB7\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\u0000G&!!\u0011\u000fB4\u0005%aunZ\"p]\u001aLw-A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003x)\"!1MAz\u0003Q1\u0018\r\\5eCR,7i\u001c8tk6,G\rR1uCR1\u00111\u0003B?\u0005\u007fBa\u0001P\u0011A\u0002\u0005-\u0003bBAAC\u0001\u0007!\u0011\u0011\t\u0007\u0003G\u0013\u0019)!&\n\t\t\u0015\u0015q\u0017\u0002\t\u0013R,'/\u00192mK\u0006aa)\u001a;dQ\u0016$')\u0019;dQB\u0019\u00111P\u001b\u0014\u000bU\u0012iI!'\u0011\u0015\t=%QSA_\u0003c\n)*\u0004\u0002\u0003\u0012*\u0019!1S\"\u0002\u000fI,h\u000e^5nK&!!q\u0013BI\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0004]\nm\u0015bAA[_R\u0011!\u0011\u0012\u000b\u0003\u0005\u001f\tQ!\u00199qYf$b!!&\u0003&\n\u001d\u0006bBA]q\u0001\u0007\u0011Q\u0018\u0005\b\u0003\u000bD\u0004\u0019AA9\u0003\u001d)h.\u00199qYf$BA!,\u0003:B)!Ia,\u00034&\u0019!\u0011W\"\u0003\r=\u0003H/[8o!\u001d\u0011%QWA_\u0003cJ1Aa.D\u0005\u0019!V\u000f\u001d7fe!I!1X\u001d\u0002\u0002\u0003\u0007\u0011QS\u0001\u0004q\u0012\u0002\u0004")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.tmpDir(), "kafka");
    private final ChecksumParams checksumParams = TestUtils$.MODULE$.createChecksumParams();

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    private ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps);
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(AbstractLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private AbstractLog createLog(LogConfig config) {
        File x$1 = this.logDir();
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Metrics x$7 = new Metrics();
        Time x$8 = Time.SYSTEM;
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$14 = None$.MODULE$;
        ChecksumParams x$17 = this.checksumParams();
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(x$1, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, x$8, 300000, x$10, x$11, (Option)x$18, x$12, x$13, true, (Option)x$14, true, x$19, (Option)x$20, x$21, x$17);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties());
    }

    private void validateConsumedData(AbstractLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.localLogSegments().forEach(segment -> segment.log().batches().forEach(batch -> {
            if (iter.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
                }
            }
        }));
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.readLocal((long)fetchOffset.elem, (int)1, (FetchIsolation)FetchIsolation.HIGH_WATERMARK, (boolean)true).records.batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, AbstractLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer())) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (this.baseOffset() != fetchedBatch.baseOffset() || this.epoch() != fetchedBatch.epoch() || !fetchedBatch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset;
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5(), this.log.appendAsLeader$default$6());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = 2;
                        CompressionType x$5 = CompressionType.NONE;
                        long x$6 = -1L;
                        short x$7 = -1;
                        int x$8 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, AbstractLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

