/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005\u0002UBQA\u0012\u0001\u0005\u0002UBQ\u0001\u0013\u0001\u0005\u0002UBQA\u0013\u0001\u0005\u0002UBQ\u0001\u0014\u0001\u0005\u0002UBQA\u0014\u0001\u0005\u0002UBQ\u0001\u0015\u0001\u0005\u0002UBQA\u0015\u0001\u0005\u0002UBQ\u0001\u0016\u0001\u0005\u0002UBQA\u0016\u0001\u0005\u0002UBQ\u0001\u0017\u0001\u0005\u0002UBQA\u0017\u0001\u0005\u0002UBQ\u0001\u0018\u0001\u0005\u0002UBQA\u0018\u0001\u0005\u0002UBQ\u0001\u0019\u0001\u0005\u0002UBQA\u0019\u0001\u0005\u0002UBQ\u0001\u001a\u0001\u0005\n\u0015DQA\u001e\u0001\u0005\n]DQa \u0001\u0005\u0002UBa!a\u0001\u0001\t\u0003)\u0004BBA\u0004\u0001\u0011\u0005Q\u0007\u0003\u0004\u0002\f\u0001!\t!\u000e\u0005\u0007\u0003\u001f\u0001A\u0011A\u001b\t\r\u0005M\u0001\u0001\"\u00016\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aa!!\u0014\u0001\t\u0003)\u0004bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t9\n\u0001C\u0001\u00033Cq!a*\u0001\t\u0003\tI\u000b\u0003\u0004\u00028\u0002!\t!\u000e\u0005\b\u0003w\u0003A\u0011AA_\u0011\u0019\tI\u000f\u0001C\u0001k\tiAj\\4D_:4\u0017n\u001a+fgRT!!\n\u0014\u0002\u00071|wMC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u00024\u00015\tA%A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u00051\u0004CA\u00168\u0013\tADF\u0001\u0003V]&$\bF\u0001\u0002;!\tYD)D\u0001=\u0015\tid(A\u0002ba&T!a\u0010!\u0002\u000f),\b/\u001b;fe*\u0011\u0011IQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015c$\u0001\u0002+fgR\fa\u0003^3ti.\u000bgm[1D_:4\u0017n\u001a+p!J|\u0007o\u001d\u0015\u0003\u0007i\n!\u0007^3ti\u0016s\u0017M\u00197f'\u000eDW-\\1WC2LG-\u0019;j_:<\u0016\u000e\u001e5pkR\u001c6\r[3nCJ+w-[:uef,&\u000f\u001c\u0015\u0003\ti\nq\u0006^3ti\u0016s\u0017M\u00197f'\u000eDW-\\1WC2LG-\u0019;j_:<\u0016\u000e\u001e5TG\",W.\u0019*fO&\u001cHO]=Ve2D#!\u0002\u001e\u0002cQ,7\u000f^#oC\ndWmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8XSRDw.\u001e;J]R,'oY3qi>\u00148\t\\1tg\"\u0012aAO\u00015i\u0016\u001cH/\u00128bE2,7k\u00195f[\u00064\u0016\r\\5eCRLwN\\,ji\"\u001cUo\u001d;p[&sG/\u001a:dKB$xN]\"mCN\u001c\bFA\u0004;\u0003I!Xm\u001d;Ge>l\u0007K]8qg\u0016k\u0007\u000f^=)\u0005!Q\u0014\u0001\u0006;fgR4%o\\7Qe>\u00048/\u00138wC2LG\r\u000b\u0002\nu\u0005qB/Z:u\u0013:4\u0018\r\\5e\u0007>l\u0007/Y2uS>tG*Y4D_:4\u0017n\u001a\u0015\u0003\u0015i\nQe\u001d5pk2$g+\u00197jI\u0006$X\r\u00165s_R$H.\u001a3SKBd\u0017nY1t\u0007>tg-[4)\u0005-Q\u0014a\u0004;fgR$v\u000e\u0013;nYR\u000b'\r\\3)\u00051Q\u0014A\u0003;fgR$v\u000e\u0013;nY\"\u0012QBO\u0001\u0012i\u0016\u001cH\u000fV8F]JL7\r[3e%N$\bF\u0001\b;\u0003%!Xm\u001d;U_J\u001bH\u000f\u000b\u0002\u0010u\u0005\u0011B/Z:u\u000f\u0016$8i\u001c8gS\u001e4\u0016\r\\;fQ\t\u0001\"(A\u0013uKN$xJ^3se&$G-\u001a8D_:4\u0017nZ:Bg2{wmZ1cY\u0016\u001cFO]5oO\"\u0012\u0011CO\u0001\bSN4\u0016\r\\5e)\t1\u0017\u000e\u0005\u0002,O&\u0011\u0001\u000e\f\u0002\b\u0005>|G.Z1o\u0011\u0015Q'\u00031\u0001l\u0003-\u0019wN\u001c4jOZ\u000bG.^3\u0011\u00051\u001chBA7r!\tqG&D\u0001p\u0015\t\u0001\b&\u0001\u0004=e>|GOP\u0005\u0003e2\na\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!\u000fL\u0001\u0016CN\u001cXM\u001d;Qe>\u0004XM\u001d;z\u0013:4\u0018\r\\5e)\r1\u0004P\u001f\u0005\u0006sN\u0001\ra[\u0001\u0005]\u0006lW\rC\u0003|'\u0001\u0007A0\u0001\u0004wC2,Xm\u001d\t\u0004WuT\u0013B\u0001@-\u0005)a$/\u001a9fCR,GMP\u0001\"i\u0016\u001cH\u000fT8dC2dun\u001a*fi\u0016tG/[8o\t\u0016\u0014\u0018N^3e!J|\u0007o\u001d\u0015\u0003)i\n\u0001\u0006^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000eR3sSZ,G\rR3gCVdG\u000f\u0015:paND#!\u0006\u001e\u00025Q,7\u000f\u001e'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:)\u0005YQ\u0014!\t;fgRLeN^1mS\u0012dunY1m\u0019><'+\u001a;f]RLwN\u001c)s_B\u001c\bFA\f;\u0003i!Xm\u001d;Qe\u00164WM\u001d+jKJ4U\r^2i\u001bN\u0004&o\u001c9tQ\tA\"(\u0001\tuKN$X*\u0019=TK\u001elWM\u001c;Ng\"\u0012\u0011DO\u0001$I>$Vm\u001d;J]Z\fG.\u001b3M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:\u0004&o\u001c9t))\tY\"!\r\u0002<\u0005\u0015\u0013\u0011\n\t\u0005\u0003;\ti#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0019\u0019wN\u001c4jO*!\u0011QEA\u0014\u0003\u0019\u0019w.\\7p]*\u0019q%!\u000b\u000b\u0007\u0005-\")\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003_\tyBA\bD_:4\u0017nZ#yG\u0016\u0004H/[8o\u0011\u001d\t\u0019D\u0007a\u0001\u0003k\t\u0001\u0003\\8dC2\u0014V\r^3oi&|g.T:\u0011\u0007-\n9$C\u0002\u0002:1\u0012A\u0001T8oO\"9\u0011Q\b\u000eA\u0002\u0005}\u0012a\u00057pG\u0006d'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\bcA\u0016\u0002B%\u0019\u00111\t\u0017\u0003\u0007%sG\u000fC\u0004\u0002Hi\u0001\r!a\u0010\u0002\u001dI,G/\u001a8uS>t')\u001f;fg\"9\u00111\n\u000eA\u0002\u0005U\u0012a\u0003:fi\u0016tG/[8o\u001bN\f!\u0006^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e\u001cFo\u001c:bO\u0016|enQ8na\u0006\u001cG/\u001a3U_BL7\rK\u0002\u001c\u0003#\u00022aOA*\u0013\r\t)\u0006\u0010\u0002\t\t&\u001c\u0018M\u00197fI\"\u00121DO\u0001\u001bi\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-\u001a\u000b\u0004m\u0005u\u0003BBA09\u0001\u0007a-A\ftsN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fI\"2A$a\u0019z\u0003_\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003Sr\u0014A\u00029be\u0006l7/\u0003\u0003\u0002n\u0005\u001d$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0012\u0011\u0011O\u0001=i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-\u001a\u0011xSRD\u0007e]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u001d\u0003k\n\t)a!\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sRA!a\u001f\u0002h\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002\u0000\u0005e$a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0003\u0003\u000bK\u0012\u0001A\u0001*i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0013:4\u0018\r\\5e%\u0016$XM\u001c;j_:$\u0016.\\3\u0015\u0007Y\nY\t\u0003\u0004\u0002`u\u0001\rA\u001a\u0015\u0007;\u0005\r\u00140a$\"\u0005\u0005E\u0015a\u0013;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rI<ji\"\u00043/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\bfB\u000f\u0002v\u0005\u0005\u0015Q\u0013\u0017\u0003\u0003\u000b\u000b\u0011\u0006^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8TSj,Gc\u0001\u001c\u0002\u001c\"1\u0011q\f\u0010A\u0002\u0019DcAHA2s\u0006}\u0015EAAQ\u0003-#Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"LeN^1mS\u0012\u0014V\r^3oi&|gnU5{K\u0002:\u0018\u000e\u001e5!gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012T\u0004e\u001f\u0019~Q\u001dq\u0012QOAA\u0003Kc#!!\"\u00029Q,7\u000f\u001e,bY&$\u0017\r^3Ce>\\WM\u001d'pO\u000e{gNZ5hgR\u0019a'a+\t\r\u0005}s\u00041\u0001gQ\u0019y\u00121M=\u00020\u0006\u0012\u0011\u0011W\u0001?i\u0016\u001cHOV1mS\u0012\fG/\u001a\"s_.,'\u000fT8h\u0007>tg-[4tA]LG\u000f\u001b\u0011tsN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIj\u00023\u0010M?)\u000f}\t)(!!\u000262\u0012\u0011QQ\u0001-i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9CK\u001a|'/Z'bq6\u001bXk]3t\t\u0016\u0004(/Z2bi\u0016$7i\u001c8gS\u001eD#\u0001\t\u001e\u0002%Q,7\u000f\u001e,bY&$Gk\u001c9jGRK\b/\u001a\u000b\u0006m\u0005}\u00161\u0019\u0005\u0007\u0003\u0003\f\u0003\u0019\u00014\u0002/%\u001c\b+\u0019:uSRLwN\\$s_V\u0004XI\\1cY\u0016$\u0007BBAcC\u0001\u0007a-A\u000bjg:{W.\u001b8bY\u001e\u0013x.\u001e9F]\u0006\u0014G.\u001a3)\r\u0005\n\u0019'_AeC\t\tY-\u0001,uKN$Hk\u001c9jGRK\b/\u001a\u0011xSRD\u0007%[:QCJ$\u0018\u000e^5p]\u001e\u0013x.\u001e9F]\u0006\u0014G.\u001a3;Am\u0004T\u0010I1oI\u0002J7OT8nS:\fG\u000eV8qS\u000e\u001c%/Z1uS>tWI\\1cY\u0016$'\bI>2{\":\u0011%a4\u0002V\u0006]\u0007\u0003BA<\u0003#LA!a5\u0002z\tI1i\u001d<T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\t\u00033\fi.!9\u0002f\u0006\u0012\u00111\\\u0001\fM\u0006d7/\u001a\u0017gC2\u001cX-\t\u0002\u0002`\u0006Ya-\u00197tK2\u0002CO];fC\t\t\u0019/A\u0006ueV,G\u0006\t4bYN,\u0017EAAt\u0003)!(/^3-AQ\u0014X/Z\u0001+i\u0016\u001cHOV1mS\u0012\fG/Z,ji\"lU\r^1eCR\fg+\u001a:tS>t'JY8e'V\u0004\bo\u001c:uQ\t\u0011#\b")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(LogConfig.configNames()).asScala().filter((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "960");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testEnableSchemaValidationWithoutSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            logProps.put(cfg, "true");
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> new LogConfig(logProps).instantiateInterceptors(Optional.empty(), Optional.empty()));
        });
    }

    @Test
    public void testEnableSchemaValidationWithSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithoutInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        logProps.remove("confluent.schema.validator.interceptor.class");
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithCustomInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.validator.interceptor.class", "non.existing.interceptor");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p);
        Assertions.assertEquals((Object)new LogConfig((Map)new Properties()), (Object)config);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(config.values()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$testFromPropsEmpty$1(x$1))));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get("confluent.value.subject.name.strategy"));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get("confluent.key.subject.name.strategy"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            switch (name == null ? 0 : name.hashCode()) {
                case -2117707887: {
                    if (!"confluent.tier.local.hotset.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -2092945296: {
                    if (!"confluent.tier.cleaner.min.cleanable.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -1351059593: {
                    if (!"confluent.tier.cleaner.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case -1339220362: {
                    if (!"retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -1272818176: {
                    if (!"confluent.tier.segment.hotset.roll.min.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -1238246365: {
                    if (!"confluent.compacted.topic.prefer.tier.fetch.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -772457061: {
                    if (!"retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -555256924: {
                    if (!"confluent.tier.cleaner.compact.min.efficiency".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -554982824: {
                    if (!"confluent.prefer.tier.fetch.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -537988164: {
                    if (!"cleanup.policy".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                    return;
                }
                case -497316924: {
                    if (!"confluent.append.record.interceptor.classes".equals(name)) break;
                    return;
                }
                case -151975715: {
                    if (!"confluent.placement.constraints".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"json only", "null"}));
                    return;
                }
                case -119762923: {
                    if (!"confluent.key.subject.name.strategy".equals(name)) break;
                    return;
                }
                case -6022648: {
                    if (!"min.cleanable.dirty.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 67637273: {
                    if (!"local.retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 268940301: {
                    if (!"min.insync.replicas".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                    return;
                }
                case 297509630: {
                    if (!"remote.storage.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 632472856: {
                    if (!"local.retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 674282919: {
                    if (!"confluent.value.subject.name.strategy".equals(name)) break;
                    return;
                }
                case 1016887921: {
                    if (!"unclean.leader.election.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    return;
                }
                case 1125464128: {
                    if (!"confluent.tier.local.hotset.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 1698068565: {
                    if (!"confluent.tier.cleaner.compact.segment.min.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case 1709573955: {
                    if (!"confluent.tier.cleaner.dual.compaction".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 2114610856: {
                    if (!"message.format.version".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{""}));
                    return;
                }
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        kafkaProps.put("confluent.ssl.keystore.password", "akeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        topicOverrides.setProperty("confluent.ssl.truststore.password", "sometrustpasswrd");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{confluent.ssl.truststore.password=(redacted), min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    @Test
    public void testPreferTierFetchMsProps() {
        Properties props = new Properties();
        props.put("confluent.prefer.tier.fetch.ms", "100");
        props.put("confluent.compacted.topic.prefer.tier.fetch.ms", "200");
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)100L, (long)logConfig.confluentLogConfig().preferTierFetchMs);
        props.put("cleanup.policy", "compact");
        LogConfig logConfig2 = new LogConfig((Map)props);
        Assertions.assertEquals((long)200L, (long)logConfig2.confluentLogConfig().preferTierFetchMs);
    }

    @Test
    public void testMaxSegmentMs() {
        Properties props1 = new Properties();
        props1.put("segment.ms", "100");
        LogConfig logConfig1 = new LogConfig((Map)props1);
        Assertions.assertEquals((long)100L, (long)logConfig1.maxSegmentMs());
        Properties props2 = new Properties();
        props2.put("segment.ms", "100");
        props2.put("confluent.min.segment.ms", "200");
        LogConfig logConfig2 = new LogConfig((Map)props2);
        Assertions.assertEquals((long)200L, (long)logConfig2.maxSegmentMs());
        Properties props3 = new Properties();
        props3.put("segment.ms", "300");
        props3.put("confluent.min.segment.ms", "200");
        LogConfig logConfig3 = new LogConfig((Map)props3);
        Assertions.assertEquals((long)300L, (long)logConfig3.maxSegmentMs());
        Properties props4 = new Properties();
        props4.put("segment.ms", "300");
        props4.put("confluent.max.segment.ms", "200");
        LogConfig logConfig4 = new LogConfig((Map)props4);
        Assertions.assertEquals((long)200L, (long)logConfig4.maxSegmentMs());
        Properties props5 = new Properties();
        props5.put("segment.ms", "300");
        props5.put("confluent.min.segment.ms", "200");
        props5.put("confluent.max.segment.ms", "400");
        LogConfig logConfig5 = new LogConfig((Map)props5);
        Assertions.assertEquals((long)300L, (long)logConfig5.maxSegmentMs());
        Properties props6 = new Properties();
        props6.put("segment.ms", "300");
        props6.put("confluent.min.segment.ms", "300");
        props6.put("confluent.max.segment.ms", "300");
        LogConfig logConfig6 = new LogConfig((Map)props6);
        Assertions.assertEquals((long)300L, (long)logConfig6.maxSegmentMs());
        Properties props7 = new Properties();
        props7.put("cleanup.policy", "compact");
        props7.put("max.compaction.lag.ms", "100");
        props7.put("confluent.min.segment.ms", "200");
        props7.put("segment.ms", "300");
        LogConfig logConfig7 = new LogConfig((Map)props7);
        Assertions.assertEquals((long)200L, (long)logConfig7.maxSegmentMs());
        Properties props8 = new Properties();
        props8.put("cleanup.policy", "compact");
        props8.put("confluent.min.segment.ms", "100");
        props8.put("max.compaction.lag.ms", "200");
        props8.put("segment.ms", "300");
        LogConfig logConfig8 = new LogConfig((Map)props8);
        Assertions.assertEquals((long)200L, (long)logConfig8.maxSegmentMs());
        Properties props9 = new Properties();
        props9.put("cleanup.policy", "compact");
        props9.put("confluent.min.segment.ms", "100");
        props9.put("segment.ms", "200");
        props9.put("max.compaction.lag.ms", "300");
        LogConfig logConfig9 = new LogConfig((Map)props9);
        Assertions.assertEquals((long)200L, (long)logConfig9.maxSegmentMs());
        Properties props10 = new Properties();
        props10.put("cleanup.policy", "compact");
        props10.put("confluent.min.segment.ms", "100");
        props10.put("confluent.max.segment.ms", "200");
        props10.put("max.compaction.lag.ms", "300");
        props10.put("segment.ms", "400");
        LogConfig logConfig10 = new LogConfig((Map)props10);
        Assertions.assertEquals((long)200L, (long)logConfig10.maxSegmentMs());
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
    }

    @Disabled
    @Test
    public void testEnableRemoteLogStorageOnCompactedTopic() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @Test
    public void testTimestampBeforeMaxMsUsesDeprecatedConfig() {
        long oneDayInMillis = 86400000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampBeforeMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampAfterMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), Long.toString(oneDayInMillis));
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.before.max.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.after.max.ms"));
    }

    @ParameterizedTest(name="testTopicType with isPartitionGroupEnabled: {0} and isNominalTopicCreationEnabled: {1}")
    @CsvSource(value={"false,false", "false, true", "true, false", "true, true"})
    public void testValidTopicType(boolean isPartitionGroupEnabled, boolean isNominalGroupEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put(KafkaConfig$.MODULE$.K2TopicCreationEnabledProp(), Boolean.toString(isPartitionGroupEnabled));
        props.put(KafkaConfig$.MODULE$.NominalTopicCreationEnabledProp(), Boolean.toString(isNominalGroupEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
        logProps.put("confluent.topic.type", TopicType.STANDARD.name());
        ConfigException message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        Assertions.assertEquals((Object)new StringBuilder(20).append("Unknown topic type: ").append(TopicType.STANDARD.name()).toString(), (Object)message.getMessage());
        logProps.put("confluent.topic.type", TopicType.STANDARD.logConfigValue());
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
        logProps.put("confluent.topic.type", TopicType.K2.logConfigValue());
        if (Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled())) {
            LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
        } else {
            message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
            Assertions.assertEquals((Object)"Topic type k2 is not supported", (Object)message.getMessage());
        }
        logProps.put("confluent.topic.type", TopicType.K2.name());
        message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        Assertions.assertEquals((Object)new StringBuilder(20).append("Unknown topic type: ").append(TopicType.K2.name()).toString(), (Object)message.getMessage());
        logProps.put("confluent.topic.type", TopicType.NOMINAL.logConfigValue());
        if (Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())) {
            LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled()));
        } else {
            message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
            Assertions.assertEquals((Object)"Topic type nominal is not supported", (Object)message.getMessage());
        }
        logProps.put("confluent.topic.type", TopicType.NOMINAL.name());
        message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        Assertions.assertEquals((Object)new StringBuilder(20).append("Unknown topic type: ").append(TopicType.NOMINAL.name()).toString(), (Object)message.getMessage());
        String invalidTopicType = "invalid-topic-type";
        logProps.put("confluent.topic.type", invalidTopicType);
        message = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isK2TopicCreationEnabled()), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isNominalTopicCreationEnabled())));
        Assertions.assertEquals((Object)new StringBuilder(20).append("Unknown topic type: ").append(invalidTopicType).toString(), (Object)message.getMessage());
    }

    @Test
    public void testValidateWithMetadataVersionJbodSupport() {
        LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, true));
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, true);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(Map logProps$2, String cfg) {
        logProps$2.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$2).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(Map logProps$3, String cfg) {
        logProps$3.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$3).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(Map logProps$4, String cfg) {
        logProps$4.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$4).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class non.existing.interceptor cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testFromPropsEmpty$1(Tuple2 x$1) {
        return x$1._2() == null;
    }

    private static final void validate$1(MetadataVersion metadataVersion, boolean jbodConfig) {
        int x$3 = jbodConfig ? 2 : 1;
        boolean x$4 = true;
        boolean x$5 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var21_5 = null;
        int x$6 = createBrokerConfig$default$5_this.RandomPort();
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = true;
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$12 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var23_15 = null;
        int x$14 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$15 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var24_18 = null;
        int x$16 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$17 = None$.MODULE$;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, null, x$4, x$5, x$6, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<String>)x$17, x$3, x$18, x$19, x$20, x$21)).validateWithMetadataVersion(metadataVersion);
    }
}

