/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import kafka.log.LogTestUtils$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004^\u0001\u0001\u0006IA\u0015\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019\t\b\u0001)A\u0005A\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\ny\u0002\u0001\r\u00111A\u0005\nuD!\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003u\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0007\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\r\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fA\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAG\u0001E\u0005I\u0011AAH\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a1\u0001\t\u0003\t)\rC\u0004\u0002^\u0002!\t!!2\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"9!q\u0006\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\u001d\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005{\u0001A\u0011AAc\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0003\u000bDqA!\u0012\u0001\t\u0003\t)\rC\u0004\u0003J\u0001!\t!!2\t\u000f\t5\u0003\u0001\"\u0001\u0002F\"9!\u0011\u000b\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B+\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u00053\u0002A\u0011AAc\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003\u000bDqA!\u0019\u0001\t\u0003\t)\rC\u0004\u0003f\u0001!\t!!2\t\u000f\t%\u0004\u0001\"\u0001\u0002F\"9!Q\u000e\u0001\u0005\n\t=\u0004\"\u0003BL\u0001E\u0005I\u0011BA9\u0011%\u0011I\nAI\u0001\n\u0013\t\t\bC\u0005\u0003\u001c\u0002\t\n\u0011\"\u0003\u0003\u001e\"9!\u0011\u0015\u0001\u0005\u0002\u0005\u0015\u0007b\u0002BS\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005S\u0003A\u0011AAc\u0011\u001d\u0011i\u000b\u0001C\u0001\u0003\u000bDqA!-\u0001\t\u0003\t)\rC\u0004\u0002>\u0001!IA!.\t\u000f\t\r\u0007\u0001\"\u0001\u0002F\"9!q\u0019\u0001\u0005\u0002\u0005\u0015\u0007b\u0002Bf\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u001f\u0004A\u0011AAc\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0003\u000bDqAa6\u0001\t\u0003\t)\rC\u0004\u0003\\\u0002!\t!!2\t\u000f\t}\u0007\u0001\"\u0001\u0002F\"9!1\u001d\u0001\u0005\u0002\u0005\u0015\u0007b\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005\u007f\u0004A\u0011AAc\u0011\u001d\u0019\u0019\u0001\u0001C\u0005\u0007\u000b9qa!\u0004A\u0011\u0003\u0019yA\u0002\u0004@\u0001\"\u00051\u0011\u0003\u0005\u0007\u0019r\"\taa\u0005\t\u000f\tuH\b\"\u0001\u0004\u0016\tqAj\\4TK\u001elWM\u001c;UKN$(BA!C\u0003\rawn\u001a\u0006\u0002\u0007\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0014\t\u0003\u001f\u0002i\u0011\u0001Q\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005\u0011\u0006CA*\\\u001b\u0005!&BA+W\u0003\u0019\u0019w.\\7p]*\u00111i\u0016\u0006\u00031f\u000ba!\u00199bG\",'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002])\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u0011M,w-\\3oiN,\u0012\u0001\u0019\t\u0004C\u001aDW\"\u00012\u000b\u0005\r$\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003K\"\u000b!bY8mY\u0016\u001cG/[8o\u0013\t9'MA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA5p\u001b\u0005Q'BA!l\u0015\taW.A\u0005j]R,'O\\1mg*\u0011aNV\u0001\bgR|'/Y4f\u0013\t\u0001(N\u0001\u0006M_\u001e\u001cVmZ7f]R\f\u0011b]3h[\u0016tGo\u001d\u0011\u0002\r1|w\rR5s+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\tIwNC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\rq\u00181\u0001\t\u0003\u000f~L1!!\u0001I\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015q!!AA\u0002Q\f1\u0001\u001f\u00132\u0003\u001dawn\u001a#je\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u00055\u0001cA5\u0002\u0010%\u0019\u0011\u0011\u00036\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u0005i1\r[3dWN,Xn\u0015;pe\u0016,\"!!\u0007\u0011\t\u0005m\u00111F\u0007\u0003\u0003;QA!a\b\u0002\"\u0005A1\r[3dWN,XNC\u0002o\u0003GQ1aQA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013\r|gN\u001a7vK:$(\"A<\n\t\u00055\u0012Q\u0004\u0002\u0011\u000bJ*5\t[3dWN,Xn\u0015;pe\u0016\fab\u00195fG.\u001cX/\\*u_J,\u0007%\u0001\bdQ\u0016\u001c7n];n!\u0006\u0014\u0018-\\:\u0016\u0005\u0005U\u0002\u0003BA\u000e\u0003oIA!!\u000f\u0002\u001e\tq1\t[3dWN,X\u000eU1sC6\u001c\u0018aD2iK\u000e\\7/^7QCJ\fWn\u001d\u0011\u0002\u001b\r\u0014X-\u0019;f'\u0016<W.\u001a8u)%A\u0017\u0011IA&\u0003+\n)\u0007C\u0004\u0002D=\u0001\r!!\u0012\u0002\r=4gm]3u!\r9\u0015qI\u0005\u0004\u0003\u0013B%\u0001\u0002'p]\u001eD\u0011\"!\u0014\u0010!\u0003\u0005\r!a\u0014\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\t\u0004\u000f\u0006E\u0013bAA*\u0011\n\u0019\u0011J\u001c;\t\u0013\u0005]s\u0002%AA\u0002\u0005e\u0013\u0001\u0002;j[\u0016\u0004B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\"\u0016!B;uS2\u001c\u0018\u0002BA2\u0003;\u0012A\u0001V5nK\"I\u0011qM\b\u0011\u0002\u0003\u0007\u0011\u0011N\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\bcA$\u0002l%\u0019\u0011Q\u000e%\u0003\u000f\t{w\u000e\\3b]\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$HEM\u000b\u0003\u0003gRC!a\u0014\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002\"\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t))a\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0012\u0016\u0005\u00033\n)(A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0013\u0016\u0005\u0003S\n)(A\u0004sK\u000e|'\u000fZ:\u0015\r\u0005]\u00151UAS!\u0011\tI*a(\u000e\u0005\u0005m%bAAO)\u00061!/Z2pe\u0012LA!!)\u0002\u001c\niQ*Z7pef\u0014VmY8sINDq!a\u0011\u0014\u0001\u0004\t)\u0005C\u0004\u0002\u0014N\u0001\r!a*\u0011\u000b\u001d\u000bI+!,\n\u0007\u0005-\u0006J\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!a,\u0002>:!\u0011\u0011WA]!\r\t\u0019\fS\u0007\u0003\u0003kS1!a.E\u0003\u0019a$o\\8u}%\u0019\u00111\u0018%\u0002\rA\u0013X\rZ3g\u0013\u0011\ty,!1\u0003\rM#(/\u001b8h\u0015\r\tY\fS\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002}\"\u001aA#!3\u0011\t\u0005-\u0017\u0011\\\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006\u0019\u0011\r]5\u000b\t\u0005M\u0017Q[\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9.W\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\fiM\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004+\u0005\u0005\b\u0003BAf\u0003GLA!!:\u0002N\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001/i\u0016\u001cH/\u00119qK:$gi\u001c:M_\u001e\u001cVmZ7f]R|eMZ:fi>3XM\u001d4m_^,\u0005pY3qi&|g\u000eF\u0003\u007f\u0003W\fy\u000fC\u0004\u0002nZ\u0001\r!!\u0012\u0002\u0015\t\f7/Z(gMN,G\u000fC\u0004\u0002rZ\u0001\r!!\u0012\u0002\u001b1\f'oZ3ti>3gm]3uQ\r1\u0012Q\u001f\t\u0005\u0003o\fi0\u0004\u0002\u0002z*!\u00111`Ai\u0003\u0019\u0001\u0018M]1ng&!\u0011q`A}\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b-\t\r!q\u0002B\t!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003s\f\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0005\u001b\u00119AA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2r!1\u0003B\f\u00057\u0011yBa\t\u0003(\t-\u0012E\u0001B\u000b\u00039\u0001D\u0006I\u00173cQ:D\u0007O\u001a7ia\n#A!\u0007\u0002\u001bAb\u0003EM\u00195oQB4G\u000e\u001b9C\t\u0011i\"\u0001\u00032Y\u0001\u0002\u0014E\u0001B\u0011\u0003\u001d\t\u0004\u0007\r\u0017!cA\n#A!\n\u0002\u001bI\nDg\u000e\u001b9gY\"\u0004\b\f\u00111C\t\u0011I#\u0001\b.eE\"t\u0007\u000e\u001d4mQBD\u0006\t\u0019\"\u0005\t5\u0012!\u0006\u001a2i]\"\u0004h\r\u001c5q1\"$'\u000f\u001b:m]\u0012\u0014HN\u0001\u0017i\u0016\u001cHOU3bI>sW)\u001c9usN+w-\\3oi\"\u001aqCa\r\u0011\t\u0005-'QG\u0005\u0005\u0005o\tiM\u0001\u0003UKN$\u0018!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRD3\u0001\u0007B\u001a\u0003E!Xm\u001d;SK\u0006$\u0017I\u001a;fe2\u000b7\u000f\u001e\u0015\u00043\tM\u0012a\u0004;fgR\u0014V-\u00193Ge>lw)\u00199)\u0007i\u0011\u0019$\u0001\u0007uKN$HK];oG\u0006$X\rK\u0002\u001c\u0005g\t\u0001\u0004^3tiR\u0013XO\\2bi\u0016,U\u000e\u001d;z'\u0016<W.\u001a8uQ\ra\"1G\u00017i\u0016\u001cHOU3m_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e]!oI:+\u0007\u0010^(gMN,G/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0004;\tM\u0012\u0001\u0005;fgR$&/\u001e8dCR,g)\u001e7mQ\rq\"1G\u0001\u001ai\u0016\u001cHOR5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000fK\u0002 \u0005g\t\u0011\u0004^3ti:+\u0007\u0010^(gMN,GoQ1mGVd\u0017\r^5p]\"\u001a\u0001Ea\r\u0002-Q,7\u000f^\"iC:<WMR5mKN+hMZ5yKND3!\tB\u001a\u0003u!Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f^%oI\u0016D\bf\u0001\u0012\u00034\u0005YB/Z:u%\u0016\u001cwN^3s)J\fgn]1di&|g.\u00138eKbD3a\tB\u001a\u0003y!Xm\u001d;SK\u000e|g/\u001a:z%\u0016\u0014W/\u001b7eg\u0016\u0003xn\u00195DC\u000eDW\rK\u0002%\u0005g\tQ\"\u001a8e)bt'+Z2pe\u0012\u001cH\u0003EAL\u0005c\u0012YHa \u0003\n\n-%q\u0012BJ\u0011\u001d\u0011\u0019(\na\u0001\u0005k\n\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\tIJa\u001e\n\t\te\u00141\u0014\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002B?K\u0001\u0007\u0011QI\u0001\u000baJ|G-^2fe&#\u0007b\u0002BAK\u0001\u0007!1Q\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007\u001d\u0013))C\u0002\u0003\b\"\u0013Qa\u00155peRDq!a\u0011&\u0001\u0004\t)\u0005C\u0005\u0003\u000e\u0016\u0002\n\u00111\u0001\u0002P\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"D\u0011B!%&!\u0003\u0005\r!a\u0014\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\"\u0003BKKA\u0005\t\u0019AA#\u0003%!\u0018.\\3ti\u0006l\u0007/A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HEN\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uI]*\"Aa(+\t\u0005\u0015\u0013QO\u0001\"i\u0016\u001cHOU3d_Z,'/\u001f$jq\u0016\u001c8i\u001c:skB$H+[7f\u0013:$W\r\u001f\u0015\u0004S\tM\u0012A\b;fgR\u0014VmY8wKJLx+\u001b;i\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4fQ\rQ#1G\u0001&i\u0016\u001cH/\u00138eKb\u001c\u0006/\u0019:tSRLX*\u001e7uSBdWMQ1uG\"\f\u0005\u000f]3oIND3a\u000bB\u001a\u0003)\"Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM\u001d$jY2,G-\u00138eKb\feo\\5eg>3XM\u001d4m_^D3\u0001\fB\u001a\u0003}!Xm\u001d;Qe\u0016\u001cXM\u001d<fI2\u000b7\u000f^(gMN,G\u000fS1oI2Lgn\u001a\u0015\u0004[\tMB#\u00035\u00038\ne&1\u0018B`\u0011\u001d\tiO\fa\u0001\u0003\u000bBq!a\u001a/\u0001\u0004\tI\u0007C\u0004\u0003>:\u0002\r!a\u0014\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u000f\t\u0005g\u00061\u0001\u0002j\u0005Y\u0001O]3bY2|7-\u0019;f\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3)\u0007=\u0012\u0019$A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TXm\u00117fCJ\u001c\u0006.\u001e;e_^t\u0007f\u0001\u0019\u00034\u0005q3\u000f[8vY\u0012$&/\u001e8dCR,WI^3o\u0013\u001a|eMZ:fiB{\u0017N\u001c;t)>\fu)\u00199J]RCW\rT8hQ\r\t$1G\u0001\u0013i\u0016\u001cH/\u00119qK:$gI]8n\r&dW\rK\u00023\u0005g\t!\u0004^3ti2\u000b7\u000f^*fO6,g\u000e^(gMN,GoQ1dQ\u0016D3a\rB\u001a\u00035\"Xm\u001d;GC&d\u0017JZ+oKb\u0004Xm\u0019;fI:{g.R7qif4\u0015\u000e\\3BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u0015\u0004i\tM\u0012!\u0006;fgRd\u0015m\u001d;GYV\u001c\b.\u001a3US6,Wj\u001d\u0015\u0004k\tM\u0012a\u0007;fgR\u001c\u0005.Z2lgVlW\u000b\u001d3bi\u0016$wJ\\!qa\u0016tG\rK\u00027\u0005g\tQ\u0005^3ti\u000eCWmY6tk6\u0014VmY8wKJLxJ\\*fO6,g\u000e\u001e*fG>4XM]=)\u0007]\u0012\u0019$\u0001\fuKN$8\t[3dWN,X\u000e\u0016:v]\u000e\fG/[8o)\rq(1\u001e\u0005\b\u0005[D\u0004\u0019AA(\u0003A!(/\u001e8dCRLwN\\(gMN,G\u000fK\u00029\u0003kDs\u0001\u000fBz\u0005\u001f\u0011I\u0010\u0005\u0003\u0003\u0006\tU\u0018\u0002\u0002B|\u0005\u000f\u0011A\"T3uQ>$7k\\;sG\u0016d#Aa?\"\u0005\tu\u0018aI2iK\u000e\\7/^7UeVt7-\u0019;j_:\u0004\u0016M]1nKR,'\u000f\u0015:pm&$WM]\u0001%i\u0016\u001cHo\u00115fG.\u001cX/\\*u_J,WI\u001c;ss&s\u0017\u000e^5bY&T\u0018\r^5p]\"\u001a\u0011Ha\r\u0002/9,w\u000f\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014HCAB\u0004!\rI7\u0011B\u0005\u0004\u0007\u0017Q'\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'/\u0001\bM_\u001e\u001cVmZ7f]R$Vm\u001d;\u0011\u0005=c4C\u0001\u001fG)\t\u0019y\u0001\u0006\u0002\u0004\u0018A)qi!\u0007\u0002P%\u001911\u0004%\u0003\u000b\u0005\u0013(/Y=")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private File logDir;
    private final LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
    private final E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
    private final ChecksumParams checksumParams = new ChecksumParams(Optional.of(this.checksumStore()), this.checksumStore().checksumProtectionEnabledForTopic(this.topicPartition(), this.logConfig()), true);

    public static int[] checksumTruncationParameterProvider() {
        return Array$.MODULE$.range(-50, 50);
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private LogConfig logConfig() {
        return this.logConfig;
    }

    private E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    private ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time, boolean fileAlreadyExists) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time, fileAlreadyExists, this.checksumParams());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, scala.collection.immutable.Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @ParameterizedTest
    @CsvSource(value={"0, -2147483648", "0, 2147483648", "1, 0", "100, 10", "2147483648, 0", "-2147483648, 0", "2147483648,4294967296"})
    public void testAppendForLogSegmentOffsetOverflowException(long baseOffset, long largestOffset) {
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        long currentTime = Time.SYSTEM.milliseconds();
        MemoryRecords memoryRecords = this.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        Assertions.assertThrows(LogSegmentOffsetOverflowException.class, () -> seg.append(largestOffset, memoryRecords, currentTime));
    }

    @Test
    public void testReadOnEmptySegment() {
        Assertions.assertNull((Object)this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4()).read(40L, 300), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, ms);
        Records read = seg.read((long)41L, (int)300).records;
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = this.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            MemoryRecords ms1 = LogTestUtils$.MODULE$.records(offset$2.elem, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, ms1);
            MemoryRecords ms2 = LogTestUtils$.MODULE$.records(offset$2.elem + 1, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(read.records.records()).asScala().toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(read2.records.records()).asScala().size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        boolean rollBasedOnSystemTime = this.logConfig().confluentLogConfig().systemTimeBasedRollEnable;
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(0L, x$3, (Time)time, x$4);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        int x$7 = this.createSegment$default$2();
        boolean x$8 = this.createSegment$default$4();
        LogSegment reopened = this.createSegment(0L, x$7, (Time)time, x$8);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L, rollBasedOnSystemTime));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds(), rollBasedOnSystemTime);
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L, rollBasedOnSystemTime));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds(), rollBasedOnSystemTime);
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 2147483847L, 1024, time.milliseconds(), rollBasedOnSystemTime);
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            seg.append((long)offset$3.elem, LogTestUtils$.MODULE$.records(offset$3.elem, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        boolean rollBasedOnSystemTime = this.logConfig().confluentLogConfig().systemTimeBasedRollEnable;
        MockTime time = new MockTime(0L, 0L, 0L);
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time, x$4);
        time.sleep(400L);
        MemoryRecords records = LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(41L, records);
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), 900L, rollBasedOnSystemTime));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)seg.getFirstBatchTimestamp());
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L, rollBasedOnSystemTime));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024), (String)"Segment should be empty.");
        seg.append(41L, LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(420L, 0L).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(421L, 0L).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(430L, 0L).get()).offset());
        Assertions.assertEquals((long)44L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(431L, 0L).get()).offset());
        Assertions.assertEquals(Optional.empty(), (Object)seg.findOffsetByTimestamp(491L, 0L));
        Assertions.assertEquals((long)41L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(401L, 0L).get()).offset());
        Assertions.assertEquals((long)40L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(399L, 0L).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        ChecksumStore store = this.checksumStore().store();
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndexFile();
        File timeIndexFile = seg.timeIndexFile();
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertTrue((boolean)store.get(seg.log().file().getAbsolutePath()).isPresent());
        Assertions.assertTrue((boolean)store.get(seg.offsetIndexFile().getAbsolutePath()).isPresent());
        Assertions.assertTrue((boolean)store.get(seg.timeIndexFile().getAbsolutePath()).isPresent());
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.offsetIndexFile().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.timeIndexFile().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.offsetIndex();
        Assertions.assertTrue((boolean)seg.offsetIndexFile().exists());
        seg.timeIndex();
        Assertions.assertTrue((boolean)seg.timeIndexFile().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.offsetIndexFile();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Iterable records = seg$5.read((long)((long)i), (int)1, (long)((long)seg$5.size()), (boolean)true).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverTransactionIndex() {
        void getChecksumInfoForFile_size;
        void getChecksumInfoForFile_file;
        void getChecksumInfoForFile_store;
        void getChecksumInfoForFile_size2;
        void getChecksumInfoForFile_file2;
        void getChecksumInfoForFile_store2;
        void withRecords_records;
        void withRecords_compressionType;
        void withTransactionalRecords_records;
        void withTransactionalRecords_compressionType;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_compressionType2;
        MockTime time = new MockTime();
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withTransactionalRecords_initialOffset = 100L;
        compressionType = null;
        simpleRecordArray = null;
        segment.append(101L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType2 = CompressionType.NONE;
        long withTransactionalRecords_initialOffset2 = 102L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        segment.append(103L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset2, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset = 104L;
        compressionType3 = null;
        simpleRecordArray3 = null;
        segment.append(105L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        segment.append(106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, 0, 0, -1L));
        segment.append(107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, 0, 0, -1L));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        int n = (int)segment.txnIndex().file().length();
        File file = segment.txnIndex().file();
        ChecksumStore checksumStore = this.checksumStore().store();
        LogTestUtils$ getChecksumInfoForFile_this = LogTestUtils$.MODULE$;
        Object var29_21 = null;
        checksumStore = null;
        file = null;
        Optional<ChecksumInfo> expectedChecksum = getChecksumInfoForFile_this.getChecksumInfoForFile((ChecksumStore)getChecksumInfoForFile_store2, (File)getChecksumInfoForFile_file2, (int)getChecksumInfoForFile_size2, false);
        Optional actualChecksum = this.checksumStore().store().get(segment.txnIndex().file().getAbsolutePath());
        Assertions.assertEquals(expectedChecksum, (Object)actualChecksum);
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        long loadTimeMs = time.milliseconds();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))), loadTimeMs);
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        int n2 = (int)segment.txnIndex().file().length();
        File file2 = segment.txnIndex().file();
        ChecksumStore checksumStore2 = this.checksumStore().store();
        LogTestUtils$ getChecksumInfoForFile_this2 = LogTestUtils$.MODULE$;
        Object var33_30 = null;
        checksumStore2 = null;
        file2 = null;
        expectedChecksum = getChecksumInfoForFile_this2.getChecksumInfoForFile((ChecksumStore)getChecksumInfoForFile_store, (File)getChecksumInfoForFile_file, (int)getChecksumInfoForFile_size, false);
        actualChecksum = this.checksumStore().store().get(segment.txnIndex().file().getAbsolutePath());
        Assertions.assertEquals(expectedChecksum, (Object)actualChecksum);
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryRebuildsEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        void withRecords_compressionType3;
        void withRecords_records4;
        void withRecords_partitionLeaderEpoch4;
        void withRecords_compressionType4;
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            public void write(Collection<EpochEntry> x$1) {
                super.write(x$1);
            }

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Collection<EpochEntry> epochs, boolean ignored) {
                this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
            }

            public java.util.List<EpochEntry> read() {
                return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
            }

            public File file() {
                return this.file;
            }

            public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }
            {
                this.epochs = (Seq)Seq$.MODULE$.empty();
                this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 104L;
        compressionType = null;
        simpleRecordArray = null;
        seg.append(105L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withRecords_records4));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl2 = true;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 106L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        seg.append(107L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl3 = true;
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset3 = 108L;
        compressionType3 = null;
        simpleRecordArray3 = null;
        seg.append(109L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        int n = 2;
        CompressionType compressionType4 = CompressionType.NONE;
        long withRecords_initialOffset4 = 110L;
        compressionType4 = null;
        simpleRecordArray4 = null;
        seg.append(111L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset4, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        seg.recover(this.newProducerStateManager(), Optional.of(cache));
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, this.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.timeIndexFile();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10), 0L).get()).offset());
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10 + 1), 0L).get()).offset());
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), Optional.empty());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(seg.log().batches()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastOffset()))).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    @Test
    public void testIndexSparsityMultipleBatchAppends() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        ByteBufferChannel channel = new ByteBufferChannel(100000L);
        int numBatches = 100;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            void withRecords_records;
            void withRecords_compressionType;
            void withRecords_initialOffset;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("foo".getBytes())};
            CompressionType compressionType = CompressionType.NONE;
            long l = i;
            byte withRecords_magic = 2;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            Object var8_6 = null;
            compressionType = null;
            simpleRecordArray = null;
            MemoryRecords memoryBatch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            return memoryBatch.writeTo((TransferableChannel)channel, 0, memoryBatch.sizeInBytes());
        });
        ByteBuffer buf = channel.buffer();
        buf.flip();
        MemoryRecords appendable = new MemoryRecords(buf);
        seg.append((long)numBatches, appendable);
        Assertions.assertEquals((int)(numBatches - 1), (int)seg.offsetIndex().entries(), (String)"every batch should have its own offset index entry aside from the last one");
    }

    @Test
    public void testRecoveryAfterFilledIndexAvoidsOverflow() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        ByteBufferChannel channel = new ByteBufferChannel(100000L);
        int numBatches = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            void withRecords_records;
            void withRecords_compressionType;
            void withRecords_initialOffset;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("foo".getBytes())};
            CompressionType compressionType = CompressionType.NONE;
            long l = i;
            byte withRecords_magic = 2;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            Object var8_6 = null;
            compressionType = null;
            simpleRecordArray = null;
            MemoryRecords memoryBatch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            return memoryBatch.writeTo((TransferableChannel)channel, 0, memoryBatch.sizeInBytes());
        });
        ByteBuffer buf = channel.buffer();
        buf.flip();
        MemoryRecords appendable = new MemoryRecords(buf);
        seg.append((long)numBatches, appendable);
        Assertions.assertTrue((boolean)seg.offsetIndex().isFull(), (String)"batch index should have been filled from single append of many batches");
        seg.close();
        this.segments().remove(0);
        int x$3 = this.createSegment$default$2();
        Time x$4 = this.createSegment$default$3();
        this.createSegment(0L, x$3, x$4, true).recover(this.newProducerStateManager(), Optional.empty());
    }

    @Test
    public void testPreservedLastOffsetHandling() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(0L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"text"})));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(out, 2, CompressionType.NONE, TimestampType.CREATE_TIME, 1L, 0L, 0L, 0, 0, false, false, 0, out.limit());
        builder.append(new SimpleRecord("foo".getBytes()));
        builder.overrideLastOffset(3L);
        builder.close();
        buffer.flip();
        seg.append(1L, new MemoryRecords(buffer));
        Assertions.assertEquals((long)3L, (long)seg.offsetIndex().lastOffset());
        Assertions.assertEquals((long)4L, (long)seg.readNextOffset());
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils.tempDirectory(null, null);
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)baseOffset, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate, (String)"", (ChecksumParams)this.checksumParams());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    public boolean createSegment$default$4() {
        return false;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        void open_checksumParams;
        void open_preallocate;
        void open_initFileSize;
        void open_time;
        void open_config;
        File tempDir = TestUtils.tempDirectory(null, null);
        ChecksumParams checksumParams = this.checksumParams();
        boolean bl = true;
        int n = 0x20000000;
        Time time = Time.SYSTEM;
        LogConfig logConfig = this.logConfig();
        long open_baseOffset = 40L;
        logConfig = null;
        time = null;
        checksumParams = null;
        LogSegment seg = LogSegment.open((File)tempDir, (long)open_baseOffset, (LogConfig)open_config, (Time)open_time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)"", (ChecksumParams)open_checksumParams);
        MemoryRecords ms = this.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment.open((File)tempDir, (long)40L, (LogConfig)this.logConfig(), (Time)Time.SYSTEM, (boolean)true, (int)0x20000000, (boolean)true, (String)"", (ChecksumParams)this.checksumParams());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000);
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(log.records.batches()).asScala().size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils.tempDirectory(null, null);
        long logFile_offset = 0L;
        File open_file = LogFileUtils.logFile((File)tempDir, (long)logFile_offset, (String)"");
        boolean open_mutable = true;
        Object var11_3 = null;
        FileRecords fileRecords = FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir, (boolean)false);
    }

    @Test
    public void testLastSegmentOffsetCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(2L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Field field = LogSegment.class.getDeclaredField("lastSegmentOffset");
        field.setAccessible(true);
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.truncateTo(3L);
        Assertions.assertEquals((long)-1L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.append(5L, LogTestUtils$.MODULE$.records(3L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)6L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)5L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
    }

    @Test
    public void testFailIfUnexpectedNonEmptyFileAlreadyExists() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(0L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        seg.close();
        this.segments().remove(0);
        Assertions.assertThrows(IllegalStateException.class, () -> this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4()));
        int x$3 = this.createSegment$default$2();
        Time x$4 = this.createSegment$default$3();
        this.createSegment(0L, x$3, x$4, true);
    }

    @Test
    public void testLastFlushedTimeMs() {
        MockTime time = new MockTime(0L, 1000L, 1000000000L);
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time, x$4);
        MemoryRecords records = LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(41L, records);
        seg.setLastModified(time.milliseconds());
        Assertions.assertFalse((boolean)seg.lastFlushedTimeMs().isPresent());
        time.sleep(2000L);
        seg.flush();
        Assertions.assertEquals((Object)OptionalLong.of(time.milliseconds()), (Object)seg.lastFlushedTimeMs(), (String)"flush time of segment was not correctly set");
    }

    @Test
    public void testChecksumUpdatedOnAppend() {
        ChecksumStore store = this.checksumStore().store();
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        String segFilePath = seg.log().file().getAbsolutePath();
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        ByteBuffer buffer = ms.buffer().duplicate();
        store.initializeEntry("expected");
        seg.append(53L, ms);
        store.update("expected", buffer);
        long expectedChecksum = ((ChecksumInfo)store.get("expected").get()).checksum().getValue();
        long actualChecksum = ((ChecksumInfo)store.get(segFilePath).get()).checksum().getValue();
        Assertions.assertEquals((long)expectedChecksum, (long)actualChecksum);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChecksumRecoveryOnSegmentRecovery() {
        void getChecksumInfoForFile_size;
        void getChecksumInfoForFile_file;
        void getChecksumInfoForFile_size2;
        void getChecksumInfoForFile_file2;
        void getChecksumInfoForFile_size3;
        void getChecksumInfoForFile_file3;
        int numMessages = 30;
        IntRef offset = IntRef.create((int)40);
        LogSegment seg = this.createSegment((long)offset.elem, 2 * LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3(), this.createSegment$default$4());
        ChecksumStore store = this.checksumStore().store();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            seg.append((long)offset$4.elem, LogTestUtils$.MODULE$.records(offset$4.elem, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$4.elem;
        });
        store.remove(seg.log().file().getAbsolutePath());
        store.remove(seg.timeIndex().file().getAbsolutePath());
        store.remove(seg.offsetIndex().file().getAbsolutePath());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        int n = seg.log().sizeInBytes();
        File file = seg.log().file();
        LogTestUtils$ getChecksumInfoForFile_this = LogTestUtils$.MODULE$;
        Object var11_7 = null;
        file = null;
        Optional<ChecksumInfo> segmentExpected = getChecksumInfoForFile_this.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file3, (int)getChecksumInfoForFile_size3, false);
        int n2 = seg.offsetIndex().sizeInBytes();
        File file2 = seg.offsetIndex().file();
        LogTestUtils$ getChecksumInfoForFile_this2 = LogTestUtils$.MODULE$;
        Object var14_11 = null;
        file2 = null;
        Optional<ChecksumInfo> offsetIndexExpected = getChecksumInfoForFile_this2.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file2, (int)getChecksumInfoForFile_size2, false);
        int n3 = seg.timeIndex().sizeInBytes();
        File file3 = seg.timeIndex().file();
        LogTestUtils$ getChecksumInfoForFile_this3 = LogTestUtils$.MODULE$;
        Object var17_15 = null;
        file3 = null;
        Optional<ChecksumInfo> timeIndexExpected = getChecksumInfoForFile_this3.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file, (int)getChecksumInfoForFile_size, false);
        Optional segmentActual = store.get(seg.log().file().getAbsolutePath());
        Optional offsetIndexActual = store.get(seg.offsetIndex().file().getAbsolutePath());
        Optional timeIndexActual = store.get(seg.timeIndex().file().getAbsolutePath());
        Assertions.assertEquals(segmentExpected, (Object)segmentActual);
        Assertions.assertEquals(offsetIndexExpected, (Object)offsetIndexActual);
        Assertions.assertEquals(timeIndexExpected, (Object)timeIndexActual);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"checksumTruncationParameterProvider"})
    public void testChecksumTruncation(int truncationOffset) {
        void getChecksumInfoForFile_size;
        void getChecksumInfoForFile_file;
        void getChecksumInfoForFile_size2;
        void getChecksumInfoForFile_file2;
        void getChecksumInfoForFile_size3;
        void getChecksumInfoForFile_file3;
        ChecksumStore store = this.checksumStore().store();
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 25).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            MemoryRecords ms = LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("hello").append(i).toString()}));
            seg.append((long)i, ms);
        });
        seg.truncateTo((long)truncationOffset);
        int n = seg.log().sizeInBytes();
        File file = seg.log().file();
        LogTestUtils$ getChecksumInfoForFile_this = LogTestUtils$.MODULE$;
        Object var10_6 = null;
        file = null;
        Optional<ChecksumInfo> segmentExpected = getChecksumInfoForFile_this.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file3, (int)getChecksumInfoForFile_size3, false);
        int n2 = seg.offsetIndex().sizeInBytes();
        File file2 = seg.offsetIndex().file();
        LogTestUtils$ getChecksumInfoForFile_this2 = LogTestUtils$.MODULE$;
        Object var13_10 = null;
        file2 = null;
        Optional<ChecksumInfo> offsetIndexExpected = getChecksumInfoForFile_this2.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file2, (int)getChecksumInfoForFile_size2, false);
        int n3 = seg.timeIndex().sizeInBytes();
        File file3 = seg.timeIndex().file();
        LogTestUtils$ getChecksumInfoForFile_this3 = LogTestUtils$.MODULE$;
        Object var16_14 = null;
        file3 = null;
        Optional<ChecksumInfo> timeIndexExpected = getChecksumInfoForFile_this3.getChecksumInfoForFile(store, (File)getChecksumInfoForFile_file, (int)getChecksumInfoForFile_size, false);
        Optional segmentActual = store.get(seg.log().file().getAbsolutePath());
        Optional offsetIndexActual = store.get(seg.offsetIndex().file().getAbsolutePath());
        Optional timeIndexActual = store.get(seg.timeIndex().file().getAbsolutePath());
        Assertions.assertEquals(segmentExpected, (Object)segmentActual);
        Assertions.assertEquals(offsetIndexExpected, (Object)offsetIndexActual);
        Assertions.assertEquals(timeIndexExpected, (Object)timeIndexActual);
    }

    @Test
    public void testChecksumStoreEntryInitialization() {
        ChecksumStore store = this.checksumStore().store();
        LogSegment.open((File)TestUtils.tempDirectory(null, null), (long)40L, (LogConfig)this.logConfig(), (Time)Time.SYSTEM, (boolean)true, (int)512, (boolean)true, (String)"", (ChecksumParams)this.checksumParams());
        Assertions.assertEquals((int)0, (int)store.size());
        LogSegment seg = LogSegment.open((File)TestUtils.tempDirectory(null, null), (long)40L, (LogConfig)this.logConfig(), (Time)Time.SYSTEM, (boolean)false, (int)512, (boolean)true, (String)"", (ChecksumParams)this.checksumParams());
        Assertions.assertEquals((int)3, (int)store.size());
        Assertions.assertTrue((boolean)store.get(seg.log().file().getAbsolutePath()).isPresent());
        Assertions.assertTrue((boolean)store.get(seg.timeIndex().file().getAbsolutePath()).isPresent());
        Assertions.assertTrue((boolean)store.get(seg.offsetIndex().file().getAbsolutePath()).isPresent());
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), (Time)new MockTime(), Optional.empty(), this.checksumParams());
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$1(long offset, String record) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$2(long offset, int size) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new byte[size])};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private static final long reflectLastSegmentOffset$1(Field field$1, LogSegment seg$8) {
        return ((AtomicLong)field$1.get(seg$8)).get();
    }
}

