/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kafka.log.LogTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u00043\u0001\u0001\u0006Ia\n\u0005\ng\u0001\u0001\r\u00111A\u0005\u0002QB\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001 \t\u0013\u0011\u0003\u0001\u0019!A!B\u0013)\u0004bB#\u0001\u0005\u0004%\tA\u0012\u0005\u0007'\u0002\u0001\u000b\u0011B$\t\u000bQ\u0003A\u0011B+\t\u000fA\u0004\u0011\u0013!C\u0005c\"9A\u0010AI\u0001\n\u0013i\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u001a\u0001!\t!!\u0001\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\f\u0001\u0005\u0002\u0005\u0005\u0001bBA2\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003O\u0002A\u0011AA\u0001\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0003Aq!a\u001c\u0001\t\u0003\t\tAA\bM_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\t1r#A\u0002m_\u001eT\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003U\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001(!\tA\u0003'D\u0001*\u0015\tQ3&\u0001\u0004d_6lwN\u001c\u0006\u000311R!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011'\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00027pO\u0012K'/F\u00016!\t14(D\u00018\u0015\tA\u0014(\u0001\u0002j_*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011A\u0004Q\u0005\u0003\u0003v\u0011A!\u00168ji\"91)BA\u0001\u0002\u0004)\u0014a\u0001=%c\u00059An\\4ESJ\u0004\u0013AD2iK\u000e\\7/^7QCJ\fWn]\u000b\u0002\u000fB\u0011\u0001*U\u0007\u0002\u0013*\u0011!jS\u0001\tG\",7m[:v[*\u0011A*T\u0001\bgR|'/Y4f\u0015\tAbJ\u0003\u0002P!\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002q%\u0011!+\u0013\u0002\u000f\u0007\",7m[:v[B\u000b'/Y7t\u0003=\u0019\u0007.Z2lgVl\u0007+\u0019:b[N\u0004\u0013!D2sK\u0006$XmU3h[\u0016tG\u000f\u0006\u0003W=\u000eD\u0007CA,]\u001b\u0005A&B\u0001\fZ\u0015\tQ6,A\u0005j]R,'O\\1mg*\u0011AjK\u0005\u0003;b\u0013!\u0002T8h'\u0016<W.\u001a8u\u0011\u0015y\u0016\u00021\u0001a\u0003\u0019ygMZ:fiB\u0011A$Y\u0005\u0003Ev\u0011A\u0001T8oO\"9A-\u0003I\u0001\u0002\u0004)\u0017AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\"\u0001\b4\n\u0005\u001dl\"aA%oi\"9\u0011.\u0003I\u0001\u0002\u0004Q\u0017\u0001\u0002;j[\u0016\u0004\"a\u001b8\u000e\u00031T!!\\\u0015\u0002\u000bU$\u0018\u000e\\:\n\u0005=d'\u0001\u0002+j[\u0016\fqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003IT#!Z:,\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0013Ut7\r[3dW\u0016$'BA=\u001e\u0003)\tgN\\8uCRLwN\\\u0005\u0003wZ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3'F\u0001\u007fU\tQ7/A\u0003tKR,\b\u000fF\u0001@Q\ra\u0011Q\u0001\t\u0005\u0003\u000f\t)\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001f\t\t\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005Ma&A\u0003kk:LG/\u0003\u0003\u0002\u0018\u0005%!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u000e\u0003;\u0001B!a\u0002\u0002 %!\u0011\u0011EA\u0005\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0006bgN,'\u000f^#oiJLH#B \u0002(\u0005-\u0002BBA\u0015\u001d\u0001\u0007a+A\u0004tK\u001elWM\u001c;\t\u000f\u00055b\u00021\u0001\u00020\u00051A/Z:uK\u0012\u0004r!!\r\u0002J\u0005=cK\u0004\u0003\u00024\u0005\rc\u0002BA\u001b\u0003\u007fqA!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wI\u0012A\u0002\u001fs_>$h(C\u0001;\u0013\r\t\t%O\u0001\u0005kRLG.\u0003\u0003\u0002F\u0005\u001d\u0013aA'ba*\u0019\u0011\u0011I\u001d\n\t\u0005-\u0013Q\n\u0002\u0006\u000b:$(/\u001f\u0006\u0005\u0003\u000b\n9\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)&O\u0001\u0005Y\u0006tw-C\u0002c\u0003'\n1\u0003^3ti\n\u000b7/[2Pa\u0016\u0014\u0018\r^5p]ND3aDA/!\u0011\t9!a\u0018\n\t\u0005\u0005\u0014\u0011\u0002\u0002\u0005)\u0016\u001cH/A\tuKN$8+Z4nK:$\u0018iY2fgND3\u0001EA/\u0003i!Xm\u001d;DY>\u001cXm\u001d;NCR\u001c\u0007n\u00149fe\u0006$\u0018n\u001c8tQ\r\t\u0012QL\u0001\u0013i\u0016\u001cH\u000fS5hQ\u0016\u00148+Z4nK:$8\u000fK\u0002\u0013\u0003;\nA\u0003^3tiNK'0\u001a$pe2\u000b'oZ3M_\u001e\u001c\bfA\n\u0002^\u0001")
public class LogSegmentsTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private File logDir;
    private final ChecksumParams checksumParams = TestUtils$.MODULE$.createChecksumParams();

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    private LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        File x$2 = this.logDir();
        ChecksumParams x$5 = this.checksumParams();
        boolean x$6 = false;
        return LogTestUtils$.MODULE$.createSegment(offset, x$2, indexIntervalBytes, time, x$6, x$5);
    }

    private int createSegment$default$2() {
        return 10;
    }

    private Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    private void assertEntry(LogSegment segment, Map.Entry<Long, LogSegment> tested) {
        Assertions.assertEquals((long)segment.baseOffset(), (Long)tested.getKey());
        Assertions.assertEquals((Object)segment, (Object)tested.getValue());
    }

    @Test
    public void testBasicOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        int offset1 = 40;
        LogSegment seg1 = this.createSegment(offset1, 10, Time.SYSTEM);
        int offset2 = 80;
        LogSegment seg2 = this.createSegment(offset2, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(offset1, 10, Time.SYSTEM);
        segments.add(seg1);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.get((long)offset1));
        segments.add(seg2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset2));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.get((long)offset2));
        segments.add(seg3);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.get((long)offset1));
        segments.remove((long)offset2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset2));
        segments.clear();
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)0, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset1));
        segments.close();
    }

    @Test
    public void testSegmentAccess() {
        LogSegments segments = new LogSegments(this.topicPartition());
        int offset1 = 1;
        LogSegment seg1 = this.createSegment(offset1, 10, Time.SYSTEM);
        int offset2 = 2;
        LogSegment seg2 = this.createSegment(offset2, 10, Time.SYSTEM);
        int offset3 = 3;
        LogSegment seg3 = this.createSegment(offset3, 10, Time.SYSTEM);
        int offset4 = 4;
        LogSegment seg4 = this.createSegment(offset4, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)seg -> {
            LogSegmentsTest.$anonfun$testSegmentAccess$1(this, segments, seg1, seg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{offset1, offset2, offset3, offset4})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.baseOffsets()).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values()).asScala().toSeq());
        Assertions.assertThrows(IllegalArgumentException.class, () -> segments.values(2L, 1L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 1L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 2L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 3L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$))), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(2L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg3, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(3L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(4L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg4, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(4L, 5L)).asScala().toSeq());
        segments.close();
    }

    @Test
    public void testClosestMatchOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, 10, Time.SYSTEM);
        LogSegment seg2 = this.createSegment(3L, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(5L, 10, Time.SYSTEM);
        LogSegment seg4 = this.createSegment(7L, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)x$1 -> segments.add(x$1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.floorSegment(2L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.floorSegment(3L));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.lowerSegment(3L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.lowerSegment(4L));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.higherSegment(4L));
        this.assertEntry(seg3, (Map.Entry)segments.higherEntry(4L).get());
        Assertions.assertEquals(Optional.of(seg4), (Object)segments.higherSegment(5L));
        this.assertEntry(seg4, (Map.Entry)segments.higherEntry(5L).get());
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.nextLogSegment(this.createSegment(0L, 10, Time.SYSTEM)));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.nextLogSegment(seg1));
        Assertions.assertEquals(Optional.empty(), (Object)segments.nextLogSegment(seg4));
        segments.close();
    }

    @Test
    public void testHigherSegments() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, 10, Time.SYSTEM);
        LogSegment seg2 = this.createSegment(3L, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(5L, 10, Time.SYSTEM);
        LogSegment seg4 = this.createSegment(7L, 10, Time.SYSTEM);
        LogSegment seg5 = this.createSegment(9L, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x$1 -> segments.add(x$1));
        Iterator iterator = segments.higherSegments(0L).iterator();
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$2(iterator, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = segments.higherSegments(1L).iterator();
        new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$3(iterator2, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = segments.higherSegments(8L).iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((Object)seg5, iterator3.next());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        Assertions.assertFalse((boolean)segments.higherSegments(9L).iterator().hasNext());
    }

    @Test
    public void testSizeForLargeLogs() {
        long largeSize = 0xFFFFFFFEL;
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)LogSegments.sizeInBytes(Arrays.asList(logSegment)));
        Assertions.assertEquals((long)largeSize, (long)LogSegments.sizeInBytes(Arrays.asList(logSegment, logSegment)));
        Assertions.assertTrue((LogSegments.sizeInBytes(Arrays.asList(logSegment, logSegment)) > Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentAccess$1(LogSegmentsTest $this, LogSegments segments$1, LogSegment seg1$1, LogSegment seg) {
        segments$1.add(seg);
        $this.assertEntry(seg1$1, (Map.Entry)segments$1.firstEntry().get());
        Assertions.assertEquals(Optional.of(seg1$1), (Object)segments$1.firstSegment());
        $this.assertEntry(seg, (Map.Entry)segments$1.lastEntry().get());
        Assertions.assertEquals(Optional.of(seg), (Object)segments$1.lastSegment());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$2(Iterator iterator$1, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Assertions.assertEquals((Object)segment, iterator$1.next());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$3(Iterator iterator$2, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$2.hasNext());
        Assertions.assertEquals((Object)segment, iterator$2.next());
    }
}

