/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kafka.cluster.Partition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.HarnessParams;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.FaultInjectedTierObjectStoreWrapper;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MergedLogHarness$
implements Logging {
    public static final MergedLogHarness$ MODULE$ = new MergedLogHarness$();
    private static final int MaxTransactionTimeoutMs = 300000;
    private static final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(3600000, false);
    private static final int ProducerIdExpirationCheckIntervalMs = 600000;
    private static final int BrokerId = 0;
    private static final long MinAbortedProducerId = 1000000L;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$((Logging)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String logIdent() {
        return logIdent;
    }

    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public int MaxTransactionTimeoutMs() {
        return MaxTransactionTimeoutMs;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return producerStateManagerConfig;
    }

    public int ProducerIdExpirationCheckIntervalMs() {
        return ProducerIdExpirationCheckIntervalMs;
    }

    public int BrokerId() {
        return BrokerId;
    }

    public long MinAbortedProducerId() {
        return MinAbortedProducerId;
    }

    public Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> initializeComponents(MergedLog log, Throttler throttler, HarnessParams params, int leaderEpoch) {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog(log.topicPartition(), logManager.getLog$default$2())).thenReturn((Object)new Some((Object)log));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.liveLogDirs()).thenReturn((Object)new .colon.colon((Object)Paths.get("/tmp/", new String[0]).toFile(), (List)Nil$.MODULE$));
        Mockito.when((Object)replicaManager.getLog(log.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTasksConfig compactionTaskConfig = new CompactionTasksConfig(params.skimpyOffsetMapMemory(), Defaults$.MODULE$.LogCleanerDedupeBufferLoadFactor(), params.initialCompactIoBufferSize(), params.maxCompactBufferSize(), params.ioMaxBytesPerSecond(), params.throttleCheckInterval(), 100, Long.MAX_VALUE);
        boolean x$5 = log.config().confluentLogConfig().tierCleanerEnable;
        boolean x$6 = log.config().confluentLogConfig().tierCleanerDualCompaction;
        Some x$7 = new Some((Object)compactionTaskConfig);
        int x$8 = this.BrokerId();
        long x$9 = 600000L;
        int x$10 = 50;
        int x$11 = 300000;
        None$ x$12 = None$.MODULE$;
        TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, x$8, x$9, 5L, x$10, x$11, x$5, x$6, (Option)x$7, (Option)x$12);
        TopicIdPartition topicIdPartition = new TopicIdPartition(log.topicPartition().topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)log.topicId().get()), log.topicPartition().partition());
        ArchiveTask archiveTask = new ArchiveTask(ctx, topicIdPartition, (ArchiveTaskState)new BeforeLeader(leaderEpoch), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), this.BrokerId());
        LogCleanerMetrics logCleanerMetrics = new LogCleanerMetrics((Option)None$.MODULE$);
        Cleaner localCleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(Integer.MAX_VALUE), params.initialCompactIoBufferSize(), params.maxCompactBufferSize(), 0.75, throttler, log.localLog().time(), (Function1 & Serializable)x$1 -> {
            MergedLogHarness$.$anonfun$initializeComponents$1(x$1);
            return BoxedUnit.UNIT;
        }, logCleanerMetrics);
        OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(2, params.skimpyOffsetMapMemory());
        CompactionTask compactionTask = new CompactionTask(ctx, topicIdPartition, offsetMapSupplier, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(leaderEpoch, (Option)None$.MODULE$), new TierCompactionMetrics(logCleanerMetrics, (Option)None$.MODULE$, (Option)None$.MODULE$), log.localLog().time());
        CopyOnWriteArrayList appendedMetadata = new CopyOnWriteArrayList();
        TierTopicAppender appender = new TierTopicAppender(log, appendedMetadata){
            private final MergedLog log$1;
            private final CopyOnWriteArrayList appendedMetadata$1;

            public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
                TierPartitionState.AppendResult result;
                TierPartitionState.AppendResult appendResult = result = this.log$1.tierPartitionState().append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
                TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                Predef$.MODULE$.assert(!(appendResult != null ? !appendResult.equals(appendResult2) : appendResult2 != null));
                this.appendedMetadata$1.add(entry);
                return CompletableFuture.completedFuture(result);
            }

            public boolean isReadyForWrites() {
                return true;
            }
            {
                this.log$1 = log$1;
                this.appendedMetadata$1 = appendedMetadata$1;
            }
        };
        return new Tuple7((Object)tierTasksConfig, (Object)archiveTask, (Object)compactionTask, (Object)appender, appendedMetadata, (Object)replicaManager, (Object)localCleaner);
    }

    /*
     * WARNING - void declaration
     */
    public MergedLogHarness apply(TopicPartition topicPartition, LogConfig config, HarnessParams params) {
        void var48_45;
        void var47_44;
        void var46_43;
        void var45_42;
        void var44_41;
        void var43_40;
        void var49_46;
        MockTime time = new MockTime(0L, 0L);
        MockScheduler scheduler = time.scheduler;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        long recoveryPoint = 0L;
        long initialLogStartOffset = 0L;
        int leaderEpoch = 0;
        TierTestUtils$.MODULE$.setTierTopicOffsetAndEpoch(new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        File logDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        logDir.mkdir();
        File partitionDir = new File(logDir, topicPartition.toString());
        partitionDir.mkdir();
        TopicIdPartition tpid = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        MockInMemoryTierObjectStoreConfig tierObjectStoreConfig = new MockInMemoryTierObjectStoreConfig(Optional.of(UUID.randomUUID().toString()), Optional.of(Predef$.MODULE$.int2Integer(0)), new StringBuilder(1).append(tpid.toString()).append("/").toString());
        Map<String, Object> crashDefinition = params.putCrashPeriod() == -1 ? Collections.emptyMap() : Collections.singletonMap("putInMemorySegment", BoxesRunTime.boxToInteger((int)params.putCrashPeriod()));
        FaultInjectedTierObjectStoreWrapper tierObjectStore = new FaultInjectedTierObjectStoreWrapper((TierObjectStore)new MockInMemoryTierObjectStore((Time)time, tierObjectStoreConfig), crashDefinition);
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, true, TierPartitionStateCleanupConfig.EMPTY, false, -1), (Option)None$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = MergedLogHarness$.$anonfun$apply$1(tpid);
            Object var50_18 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        Metrics metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(metrics);
        BrokerTopicStats x$6 = new BrokerTopicStats();
        int x$9 = this.MaxTransactionTimeoutMs();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        int x$11 = this.ProducerIdExpirationCheckIntervalMs();
        None$ x$12 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        ChecksumParams x$18 = TestUtils$.MODULE$.createChecksumParams();
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        MergedLog log = MergedLog$.MODULE$.apply(partitionDir, config, initialLogStartOffset, recoveryPoint, (Scheduler)scheduler, x$6, metrics, (Time)time, x$9, x$10, x$11, (Option)x$12, logDirFailureChannel, tierLogComponents, true, (Option)x$16, true, x$19, (Option)x$20, x$21, x$18);
        Predef$.MODULE$.assert(log.tieredLogSegments().isEmpty(), (Function0 & Serializable)() -> log.toString());
        log.assignTopicId(CoreUtils$.MODULE$.toKafkaUUID(tpid.topicId()), log.assignTopicId$default$2());
        if (config.confluentLogConfig().tierEnable()) {
            log.tierPartitionState().setTieringEnabled();
            MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(log);
        }
        double x$22 = params.ioMaxBytesPerSecond();
        long x$23 = params.throttleCheckInterval();
        Time x$24 = log.localLog().time();
        boolean x$25 = true;
        String x$26 = "throttler";
        String x$27 = "entries";
        Throttler throttler = new Throttler(x$22, x$23, x$25, x$26, x$27, x$24);
        int epoch = 0;
        Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> tuple7 = this.initializeComponents(log, throttler, params, epoch);
        if (tuple7 == null) {
            throw new MatchError(null);
        }
        TierTasksConfig tierTasksConfig = (TierTasksConfig)tuple7._1();
        ArchiveTask archiveTask = (ArchiveTask)tuple7._2();
        CompactionTask compactionTask = (CompactionTask)tuple7._3();
        TierTopicAppender appender = (TierTopicAppender)tuple7._4();
        CopyOnWriteArrayList appendMetadata = (CopyOnWriteArrayList)tuple7._5();
        ReplicaManager replicaManager = (ReplicaManager)tuple7._6();
        Cleaner cleaner = (Cleaner)tuple7._7();
        return new MergedLogHarness(log, epoch, params, throttler, (Cleaner)var49_46, false, (TierTasksConfig)var43_40, (ArchiveTask)var44_41, (CompactionTask)var45_42, (TierTopicAppender)var46_43, tierObjectStore, (CopyOnWriteArrayList<AbstractTierMetadata>)var47_44, (ReplicaManager)var48_45);
    }

    public void dropFirstRecordFromSegment(FileRecords inputFileRecords, FileRecords outputFileRecords) {
        ByteBuffer buffer = ByteBuffer.allocate(inputFileRecords.sizeInBytes());
        inputFileRecords.readInto(buffer, 0);
        inputFileRecords.close();
        MemoryRecords memoryRecords = new MemoryRecords(buffer);
        ByteBuffer filtered = ByteBuffer.allocate(inputFileRecords.sizeInBytes());
        int toDropCount = 1;
        IntRef droppedCount = IntRef.create((int)0);
        MemoryRecords.FilterResult filterResult = memoryRecords.filterTo(new TopicPartition("dummy", 0), new MemoryRecords.RecordFilter(droppedCount, toDropCount){
            private final IntRef droppedCount$1;
            private final int toDropCount$1;

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY, true);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                if (this.droppedCount$1.elem < this.toDropCount$1) {
                    ++this.droppedCount$1.elem;
                    return false;
                }
                return true;
            }
            {
                this.droppedCount$1 = droppedCount$1;
                this.toDropCount$1 = toDropCount$1;
                super(0L, 0L);
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("read: ").append(filterResult.messagesRead()).append(", retained: ").append(filterResult.messagesRetained()).toString());
        MemoryRecords newRecords = new MemoryRecords(filtered);
        outputFileRecords.append(newRecords);
        outputFileRecords.flush();
    }

    public boolean isAbortedProducerId(long producerId) {
        return producerId >= this.MinAbortedProducerId();
    }

    public static final /* synthetic */ void $anonfun$initializeComponents$1(TopicPartition x$1) {
    }

    public static final /* synthetic */ String $anonfun$apply$1(TopicIdPartition tpid$1) {
        return new StringBuilder(28).append("Creating partition for run: ").append(tpid$1).toString();
    }

    private MergedLogHarness$() {
    }
}

