/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.Cleaner;
import kafka.log.HarnessParams;
import kafka.log.LogCleanerManager$;
import kafka.log.LogManager$;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.MergedLogStateSnapshot;
import kafka.log.OffsetsToClean;
import kafka.log.RecordState;
import kafka.log.RecordState$;
import kafka.log.SegmentFields;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.log.ValidateLogResult$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationKey;
import kafka.server.ReplicaManager;
import kafka.tier.DeletionState;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializingState$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchDataInfo;
import kafka.tier.fetcher.TierFetchResult;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.FaultInjectedTierObjectStoreWrapper;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.test.TestUtils;
import org.mockito.Mockito;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r\u001du!B'O\u0011\u0003\u0019f!B+O\u0011\u00031\u0006\"B2\u0002\t\u0003!\u0007bB3\u0002\u0005\u0004%\tA\u001a\u0005\u0007U\u0006\u0001\u000b\u0011B4\t\u000f-\f!\u0019!C\u0001Y\"110\u0001Q\u0001\n5Dq\u0001`\u0001C\u0002\u0013\u0005a\r\u0003\u0004~\u0003\u0001\u0006Ia\u001a\u0005\b}\u0006\u0011\r\u0011\"\u0001g\u0011\u0019y\u0018\u0001)A\u0005O\"I\u0011\u0011A\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003\u0017\t\u0001\u0015!\u0003\u0002\u0006!9\u0011QB\u0001\u0005\u0002\u0005=\u0001bBAQ\u0003\u0011\u0005\u00111\u0015\u0005\b\u0007O\nA\u0011AB5\u0011\u001d\u0019y(\u0001C\u0001\u0007\u00033Q!\u0016(\u0001\u0003OC\u0011bT\t\u0003\u0002\u0004%\t!!+\t\u0015\u0005-\u0016C!a\u0001\n\u0003\ti\u000b\u0003\u0006\u0002:F\u0011\t\u0011)Q\u0005\u0003\u0007C\u0011\"a/\u0012\u0005\u0003\u0007I\u0011\u00014\t\u0015\u0005u\u0016C!a\u0001\n\u0003\ty\fC\u0005\u0002DF\u0011\t\u0011)Q\u0005O\"Q\u0011QS\t\u0003\u0006\u0004%\t!!2\t\u0015\u0005\u001d\u0017C!A!\u0002\u0013\t9\n\u0003\u0006\u0002\fF\u0011)\u0019!C\u0001\u0003\u0013D!\"a3\u0012\u0005\u0003\u0005\u000b\u0011BAG\u0011)\ti-\u0005BA\u0002\u0013\u0005\u0011q\u001a\u0005\u000b\u0003#\f\"\u00111A\u0005\u0002\u0005M\u0007BCAl#\t\u0005\t\u0015)\u0003\u0002|!Q\u0011\u0011\\\t\u0003\u0002\u0004%\t!a7\t\u0015\u0005\r\u0018C!a\u0001\n\u0003\t)\u000f\u0003\u0006\u0002jF\u0011\t\u0011)Q\u0005\u0003;D!\"a;\u0012\u0005\u0003\u0007I\u0011AAw\u0011)\ty/\u0005BA\u0002\u0013\u0005\u0011\u0011\u001f\u0005\u000b\u0003k\f\"\u0011!Q!\n\u0005]\u0001BCA|#\t\u0005\r\u0011\"\u0001\u0002z\"Q\u00111`\t\u0003\u0002\u0004%\t!!@\t\u0015\t\u0005\u0011C!A!B\u0013\tY\u0003\u0003\u0006\u0003\u0004E\u0011\t\u0019!C\u0001\u0005\u000bA!Ba\u0002\u0012\u0005\u0003\u0007I\u0011\u0001B\u0005\u0011)\u0011i!\u0005B\u0001B\u0003&\u0011q\u0007\u0005\u000b\u0005\u001f\t\"\u00111A\u0005\u0002\tE\u0001B\u0003B\n#\t\u0005\r\u0011\"\u0001\u0003\u0016!Q!\u0011D\t\u0003\u0002\u0003\u0006K!a\u0011\t\u0015\tm\u0011C!b\u0001\n\u0003\u0011i\u0002\u0003\u0006\u0003,E\u0011\t\u0011)A\u0005\u0005?A!B!\f\u0012\u0005\u0003\u0007I\u0011\u0001B\u0018\u0011)\u0011\t$\u0005BA\u0002\u0013\u0005!1\u0007\u0005\u000b\u0005o\t\"\u0011!Q!\n\u0005=\u0003B\u0003B\u001d#\t\u0005\r\u0011\"\u0001\u0003<!Q!QH\t\u0003\u0002\u0004%\tAa\u0010\t\u0015\t\r\u0013C!A!B\u0013\ty\u0007\u0003\u0004d#\u0011\u0005!Q\t\u0005\n\u0005C\n\"\u0019!C\u0001\u0005GB\u0001Ba\u001d\u0012A\u0003%!Q\r\u0005\b\u0005k\nB\u0011\u0001B<\u0011\u001d\u0011I(\u0005C\u0001\u0005oBqAa\u001f\u0012\t\u0003\u0011i\bC\u0004\u0003\u0004F!\tA!\"\t\u000f\t\r\u0015\u0003\"\u0001\u0003&\"9!\u0011W\t\u0005\u0002\tM\u0006\"\u0003Br#E\u0005I\u0011\u0001Bs\u0011\u001d\u0011Y0\u0005C\u0001\u0005oBqA!@\u0012\t\u0003\u0011y\u0010C\u0004\u0004\u0006E!\taa\u0002\t\u000f\r=\u0011\u0003\"\u0003\u0002\u0004!91\u0011C\t\u0005\u0002\rM\u0001bBB\u000b#\u0011\u00051q\u0003\u0005\b\u00073\tB\u0011AB\u000e\u0011%\u0019I$EI\u0001\n\u0003\u0019Y\u0004C\u0004\u0004\u001aE!\taa\u0010\t\u000f\r-\u0013\u0003\"\u0003\u0002\u0004!91QJ\t\u0005\n\r=\u0003bBB*#\u0011\u0005!q\u000f\u0005\b\u0007+\nB\u0011\u0002B<\u0003AiUM]4fI2{w\rS1s]\u0016\u001c8O\u0003\u0002P!\u0006\u0019An\\4\u000b\u0003E\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002U\u00035\taJ\u0001\tNKJ<W\r\u001a'pO\"\u000b'O\\3tgN\u0019\u0011aV/\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\r\u0005s\u0017PU3g!\tq\u0016-D\u0001`\u0015\t\u0001\u0007+A\u0003vi&d7/\u0003\u0002c?\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001T\u0003]i\u0015\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/F\u0001h!\tA\u0006.\u0003\u0002j3\n\u0019\u0011J\u001c;\u000215\u000b\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-F\u0001n!\tq\u00170D\u0001p\u0015\ty\u0005O\u0003\u0002re\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003gR\fqa\u001d;pe\u0006<WM\u0003\u0002Rk*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQxN\u0001\u000eQe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-A\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw\rI\u0001$!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'t\u0003\u0011\u0002&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]\u000eCWmY6J]R,'O^1m\u001bN\u0004\u0013\u0001\u0003\"s_.,'/\u00133\u0002\u0013\t\u0013xn[3s\u0013\u0012\u0004\u0013\u0001F'j]\u0006\u0013wN\u001d;fIB\u0013x\u000eZ;dKJLE-\u0006\u0002\u0002\u0006A\u0019\u0001,a\u0002\n\u0007\u0005%\u0011L\u0001\u0003M_:<\u0017!F'j]\u0006\u0013wN\u001d;fIB\u0013x\u000eZ;dKJLE\rI\u0001\u0015S:LG/[1mSj,7i\\7q_:,g\u000e^:\u0015\u0015\u0005E\u0011\u0011QAE\u0003'\u000bi\nE\tY\u0003'\t9\"a\u000b\u00028\u0005\r\u0013qJA8\u0003wJ1!!\u0006Z\u0005\u0019!V\u000f\u001d7foA!\u0011\u0011DA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011AB2p]\u001aLwM\u0003\u0003\u0002\"\u0005\r\u0012!\u0002;bg.\u001c(bAA\u0013!\u0006!A/[3s\u0013\u0011\tI#a\u0007\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0005\u0003c\ty\"A\u0004be\u000eD\u0017N^3\n\t\u0005U\u0012q\u0006\u0002\f\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8\u000e\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\u0011\ti$a\b\u0002\u0015\r|W\u000e]1di&|g.\u0003\u0003\u0002B\u0005m\"AD\"p[B\f7\r^5p]R\u000b7o\u001b\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)!\u0011\u0011JA\u0012\u0003\u0015!x\u000e]5d\u0013\u0011\ti%a\u0012\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0004\u0002R\u0005}\u00131M\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005e\u00131L\u0001\u0005kRLGN\u0003\u0002\u0002^\u0005!!.\u0019<b\u0013\u0011\t\t'a\u0015\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$\u0002BA5\u0003G\ta\u0001Z8nC&t\u0017\u0002BA7\u0003O\u0012A#\u00112tiJ\f7\r\u001e+jKJlU\r^1eCR\f\u0007\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U\u0004+\u0001\u0004tKJ4XM]\u0005\u0005\u0003s\n\u0019H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007Q\u000bi(C\u0002\u0002\u00009\u0013qa\u00117fC:,'\u000f\u0003\u0004P\u001b\u0001\u0007\u00111\u0011\t\u0004)\u0006\u0015\u0015bAAD\u001d\nIQ*\u001a:hK\u0012dun\u001a\u0005\b\u0003\u0017k\u0001\u0019AAG\u0003%!\bN]8ui2,'\u000fE\u0002_\u0003\u001fK1!!%`\u0005%!\u0006N]8ui2,'\u000fC\u0004\u0002\u00166\u0001\r!a&\u0002\rA\f'/Y7t!\r!\u0016\u0011T\u0005\u0004\u00037s%!\u0004%be:,7o\u001d)be\u0006l7\u000f\u0003\u0004\u0002 6\u0001\raZ\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\u0003baBd\u0017\u0010\u0006\u0005\u0002&\u000e]31MB3!\t!\u0016cE\u0002\u0012/v+\"!a!\u0002\u000f1|wm\u0018\u0013fcR!\u0011qVA[!\rA\u0016\u0011W\u0005\u0004\u0003gK&\u0001B+oSRD\u0011\"a.\u0014\u0003\u0003\u0005\r!a!\u0002\u0007a$\u0013'\u0001\u0003m_\u001e\u0004\u0013!B3q_\u000eD\u0017!C3q_\u000eDw\fJ3r)\u0011\ty+!1\t\u0011\u0005]f#!AA\u0002\u001d\fa!\u001a9pG\"\u0004SCAAL\u0003\u001d\u0001\u0018M]1ng\u0002*\"!!$\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005m\u0014aC2mK\u0006tWM]0%KF$B!a,\u0002V\"I\u0011qW\u000f\u0002\u0002\u0003\u0007\u00111P\u0001\tG2,\u0017M\\3sA\u0005iQM^3s\u0007>l\u0007/Y2uK\u0012,\"!!8\u0011\u0007a\u000by.C\u0002\u0002bf\u0013qAQ8pY\u0016\fg.A\tfm\u0016\u00148i\\7qC\u000e$X\rZ0%KF$B!a,\u0002h\"I\u0011q\u0017\u0011\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u000fKZ,'oQ8na\u0006\u001cG/\u001a3!\u0003=!\u0018.\u001a:UCN\\7oQ8oM&<WCAA\f\u0003M!\u0018.\u001a:UCN\\7oQ8oM&<w\fJ3r)\u0011\ty+a=\t\u0013\u0005]6%!AA\u0002\u0005]\u0011\u0001\u0005;jKJ$\u0016m]6t\u0007>tg-[4!\u0003-\t'o\u00195jm\u0016$\u0016m]6\u0016\u0005\u0005-\u0012aD1sG\"Lg/\u001a+bg.|F%Z9\u0015\t\u0005=\u0016q \u0005\n\u0003o3\u0013\u0011!a\u0001\u0003W\tA\"\u0019:dQ&4X\rV1tW\u0002\nabY8na\u0006\u001cG/[8o)\u0006\u001c8.\u0006\u0002\u00028\u0005\u00112m\\7qC\u000e$\u0018n\u001c8UCN\\w\fJ3r)\u0011\tyKa\u0003\t\u0013\u0005]\u0016&!AA\u0002\u0005]\u0012aD2p[B\f7\r^5p]R\u000b7o\u001b\u0011\u0002\u0011\u0005\u0004\b/\u001a8eKJ,\"!a\u0011\u0002\u0019\u0005\u0004\b/\u001a8eKJ|F%Z9\u0015\t\u0005=&q\u0003\u0005\n\u0003oc\u0013\u0011!a\u0001\u0003\u0007\n\u0011\"\u00199qK:$WM\u001d\u0011\u0002\u0017=\u0014'.Z2u'R|'/Z\u000b\u0003\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0005\u0005K\t\u0019#A\u0003ti>\u0014X-\u0003\u0003\u0003*\t\r\"a\t$bk2$\u0018J\u001c6fGR,G\rV5fe>\u0013'.Z2u'R|'/Z,sCB\u0004XM]\u0001\r_\nTWm\u0019;Ti>\u0014X\rI\u0001\u0011CB\u0004XM\u001c3fI6+G/\u00193bi\u0006,\"!a\u0014\u0002)\u0005\u0004\b/\u001a8eK\u0012lU\r^1eCR\fw\fJ3r)\u0011\tyK!\u000e\t\u0013\u0005]\u0016'!AA\u0002\u0005=\u0013!E1qa\u0016tG-\u001a3NKR\fG-\u0019;bA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA8\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005=&\u0011\t\u0005\n\u0003o#\u0014\u0011!a\u0001\u0003_\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u000b\u001d\u0003K\u00139E!\u0013\u0003L\t5#q\nB)\u0005'\u0012)Fa\u0016\u0003Z\tm#Q\fB0\u0011\u0019ye\u00071\u0001\u0002\u0004\"1\u00111\u0018\u001cA\u0002\u001dDq!!&7\u0001\u0004\t9\nC\u0004\u0002\fZ\u0002\r!!$\t\u000f\u00055g\u00071\u0001\u0002|!9\u0011\u0011\u001c\u001cA\u0002\u0005u\u0007bBAvm\u0001\u0007\u0011q\u0003\u0005\b\u0003o4\u0004\u0019AA\u0016\u0011\u001d\u0011\u0019A\u000ea\u0001\u0003oAqAa\u00047\u0001\u0004\t\u0019\u0005C\u0004\u0003\u001cY\u0002\rAa\b\t\u000f\t5b\u00071\u0001\u0002P!9!\u0011\b\u001cA\u0002\u0005=\u0014aB7fiJL7m]\u000b\u0003\u0005K\u0002BAa\u001a\u0003p5\u0011!\u0011\u000e\u0006\u0005\u0005C\u0012YGC\u0002\u0003nQ\faaY8n[>t\u0017\u0002\u0002B9\u0005S\u0012q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u001d!Wm\u001d;s_f$\"!a,\u0002/Y\fG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKR,\u0017A\u0002:f_B,g\u000e\u0006\u0003\u00020\n}\u0004b\u0002BAw\u0001\u0007\u0011Q\\\u0001\nk:4G.^:iK\u0012\fA\"\u001e9eCR,7i\u001c8gS\u001e$b!a,\u0003\b\n\u0005\u0006b\u0002BEy\u0001\u0007!1R\u0001\u0004W\u0016L\b\u0003\u0002BG\u00057sAAa$\u0003\u0018B\u0019!\u0011S-\u000e\u0005\tM%b\u0001BK%\u00061AH]8pizJ1A!'Z\u0003\u0019\u0001&/\u001a3fM&!!Q\u0014BP\u0005\u0019\u0019FO]5oO*\u0019!\u0011T-\t\u000f\t\rF\b1\u0001\u0003\f\u0006)a/\u00197vKR!\u0011q\u0016BT\u0011\u001d\u0011I+\u0010a\u0001\u0005W\u000b\u0011B\\3x\u0007>tg-[4\u0011\u00079\u0014i+C\u0002\u00030>\u0014\u0011\u0002T8h\u0007>tg-[4\u0002%I,\u0017\rZ&fsN\fe\u000eZ(gMN,Go\u001d\u000b\u0005\u0005k\u0013y\u000eE\u0004Y\u0005o\u0013YL!3\n\u0007\te\u0016L\u0001\u0004UkBdWM\r\t\t\u0005{\u0013yLa1\u0002\u00065\u0011\u0011qK\u0005\u0005\u0005\u0003\f9FA\u0004ICNDW*\u00199\u0011\u000ba\u0013)Ma#\n\u0007\t\u001d\u0017L\u0001\u0004PaRLwN\u001c\t\u0007\u0005\u0017\u0014)N!7\u000e\u0005\t5'\u0002\u0002Bh\u0005#\fq!\\;uC\ndWMC\u0002\u0003Tf\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119N!4\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0002U\u00057L1A!8O\u0005-\u0011VmY8sIN#\u0018\r^3\t\u0013\t\u0005h\b%AA\u0002\u0005u\u0017!F3yG2,H-Z!c_J$X\r\u001a*fG>\u0014Hm]\u0001\u001de\u0016\fGmS3zg\u0006sGm\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119O\u000b\u0003\u0002^\n%8F\u0001Bv!\u0011\u0011iOa>\u000e\u0005\t=(\u0002\u0002By\u0005g\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tU\u0018,\u0001\u0006b]:|G/\u0019;j_:LAA!?\u0003p\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0015Y,'/\u001b4z)bt7/\u0001\u0007bIZ\fgnY3DY>\u001c7\u000e\u0006\u0003\u00020\u000e\u0005\u0001bBB\u0002\u0003\u0002\u0007\u0011QA\u0001\u0003[N\f\u0011\u0003^1lKN#\u0018\r^3T]\u0006\u00048\u000f[8u)\t\u0019I\u0001E\u0002U\u0007\u0017I1a!\u0004O\u0005YiUM]4fI2{wm\u0015;bi\u0016\u001cf.\u00199tQ>$\u0018\u0001D4fi2{7o]\"pk:$\u0018\u0001E7bs\n,G+[3s'\u0016<W.\u001a8u)\t\ti.A\u0007uS\u0016\u0014(+\u001a;f]RLwN\u001c\u000b\u0002O\u0006QQ.Y=cK\u000ecW-\u00198\u0015\t\ru1q\u0004\t\b1\n]\u0016QAA\u0003\u0011%\u0019\tC\u0012I\u0001\u0002\u0004\u0019\u0019#\u0001\rfqB,7\r^3e-\u0006d\u0017\u000eZ1uS>t'+Z:vYR\u0004Ba!\n\u000449!1qEB\u0018\u001d\u0011\u0019Ic!\f\u000f\t\tE51F\u0005\u0002#&\u0011q\nU\u0005\u0004\u0007cq\u0015!\u0005,bY&$\u0017\r^3M_\u001e\u0014Vm];mi&!1QGB\u001c\u0005E1\u0016\r\\5eCR,Gj\\4SKN,H\u000e\u001e\u0006\u0004\u0007cq\u0015\u0001F7bs\n,7\t\\3b]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004>)\"11\u0005Bu)!\u0019ib!\u0011\u0004F\r%\u0003bBB\"\u0011\u0002\u0007\u0011Q\\\u0001\u0006Y>\u001c\u0017\r\u001c\u0005\b\u0007\u000fB\u0005\u0019AAo\u0003\u0019!\u0018.\u001a:fI\"91\u0011\u0005%A\u0002\r\r\u0012aD7bs\n,Gj\\2bY\u000ecW-\u00198\u0002\u001d5\f\u0017PY3US\u0016\u00148\t\\3b]R!\u0011QAB)\u0011\u001d\u0019\tC\u0013a\u0001\u0007G\t\u0001c]5nk2\fG/\u001a#bi\u0006dun]:\u00021\u0011,G.\u001a;f\r&\u00148\u000f\u001e+jKJ,GmU3h[\u0016tG\u000fC\u0004\u0004Z9\u0001\raa\u0017\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1QLB0\u001b\t\u0011Y'\u0003\u0003\u0004b\t-$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003;q\u0001\u0019\u0001BV\u0011\u001d\t)J\u0004a\u0001\u0003/\u000b!\u0004\u001a:pa\u001aK'o\u001d;SK\u000e|'\u000f\u001a$s_6\u001cVmZ7f]R$b!a,\u0004l\rm\u0004bBB7\u001f\u0001\u00071qN\u0001\u0011S:\u0004X\u000f\u001e$jY\u0016\u0014VmY8sIN\u0004Ba!\u001d\u0004x5\u001111\u000f\u0006\u0005\u0007k\u0012Y'\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0007s\u001a\u0019HA\u0006GS2,'+Z2pe\u0012\u001c\bbBB?\u001f\u0001\u00071qN\u0001\u0012_V$\b/\u001e;GS2,'+Z2pe\u0012\u001c\u0018aE5t\u0003\n|'\u000f^3e!J|G-^2fe&#G\u0003BAo\u0007\u0007Cqa!\"\u0011\u0001\u0004\t)!\u0001\u0006qe>$WoY3s\u0013\u0012\u0004")
public class MergedLogHarness
implements Logging {
    private MergedLog log;
    private int epoch;
    private final HarnessParams params;
    private final Throttler throttler;
    private Cleaner cleaner;
    private boolean everCompacted;
    private TierTasksConfig tierTasksConfig;
    private ArchiveTask archiveTask;
    private CompactionTask compactionTask;
    private TierTopicAppender appender;
    private final FaultInjectedTierObjectStoreWrapper objectStore;
    private CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata;
    private ReplicaManager replicaManager;
    private final Metrics metrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean isAbortedProducerId(long producerId) {
        return MergedLogHarness$.MODULE$.isAbortedProducerId(producerId);
    }

    public static void dropFirstRecordFromSegment(FileRecords inputFileRecords, FileRecords outputFileRecords) {
        MergedLogHarness$.MODULE$.dropFirstRecordFromSegment(inputFileRecords, outputFileRecords);
    }

    public static MergedLogHarness apply(TopicPartition topicPartition, LogConfig config, HarnessParams params) {
        return MergedLogHarness$.MODULE$.apply(topicPartition, config, params);
    }

    public static Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> initializeComponents(MergedLog log, Throttler throttler, HarnessParams params, int leaderEpoch) {
        return MergedLogHarness$.MODULE$.initializeComponents(log, throttler, params, leaderEpoch);
    }

    public static long MinAbortedProducerId() {
        return MergedLogHarness$.MODULE$.MinAbortedProducerId();
    }

    public static int BrokerId() {
        return MergedLogHarness$.MODULE$.BrokerId();
    }

    public static int ProducerIdExpirationCheckIntervalMs() {
        return MergedLogHarness$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public static ProducerStateManagerConfig producerStateManagerConfig() {
        return MergedLogHarness$.MODULE$.producerStateManagerConfig();
    }

    public static int MaxTransactionTimeoutMs() {
        return MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MergedLog log() {
        return this.log;
    }

    public void log_$eq(MergedLog x$1) {
        this.log = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public HarnessParams params() {
        return this.params;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(Cleaner x$1) {
        this.cleaner = x$1;
    }

    public boolean everCompacted() {
        return this.everCompacted;
    }

    public void everCompacted_$eq(boolean x$1) {
        this.everCompacted = x$1;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public void tierTasksConfig_$eq(TierTasksConfig x$1) {
        this.tierTasksConfig = x$1;
    }

    public ArchiveTask archiveTask() {
        return this.archiveTask;
    }

    public void archiveTask_$eq(ArchiveTask x$1) {
        this.archiveTask = x$1;
    }

    public CompactionTask compactionTask() {
        return this.compactionTask;
    }

    public void compactionTask_$eq(CompactionTask x$1) {
        this.compactionTask = x$1;
    }

    public TierTopicAppender appender() {
        return this.appender;
    }

    public void appender_$eq(TierTopicAppender x$1) {
        this.appender = x$1;
    }

    public FaultInjectedTierObjectStoreWrapper objectStore() {
        return this.objectStore;
    }

    public CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata() {
        return this.appendedMetadata;
    }

    public void appendedMetadata_$eq(CopyOnWriteArrayList<AbstractTierMetadata> x$1) {
        this.appendedMetadata = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void destroy() {
        this.log().info((Function0 & Serializable)() -> new StringBuilder(27).append("Final log at destroy time: ").append(this.log()).toString());
        this.validatePartitionDelete();
        this.log().time().sleep(10000L);
        this.log().close();
        Utils.delete((File)this.log().dir().getParentFile(), (boolean)false);
        this.objectStore().close();
        Mockito.framework().clearInlineMocks();
        this.log_$eq(null);
    }

    public void validatePartitionDelete() {
        this.log().topicIdPartition().foreach((Function1 & Serializable)topicIdPartition -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$1(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void reopen(boolean unflushed) {
        void var34_31;
        void var33_30;
        void var31_28;
        void var30_27;
        void var29_26;
        void var28_25;
        void var32_29;
        MockTime time = (MockTime)this.log().localLog().time();
        MockScheduler scheduler = time.scheduler;
        long recoveryPoint = unflushed ? this.log().recoveryPoint() : 0L;
        File logDir = this.log().localLog().dir();
        long logStartOffset = this.log().logStartOffset();
        long hwm = this.log().highWatermark();
        LogConfig logConfig = this.log().config();
        TierLogComponents tierLogComponents = this.log().tierLogComponents();
        LogDirFailureChannel logDirFailureChannel = this.log().localLog().logDirFailureChannel();
        int nextEpoch = this.epoch() + 1;
        this.log().close();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = this.metrics();
        int x$9 = MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs();
        ProducerStateManagerConfig x$10 = MergedLogHarness$.MODULE$.producerStateManagerConfig();
        int x$11 = MergedLogHarness$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        None$ x$12 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        ChecksumParams x$18 = TestUtils$.MODULE$.createChecksumParams();
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        MergedLog newLog = MergedLog$.MODULE$.apply(logDir, logConfig, logStartOffset, recoveryPoint, (Scheduler)scheduler, x$6, x$7, (Time)time, x$9, x$10, x$11, (Option)x$12, logDirFailureChannel, tierLogComponents, unflushed, (Option)x$16, true, x$19, (Option)x$20, x$21, x$18);
        if (newLog.config().confluentLogConfig().tierEnable()) {
            newLog.tierPartitionState().setTieringEnabled();
            MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(newLog);
        }
        newLog.updateHighWatermark(hwm);
        this.compactionTask().offsetMapSupplier().close();
        Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> tuple7 = MergedLogHarness$.MODULE$.initializeComponents(newLog, this.throttler(), this.params(), nextEpoch);
        if (tuple7 == null) {
            throw new MatchError(null);
        }
        TierTasksConfig newTierTasksConfig = (TierTasksConfig)tuple7._1();
        ArchiveTask newArchiveTask = (ArchiveTask)tuple7._2();
        CompactionTask newCompactionTask = (CompactionTask)tuple7._3();
        TierTopicAppender newAppender = (TierTopicAppender)tuple7._4();
        CopyOnWriteArrayList newAppendedMetadata = (CopyOnWriteArrayList)tuple7._5();
        ReplicaManager newReplicaManager = (ReplicaManager)tuple7._6();
        Cleaner newCleaner = (Cleaner)tuple7._7();
        var32_29.addAll(this.appendedMetadata());
        this.log_$eq(newLog);
        this.tierTasksConfig_$eq((TierTasksConfig)var28_25);
        this.archiveTask_$eq((ArchiveTask)var29_26);
        this.compactionTask_$eq((CompactionTask)var30_27);
        this.appender_$eq((TierTopicAppender)var31_28);
        this.appendedMetadata_$eq((CopyOnWriteArrayList<AbstractTierMetadata>)var32_29);
        this.replicaManager_$eq((ReplicaManager)var33_30);
        this.cleaner_$eq((Cleaner)var34_31);
        this.epoch_$eq(nextEpoch);
    }

    public void updateConfig(String key, String value) {
        Map map = this.log().config().originals();
        map.put(key, value);
        this.log().updateConfig(new LogConfig(map));
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public void updateConfig(LogConfig newConfig) {
        this.log().updateConfig(newConfig);
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> readKeysAndOffsets(boolean excludeAbortedRecords) {
        this.verifyTxns();
        FetchOffsetCache fetchOffsetCache = new FetchOffsetCache(this.log().localLog().time(), 1000, 1000);
        MemoryTracker memoryTracker = new MemoryTracker(this.log().localLog().time(), Long.MAX_VALUE);
        ArrayList ignored = new ArrayList(0);
        Consumer<DelayedOperationKey> callback = new Consumer<DelayedOperationKey>(null){

            public Consumer<DelayedOperationKey> andThen(Consumer<? super DelayedOperationKey> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(DelayedOperationKey t) {
            }
        };
        LongRef fetchOffset = LongRef.create((long)this.log().logStartOffset());
        HashMap offsetMap = new HashMap();
        ListBuffer records = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef priorOffsetRead = ObjectRef.create((Object)None$.MODULE$);
        while (fetchOffset.elem < this.log().logEndOffset()) {
            long startFetchOffset = fetchOffset.elem;
            AbstractFetchDataInfo fetchInfo = this.log().read(fetchOffset.elem, this.params().readSize(), FetchIsolation.LOG_END, true, true);
            if (fetchInfo instanceof FetchDataInfo) {
                FetchDataInfo fetchDataInfo = (FetchDataInfo)fetchInfo;
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    this.process$1(batch, excludeAbortedRecords, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
                if (fetchDataInfo.fetchOffsetMetadata.messageOffset == this.log().logEndOffset() && CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty() && this.log().activeSegment().size() == 0) {
                    fetchOffset.elem = fetchDataInfo.fetchOffsetMetadata.messageOffset;
                }
            } else if (fetchInfo instanceof TierFetchDataInfo) {
                TierFetchDataInfo tierFetchDataInfo = (TierFetchDataInfo)fetchInfo;
                PendingFetch fetch = new PendingFetch(CancellationContext.newContext(), ((FaultInjectedTierObjectStoreWrapper)this.log().tierLogComponents().objectStoreOpt().get()).innerTierObjectStore(), fetchOffsetCache, Optional.empty(), tierFetchDataInfo.fetchMetadata().segmentMetadata(), (Consumer)callback, fetchOffset.elem, this.params().readSize(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED, memoryTracker, ignored, this.log().localLog().time());
                fetch.run();
                TierFetchResult result = (TierFetchResult)fetch.finish().get(this.log().topicPartition());
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    this.process$1(batch, excludeAbortedRecords, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(fetchInfo.getClass()).toString());
            }
            Predef$.MODULE$.assert(fetchOffset.elem != startFetchOffset || fetchOffset.elem == this.log().logEndOffset(), (Function0 & Serializable)() -> new StringBuilder(34).append("fetch offset didn't advance after ").append(fetchOffset$1.elem).toString());
        }
        return new Tuple2(offsetMap, (Object)records);
    }

    public boolean readKeysAndOffsets$default$1() {
        return false;
    }

    public void verifyTxns() {
        FetchOffsetCache fetchOffsetCache = new FetchOffsetCache(this.log().localLog().time(), 1000, 1000);
        MemoryTracker memoryTracker = new MemoryTracker(this.log().localLog().time(), Long.MAX_VALUE);
        ArrayList ignored = new ArrayList(0);
        Consumer<DelayedOperationKey> callback = new Consumer<DelayedOperationKey>(null){

            public Consumer<DelayedOperationKey> andThen(Consumer<? super DelayedOperationKey> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(DelayedOperationKey t) {
            }
        };
        LongRef fetchOffset = LongRef.create((long)this.log().logStartOffset());
        long endpoint = this.log().lastStableOffset();
        while (fetchOffset.elem < endpoint) {
            long startFetchOffset = fetchOffset.elem;
            AbstractFetchDataInfo fetchInfo = this.log().read(fetchOffset.elem, this.params().readSize(), FetchIsolation.TXN_COMMITTED, true, false);
            if (fetchInfo instanceof FetchDataInfo) {
                FetchDataInfo fetchDataInfo = (FetchDataInfo)fetchInfo;
                scala.collection.immutable.Set abortedProducerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)fetchDataInfo.abortedTransactions.get()).asScala().map((Function1 & Serializable)abort -> BoxesRunTime.boxToLong((long)abort.producerId()))).toSet();
                scala.collection.immutable.Set abortedProducerIdsFromRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().filter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$verifyTxns$2(batch)))).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.producerId()))).toSet();
                Predef$.MODULE$.assert(abortedProducerIdsFromRecords.subsetOf((Set)abortedProducerIds), (Function0 & Serializable)() -> new StringBuilder(86).append("Aborted producer ids collected from records: ").append(abortedProducerIdsFromRecords).append(" vs aborted producer ids from txn index: ").append(abortedProducerIds).toString());
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
                if (fetchDataInfo.fetchOffsetMetadata.messageOffset == endpoint && CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty() && this.log().activeSegment().size() == 0) {
                    fetchOffset.elem = fetchDataInfo.fetchOffsetMetadata.messageOffset;
                }
            } else if (fetchInfo instanceof TierFetchDataInfo) {
                TierFetchDataInfo tierFetchDataInfo = (TierFetchDataInfo)fetchInfo;
                PendingFetch fetch = new PendingFetch(CancellationContext.newContext(), ((FaultInjectedTierObjectStoreWrapper)this.log().tierLogComponents().objectStoreOpt().get()).innerTierObjectStore(), fetchOffsetCache, Optional.empty(), tierFetchDataInfo.fetchMetadata().segmentMetadata(), (Consumer)callback, fetchOffset.elem, this.params().readSize(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, memoryTracker, ignored, this.log().localLog().time());
                fetch.run();
                TierFetchResult result = (TierFetchResult)fetch.finish().get(this.log().topicPartition());
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    MergedLogHarness.process2$1(batch, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                scala.collection.immutable.Set abortedProducerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.abortedTxns).asScala().map((Function1 & Serializable)txn -> BoxesRunTime.boxToLong((long)txn.producerId()))).toSet();
                scala.collection.immutable.Set abortedProducerIdsFromRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().filter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$verifyTxns$8(batch)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.producerId()))).toSet();
                Predef$.MODULE$.assert(abortedProducerIdsFromRecords.subsetOf((Set)abortedProducerIds), (Function0 & Serializable)() -> new StringBuilder(86).append("Aborted producer ids collected from records: ").append(abortedProducerIdsFromRecords).append(" vs aborted producer ids from txn index: ").append(abortedProducerIds).toString());
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(fetchInfo.getClass()).toString());
            }
            if (fetchOffset.elem != startFetchOffset) continue;
            fetchOffset.elem = endpoint;
        }
    }

    public void advanceClock(long ms) {
        this.log().localLog().time().sleep(ms);
    }

    /*
     * WARNING - void declaration
     */
    public MergedLogStateSnapshot takeStateSnapshot() {
        void var3_3;
        void var2_2;
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.readKeysAndOffsets(true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Predef$.MODULE$.assert(!this.log().localLogSegments().stream().anyMatch(seg -> seg.readNextOffset() != seg.scanNextOffset()), (Function0 & Serializable)() -> "Next offset caching resulted in incorrect next offset");
        long lossCount = this.getLossCount();
        Predef$.MODULE$.assert(lossCount == 0L, (Function0 & Serializable)() -> "lossCount was > 0");
        return new MergedLogStateSnapshot(this.log().topicPartition(), this.log().time().milliseconds(), this.log().logStartOffset(), this.log().localLogStartOffset(), this.log().logEndOffset(), this.log().size(), this.log().tierPartitionState().totalSize(), this.log().highWatermark(), this.log().lastStableOffset(), (Vector<SegmentFields>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().localLogSegments()).asScala().map((Function1 & Serializable)seg -> new SegmentFields(seg.baseOffset(), seg.readNextOffset(), seg.getFirstBatchTimestamp(), seg.largestTimestamp(), seg.size()))).toVector(), (List<TierLogSegment>)this.log().tieredLogSegments().toList(), Predef$.MODULE$.Long2long(this.log().tierPartitionState().startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), this.log().tierPartitionState().endOffset(), this.log().tierPartitionState().committedEndOffset(), this.log().tierPartitionState().status(), (scala.collection.immutable.Map<Object, ProducerStateEntry>)CollectionConverters$.MODULE$.MapHasAsScala(this.log().producerStateManager().activeProducers()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Long k = (Long)x0$1._1();
                ProducerStateEntry v = (ProducerStateEntry)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)v.copy());
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (scala.collection.immutable.Map<Object, TxnMetadata>)CollectionConverters$.MODULE$.MapHasAsScala(this.log().producerStateManager().ongoingTxns()).asScala().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Long k = (Long)x0$2._1();
                TxnMetadata v = (TxnMetadata)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)new TxnMetadata(v.producerId, v.firstOffset, v.startTimeUpperBoundMs, v.lastOffset));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (HashMap<Option<String>, Object>)var2_2, (ListBuffer<RecordState>)var3_3);
    }

    private long getLossCount() {
        if (this.params().runDurabilityAudit()) {
            MockTime durabilityMockTime = new MockTime(this.log().time().milliseconds(), 0L);
            DurabilityMetricsManager metricsManager = (DurabilityMetricsManager)Mockito.mock(DurabilityMetricsManager.class);
            Mockito.when((Object)metricsManager.startAuditJob()).thenReturn((Object)Instant.ofEpochMilli(durabilityMockTime.milliseconds()));
            AuditReporter simpleReporter = new AuditReporter(metricsManager);
            AuditJobSummary simpleAuditSummary = new AuditJobSummary();
            DurabilityDB db = DurabilityDB$.MODULE$.apply(TestUtils.tempDirectory(null, null));
            DurabilityAuditConfig durabilityAuditConfig = (DurabilityAuditConfig)Mockito.mock(DurabilityAuditConfig.class);
            new BrokerAuditJob((Seq)new .colon.colon((Object)new Tuple2((Object)this.log().topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$), this.replicaManager().logManager(), new CountDownLatch(1), simpleReporter, simpleAuditSummary, 0, (Option)new Some((Object)this.objectStore()), (Time)durabilityMockTime, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), durabilityAuditConfig, db, (Option)None$.MODULE$, false, (Option)None$.MODULE$).run();
            return simpleReporter.getDurabilityCounters(this.log().topicPartition()).loss();
        }
        return 0L;
    }

    public boolean maybeTierSegment() {
        if (this.log().tierPartitionState().isTieringEnabled()) {
            boolean bl;
            if (this.archiveTask().state() instanceof BeforeLeader) {
                ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result.state() instanceof BeforeUpload);
            }
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            long initialTierEndOffset = this.log().tierPartitionState().endOffset();
            if (((ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).state() instanceof Upload) {
                ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result2.state() instanceof AfterUpload);
                ArchiveTask result3 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result3.state() instanceof BeforeUpload);
                this.log().tierPartitionState().flush();
                Predef$.MODULE$.assert(initialTierEndOffset != this.log().tierPartitionState().endOffset(), (Function0 & Serializable)() -> "tier end offset should have changed after upload");
                bl = true;
            } else {
                bl = false;
            }
            boolean uploaded = bl;
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            return uploaded;
        }
        return false;
    }

    public int tierRetention() {
        int deleted = 0;
        if (this.log().tierPartitionState().isTieringEnabled()) {
            try {
                DeletionTask.CollectDeletableObjects state = new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), this.log().tierPartitionState().tierEpoch()));
                DeletionTask.State currState = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                while (currState instanceof DeletionTask.InitiateDelete) {
                    DeletionTask.State state3 = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)currState.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(state3 instanceof DeletionTask.Delete);
                    DeletionTask.State completeDelete = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state3.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(completeDelete instanceof DeletionTask.CompleteDelete);
                    ++deleted;
                    Future nextIteration = (Future)Await$.MODULE$.ready((Awaitable)completeDelete.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    nextIteration.value().get();
                    currState = (DeletionTask.State)((Try)nextIteration.value().get()).get();
                }
                Predef$.MODULE$.assert(currState instanceof DeletionTask.CollectDeletableObjects);
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
        }
        return deleted;
    }

    public Tuple2<Object, Object> maybeClean(Enumeration.Value expectedValidationResult) {
        return this.maybeClean(true, true, expectedValidationResult);
    }

    public Tuple2<Object, Object> maybeClean(boolean local, boolean tiered, Enumeration.Value expectedValidationResult) {
        long localDirtyOffset = local ? this.maybeLocalClean() : -1L;
        long tierDirtyOffset = tiered ? this.maybeTierClean(expectedValidationResult) : -1L;
        return new Tuple2.mcJJ.sp(localDirtyOffset, tierDirtyOffset);
    }

    public Enumeration.Value maybeClean$default$1() {
        return ValidateLogResult$.MODULE$.Passed();
    }

    /*
     * WARNING - void declaration
     */
    private long maybeLocalClean() {
        if (this.log().isLocallyCompactable()) {
            OffsetsToClean cleaningPoint = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)this.log(), (Option)None$.MODULE$, this.log().localLog().time().milliseconds());
            LogToClean logToClean = new LogToClean(this.log().topicPartition(), (AbstractLog)this.log(), cleaningPoint.firstDirtyOffset(), cleaningPoint.firstUncleanableDirtyOffset(), true);
            if (logToClean.cleanableBytes() > 0L) {
                void var4_4;
                Tuple2 tuple2 = this.cleaner().clean((CleanParams)logToClean);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                long cleanedEndOffset = tuple2._1$mcJ$sp();
                this.everCompacted_$eq(true);
                return (long)var4_4;
            }
            return cleaningPoint.firstDirtyOffset();
        }
        return -1L;
    }

    private long maybeTierClean(Enumeration.Value expectedValidationResult) {
        if (this.log().isTierCompactable()) {
            try {
                if (CollectionConverters$.MODULE$.IteratorHasAsScala(this.log().tierPartitionState().segments()).asScala().nonEmpty()) {
                    long prevValidationFailedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count();
                    long prevValidationAbortedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count();
                    Await$.MODULE$.result((Awaitable)this.compactionTask().state().transition(this.compactionTask().ctx(), (TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.throttler(), this.compactionTask().offsetMapSupplier(), this.compactionTask().tierCompactionMetrics(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    Enumeration.Value value = expectedValidationResult;
                    Enumeration.Value value2 = ValidateLogResult$.MODULE$.Failed();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count() > prevValidationFailedCount, (Function0 & Serializable)() -> "dual compaction validation is expected to fail");
                    } else {
                        Enumeration.Value value3 = expectedValidationResult;
                        Enumeration.Value value4 = ValidateLogResult$.MODULE$.Aborted();
                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                            Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count() > prevValidationAbortedCount, (Function0 & Serializable)() -> "dual compaction validation is expected to abort");
                        }
                    }
                }
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
            this.everCompacted_$eq(true);
            return this.log().tierPartitionState().compactDirtyStartOffset();
        }
        return -1L;
    }

    public void simulateDataLoss() {
        this.deleteFirstTieredSegment();
    }

    private void deleteFirstTieredSegment() {
        TierLogSegment firstSegment = (TierLogSegment)this.log().tierPartitionState().segments().next();
        TierSegmentDeleteInitiate deleteInitiate = new TierSegmentDeleteInitiate(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch());
        this.appender().addMetadata((AbstractTierMetadata)deleteInitiate);
        this.objectStore().deleteSegment(firstSegment.metadata());
        TierSegmentDeleteComplete deleteComplete = new TierSegmentDeleteComplete(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), this.log().time().milliseconds());
        this.appender().addMetadata((AbstractTierMetadata)deleteComplete);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$2(InProgressDeletion inProgress$1, IntRef offset$1, AbstractTierMetadata metadata) {
        inProgress$1.process(metadata, new OffsetAndEpoch((long)offset$1.elem, Optional.of(Predef$.MODULE$.int2Integer(0))));
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$9(MergedLogHarness $this, ObjectMetadata seg) {
        $this.objectStore().innerTierObjectStore().deleteSegment(seg);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$1(MergedLogHarness $this, TopicIdPartition topicIdPartition) {
        ReplicaManager x$52 = $this.replicaManager();
        MockScheduler x$6 = ((MockTime)$this.log().localLog().time()).scheduler;
        MockTime x$7 = (MockTime)$this.log().localLog().time();
        scala.collection.mutable.Map x$8 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        TierPartitionStatus x$9 = TierPartitionStatus.INIT;
        MaterializingState$ x$10 = MaterializingState$.MODULE$;
        InProgressDeletion inProgress = new InProgressDeletion(0, topicIdPartition, 0L, null, x$8, x$9, (DeletionState)x$10, x$52, (Scheduler)x$6, (Time)x$7);
        IntRef offset = IntRef.create((int)0);
        CollectionConverters$.MODULE$.ListHasAsScala($this.appendedMetadata()).asScala().foreach((Function1 & Serializable)metadata -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$2(inProgress, offset, metadata);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set collectedIds = inProgress.allTieredObjects().map((Function1 & Serializable)x$3 -> x$3.objectId()).toSet();
        scala.collection.immutable.Set stateObjectIds = CollectionConverters$.MODULE$.IteratorHasAsScala($this.log().tierPartitionState().segments()).asScala().$plus$plus((Function0 & Serializable)() -> CollectionConverters$.MODULE$.CollectionHasAsScala($this.log().tierPartitionState().fencedSegments()).asScala()).$plus$plus((Function0 & Serializable)() -> CollectionConverters$.MODULE$.CollectionHasAsScala($this.log().tierPartitionState().compactedSegments()).asScala()).map((Function1 & Serializable)x$4 -> x$4.objectId()).toSet();
        Predef$.MODULE$.assert(stateObjectIds.diff((Set)collectedIds).isEmpty());
        String objectStorePrefix = new StringBuilder(1).append(((TopicIdPartition)$this.log().topicIdPartition().get()).toString()).append("/").toString();
        scala.collection.immutable.Set segmentsInObjectStore = CollectionConverters$.MODULE$.ListHasAsScala(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala().toList().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)k.endsWith(ObjectType.SEGMENT.suffix()))).toSet();
        scala.collection.immutable.Set toDeleteSegmentKeys = inProgress.allTieredObjects().map((Function1 & Serializable)x$5 -> ((FragmentLocation)x$5.toFragmentLocation(objectStorePrefix, FragmentType.SEGMENT).get()).objectPath()).toSet();
        Predef$.MODULE$.assert(segmentsInObjectStore.diff((Set)toDeleteSegmentKeys).isEmpty());
        inProgress.allTieredObjects().foreach((Function1 & Serializable)seg -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$9($this, seg);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(CollectionConverters$.MODULE$.ListHasAsScala(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$readKeysAndOffsets$1(MergedLogHarness $this, RecordBatch batch$1, boolean excludeAbortedRecords$1, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1, Record rec) {
        RecordState recordState = RecordState$.MODULE$.apply(batch$1, rec);
        if (!(batch$1.isControlBatch() || excludeAbortedRecords$1 && MergedLogHarness$.MODULE$.isAbortedProducerId(batch$1.producerId()))) {
            offsetMap$1.put(recordState.key(), BoxesRunTime.boxToLong((long)recordState.offset()));
        }
        records$1.$plus$eq((Object)recordState);
        if (!$this.log().config().compact()) {
            if (((Option)priorOffsetRead$1.elem).isEmpty()) {
                if (rec.offset() > fetchOffset$1.elem) {
                    throw new IllegalThreadStateException("First read offset should never skip forward from the first fetch offset.");
                }
            } else if (BoxesRunTime.unboxToLong((Object)((Option)priorOffsetRead$1.elem).get()) + 1L != rec.offset()) {
                throw new IllegalThreadStateException(new StringBuilder(53).append("Next read offset ").append(rec.offset()).append(" is not equal to prior offset + 1 (").append(fetchOffset$1.elem).append(")").toString());
            }
        }
        priorOffsetRead$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)rec.offset()));
    }

    private final void process$1(RecordBatch batch, boolean excludeAbortedRecords$1, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1) {
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)rec -> {
            MergedLogHarness.$anonfun$readKeysAndOffsets$1(this, batch, excludeAbortedRecords$1, offsetMap$1, records$1, priorOffsetRead$1, fetchOffset$1, rec);
            return BoxedUnit.UNIT;
        });
    }

    private static final void process2$1(RecordBatch batch, LongRef fetchOffset$2) {
        fetchOffset$2.elem = batch.lastOffset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$verifyTxns$2(RecordBatch batch) {
        return batch.isTransactional() && !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTxns$8(MutableRecordBatch batch) {
        return batch.isTransactional() && !batch.isControlBatch();
    }

    public MergedLogHarness(MergedLog log, int epoch, HarnessParams params, Throttler throttler, Cleaner cleaner, boolean everCompacted, TierTasksConfig tierTasksConfig, ArchiveTask archiveTask, CompactionTask compactionTask, TierTopicAppender appender, FaultInjectedTierObjectStoreWrapper objectStore, CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata, ReplicaManager replicaManager) {
        this.log = log;
        this.epoch = epoch;
        this.params = params;
        this.throttler = throttler;
        this.cleaner = cleaner;
        this.everCompacted = everCompacted;
        this.tierTasksConfig = tierTasksConfig;
        this.archiveTask = archiveTask;
        this.compactionTask = compactionTask;
        this.appender = appender;
        this.objectStore = objectStore;
        this.appendedMetadata = appendedMetadata;
        this.replicaManager = replicaManager;
        this.metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(this.metrics());
    }
}

