/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.durability.audit.manager.SegmentDeletionStats;
import kafka.log.AbstractLog;
import kafka.log.HotsetRetention$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.RetentionType;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.RequestLocal;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.OpaqueData;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergedLogTest$ {
    public static final MergedLogTest$ MODULE$ = new MergedLogTest$();

    public List<Record> allRecords(AbstractLog log) {
        ListBuffer recordsFound = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments()).asScala().foreach((Function1 & Serializable)logSegment -> {
            MergedLogTest$.$anonfun$allRecords$1(recordsFound, logSegment);
            return BoxedUnit.UNIT;
        });
        return recordsFound.toList();
    }

    public void verifyRecordsInLog(AbstractLog log, List<Record> expectedRecords) {
        Assertions.assertEquals(expectedRecords, this.allRecords(log));
    }

    public MemoryRecords createRecords(int segmentIdx, int messageIdx, long timestamp) {
        String segmentStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segmentIdx)}));
        String messageStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageIdx)}));
        byte[] x$1 = new StringBuilder(4).append("test").append(segmentStr).append(messageStr).toString().getBytes();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, x$5);
    }

    public int createRecords$default$1() {
        return 0;
    }

    public int createRecords$default$2() {
        return 0;
    }

    public long createRecords$default$3() {
        return -1L;
    }

    public void initializeTierMetadata(MergedLog log, TopicIdPartition topicIdPartition) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        log.setTopicId(topicIdPartition.kafkaTopicId());
        tierPartitionState.onCatchUpComplete();
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
    }

    public void createTieredSegments(MergedLog log, LogSegment segment, TopicIdPartition topicIdPartition, int epoch) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, epoch, UUID.randomUUID(), segment.baseOffset(), segment.offsetOfMaxTimestampSoFar(), segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, false, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        tierPartitionState.flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public int createTieredSegments$default$4() {
        return 0;
    }

    public MergedLog createLogWithOverlap(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk, ChecksumParams checksumParams) {
        int x$3 = logConfig.segmentSize;
        long x$4 = logConfig.segmentMs;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -2L;
        long x$9 = 0L;
        String x$10 = "delete";
        int x$11 = 0x10000C;
        int x$12 = 4096;
        int x$13 = 0xA00000;
        String x$14 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$15 = 60000L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, x$6, x$7, 1L, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, true, 1L, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        ProducerStateManagerConfig x$31 = new ProducerStateManagerConfig(maxProducerIdExpirationMs, false);
        LogDirFailureChannel x$35 = new LogDirFailureChannel(10);
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        ObjectRef log = ObjectRef.create((Object)LogTestUtils$.MODULE$.createLog(dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, x$31, producerIdExpirationCheckIntervalMs, tierLogComponents, x$35, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, checksumParams));
        ObjectRef tierPartitionState = ObjectRef.create((Object)((MergedLog)log.elem).tierPartitionState());
        ((TierPartitionState)tierPartitionState.elem).setTopicId(topicIdPartition.topicId());
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        ((TierPartitionState)tierPartitionState.elem).onCatchUpComplete();
        int epoch = 0;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$95.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$95.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$95.elem;
                MemoryRecords x$41 = MODULE$.createRecords(segment, message, timestamp);
                AppendOrigin x$43 = qual$1.appendAsLeader$default$3();
                MetadataVersion x$44 = qual$1.appendAsLeader$default$4();
                RequestLocal x$45 = qual$1.appendAsLeader$default$5();
                VerificationGuard x$46 = qual$1.appendAsLeader$default$6();
                qual$1.appendAsLeader(x$41, 0, x$43, x$44, x$45, x$46);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        ((TierPartitionState)tierPartitionState.elem).append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Iterable segmentsToTier = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(((MergedLog)log.elem).localLogSegments()).asScala().take(numTieredSegments + numOverlap);
        segmentsToTier.foreach((Function1 & Serializable)segment -> {
            MergedLogTest$.$anonfun$createLogWithOverlap$2(tierPartitionState, topicIdPartition, epoch, segment);
            return BoxedUnit.UNIT;
        });
        Iterable localSegmentsToDelete = (Iterable)segmentsToTier.take(numTieredSegments);
        if (localSegmentsToDelete.nonEmpty()) {
            MergedLog qual$2 = (MergedLog)log.elem;
            Some x$47 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
            Function0 & Serializable x$48 = (Function0 & Serializable)() -> None$.MODULE$;
            HotsetRetention$ x$50 = HotsetRetention$.MODULE$;
            Function1 x$51 = qual$2.deleteOldSegments$default$5();
            SegmentDeletionStats x$52 = qual$2.deleteOldSegments$default$6();
            qual$2.deleteOldSegments((Option)x$47, (Function0)x$48, Integer.MAX_VALUE, (RetentionType)x$50, x$51, x$52);
        }
        ((MergedLog)log.elem).close();
        ProducerStateManagerConfig x$61 = new ProducerStateManagerConfig(maxProducerIdExpirationMs, false);
        LogDirFailureChannel x$65 = new LogDirFailureChannel(10);
        LogOffsetsListener x$66 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$67 = true;
        None$ x$68 = None$.MODULE$;
        boolean x$69 = true;
        ConcurrentHashMap<String, Object> x$70 = new ConcurrentHashMap<String, Object>();
        log.elem = LogTestUtils$.MODULE$.createLog(dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, x$61, producerIdExpirationCheckIntervalMs, tierLogComponents, x$65, x$66, x$67, (Option<Uuid>)x$68, x$69, x$70, checksumParams);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        tierPartitionState.elem = ((MergedLog)log.elem).tierPartitionState();
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((int)(numTieredSegments + numOverlap), (int)CollectionConverters$.MODULE$.IteratorHasAsScala(((TierPartitionState)tierPartitionState.elem).segments()).asScala().size());
        Tuple2 tuple2 = ((MergedLog)log.elem).uniqueLogSegments();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Iterator tierLogSegments = (Iterator)tuple2._1();
        Iterable localLogSegments = (Iterable)tuple2._2();
        Assertions.assertEquals((int)numTieredSegments, (int)tierLogSegments.size());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)localLogSegments.size());
        return (MergedLog)log.elem;
    }

    public long createLogWithOverlap$default$11() {
        return 0L;
    }

    public long createLogWithOverlap$default$12() {
        return 0L;
    }

    public int createLogWithOverlap$default$13() {
        return 300000;
    }

    public int createLogWithOverlap$default$14() {
        return 3600000;
    }

    public int createLogWithOverlap$default$15() {
        return 600000;
    }

    public Function0<Object> createLogWithOverlap$default$16() {
        return (JFunction0.mcJ.sp & Serializable)() -> -1L;
    }

    public Tuple2<MergedLog, Iterable<LogSegment>> createLogWithMissingTierState(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk, ChecksumParams checksumParams) {
        int x$3 = logConfig.segmentSize;
        long x$4 = logConfig.segmentMs;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -2L;
        long x$9 = 0L;
        String x$10 = "delete";
        int x$11 = 0x10000C;
        int x$12 = 4096;
        int x$13 = 0xA00000;
        String x$14 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$15 = 60000L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, x$6, x$7, 1L, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, true, 1L, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        ProducerStateManagerConfig x$31 = new ProducerStateManagerConfig(maxProducerIdExpirationMs, false);
        LogDirFailureChannel x$35 = new LogDirFailureChannel(10);
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$37 = true;
        None$ x$38 = None$.MODULE$;
        boolean x$39 = true;
        ConcurrentHashMap<String, Object> x$40 = new ConcurrentHashMap<String, Object>();
        ObjectRef log = ObjectRef.create((Object)LogTestUtils$.MODULE$.createLog(dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, x$31, producerIdExpirationCheckIntervalMs, tierLogComponents, x$35, x$36, x$37, (Option<Uuid>)x$38, x$39, x$40, checksumParams));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$96.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$96.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$96.elem;
                MemoryRecords x$41 = MODULE$.createRecords(segment, message, timestamp);
                AppendOrigin x$43 = qual$1.appendAsLeader$default$3();
                MetadataVersion x$44 = qual$1.appendAsLeader$default$4();
                RequestLocal x$45 = qual$1.appendAsLeader$default$5();
                VerificationGuard x$46 = qual$1.appendAsLeader$default$6();
                qual$1.appendAsLeader(x$41, 0, x$43, x$44, x$45, x$46);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Iterable localSegmentsToDelete = (Iterable)((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(((MergedLog)log.elem).localLogSegments()).asScala().take(numTieredSegments + numOverlap)).take(numTieredSegments);
        Iterable retTierSegments = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(((MergedLog)log.elem).localLogSegments()).asScala().take(numTieredSegments + numOverlap);
        MergedLog qual$2 = (MergedLog)log.elem;
        Some x$47 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
        Function0 & Serializable x$48 = (Function0 & Serializable)() -> None$.MODULE$;
        HotsetRetention$ x$50 = HotsetRetention$.MODULE$;
        Function1 x$51 = qual$2.deleteOldSegments$default$5();
        SegmentDeletionStats x$52 = qual$2.deleteOldSegments$default$6();
        qual$2.deleteOldSegments((Option)x$47, (Function0)x$48, Integer.MAX_VALUE, (RetentionType)x$50, x$51, x$52);
        ((MergedLog)log.elem).close();
        ProducerStateManagerConfig x$61 = new ProducerStateManagerConfig(maxProducerIdExpirationMs, false);
        LogDirFailureChannel x$65 = new LogDirFailureChannel(10);
        LogOffsetsListener x$66 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$67 = true;
        None$ x$68 = None$.MODULE$;
        boolean x$69 = true;
        ConcurrentHashMap<String, Object> x$70 = new ConcurrentHashMap<String, Object>();
        log.elem = LogTestUtils$.MODULE$.createLog(dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, x$61, producerIdExpirationCheckIntervalMs, tierLogComponents, x$65, x$66, x$67, (Option<Uuid>)x$68, x$69, x$70, checksumParams);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        return new Tuple2((Object)((MergedLog)log.elem), (Object)retTierSegments);
    }

    public long createLogWithMissingTierState$default$11() {
        return 0L;
    }

    public long createLogWithMissingTierState$default$12() {
        return 0L;
    }

    public int createLogWithMissingTierState$default$13() {
        return 300000;
    }

    public int createLogWithMissingTierState$default$14() {
        return 3600000;
    }

    public int createLogWithMissingTierState$default$15() {
        return 600000;
    }

    public Function0<Object> createLogWithMissingTierState$default$16() {
        return (JFunction0.mcJ.sp & Serializable)() -> -1L;
    }

    public void kafka$log$MergedLogTest$$deleteOldLogSegments(MergedLog log, int expectedNumDeleted) {
        int maxNumSegmentsToDeletePerRun = 1;
        IntRef numDeleted = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), expectedNumDeleted).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            numDeleted$1.elem += log.deleteOldSegments(maxNumSegmentsToDeletePerRun);
            Assertions.assertEquals((int)i, (int)numDeleted$1.elem);
        });
        Assertions.assertEquals((int)expectedNumDeleted, (int)numDeleted.elem);
        Assertions.assertEquals((int)0, (int)log.deleteOldSegments());
    }

    public static final /* synthetic */ void $anonfun$allRecords$1(ListBuffer recordsFound$1, LogSegment logSegment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().foreach((Function1 & Serializable)batch -> (ListBuffer)recordsFound$1.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IteratorHasAsScala(batch.iterator()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$createLogWithOverlap$2(ObjectRef tierPartitionState$18, TopicIdPartition topicIdPartition$1, int epoch$14, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata((TierPartitionState)tierPartitionState$18.elem, topicIdPartition$1, epoch$14, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, false, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ((TierPartitionState)tierPartitionState$18.elem).flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    private MergedLogTest$() {
    }
}

