/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0003\t\u0005\"C$\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011\u001dA\u0005A1A\u0005\u0002%Ca!\u0014\u0001!\u0002\u0013Q\u0005b\u0002(\u0001\u0005\u0004%\ta\u0014\u0005\u0007'\u0002\u0001\u000b\u0011\u0002)\t\u000fQ\u0003!\u0019!C\u0001+\"1!\r\u0001Q\u0001\nYCqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\u0006m\u0002!\tA\u001b\u0005\u0006w\u0002!\tA\u001b\u0005\u0007\u0003\u0003\u0001A\u0011\u00016\t\r\u0005\u0015\u0001\u0001\"\u0001k\u0011\u0019\tI\u0001\u0001C\u0001U\"1\u0011Q\u0002\u0001\u0005\u0002)Da!!\u0005\u0001\t\u0003Q\u0007BBA\u000b\u0001\u0011\u0005!\u000e\u0003\u0004\u0002\u001a\u0001!\tA\u001b\u0005\u0007\u0003;\u0001A\u0011\u00016\t\r\u0005\u0005\u0002\u0001\"\u0001k\u0011\u0019\t)\u0003\u0001C\u0001U\"1\u0011\u0011\u0006\u0001\u0005\u0002)Dq!!\f\u0001\t\u0003\ty\u0003\u0003\u0004\u0002t\u0001!\tA\u001b\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\ty\t\u0001C\u0001\u0003#\u0013qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003C\t\n1\u0001\\8h\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001!\u0003\rIG\r_\u000b\u0002eA\u00111GP\u0007\u0002i)\u0011\u0011%\u000e\u0006\u0003m]\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005aJ\u0014aB:u_J\fw-\u001a\u0006\u0003GiR!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO&\u0011q\b\u000e\u0002\f\u001f\u001a47/\u001a;J]\u0012,\u00070A\u0004jIb|F%Z9\u0015\u0005\t+\u0005CA\u0014D\u0013\t!\u0005F\u0001\u0003V]&$\bb\u0002$\u0004\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0014\u0001B5eq\u0002\n!\"\\1y\u000b:$(/[3t+\u0005Q\u0005CA\u0014L\u0013\ta\u0005FA\u0002J]R\f1\"\\1y\u000b:$(/[3tA\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003A\u0003\"aJ)\n\u0005IC#\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005i1\r[3dWN,Xn\u0015;pe\u0016,\u0012A\u0016\t\u0003/\u0002l\u0011\u0001\u0017\u0006\u00033j\u000b\u0001b\u00195fG.\u001cX/\u001c\u0006\u0003qmS!a\t/\u000b\u0005us\u0016!C2p]\u001adW/\u001a8u\u0015\u0005y\u0016AA5p\u0013\t\t\u0007L\u0001\tFe\u0015\u001b\u0005.Z2lgVl7\u000b^8sK\u0006q1\r[3dWN,Xn\u0015;pe\u0016\u0004\u0013AD2iK\u000e\\7/^7QCJ\fWn]\u000b\u0002KB\u0011qKZ\u0005\u0003Ob\u0013ab\u00115fG.\u001cX/\u001c)be\u0006l7/A\bdQ\u0016\u001c7n];n!\u0006\u0014\u0018-\\:!\u0003\u0015\u0019X\r^;q)\u0005\u0011\u0005FA\u0007m!\tiG/D\u0001o\u0015\ty\u0007/A\u0002ba&T!!\u001d:\u0002\u000f),\b/\u001b;fe*\u00111\u000fP\u0001\u0006UVt\u0017\u000e^\u0005\u0003k:\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007F\u0001\by!\ti\u00170\u0003\u0002{]\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011e\u0006tGm\\7M_>\\W\u000f\u001d+fgRD#aD?\u0011\u00055t\u0018BA@o\u0005\u0011!Vm\u001d;\u0002%1|wn[;q\u000bb$(/Z7f\u0007\u0006\u001cXm\u001d\u0015\u0003!u\f\u0011\u0002^3ti\u0016sGO]=)\u0005Ei\u0018!\u0005;fgR,e\u000e\u001e:z\u001fZ,'O\u001a7po\"\u0012!#`\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u0005Mi\u0018\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\t!R0A\ruKN$h)\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$\bFA\u000b~\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003-u\f1\u0005^3tiJ+w\u000e]3o\r\u0006LGn\u00165f]\u001aKG.Z!me\u0016\fG-_#ySN$8\u000f\u000b\u0002\u0018{\u0006AAO];oG\u0006$X\r\u000b\u0002\u0019{\u0006qam\u001c:dKVsW.\u00199UKN$\bFA\r~\u0003\u0015\"Xm\u001d;TC:LG/\u001f'bgR|eMZ:fi\u0016\u000bX/\u00197U_\n\u000b7/Z(gMN,G\u000f\u000b\u0002\u001b{\u0006\u0001\u0012m]:feR<&/\u001b;f\r\u0006LGn]\u000b\u0005\u0003c\t\t\u0007F\u0005C\u0003g\ti%a\u0014\u0002T!9\u0011QG\u000eA\u0002\u0005]\u0012aB7fgN\fw-\u001a\t\u0005\u0003s\t9E\u0004\u0003\u0002<\u0005\r\u0003cAA\u001fQ5\u0011\u0011q\b\u0006\u0004\u0003\u0003\"\u0013A\u0002\u001fs_>$h(C\u0002\u0002F!\na\u0001\u0015:fI\u00164\u0017\u0002BA%\u0003\u0017\u0012aa\u0015;sS:<'bAA#Q!)\u0001g\u0007a\u0001e!1\u0011\u0011K\u000eA\u0002)\u000baa\u001c4gg\u0016$\bbBA+7\u0001\u0007\u0011qK\u0001\u0006W2\f7o\u001d\t\u0007\u0003s\tI&!\u0018\n\t\u0005m\u00131\n\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003?\n\t\u0007\u0004\u0001\u0005\u000f\u0005\r4D1\u0001\u0002f\t\tA+\u0005\u0003\u0002h\u00055\u0004cA\u0014\u0002j%\u0019\u00111\u000e\u0015\u0003\u000f9{G\u000f[5oOB\u0019q%a\u001c\n\u0007\u0005E\u0004FA\u0002B]f\f1\u0004^3ti\u000eCWmY6tk6,\u0006\u000fZ1uK\u0012|e.\u00119qK:$\u0007F\u0001\u000f~\u00031iwN\\8u_:L7mU3r)\u0019\tY(a\"\u0002\fB)\u0011QPAB\u00156\u0011\u0011q\u0010\u0006\u0004\u0003\u0003C\u0013AC2pY2,7\r^5p]&!\u0011QQA@\u0005\r\u0019V-\u001d\u0005\u0007\u0003\u0013k\u0002\u0019\u0001&\u0002\t\t\f7/\u001a\u0005\u0007\u0003\u001bk\u0002\u0019\u0001&\u0002\u00071,g.A\no_:,\u00050[:uK:$H+Z7q\r&dW\r\u0006\u0002\u0002\u0014B!\u0011QSAO\u001b\t\t9JC\u0002`\u00033S!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b9J\u0001\u0003GS2,\u0007")
public class OffsetIndexTest {
    private OffsetIndex idx;
    private final int maxEntries;
    private final long baseOffset;
    private final E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
    private final ChecksumParams checksumParams = new ChecksumParams(Optional.of(this.checksumStore()), true, true);

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, this.checksumParams()));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    @Test
    public void randomLookupTest() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L), (String)"Not present value should return physical offset 0.");
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableOps)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable)x$2 -> x$2)).zip(this.monotonicSeq(0, size));
        vals.foreach((Function1 & Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetIndexTest.$anonfun$randomLookupTest$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$3);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = (TreeMap)new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((IterableOnce)vals.map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p)));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList(new long[][]{offsets}));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.longArrayOps(offsets), 30)), (Function1)(JFunction1.mcVJ.sp & Serializable)offset -> Assertions.assertEquals((Object)(offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._1$mcJ$sp(), ((Tuple2)((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._2())._2$mcI$sp())), (Object)this.idx().lookup(offset), (String)"The index should give the same answer as the sorted map"));
    }

    @Test
    public void lookupExtremeCases() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()), (String)"Lookup on empty file");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)i + 1L, i), (Object)this.idx().entry(i)));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().append(50L, 1));
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assertions.assertEquals(Optional.of(fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset, first.position);
        this.idx().append(sec.offset, sec.position);
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true, true, this.checksumParams());
        Assertions.assertEquals((Object)first, (Object)idxRo.lookup(first.offset));
        Assertions.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset));
        Assertions.assertEquals((long)sec.offset, (long)idxRo.lastOffset());
        Assertions.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        OffsetPosition entry = new OffsetPosition(51L, 0);
        this.idx().append(entry.offset, entry.position);
        this.idx().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new OffsetIndex(this.idx().file(), this.idx().baseOffset(), this.checksumParams()));
        this.idx_$eq(new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true, true, this.checksumParams()));
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, this.checksumParams());
        idx.truncate();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate past the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate at the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assertions.assertEquals((Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L), (String)"Index should truncate off last entry");
        Assertions.assertEquals((long)8L, (long)idx.lastOffset(), (String)"8 should be the last entry in the index");
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assertions.assertEquals((Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L), (String)"4 should be the last entry in the index");
        Assertions.assertEquals((long)4L, (long)idx.lastOffset(), (String)"4 should be the last entry in the index");
        idx.append(5L, 5);
        idx.truncate();
        Assertions.assertEquals((int)0, (int)idx.entries(), (String)"Full truncation should leave no entries");
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, this.checksumParams());
        idx.forceUnmap();
        Assertions.assertThrows(NullPointerException.class, () -> idx.lookup(1L));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, this.checksumParams());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> idx.append((long)offset, 1), () -> message);
        Assertions.assertEquals(klass, e.getClass(), (String)"Got an unexpected exception.");
    }

    @Test
    public void testChecksumUpdatedOnAppend() {
        ChecksumStore store = this.checksumStore().store();
        store.initializeEntry(this.idx().file().getAbsolutePath());
        store.initializeEntry("expected");
        this.idx().append(1000L, 2000);
        store.update("expected", (int)(1000L - this.baseOffset()));
        store.update("expected", 2000);
        long expectedChecksum = ((ChecksumInfo)store.get("expected").get()).checksum().getValue();
        long actualChecksum = ((ChecksumInfo)store.get(this.idx().file().getAbsolutePath()).get()).checksum().getValue();
        Assertions.assertEquals((long)expectedChecksum, (long)actualChecksum);
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable)x$4 -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)x$4)));
        return vals;
    }

    public File nonExistentTempFile() {
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Files.delete(file.toPath());
        return file;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$randomLookupTest$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$3) {
        if (x$3 != null) {
            long logical = x$3._1$mcJ$sp();
            int physical = x$3._2$mcI$sp();
            Assertions.assertEquals((Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical), (String)"Should be able to find values that are present.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset, offsetPosition.position);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int x$4) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return (ArrayBuffer)vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

