/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005\u0002\u0005BQA\r\u0001\u0005\u0002\u0005BQ\u0001\u000e\u0001\u0005\u0002\u0005BQA\u000e\u0001\u0005\u0002\u0005BQ\u0001\u000f\u0001\u0005\u0002eBQA\u0012\u0001\u0005\u0002\u001dCqA\u0018\u0001\u0012\u0002\u0013\u0005q\fC\u0003k\u0001\u0011\u00051\u000eC\u0004q\u0001E\u0005I\u0011A0\b\u000bE\u0004\u0002\u0012\u0001:\u0007\u000b=\u0001\u0002\u0012A:\t\u000bqaA\u0011\u0001;\t\u000bUdA\u0011\u0001<\u0003\u001b=3gm]3u\u001b\u0006\u0004H+Z:u\u0015\t\t\"#A\u0002m_\u001eT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003A\t1\u0003^3ti\n\u000b7/[2WC2LG-\u0019;j_:$\u0012A\t\t\u0003/\rJ!\u0001\n\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0019\u0002\"a\n\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002,Y\u00059!.\u001e9ji\u0016\u0014(BA\u0017/\u0003\u0015QWO\\5u\u0015\u0005y\u0013aA8sO&\u0011\u0011\u0007\u000b\u0002\u0005)\u0016\u001cH/A\u0005uKN$8\t\\3be\"\u00121AJ\u0001\u0010i\u0016\u001cHoR3u/\",gNR;mY\"\u0012AAJ\u0001\u0016i\u0016\u001cH/\u0012=uK:$W\rZ(gMN,G/T1qQ\t)a%A\u0002lKf$\"A\u000f\"\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014a\u00018j_*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006q\u0019\u0001\ra\u0011\t\u0003/\u0011K!!\u0012\r\u0003\t1{gnZ\u0001\fm\u0006d\u0017\u000eZ1uK6\u000b\u0007\u000fF\u0002I)f\u0003\"!\u0013*\u000e\u0003)S!!E&\u000b\u00051k\u0015!C5oi\u0016\u0014h.\u00197t\u0015\tqu*A\u0004ti>\u0014\u0018mZ3\u000b\u0005M\u0001&BA)/\u0003\u0019\t\u0007/Y2iK&\u00111K\u0013\u0002\u0010'.LW\u000e]=PM\u001a\u001cX\r^'ba\")Qk\u0002a\u0001-\u0006)\u0011\u000e^3ngB\u0011qcV\u0005\u00031b\u00111!\u00138u\u0011\u001dQv\u0001%AA\u0002m\u000b!\u0002\\8bI\u001a\u000b7\r^8s!\t9B,\u0003\u0002^1\t1Ai\\;cY\u0016\fQC^1mS\u0012\fG/Z'ba\u0012\"WMZ1vYR$#'F\u0001aU\tY\u0016mK\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0005v]\u000eDWmY6fI*\u0011q\rG\u0001\u000bC:tw\u000e^1uS>t\u0017BA5e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014m\u0006d\u0017\u000eZ1uK\u0016CH/\u001a8eK\u0012l\u0015\r\u001d\u000b\u0005E1lw\u000eC\u0003V\u0013\u0001\u0007a\u000bC\u0003o\u0013\u0001\u0007a+\u0001\u0004nCb\\U-\u001f\u0005\b5&\u0001\n\u00111\u0001\\\u0003u1\u0018\r\\5eCR,W\t\u001f;f]\u0012,G-T1qI\u0011,g-Y;mi\u0012\u001a\u0014!D(gMN,G/T1q)\u0016\u001cH\u000f\u0005\u0002 \u0019M\u0011AB\u0006\u000b\u0002e\u0006!Q.Y5o)\t\u0011s\u000fC\u0003y\u001d\u0001\u0007\u00110\u0001\u0003be\u001e\u001c\bcA\f{y&\u00111\u0010\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004{\u0006%ab\u0001@\u0002\u0006A\u0011q\u0010G\u0007\u0003\u0003\u0003Q1!a\u0001\u0015\u0003\u0019a$o\\8u}%\u0019\u0011q\u0001\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9\u0001\u0007")
public class OffsetMapTest {
    public static void main(String[] args) {
        OffsetMapTest$.MODULE$.main(args);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096);
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assertions.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    @Test
    public void testExtendedOffsetMap() {
        this.validateExtendedMap(100, 100, this.validateExtendedMap$default$3());
        this.validateExtendedMap(10000, 200, this.validateExtendedMap$default$3());
        this.validateExtendedMap(10000, 5000, this.validateExtendedMap$default$3());
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(Long.toString(key).getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }

    public void validateExtendedMap(int items, int maxKey, double loadFactor) {
        Random rnd = new Random();
        HashMap truthMap = new HashMap();
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24));
        ExtendedOffsetMap extendedMap = new ExtendedOffsetMap((OffsetMap)map);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int intKey = rnd.nextInt(maxKey);
            boolean isTombstone = rnd.nextBoolean();
            truthMap.put((Object)BoxesRunTime.boxToInteger((int)intKey), (Object)new Tuple2.mcIZ.sp(i, isTombstone));
            extendedMap.put(this.key(intKey), (long)i, isTombstone);
        });
        Assertions.assertEquals((int)truthMap.size(), (int)extendedMap.size());
        Assertions.assertEquals((int)truthMap.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetMapTest.$anonfun$validateExtendedMap$2(x$1))), (int)extendedMap.tombstoneCount());
        truthMap.foreach((Function1 & Serializable)entry -> {
            OffsetMapTest.$anonfun$validateExtendedMap$3(this, extendedMap, entry);
            return BoxedUnit.UNIT;
        });
    }

    public double validateExtendedMap$default$3() {
        return 0.5;
    }

    public static final /* synthetic */ boolean $anonfun$validateExtendedMap$2(Tuple2 x$1) {
        return ((Tuple2)x$1._2())._2$mcZ$sp();
    }

    public static final /* synthetic */ void $anonfun$validateExtendedMap$3(OffsetMapTest $this, ExtendedOffsetMap extendedMap$1, Tuple2 entry) {
        Assertions.assertEquals((long)((Tuple2)entry._2())._1$mcI$sp(), (long)extendedMap$1.get($this.key(entry._1$mcI$sp())));
    }
}

